<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use App\Http\Controllers\Customer_account_update;
use App\Models\Income_model;
class Accounting extends Controller
{
    public function select_bank_accounting()
    {
        $data['data_bank'] = DB::table('erp_bank_account')
            ->select('*')
            ->where('status', 'Enable')
            ->orderBy('order_bank', 'ASC')
            ->get();
        $arr_bank_jpy = array();
        $arr_bank_usd = array();
        $arr_balance = array();
        foreach ($data['data_bank'] as $val) {
            $bank_acc_id = $val->bank_account_id;
            if ($bank_acc_id != 12) {
                if ($bank_acc_id != 13) {
                    $arr_bank = DB::table('erp_deposit_income As a')
                        ->select(DB::raw("SUM(deposit_after_bankcharge) AS income,deposit_currency AS currency"))
                        ->where('a.bank_account_id', '=', $bank_acc_id)
                        ->unionAll(
                            DB::table('erp_deposit_expense  As a')
                                ->select("SUM(deposit_raw) AS income, currency_type AS currency")
                                ->select(DB::raw("SUM(deposit_raw) AS income, currency_type AS currency"))
                                ->where('a.bank_account_id', '=', $bank_acc_id)
                        )->get();
                    $arr_balance = @$arr_bank[0]->income - @$arr_bank[1]->income;

                    if (@$arr_bank[0]->currency == "JPY") {
                        $arr_bank_jpy[$bank_acc_id] = "<span style='font-weight: bold;'>" . $val->bank_name . " : </span><span style='font-weight: bold;color:red;'> " . number_format($arr_balance) . " " . @$arr_bank[0]->currency . "</span><br>";
                    } else {
                        $arr_bank_usd[$bank_acc_id] = "<span style='font-weight: bold;'>" . $val->bank_name . " : </span><span style='font-weight: bold;color:red;'> " . number_format($arr_balance, 2) . " " . @$arr_bank[0]->currency . "</span><br>";
                    }
                }
            }
        }
        $data['arr_bank_jpy'] = $arr_bank_jpy;
        $data['arr_bank_usd'] = $arr_bank_usd;

        return response()->json([
            $data
        ], 200);
    }

    public function insert_deposit_expense(Request $request)
    {
        $savedata = $request->get('savedata');
        $user = Auth::user();
        foreach (json_decode($savedata) as $val) {
            $deposit_date = $val->expense_deposit_date;
            $bank_name = $val->expense_bank_name;
            $deposit_amount = $val->expense_deposit_amount;
            $currency = $val->expense_currency;
            $description = $val->expense_description;
            $data = array(
                'created_dt' => $deposit_date . " " . date(format: 'H:i:s'),
                'bank_account_id' => $bank_name,
                'deposit' => $deposit_amount,
                'deposit_raw' => $deposit_amount,
                'currency_type' => $currency,
                'description' => $description,
                'staff_id' => $user->staff_id
            );
          
            DB::table('erp_deposit_expense')
                ->insert($data);
        }
    }
    public function insert_bank_accounting(Request $request)
    {
        $dataInsert = $request->get('dataInsert');
        foreach (json_decode($dataInsert) as $val) {
            $bank_short_name = $val->b_short_name;
            $bank_full_name = $val->b_full_name;
            $bank_swift_code = $val->b_swift_code;
            $bank_account_number = $val->b_account_number;
            $bank_brand_name = $val->b_brand_name;
            $bank_address = $val->b_address;
            $status = $val->b_status;
            $data = array(
                'bank_name' => $bank_short_name,
                'bank_full_name' => $bank_full_name,
                'swift_code' => $bank_swift_code,
                'account_number' => $bank_account_number,
                'branch_name' => $bank_brand_name,
                'address' => $bank_address,
                'status' => $status
            );

            DB::table('erp_bank_account')
                ->insert($data);
        }
    }
    public function get_acc_list(Request $request)
    {
        $search = $request->get('search_data');
        $where1 = '';
        $where2 = '';

        foreach (json_decode($search) as $item) {

            if ($item->Search_date_start <> '') {
                if ($item->Search_bank_name <> "") {
                    $where1 = "date(deposit_date) >= '$item->Search_date_start' AND date(deposit_date) <= '$item->Search_date_ends'";
                    $where2 = "date(created_dt) >= '$item->Search_date_start' AND date(created_dt) <= '$item->Search_date_ends'";
                }
            }
            if ($item->Search_bank_name <> "") {
                if (!empty($where1)) {
                    $where1 .= " AND a.bank_account_id='$item->Search_bank_name'";
                } else {
                    $where1 = " a.bank_account_id='$item->Search_bank_name'";
                }

                if (!empty($where2)) {
                    $where2 .= " AND a.bank_account_id='$item->Search_bank_name'";
                } else {
                    $where2 = "a.bank_account_id='$item->Search_bank_name'";
                }
            }

            if ($item->Search_date_start != "") {
                $item->Search_date_start;
            }

            if ($item->Search_date_ends != "") {
                $item->Search_date_ends;
            }
        }

        $data['account_list'] = DB::table('erp_deposit_income As a')
            ->select(DB::raw("deposit_after_bankcharge AS deposit_after_BC,deposit_income_id AS acc_id,deposit_date AS date,description AS description,deposit_raw AS income,bank_name AS bank_name,IF(deposit_raw>0,0,0) AS expense,after_bankcharge_currency AS currency,deposit_currency AS dep_currency,a.bank_account_id"))
            ->whereRaw(DB::raw($where1))
            ->join('erp_bank_account As b', 'b.bank_account_id', '=', 'a.bank_account_id')
            ->union(
                DB::table('erp_deposit_expense As a')
                    ->select(DB::raw("0 AS deposit_after_BC,deposit_expense_id AS acc_id,created_dt AS date,description AS description,IF(deposit_raw>0,0,0) AS income,bank_name AS bank_name,deposit_raw AS expense,currency_type AS currency,NUll AS dep_currency,a.bank_account_id"))
                    ->join('erp_bank_account As b', 'b.bank_account_id', '=', 'a.bank_account_id')
                    ->whereRaw(DB::raw($where2))
                    ->orderBy('date', 'ASC')
            )->get();
        // dd( $data['account_list'] );

        $date_minus = date('Y-m-d', strtotime($item->Search_date_start . ' -1 day'));
        $select_dep_info = $this->select_account_balance($item->Search_bank_name, $date_minus);
        $total_balance = 0;
        foreach ($select_dep_info as $val) {
            if ($val->income > 0) {
                $total_balance += $val->deposit_after_BC;
            } else {
                $total_balance -= $val->expense;
            }
        }

        $total_income = 0;
        $totel_expense = 0;
        $total_amount = 0;
        $total_amount_after_bankcharge = 0;
        $deposit_am_expense = array();
        $deposit_am_income = array();
        $deposit_am_income_bc = array();
        $balance_am = array();
        $deposit_total_ex = array();
        $deposit_total_in = array();
        $deposit_total_in_bc = array();
        $total_amount = $total_balance + 0;
        $total_balance = 0;
        $total_income = 0;
        $totel_expense = 0;

        foreach ($data['account_list'] as $val => $rows) {

            $acc_id = $rows->acc_id;
            if ($rows->income > 0) {
                $total_income += $rows->income;
                $total_amount += $rows->deposit_after_BC;
                $total_amount_after_bankcharge += $rows->deposit_after_BC;
            } else {
                $totel_expense += $rows->expense;
                $total_amount -= $rows->expense;
            }
            // expence
            $am_expense = number_format($rows->expense, 2);
            $deposit_am_expense[$acc_id] = str_replace('.00', '', $am_expense . ' ' . $rows->currency);

            // income
            $am_income = number_format($rows->income, 2);
            $deposit_am_income[$acc_id] = str_replace('.00', '', $am_income . ' ' . $rows->currency);

            // deposit bc
            $am_income_bc = number_format($rows->deposit_after_BC, 2);
            $deposit_am_income_bc[$acc_id] = str_replace('.00', '', $am_income_bc . ' ' . $rows->currency);

            //balance
            $am_balance = number_format($total_amount, 2);
            $balance_am[$acc_id] = str_replace('.00', '', $am_balance . ' ' . $rows->currency);

            // total expence
            $am_total_ex = number_format($totel_expense, 2);
            $deposit_total_ex = str_replace('.00', '', $am_total_ex . ' ' . $rows->currency);

            // total income
            $am_total_in = number_format($total_income, 2);
            $deposit_total_in = str_replace('.00', '', $am_total_in . ' ' . $rows->currency);

            // total_in_bc 
            $am_total_in_bc = number_format($total_amount_after_bankcharge, 2);
            $deposit_total_in_bc = str_replace('.00', '', $am_total_in_bc . ' ' . $rows->currency);
        }

        $data['deposit_am_expense'] = $deposit_am_expense;
        $data['deposit_am_income'] = $deposit_am_income;
        $data['deposit_am_income_bc'] = $deposit_am_income_bc;
        $data['balance_am'] = $balance_am;
        $data['deposit_total_ex'] = $deposit_total_ex;
        $data['deposit_total_in'] = $deposit_total_in;
        $data['deposit_total_in_bc'] = $deposit_total_in_bc;

        return response()->json([
            $data
        ], status: 200);
    }
    public function modify_deposit_expense(Request $request)
    {
        $modify_deposit_expense = $request->get('modify_deposit_expense');
        $user = Auth::user();
        foreach (json_decode($modify_deposit_expense) as $item) {
            $acc_id = $item->acc_id;
            $deposit_date_edit = $item->deposit_date_edit;
            $bank_name_edit = $item->bank_name_edit;
            $deposit_amount_edit = $item->deposit_amount_edit;
            $currency_edit = $item->currency_edit;
            $description_edit = $item->description_edit;

            $data = array(
                'created_dt' => $deposit_date_edit,
                'bank_account_id' => $bank_name_edit,
                'deposit' => $deposit_amount_edit,
                'deposit_raw' => $deposit_amount_edit,
                'currency_type' => $currency_edit,
                'description' => $description_edit,
                'staff_id' => $user->staff_id
            );
            DB::table('erp_deposit_expense')
                ->where('deposit_expense_id', '=', $acc_id)
                ->update($data);
        }
    }
    public function select_count_deposit_expense($acc_id)
    {
        $data = DB::table('erp_deposit_expense')
            ->select('*')
            ->where('deposit_expense_id', '=', $acc_id)
            ->get();

        return $data;
    }

    public function delete_deposit_expense(Request $request)
    {
        $deposit_ex_delete = $request->get('deposit_ex_delete');
        // dd($deposit_ex_delete );
        foreach (json_decode($deposit_ex_delete) as $item) {
            $deposit_expense_ids = $item->Acc_id;
            $deposit_expence = $item->deposit_amount_delete;

            if ($deposit_expence == '0.00' || $deposit_expence == '') {
                $cus_dep_info = $this->get_cus_deposit_info($deposit_expense_ids);

                if (count($cus_dep_info) > 0) {
                    foreach ($cus_dep_info as $cus_dep) {
                        $cus_dep_id = $cus_dep->customer_deposit_id;
                        DB::table('erp_carpayments')
                            ->where('customer_deposit_id', $cus_dep_id)
                            ->delete();
                        // delete from customer deposit
                        $cus_ids = $this->get_customer_id_by_dep_id($cus_dep_id);
                        Customer_account_update::update_customer_remain($cus_ids);
                        DB::table('erp_customer_deposit')
                            ->where('customer_deposit_id', $cus_dep_id)
                            ->delete();
                    }
                }
                DB::table('erp_deposit_income')
                    ->where('deposit_income_id', $deposit_expense_ids)
                    ->delete();
            } else {
                $get_car_division = $this->get_car_division($deposit_expense_ids);

                if (count($get_car_division) > 0) {
                    foreach ($get_car_division as $val) {
                        $division_id = $val->expenses_division_id;
                        $get_car_expense = $this->get_car_expense($division_id);
                        if ($get_car_expense->num_rows() > 0) {
                            foreach ($get_car_expense->result() as $row) {
                                $expens_id = $row->car_expense_id;
                                DB::table('erp_car_expenses_other_fee')
                                    ->where('car_expense_id', $expens_id)
                                    ->delete();

                                DB::table('erp_car_expenses_other_refund')
                                    ->where('car_expense_id', $expens_id)
                                    ->delete();
                            }
                        }
                        DB::table('erp_car_expenses')
                            ->where('expenses_division_id', $division_id)
                            ->delete();

                        DB::table('erp_carpayments')
                            ->where('expenses_division_id', $division_id)
                            ->delete();
                    }

                }

                DB::table('erp_expenses_division')
                    ->where('deposit_expense_id', $deposit_expense_ids)
                    ->delete();

                DB::table('erp_deposit_expense')
                    ->where('deposit_expense_id', $deposit_expense_ids)
                    ->delete();
            }
        }
    }
    public function get_car_division($deposit_expense_ids)
    {
        $data = DB::table('erp_expenses_division As a')
            ->select('*')
            ->leftjoin('erp_deposit_expense AS b', 'b.deposit_expense_id', '=', 'a.deposit_expense_id')
            ->where('a.deposit_expense_id', '=', $deposit_expense_ids)
            ->get();

        return $data;
    }
    public function get_car_expense($division_id)
    {
        $data = DB::table('erp_car_expenses')
            ->select('*')
            ->where('expenses_division_id', '=', $division_id)
            ->toRgetawSql();
        return $data;
    }
    public function insert_deposit_income(Request $request)
    {
        $file_data = $request->file('userfile');
        // dd($file_data);
        $income_date = $request->get('deposit_date_income');
        $income_bank_name = $request->get('income_bank_name');
        $income_sender = $request->get('income_sender');
        $income_deposit = $request->get('income_deposit');
        $deposit_after_bankcharge = $request->get('deposit_after_bankcharge');
        $description_income = $request->get('description_income');
        $income_currency = $request->get('income_currency');
        $after_currency = $request->get('after_currency');
        $deposit_tt_att = "";
        if (empty($file_data)) {
            $data = array(
                'deposit_date' => $income_date,
                'bank_account_id' => $income_bank_name,
                'description' => $income_sender,
                'deposit_amount' => $income_deposit,
                'deposit_after_bankcharge' => $deposit_after_bankcharge,
                'deposit_raw' => $income_deposit,
                'deposit_currency' => $income_currency,
                'after_bankcharge_currency' => $after_currency,
                'deposit_desc' => $description_income,

            );
            DB::table('erp_deposit_income')
                ->insert($data);
        }
        if ($request->hasFile('userfile')) {
            $ext = explode('.', $file_data->getClientOriginalName());
            $ext = end($ext);
            $ext = strtolower($ext);
            $fname_compress = date('Ymd_His') . '_' . mt_rand('0000000', '9999999') . '.' . $ext;
            $fileName = $fname_compress;
            $deposit_tt_att = '/upload/pdf_files/' . $fileName;
            $data = array(
                'deposit_date' => $income_date,
                'bank_account_id' => $income_bank_name,
                'description' => $income_sender,
                'deposit_amount' => $income_deposit,
                'deposit_after_bankcharge' => $deposit_after_bankcharge,
                'deposit_raw' => $income_deposit,
                'deposit_currency' => $income_currency,
                'after_bankcharge_currency' => $after_currency,
                'deposit_desc' => $description_income,
                'deposit_tt_att' => $deposit_tt_att

            );
            DB::table('erp_deposit_income')
                ->insert($data);
        }

    }

    function get_customer_id_by_dep_id($cus_dep_id)
    {
        $dep_info = Income_model::get_customer_id_by_dep_ids($cus_dep_id);
        $cus_id = '';
        if (count($dep_info) > 0) {
            foreach ($dep_info as $val) {
                $cus_id = $val->customer_id;
            }
        }

        return $cus_id;

    }
    public function modify_deposit_income(Request $request)
    {
        $modify_deposit_income = $request->get('modify_deposit_income');

        foreach (json_decode($modify_deposit_income) as $item) {
            $acc_id = $item->acc_id;
            $edit_income_date = $item->edit_income_date;
            $edit_income_deposit = $item->edit_income_deposit;
            $edit_deposit_after_bankcharge = $item->edit_deposit_after_bankcharge;
            $edit_description_income = $item->edit_description_income;
            $edit_income_currency = $item->edit_income_currency;
            $edit_after_currency = $item->edit_after_currency;
            $edit_income_sender = $item->edit_income_sender;
            $edit_income_bank_name = $item->edit_income_bank_name;

            $data = array(
                'deposit_date' => $edit_income_date,
                'bank_account_id' => $edit_income_bank_name,
                'description' => $edit_income_sender,
                'deposit_amount' => $edit_income_deposit,
                'deposit_after_bankcharge' => $edit_deposit_after_bankcharge,
                'deposit_raw' => $edit_income_deposit,
                'deposit_currency' => $edit_income_currency,
                'after_bankcharge_currency' => $edit_after_currency,
                'deposit_desc' => $edit_description_income,
            );

            DB::table('erp_deposit_income')
                ->where('deposit_income_id', '=', $acc_id)
                ->update($data);
        }
    }

    public function get_cus_deposit_info($deposit_expense_ids)
    {
        $data = DB::table('erp_customer_deposit')
            ->select('*')
            ->where('deposit_income_id', '=', $deposit_expense_ids)
            ->get();

        return $data;
    }


    public function excel_export_account(Request $request)
    {
        $search = $request->get('search_data');
        $objPHPExcel = new Spreadsheet();
        $objPHPExcel->getActiveSheet()->setTitle('Account');
        $objPHPExcel->setActiveSheetIndex(0);

        foreach (json_decode($search) as $item) {
            $stdate = $item->Search_date_start;
            $endate = $item->Search_date_ends;
            $bank = $item->Search_bank_name;

            if ($bank != "") {
                $bank;
            }
            if ($stdate != "") {
                $stdate;
            }
            if ($endate != "") {
                $endate;

            }
            $total_balance = 0;
            $date_minus = date('Y-m-d', strtotime($stdate . ' -1 day'));
            $select_dep_info = $this->select_account_balance($bank, $date_minus);
            foreach ($select_dep_info as $val) {
                if ($val->income > 0) {
                    $total_balance += $val->deposit_after_BC;
                } else {
                    $total_balance -= $val->expense;
                }
            }
            $accounting_data = $this->select_expense_deposit($bank, $stdate, $endate);
            $objPHPExcel->getActiveSheet()
                ->getStyle('A:H')
                ->getAlignment()
                ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER, );

            $styleArray = array(
                'font' => array(
                    'bold' => true,
                    'color' => array('rgb' => '4360F6'),
                    'size' => 12,
                    'name' => 'Verdana'
                )
            );
            $bold = array(
                'font' => array(
                    'bold' => true,
                    'size' => 10,
                    'name' => 'Verdana'
                )
            );
            $outline = array(
                'borders' => array(
                    'outline' => array(
                        'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                    )
                )
            );
            $BStyle = array(
                'borders' => array(
                    'allborders' => array(
                        'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                    )
                )
            );


            if (count($accounting_data) > 0) {
                $objPHPExcel->getActiveSheet()->getStyle('A1:H1')->applyFromArray($outline);
                $objPHPExcel->getActiveSheet()->freezePane('Z3');
                $objPHPExcel->getActiveSheet()->getStyle('A2:H2')->applyFromArray($bold);
                $objPHPExcel->getActiveSheet()->getStyle('E1')->applyFromArray($styleArray);

                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(7);
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(25);
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(30);
                $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(20);
                $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(30);
                $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
                $objPHPExcel->getActiveSheet()->setCellValue('E1', 'ACCOUNTING LIST')
                    ->setCellValue('A2', 'NO')
                    ->setCellValue('B2', 'DATE')
                    ->setCellValue('C2', 'BANK NAME')
                    ->setCellValue('D2', 'DESCRIPTION')
                    ->setCellValue('E2', 'EXPENSE')
                    ->setCellValue('F2', 'INCOME')
                    ->setCellValue('G2', 'DEPOSIT AFTER BANKCHARGE')
                    ->setCellValue('H2', 'BALLANCE');
                $i = 1;
                $no = 3;
                $total_amount_after_bankcharge = 0;
                $total_amount = $total_balance + 0;
                $total_income = 0;
                $total_expense = 0;
                foreach ($accounting_data as $rows) {
                    if ($rows->income > 0) {
                        $total_income += $rows->income;
                        $total_amount += $rows->deposit_after_BC;
                        $total_amount_after_bankcharge += $rows->deposit_after_BC;

                    } else {
                        $total_expense += $rows->expense;
                        $total_amount -= $rows->expense;

                    }

                    $objPHPExcel->getActiveSheet()->setCellValue('A' . $no, $i)
                        ->setCellValue('B' . $no, date('Y-m-d H:i:s A', strtotime($rows->date)))
                        ->setCellValue('C' . $no, $rows->bank_name)
                        ->setCellValue('D' . $no, $rows->description)
                        ->setCellValue('E' . $no, number_format($rows->expense) . ' ' . $rows->currency)
                        ->setCellValue('F' . $no, number_format($rows->income) . ' ' . $rows->dep_currency)
                        ->setCellValue('G' . $no, number_format($rows->deposit_after_BC) . ' ' . $rows->currency)
                        ->setCellValue('H' . $no, number_format($total_amount) . ' ' . $rows->currency);
                    $no++;
                    $i++;
                }
                $objPHPExcel->getActiveSheet()->getStyle('A2:H' . ($no - 1))->applyFromArray($BStyle);
                $objPHPExcel->getActiveSheet()->getStyle('D' . $no . ':G' . $no)->applyFromArray($BStyle);
                $objPHPExcel->getActiveSheet()->getStyle('D' . $no . ':G' . $no)->applyFromArray($bold);
                $objPHPExcel->getActiveSheet()->setCellValue('D' . $no, "TOTAL")
                    ->setCellValue('E' . $no, number_format($total_expense) . " " . @$rows->currency)
                    ->setCellValue('F' . $no, number_format($total_income) . " " . @$rows->currency)
                    ->setCellValue('G' . $no, number_format($total_amount_after_bankcharge) . " " . @$rows->currency);


            }

            $writer = new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

            // Redirect output to a client’s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="account.xls"');
            header('Cache-Control: max-age=0');
            // If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');
            // If you're serving to IE over SSL, then the following may be needed
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT'); // always modified
            header('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header('Pragma: public'); // HTTP/1.0
            return response()->json([
                $writer->save('php://output')
            ]);

        }

    }
    public function select_account_balance($bank, $date_minus)
    {
        $where1 = '';
        $where2 = '';

        $where1 .= " AND a.bank_account_id='$bank' AND date(deposit_date) <='$date_minus'";
        $where2 .= " AND a.bank_account_id='$bank' AND date(created_dt) <='$date_minus'";

        $sql = "SELECT deposit_after_bankcharge AS deposit_after_BC, deposit_income_id AS acc_id,deposit_date AS date,description AS description,deposit_raw AS income,bank_name AS bank_name,IF(deposit_raw>0,0,0) AS expense,deposit_currency AS currency FROM erp_deposit_income a JOIN erp_bank_account b ON b.bank_account_id = a.bank_account_id " . $where1;
        $sql .= "\n UNION \n";
        $sql .= "SELECT 0 AS deposit_after_BC, deposit_expense_id AS acc_id,created_dt AS date,description AS description,IF(deposit_raw>0,0,0) AS income,bank_name AS bank_name,deposit_raw AS expense,currency_type AS currency FROM erp_deposit_expense a JOIN erp_bank_account b ON b.bank_account_id = a.bank_account_id " . $where2;

        $sql .= "ORDER BY date ASC";
        $data = DB::select($sql);
        return $data;

    }
    public function select_expense_deposit($bank, $stdate, $endate)
    {
        $where1 = '';
        $where2 = '';

        if ($stdate <> '') {
            if ($bank <> "") {
                $where1 = "WHERE date(deposit_date) >= '$stdate' AND date(deposit_date) <= '$endate'";
                $where2 = "WHERE date(created_dt) >= '$stdate' AND date(created_dt) <= '$endate'";
            }
        }
        if ($bank <> "") {
            if (!empty($where1)) {
                $where1 .= " AND a.bank_account_id='$bank'";
            } else {
                $where1 = "WHERE a.bank_account_id='$bank'";
            }

            if (!empty($where2)) {
                $where2 .= " AND a.bank_account_id='$bank'";
            } else {
                $where2 = "WHERE a.bank_account_id='$bank'";
            }


        }


        $sql = "SELECT deposit_after_bankcharge AS deposit_after_BC, deposit_income_id AS acc_id,deposit_date AS date,description AS description,deposit_raw AS income,bank_name AS bank_name,IF(deposit_raw>0,0,0) AS expense,after_bankcharge_currency AS currency,deposit_currency AS dep_currency FROM erp_deposit_income a JOIN erp_bank_account b ON b.bank_account_id = a.bank_account_id " . $where1;

        $sql .= "\n UNION \n";
        $sql .= "SELECT 0 AS deposit_after_BC, deposit_expense_id AS acc_id,created_dt AS date,description AS description,IF(deposit_raw>0,0,0) AS income,bank_name AS bank_name,deposit_raw AS expense,currency_type AS currency, NUll AS dep_currency FROM erp_deposit_expense a JOIN erp_bank_account b ON b.bank_account_id = a.bank_account_id " . $where2;

        $sql .= "ORDER BY date ASC";
        $data = DB::select($sql);

        return $data;
    }
}
