<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;
use Stevebauman\Location\Facades\Location;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;

class AuthController extends Controller
{
     //Login
     public function StaffLogin(Request $request){
        $id = $request->get('log_in_id');
        $password =$request->get('password');
        if(empty($id) || empty($password)){
            return response()->json([
                'status' => false,
                'messages' => 'Please input all field',
                'body' => [
                    'identity' => $id,
                    'password' => $password
                ]
            ]);
        }

        $data = $this->get_data_staff($id);
        if(COUNT($data) === 1){
            $query_access_ip = DB::table('erp_staff_access_ip')
                               ->select('*')
                               ->where('ip_group', $data[0]->ip_group)
                               ->get();
            if(COUNT($query_access_ip) >= 1){
                $public_ip_address= getenv('REMOTE_ADDR');
                if($query_access_ip[0]->allow_ip_access == $public_ip_address || $query_access_ip[0]->allow_ip_access == '%' ){
                    if (Hash::check($password, $data[0]->password)) {
                            if($data[0]->active == 0){
                                return response()->json([
                                    'status' => false,
                                    'messages' => 'This user is inactive'
                                ]);
                            }
       
                            $this->update_last_login($data[0]->staff_id);
                            $this->update_last_login_ip_address($data[0]->staff_id);
                            $data_staff = $this->get_data_staff($id);
                            if(COUNT($data_staff) === 1){
                                $this->insert_history_login($data_staff);
                            }
                           
                            // $creditials = $request->only('log_in_id','password');
                            if(Auth::attempt(['log_in_id' => $id, 'password' => $password])){
                            $user = Auth::user();
                            return response()->json([
                                'status' => true,
                                'messages' => 'Login Success',
                                'name' => $user->full_name,
                                'id' => $user->staff_id, 
                                'date' => $user->joint_date, 
                                'body' => [
                                    'access_token' =>$user->createToken('accessToken')->accessToken
                                ]
                            ]);
                            }
                        }
                        return response()->json([
                            'status' => false,
                            'messages' => 'Incorrect Password',
                            'body' => [
                                'identity' => $id,
                                'password' => $password
                            ]
                        ]);
                }
            }
           
        }else{
            return response()->json([
                'status' => false,
                'messages' => 'Incorrect Login ID'
            ]);
        }
     }

     public function CheckLogin(Request $request){
        if(Auth::check()){
            $user = Auth::user();
            $data_group_user = $this->data_group_user($user->staff_id);
            return response()->json([
                'status' => true,
                'messages' => 'Logined',
                'permission' => @$data_group_user[0]->name
            ]);
        }
    }

     public function data_group_user($id){
        $data = DB::table('users_groups AS a')
          ->select('b.name')
          ->leftjoin('groups AS b','b.id','a.group_id')
          ->where('a.staff_id','=',$id)
          ->get();
          return $data;
     }

     public function get_data_staff($id){
        $data = DB::table('erp_staff')
                  ->select('email','staff_id','password','active','last_login','ip_address','ip_group','access_from')
                  ->where('log_in_id','=',$id)
                  ->orderBy('staff_id','DESC')
                  ->limit(1)
                  ->get();
        return $data;
     }

     public function update_last_login($id){
        $currentTime = Carbon::now();
        $arr_time = $currentTime->toArray();
        DB::table('erp_staff')
          ->where('staff_id','=',$id)
          ->update(['last_login'=>$arr_time['timestamp']]);
     }

     public function update_last_login_ip_address($id){
        $ip = $_SERVER['REMOTE_ADDR'];
        $location = Location::get('96.9.79.10');
        $country = $location->countryName;
        DB::table('erp_staff')
          ->where('staff_id','=',$id)
          ->update(['ip_address'=>$ip,'access_from'=>$country]);
     }

     public function insert_history_login($data)
	{
        $login_date = date('Y-m-d h:i:s', $data[0]->last_login);

        $data_in = array(
        	'staff_id' => $data[0]->staff_id,
        	'ip_address' => $data[0]->ip_address,
        	'access_from' => $data[0]->access_from,
            'login_date' => $login_date,
        );
		// $this->db->insert($this->tables['erp_staff_login_history'],$data_in);
        DB::table('erp_staff_login_history')
          ->insert($data_in);
	}

 

    public function staff_cambodia($staff_id){
        $status = false;
        $data = DB::table('erp_staff AS s')
                  ->select('s.staff_id','s.full_name','c.country_name')
                  ->leftjoin('erp_country_list AS c','s.country_list_id','=','c.country_list_id')
                  ->where('s.staff_id','=',$staff_id)
                  ->get();
        foreach($data as $val){
            if ($val->country_name === "Cambodia") {
                $status = true;
            }
        }
        return $status;
    }
}
