<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;

class Car_info extends Controller
{
    /// ================= car make=================///
    public function get_car_make_list(Request $request)
    {
        $where_manul = "car_make_id <> ''";
        $Search_car_make = $request->get('search_car_make');
        $check = is_array(json_decode($Search_car_make)) ? count(json_decode($Search_car_make)) : 0;
        $perPage = $request->get('perPage');
        // dd($check );
        if ($check > 0) {
            foreach (json_decode($Search_car_make) as $val) {
                if (!empty($val->Car_make_fiter)) {
                    $where_manul = "erp_car_make.car_make_name LIKE '%" . $val->Car_make_fiter . "%'";
                }
            }
        }
        $data = DB::table('erp_car_make')
            ->select('*')
            ->from('erp_car_make')
            ->whereRaw(DB::raw($where_manul))
            ->paginate($perPage);
        return response()->json([
            "car_make_lists" => $data
        ], 200);
    }
    public function insert_car_make(Request $request)
    {
        $carmakeinsert = $request->get('carmakeinsert');
        // dd($carmakeinsert);
        foreach (json_decode($carmakeinsert) as $val) {
            $data = array(
                'car_make_name' => $val->Car_Make,
                'car_make_count' => '1'
            );
            DB::table('erp_car_make')
                ->insert($data);
        }
    }
    public function modify_car_make(Request $request)
    {
        $modify_car_make = $request->get('modify_car_make');
        // dd( $modify_car_make);
        foreach (json_decode($modify_car_make) as $item) {
            $car_make_id = $item->Car_make_id;
            $car_make_name_edit = $item->Car_make_name_edit;
            /// update erp_car_make
            $data = array(
                'car_make_name' => $car_make_name_edit,
            );
            DB::table('erp_car_make')
                ->where('car_make_id', '=', $car_make_id)
                ->update($data);
            /// update erp_stock_list
            $data_stock_list = array(
                'car_make_en' => $car_make_name_edit,
            );
            DB::table('erp_stock_list')
                ->where('car_make_id', '=', $car_make_id)
                ->update($data_stock_list);
        }
    }
    public function delete_car_make(Request $request)
    {
        $car_make_delete = $request->get('car_make_delete');
        foreach (json_decode($car_make_delete) as $item) {
            $dataChecked = $item->Car_make_id;
            //   dd($dataChecked );
            DB::table('erp_car_make')
                ->whereIntegerInRaw('car_make_id', [$dataChecked])
                ->delete();
        }
    }
    /// ================= car model=================///
    public function get_car_model_list(Request $request)
    {
        $where_manul = "car_model_id <> ''";
        $search_car_model = $request->get('search_car_model');
        $check = is_array(json_decode($search_car_model)) ? count(json_decode($search_car_model)) : 0;
        $perPage = $request->get('perPage');
        // dd($search_car_model);
        if ($check > 0) {
            foreach (json_decode($search_car_model) as $val) {
                if (!empty($val->Car_model_fiter)) {
                    $where_manul = "erp_car_make.car_make_name LIKE '%" . $val->Car_model_fiter . "%'";
                }
                if (!empty($val->Car_model_fiter)) {
                    $where_manul .= " OR erp_car_model.car_model_name  LIKE '%" . $val->Car_model_fiter . "%'";
                }
            }
        }
        $data = DB::table('erp_car_model')
            ->select('*')
            ->from('erp_car_model')
            ->Join('erp_car_make', 'erp_car_make.car_make_id', '=', 'erp_car_model.car_make_id')
            ->orderBy('car_model_name', 'DESC')
            ->whereRaw(DB::raw($where_manul))
            ->paginate($perPage);
        return response()->json([
            "car_model_lists" => $data
        ], 200);
    }
    public function get_all_car_make()
    {
        $data = DB::table('erp_car_make')
            ->select('*')
            ->from('erp_car_make')
            ->get();
        return response()->json([
            "all_car_makes" => $data
        ], 200);
    }
    public function save_car_model(Request $request)
    {
        $carmodelInsert = $request->get('carmodelInsert');
        // dd($carmodelInsert );
        foreach (json_decode($carmodelInsert) as $val) {
            $data = array(
                'car_make_id' => $val->Car_make_name,
                'car_model_name' => $val->Model_name,
                'car_model_count' => '1'
            );
            DB::table('erp_car_model')
                ->insert($data);
        }
    }
    public function modify_car_model(Request $request)
    {
        $edit_car_model = $request->get('edit_car_model');
        // dd( $edit_car_model);
        foreach (json_decode($edit_car_model) as $item) {
            $car_model_id = $item->Car_model_id;
            $car_make_name_edit = $item->Car_make_name_edit;
            $model_name_edit = $item->Model_name_edit;
            $data = array(
                'car_model_id' => $car_model_id,
                'car_make_id' => $car_make_name_edit,
                'car_model_name' => $model_name_edit
            );

            //  update erp_car_model
            DB::table('erp_car_model')
                ->where('car_model_id', '=', $car_model_id)
                ->update($data);

            /// update erp_stock_list
            $data_stock_list = array(
                'car_model_en' => $car_make_name_edit,
            );
            DB::table('erp_stock_list')
                ->where('car_make_id', '=', $car_model_id)
                ->update($data_stock_list);
        }
    }
    public function delete_car_model(Request $request)
    {
        $car_models_delete = $request->get('car_models_delete');
        foreach (json_decode($car_models_delete) as $item) {
            $dataChecked = $item->Car_model_id;
            //   dd($dataChecked );
            DB::table('erp_car_model')
                ->whereIntegerInRaw('car_model_id', [$dataChecked])
                ->delete();
        }
    }
    /// ================= car color=================///
    public function get_car_color_list(Request $request)
    {
        $where_manul = "color_id <> ''";
        $search_car_color = $request->get('search_car_color');
        $check = is_array(json_decode($search_car_color)) ? count(json_decode($search_car_color)) : 0;
        $perPage = $request->get('perPage');
        // dd($search_car_color);
        if ($check > 0) {
            foreach (json_decode($search_car_color) as $val) {
                if (!empty($val->Car_color_fiter)) {
                    $where_manul = "erp_car_color.color_name  LIKE '%" . $val->Car_color_fiter . "%'";
                }
            }
        }
        $perPage = $request->get('perPage');
        // dd($perPage);
        $data = DB::table('erp_car_color')
            ->select('*')
            ->from('erp_car_color')
            ->whereRaw(DB::raw($where_manul))
            ->paginate($perPage);
        return response()->json([
            "car_color_lists" => $data
        ], 200);
    }
    public function save_car_color(Request $request)
    {
        $carcolorInsert = $request->get('carcolorInsert');
        // dd($carcolorInsert );
        foreach (json_decode($carcolorInsert) as $val) {
            $data = array(
                'color_name' => $val->Color_name,
            );
            DB::table('erp_car_color')
                ->insert($data);
        }
    }
    public function modify_car_color(Request $request)
    {
        $edit_car_color = $request->get('edit_car_color');
        // dd( $edit_car_color);
        foreach (json_decode($edit_car_color) as $item) {
            $color_id = $item->Color_id;
            $color_name = $item->Color_name_edit;
            $data = array(
                'color_id' => $color_id,
                'color_name' => $color_name
            );
            DB::table('erp_car_color')
                ->where('color_id', '=', $color_id)
                ->update($data);
        }
    }
    public function delete_car_color(Request $request)
    {
        $car_colors_delete = $request->get('car_colors_delete');
        foreach (json_decode($car_colors_delete) as $item) {
            $dataChecked = $item->Color_id;
            //   dd($dataChecked );
            DB::table('erp_car_color')
                ->whereIntegerInRaw('color_id', [$dataChecked])
                ->delete();
        }
    }
}
