<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;


class City extends Controller
{
    public function city_list(Request $request)
    {
        $where_manul = "stock_city_id <> ''";
        $perPage = $request->get('perPage');
        $search = $request->get('search_data');
        $check = is_array(json_decode($search)) ? count(json_decode($search)) : 0;
        // dd($search );
        if ($check > 0) {
            foreach (json_decode($search) as $val) {
                if (!empty($val->country_fitler)) {
                    $where_manul = "erp_stock_city_location.stock_location_id=" . $val->country_fitler;
                }
                if (!empty($val->city_filter)) {
                    $where_manul .= " AND erp_stock_city_location.stock_city_name LIKE '%" . $val->city_filter . "%'";
                }
            }
        }

        $data = DB::table('erp_stock_city_location')
            ->select('*')
            ->leftjoin('erp_country_list', 'erp_stock_city_location.stock_location_id', '=', 'erp_country_list.country_list_id')
            ->whereRaw(DB::raw($where_manul))
            ->paginate($perPage);
        // dd(DB::getQueryLog());
        return response()->json([
            "city_lists" => $data
        ], 200);

    }

    public function save_city(Request $request)
    {

        $datainsert = $request->get('datainsert');
        // dd($datainsert);
        foreach (json_decode($datainsert) as $val) {
            $data = array(
                'stock_location_id' => $val->location_add,
                'stock_city_name' => $val->city_name,
            );
            $check_data = $this->check_data($val->location_add, $val->city_name);
            if (count($check_data) > 0) {
                return 'location has already!!!!';
            } else {
                DB::table('erp_stock_city_location')
                    ->insert($data);
            }
        }
    }
    public function edit_city(Request $request)
    {
        $updatedatacity = $request->get('updatedatacity');
        // dd($updatedatacity);
        foreach (json_decode($updatedatacity) as $item) {
            $id = $item->stock_city_id;
            $country = $item->country_edit;
            $city_name = $item->city_name;
            $data = array(
                'stock_location_id' => $country,
                'stock_city_name' => $city_name,
            );
            DB::table('erp_stock_city_location')
                ->where('stock_city_id', '=', $id)
                ->update($data);
        }
    }
    public function get_country_combo()
    {
        $data = DB::table('erp_stock_country_location')
            ->select('country_name', 'stock_location_id', 'erp_country_list.country_list_id')
            ->leftjoin('erp_country_list', 'erp_country_list.country_list_id', '=', 'erp_stock_country_location.country_list_id')
            ->get();
        return response()->json([
            "country_list_combo" => $data
        ], 200);
    }
    public function delete_city(Request $request)
    {
        $deletedata = $request->get('deletedata');
        foreach (json_decode($deletedata) as $item) {
            $stock_id = $item->stock_city_id;
            DB::table('erp_stock_city_location')
                ->where('stock_city_id', '=', $stock_id)
                ->delete();
        }
    }
    public function check_data($location_add, $city_name)
    {
        $data = DB::table('erp_stock_city_location')
            ->select('*')
            ->leftjoin('erp_country_list', 'erp_stock_city_location.stock_location_id', '=', 'erp_country_list.country_list_id')
            ->where('erp_stock_city_location.stock_location_id', '=', $location_add)
            ->where('erp_stock_city_location.stock_city_name', '=', $city_name)
            ->get();
        return $data;
    }
}
