<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\Hash;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class Customer extends Controller
{
    public function get_customer_list(Request $request)
    {
        $where_manul = "customer_id <> ''";
        $perPage = $request->get('perPage');
        $user = Auth::user();
        $permission = $this->data_group_user($user->staff_id);
        $search = $request->get('search_data');
        $check = is_array(json_decode($search)) ? count(json_decode($search)) : 0;

        if ($check > 0) {
            foreach (json_decode($search) as $item) {
                if (!empty($item->Full_name)) {
                    $where_manul = "erp_customer.full_name LIKE '%" . $item->Full_name . "%'";
                }
                if (!empty($item->Phone)) {
                    $where_manul .= " AND erp_customer.phone_number =" . $item->Phone;
                }
                if (!empty($item->Country)) {
                    $where_manul .= " AND erp_customer.country_list_id =" . $item->Country;
                }
            }
        }
        if ($permission == 'Sale') {
            $data['customer_list'] = DB::table('erp_customer')
                ->select('erp_customer.*', 'erp_staff.full_name as sale_name', 'erp_country_list.country_name')
                ->join('erp_country_list', 'erp_country_list.country_list_id', '=', 'erp_customer.country_list_id')
                ->leftjoin('erp_staff', 'erp_staff.staff_id', '=', 'erp_customer.staff_id')
                ->where('erp_customer.staff_id', $user->staff_id)
                ->orWhere('erp_customer.staff_id', null)
                ->where('erp_customer.active', '=', '1')
                ->whereRaw(DB::raw($where_manul))
                ->orderBy('allocate_remaining_usd', 'desc')
                ->paginate($perPage);
        } elseif ($permission == 'Manager') {
            $data['customer_list'] = DB::table('erp_customer')
                ->select('erp_customer.*', 'erp_staff.full_name as sale_name', 'erp_country_list.country_name', 'remaining_usd AS NULL', 'remaining_jpy AS NULL')
                ->join('erp_country_list', 'erp_country_list.country_list_id', '=', 'erp_customer.country_list_id')
                ->leftjoin('erp_staff', 'erp_staff.staff_id', '=', 'erp_customer.staff_id')
                ->where('erp_customer.staff_id', $user->staff_id)
                ->orWhere('erp_customer.staff_id', null)
                ->where('erp_customer.active', 1)
                ->whereRaw(DB::raw($where_manul))
                ->orderBy('allocate_remaining_usd', 'desc')
                ->paginate($perPage);
        } else {
            $data['customer_list'] = DB::table('erp_customer')
                ->select('erp_customer.*', 'erp_staff.full_name as sale_name', 'erp_country_list.country_name')
                ->join('erp_country_list', 'erp_country_list.country_list_id', '=', 'erp_customer.country_list_id')
                ->leftjoin('erp_staff', 'erp_staff.staff_id', '=', 'erp_customer.staff_id')
                ->where('erp_customer.active', '=', '1')
                ->whereRaw(DB::raw($where_manul))
                ->orderBy('allocate_remaining_usd', 'desc')
                ->orderBy('allocate_remaining_jpy', 'desc')
                ->paginate($perPage);
        }

        $arr_main_jpy = array();
        $arr_main_usd = array();
        $arr_total_remaining_jpy = array();
        $arr_total_remaining_usd = array();
        $arr_groupstatus = array();
        $arr_check_staff = array();
        $user = array();
        foreach ($data['customer_list'] as $val) {
            $customer_id = $val->customer_id;

            $sql_select_join = "
            SELECT
                SUM(car_allocate_origin) AS car_allocate_origin,
                car_allocate_origin_currency,
                customer_deposit_id
            FROM
                erp_carpayments
            GROUP BY
                customer_deposit_id
         ";
            $data_main_balance = DB::table('erp_customer_deposit AS a')
                ->select(
                    DB::raw(
                        " SUM(deposit_amount) AS deposit_amount,
                        (SUM( deposit_amount ) - car_allocate_origin) AS main_balance,
                        customer_deposit_currency,
                        car_allocate_origin,
                        car_allocate_origin_currency AS currency_type,
                        (IFNULL(SUM(deposit_amount),0) - IFNULL(SUM(car_allocate_origin),0)) AS main_balance"

                    )
                )
                ->leftjoin(DB::raw('(' . $sql_select_join . ')  AS b'), 'b.customer_deposit_id', '=', 'a.customer_deposit_id')
                ->where('customer_id', '=', $customer_id)
                ->groupBy('customer_deposit_currency')
                ->get();

            foreach ($data_main_balance as $val1) {

                if ($val1->customer_deposit_currency == "JPY") {
                    $arr_main_jpy[$val->customer_id] = 'Ұ' . number_format($val1->main_balance);
                } else {
                    $arr_main_usd[$val->customer_id] = '$' . number_format($val1->main_balance, 2);
                }
            }
            // DB::enableQueryLog();
            $data_total_allocate = DB::table('erp_stock_list')
                ->select(
                    DB::raw(
                        " erp_stock_list.stock_id,
                                        SUM(sold.total_sold_price) AS total_soldprice,
                                        sold.currency,
                                        SUM(pay.car_allocate) AS car_allocate,
                                        pay.car_allocate_currency,
                                        (
                                            IFNULL(
                                                SUM(sold.total_sold_price),
                                                0
                                            ) - IFNULL(SUM(pay.car_allocate), 0)
                                        ) AS total_remaining "
                    )
                )
                ->from('erp_stock_list')
                ->leftjoin(
                    DB::raw('(SELECT
                                  (
                                    IFNULL( res.fob, 0 ) + IFNULL( res.freight_fee, 0 ) + IFNULL( res.insurance, 0 ) + IFNULL( res.inspection, 0 ) - IFNULL( res.discount, 0 )+ IFNULL( res.other_fee, 0 )+ IFNULL( res.vanning, 0 ) 
                                  ) AS total_sold_price,
                                  res.created_dt,
                                  res.stock_id,
                                  res.currency 
                                  FROM
                                  ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res  
                                    LEFT JOIN erp_stock_list sto ON sto.stock_id = res.stock_id 
                                     GROUP BY
                                    res.stock_id 
                                ) AS sold ON sold.stock_id = erp_stock_list.stock_id'),
                    function () {
                    }
                )
                ->leftjoin(
                    DB::raw(
                        '(SELECT
                                  SUM( car_allocate ) AS car_allocate,
                                  car_allocate_currency,
                                  stock_id,
                                  b.customer_deposit_type  FROM   erp_carpayments a
                                      LEFT JOIN erp_customer_deposit b ON b.customer_deposit_id = a.customer_deposit_id
                                  WHERE
                                  b.customer_deposit_type = "customer_deposit"
                                  OR b.customer_deposit_type ="customer_auction_deposit"
                                GROUP BY
                                     stock_id 
                                )  AS pay ON pay.stock_id = erp_stock_list.stock_id '
                    ),
                    function () {
                    }
                )
                ->where('customer_id', '=', $customer_id)
                ->where('status', '<', 9)
                ->groupBy('sold.currency')
                ->get();

            $arr_total_remaining_jpy[$val->customer_id] = ($val->allocate_remaining_jpy > 0 || $val->allocate_remaining_jpy < 0) ? $val->allocate_remaining_jpy : 0;
            $arr_total_remaining_jpy[$val->customer_id] = 'Ұ' . number_format($val->allocate_remaining_jpy);
            $arr_total_remaining_usd[$val->customer_id] = ($val->allocate_remaining_usd > 0 || $val->allocate_remaining_usd < 0) ? $val->allocate_remaining_usd : 0;
            $arr_total_remaining_usd[$val->customer_id] = '$' . number_format($val->allocate_remaining_usd, 2);
            $user = Auth::user();
            $groupstatus = DB::table('users_groups')
                ->select('*')
                ->where('staff_id', '=', $user->staff_id)
                ->get();

            $check_staff = DB::table('erp_customer')
                ->select('customer_id', 'staff_id')
                ->where('customer_id', $customer_id)
                ->get();

            $arr_groupstatus[$customer_id] = $groupstatus[0]->group_id;
            $arr_check_staff[$customer_id] = $check_staff[0];

        }

        $data['arr_main_jpy'] = $arr_main_jpy;
        $data['arr_main_usd'] = $arr_main_usd;
        $data['arr_total_remaining_jpy'] = $arr_total_remaining_jpy;
        $data['arr_total_remaining_usd'] = $arr_total_remaining_usd;
        $data['arr_groupstatus'] = $arr_groupstatus;
        $data['arr_check_staff'] = $arr_check_staff;
        $data['user'] = Auth::user();
        return response()->json([
            $data
        ], 200);
    }
    public function data_group_user($id)
    {
        $data = DB::table('users_groups AS a')
            ->select('b.name')
            ->leftjoin('groups AS b', 'b.id', 'a.group_id')
            ->where('a.staff_id', '=', $id)
            ->get();
        return $data;
    }
    public function get_country_list_combo()
    {
        $data = DB::table('erp_country_list')
            ->select('*')
            ->from('erp_country_list')
            ->get();
        return response()->json([
            "country_list_combo" => $data
        ], 200);
    }
    public function get_customers_type()
    {
        $data = DB::table('erp_customer_type')
            ->select('*')
            ->from('erp_customer_type')
            ->get();
        return response()->json([
            "customer_type" => $data
        ], 200);

    }
    public function get_country_list()
    {
        $data = DB::table('erp_country_list')
            ->select('*')
            ->from('erp_country_list')
            ->get();
        return response()->json([
            "country_list" => $data
        ], 200);
    }
    public function get_sales()
    {
        $data = DB::table('erp_staff')
            ->select('*')
            ->from('erp_staff')
            ->where('active', '=', 1)
            ->get();
        return response()->json([
            "sale" => $data
        ], 200);
    }
    public function insert_customers(Request $request)
    {
        $login_id = $request->get('login_id');
        $full_name = $request->get('full_name');
        $gender = $request->get('gender');
        $country_list_id = $request->get('country');
        $type = $request->get('type');
        $sales = $request->get('sales');
        $whatapp = $request->get('whatapp');
        $address = $request->get('address');
        $email = $request->get('email1');
        $email2 = $request->get('email2');
        $phone_number = $request->get('phone');
        $payment_terms = $request->get('payment_terms');
        $password = $request->get('password');
        $hashedPassword = Hash::make($request->password);
        $customer_star_rank = $request->get('customer_star_rank');
        $consignee_name = $request->get('consignee_name');
        $consignee_address = $request->get('consignee_address');
        $consignee_phone = $request->get('consignee_phone');
        $shipper_name = $request->get('shipper_name');
        $shipper_address = $request->get('shipper_address');
        $shipper_phone = $request->get('shipper_phone');
        $shipper_email = $request->get('shipper_email');
        $create_date = date('Y-m-d ');
        $data = array(
            'login_id' => $login_id,
            'full_name' => $full_name,
            'sex' => $gender,
            'country_list_id' => $country_list_id,
            'customer_type' => $type,
            'staff_id' => $sales,
            'whatapp' => $whatapp,
            'address' => $address,
            'email1' => $email,
            'email2' => $email2,
            'phone_number' => $phone_number,
            'payment_terms' => $payment_terms,
            'password' => $hashedPassword,
            'raw_password' => $password,
            'customer_star_rank' => $customer_star_rank,
            'consignee_name' => $consignee_name,
            'consignee_address' => $consignee_address,
            'consignee_phone' => $consignee_phone,
            'shipper_name' => $shipper_name,
            'shipper_address' => $shipper_address,
            'shipper_phone' => $shipper_phone,
            'shipper_email' => $shipper_email,
            'create_date' => $create_date,
            'verify' => '1',
            'register_track' => 'erp'
        );

        // validation insert
        $validator = Validator::make($request->all(), [
            'login_id' => 'required|min:5|unique:erp_customer',
            'full_name' => 'required',
            'gender' => 'required',
            'country' => 'required',
            'type' => 'required',
            'sales' => 'required',
            'email1' => 'required|regex:/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/|unique:erp_customer',
            'phone' => 'required|min:11|numeric',
            'password' => 'required|min:5',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors()
            ], 422);
        }
        // Insert data to database
        $customer_id = DB::table('erp_customer')
            ->insertGetId($data);
        return $customer_id;

    }
    public function edit_customer(Request $request)
    {
        $customer_id = $request->get('customer_id');
        $login_id = $request->get('login_id');
        $full_name = $request->get('full_name');
        $gender = $request->get('gender');
        $country_list_id = $request->get('country');
        $type = $request->get('type');
        $sales = $request->get('sales');
        $whatapp = $request->get('whatapp');
        $address = $request->get('address');
        $email = $request->get('email1');
        $email2 = $request->get('email2');
        $phone_number = $request->get('phone_number');
        $payment_terms = $request->get('shipok_condition');
        $password = $request->get('password');
        $hashedPassword = Hash::make($request->password);
        $customer_star_rank = $request->get('customer_star_rank');
        $consignee_name = $request->get('consignee_name');
        $consignee_address = $request->get('consignee_address');
        $consignee_phone = $request->get('consignee_phone');
        $shipper_name = $request->get('shipper_name');
        $shipper_address = $request->get('shipper_address');
        $shipper_phone = $request->get('shipper_phone');
        $shipper_email = $request->get('shipper_email');
        $create_date = date('Y-m-d ');
        $data = array(
            'login_id' => $login_id,
            'full_name' => $full_name,
            'sex' => $gender,
            'country_list_id' => $country_list_id,
            'customer_type' => $type,
            'staff_id' => $sales,
            'whatapp' => $whatapp,
            'address' => $address,
            'email1' => $email,
            'email2' => $email2,
            'phone_number' => $phone_number,
            'payment_terms' => $payment_terms,
            'password' => $hashedPassword,
            'raw_password' => $password,
            'customer_star_rank' => $customer_star_rank,
            'consignee_name' => $consignee_name,
            'consignee_address' => $consignee_address,
            'consignee_phone' => $consignee_phone,
            'shipper_name' => $shipper_name,
            'shipper_address' => $shipper_address,
            'shipper_phone' => $shipper_phone,
            'shipper_email' => $shipper_email,
            'create_date' => $create_date,
        );

        $ckhogin_id = "";
        $ckemail = "";
        $ckphone_num = "";
        $data_edit = $this->get_customer_edit($customer_id);
        if ($login_id !== $data_edit[0]->login_id) {
            $ckhogin_id = 'required|unique:erp_customer';
        } else {
            $ckhogin_id = 'required';
        }
        if ($email !== $data_edit[0]->email1) {
            $ckemail = 'required|regex:/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/|unique:erp_customer';
        } else {
            $ckemail = 'required|regex:/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/';
        }
        if ($phone_number !== $data_edit[0]->phone_number) {
            $ckphone_num = 'required|numeric|unique:erp_customer';
        } else {
            $ckphone_num = 'required|numeric';
        }

        // validation 
        $validator = Validator::make($request->all(), [
            'login_id' => $ckhogin_id,
            'full_name' => 'required',
            'gender' => 'required',
            'country' => 'required',
            'type' => 'required',
            'sales' => 'required',
            'email1' => $ckemail,
            'shipok_condition' => 'required',
            'phone_number' => $ckphone_num,
            'password' => 'required|min:5',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors()
            ], 422);
        }

        DB::table('erp_customer')
            ->where('customer_id', '=', $customer_id)
            ->update($data);
    }
    public function get_customer_list_edit(Request $request)
    {
        $customer_id = $request->get('customer_id');
        $data = DB::table('erp_customer')
            ->select('erp_customer.*', 'erp_staff.full_name as sale_name', 'erp_country_list.country_name')
            ->join('erp_country_list', 'erp_country_list.country_list_id', '=', 'erp_customer.country_list_id')
            ->leftjoin('erp_staff', 'erp_staff.staff_id', '=', 'erp_customer.staff_id')
            ->where('customer_id', $customer_id)
            ->get();
        return response()->json([
            "customer" => $data
        ], 200);
    }
    public function get_customer_profile(Request $request)
    {
        $customer_id = $request->get('customer_id');
        $data['cus_profile'] = DB::table('erp_customer')
            ->select('erp_customer.*', 'erp_staff.full_name as sale_name', 'erp_country_list.country_name')
            ->join('erp_country_list', 'erp_country_list.country_list_id', '=', 'erp_customer.country_list_id')
            ->leftjoin('erp_staff', 'erp_staff.staff_id', '=', 'erp_customer.staff_id')
            ->where('customer_id', $customer_id)
            ->get();

        $arr_main_jpy = array();
        $arr_main_usd = array();
        $arr_total_remaining_jpy = array();
        $arr_total_remaining_usd = array();
        $amountjpy = array();
        $amountusd = array();
        foreach ($data['cus_profile'] as $val) {
            $customer_id = $val->customer_id;

            $sql_select_join = "
            SELECT
                SUM(car_allocate_origin) AS car_allocate_origin,
                car_allocate_origin_currency,
                customer_deposit_id
            FROM
                erp_carpayments
            GROUP BY
                customer_deposit_id
         ";
            $data_main_balance = DB::table('erp_customer_deposit AS a')
                ->select(
                    DB::raw(
                        " SUM(deposit_amount) AS deposit_amount,
                        (SUM( deposit_amount ) - car_allocate_origin) AS main_balance,
                        customer_deposit_currency,
                        car_allocate_origin,
                        car_allocate_origin_currency AS currency_type,
                        (IFNULL(SUM(deposit_amount),0) - IFNULL(SUM(car_allocate_origin),0)) AS main_balance"

                    )
                )
                ->leftjoin(DB::raw('(' . $sql_select_join . ')  AS b'), 'b.customer_deposit_id', '=', 'a.customer_deposit_id')
                ->where('customer_id', '=', $customer_id)
                ->groupBy('customer_deposit_currency')
                ->get();
            foreach ($data_main_balance as $val1) {
                // main_balance
                if ($val1->customer_deposit_currency == "JPY") {
                    $arr_main_jpy[$customer_id] = 'Ұ' . number_format($val1->main_balance);
                } else {
                    $arr_main_usd[$customer_id] = '$' . number_format($val1->main_balance, 2);
                }
            }
            if ($val->allocate_remaining_jpy > 0 || $val->allocate_remaining_jpy < 0) {
                $arr_total_remaining_jpy[$customer_id] = 'Ұ' . number_format($val->allocate_remaining_jpy);
            } elseif ($val->allocate_remaining_usd > 0 || $val->allocate_remaining_usd < 0) {
                $arr_total_remaining_usd[$customer_id] = '$' . number_format($val->allocate_remaining_usd);
            }
            /// Action Balance
            $data_auction_balance = DB::table('erp_customer_deposit AS a')
                ->select(
                    DB::raw(
                        "SUM(IF (customer_deposit_currency = 'USD',deposit_amount,0)) AS amountusd,SUM(IF (customer_deposit_currency = 'JPY',deposit_amount,0)) AS amountjpy"
                    )
                )
                ->where('customer_deposit_type', 'with_chassis')
                ->where('customer_id', '=', $customer_id)
                ->get();
            foreach ($data_auction_balance as $val) {
                $amountusd[$customer_id] = 'Ұ' . number_format($val->amountjpy);
                $amountjpy[$customer_id] = '$' . number_format($val->amountusd, 2);
            }
        }
        $data['arr_main_jpy'] = $arr_main_jpy;
        $data['arr_main_usd'] = $arr_main_usd;
        $data['arr_total_remaining_jpy'] = $arr_total_remaining_jpy;
        $data['arr_total_remaining_usd'] = $arr_total_remaining_usd;
        $data['amountjpy'] = $amountjpy;
        $data['amountusd'] = $amountusd;
        // dd($data);
        return response()->json([
            $data
        ], 200);

    }
    public function insert_consignee(Request $request)
    {
        $savedata = $request->get('savedata');
        $create_date = date('Y-m-d ');
        $user = Auth::user();
        foreach (json_decode($savedata) as $val) {
            $data = array(
                'customer_id' => $val->customer_id,
                'consignee_name' => $val->Consignee_name,
                'consignee_phone' => $val->Consignee_phone,
                'consignee_address' => $val->Consignee_address,
                'consignee_email' => $val->Consignee_phone,
                'create_dt' => $create_date,
                'user_id' => $user->staff_id,

            );
            DB::table('erp_consignee')
                ->insert($data);

        }
    }
    public function get_customer_consignee(Request $request)
    {
        $customer_id = $request->get('customer_id');
        // dd( $customer_id);
        $data = DB::table('erp_consignee')
            ->select('*')
            ->where('customer_id', $customer_id)
            ->get();
        return response()->json([
            "customer_consignees" => $data
        ], 200);
    }
    public function modify_consignee(Request $request)
    {
        $modifydata = $request->get('modifydata');
        $last_updated = date('Y-m-d ');
        foreach (json_decode($modifydata) as $val) {
            $consignee_id = $val->consignee_id;
            $data = array(
                'customer_id' => $val->customer_id,
                'consignee_name' => $val->Consignee_name,
                'consignee_phone' => $val->Consignee_phone,
                'consignee_address' => $val->Consignee_address,
                'consignee_email' => $val->Consignee_phone,
                'last_update' => $last_updated,
            );
            DB::table('erp_consignee')
                ->where('consignee_id', '=', $consignee_id)
                ->update($data);
        }
    }
    public function delete_consignee(Request $request)
    {
        $user = Auth::user();
        $permission = $this->data_group_user($user->staff_id);
        if ($permission != 'Sale') {
            $deletedata = $request->get('deletedata');
            // dd($deletedata);
            foreach (json_decode($deletedata) as $item) {
                $dataChecked = $item->consignee_id;
                DB::table('erp_consignee')
                    ->whereIntegerInRaw('consignee_id', [$dataChecked])
                    ->delete();
            }
        }
    }
    public function insert_customer_remark(Request $request)
    {
        $savedata = $request->get('savedata');
        $create_date = date('Y-m-d ');
        $user = Auth::user();
        foreach (json_decode($savedata) as $val) {
            $arr_data = array(
                'cus_no' => $val->Member_no,
                'description' => $val->Remark_desc,
                'date_remark' => $create_date,
                'update_user' => $user->staff_id,
            );
            // dd($arr_data);
            DB::table('iw_member_remark')
                ->insert($arr_data);

        }

    }
    public function get_remark(Request $request)
    {
        $customer_id = $request->get('customer_id');
        $data = DB::table('iw_member_remark AS a')
            ->select('b.full_name', 'a.*')
            ->leftjoin('erp_staff AS b', 'b.staff_id', '=', 'a.update_user')
            ->where('cus_no', $customer_id)
            ->get();
        return response()->json([
            "get_remark" => $data
        ], 200);

    }
    public function select_data_stocklist(Request $request)
    {
        $where_manul = "a.stock_id <>''";
        $search = $request->get('search_data');
        $check = is_array(json_decode($search)) ? count(json_decode($search)) : 0;
        $customer_id = $request->get('customer_id');
        $perPage = $request->get('perPage');
        if ($check > 0) {
            foreach (json_decode($search) as $item) {
                $Select_sch = $item->Select_sch;
                if ($Select_sch) {
                    if ($item->Txt_sch) {
                        if ($Select_sch == "chassios_no") {
                            $where_manul = "a.chassis_number LIKE '%" . $item->Txt_sch . "%'";
                        } else if ($Select_sch == "car_model") {
                            $where_manul = " a.car_model_en LIKE '%" . $item->Txt_sch . "%'";
                        }
                    }
                }
            }
        }
        $data['data_stocklist'] = DB::table('erp_stock_list  AS a')
            ->select('a.customer_id', 'a.stock_id', 'a.chassis_number', 'a.car_model_id', 'a.car_model_en', 'sold.total_sold_price', 'sold.currency', 'sold.vanning', 'sold.other_fee', 'sold.created_dt', 'pay.car_allocate', 'pay.car_allocate_currency')
            ->leftjoin(
                DB::raw('(SELECT (IFNULL(res.fob,0) + IFNULL(res.freight_fee,0) + IFNULL(res.insurance,0) + IFNULL(res.inspection,0) + IFNULL(res.other_fee,0)+ IFNULL(res.vanning,0)) AS total_sold_price,res.created_dt,res.stock_id, res.currency,res.vanning,res.other_fee FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res GROUP BY res.stock_id) AS sold', 'sold.stock_id = a.stock_id'),
                function ($leftjoin) {
                    $leftjoin->on('sold.stock_id', '=', 'a.stock_id');
                }
            )
            ->leftjoin(
                DB::raw('(SELECT SUM(car_allocate) AS car_allocate,SUM(IF(car_allocate_origin_currency="USD", car_allocate_origin, 0)) AS sumusd,SUM(IF( car_allocate_origin_currency ="JPY", car_allocate_origin, 0)) AS sumjpy,car_allocate_currency,stock_id FROM erp_carpayments LEFT JOIN erp_customer_deposit ON  erp_customer_deposit.customer_deposit_id=erp_carpayments.customer_deposit_id WHERE erp_customer_deposit.customer_deposit_type="customer_deposit" GROUP BY stock_id) AS pay', 'pay.stock_id = a.stock_id'),
                function ($leftjoin) {
                    $leftjoin->on('pay.stock_id', '=', 'a.stock_id');
                }
            )
            ->where('a.customer_id', $customer_id)
            ->whereRaw(DB::raw($where_manul))
            ->orderBy('pay.car_allocate', 'ASC')
            ->paginate($perPage);

        $arr_lastdepositdate = array();
        foreach ($data['data_stocklist'] as $val) {
            $customer_id = $val->customer_id;
            $stock_id = $val->stock_id;

            $lastdepositdate = DB::table('erp_carpayments AS b')
                ->select('b.create_date')
                ->leftjoin('erp_customer_deposit AS a', 'a.customer_deposit_id', '=', 'b.customer_deposit_id')
                ->where('a.customer_id', $customer_id)
                ->where('b.stock_id', $stock_id)
                ->where('a.customer_deposit_type', '=', 'customer_deposit')
                ->orderBy('b.create_date', 'DESC')
                ->limit('1')
                ->get();

            $arr_lastdepositdate[$stock_id] = @$lastdepositdate[0]->create_date;
            $arr_lastdepositdate[$stock_id] = !empty(@$lastdepositdate[0]->create_date) ? date('Y-m-d', strtotime(@$lastdepositdate[0]->create_date)) : null;

        }
        $data['arr_lastdepositdate'] = $arr_lastdepositdate;
        return response()->json([
            $data
        ], 200);
    }

    public function select_model_list()
    {
        $data = DB::table('erp_car_model')
            ->select('*')
            ->get();
        return response()->json([
            "car_model_list" => $data
        ], 200);
    }
    public function select_total_stocklist(Request $request)
    {
        $where_manul = "a.stock_id <>''";
        $search = $request->get('search_data');
        $check = is_array(json_decode($search)) ? count(json_decode($search)) : 0;
        $customer_id = $request->get('customer_id');
        if ($check > 0) {
            foreach (json_decode($search) as $item) {
                $Select_sch = $item->Select_sch;
                if ($Select_sch) {
                    if ($item->Txt_sch) {
                        if ($Select_sch == "chassios_no") {
                            $where_manul = "a.chassis_number LIKE '%" . $item->Txt_sch . "%'";
                        } else if ($Select_sch == "car_model") {
                            $where_manul = " a.car_model_en LIKE '%" . $item->Txt_sch . "%'";
                        }
                    }
                }
            }
        }
        $data = DB::table('erp_stock_list  AS a')
            ->select('a.customer_id', 'a.stock_id', 'a.chassis_number', 'a.car_model_id', 'a.car_model_en', 'sold.total_sold_price', 'sold.currency', 'sold.vanning', 'sold.other_fee', 'sold.created_dt', 'pay.car_allocate', 'pay.car_allocate_currency')
            ->leftjoin(
                DB::raw('(SELECT (IFNULL(res.fob,0) + IFNULL(res.freight_fee,0) + IFNULL(res.insurance,0) + IFNULL(res.inspection,0) + IFNULL(res.other_fee,0)+ IFNULL(res.vanning,0)) AS total_sold_price,res.created_dt,res.stock_id, res.currency,res.vanning,res.other_fee FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res GROUP BY res.stock_id) AS sold', 'sold.stock_id = a.stock_id'),
                function ($leftjoin) {
                    $leftjoin->on('sold.stock_id', '=', 'a.stock_id');
                }
            )
            ->leftjoin(
                DB::raw('(SELECT SUM(car_allocate) AS car_allocate,SUM(IF(car_allocate_origin_currency="USD", car_allocate_origin, 0)) AS sumusd,SUM(IF( car_allocate_origin_currency ="JPY", car_allocate_origin, 0)) AS sumjpy,car_allocate_currency,stock_id FROM erp_carpayments LEFT JOIN erp_customer_deposit ON  erp_customer_deposit.customer_deposit_id=erp_carpayments.customer_deposit_id WHERE erp_customer_deposit.customer_deposit_type="customer_deposit" GROUP BY stock_id) AS pay', 'pay.stock_id = a.stock_id'),
                function ($leftjoin) {
                    $leftjoin->on('pay.stock_id', '=', 'a.stock_id');
                }
            )
            ->where('a.customer_id', $customer_id)
            ->whereRaw(DB::raw($where_manul))
            ->get();
        return response()->json([
            "toal_car_stock_list" => $data
        ], 200);
    }
    public function select_allocate_history(Request $request)
    {
        $stock_id = $request->get('stock_id');
        $data = DB::table('erp_carpayments AS a')
            ->select('a.stock_id', 'a.car_allocate', 'a.car_allocate_origin', 'a.car_allocate_currency', 'a.car_allocate_origin_currency', 'a.payment_type', 'a.author_id', 'a.create_date AS all_cat_date', 'b.customer_id', 'b.customer_deposit_type', 'c.full_name')
            ->leftjoin('erp_customer_deposit AS b', 'b.customer_deposit_id', '=', 'a.customer_deposit_id')
            ->leftjoin('erp_staff AS c', 'b.author_id', '=', 'c.staff_id')
            ->where('a.stock_id', $stock_id)
            ->where('b.customer_deposit_type', '=', 'customer_deposit')
            ->get();
        return response()->json([
            "allcate_historys" => $data
        ], 200);

    }
    public function delete_customers(Request $request)
    {
        $deletedata = $request->get('deletedata');
        foreach (json_decode($deletedata) as $item) {
            $id = $item->customer_id;
            $data = array('active' => '0');
            DB::table('erp_customer')
                ->where('customer_id', $id)
                ->update($data);
        }
    }
    public function get_customer_edit($customer_id)
    {
        $data = DB::table('erp_customer')
            ->select('erp_customer.*', 'erp_staff.full_name as sale_name', 'erp_country_list.country_name')
            ->join('erp_country_list', 'erp_country_list.country_list_id', '=', 'erp_customer.country_list_id')
            ->leftjoin('erp_staff', 'erp_staff.staff_id', '=', 'erp_customer.staff_id')
            ->where('customer_id', $customer_id)
            ->get();

        return $data;

    }
    public function delete_customer_detail(Request $request)
    {
        $deletedata = $request->get('deletedata');
        foreach (json_decode($deletedata) as $item) {
            $id = $item->customer_id;
            $data = array('active' => '0');
            DB::table('erp_customer')
                ->where('customer_id', $id)
                ->update($data);
        }
    }
}


