<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;


class Exchange_rate extends Controller
{
    public function index(Request $request)
    {
        $perPage = $request->get('perPage');
        $data = DB::table('erp_exchange_rate')
            ->select('*')
            ->from('erp_exchange_rate')
            ->orderBy('exchange_dt', 'DESC')
            ->paginate($perPage);
        return response()->json([
            'exchangerate_datas' => $data
        ], 200);
    }
    public function insert_exchage_rate(Request $request)
    {
        $dataInsert = $request->get('dataInsert');
        //    dd($dataInsert);
        foreach (json_decode($dataInsert) as $item) {
            $form_currency_usd = "";
            $to_currency_usd = "";
            $exchange_date = "";
            $exchange_rate = "";
            $current_date_time = date('Y-m-d H:i:s');

            if (!empty($item->form_currency_usd)) {
                $form_currency_usd = $item->form_currency_usd;
            }

            if (!empty($item->to_currency_usd)) {
                $to_currency_usd = $item->to_currency_usd;
            }

            if (!empty($item->exchange_date)) {
                $exchange_date = $item->exchange_date;
            }

            if (!empty($item->exchange_rate)) {
                $exchange_rate = $item->exchange_rate;
            }

            $data = array(
                'from_currency' => $form_currency_usd,
                'to_currency' => $to_currency_usd,
                'exchange_dt' => $exchange_date,
                'exchange_rate' => $exchange_rate,
                'created_dt' => $current_date_time,
            );
            DB::table('erp_exchange_rate')
                ->insert($data);
        }

    }
    public function update_exchage_rate(Request $request)
    {
        $edit_data = $request->get('edit_data');
        // dd( $edit_data);
        foreach (json_decode($edit_data) as $item) {
            $id = $item->id;
            $form_currency_usd = $item->form_currency_usd;
            $to_currency_usd = $item->to_currency_usd;
            $exchange_date = $item->exchange_date;
            $exchange_rate = $item->exchange_rate;
            $current_date_time = date('Y-m-d H:i:s');
            $data = array(
                'from_currency' => $form_currency_usd,
                'to_currency' => $to_currency_usd,
                'exchange_dt' => $exchange_date,
                'exchange_rate' => $exchange_rate,
                'created_dt' => $current_date_time,
            );
            DB::table('erp_exchange_rate')
                ->where('id', '=', $id)
                ->update($data);
        }

    }

    public function delete_exchage_rate(Request $request)
    {
        $deletedata = $request->get('deletedata');
        // dd($deletedata);die();
        foreach (json_decode($deletedata) as $item) {
            $id = $item->id;
            DB::table('erp_exchange_rate')
                ->where('id', '=', $id)
                ->delete();
        }
    }
}

