<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Auth;
use App\Models\Expenses_model;
use App\Models\Income_model;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;


class Expense extends Controller
{
    public function index(Request $request){
         $tabs = $request->get('tabs');
         $Perpage = $request->get('Perpage');
         $page = $request->get('page');
         $description = $request->get('description');
         $StartDate = $request->get('StartDate');
         $data['customer_dep_list'] =  Expenses_model::select_customer_deposit();
         
         if($tabs == 'Available'){
            $data['expense_info'] = Expenses_model::expenses_deposit($Perpage,$StartDate,$description);
         }

         if($tabs == 'History'){
            $data['expense_info'] = Expenses_model::expenses_deposit_history($Perpage,$StartDate,$description);
         }
         
         return response()->json([
            $data
         ]);
    }

    public function GetExpenseSecondTap(Request $request){
      $tab_customer = $request->get('tabs');
      $Perpage = $request->get('Perpage');
      $page = $request->get('page');
      $sch_date = $request->get('sch_date');
      $sch_desc = trim($request->get('sch_desc'));
      $sch_id = trim($request->get('sch_id'));
      $sch_condition = $request->get('sch_condition');

      if($tab_customer == 'Office' || $tab_customer == 'Without Chassis' || $tab_customer == 'Furikae'){
        $whereRaw = "";
        if($sch_condition == 'name' && !empty($sch_desc)){
          $whereRaw = "erp_deposit_expense.description LIKE '%".$sch_desc."%'";
        }else if($sch_condition == 'Date' && !empty($sch_date)){
          $whereRaw ="date(erp_deposit_expense.created_dt) = '".$sch_date."'";
        }else if($sch_condition == 'ID' && !empty($sch_id)){
          $whereRaw = "erp_deposit_expense.deposit_expense_id = ".$sch_id."";
        }
      }

    $data = array();
      if($tab_customer == "With Chassis"){
        $whereRaw = "";
        if($sch_condition == 'name'  && !empty($sch_desc)){
          $whereRaw = "deposit_expense.description LIKE '%".$sch_desc."%'";
        }else if($sch_condition == 'Date' && !empty($sch_date)){
          $whereRaw = "date(deposit_expense.created_dt) = '".$sch_date."'";
        }else if($sch_condition == 'ID' && !empty($sch_id)){
          $whereRaw = "deposit_expense.deposit_expense_id = ".$sch_id."";
        }
        $data['car_expense_info'] = Expenses_model::get_car_expense_with_chasiss($Perpage,$whereRaw);
      }else if($tab_customer == 'With Chassis History'){
        $whereRaw = "";
        if($sch_condition == 'name' && !empty($sch_desc)){
          $whereRaw = "deposit_expense.description LIKE '%".$sch_desc."%'";
        }else if($sch_condition == 'Date' && !empty($sch_date)){
          $whereRaw ="date(deposit_expense.created_dt) = '".$sch_date."'";
        }else if($sch_condition == 'ID' && !empty($sch_id)){
          $whereRaw = "deposit_expense.deposit_expense_id = ".$sch_id."";
        }
        $data['car_expense_info'] = Expenses_model::get_car_expense_with_chasiss_history($Perpage,$whereRaw);
      }else if($tab_customer == 'Office'){
        $type = 'Office';
        $data['car_expense_info'] = Expenses_model::get_car_data_office($Perpage,$type,$whereRaw);
      }else if($tab_customer == "Without Chassis"){
        $type = 'without_chassis';
        $data['car_expense_info'] = Expenses_model::get_car_data_office($Perpage,$type,$whereRaw); 
      }else if($tab_customer == 'Furikae'){
        $type = 'FURIKAE';
        $data['car_expense_info'] = Expenses_model::get_car_data_office($Perpage,$type,$whereRaw); 
      }else if($tab_customer == 'Refund'){
        $whereRaw = "";
        if($sch_condition == 'name' && !empty($sch_desc)){
          $whereRaw ="erp_deposit_expense.description LIKE '%".$sch_desc."%'";
        }else if($sch_condition == 'Date' && !empty($sch_date)){
          $whereRaw ="date(erp_deposit_expense.created_dt) = '".$sch_date."'";
        }else if($sch_condition == 'ID' && !empty($sch_id)){
          $whereRaw = "erp_deposit_expense.deposit_expense_id = ".$sch_id."";
        }
        $type = 'refund';
        $data['car_expense_info'] = Expenses_model::get_car_data_refund($Perpage,$type,$whereRaw); 
      }

      return response()->json([
        $data
      ]);
    }

    public function distribute_expenses_exec(Request $request){
      $current_amount =$request->get('current_amount');
      $deposit_expense_id =$request->get('expense_id');
      $expense_types =$request->get('expense_types');
      $amount =$request->get('amount');
      $currency =$request->get('currency');
      $customer_id =$request->get('customer_id');
      $create_date  = date("Y-m-d");
      $customer_dep_id =$request->get('cus_dep_id');       
      $user = Auth::user();
      $where['deposit_expense_id']  = $deposit_expense_id;
      $where['expense_types']         = $expense_types;
  
      if($expense_types == "refund"){
          $arr_income_data = array('customer_deposit_id' => $customer_dep_id, 
                                  'car_allocate' => $amount,
                                  'car_allocate_origin' => $amount,
                                  'car_allocate_currency' => $currency,
                                  'car_allocate_origin_currency' => $currency,
                                  'payment_type' => 'refund',
                                  'create_date' => date("Y-m-d H:i:s"),
                                  'author_id' => $user->staff_id
                              );
          $check_incom = Income_model::checking_date_have_or_not($customer_dep_id,$amount,$currency,'refund',date("Y-m-d"),$user->staff_id);
      
          if(count($check_incom) > 0){
          }else{
            Income_model::insert_car_payment_data($arr_income_data);
          }
      }
      // $current_distribute = Expenses_model::get_current_distribute($where);
      $data_check = Expenses_model::echecking_data($expense_types,$customer_id,$amount,$currency,$deposit_expense_id,date("Y-m-d"));

      $DataInsert = array(
         'expense_types' => $expense_types,
         'customer_id' => $customer_id,
         'amount' => $amount,
         'currency_type' => $currency,
         'deposit_expense_id' => $deposit_expense_id,
         'create_date' => $create_date
      );
  
      if(count( $data_check) > 0){
      }else{
          $result =  Expenses_model::distribute_exec($DataInsert);
          return response()->json([
            'status' => true,
            'message' => 'Distribute successfully'
          ]);
      }
    }

    public function delete_expenses_item(Request $request){
      $deposit_id = $request->get('deposit_id');
      DB::table('erp_deposit_expense')
        ->where('deposit_expense_id','=',$deposit_id)
        ->delete();
        return response()->json([
            'status' => true,
            'message' => 'Delete successfully'
          ]);

    }

    public function exportdeposithistory(Request $request){
      $depdate = $request->get('StartDate');
      $desc = $request->get('sch_word');
      require '../vendor/autoload.php';
      $objPHPExcel = new Spreadsheet();
      $inputFileName = storage_path( 'app/public/PHPEXCEL/export_excel_deposit_history.xls' );
      $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );

      $dataDeposit = Expenses_model::data_deposit_history($depdate,$desc);

      $objPHPExcel->getActiveSheet()->getDefaultColumnDimension()
      ->setWidth(20);
      $style = array(
          'alignment' => array(
              'horizontal' =>  \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
          )
      );

      $right= array('borders' => array('right' => array('bordStyle' => 
       \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('argb' => '000000'),)));

      $bottom= array('borders' => array('bottom' => array('bordStyle' => 
       \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('argb' => '000000'),)));
      $objPHPExcel->getActiveSheet()->getStyle('A1:F1')->applyFromArray($style);
      $style = array(
            'alignment' => array(
                'horizontal' =>  \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
            )
        );

        $objPHPExcel->getActiveSheet()->getStyle("A1")->applyFromArray($style);
      $objPHPExcel->getActiveSheet()->setCellValue('A1', 'DEPOSIT HISTORY LIST')
                                    ->setCellValue('A2', 'Deposit ID')
                                    ->setCellValue('B2', 'Bank')
                                    ->setCellValue('C2', 'Description')
                                    ->setCellValue('D2', 'Amount')
                                    ->setCellValue('E2', 'Date');
        $objPHPExcel->getActiveSheet()->mergeCells('A1:E1');
        
      if(COUNT($dataDeposit) >0){
        $i=3;
        $j=1;
        foreach($dataDeposit as $row){
          $objPHPExcel->getActiveSheet()
                                    ->setCellValue('A'.$i, $row->deposit_expense_id)
                                    ->setCellValue('B'.$i, $row->bank_full_name)
                                    ->setCellValue('C'.$i, $row->description)
                                    ->setCellValue('D'.$i, $row->deposit_raw.' '.$row->currency_type)
                                    ->setCellValue('E'.$i, substr($row->created_dt, 0,10));
        $i++;
        $j++;
        }
        $i = $i - 1;
        $objPHPExcel->getActiveSheet()->getStyle('A1:E'.$i)->applyFromArray(
            array(
                'borders' => array(
                      'allBorders' => array(
                          'borderStyle' =>  \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                      )
                  )
            )
        );
      }


      $objPHPExcel->setActiveSheetIndex(0);

      $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);
      

      // Redirect output to a client’s web browser (Excel5)
      header('Content-Type: application/vnd.ms-excel');
      header('Content-Disposition: attachment;filename="invoice_.xls"');
      header('Cache-Control: max-age=0');
      // If you're serving to IE 9, then the following may be needed
      header('Cache-Control: max-age=1');
      // If you're serving to IE over SSL, then the following may be needed
      header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
      header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
      header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
      header ('Pragma: public'); // HTTP/1.0
      return response()->json([
          $writer->save('php://output')
      ]);
      
    }

    public function exportdeposit(Request $request){
      $depdate = $request->get('StartDate');
      $desc = $request->get('sch_word');
      require '../vendor/autoload.php';
      $objPHPExcel = new Spreadsheet();
      $inputFileName = storage_path( 'app/public/PHPEXCEL/export_excel_deposit.xls' );
      $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );

      $data = Expenses_model::data_exponse_deposit($depdate,$desc);
      
      $objPHPExcel->getActiveSheet()->mergeCells('A1:F1');
      $style = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
            )
        );

      $objPHPExcel->getActiveSheet()->getStyle("A1")->applyFromArray($style);
      $objPHPExcel->getActiveSheet()->setCellValue('A1', 'DEPOSIT LIST')
                                    ->setCellValue('A2', 'Deposit ID')
                                    ->setCellValue('B2', 'Bank')
                                    ->setCellValue('C2', 'Deposit Raw')
                                    ->setCellValue('D2', 'Description')
                                    ->setCellValue('E2', 'Amount')
                                    ->setCellValue('F2', 'Date');
      $objPHPExcel->getActiveSheet()->getDefaultColumnDimension()
      ->setWidth(20);

       $style = array(
          'alignment' => array(
              'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
          )
      );

      $objPHPExcel->getActiveSheet()->getStyle('A1:F1')->applyFromArray($style);

      if(COUNT($data) > 0){
        $i=3;
        foreach($data as $row){
          $objPHPExcel->getActiveSheet()->setCellValue('A'.$i, $row->deposit_expense_id)
                                        ->setCellValue('B'.$i, $row->bank_full_name)
                                        ->setCellValue('C'.$i, $row->deposit_raw)
                                        ->setCellValue('D'.$i, $row->description)
                                        ->setCellValue('E'.$i, $row->deposit.' '.$row->currency_type)
                                        ->setCellValue('F'.$i, substr($row->created_dt, 0,10));

        $i++;
        }
        $i = $i - 1;
        $objPHPExcel->getActiveSheet()->getStyle('A1:F'.$i)->applyFromArray(
            array(
                'borders' => array(
                      'allBorders' => array(
                          'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                      )
                  )
            )
        );
      }

      $objPHPExcel->setActiveSheetIndex(0);

      $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);
      

      // Redirect output to a client’s web browser (Excel5)
      header('Content-Type: application/vnd.ms-excel');
      header('Content-Disposition: attachment;filename="invoice_.xls"');
      header('Cache-Control: max-age=0');
      // If you're serving to IE 9, then the following may be needed
      header('Cache-Control: max-age=1');
      // If you're serving to IE over SSL, then the following may be needed
      header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
      header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
      header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
      header ('Pragma: public'); // HTTP/1.0
      return response()->json([
          $writer->save('php://output')
      ]);
    }

    public function main_detail_history(request $request){
      $id = $request->get('dep_id');
      $data['currency'] = $request->get('currency');
      $data['get_all_history'] = Expenses_model::get_all_history($id);
      return response()->json([
         $data
      ]);
    }

    public function history_view(Request $request){
      $id = $request->get('expense_id');
      $divi_id = $request->get('division_id');
      $currency =$request->get('currency_his');
      $amount =$request->get('amount');

      $SubDivisionExpensesAmount = Expenses_model::get_expense_car_amount($divi_id);

      $get_income_amount_division_id =Expenses_model::getIncomeAmont($divi_id);
      $total_distribute =0;
      if(COUNT($SubDivisionExpensesAmount)>0){

          $total_distribute = $this->TotalExpensesAmount($SubDivisionExpensesAmount);

          $total_distribute = $amount - $total_distribute;
      }
      $other_fee_info = array();
      $refund_info = array();
      if(COUNT($SubDivisionExpensesAmount) > 0){
        foreach($SubDivisionExpensesAmount as $val){
          $sql="SELECT * FROM erp_car_expenses_other_fee where car_expense_id='$val->car_expense_id'";
          $data_other_fee = DB::select($sql);
          foreach($data_other_fee as $row){
            $currency= $row->currency_type;
            $ts = strtotime($row->create_date);
            $date = date('Y-m-d', $ts);
            array_push($other_fee_info, array(
              'other_fee_id' => $row->other_fee_id,
              'amount' => number_format($row->amount),
              'title' => $row->title,
              'currency' =>  $currency,
              'create_date' => $date,
              'chassis_number' => $val->chassis_number
            ));
          }

          $sql_refund="SELECT * FROM erp_car_expenses_other_refund where car_expense_id='$val->car_expense_id'";
          $data_refund = DB::select($sql_refund);
          foreach($data_refund as $value){
            $ts = strtotime($value->create_date);
            $date = date('Y-m-d', $ts);
            array_push($refund_info,array(
              'chassis_number' => $value->chassis_number,
              'other_refund_id' => $value->other_refund_id,
              'title' => $value->title,
              'amount' => $value->amount,
              'currency_type' => $value->currency_type,
              'create_date' => $date,
              'chassis_number' => $val->chassis_number
            ));
          }
        }
      }
      
      

      $data['expense_list_his'] = $SubDivisionExpensesAmount;
      $data['total_distribute'] = $total_distribute;
      $data['income_amount'] = $get_income_amount_division_id;
      $data['currency'] = $currency;
      $data['other_fee_info'] = $other_fee_info;
      $data['refund_info'] = $refund_info;
      return response()->json([
        $data
      ]);
    }

    public function detail_expenese(Request $request){
      $id = $request->get('expense_id');
      $divi_id = $request->get('division_id');
      $currency_cur =$request->get('currency');
      $amount =$request->get('amount');

      $SubDivisionExpensesAmount = Expenses_model::get_expense_car_amount($divi_id);

      $get_income_amount_division_id =Expenses_model::getIncomeAmont($divi_id);
      $total_distribute =$amount;
      if(COUNT($SubDivisionExpensesAmount)>0){

          $total_distribute = $this->TotalExpensesAmount($SubDivisionExpensesAmount);

          // $total_distribute = $amount - $total_distribute;
      }
      $other_fee_info = array();
      $refund_info = array();
      if(COUNT($SubDivisionExpensesAmount) > 0){
        foreach($SubDivisionExpensesAmount as $val){
          $sql="SELECT * FROM erp_car_expenses_other_fee where car_expense_id='$val->car_expense_id'";
          $data_other_fee = DB::select($sql);
      
   
          // dd($sql);
          foreach($data_other_fee as $row){
            $currency= $row->currency_type;
            $ts = strtotime($row->create_date);
            $date = date('Y-m-d', $ts);
            if($currency=='JPY'){
                $currency = "Ұ";
            }else{
                $currency = "$";
            }
            array_push($other_fee_info, array(
              'other_fee_id' => @$row->other_fee_id,
              'amount' => number_format(@$row->amount),
              'title' => @$row->title,
              'currency' =>  $currency,
              'create_date' => $date,
              'chassis_no' => $val->chassis_number
            ));
         
          }
       
          $sql_refund="SELECT * FROM erp_car_expenses_other_refund where car_expense_id='$val->car_expense_id'";
          $data_refund = DB::select($sql_refund);
          foreach($data_refund as $value){
            $ts = strtotime(@$value->create_date);
            $date = date('Y-m-d', $ts);
            array_push($refund_info,array(
              'chassis_number' => @$value->chassis_number,
              'other_refund_id' => @$value->other_refund_id,
              'title' => @$value->title,
              'amount' => @$value->amount,
              'currency_type' => @$value->currency_type,
              'create' =>$value->create_date,
              'chassis_no' => $val->chassis_number
            ));
          }
        }
      }
      $data['expense_list'] = $SubDivisionExpensesAmount;
      $data['total_distribute'] = $total_distribute;
      $data['income_amount'] = $get_income_amount_division_id;
      $data['currency'] = $currency_cur;
      $data['other_fee_info'] = $other_fee_info;
      $data['refund_info'] = $refund_info;
      $data['divi_id'] = $divi_id;
      return response()->json([
        $data
      ]);
    }

    function TotalExpensesAmount($get_expense_car_amount){
      $buying_price        = 0;
      $tax_fee          = 0;
      $auction_fee         = 0;
      $transportation_fee  = 0;
      $car_tax_fee           = 0;
      $recycle_fee             = 0;
      $freight_fee          = 0;
      $repair_fee        = 0;
      $inspection_fee         = 0;
      $shipping_charge_fee      = 0;
      $shipping_charge_cost = 0;
      $insurance_fee = 0;
      $other_fee_amount = 0;
      $other_refund_amount = 0;
      $ea_fee = 0;
      
      foreach ($get_expense_car_amount as $val) {
          $expense_id = $val->car_expense_id;
          $division_id = $val->expenses_division_id;
          $division_amount  = $val->amount;
          $buying_price       += !empty($val->buying_price) ? $val->buying_price : 0;
          $tax_fee         += !empty($val->tax_fee) ? $val->tax_fee : 0;
          $auction_fee        += !empty($val->auction_fee) ? $val->auction_fee : 0;
          $transportation_fee += !empty($val->transportation_fee) ? $val->transportation_fee : 0;
          $recycle_fee          += !empty($val->recycle_fee) ? $val->recycle_fee : 0;
          $car_tax_fee            += !empty($val->car_tax_fee) ? $val->car_tax_fee : 0;
          $freight_fee         += !empty($val->freight_fee) ? $val->freight_fee : 0;
          $repair_fee       += !empty($val->repair_fee) ? $val->repair_fee : 0;
          $inspection_fee        += !empty($val->inspection_fee) ? $val->inspection_fee : 0;
          $shipping_charge_fee     += !empty($val->shipping_charge_fee) ? $val->shipping_charge_fee : 0;
          $insurance_fee += !empty($val->insurance_fee) ? $val->insurance_fee : 0;
          $ea_fee += !empty($val->ea_fee) ? $val->ea_fee : 0;
          
          $expenses_other_fee =  Expenses_model::get_car_expenses_other_fee($expense_id);

          
     if(COUNT($expenses_other_fee)>0){
          foreach ($expenses_other_fee as $row) {
              $other_fee_amount += !empty($row->amount) ? $row->amount : 0;
          }
     }

      $expenses_other_refund =  Expenses_model::get_car_expenses_other_refund($expense_id);
      
      if(COUNT($expenses_other_refund)>0){
          foreach ($expenses_other_refund as $row) {
              $other_refund_amount += !empty($row->amount) ? $row->amount : 0;
          }
         
      }
          
      }
     
      $amount_income= 0;
      $get_income_amount_division_id =Expenses_model::getIncomeAmontByDivion($division_id);
      if (COUNT($get_income_amount_division_id) > 0) {
        foreach ($get_income_amount_division_id as $val) {
          $amount_income = $val->amount_income;
        }
      }

      

      $total_expenses_alllocate = $other_fee_amount + $other_refund_amount + $buying_price + $tax_fee + $auction_fee + $transportation_fee + $recycle_fee  +  $car_tax_fee + $freight_fee + $repair_fee + $inspection_fee + $shipping_charge_fee + $insurance_fee + $ea_fee;
      if(!empty($division_id)){
          $total_distribute = $division_amount - $total_expenses_alllocate;
      }else{
          $total_distribute = $division_amount;
      }

      return $total_distribute + $amount_income;
  }

  public function search_chassis_car(Request $request){
    $chassis_no = $request->get('car_chassis');
    $division_id = $request->get('division_id');
    $stock_list = Expenses_model::SelectCarWithChassis($chassis_no);
    if(COUNT($stock_list)>0){
      $data['stock_id']     = $stock_list[0]->stock_id;
    }
    $get_chassis_num = 0;
    if(!empty($chassis_no)){
      $get_chassis_num = Expenses_model::get_chassis_num($chassis_no);
    }
    $data['get_chassis_num'] = $get_chassis_num;
    if($get_chassis_num > 0){

      $data['chassis_num'] = $chassis_no;
      $get_expense_car =  Expenses_model::get_expense_car($chassis_no,$division_id);
      $data['get_expense_car'] = $get_expense_car;
      
      
      $data['car_expense_id'] = NULL;
      $data['buying_price'] = NULL;
      $data['auction_fee'] = NULL;
      $data['transportation_fee'] = NULL;
      $data['freight_fee'] = NULL;
      $data['repair_fee'] = NULL;
      $data['inspection_fee'] = NULL;
      $data['shipping_charge_fee'] = NULL;
      $data['insurance_fee'] = NULL;
      $data['tax_fee'] = NULL;
      $data['car_tax_fee'] = NULL;
      $data['recycle_fee'] = NULL;
      $data['month_of_expense'] = NULL;
      $data['ea_fee'] = NULL;
      $data['totol_expense'] = 0;
  
      if(!empty($get_expense_car)){
        foreach ($get_expense_car as $rows) {
            $data['car_expense_id'] = $rows->car_expense_id;
            $data['buying_price'] = $rows->buying_price;
            $data['auction_fee'] = $rows->auction_fee;
            $data['transportation_fee'] = $rows->transportation_fee;
            $data['freight_fee'] = $rows->freight_fee;
            $data['repair_fee'] = $rows->repair_fee;
            $data['inspection_fee'] = $rows->inspection_fee;
            $data['shipping_charge_fee'] = $rows->shipping_charge_fee;
            $data['insurance_fee'] = $rows->insurance_fee;
            $data['tax_fee'] = $rows->tax_fee;
            $data['car_tax_fee'] = $rows->car_tax_fee;
            $data['recycle_fee'] = $rows->recycle_fee;
            $data['ea_fee'] = $rows->ea_fee;
  
            $data['totol_expense'] = $rows->buying_price + $rows->auction_fee + $rows->transportation_fee + $rows->freight_fee + $rows->repair_fee + $rows->inspection_fee + $rows->shipping_charge_fee + $rows->insurance_fee + $rows->tax_fee + $rows->car_tax_fee + $rows->recycle_fee + $rows->ea_fee + $rows->other_fee_amount + $rows->other_refund_amount;
            
        }
     }
  
     $sql="SELECT * FROM erp_car_expenses_other_refund where car_expense_id='".$data['car_expense_id']."'";
     $data['data_refund'] = DB::select($sql);
  
     $sql_othewr_fee = "SELECT * FROM erp_car_expenses_other_fee where car_expense_id='".$data['car_expense_id']."'";

     $data['data_other_fee'] = DB::select($sql_othewr_fee);
  
     $sql_income ="SELECT * FROM erp_carpayments where expenses_division_id='$division_id' AND stock_id=".$data['stock_id'];
     $data['data_income'] = DB::select($sql_income);

    }
   
  
   return response()->json([
    $data
  ]);
  }

  public function Allocate_car_expense(Request $request){
     $currency = $request->get('currency');
     $stock_id = $request->get('stock_id');
     $income_money = json_decode($request->get('income_money'));
     $chassis = $request->get('chassis');
     $data_Refund = json_decode($request->get('data_Refund'));
     $data_other_fee = json_decode($request->get('data_other_fee'));
     
     $created_dt = $request->get('created_dt');
     $division_id = $request->get('division_id');
     $insert_data = json_decode($request->get('insert_data'));
     $amount_allocate = $request->get('amount_allocate');
     $user = Auth::user();
     if($currency == "JPY"){
        //get exchange rate from jpy to usd
        $rateWhere = array();
        $rateWhere['from_currency'] = 'JPY';
        $rateWhere['to_currency']   = 'USD';
        $rateWhere['created_dt']   = $created_dt;
        $exchange_rate_jpy_to_usd = Expenses_model::get_exchange_rate($rateWhere);
        if(!empty($exchange_rate_jpy_to_usd)){
            $exchange_jpy_to_usd = $exchange_rate_jpy_to_usd[0]->exchange_rate; 
        }else{
            $con['from_currency'] = 'JPY';
            $con['to_currency']   = 'USD';
            $info_jpy_to_usd = Expenses_model::get_latest_exchange_rate($con);
            $exchange_jpy_to_usd =$info_jpy_to_usd[0]->exchange_rate;
        }
     }

     if($currency == "USD"){
      //get exchange rate from usd to jyp
      $rateWhere1 = array();
      $rateWhere1['from_currency'] = 'USD';
      $rateWhere1['to_currency']   = 'JPY';
      $rateWhere1['created_dt']   = $created_dt;
      $exchange_rate_usd_to_jpy =Expenses_model::get_exchange_rate($rateWhere1);
      if(!empty($exchange_rate_usd_to_jpy)){
          $exchange_usd_to_jpy = $exchange_rate_usd_to_jpy->exchange_rate;
      }else{
          $cons['from_currency'] = 'USD';
          $cons['to_currency']   = 'JPY';
          $info_exchange_rate =Expenses_model::get_latest_exchange_rate($cons);
          $exchange_usd_to_jpy =$info_exchange_rate[0]->exchange_rate;
      }
    }
    $get_car_stock_list = Expenses_model::get_car_stock_list($stock_id);
    if(COUNT($income_money) > 0){
      $n = 0;
      $val = $get_car_stock_list[0];
      $car_allocate_cur = "JPY";
      foreach ($income_money as $value) {
              if(empty($value->car_payment_id)){

                if($currency == "JPY"){
                  $car_exchange_amount = $value->amount;
                  $car_allocate = $value->amount;
              }else{
                  $car_exchange_amount =  $value->amount * $exchange_usd_to_jpy;
                  $car_allocate = $car_exchange_amount;
              }

              if($currency == "USD"){
                  $rate_exchange = $exchange_usd_to_jpy;
              }else{
                  $rate_exchange = $exchange_jpy_to_usd;
              }
              
              $data_income = array(   'expenses_division_id' =>$division_id,
                                      'car_allocate' => $car_allocate,
                                      'car_allocate_origin' => $value->amount,
                                      'stock_id'     => $stock_id,
                                      'car_allocate_currency' => $car_allocate_cur,
                                      'car_allocate_origin_currency' => $currency,
                                      'exchange_amount' => $car_exchange_amount,
                                      'exchange_rate' => $rate_exchange,
                                      'allocate_title' => $value->title,
                                      'exchange_date' => $created_dt,
                                      'payment_type' => "customer_deposit",
                                      'author_id'     => $user->staff_id,
                                      'create_date' => date("Y-m-d h:i:sa")
              );
              Expenses_model::insert_car_payment($data_income);

              }
        }
          
      }
      $car_expense_id = '';
      $where = array();
      $where['expenses_division_id']  = $division_id;
      $where['stock_id']  = $stock_id;
      $inData = array();
      $rate_exchange = 0;
      if($currency=="JPY"){
        $rate_exchange = $exchange_jpy_to_usd;
      }else{
        $rate_exchange = $exchange_usd_to_jpy;
      }
      $inData['exchange_rate'] = $rate_exchange;
      $inData['currency_type'] = $currency;
      $inData['staff_id'] = $user->staff_id;
      $inData['stock_id'] = $stock_id;
      $inData['expenses_division_id'] = $division_id;
      foreach($insert_data as $rows){
        $inData['buying_price'] = $rows->buying_price;
        $inData['auction_fee'] = $rows->auction_fee;
        $inData['transportation_fee'] = $rows->transportation_fee;
        $inData['freight_fee'] = $rows->freight_fee;
        $inData['repair_fee'] = $rows->repair_fee;
        $inData['inspection_fee'] = $rows->inspection_fee;
        $inData['shipping_charge_fee'] = $rows->shipping_charge_fee;
        $inData['insurance_fee'] = $rows->insurance_fee;
        $inData['tax_fee'] = $rows->tax_fee;
        $inData['car_tax_fee'] = $rows->car_tax_fee;
        $inData['recycle_fee'] = $rows->recycle_fee;
        $inData['ea_fee'] = $rows->ea_fee;
        $car_expense_id =$rows->car_expense_id;
      }

     
      $get_expense_car =Expenses_model::get_expense_car($chassis,$division_id);
      
      if(COUNT($get_expense_car) > 0){
          Expenses_model::update_expense_car($where,$inData);
      }else{
          $inData['created_date']  = date("Y-m-d h:i:sa");
          $insert_id = Expenses_model::insert_car_expenses($inData);
      }
      if(!empty($car_expense_id)){
        $car_expense_id =$car_expense_id;
      }else{
          $car_expense_id =$insert_id;
      }
        //insert other refund
        $i=0;
        $j=0;
        $amount_other_refund_in =0;
        if(COUNT($data_Refund) > 0){  
            foreach ($data_Refund as $value) {
                $data_tiltl = $value->title;
                $data_amount = $value->amount;
                if(empty($value->other_refund_id)){
                   if(!empty($data_tiltl)){
                    $insert_data = array(
                      'title' => $data_tiltl,
                      'amount' => $data_amount,
                      'create_date' => date("Y-m-d h:i:sa"),
                      'car_expense_id' => $car_expense_id,
                      'currency_type' => $currency
                    );
                    Expenses_model::insert_car_other_refund($insert_data);
                   }
                   
                }else{
                  $id = $value->other_refund_id;
                  $data_tiltle = $value->title;
                  $data_amount = $value->amount;
                  $update_data = array(
                      'title' => $data_tiltle,
                      'amount' => $data_amount,
                      'create_date' => date("Y-m-d h:i:sa"),
                      'car_expense_id' => $car_expense_id,
                      'currency_type' => $currency
                  );
                  $where1 = array();
                  $where1['other_refund_id']  = $id;
                  $where1['car_expense_id']  = $car_expense_id;
                  Expenses_model::update_other_refund($where1,$update_data);
                }
                $i += 1;
                $amount_other_refund_in += $data_amount;
            }
        }

          //insert other fee
          $b=0;
          $amount_other_fee_in=0;
          if(COUNT($data_other_fee) > 0){
           
              foreach ($data_other_fee as $row) {
                  if(empty($row->other_fee_id)){
                    $data_tiltle = $row->title;
                    $data_amount = $row->amount;
                    $currency_type = $row->currnecy;
                    $date = $row->date;
                    if(!empty($row->title)){
                        $insert_data = array(
                            'title' => $data_tiltle,
                            'amount' => $data_amount,
                            'create_date' => $date,
                            'car_expense_id' => $car_expense_id,
                            'currency_type' => $currency_type
  
                        );
                        Expenses_model::insert_other_fee($insert_data);
                    }
                  }else{
                        $id = $row->other_fee_id;
                        $data_tiltle = $row->amount;
                        $data_amount = $row->amount;
                        $currency_type = $row->currnecy;
                        $date =  $row->date;
                        $update_data = array(
                            'title' => $data_tiltle,
                            'amount' => $data_amount,
                            'create_date' => $date,
                            'car_expense_id' => $car_expense_id,
                            'currency_type' => $currency_type

                        );
                        $where1 = array();
                        $where1['other_fee_id']  = $id;
                        $where1['car_expense_id']  = $car_expense_id;
                        Expenses_model::update_other_fee($where1,$update_data);
                  }
              }
              
          }
          $total_distribute  = $amount_allocate;
          $get_expense_car_amount = Expenses_model::get_expense_car_amount($division_id);
          if(COUNT($get_expense_car_amount)>0){
              $total_distribute = $this->TotalExpensesAmount($get_expense_car_amount);
          }
          $total_distribute = $total_distribute;
          return response()->json([
            'status' => true,
            'total_distribute' => $total_distribute
          ]);
  }

  public function delete_other_fee(Request $request){
       $id = $request->get('other_fee_id');
       DB::table('erp_car_expenses_other_fee')
         ->where('other_fee_id','=',$id)
         ->delete();
         return response()->json([
          'status' => true
        ]);
  }

  public function delete_other_refund(Request $request){
    $id = $request->get('other_refund_id');
    DB::table('erp_car_expenses_other_refund')
      ->where('other_refund_id','=',$id)
      ->delete();
      return response()->json([
       'status' => true
     ]);
  }

  public function delete_ex_income(Request $request){
    $id = $request->get('car_payment_id');
    DB::table('erp_carpayments')
      ->where('car_payment_id','=',$id)
      ->delete();
      return response()->json([
       'status' => true
     ]);
  }

  public function delete_income_from_payment(Request $request){
    $divi_id = $request->get('division_id');
    $pay_id = $request->get('payment_id');
    if(!empty($pay_id)){
      DB::table('erp_carpayments')
        ->where('car_payment_id','=',$pay_id)
        ->delete();
      return response()->json([
        'status' => true,
        'division_id' => $divi_id,
        'message' => 'successfully'
      ]);
    }
  }

  public function delete_car_expense(Request $request){
    $car_expense_id = $request->get('car_expense_id');
    $divi_id = $request->get('division_id');
    $updata = array(
      'buying_price'=> NULL,
      'auction_fee'=> NULL,
      'transportation_fee'=> NULL,
      'freight_fee'=> NULL,
      'repair_fee'=> NULL,
      'inspection_fee'=> NULL,
      'shipping_charge_fee'=> NULL,
      'insurance_fee'=> NULL,
      'tax_fee'=> NULL,
      'car_tax_fee'=> NULL,
      'recycle_fee'=> NULL,
      'exchange_rate'=> NULL,
      'currency_type'=> NULL,
      'month_of_expense'=> NULL,
      'created_date' => NULL,
      'ea_fee'=>NULL
  );
    if(!empty($car_expense_id)){
      DB::table('erp_car_expenses')
        ->where('car_expense_id','=',$car_expense_id)
        ->update($updata);
      return response()->json([
        'status' => true,
        'division_id' => $divi_id,
        'message' => 'successfully'
      ]);
    }
  }

  public static function update_car_expense(Request $request){
    $car_exp_id =  $request->get('car_exp_id');
    $divi_id = $request->get('division_id');
    $buying_price = $request->get('buying_price');
    $transportation_fee = $request->get('transportation_fee');
    $auction_fee = $request->get('auction_fee');
    $freight_fee = $request->get('freight_fee');
    $repair_fee = $request->get('repair_fee');
    $inspection_fee = $request->get('inspection_fee');
    $shipping_charge_fee = $request->get('shipping_charge_fee');
    $insurance_fee = $request->get('insurance_fee');
    $tax_fee = $request->get('tax_fee');
    $car_tax_fee = $request->get('car_tax_fee');
    $recycle_fee = $request->get('recycle_fee');
    $month_of_expense = $request->get('month_of_expense');
    $ea_fee = $request->get('ea_fee');
    $updata = array(
      'buying_price'=> $buying_price,
      'auction_fee'=> $auction_fee,
      'transportation_fee'=> $transportation_fee ,
      'freight_fee'=> $freight_fee,
      'repair_fee'=> $repair_fee,
      'inspection_fee'=> $inspection_fee,
      'shipping_charge_fee'=> $shipping_charge_fee,
      'insurance_fee'=> $insurance_fee,
      'tax_fee'=> $tax_fee,
      'car_tax_fee'=> $car_tax_fee,
      'recycle_fee'=> $recycle_fee,
      'month_of_expense'=> $month_of_expense,
      'ea_fee'=>$ea_fee
  );

    DB::table('erp_car_expenses')
      ->where('car_expense_id','=',$car_exp_id)
      ->update($updata);
    return response()->json([
      'status' => true,
      'division_id' => $divi_id,
      'message' => 'successfully'
    ]);
    
  }

  public function update_other_refund_id(Request $request){
    $refund_id =  $request->get('refund_id');
    $divi_id = $request->get('divi_id');
    $title = $request->get('title');
    $create = $request->get('create');
    $amount = $request->get('amount');

    $upData = array(
      'title' => $title,
      'create_date' => $create,
      'amount' => $amount
    );

    DB::table('erp_car_expenses_other_refund')
      ->where('other_refund_id','=',$refund_id)
      ->update($upData);
      return response()->json([
        'status' => true,
        'division_id' => $divi_id,
        'message' => 'successfully'
      ]);
  }

  public function delete_other_refund_id(Request $request){
    $refund_id =  $request->get('refund_id');
    $divi_id = $request->get('divi_id');

    if(!empty($refund_id)){
       DB::table('erp_car_expenses_other_refund')
         ->where('other_refund_id','=',$refund_id)
         ->delete();
         return response()->json([
          'status' => true,
          'division_id' => $divi_id,
          'message' => 'successfully'
        ]);
    }
  }

  public function update_other_fee_id(Request $request){
    $other_fee_id = $request->get('o_fee_id');
    $divi_id = $request->get('divi_id');
    $title = $request->get('title');
    $create = $request->get('create');
    $amount = $request->get('amount');
    $upData = array(
      'title' => $title,
      'create_date' => $create,
      'amount' => $amount
    );
    DB::table('erp_car_expenses_other_fee')
      ->where('other_fee_id','=',$other_fee_id)
      ->update($upData);
    return response()->json([
      'status' => true,
      'division_id' => $divi_id,
      'message' => 'update successful!'
    ]);
  }
  
  public function delete_other_fee_id(Request $request){
    $other_fee_id = $request->get('o_fee_id');
    $divi_id = $request->get('divi_id');
    DB::table('erp_car_expenses_other_fee')
       ->where('other_fee_id','=',$other_fee_id)
       ->delete();
       return response()->json([
        'status' => true,
        'division_id' => $divi_id,
        'message' => 'update successful!'
      ]);
  }

  public function return_expend_cha(Request $request){
     $exp_id = $request->get('division_id');
     $amount =  $request->get('amount');
     $currency =  $request->get('currency');

     $get_car_exp = Expenses_model::get_car_exp($exp_id);

     $get_deposit_id =  Expenses_model::get_deposit_id($exp_id);
      $deposit_id = @$get_deposit_id[0]->deposit_expense_id;

      $get_current_amount =Expenses_model::get_current_amount($deposit_id);
      $current_amount = @$get_current_amount[0]->deposit;

      $up_amount = array('deposit'=>$current_amount+$amount);
      Expenses_model::update_deposit_exp_amount($up_amount, $deposit_id);
      foreach ($get_car_exp as $val) {
        $dt = $val->car_expense_id;
        Expenses_model::remove_other_fee($dt);
        Expenses_model::remove_other_refund($dt);
        Expenses_model::remove_car_expense($dt);
      }
      Expenses_model::remove_exp_division($exp_id);
      return response()->json([
        'status' => true,
        'message' => 'successful!'
      ]);
  }

  public function export_excel_expense(Request $request){
    $tab_customer = $request->get('tabs');
    $sch_date = $request->get('sch_date');
    $sch_desc = trim($request->get('sch_desc'));
    $sch_id = trim($request->get('sch_id'));
    $sch_condition = $request->get('sch_condition');
    ob_clean();
    error_reporting(E_ALL);
    ini_set('display_errors', TRUE);
    ini_set('display_startup_errors', TRUE);
    date_default_timezone_set('Europe/London');
      if (PHP_SAPI == 'cli')
         die('This example should only be run from a Web Browser');
    require '../vendor/autoload.php';
    $objPHPExcel = new Spreadsheet();
    if($tab_customer == 'With Chassis'){
      $inputFileName = storage_path( 'app/public/PHPEXCEL/excel_expense.xls' );
    }else{
      $inputFileName = storage_path( 'app/public/PHPEXCEL/excel_expense_with_chasiss.xls' );
    }
    $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
    $type = 'Car';
    $whereRaw = "";
    if($sch_condition == 'name'  && !empty($sch_desc)){
      $whereRaw = "deposit_expense.description LIKE '%".$sch_desc."%'";
    }else if($sch_condition == 'Date' && !empty($sch_date)){
      $whereRaw = "date(deposit_expense.created_dt) = '".$sch_date."'";
    }else if($sch_condition == 'ID' && !empty($sch_id)){
      $whereRaw = "deposit_expense.deposit_expense_id = ".$sch_id."";
    }
    if($tab_customer == 'With Chassis'){
      $get_car_distribute =  Expenses_model::get_car_distribute1($type,$whereRaw);
      $expenses_export_excel = array();
      $total_distribute = array();
      $car_distribute = array();
      $result_car_distribute = array();
      if(COUNT($get_car_distribute)>0){
        $row = 1;
          foreach ($get_car_distribute as $val) {
            
              $row += 1;
              if($val->currency_type=='JPY'){
                $currency = "Ұ";
              }else{
                $currency = "$";
              }     
            $objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $val->deposit_expense_id)                            
                                            ->setCellValue('B'.$row, $val->created_dt)
                                            ->setCellValue('C'.$row, $val->bank_full_name)
                                            ->setCellValue('D'.$row, $val->description)
                                            ->setCellValue('E'.$row, $currency.' '.number_format($val->amount));
            $total_distribute = $val->amount -  $val->total_car_expense +  $val->total_income;
            $objPHPExcel->getActiveSheet()->setCellValue('F'.$row, $currency.' '.number_format($total_distribute));

            $objPHPExcel->getActiveSheet()->getStyle('A2:F'.$row)->applyFromArray(
              array(
                  'borders' => array(
                        'allBorders' => array(
                            'borderStyle' =>  \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                        )
                    )
              )
          );


        }

      }
    }else{
      $row = 1;
      if($tab_customer == 'Office' || $tab_customer == 'Without Chassis' || $tab_customer == 'Furikae'){
        $whereRaw = "";
        if($sch_condition == 'name' && !empty($sch_desc)){
          $whereRaw = "erp_deposit_expense.description LIKE '%".$sch_desc."%'";
        }else if($sch_condition == 'Date' && !empty($sch_date)){
          $whereRaw ="date(erp_deposit_expense.created_dt) = '".$sch_date."'";
        }else if($sch_condition == 'ID' && !empty($sch_id)){
          $whereRaw = "erp_deposit_expense.deposit_expense_id = ".$sch_id."";
        }
      }
      if($tab_customer == 'With Chassis History'){
        $whereRaw = "";
        if($sch_condition == 'name' && !empty($sch_desc)){
          $whereRaw = "deposit_expense.description LIKE '%".$sch_desc."%'";
        }else if($sch_condition == 'Date' && !empty($sch_date)){
          $whereRaw ="date(deposit_expense.created_dt) = '".$sch_date."'";
        }else if($sch_condition == 'ID' && !empty($sch_id)){
          $whereRaw = "deposit_expense.deposit_expense_id = ".$sch_id."";
        }
        $expenses_export_excel = Expenses_model::get_car_expense_with_chasiss_history_excel($whereRaw);
      }else if($tab_customer == 'Office'){
        $type = 'Office';
        $expenses_export_excel = Expenses_model::get_car_data_office_excel($type,$whereRaw);
      }else if($tab_customer == "Without Chassis"){
        $type = 'without_chassis';
        $expenses_export_excel = Expenses_model::get_car_data_office_excel($type,$whereRaw); 
      }else if($tab_customer == 'Furikae'){
        $type = 'FURIKAE';
        $expenses_export_excel = Expenses_model::get_car_data_office_excel($type,$whereRaw); 
      }else if($tab_customer == 'Refund'){
        $whereRaw = "";
        if($sch_condition == 'name' && !empty($sch_desc)){
          $whereRaw ="erp_deposit_expense.description LIKE '%".$sch_desc."%'";
        }else if($sch_condition == 'Date' && !empty($sch_date)){
          $whereRaw ="date(erp_deposit_expense.created_dt) = '".$sch_date."'";
        }else if($sch_condition == 'ID' && !empty($sch_id)){
          $whereRaw = "erp_deposit_expense.deposit_expense_id = ".$sch_id."";
        }
        $type = 'refund';
        $expenses_export_excel = Expenses_model::get_car_data_refund_excel($type,$whereRaw); 
      }



      foreach ($expenses_export_excel as $val) {
        if($val->currency_type=='JPY'){
                $currency = "Ұ";
              }else{
                $currency = "$";
              }     
        $row += 1;
        $objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $val->expenses_division_id)                            
                                        ->setCellValue('B'.$row, $val->created_dt)
                                        ->setCellValue('C'.$row, $val->bank_full_name)
                                        ->setCellValue('D'.$row, $val->description)
                                        ->setCellValue('E'.$row, $currency.' '.number_format($val->amount));
                                        
    

      }
      $border_all =  array(
        'borders' => array(
              'allBorders' => array(
                  'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
              )
          )
      );

      $objPHPExcel->getActiveSheet()->getStyle('A2:E'.$row)->applyFromArray($border_all);
    }
   

       
    $objPHPExcel->getActiveSheet()->setAutoFilter('A1:BZ5000');
    // Rename worksheet
    $objPHPExcel->getActiveSheet()->setTitle('Excel Staff');
    // Set active sheet index to the first sheet, so Excel opens this as the first sheet
    $objPHPExcel->setActiveSheetIndex(0);
    $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);
    // Redirect output to a client’s web browser (Excel5)
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="invoice.xls"');
    header('Cache-Control: max-age=0');
    // If you're serving to IE 9, then the following may be needed
    header('Cache-Control: max-age=1');
    // If you're serving to IE over SSL, then the following may be needed
    header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
    header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
    header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
    header ('Pragma: public'); // HTTP/1.0
    return response()->json([
        $writer->save('php://output')
    ]);
  }
}