<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Auth;
use App\Models\Stocklist_model;
use App\Models\Income_model;
use App\Http\Controllers\Customer_account_update;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use App\Models\Expenses_model;
class Income extends Controller
{
    public function loadDataIncome(Request $request){
        $perpage = $request->get('perPage');
        $from_date = $request->get('from_date');
        $sch_sender = $request->get('sch_sender');
        $to_date = $request->get('to_date');
        $txt_search_date = '';
        $txt_search_left = '';
        $txt_search_to_date = '';
        if(!empty($from_date)){
            $txt_search_date = $from_date;
        }
        if(!empty($sch_sender)){
            $txt_search_left = trim($sch_sender);
        }
        if(!empty($to_date)){
            $txt_search_to_date =  $to_date;
        }
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list($user->staff_id);
        $tab_type = $request->get('tap_type');
        $data = array();
        if($tab_type == 'Available'){
            $empRecord = Income_model::income_deposit($hide_pakistan,$perpage,$txt_search_date,$txt_search_left,$txt_search_to_date);
            $data['income_data'] = $empRecord;
        }else if($tab_type == 'History'){
            $empRecord = Income_model::income_deposit_history($hide_pakistan,$perpage,$txt_search_date,$txt_search_left,$txt_search_to_date);
            $data['income_data'] = $empRecord;
        }
        return response()->json([
            $data 
        ]);
    }

    public function income_destribute(Request $request){
        $deposit_id = $request->get('deposit_id');
        if(!empty($deposit_id)){
            $data['deposit_list'] = Income_model::get_deposit_income_by_id($deposit_id);
            $data['customer_list'] = Income_model::get_customer_info();
        }
        return response()->json([
            $data
        ]);
    }

    public function get_customer_search(Request $request){
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list($user->staff_id);
        $search_condition = $request->get('search_condition');
        $customer_name = $request->get('customer_name');
        $show = array();
        if(!empty($hide_pakistan)){
            $country_list = DB::table('erp_block_countries as t1')
                            ->select('t1.*','c.*')
                            ->leftjoin('erp_block_countries as t2','t1.parent_id','=','t2.parent_id')
                            ->leftjoin('erp_country_list as c','t1.country_list_id','=','c.country_list_id')
                            ->groupBy('t1.country_list_id')
                            ->get();
            foreach  ($country_list as $key => $value) {
                    array_push($show, strtolower($value->country_list_id));
            }
        }
        $data['customer_list'] = Income_model::get_customer_info_by_search($search_condition,$customer_name,$show);
        return response()->json([
            $data
        ]);
    }

    public function exec_distribute(Request $request){
        $distrute_type = $request->get('distrute_type');
        $deposit_id = $request->get('deposit_income_id');
        $deposit_currency = $request->get('deposit_currency');
        $insert_info = $request->get('sub_info');
        $other_amount = $request->get('other_amount');
        $arr_cus_dep = array();
        $user = Auth::user();
        if($distrute_type == "customer"){
            foreach(json_decode($insert_info) as $val){
                $arr_cus_dep = array('deposit_amount' => $val->amount,
                'customer_id' => $val->cus_id,
                'deposit_income_id' => $deposit_id,
                'customer_deposit_type' => 'customer_deposit',
                'create_date' => date("Y-m-d H:i:s"),
                'customer_deposit_currency'=> $deposit_currency,
                'author_id' => $user->staff_id
                );

                $check_amount_dis = Income_model::check_amount_distribute('customer_deposit',$deposit_id,$deposit_currency,date("Y-m-d"),$val->amount,$val->cus_id,$user->staff_id);
                if(count($check_amount_dis) <= 0){
                   // insert money to customer acc
                    Income_model::insert_data_customer_deposit($arr_cus_dep); 
                }
            }
        }else if($distrute_type == "auction_dep"){
            foreach(json_decode($insert_info) as $val){
                $arr_cus_dep = array('deposit_amount' => $val->amount,
                                    'customer_id' => $val->cus_id,
                                    'deposit_income_id' => $deposit_id,
                                    'customer_deposit_type' => 'customer_auction_deposit',
                                    'create_date' => date("Y-m-d H:i:s"),
                                    'customer_deposit_currency'=> $deposit_currency,
                                    'author_id' => $user->staff_id
                );

                $check_amount_dis = Income_model::check_amount_distribute('customer_auction_deposit',$deposit_id,$deposit_currency,date("Y-m-d"),$val->amount,$val->cus_id,$user->staff_id);
                if(count($check_amount_dis) <= 0){
                   // insert money to customer acc
                    Income_model::insert_data_customer_deposit($arr_cus_dep); 
                }
            }
        }else{
            $deposit_type = "";
            if($distrute_type == "without_chassis"){
                $deposit_type = "without_chassis";
            }else if($distrute_type == "with_chassis"){
                $deposit_type = "with_chassis";
            }else if($distrute_type == "furike"){
                $deposit_type = "furikae";
            }
            $arr_cus_dep = array('deposit_amount' => $other_amount,
                            'deposit_income_id' => $deposit_id,
                            'customer_deposit_type' => $deposit_type,
                            'create_date' => date("Y-m-d H:i:s"),
                            'customer_deposit_currency'=> $deposit_currency,
                            'author_id' => $user->staff_id
            );
            $check_amount_dis = Income_model::check_amount_distribute_other($deposit_type,$deposit_id,$deposit_currency,date("Y-m-d"),$other_amount,$user->staff_id);
            if(count($check_amount_dis) <= 0){
               // insert money to customer acc
                Income_model::insert_data_customer_deposit($arr_cus_dep); 
            }
        }
        return response()->json([
           'status' => true,
            'message' => 'Distribute successfully'
        ]);
    }

    public function history_deposit_detail(Request $request){
        $deposit_income_id = $request->get('deposit_id');
        $data['deposit_info'] = Income_model::get_deposit_info_by_id($deposit_income_id);
        return response()->json([
            $data
        ]);
    }

    public function get_detail_car(Request $request){
        $customer_deposit_id = $request->get('customer_deposit');
        $data['dep_info'] = Income_model::get_deposit_info( $customer_deposit_id);
        $data['car_pay_info'] = Income_model::get_car_info_customer_id($customer_deposit_id);
        return response()->json([
            $data 
        ]);
    }

    public function delete_allocate(Request $request){
        $pay_id = $request->get('pay_id');
        $cus_id = $request->get('cus_id');
        if(!empty($pay_id)){
            $stock_id = Income_model::getStockIdByCarpaymentId($pay_id);
            DB::table('erp_carpayments')
              ->where('car_payment_id','=',$pay_id)
              ->delete();

            $this->execute_update_car_profit_and_car_status($stock_id);

            $cus_ids = $this->get_customer_id_by_dep_id($cus_id);
            Customer_account_update::update_customer_remain($cus_ids);
            return response()->json([
                'status' => true,
                'message' => 'successfully'
            ]);
        }
    }

    function get_customer_id_by_dep_id($cus_dep_id){
        $dep_info = Income_model::get_customer_id_by_dep_ids($cus_dep_id);
        $cus_id ='';
        if(count($dep_info) > 0){
            foreach ($dep_info as $val) {
                $cus_id = $val->customer_id;
            }
        }
        
        return $cus_id;

    }

    public  function execute_update_car_profit_and_car_status($stock_id){
        $user = Auth::user();
        $staff_id = $user->staff_id;
        $this->update_profit_delete_allocate($stock_id);
        $stock_arr = array('status' => '2');
        // update car status to reserved
        Income_model::update_car_data($stock_arr,$stock_id);
        // add reserved history
        $status_arr = array(
                        'stock_id'=>$stock_id,
                        'car_status'=>'reserved',
                        'create_date'=>date('Y-m-d H:i:s'),
                        'staff_id'=>$staff_id
                        );
        Income_model::add_history_car($status_arr);	
        
    }

    public function update_profit_delete_allocate($stock){
        $total_cost = $this->get_all_cost_delete_allocate($stock);
        $total_allocate = Income_model::get_total_allocate($stock);
        $get_purpos = Income_model::get_car_status_info($stock);
        $total_amount = 0;
        foreach ($total_allocate as $val) {
            if ($val->car_allocate_currency == "USD") {
                // $total_amount += $val->exchange_amount;
                $exchange_amount = $val->car_allocate * ($val->exchange_rate - 1 );
                 $total_amount += $exchange_amount; 
            }else{
                $total_amount += $val->car_allocate;
            }
        }
        
        // if($total_amount > 0){
            if($get_purpos[0]->purpose == "export"){
                $profit = $total_amount - $total_cost['total_cost']; 
            }else{
                $profit = $total_amount - $total_cost['total_price'];
            }
            $arr_profit = array('profit' => $profit);
            Income_model::update_car_profit($stock,$arr_profit);
        // }
        // echo $total_amount;die;

    }
    function get_all_cost_delete_allocate($stock){
        $result['total_cost'] = 0;
        $result['total_price'] = 0;
        $total_allocate_ex = Income_model::get_total_cost($stock);
        $buying_price = 0;
        $auction_fee = 0;
        $transport_fee = 0;
        $fright_fee = 0;
        $repair = 0;
        $inspect = 0;
        $shipping_charge = 0;
        $tax = 0;
        $car_tax = 0;
        $insurence = 0;
        $recycle = 0;
        $redaition = 0;
        $other_fee_amount = 0;
        $ea_fee = 0;
        $other_refund_amount = 0;
        foreach ($total_allocate_ex as $val) {
            if($val->currency_type == "USD"){
                $buying_price += $val->buying_price * $val->exchange_rate;
                $auction_fee += $val->auction_fee * $val->exchange_rate;
                $transport_fee += $val->transportation_fee * $val->exchange_rate;
                $fright_fee += $val->freight_fee * $val->exchange_rate;
                $repair += $val->repair_fee * $val->exchange_rate;
                $inspect += $val->inspection_fee * $val->exchange_rate;
                $shipping_charge += $val->shipping_charge_fee * $val->exchange_rate;
                $tax += $val->tax_fee * $val->exchange_rate;
                $car_tax += $val->car_tax_fee * $val->exchange_rate;
                $insurence += $val->insurance_fee * $val->exchange_rate;
                $recycle += $val->recycle_fee * $val->exchange_rate;
                $redaition += $val->rediation_fee * $val->exchange_rate;
                $ea_fee += $val->ea_fee * $val->exchange_rate;
                $other_fee_amount += $val->total_other_fee * $val->exchange_rate;
                $other_refund_amount += $val->total_other_refund * $val->exchange_rate;

            }else{

                $buying_price += $val->buying_price;
                $auction_fee += $val->auction_fee;
                $transport_fee += $val->transportation_fee;
                $fright_fee += $val->freight_fee;
                $repair += $val->repair_fee;
                $inspect += $val->inspection_fee;
                $shipping_charge += $val->shipping_charge_fee;
                $tax += $val->tax_fee;
                $car_tax += $val->car_tax_fee;
                $insurence += $val->insurance_fee;
                $recycle += $val->recycle_fee;
                $redaition += $val->rediation_fee;
                $ea_fee += $val->ea_fee;
                $other_fee_amount += $val->total_other_fee;
                $other_refund_amount += $val->total_other_refund;
            }
              
        }
        $result['total_cost'] = $buying_price + $auction_fee + $car_tax + $transport_fee + $fright_fee + $repair + $inspect + $shipping_charge + $other_fee_amount + $redaition + $insurence + $ea_fee;
        $result['total_price']= $buying_price + $auction_fee + $car_tax + $transport_fee + $fright_fee + $repair + $inspect + $shipping_charge + $other_fee_amount + $redaition + $tax + $recycle + $other_refund_amount + $insurence + $ea_fee;
        return $result;
    }

    public function get_excel_export_history(Request $request){
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/test.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
       
        $from_date = $request->get('from_date');
        $sch_sender = $request->get('sch_sender');
        $to_date = $request->get('to_date');
        $txt_search_date = '';
        $txt_search_left = '';
        $txt_search_to_date = '';
        if(!empty($from_date)){
            $txt_search_date = $from_date;
        }
        if(!empty($sch_sender)){
            $txt_search_left = trim($sch_sender);
        }
        if(!empty($to_date)){
            $txt_search_to_date =  $to_date;
        }
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list($user->staff_id);
        $empRecord = Income_model::income_deposit_history_excel($hide_pakistan,$txt_search_left,$txt_search_date,$txt_search_to_date);

        $k = 1;
        foreach($empRecord as $val){
            $k += 1;
            if($val->deposit_currency=="USD"){
                $curreny_symbol = "$";
                $deposit_raw = number_format($val->deposit_raw,2);
            }else{
                $curreny_symbol = "¥";
                $deposit_raw = number_format($val->deposit_raw);
            }
            
            $objPHPExcel->getActiveSheet()->setCellValue('A'.$k,date_format(date_create($val->deposit_date),'Y-m-d'));
            $objPHPExcel->getActiveSheet()->setCellValue('B'.$k, $val->bank_full_name);
            $objPHPExcel->getActiveSheet()->setCellValue('C'.$k, $val->description);
            $objPHPExcel->getActiveSheet()->setCellValue('D'.$k, $curreny_symbol.' '.$deposit_raw);
            $get_data_check_type = Income_model::get_data_check_type($val->deposit_income_id);
            foreach($get_data_check_type as  $key1 => $value){
                if($value->customer_deposit_type == 'customer_deposit' || $value->customer_deposit_type == 'customer_auction_deposit'){
                    $car_pay_info =Income_model::get_car_info_for_excel($value->customer_deposit_id);
                    foreach($car_pay_info as $key => $row ){
                        $objPHPExcel->getActiveSheet()->setCellValue('E'.$k,date_format(date_create($row->etd),'Y-m-d'));
                        if($row->car_allocate_origin_currency=="USD"){
                            $curreny = "$";
                            $car_allocate_origin = number_format($row->car_allocate_origin,2);
                        }else{
                            $curreny = "¥";
                            $car_allocate_origin = number_format($row->car_allocate_origin);
                        }
                        $objPHPExcel->getActiveSheet()->setCellValue('F'.$k, $row->chassis_number);
                        $objPHPExcel->getActiveSheet()->setCellValue('G'.$k, $curreny.' '.$car_allocate_origin);  
                        $k += 1;
                    }      
                }else{
                    if($value->customer_deposit_currency=="USD"){
                        $curreny = "$";
                        $deposit_amount = number_format($value->deposit_amount,2);
                    }else{
                        $curreny = "¥";
                        $deposit_amount = number_format($value->deposit_amount);
                    }
                    $objPHPExcel->getActiveSheet()->setCellValue('F'.$k, $value->customer_deposit_type);
                    $objPHPExcel->getActiveSheet()->setCellValue('G'.$k, $curreny.' '.$deposit_amount);      
                }
                     if($key1+1 == COUNT($get_data_check_type)){
                            $k -= 1;
                        }
            } 
        }
            //boder all
            $border_all = array(
            'borders' => array(
                'allBorders' => array(
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                )
            )
        );

        $objPHPExcel->getActiveSheet()->getStyle('A2:G'.$k)->applyFromArray($border_all);
       
        $objPHPExcel->getActiveSheet()->setAutoFilter('A1:BZ5000');
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Excel Staff');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="invoice.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        return response()->json([
            $writer->save('php://output')
        ]);
    }

    function GetIncomeInfo(Request $request){
        $date_dep = $request->get('date_dep');
        $cus_name = trim($request->get('cus_name'));
        $perPage = $request->get('perPage');
        $tab_customer = $request->get('tap_type');
     
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list($user->staff_id);
    if($tab_customer == 'Customer Acc.'){
        //customer_acount
        $data['customer_deposit_list']   = Income_model::customer_deposit($hide_pakistan,$perPage,$cus_name,$date_dep);
    }else if($tab_customer == 'Customer Acc. His.'){
        // customer_acount_history
        $data['customer_deposit_list']=Income_model::get_customer_history_list($hide_pakistan,$perPage,$cus_name,$date_dep);
    }else if($tab_customer == 'With Cha.'){
        // with_chassis
        $data['customer_deposit_list']=Income_model::customer_with_chassis($hide_pakistan,$perPage,$date_dep);

    }else if($tab_customer == 'With Cha. His.'){
        //with_chassis_history
        $data['customer_deposit_list']=Income_model::customer_with_chassis_history($hide_pakistan,$perPage,$date_dep);
    }else if($tab_customer == 'Without Cha.'){
        //without_chassis
        $data['customer_deposit_list']=Income_model::customer_without_chassis($hide_pakistan,$perPage,$date_dep);
    }else if($tab_customer == 'Auction Dep'){
        //auction_deposit
        $data['customer_deposit_list']=Income_model::get_customer_auction($hide_pakistan,$perPage,$cus_name,$date_dep);
        
    }else if($tab_customer == 'Furikae'){
        //furikae
        $data['customer_deposit_list']=Income_model::customer_furikae($hide_pakistan,$perPage,$date_dep);
    }

        return response()->json([
           $data
        ]);
    }

    public function customer_allocate(Request $request){
        $cus_id = $request->get('customer_deposit');
        $data['cusr_dep_info'] = Income_model::get_customer_deposit_by_id($cus_id);
        $grand_deposit = 0;
        $grand_total = 0;
        $grand_totals = 0;
        $grand_date = '';
        $grand_currency = '';
        $first_record = array();
        $car_list = array();
        foreach($data['cusr_dep_info'] as $cus_info){
            $grand_deposit =number_format($cus_info->deposit_amount,2);
            $grand_total += $cus_info->deposit_amount;
            $grand_totals = $grand_total;
            $grand_date = $cus_info->create_date;
            $grand_currency =$cus_info->customer_deposit_currency;
            $car_lists = DB::table('erp_carpayments')
              ->select('*')
              ->join('erp_stock_list','erp_stock_list.stock_id','=','erp_carpayments.stock_id')
              ->where('customer_deposit_id','=',$cus_info->customer_deposit_id)
              ->get();
              foreach($car_lists as $row){
                 $grand_total = $grand_total - $row->car_allocate_origin;
                 switch ($row->car_allocate_origin_currency) {
                    case "USD":
                        $currency_type = "$";
                        break;
                    case "JPY":
                        $currency_type = "¥";
                        break;
                    default:
                        $currency_type = "¥";
                  }
                  $am_origin = number_format($row->car_allocate_origin,2);
                  $origin_str = str_replace('.00','', $am_origin);  
                  $am_balance_origin = number_format($grand_total,2);
                  $balance_str_origin = str_replace('.00','', $am_balance_origin);
                   array_push($car_list,array(
                    'currency_type' =>$currency_type,
                    'car_allocate_origin' => $origin_str,
                    'chassis_number' => $row->chassis_number,
                    'stock_id' => $row->stock_id,
                    'balance_str_origin' => $balance_str_origin,
                    'car_payment_id' => $row->car_payment_id,
                    'create_date' => $row->create_date,
                   ));
              }
        }

        if($grand_currency == 'JPY'){
            $curreny = ' ¥';
        }else{
            $curreny = ' $';
        }
        $first_record = array([
            'grand_deposit' => $grand_deposit.$curreny,
            'grand_total' => $grand_totals.$curreny,
            'grand_date' => $grand_date,
            'grand_currency' =>  $grand_currency
         ]);
        
        $data['first_record'] = $first_record;
        $data['car_list_allocated'] = $car_list;
        $data['cus_dep_id'] = $cus_id;
        return response()->json([
            $data
        ]);
    }

    public function delete_allocate_customer(Request $request){
        $pay_id = $request->get('pay_id');
        $cus_id = $request->get('dep_id');
        if(!empty($pay_id)){
            $stock_id = Income_model::getStockIdByCarpaymentId($pay_id);
            $cus_ids = $this->get_customer_id_by_dep_id($cus_id);
            Customer_account_update::update_customer_remain($cus_ids);
            DB::table('erp_carpayments')
              ->where('car_payment_id','=',$pay_id)
              ->delete();
            $this->execute_update_car_profit_and_car_status($stock_id);
            return response()->json([
               'status' => true,
               'message' => 'succesfully'
            ]);
        }
    }

    public function car_allocate(request $request){
        $cus_dep_id = $request->get('CusDepId');
        $data['customer_dep_info'] =Income_model::get_customer_dep_info($cus_dep_id);
        $get_all_car_cus =Income_model::get_all_car_by_cus_id($data['customer_dep_info'][0]->customer_id);

        $data_info = array();
        $car_allocate = 0;
        $total_sold_price = 0;
        foreach($get_all_car_cus as $value){
          
            if(!empty($value->car_allocate)){
                $car_allocate = $value->car_allocate;
            }
         
            if(!empty($value->total_sold_price)){
                $total_sold_price = $value->total_sold_price;
            }
            array_push($data_info, array(
                'stock_id' => $value->stock_id,
                'chassis_number' =>$value->chassis_number,
                'car_model_name' =>$value->car_model_name,
                'total_sold_price' =>$total_sold_price,
                'currency' => $value->currency,
                'car_allocate' => $car_allocate,
                'car_allocate_currency' => $value->car_allocate_currency
            ));
        }
        $data['customer_id'] = $data['customer_dep_info'][0]->customer_id;
        $data['get_all_car_cus'] = $data_info;
        return response()->json([
            $data
         ]);
    }

    public function get_chassis_search(Request $request){
        $sch_condition = $request->get('search_condition');
        $search_word = $request->get('search_word');
        $cus_Depid = $request->get('CustomerID');
        $car_list = Income_model::get_car_info_by_cus_id($cus_Depid,$search_word);
        $car_info =  array();
        foreach($car_list as $value){
            if(!empty($value->car_allocate)){
                $car_allocate = $value->car_allocate;
            }else{
                $car_allocate = '0';
            }
            $total_sold_price = 0;
            if(!empty($value->total_sold_price)){
                $total_sold_price = $value->total_sold_price;
            }
            array_push($car_info, array(
                'stock_id' => $value->stock_id,
                'chassis_number' =>$value->chassis_number,
                'car_model_name' =>$value->car_model_name,
                'total_sold_price' =>$total_sold_price,
                'currency' => $value->currency,
                'car_allocate' => $car_allocate,
                'car_allocate_currency' => $value->car_allocate_currency
            ));
        }
        return response()->json([
            'car_info' => $car_info
         ]);
    }

    public function car_allocate_excecute(Request $request){
        $customer_dep_id = $request->get('customer_dep_id');
        $insert_info = $request->get('sub_info');
        $customer_id = $request->get('customer_id');
        $balance_cur = $request->get('balance_cur');
        $dep_date = $request->get('deposit_date');
        $user = Auth::user();
        $user_id = $user->staff_id;
        
        foreach(json_decode($insert_info) as $val){
           $stock_id =  $val->stock_id;
           $car_info = Income_model::get_car_info_by_stock_id($stock_id);
           
           $where['from_currency']="USD";
           $where['to_currency']="JPY";
           $where['exchange_dt']=$dep_date;
           $get_exchanges = Income_model::get_exchange_rate($where);
           
           $where['from_currency']="JPY";
           $where['to_currency']="USD";
           $where['exchange_dt']=$dep_date;
           $get_exchange = Income_model::get_exchange_rate($where);

           if(count($get_exchange) > 0){
               $get_jpy_to_usd = $get_exchange[0]->exchange_rate;
           }else{
               $get_jpy_to_usd = 0;
           }
           
            if(count($get_exchanges) > 0){
                $get_usd_to_jpy1 = $get_exchanges[0]->exchange_rate;
                $get_usd_to_jpy = $get_usd_to_jpy1 - 1;
            }else{
                $get_usd_to_jpy = 0;
            }

            if( $balance_cur== "USD"){
                $car_allocate = $val->amount * $get_usd_to_jpy;
                if($car_info[0]->currency =="USD"){
                    $arr_car_allocate = array('stock_id' => $stock_id,
                                            'customer_deposit_id' => $customer_dep_id,
                                            'car_allocate' => $val->amount,
                                            'car_allocate_currency' => $balance_cur,
                                            'car_allocate_origin' => $val->amount,
                                            'car_allocate_origin_currency' => $balance_cur,
                                            'payment_type' => 'customer_deposit',
                                            'exchange_date' => $dep_date,
                                            'exchange_rate' => $get_usd_to_jpy,
                                            'exchange_amount' => $car_allocate,
                                            'create_date' => date("Y-m-d H:i:s"),
                                            'author_id' => $user_id);
                                           
                    $check_allocate =Income_model::check_allocate_duble($arr_car_allocate);
                 
                    if(count($check_allocate) <= 0){
                       Income_model::insert_car_payment_data($arr_car_allocate);
                    }
                }else{
                    $arr_car_allocate = array('stock_id' => $stock_id,
                                            'customer_deposit_id' => $customer_dep_id,
                                            'car_allocate' => $car_allocate,
                                            'car_allocate_currency' => $car_info[0]->currency,
                                            'car_allocate_origin' => $val->car_allocate,
                                            'car_allocate_origin_currency' => $balance_cur,
                                            'payment_type' => 'customer_deposit',
                                            'exchange_date' => $dep_date,
                                            'exchange_rate' => $get_usd_to_jpy,
                                            'exchange_amount' => $car_allocate,
                                            'create_date' => date("Y-m-d H:i:s"),
                                           'author_id' => $user_id);
                    $check_allocate = Income_model::check_allocate_duble($arr_car_allocate);
                    if(count($check_allocate) <= 0){
                        Income_model::insert_car_payment_data($arr_car_allocate);
                    }
                }
            }else{
                if($car_info[0]->currency =="JPY"){
                    $arr_car_allocate = array('stock_id' => $stock_id,
                                            'customer_deposit_id' => $customer_dep_id,
                                            'car_allocate' => $val->amount,
                                            'car_allocate_currency' => $balance_cur,
                                            'car_allocate_origin' => $val->amount,
                                            'car_allocate_origin_currency' => $balance_cur,
                                            'payment_type' => 'customer_deposit',
                                            'exchange_amount' => $val->amount,
                                            'create_date' => date("Y-m-d H:i:s"),
                                            'author_id' => $user_id);
                    $check_allocate = Income_model::check_allocate_duble($arr_car_allocate);
                    if(count($check_allocate) <= 0){
                        Income_model::insert_car_payment_data($arr_car_allocate);
                    }

                }else{
                    $car_allocate = $val->amount * $get_jpy_to_usd;
                    $arr_car_allocate = array('stock_id' => $stock_id,
                                            'customer_deposit_id' => $customer_dep_id,
                                            'car_allocate' => $car_allocate,
                                            'car_allocate_currency' => $car_info[0]->currency,
                                            'car_allocate_origin' => $val->amount,
                                            'car_allocate_origin_currency' => $balance_cur,
                                            'payment_type' => 'customer_deposit',
                                            'exchange_date' => $dep_date,
                                            'exchange_rate' => $get_jpy_to_usd,
                                            'exchange_amount' => $val->amount,
                                            'create_date' => date("Y-m-d H:i:s"),
                                            'author_id' => $user_id);
                    $check_allocate =  Income_model::check_allocate_duble($arr_car_allocate);
                    if(count($check_allocate) <= 0){
                        Income_model::insert_car_payment_data($arr_car_allocate);
                    }
                    
                }
            }

            $this->update_profit($stock_id);
            Status_update::update_car_status($stock_id,$customer_id,$user_id);
            Status_update::update_releasebl_status($stock_id,$user_id);
            Status_update::update_soldout_status($stock_id,$user_id);
            Customer_account_update::update_customer_remain($customer_id);
    
            return response()->json([
                'status' => true,
                'cusdep_id' => $customer_dep_id,
                'message' => 'Allocate Completed!!!!'
            ]);
        }
       
    }

    public function update_profit($id){
        $total_cost = $this->get_all_cost($id);
        $total_allocate = Income_model::get_total_allocate($id);
        $get_purpos = Income_model::get_car_status_info($id);
        $total_amount = 0;

        foreach ($total_allocate as $val) {
            if ($val->car_allocate_currency == "USD") {
                $exchange_amount = $val->car_allocate * ($val->exchange_rate - 1 );
                 $total_amount += $exchange_amount; 
            }else{
                $total_amount += $val->car_allocate;
            }
        }
        if($get_purpos[0]->purpose == "export"){
            $profit = $total_amount - @$total_cost['total_cost']; 
        }else{
            $profit = $total_amount - @$total_cost['total_price'];
        }
        $arr_profit = array('profit' => $profit);
        Income_model::update_car_profit($id,$arr_profit);
    }
    public function get_all_cost($id){
        $result['total_cost'] = 0;
        $result['total_price'] = 0;
        $total_allocate_ex = Income_model::get_total_cost($id);
        $buying_price = 0;
        $auction_fee = 0;
        $transport_fee = 0;
        $fright_fee = 0;
        $repair = 0;
        $inspect = 0;
        $shipping_charge = 0;
        $tax = 0;
        $car_tax = 0;
        $insurence = 0;
        $recycle = 0;
        $redaition = 0;
        $other_fee_amount = 0;
        $ea_fee = 0;
        $other_refund_amount = 0;
        foreach($total_allocate_ex as $val){
            if($val->currency_type == "USD"){
                $buying_price += $val->buying_price * $val->exchange_rate;
                $auction_fee += $val->auction_fee * $val->exchange_rate;
                $transport_fee += $val->transportation_fee * $val->exchange_rate;
                $fright_fee += $val->freight_fee * $val->exchange_rate;
                $repair += $val->repair_fee * $val->exchange_rate;
                $inspect += $val->inspection_fee * $val->exchange_rate;
                $shipping_charge += $val->shipping_charge_fee * $val->exchange_rate;
                $tax += $val->tax_fee * $val->exchange_rate;
                $car_tax += $val->car_tax_fee * $val->exchange_rate;
                $insurence += $val->insurance_fee * $val->exchange_rate;
                $recycle += $val->recycle_fee * $val->exchange_rate;
                $redaition += $val->rediation_fee * $val->exchange_rate;
                $ea_fee += $val->ea_fee * $val->exchange_rate;
                $other_fee_amount += $val->total_other_fee * $val->exchange_rate;
                $other_refund_amount += $val->total_other_refund * $val->exchange_rate;

            }else{

                $buying_price += $val->buying_price;
                $auction_fee += $val->auction_fee;
                $transport_fee += $val->transportation_fee;
                $fright_fee += $val->freight_fee;
                $repair += $val->repair_fee;
                $inspect += $val->inspection_fee;
                $shipping_charge += $val->shipping_charge_fee;
                $tax += $val->tax_fee;
                $car_tax += $val->car_tax_fee;
                $insurence += $val->insurance_fee;
                $recycle += $val->recycle_fee;
                $redaition += $val->rediation_fee;
                $ea_fee += $val->ea_fee;
                $other_fee_amount += $val->total_other_fee;
                $other_refund_amount += $val->total_other_refund;
            }
            $result['total_cost'] = $buying_price + $auction_fee + $car_tax + $transport_fee + $fright_fee + $repair + $inspect + $shipping_charge + $other_fee_amount + $redaition + $insurence + $ea_fee;
            $result['total_price']= $buying_price + $auction_fee + $car_tax + $transport_fee + $fright_fee + $repair + $inspect + $shipping_charge + $other_fee_amount + $redaition + $tax + $recycle + $other_refund_amount + $insurence + $ea_fee;
            return $result;
        }
    }

    public function return_money_back(Request $request){
        $deposit_id = $request->get('customer_deposit');
        if(!empty($deposit_id)){
            $cus_id = $this->get_customer_id_by_dep_id($deposit_id);
            Customer_account_update::update_customer_remain($cus_id);
            // delete from carpayment
           DB::table('erp_carpayments')
             ->where('customer_deposit_id','=',$deposit_id)
             ->where('payment_type','=','customer_deposit')
             ->delete();
           // delete from customer deposit
           DB::table('erp_customer_deposit')
             ->where('customer_deposit_id','=',$deposit_id)
             ->delete();
             return response()->json([
                'status' => true,
                'message' => 'Return back successfully!'
            ]);
        }
    }

    public function customer_allocate_with_chassis(Request $request){
        $cus_id = $request->get('customer_deposit');
        $data['cus_dep_id'] = $cus_id;
        $data['customer_dep_info'] = Income_model::get_customer_info_cus_dep_id($cus_id);
        return response()->json([
            $data
        ]);

    }

    public function check_chassis(Request $request){
        $chassis  = $request->get('chassis_no');
        $chassis_no = str_replace('%20'," ",$chassis);
        $chassis_status = Income_model::getStatusChassis($chassis_no);
        if($chassis_status >= 1){
            $status = "yes";
        }else{
            $status = "no";
        }
        return response()->json([
            'status' => $status
        ]);
    }

    public function save_with_chassis(Request $request){
        $deposit_income_id = $request->get('dep_income_id');
        $customer_dep_id = $request->get('CusDepId');
        $currency_dep = $request->get('dep_cur');
        $income_info = $request->get('income_info');
        $expense_info = $request->get('expense_info');
        // dd($deposit_income_id.' / '.$customer_dep_id.' / '.$currency_dep.' / '.$income_info.' / '.$expense_info);
        $user = Auth::user();
        $date_deposit_income = @Income_model::getDataDepositIncomeById($deposit_income_id);
      
        $exchageRateByDateDepositIncome = @Income_model::getExchangeRateByDate($date_deposit_income[0]->deposit_date,"USD","JPY")[0]->exchange_rate;
    
        $check = is_array(json_decode($income_info)) ? count(json_decode($income_info)) : 0;
        if($check > 0){
            foreach(json_decode($income_info) as $income){
                $stock_id =Income_model::get_stock_id_by_chassis(trim($income->chassis_no));
         
                if($income->chassis_no == "without chassis"){
                    $inc_arr = array('stock_id' => $stock_id,
                                'customer_deposit_id' => $customer_dep_id,
                                'car_allocate' => $income->amount,
                                'car_allocate_origin' => $income->amount,
                                'car_allocate_currency' => $currency_dep,
                                'car_allocate_origin_currency' => $currency_dep,
                                'exchange_amount' => $income->amount,
                                'create_date' => date('Y-m-d H:i:s'),
                                'author_id' => $user->staff_id,
                                'payment_type' => 'without_chassis',
                                'allocate_title' => $income->title
                                 );
                }else{
                    $car_allocate = $income->amount;
                    $ex_rate = null;
                    $ex_date = null; 
                    if($currency_dep == "USD"){
                        $car_allocate = $this->convertUSDToJPY($car_allocate,$exchageRateByDateDepositIncome);
                        $ex_rate = $exchageRateByDateDepositIncome;
                        $ex_date = date("Y-m-d", strtotime($date_deposit_income[0]->deposit_date));
                    }
                   

                    $inc_arr = array('stock_id' => $stock_id,
                                'customer_deposit_id' => $customer_dep_id,
                                'car_allocate' => $car_allocate,
                                'car_allocate_origin' => $income->amount,
                                'car_allocate_currency' => 'JPY',
                                'car_allocate_origin_currency' => $currency_dep,
                                'exchange_amount' => $car_allocate,
                                'create_date' => date('Y-m-d H:i:s'),
                                'author_id' => $user->staff_id,
                                'allocate_title' => $income->title,
                                'exchange_rate'=>$ex_rate,
                                'exchange_date'=>$ex_date
                    );
                }
              
                Income_model::insert_withchassis($inc_arr);
            }
        }

        $check_expense = is_array(json_decode($expense_info)) ? count(json_decode($expense_info)) : 0;
        if($check_expense > 0){
            foreach(json_decode($expense_info) as $expense){
                $stock_id = Income_model::get_stock_id_by_chassis(trim($expense->chassis_no));
                
                $unit_price_ex='0';
                $auctionfee_ex='0';
                $transport_ex='0';
                $refundfee_ex='0';
                $tax_ex='0';
                $cartax_ex='0';
                $freight_ex='0';
                $repair_ex='0';
                $inspection_ex='0';
                $shipping_ex='0';
                $otherfee_ex='0';
                $otherrefund_ex='0';
                $without_ex ='0';
                $other_refund_title_ex="";
                $other_fee_title_ex="";
                $other_fee_date_ex="";
                $other_fee_currency_ex="";

                $ex_stat = $expense->paymentEType;
                $car_allocate_ex = $expense->amount;
                if($ex_stat=='buying_price'){
                   $unit_price_ex = $car_allocate_ex;
                }
                if($ex_stat=='auctionfee'){
                    $auctionfee_ex =$car_allocate_ex;
                }
                if($ex_stat=='transportation'){
                    $transport_ex =$car_allocate_ex;
                }
                if($ex_stat=='tax'){
                    $tax_ex =$car_allocate_ex;
                }
                if($ex_stat=='car_tax'){
                    $cartax_ex =$car_allocate_ex;
                }
                if($ex_stat=='recycle_fee'){
                    $refundfee_ex =$car_allocate_ex;
                }
                if($ex_stat=='freight'){
                    $freight_ex =$car_allocate_ex;
                }
                if($ex_stat=='repair'){
                    $repair_ex =$car_allocate_ex;
                }
                if($ex_stat=='inspection'){
                    $inspection_ex =$car_allocate_ex;
                }
                if($ex_stat=='shipping_charg'){
                    $shipping_ex =$car_allocate_ex;
                }
                if($ex_stat=='without_chassis'){
                    $without_ex =$car_allocate_ex;
                }
                $ex_arr = array('buying_price' => $unit_price_ex,
                                'auction_fee' => $auctionfee_ex,
                                'transportation_fee' => $transport_ex,
                                'recycle_fee' => $refundfee_ex,
                                'freight_fee' => $freight_ex,
                                'repair_fee' => $repair_ex,
                                'inspection_fee' => $inspection_ex,
                                'shipping_charge_fee' => $shipping_ex,
                                'tax_fee' => $tax_ex,
                                'car_tax_fee' => $cartax_ex,
                                'without_chassis' => $without_ex,
                                'stock_id'=>$stock_id,
                                'created_date'=>date("Y-m-d H:i:s"),
                                'customer_deposit_id'=>$customer_dep_id,
                                'staff_id' =>$user->staff_id
                                );
                               
                Income_model::insert_car_expense($ex_arr);
                $expense_id = Income_model::get_last_car_expense_id();
                if($ex_stat=='other_refund'){
                    $o_refund_arr = array('car_expense_id' => $expense_id,
                                        'title' => $expense->title,
                                        'amount' => $car_allocate_ex,
                                        'currency_type' => $currency_dep,
                                        'create_date' => date("Y-m-d H:i:s"),
                                        );
                    Income_model::insert_car_expense_other_refund($o_refund_arr);
                  
                }
              
                if($ex_stat=='other_fee'){
                    $o_fee_arr = array('car_expense_id' => $expense_id,
                                        'title' => $expense->title,
                                        'amount' => $car_allocate_ex,
                                        'currency_type' => $currency_dep,
                                        'create_date' => date("Y-m-d H:i:s"),
                                        );
                    Income_model::insert_car_expense_other_fee($o_fee_arr);
                }
            }
        }
        return response()->json([
            'status' => true,
            'message' => 'You have allocate successfully.'
        ]);
    }
    function convertUSDToJPY($priceUSD,$exchangeRate){
        $exRate = $exchangeRate - 1;
        $total = $priceUSD * $exRate;
        return round($total);
    }

    public function with_chassis_history_detail(Request $request){
        $cus_id = $request->get('CusDepId');
        $data['income_car'] = Income_model::get_income_car_cus_dep_id($cus_id);
        $expense_car = Income_model::get_expense_car_cus_dep_id($cus_id);
        $data_expense = array();
        $table = '';
      
        foreach($expense_car as $val){
            $type = "";
            $amount = "";
            $check = "";
            if($val->buying_price > 0){
              $type = "Buying Price";
              $amount = $val->buying_price;
              $check = "1";
            }elseif($val->auction_fee> 0){
              $type = "Auction Fee";
              $amount = $val->auction_fee;
              $check = "1";
            }elseif($val->transportation_fee> 0){
              $type = "Transparation Fee";
              $amount = $val->transportation_fee;
              $check = "1";
            }elseif($val->freight_fee> 0){
              $type = "Freight Fee";
              $amount = $val->freight_fee;
              $check = "1";
            }elseif($val->repair_fee> 0){
              $type = "Repair Fee";
              $amount = $val->repair_fee;
              $check = "1";
            }elseif($val->inspection_fee> 0){
              $type = "Inspection fee";
              $amount = $val->inspection_fee;
              $check = "1";
            }elseif($val->shipping_charge_fee> 0){
              $type = "Shipping Charge Fee";
              $amount = $val->shipping_charge_fee;
              $check = "1";
            }elseif($val->insurance_fee> 0){
              $type = "Insurance Fee";
              $amount = $val->insurance_fee;
              $check = "1";
            }elseif($val->tax_fee> 0){
              $type = "Tax Fee";
              $amount = $val->tax_fee;
              $check = "1";
            }elseif($val->car_tax_fee> 0){
              $type = "Car Tax Fee";
              $amount = $val->car_tax_fee;
              $check = "1";
            }elseif($val->recycle_fee> 0){
              $type = "Recycle Fee";
              $amount = $val->recycle_fee;
              $check = "1";
            }
            elseif($val->without_chassis> 0){
              $type = "Without Chassis";
              $amount = $val->without_chassis;
              $check = "1";
            }

            if($val->buying_price > 0 || $val->auction_fee > 0 || $val->transportation_fee > 0 || $val->freight_fee > 0 || $val->repair_fee > 0 || $val->inspection_fee > 0 || $val->shipping_charge_fee > 0 || $val->insurance_fee > 0 || $val->tax_fee > 0 || $val->car_tax_fee > 0 || $val->recycle_fee > 0 || $val->without_chassis > 0){
                $table .= "<tr>";
                if($val->without_chassis > 0){
                    $table .= "<td>Without Chassis</td>";
                  $table .=  "<td></td>";
                }else{
                    $table .=  "<td><a href='/viewdetail/$val->stock_id' target='_blank' style='text-decoration: none;'>".$val->chassis_number."</a></td>";
                   $table .= "<td>".$type."</td>";
                }
                  $table .= "<td></td>";
                  $table .= "<td>".$amount."</td>";
                   $table .= "<td>JPY</td>";
                   $table .=  "</tr>";
              }
            $sql ="SELECT * FROM erp_car_expenses_other_fee WHERE car_expense_id=".$val->car_expense_id;
            $car_expenses_other_fee = DB::select($sql);
            foreach ($car_expenses_other_fee as $row) {
                $table .=  "<tr>";
                 $table .=  "<td><a href='/viewdetail/$val->stock_id' target='_blank' style='text-decoration: none;'>".$val->chassis_number."</a></td>";
                 $table .=  "<td>Other Fee</td>";
                 $table .=  "<td>".$row->title."</td>";
                 $table .=  "<td>".$row->amount."</td>";
                 $table .=  "<td>JPY</td>";
               $table .=  "</tr>";
              }
            $sql1 ="SELECT * FROM erp_car_expenses_other_refund WHERE car_expense_id=".$val->car_expense_id;
            $car_expenses_other_refund = DB::select($sql1);
            foreach($car_expenses_other_refund as $value){
                 $table .= "<tr>";
                 $table .= "<td><a href='/viewdetail/$val->stock_id' target='_blank' style='text-decoration: none;'>".$val->chassis_number."</a></td>";
                 $table .= "<td>Other Refund</td>";
                 $table .= "<td>".$value->title."</td>";
                 $table .= "<td>".$value->amount."</td>";
                 $table .= "<td>JPY</td>";
               $table .= "</tr>";
            }
        }
        $data['expense_car'] = $table;
        return response()->json([
            $data
        ]);
    }

    public function return_money_back_with_cha(Request $request){
        $deposit_id =$request->get('deposit_id');
        $customer_id =$request->get('customer_id');
        $amount =$request->get('re_amount');
        $currency =$request->get('currency');
        $get_car_exp = Expenses_model::get_car_exp_cus_dep_id($customer_id);
        foreach ($get_car_exp as $val) {
            $dt = $val->car_expense_id;
            Expenses_model::remove_other_fee($dt);
            Expenses_model::remove_other_refund($dt);
            Expenses_model::remove_car_expense($dt);
        }
        $where = array('customer_deposit_id' => $customer_id, 'deposit_income_id'=>$deposit_id);
        // $get_depsit_amount =Income_model::get_deposit_income_by_id($deposit_id);
        // $arr_update_dep  = array('deposit_amount' => @$get_depsit_amount[0]->deposit_amount + $amount );
        // Income_model::return_money_dep_with_cha($arr_update_dep, $deposit_id);

        Income_model::delete_money_car_payment_with_cha($customer_id);
        Income_model::return_money_cus_with_cha($where);
        return response()->json([
            'status' => true,
            'message' => 'successfully'
        ]);
    }

    public function return_money_back_without_cha(Request $request){
        $deposit_id =$request->get('deposit_id');
        $customer_id =$request->get('customer_id');
        $amount =$request->get('re_amount');
        $currency =$request->get('currency');
        $where = array('customer_deposit_id' => $customer_id, 'deposit_income_id'=>$deposit_id);
        // $get_depsit_amount = Income_model::get_deposit_income_by_id($deposit_id);
        // $arr_update_dep  = array('deposit_amount' => $get_depsit_amount[0]->deposit_amount + $amount );
        // Income_model::return_money_dep_with_cha($arr_update_dep, $deposit_id);
        Income_model::return_money_cus_with_cha($where);
        return response()->json([
            'status' => true,
            'message' => 'successfully'
        ]);
    }

    public static function return_auction_money_back(Request $request){
        $deposit_id = $request->get('customer_deposit');
        if(!empty($deposit_id)){
            // delete from carpayment
           DB::table('erp_carpayments')
             ->where('customer_deposit_id','=',$deposit_id)
             ->where('payment_type','=','customer_deposit')
             ->delete();
           // delete from customer deposit
           DB::table('erp_customer_deposit')
             ->where('customer_deposit_id','=',$deposit_id)
             ->delete();
            return response()->json([
            'status' => true,
            'message' => 'Return back successfully'
           ]);
        }
    }

    public function return_money_back_with_furikae(Request $request){
        $deposit_id =$request->get('deposit_id');
        $customer_id =$request->get('customer_id');
        $amount =$request->get('re_amount');
        $currency =$request->get('currency');
        $where = array('customer_deposit_id' => $customer_id, 'deposit_income_id'=>$deposit_id);
        // $get_depsit_amount = Income_model::get_deposit_income_by_id($deposit_id);
        // $arr_update_dep  = array('deposit_amount' => $get_depsit_amount[0]->deposit_amount + $amount );
        // Income_model::return_money_dep_with_cha($arr_update_dep, $deposit_id);
        Income_model::return_money_cus_with_cha($where);
        return response()->json([
            'status' => true,
            'message' => 'successfully'
        ]);
    }
}