<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Auth;
use App\Models\Stocklist_model;
use App\Models\Invoice_model;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use Illuminate\Bus\Batchable;
use PDF;

class Invoice extends Controller
{
     function get_data_invoice(Request $request){
        $search = $request->get('search_data');
        $perPage = $request->get('perPage');
        $tabs = '';
        $customer = '';
        $invoice_no = '';
        $min_date = '';
        $max_date = '';
        $chassis_number = '';
        foreach(json_decode($search) as $item){
            $tabs =  $item->type;
            $customer =  @$item->customer;
            $invoice_no =  @$item->invoice_no;
            $min_date = @$item->min_date;
            $max_date =  @$item->max_date;
            $chassis_number = @$item->chassis_number;
        }

    

        $user = Auth::user();
        $permission = $this->data_group_user($user->staff_id);
        $show = array();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list($user->staff_id);
        if($tabs == 'Invoice'){
            $where=array();
            $where_manul =array();
            $where_manul = 'a.invoice_id <>""';
            if(!empty($customer)){
                $where_manul .= 'AND b.customer_id LIKE '.$customer.'' ;
            }
            if(!empty($chassis_number)){
                $where_manul .= ' AND a.chassis_number LIKE "%'.$chassis_number.'%"' ;
            }
            if(!empty($invoice_no)){
                $where['b.invoice_id'] = $invoice_no;
            }
            if(!empty($min_date)){
                $where_manul .= ' AND b.issue_date >= "'.$min_date.'"';
            }
            if(!empty($max_date)){
                $where_manul .= ' AND b.due_date <= "'.$max_date.'"';
            }
            if(!empty($hide_pakistan)){
                $country_list = DB::table('erp_block_countries as t1')
                                ->select('t1.*','c.*')
                                ->leftjoin('erp_block_countries as t2','t1.parent_id','=','t2.parent_id')
                                ->leftjoin('erp_country_list as c','t1.country_list_id','=','c.country_list_id')
                                ->groupBy('t1.country_list_id')
                                ->get();
                foreach  ($country_list as $key => $value) {
                        array_push($show, strtolower($value->country_list_id));
                }
            }
            $invoice_data = DB::table('erp_stock_list AS a')
                    ->select(DB::raw('IFNULL(SUM(c.fob),0) AS totalprices,
                            IFNULL(SUM(c.freight_fee),0) AS freight_fees,
                            IFNULL(SUM(c.insurance),0) AS insurances,
                            IFNULL(SUM(c.discount),0) AS discounts,a.stock_id as stock_id,a.consignee_name,b.invoice_id,b.issue_date,b.due_date,b.bank_account_id,b.invoice_status,c.fob,c.freight_fee,c.inspection,c.staff_id,c.insurance,c.discount,c.currency,d.full_name as customer_name,d.customer_id,d.payment_terms,e.discharge_id,e.discharge_name,f.port_of_loading_id,f.port_of_loading_name,g.bank_full_name,i.full_name,c.final_des_name,a.chassis_number,g.bank_eng_name'))
                    ->leftjoin('erp_invoice as b','b.invoice_id','=','a.invoice_id')
                    ->leftjoin(DB::raw('(SELECT res.fob,res.freight_fee,res.insurance,res.inspection,res.created_dt,res.stock_id, res.currency,res.staff_id,res.hs_code,res.discount,res.vessel,erp_final_destination.final_des_name,res.discharge_id,res.port_of_loading_id FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res LEFT JOIN erp_final_destination ON res.discharge_id = erp_final_destination.id GROUP BY res.stock_id) as c'),'c.stock_id','=','a.stock_id')
                    ->leftjoin('erp_customer AS d','d.customer_id','=','b.customer_id')
                    ->leftjoin('erp_discharge AS e','e.discharge_id','=','c.discharge_id')
                    ->leftjoin('erp_port_of_loading AS f','f.port_of_loading_id','=','c.port_of_loading_id')
                    ->leftjoin('erp_bank_account AS g','g.bank_account_id','=','b.bank_account_id')
                    ->leftjoin('erp_staff AS i','i.staff_id','=','d.staff_id')
                    ->where($where)
                    ->when(!empty($hide_pakistan),function ($v) use ($show) {
                        $v->whereIn(DB::raw('i.country_list_id'),$show);
                    })
                    ->when(!empty($where_manul),function ($v) use ($where_manul) {
                        $v->whereRaw(DB::raw($where_manul));
                    })
                    ->groupBy('a.invoice_id')
                    ->orderBy('b.invoice_id','DESC')
                    ->paginate($perPage);
            $deposite_data = array();
            $totalprices = array();
            $totalallocate = array();
            foreach($invoice_data as $value){
          
                if ($value->discounts=='' || $value->discounts==0) {
                    $discount = '';
                }else{
                    $discount = $value->discounts.' '.$value->currency;
                }
                $totalprices[$value->invoice_id] =$value->totalprices + $value->freight_fees + $value->insurances - $value->discounts;
                $sub_data_customer = DB::table('erp_stock_list AS a')
                                    ->select(DB::Raw('SUM(IF(d.customer_deposit_type="customer_deposit",c.car_allocate_origin,0)) AS totalallocate'))
                                    ->leftjoin('erp_invoice AS b','a.invoice_id','=','b.invoice_id')
                                    ->leftjoin('erp_carpayments AS c','a.car_stock_id','=','c.stock_id')
                                    ->leftjoin('erp_customer_deposit AS d','c.customer_deposit_id','=','d.customer_deposit_id')
                                    ->whereRaw('a.invoice_id <>""')
                                    ->where('a.invoice_id','=',$value->invoice_id)
                                    ->groupBy('a.invoice_id')
                                    ->get();
                        if(COUNT($sub_data_customer) > 0){
                            $deposite_data[$value->invoice_id] = $sub_data_customer[0]->totalallocate;
                        }else{                 
                            $deposite_data[$value->invoice_id]  = 0;
                        }
         }
         $data['invoice_data'] = $invoice_data;
         $data['totalallocate'] = $deposite_data;
         $data['totalprices'] = $totalprices;
         $data['permission'] = $permission;
         $data['bank_accounting'] = array();
        }else{
            $where=array();
            $where_manul =array();
            $where_manul = 'a.invoice_id <>""';
            if(!empty($customer)){
                $where_manul .= 'AND b.customer_id LIKE '.$customer.'' ;
            }
            if(!empty($invoice_no)){
                $where['a.invoice_id'] = $invoice_no;
            }
            if(!empty($min_date)){
                $where_manul .= ' AND a.created_dt >= "'.$min_date.'"';
            }
            if(!empty($max_date)){
                $where_manul .= ' AND a.created_dt <= "'.$max_date.'"';
            }
            $bank_accounting = Invoice_model::select_bank_accounting($hide_pakistan);
            $invoice_data = Invoice_model::select_invoice_items($perPage,$where_manul,$where);
            $data['invoice_data'] = $invoice_data;
            $data['totalallocate'] = 0;
            $data['totalprices'] = 0;
            $data['permission'] = $permission;
            $data['bank_accounting'] = $bank_accounting;
        }
        
        $customer_data = DB::table('erp_customer')
                           ->select('*')
                           ->whereRaw('full_name <> ""')
                           ->orderBy('full_name','ASC')
                           ->get();
       
        $data['customer_data'] = $customer_data;

        return response()->json([
           $data
        ]);
     }

     public function insert_invoice_items(Request $request){
        $insert_data = $request->get('insert_data');
        $sub_data = $request->get('sub_info');
        $user = Auth::user();
      
        foreach(json_decode($insert_data) as $value){
            $data=array(
                'issue_date' => $value->p_issue_date,
                'due_date' => $value->p_due_date,
                'customer_id' => $value->p_customer_id,
                'invoice_type' => 'other_invoice',
                'inv_currency' => $value->p_cur,
                'bank_account_id' => $value->p_bank_account_name,
                'staff_id' => $user->staff_id
            );

            $return_id =Invoice_model::insert_invoice($data);
            if (!empty($return_id)) {
                foreach(json_decode($sub_data) as $val){
                    $data_invoiceitem=array(
                            'invoice_id' => $return_id,
                            'invoice_title' => $value->invoice_titles,
                            'qty' => $val->qty,
                            'item_amount' =>  $val->item_amount,
                            'created_dt' => date('Y-m-d'),
                            'staff_id' => $user->staff_id,
                            'item_description' => $val->item_description
                        );
                        Invoice_model::insert_invoice_item($data_invoiceitem);
                }         
            }
        }
     }

     public function get_history_invoice(Request $request){
        $invoice_id = $request->get('invoice_id');
        if(!empty($invoice_id)){
            $data_id_stock_history = Invoice_model::Getinvoice_history($invoice_id);
            $txt = '';
            foreach($data_id_stock_history as $val_history){
                $txt .= $val_history->stock_id.',';
            }
            $txts = trim($txt,',');
        }
     
        $data = array();
        if(!empty($data_id_stock_history )){
            $data  = Invoice_model::Getinvoice_history_data($txts);
            return response()->json([
                'data_id_stock_history' => $data
            ]);
        }
        return response()->json([
            'data_id_stock_history' => $data
        ]);
     }

     public function data_group_user($id){
        $data = DB::table('users_groups AS a')
          ->select('b.name')
          ->leftjoin('groups AS b','b.id','a.group_id')
          ->where('a.staff_id','=',$id)
          ->get();
          return $data;
     }

     function deletes_invoice(Request $request){
         $invoice_id = $request->get('invoice_id');
         $tabs = $request->get('tabs');
         if($tabs == 'Invoice'){
            $data = Invoice_model::deletes_invoice_stocklist($invoice_id);
            $data = Invoice_model::deletes_invoice($invoice_id);
         }else{
            $data = Invoice_model::deletes_invoice_items($invoice_id);
         }
         return response()->json([
            $data
         ]);
     }

     function update_invoice_status(Request $request){
        $invoice_id = $request->get('invoice_id');
        $status = $request->get('status');
        $data=array('invoice_status'=>$status);
        Invoice_model::update_status_invoice($invoice_id,$data);
     }

     function download_excel_invoice(Request $request){
        $invoice_id = $request->get('invoice_id');
        $totalallocate = $request->get('totalallocate');
        $cus_id = $request->get('cus_id');
        $checkCustomerForm = Invoice_model::get_customer_form_cambodia($cus_id);
        if($checkCustomerForm > 0){
          $data =  $this->download_excel_invoice_for_customer_form_cambdodia($invoice_id,(int)$totalallocate);

        }else{
            $data = $this->download_excel_invoice_other($invoice_id,(int)$totalallocate);
        }
        return response()->json([
            $data
        ]);
     }

     function download_excel_invoice_other($invoice_id,$total_deposit){
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/proform_invoice_excel_new_edit.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
       
        $objPHPExcel->getActiveSheet()->setTitle( 'Invoice' );
        $objPHPExcel->setActiveSheetIndex(0);
        $data = Invoice_model::get_data_proforma_invoice($invoice_id);
        $baseRow = 26;
        $total_amount_jp = 0;
        $total_amount_kr = 0;
        $total_unit  = 0;
        $currency_jp = 'Ұ';
        $currency_kr = '$';

        $any_total = 0;
        $actual_price =0;
        $freight = 0;
        $any_total =0;
        $insurance =0;
        $vanning =0;
        $discount =0;
        $discountprice = 0;
        $grand_total = 0;
        $final_total=0;
        $grand_last_total = 0; 
        $all_deposit=0;

        foreach($data as $r => $dataRow) {
            $dobs = trim($dataRow->date_of_production);
            if(!empty($dobs)){
                $dop = $dataRow->date_of_production;
                $dopex = explode(' ',$dop);
                $numMonth = date('m', strtotime($dopex[0]));
                $modelYear =$dopex[1]."/".$numMonth;
            }else{
                $modelYear = $dataRow->car_model_year;
            }
            $row = $baseRow + $r;
            $actual_price = $dataRow->fob;
            $freight = $dataRow->freight_fee;
            $insurance = $dataRow->insurance;
            $vanning = $dataRow->vanning;
            $discount = $dataRow->discount;
            $any_total = @$actual_price + @$freight + @$insurance + @$vanning;
            $deposit=0;
            if(!empty($data[0]->deposit)){
                $deposit= $data[0]->deposit;
            }
            $discount_price =0;
            if(!empty($dataRow->discount_price)){
               $discount_price = $dataRow->discount_price;
            }
            $all_deposit=$total_deposit+$deposit;
            $last_total = $any_total - @$discount;
            $grand_total += $last_total;
            $grand_last_total += $any_total;
            $final_total=$grand_last_total-$all_deposit-$discount_price;
            $discountprice +=$discount;
            $dateofpro = trim($dataRow->date_of_production);

            if ($dataRow->freight_fee=='0' || $dataRow->freight_fee=='') {
                $freight_fee=number_format($dataRow->freight_fee,2);    
            }else {
                 $freight_fee=$dataRow->freight_fee;
            }
            if ($dataRow->insurance=='0' || $dataRow->insurance=='') {
                $insurance=number_format($dataRow->insurance,2);
            }else {
                $insurance=$dataRow->insurance;
            }

            $vanning = ($dataRow->vanning == '0' || $dataRow->vanning == '' ) ? number_format($dataRow->vanning,2) : $dataRow->vanning ;

                $car_color = $dataRow->color_name;
             
           
            $objPHPExcel->getActiveSheet()->insertNewRowBefore($row,1);
                
                $objPHPExcel->getActiveSheet()->mergeCells('A'.$row.':B'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('C'.$row.':E'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('F'.$row.':G'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('H'.$row.':J'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('K'.$row.':M'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('N'.$row.':O'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('P'.$row.':S'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('T'.$row.':T'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('U'.$row.':V'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('W'.$row.':W'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('Y'.$row.':Z'.$row);

                $objPHPExcel->getActiveSheet()->mergeCells('E18:O18');
                $objPHPExcel->getActiveSheet()->mergeCells('E19:O19');
                $objPHPExcel->getActiveSheet()->mergeCells('E20:O20');

                            
                $objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $dataRow->car_stock_id)
                                        ->setCellValue('C'.$row, $dataRow->car_make_name)
                                        ->setCellValue('F'.$row, $dataRow->car_model_name)
                                        ->setCellValue('H'.$row, $modelYear)
                                        ->setCellValue('K'.$row, $dataRow->chassis_number)
                                        ->setCellValue('N'.$row, 1)
                                        ->setCellValue('P'.$row, $car_color) 
                                        ->setCellValue('T'.$row, number_format($dataRow->fob).' '.$dataRow->currency)
                                        ->setCellValue('U'.$row, number_format($freight_fee).' '.$dataRow->currency)
                                        ->setCellValue('W'.$row, number_format($insurance).' '.$dataRow->currency)
                                        ->setCellValue('X'.$row, number_format($vanning).' '.$dataRow->currency)
                                        ->setCellValue('Y'.$row, number_format($any_total).' '.$dataRow->currency);

                $total_unit = $total_unit + 1;
        
            }

            $total_unit_row_final_balance = 31 + $r;
            $total_unit_row_discount = 30 + $r;
            $total_unit_row_grand = 28 + $r;
            $total_unit_row = 29 + $r;
            $C31 = 31 + $r;
            $C32 = 31 + $r;
            $C53 = 33 + $r;
            $C54 = 34 + $r;
            $C55 = 35 + $r;
            $C56 = 36 + $r;
            $C57 = 37 + $r;

            $objPHPExcel->getActiveSheet()->getStyle('E17:O20')->applyFromArray(
                array(
                    'fill' => array(
                    'type' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                    'color' => array('rgb' => 'FFFFFF')
                    )
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('E17:O20')->applyFromArray(
                            array(
                                'alignment' => array(
                                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                )
                            )
                        );
            $disp = 0;
            if(!empty($data[0]->discount_price)){
            $disp = $data[0]->discount_price;
            }

            $objPHPExcel->getActiveSheet()->setCellValue('E17', $data[0]->cus_name)
            ->setCellValue('E18', $data[0]->phone_number)
            ->setCellValue('E19', $data[0]->cus_address)

            ->setCellValue('V17', $data[0]->issue_date)
            ->setCellValue('V18', $invoice_id)
            ->setCellValue('V19', $data[0]->due_date)
            ->setCellValue('F'.$C32, $data[0]->final_des_name)
            ->setCellValue('A'.$C53, 'BANK NAME; '.@$data[0]->bank_eng_name)
            ->setCellValue('A'.$C54, 'BRANCH NAME; '.@$data[0]->branch_name)
            ->setCellValue('A'.$C55, 'Swift Code: '.@$data[0]->swift_code)
            ->setCellValue('A'.$C56, 'Accunt No: '.@$data[0]->account_number)
            ->setCellValue('M'.$total_unit_row, $total_unit)
            ->setCellValue('Q'.$total_unit_row, number_format($grand_total).' '.$data[0]->currency)
            ->setCellValue('X'.$total_unit_row_grand, number_format($grand_last_total).' '.$data[0]->currency)
            ->setCellValue('X'.$total_unit_row, number_format($all_deposit).' '.$data[0]->currency)
            ->setCellValue('X'.$total_unit_row_discount, number_format($disp).' '.$data[0]->currency)
            ->setCellValue('X'.$total_unit_row_final_balance, number_format($final_total).' '.$data[0]->currency);
            $objPHPExcel->getActiveSheet()->removeRow($baseRow-1,1);

        
            $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

            // Redirect output to a client’s web browser (Excel5)
            header('Content-Type: application/vnd.ms-excel');
            header('Content-Disposition: attachment;filename="invoice_'.$invoice_id.'.xls"');
            header('Cache-Control: max-age=0');
            // If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');
            // If you're serving to IE over SSL, then the following may be needed
            header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
            header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
            header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
            header ('Pragma: public'); // HTTP/1.0
            return $writer->save('php://output');
    }

     function download_excel_invoice_for_customer_form_cambdodia($invoice_id,$total_deposit){
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/proform_invoice_excel_for_customer_form_cambodia.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
       
        $objPHPExcel->getActiveSheet()->setTitle( 'Invoice' );
        $objPHPExcel->setActiveSheetIndex(0);

        $data = Invoice_model::get_data_proforma_invoice_for_customer_form_cambodia($invoice_id);

        $baseRow = 26;
        $total_amount_jp = 0;
        $total_amount_kr = 0;
        $total_unit  = 0;
        $currency_jp = 'Ұ';
        $currency_kr = '$';

        $any_total = 0;
        $actual_price =0;
        $freight = 0;
        $any_total =0;
        $insurance =0;
        $vanning =0;
        $discount =0;
        $discountprice = 0;
        $grand_total = 0;
        $final_total=0;
        $grand_last_total = 0; 
        $all_deposit=0;
        $grandTotalCustomerDepoit = 0;
        $grandTotalCustomerBalance = 0;
        foreach($data as $r => $dataRow) {
            $dobs = trim($dataRow->date_of_production);
            if(!empty($dobs)){
                $dop = $dataRow->date_of_production;
                $dopex = explode(' ',$dop);
                $numMonth = date('m', strtotime($dopex[0]));
                $modelYear =$dopex[1]."/".$numMonth;
            }else{
                $modelYear = $dataRow->car_model_year;
            }
            $row = $baseRow + $r;
            $actual_price = $dataRow->fob;
            $freight = $dataRow->freight_fee;
            $insurance = $dataRow->insurance;
            $vanning = $dataRow->vanning;
            $discount = $dataRow->discount;
            $totalCustomerDepoit = $dataRow->total_deposit;
            
            $any_total = @$actual_price + @$freight + @$insurance + @$vanning;
            $deposit1= 0;
            if(!empty($data[0]->deposit)){
                $deposit1=$data[0]->deposit;
            }
            $all_deposit=$total_deposit+$deposit1;
            $last_total = $any_total - @$discount;
            
            
            $discountprice +=$discount;
            $dateofpro = trim($dataRow->date_of_production);
            $deposit =0;
            $dep_per =0;
            if($totalCustomerDepoit == 0){
                $dep_per =$dataRow->dep_percentage;
                $cal_dep =($any_total)*(($dep_per)/100);
                $deposit = $cal_dep;
            }else{
                $deposit = $totalCustomerDepoit;
            }
            $totalCustomerBalance = $any_total-$deposit;
            $grandTotalCustomerDepoit += $deposit;
            $grandTotalCustomerBalance += $totalCustomerBalance;
            $grand_total += $last_total;
            $grand_last_total += $any_total;
            $discount_price = 0;
            if(!empty($dataRow->discount_price)){
                $discount_price = $dataRow->discount_price;
            }
            $final_total=$grand_last_total-$all_deposit-$discount_price;

            if ($dataRow->freight_fee=='0' || $dataRow->freight_fee=='') {
                $freight_fee=number_format($dataRow->freight_fee,2);    
            }else {
                 $freight_fee=$dataRow->freight_fee;
            }
            if ($dataRow->insurance=='0' || $dataRow->insurance=='') {
                $insurance=number_format($dataRow->insurance,2);
            }else {
                $insurance=$dataRow->insurance;
            }

            $vanning = ($dataRow->vanning == '0' || $dataRow->vanning == '' ) ? number_format($dataRow->vanning,2) : $dataRow->vanning ;

            $car_color = $dataRow->color_name;
            $objPHPExcel->getActiveSheet()->insertNewRowBefore($row,1);
                
            $objPHPExcel->getActiveSheet()->mergeCells('A'.$row.':B'.$row);
            $objPHPExcel->getActiveSheet()->mergeCells('C'.$row.':E'.$row);
            $objPHPExcel->getActiveSheet()->mergeCells('F'.$row.':G'.$row);
            $objPHPExcel->getActiveSheet()->mergeCells('H'.$row.':J'.$row);
            $objPHPExcel->getActiveSheet()->mergeCells('K'.$row.':M'.$row);
            $objPHPExcel->getActiveSheet()->mergeCells('N'.$row.':O'.$row);
            $objPHPExcel->getActiveSheet()->mergeCells('P'.$row.':S'.$row);
            $objPHPExcel->getActiveSheet()->mergeCells('T'.$row.':T'.$row);
            $objPHPExcel->getActiveSheet()->mergeCells('U'.$row.':V'.$row);
            $objPHPExcel->getActiveSheet()->mergeCells('W'.$row.':W'.$row);
            $objPHPExcel->getActiveSheet()->mergeCells('Y'.$row.':Z'.$row);

            $objPHPExcel->getActiveSheet()->mergeCells('E18:O18');
            $objPHPExcel->getActiveSheet()->mergeCells('E19:O19');
            $objPHPExcel->getActiveSheet()->mergeCells('E20:O20');

            $objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $dataRow->car_stock_id)
                                        ->setCellValue('C'.$row, $dataRow->car_make_name)
                                        ->setCellValue('F'.$row, $dataRow->car_model_name)
                                        ->setCellValue('H'.$row, $modelYear)
                                        ->setCellValue('K'.$row, $dataRow->chassis_number)
                                        ->setCellValue('N'.$row, 1)
                                        ->setCellValue('P'.$row, $car_color)
                                        
                                        ->setCellValue('T'.$row, number_format($dataRow->fob).' '.$dataRow->currency)
                                        ->setCellValue('U'.$row, number_format($freight_fee).' '.$dataRow->currency)
                                        ->setCellValue('W'.$row, number_format($any_total).' '.$dataRow->currency)
                                        ->setCellValue('X'.$row, number_format($deposit).' '.$dataRow->currency)
                                        ->setCellValue('Y'.$row, number_format($totalCustomerBalance).' '.$dataRow->currency);

                $total_unit = $total_unit + 1;
        }
        $total_unit_row_final_balance = 31 + $r;
            $total_unit_row_discount = 30 + $r;
            $total_unit_row_grand = 28 + $r;
            $total_unit_row = 29 + $r;
            $C31 = 31 + $r;
            $C32 = 31 + $r;
            $C53 = 33 + $r;
            $C54 = 34 + $r;
            $C55 = 35 + $r;
            $C56 = 36 + $r;
            $C57 = 37 + $r;

        $objPHPExcel->getActiveSheet()->getStyle('E17:O20')->applyFromArray(
            array(
                'fill' => array(
                'type' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                'color' => array('rgb' => 'FFFFFF')
                )
            )
        );
        $objPHPExcel->getActiveSheet()->getStyle('E17:O20')->applyFromArray(
                    array(
                        'alignment' => array(
                            'horizontal' =>\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                        )
                    )
                );
        //var_dump($dataRow); die();
        $disp = 0;
        if(!empty($data[0]->discount_price)){
        $disp = $data[0]->discount_price;
        }

        $objPHPExcel->getActiveSheet()->setCellValue('E17', $data[0]->cus_name)
        ->setCellValue('E18', $data[0]->phone_number)
        ->setCellValue('E19', $data[0]->cus_address)

        ->setCellValue('V17', $data[0]->issue_date)
        ->setCellValue('V18', $invoice_id)
        ->setCellValue('V19', $data[0]->due_date)
        ->setCellValue('F'.$C32, $data[0]->final_des_name)
        ->setCellValue('A'.$C53, 'BANK NAME; '.@$data[0]->bank_eng_name)
        ->setCellValue('A'.$C54, 'BRANCH NAME; '.@$data[0]->branch_name)
        ->setCellValue('A'.$C55, 'Swift Code: '.@$data[0]->swift_code)
        ->setCellValue('A'.$C56, 'Accunt No: '.@$data[0]->account_number)
        ->setCellValue('M'.$total_unit_row, $total_unit)
        ->setCellValue('Q'.$total_unit_row, number_format($grand_total).' '.$data[0]->currency)
        ->setCellValue('X'.$total_unit_row_grand, number_format($grandTotalCustomerDepoit).' '.$data[0]->currency)
        ->setCellValue('X'.$total_unit_row, number_format($grandTotalCustomerBalance).' '.$data[0]->currency);
        $objPHPExcel->getActiveSheet()->removeRow($baseRow-1,1);

        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Invoice');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

       
        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="invoice_'.$invoice_id.'.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        return $writer->save('php://output');
     }

     function download_excel_invoice_new(Request $request){
        $invoice_id = $request->get('invoice_id');
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/tt_invoice.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
       
        $objPHPExcel->getActiveSheet()->setTitle( 'Invoice' );
        $objPHPExcel->setActiveSheetIndex(0);

        $data = Invoice_model::get_data_proforma_invoice($invoice_id);
        $baseRow = 36;
        $i = 0;
        $car_name_row = 0;
        $car_cha_row = 0;
        $reg_row = 0;
        $tran_row = 0;
        $color_row = 0;
        $cc_row = 0;
        $model_row = 0;
        $free_row =0;
        $row = 0;
        $grand_total = 0;

        foreach($data as $dataRow){
            $i = $i + 1;
            if($row == 0){
                $row = $baseRow + $i;
            }else{
                $row = $baseRow + 9;
            }
            $car_name_row = $row + 1;
            $car_cha_row = $row + 2;
            $reg_row = $row + 3;
            $tran_row = $row + 4;
            $color_row = $row + 5;
            $model_row = $row + 6;
            $cc_row = $row + 7;
            $free_row = $row + 8;
            $cur = "$";
            switch ($dataRow->currency) {
                case "USD":
                    $cur = "$";
                    break;
                case "JPY":
                    $cur = "¥";
                    break;
                default:
                    $cur = "¥";
            }
            $total_amount = $dataRow->freight_fee + $dataRow->fob;
            $grand_total += $total_amount;
            //$objPHPExcel->getActiveSheet()->insertNewRowBefore($row,1);
            $objPHPExcel->getActiveSheet()->mergeCells('G'.$car_name_row.':H'.$car_name_row);
            $objPHPExcel->getActiveSheet()->mergeCells('G'.$car_cha_row.':H'.$car_cha_row);
            $objPHPExcel->getActiveSheet()->mergeCells('G'.$reg_row.':H'.$reg_row);
            $objPHPExcel->getActiveSheet()->mergeCells('G'.$tran_row.':H'.$tran_row);
            $objPHPExcel->getActiveSheet()->mergeCells('G'.$color_row.':H'.$color_row);
            $objPHPExcel->getActiveSheet()->mergeCells('G'.$model_row.':H'.$model_row);
            $objPHPExcel->getActiveSheet()->mergeCells('G'.$cc_row.':H'.$cc_row);

            $objPHPExcel->getActiveSheet()->setCellValue('A'.$tran_row, $i)
                                          ->setCellValue('B'.$tran_row,$dataRow->stock_id)
                                          ->setCellValue('D'.$car_name_row, "Car Name")
                                          ->setCellValue('D'.$car_cha_row, "Chassis No")
                                          ->setCellValue('D'.$reg_row, "Reg. Yr/Mo")
                                          ->setCellValue('D'.$tran_row, "Transmition")
                                          ->setCellValue('D'.$color_row, "Color")
                                          ->setCellValue('D'.$model_row, "Model")
                                          ->setCellValue('D'.$cc_row, "CC")
                                          ->setCellValue('D'.$free_row, "")
                                          ->setCellValue('E'.$car_name_row, ":")
                                          ->setCellValue('E'.$car_cha_row, ":")
                                          ->setCellValue('E'.$reg_row, ":")
                                          ->setCellValue('E'.$tran_row, ":")
                                          ->setCellValue('E'.$color_row, ":")
                                          ->setCellValue('E'.$model_row, ":")
                                          ->setCellValue('E'.$cc_row, ":")
                                          ->setCellValue('E'.$free_row, "")
                                          ->setCellValue('G'.$car_name_row, $dataRow->car_make_name." ".$dataRow->car_model_name)
                                          ->setCellValue('G'.$car_cha_row, $dataRow->chassis_number)
                                          ->setCellValue('G'.$reg_row, $dataRow->date_of_production)
                                          ->setCellValue('G'.$tran_row, $dataRow->transimission)
                                          ->setCellValue('G'.$color_row, $dataRow->color_name)
                                          ->setCellValue('G'.$cc_row, $dataRow->engine_size)
                                          ->setCellValue('G'.$model_row, $dataRow->car_model_name)
                                          ->setCellValue('J'.$reg_row, $dataRow->memo_for_web)
                                          ->setCellValue('G'.$free_row, "")
                                          ->setCellValue('Q'.$car_name_row, $cur)
                                          ->setCellValue('Q'.$car_cha_row, $dataRow->fob)
                                          ->setCellValue('Q'.$reg_row, $dataRow->freight_fee)
                                          ->setCellValue('Q'.$tran_row, $total_amount)
                                          ->setCellValue('J'.$car_cha_row, "Options")
                                          ->setCellValue('O'.$car_name_row, "Currency")
                                          ->setCellValue('O'.$car_cha_row, "Unit Price")
                                          ->setCellValue('O'.$reg_row, "Freight")
                                          ->setCellValue('O'.$tran_row, "TOTAL");
            $objPHPExcel->getActiveSheet()->mergeCells('J'.$reg_row.':M'.$free_row);
            $objPHPExcel->getActiveSheet()->mergeCells('O'.$car_name_row.':P'.$car_name_row);
            $objPHPExcel->getActiveSheet()->mergeCells('O'.$car_cha_row.':P'.$car_cha_row);
            $objPHPExcel->getActiveSheet()->mergeCells('O'.$reg_row.':P'.$reg_row);
            $objPHPExcel->getActiveSheet()->mergeCells('O'.$tran_row.':p'.$tran_row);
            $objPHPExcel->getActiveSheet()->getStyle('J'.$reg_row)->getAlignment()->setWrapText(true); 
            $objPHPExcel->getActiveSheet()->getStyle('A'.$car_name_row.':Q'.$free_row)->applyFromArray(
            array('borders' => array(
                        'bottom'    => array('style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN),
                        'right'     => array('style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN),
                        'left'      => array('style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN),
                        'top'       => array('style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN)
                    )
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('A'.$car_name_row.':A'.$free_row)->applyFromArray(
                array('borders' => array(
                            'right'     => array('style' =>\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN)
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle('B'.$car_name_row.':B'.$free_row)->applyFromArray(
                array('borders' => array(
                            'right'     => array('style' =>\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN)
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle('H'.$car_name_row.':H'.$free_row)->applyFromArray(
                array('borders' => array(
                            'right'     => array('style' =>\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN)
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle('N'.$car_name_row.':N'.$free_row)->applyFromArray(
                array('borders' => array(
                            'right'     => array('style' =>\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN)
                        )
                    )
                );
                $objPHPExcel->getActiveSheet()->getStyle('O'.$reg_row.':Q'.$reg_row)->applyFromArray(
                array('borders' => array(
                            'bottom'    => array('style' =>\PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN)
                        )
                    )
                );
        }

        $objPHPExcel->getActiveSheet()->setCellValue('D6', $data[0]->cus_name)
                    ->setCellValue('D7',"")
                    ->setCellValue('D10',$data[0]->consignee_name)
                    ->setCellValue('D11',$data[0]->consignee_address)
                    ->setCellValue('C24',$data[0]->bank_eng_name)
                    ->setCellValue('C25',$data[0]->address)
                    ->setCellValue('C26',$data[0]->bank_name)
                    ->setCellValue('C27',$data[0]->swift_code)
                    ->setCellValue('C28',$data[0]->branch_name)
                    ->setCellValue('C36',count($data))
                    ->setCellValue('K24',$data[0]->account_number)
                    ->setCellValue('D14',$data[0]->vessel)
                    ->setCellValue('D15',$data[0]->country_name)
                    ->setCellValue('E32',$data[0]->car_selling_price_type)
                    ->setCellValue('F35',$data[0]->due_date)
                    ->setCellValue('O6',$data[0]->issue_date)
                    ->setCellValue('O7',$data[0]->invoice_id)    
                    ->setCellValue('O8',$data[0]->etd)
                    ->setCellValue('O9',$data[0]->shipping_co_name)
                    ->setCellValue('O10',$data[0]->voyage_no)
                    ->setCellValue('M14',$data[0]->port_of_loading_name)
                    ->setCellValue('M15',$data[0]->discharge_name)
                    ->setCellValue('M16',$data[0]->customer_id)
                    ->setCellValue('M17',$data[0]->full_name)
                    ->setCellValue('M31',$cur.' '.$grand_total);

        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="invoice_'.$invoice_id.'.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        return response()->json([
            $writer->save('php://output')
        ]);
}

function proforma_invoice_download(Request $request){
    require '../vendor/autoload.php';
    $objPHPExcel = new Spreadsheet();
    $inputFileName = storage_path( 'app/public/PHPEXCEL/proform_invoice_excel_new.xls' );
    $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
    
    $objPHPExcel->getActiveSheet()->setTitle( 'Invoice' );
    $objPHPExcel->setActiveSheetIndex(0);

    $multi_stock = $request->get("stock_ids");
    $stock_trim = trim($multi_stock,",");
    $datemonthyear = date("YmdHis");
    $p_customer_id = $request->get("customer_id");
    $p_bank_account_name = $request->get("bank_account_id");
    $p_issue_date = $request->get("issue_date");
    $p_due_date = $request->get("due_date");

     // get customer info
     $cusInfo = Invoice_model::get_customer_info_by_cus_id($p_customer_id);
     // get bank info
     $data_bank = Invoice_model::get_bank_info_by_bank_id($p_bank_account_name);
     // get info of invoice
     $data = Invoice_model::get_data_proforma_invoice_multi_stock($stock_trim);

     $baseRow = 26;
        $total_amount_jp = 0;
        $total_amount_kr = 0;
        $total_unit  = 0;
        $currency_jp = 'Ұ';
        $currency_kr = '$';

        $any_total = 0;
        $actual_price =0;
        $freight = 0;
        $any_total =0;
        $insurance =0;
        $discount =0;
        $discountprice = 0;
        $grand_total = 0; 
        foreach($data as $r => $dataRow) {
            $row = $baseRow + $r;
            $actual_price = $dataRow->fob;
            $freight = $dataRow->freight_fee;
            $insurance = $dataRow->insurance;
            $discount = $dataRow->discount;
            $any_total = @$actual_price + @$freight + @$insurance;
            $last_total = $any_total - @$discount;
            $grand_total += $last_total;
            $discountprice +=$discount;
            $dateofpro = trim($dataRow->date_of_production);
            //$etd = date('d-M', strtotime($dataRow['etd']));
            if(!empty($dataRow->eta)){
                 $etd = date('F, d', strtotime($dataRow->eta));
             }else{
                $etd = $dataRow->eta;
             }
           
            $objPHPExcel->getActiveSheet()->insertNewRowBefore($row,1);
                
                $objPHPExcel->getActiveSheet()->mergeCells('A'.$row.':B'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('C'.$row.':F'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('G'.$row.':H'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('I'.$row.':K'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('L'.$row.':N'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('O'.$row.':P'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('Q'.$row.':T'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('V'.$row.':W'.$row);
                $objPHPExcel->getActiveSheet()->mergeCells('Y'.$row.':Z'.$row);

                $objPHPExcel->getActiveSheet()->mergeCells('E18:O18');
                $objPHPExcel->getActiveSheet()->mergeCells('E19:O19');
                $objPHPExcel->getActiveSheet()->mergeCells('E20:O20');

                $objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $dataRow->car_stock_id)
                        ->setCellValue('C'.$row, $dataRow->car_make_name)
                        ->setCellValue('G'.$row, $dataRow->car_model_name)
                        ->setCellValue('I'.$row, $dataRow->car_model_year)
                        //->setCellValue('I'.$row, $dataRow->color_name)
                        ->setCellValue('L'.$row, $dataRow->chassis_number)
                        ->setCellValue('Q'.$row, $etd)
                        ->setCellValue('O'.$row, 1)
                          //->setCellValue('P'.$row, $dataRow->chassis_number)
                          
                        ->setCellValue('U'.$row, $dataRow->fob.' '.$dataRow->currency)
                        ->setCellValue('V'.$row, $dataRow->freight_fee.' '.$dataRow->currency)
                        ->setCellValue('X'.$row, $dataRow->insurance.' '.$dataRow->currency)
                        ->setCellValue('Y'.$row, $any_total.' '.$dataRow->currency);

                $total_unit = $total_unit + 1;
        
            }

            $total_unit_row = 29 + $r;
            $C31 = 31 + $r;
            $C32 = 31 + $r;
            $C53 = 33 + $r;
            $C54 = 34 + $r;
            $C55 = 35 + $r;
            $C56 = 36 + $r;
            $C57 = 37 + $r;

    
            // $objPHPExcel->getActiveSheet()->getStyle('E17')->getAlignment()->setWrapText(true);
            $objPHPExcel->getActiveSheet()->getStyle('E17:O20')->applyFromArray(
                                                                array(
                                                                    'fill' => array(
                                                                    'type' => \PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,
                                                                    'color' => array('rgb' => 'FFFFFF')
                                                                    )
                                                                )
                                                            );
            $objPHPExcel->getActiveSheet()->getStyle('E17:O20')->applyFromArray(
                                                                array(
                                                                    'alignment' => array(
                                                                        'horizontal' =>  \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                                                                    )
                                                                )
                                                            );
            $objPHPExcel->getActiveSheet()->setCellValue('E17', @$cusInfo[0]->full_name)
                                          ->setCellValue('E18', @$cusInfo[0]->phone_number)
                                          ->setCellValue('E19', @$cusInfo[0]->address)
                                          ->setCellValue('W17', $p_issue_date)
                                          ->setCellValue('W18', "")
                                          ->setCellValue('W19', $p_due_date)
                                          ->setCellValue('G'.$C32, $data[0]->final_des_name)
                                          ->setCellValue('A'.$C53, 'BANK NAME; '.@$data_bank[0]->bank_name)
                                          ->setCellValue('A'.$C54, 'BRANCH NAME; '.@$data_bank[0]->branch_name)
                                          ->setCellValue('A'.$C55, 'Swift Code: '.@$data_bank[0]->swift_code)
                                          ->setCellValue('A'.$C56, 'Accunt No: '.@$data_bank[0]->account_number)
                                          ->setCellValue('N'.$total_unit_row, $total_unit)
                                          ->setCellValue('R'.$total_unit_row, $grand_total.' '.$data[0]->currency);
        $objPHPExcel->getActiveSheet()->removeRow($baseRow-1,1);

        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="invoice_'.$datemonthyear.'.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        return response()->json([
            $writer->save('php://output')
        ]);

}

function download_excel_invoice_items(Request $request){
    $invoice_id = $request->get('invoice_id');

    require '../vendor/autoload.php';
    $objPHPExcel = new Spreadsheet();
    $inputFileName = storage_path( 'app/public/PHPEXCEL/invioce_proforma_items.xls' );
    $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
    
    $objPHPExcel->getActiveSheet()->setTitle( 'Invoice' );
    $objPHPExcel->setActiveSheetIndex(0);
    $datas = Invoice_model::get_data_invoice_items($invoice_id);

    $baseRow = 21;
        $i = 1;
        $grantTotal = 0;
        $grantQty = 0;
        $cur = "";
        foreach($datas as $r => $dataRows) {
            $grantTotal += $dataRows->item_amount;
            $grantQty += $dataRows->qty;
            $row = $baseRow + $r;
            $cur = $dataRows->inv_currency;
            if($dataRows->inv_currency == "USD"){
                $curSym1 = "$";
            }else{
                $curSym1 = "¥";
            }
            $objPHPExcel->getActiveSheet()->insertNewRowBefore($row,1);
            $objPHPExcel->getActiveSheet()->mergeCells('A'.$row.':C'.$row);
            $objPHPExcel->getActiveSheet()->mergeCells('D'.$row.':S'.$row);
            $objPHPExcel->getActiveSheet()->mergeCells('T'.$row.':W'.$row);
            $objPHPExcel->getActiveSheet()->mergeCells('X'.$row.':Z'.$row);
            $objPHPExcel->getActiveSheet()->mergeCells('E18:O18');
            $objPHPExcel->getActiveSheet()->mergeCells('E19:O19');
            $objPHPExcel->getActiveSheet()->mergeCells('E20:O20');
            $objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $i++);                        
            $objPHPExcel->getActiveSheet()->setCellValue('D'.$row, $dataRows->item_description);
            $objPHPExcel->getActiveSheet()->setCellValue('T'.$row, $dataRows->qty);
            $objPHPExcel->getActiveSheet()->setCellValue('X'.$row, $curSym1.$dataRows->item_amount);
        }

        $c48 = 24 + $r;
        $C53 = 29 + $r;
        $C54 = 30 + $r;
        $C55 = 31 + $r;
        $C56 = 32 + $r;
        $C57 = 33 + $r;

        if($cur == "USD"){
            $curSym = "$";
        }else{
            $curSym = "¥";
        }

        $objPHPExcel->getActiveSheet()->getStyle('E17:O20')->applyFromArray(array('fill'=>array('type'=>\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID,'color'=>array('rgb' => 'FFFFFF'))));

        $objPHPExcel->getActiveSheet()->getStyle('E17:O20')->applyFromArray(array('alignment' => array('horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,)));
        //var_dump($dataRow); die();
        $objPHPExcel->getActiveSheet()->setCellValue('N'.$c48, $grantQty);
        $objPHPExcel->getActiveSheet()->setCellValue('R'.$c48, $curSym.$grantTotal);
        $objPHPExcel->getActiveSheet()->setCellValue('E12', @$datas[0]->customer_name)
                                      ->setCellValue('E13', @$datas[0]->customer_address)
                                      ->setCellValue('E14', '')
                                      ->setCellValue('E15', '')
                                      // ->setCellValue('J9', $datas[0]->invoice_title)
                                      ->setCellValue('T12', $datas[0]->issue_date)
                                      ->setCellValue('T13', $invoice_id)
                                      ->setCellValue('T14', $datas[0]->due_date)
                                      ->setCellValue('F32', '')
                                      ->setCellValue('F33', '')
                                      ->setCellValue('k8', $datas[0]->full_name)
                                      ->setCellValue('A'.$C53, "BENEFICIARY BANk : ".$datas[0]->bank_name)
                                      ->setCellValue('A'.$C54, 'SWIFT CODE : '.$datas[0]->swift_code)
                                      ->setCellValue('A'.$C55, "BRANCH NAME : ".$datas[0]->branch_name)
                                      ->setCellValue('A'.$C57, "BENEFICIARY BANk : Silmi Japan Co., Ltd.")
                                      ->setCellValue('A'.$C56, 'BENEFICIARY ACCOUNT NUMBER : '.$datas[0]->account_number);
    $objPHPExcel->getActiveSheet()->removeRow($baseRow-1,1);

    $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(20);      
    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(20);  
    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(20);
    $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

    // Redirect output to a client’s web browser (Excel5)
    header('Content-Type: application/vnd.ms-excel');
    header('Content-Disposition: attachment;filename="invoice_'.$invoice_id.'.xls"');
    header('Cache-Control: max-age=0');
    // If you're serving to IE 9, then the following may be needed
    header('Cache-Control: max-age=1');
    // If you're serving to IE over SSL, then the following may be needed
    header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
    header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
    header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
    header ('Pragma: public'); // HTTP/1.0
    return response()->json([
        $writer->save('php://output')
    ]);
    
}



function check_download_pdf_preview(request $request){
    $invoice_id = $request->get('invoice_id');
    $totalallocate = $request->get('totalallocate');
    $cus_id = $request->get('cus_id');
    $checkCustomerForm = Invoice_model::get_customer_form_cambodia($cus_id);
    if($checkCustomerForm > 0){
        $this->preview_invoice_cambodia_pdf_by_id($invoice_id);

    }else{
        $this->preview_invoice_pdf_by_id($invoice_id);
    }
}

function check_download_pdf_invoice_item(Request $request){
    $invoice_id = $request->get('invoice_id');
    stream_context_set_default([
        'ssl' => [
            'verify_peer' => false,
            'verify_peer_name' => false,
        ]
    ]);
    $data = Invoice_model::get_data_invoice_items($invoice_id);
    if(!empty($data[0]->invoice_number)){
        $invoice_no = $data[0]->invoice_number;
    }else{
        $invoice_no = $invoice_id;
    }
    $pdf = new PDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

    PDF::SetTitle('TCPDF Example 002');
    PDF::SetSubject('TCPDF Tutorial');
    PDF::SetKeywords('TCPDF, PDF, example, test, guide');

    // remove default header/footer
    PDF::setPrintHeader(false);
    PDF::setPrintFooter(false);

    // set default monospaced font
    PDF::SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    PDF::SetAutoPageBreak(TRUE, 0);

    // set image scale factor
    PDF::setImageScale(PDF_IMAGE_SCALE_RATIO);

    // set some language-dependent strings (optional)
    if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
      require_once(dirname(__FILE__).'/lang/eng.php');
      PDF::setLanguageArray($l);
    }

    // ---------------------------------------------------------

    // set font
    PDF::SetFont('times', '', 7);

    //PDF::AddPage('L', 'A4');
    //PDF::Cell(0, 0, 'A4 LANDSCAPE', 1, 1, 'C');
    // add a page
    PDF::AddPage();
    // set cell padding
    PDF::setCellPaddings(1, 1, 1, 1);
    // set cell padding
    $image_file = public_path().'/uploads/silmi_logo_invoice1.png';
    PDF::Image($image_file, '','',40, 25, 'png', 'https://silmijapan.com', '', true, 150, '', false, false, 1, false, false, false);

    $html = <<<EOD
        <br/><br/><br/><br/><br/>
    <h1 style="text-align: center; color:#FF0000">INVOICE</h1>

    EOD;

        // Print text using writeHTMLCell()
        PDF::writeHTMLCell(0, 0, 25, '', utf8_decode($html), 0, 1, 0, true, '', true);

        $html = <<<EOD
    <p>
    Home page: <a href="https://silmijapan.com" dir="ltr">https://silmijapan.com</a>
    </p>
    <br/>
    <hr>
    EOD;

        // Print text using writeHTMLCell()
    PDF::writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
    $html = '<table border="0" style="width:60%;">
    <tbody>
        <tr> 
            <th style="border: 0.1px solid black;padding:8px;" width="25%" height="15">CUSTOMER NAME </th>
            <td style="border: 0.1px solid black;vertical-align: middle" width="75%" height="15"><span>'.$data[0]->customer_name.'</span></td>
        </tr>
        <tr> 
            <th style="border: 0.1px solid black;">&nbsp;<br/>ADDRESS </th>
            <td style="border: 0.1px solid black;" height="25"><span>'.$data[0]->customer_address.'</span></td>
        </tr>
    <tbody>    
    </table>';


        // Print text using writeHTMLCell()
        PDF::writeHTMLCell(0, 0, '', 53, $html, 0, 1, 0, true, 'C', false);

    $html = '<table style="">
    <tbody>
        <tr> 
            <th style="border: 0.1px solid black;" height="15">DATE </th>
            <td style="border: 0.1px solid black;" height="15">'.$data[0]->issue_date.'</td>
        </tr>
        <tr> 
            <th style="border: 0.1px solid black;" height="15">INVOICE NUMBER </th>
            <td style="border: 0.1px solid black;" height="15">'.$invoice_id.'</td>
        </tr>
        <tr> 
            <th style="border: 0.1px solid black;" height="15">EXPIRATION DATE</th>
            <td style="border: 0.1px solid black;" height="15">'.$data[0]->due_date.'</td>

        </tr>
    <tbody>    
    </table><br/><br/><br/><br/>';
    // Print text using writeHTMLCell()
    PDF::writeHTMLCell(0, 0,130, 53, $html, 0, 1, 0, true, 'C', true);
    $html = '<hr><br/><table border="0.1" style="width:100%">
            <thead>
                <tr align="center">
                    <th width="10%" height="15">NO</th>
                    <th width="60%" height="15">DESCRIPTION</th>
                    <th width="10%" height="15">QTY </th>
                    <th width="20%" height="15">AMOUNT </th>
                </tr>
            </thead>
            <tbody>';

        $total_unit =0;
        $amount = 0;
        $grand_total = 0;
        $i = 0;
        $country_destination = "";
    foreach($data as $dataRow) {
            $i = $i + 1;
            $total_unit = $total_unit + 1;
            
            if($dataRow->item_amount > 0){
                $amount = $dataRow->item_amount;
            }
            $grand_total = $grand_total + $amount;
            if(!empty($dataRow->final_des_name)){
                $final_destination = $dataRow->final_des_name;
            }

            if(!empty($dataRow->country_name)){
                 $country_destination = $dataRow->country_name;
            }

            switch ($dataRow->inv_currency) {  
              case 'USD':
              $currency_mark = '$';
              break;
              case 'KRW':
              $currency_mark = '₩';
              break;    
              case 'JPY':
              $currency_mark = '&#165;';
              break;
              case 'EUR':
              $currency_mark = '€';
              break;   
              default:
              $currency_mark = '';
              break;
            }
        $html .='<tr align="center">
          <td width="10%" height="15">'.$i.'</td>
          <td width="60%" height="15">'.$dataRow->item_description.'</td>
          <td width="10%" height="15">'.$dataRow->qty.'</td>
          <td width="20%" height="15">'.number_format($amount).' '.$currency_mark.'</td>
          
        </tr>';
    } 

    $html .='</tbody></table><br/><br/>';                   
           
    // Print text using writeHTMLCell()
     PDF::writeHTMLCell(0, 0,'', '', $html, 0, 1, 0, true, '', true);

    $html = '<table style="border-collapse: collapse;">
    <tr> 
        <th colspan="7"></th>
        <th align="center" border="0.1" height="15">QUANTITY</th>
        <th align="center" border="0.1" height="15">GRAND TOTAL</th>
    </tr>
    <tr> 
        <td colspan="7" border="0.1" style="color:red;"  height="15">TOTAL</td>
        <td align="center" border="0.1" height="15">'.$total_unit.'</td>
        <td align="center" border="0.1" height="15">'.number_format($grand_total).' '.$currency_mark.'</td>
        
    </tr>
    </table>';
    
    PDF::writeHTMLCell(0, 0, '', '', utf8_decode($html), 0, 1, 0, true, '', true);

   $html1 = '<p style="padding:0;margin:0;">BANK DETAILS</p>
   <p style="padding:0;margin:0;color:red; border:1px solid black;text-align:center;">BENEFICIARY BANk : '.@$data[0]->bank_name.
   '<br/>BRANCH NAME : '.@$data[0]->branch_name.
   '<br/>SWIFT CODE : '.@$data[0]->swift_code.
   '<br/>BENEFICIARY ACCOUNT NUMBER : '.@$data[0]->account_number.
   '</p><br/><br/><br/>';

   // create some HTML content

$html = '
<table border="0">
<tr> 
    <th style="">
        '.$html1.'<br/><br/>BENEFICIARY`S NAME & ADDRESS
        <p style="border:0.1px solid black; text-align:center;">Name: SILMI JAPAN CO., LTD.<br/>Address: 3-6-28, Miyanosaka, Hirakata-city, Osaka, Japan</p><br/>
    </th>
    <th align="center"><img src="'.public_path().'/uploads/silmi_signature.png" height="90" width="120">
        <br/><hr style="width:50%" ><br/>
        <h4>
            YOHEI MURASHIMA<br/>
            SILMI JAPAN CO., LTD.
            <p></p>
        </h4>
    </th>
</tr>

</table>';
 
  // Print text using writeHTMLCell()
  PDF::writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
    //Close and output PDF document
    return   PDF::Output('INVOICE.pdf', 'I');

}

function preview_invoice_pdf_by_id($invoice_id){
    stream_context_set_default([
        'ssl' => [
            'verify_peer' => false,
            'verify_peer_name' => false,
        ]
    ]);
    $data = Invoice_model::get_data_proforma_invoice($invoice_id);

    if(!empty($data[0]->invoice_number)){
        $invoice_no = $data[0]->invoice_number;
    }else{
        $invoice_no = $invoice_id;
    }

    $pdf = new PDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

    PDF::SetTitle('Invoice'.$invoice_id);
    PDF::SetSubject('TCPDF Tutorial');
    PDF::SetKeywords('TCPDF, PDF, example, test, guide');

    // remove default header/footer
    PDF::setPrintHeader(false);
    PDF::setPrintFooter(false);

    // set default monospaced font
    PDF::SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

    PDF::SetAutoPageBreak(TRUE, 0);

    // set image scale factor
    PDF::setImageScale(PDF_IMAGE_SCALE_RATIO);

    // set some language-dependent strings (optional)
    if (@file_exists(dirname(__FILE__).'/lang/eng.php')) {
      require_once(dirname(__FILE__).'/lang/eng.php');
      PDF::setLanguageArray($l);
    }
    // set font
    PDF::SetFont('times', '', 7);
    // add a page
    PDF::AddPage();
    // set cell padding
    PDF::setCellPaddings(1, 1, 1, 1);

    $image_file = public_path().'/uploads/silmi_logo_invoice1.png';

    PDF::Image($image_file, '','',40, 25, 'png', 'https://silmijapan.com', '', true, 150, '', false, false, 1, false, false, false);
 
        $html = <<<EOD
    <h2 style="text-align: center; color:#ED7D31">SILMI JAPAN CO., LTD.<br/>
    3-6-28, Miyanosaka, Hirakata-city, Osaka, Japan<br/>
    PHONE: +81-72-392-4971
    </h2>
    <h1 style="text-align: center; color:#FF0000">PROFORMA INVOICE</h1>
    
    EOD;
    
        // Print text using writeHTMLCell()
        PDF::writeHTMLCell(0, 0, 45, '', utf8_decode($html), 0, 1, 0, true, '', true);
    
        $html = <<<EOD
    <p>
    Home page: <a href="https://silmijapan.com" dir="ltr">https://silmijapan.com</a>
    </p>
    <br/>
    <hr>
    EOD;
    
        // Print text using writeHTMLCell()
        PDF::writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
    $html = '<table border="0" style="width:60%;">
    <tbody>
        <tr> 
            <th style="border: 0.1px solid black;padding:8px;" width="25%" height="15">CUSTOMER NAME </th>
            <td style="border: 0.1px solid black;vertical-align: middle" width="75%" height="15"><span>'.$data[0]->cus_name.'</span></td>
        </tr>
        <tr> 
            <th style="border: 0.1px solid black;" width="25%" height="15">PHONE NUMBER </th>
            <td style="border: 0.1px solid black;" width="75%" height="15">'.$data[0]->phone_number.'</td>
        </tr>
        <tr> 
            <th style="border: 0.1px solid black;">&nbsp;<br/>ADDRESS </th>
            <td style="border: 0.1px solid black;" height="25"><span>'.$data[0]->cus_address.'</span></td>
        </tr>
    <tbody>    
    </table>';

    // Print text using writeHTMLCell()
    PDF::writeHTMLCell(0, 0, '', 53, $html, 0, 1, 0, true, 'C', false);

    $html = '<table style="">
    <tbody>
        <tr> 
            <th style="border: 0.1px solid black;" height="15">DATE </th>
            <td style="border: 0.1px solid black;" height="15">'.$data[0]->issue_date.'</td>
        </tr>
        <tr> 
            <th style="border: 0.1px solid black;" height="15">INVOICE NUMBER </th>
            <td style="border: 0.1px solid black;" height="15">'.$invoice_no.'</td>
        </tr>
        <tr> 
            <th style="border: 0.1px solid black;" height="15">EXPIRATION DATE</th>
            <td style="border: 0.1px solid black;" height="15">'.$data[0]->due_date.'</td>
    
        </tr>
    <tbody>    
    </table><br/><br/><br/><br/>';
    
     
    // Print text using writeHTMLCell()
    PDF::writeHTMLCell(0, 0,130, 53, $html, 0, 1, 0, true, 'C', true);
    
    $html = '<hr><br/><table border="0.1" style="width:100%">
                <thead>
                    <tr align="center">
                        <th width="8%" height="15">STOCK NO</th>
                        <th width="16%" height="15">MAKER</th>
                        <th width="6%" height="15">YEAR</th>
                        <th width="13%" height="15">CHASSIS NUMBER</th>
                        <th width="5%" height="15">UNIT</th>
                        <th width="10%" height="15">COLOR</th>
                        <th width="8%" height="15">PRICE</th>
                        <th width="7%" height="15">FREIGHT</th>
                        <th width="9%" height="15">INSURANCE </th>
                        <th width="8%" height="15">VANNING </th>
                        <th width="10%" height="15">TOTAL</th>
                    </tr>
                </thead>
                <tbody>';
    
            $total_unit =0;
            $any_total = 0;
            $actual_price =0;
            $freight = 0;
            $any_total =0;
            $insurance =0;
            $vanning = 0;
            $discount =0;
            $discountprice = 0;
            $grand_total = 0;
            $deposit = 0; 
        foreach($data as $dataRow) {
                $dobs = trim($dataRow->date_of_production);
                $final_destination="";
                if(!empty($dobs)){
                    $dop = $dataRow->date_of_production;
                    $dopex = explode(' ',$dop);
                    $numMonth = date('m', strtotime($dopex[0]));
                    $modelYear = $dopex[1]."/".$numMonth;
                }else{
                    $modelYear = $dataRow->car_model_year;
                }
                if($dataRow->freight_fee > 0){
                    $freight = $dataRow->freight_fee;
                }
                if($dataRow->insurance > 0){
                    $insurance = $dataRow->insurance;
                }
                if(!empty($dataRow->final_des_name)){
                    $final_destination = $dataRow->final_des_name;
                }
                if(!empty($dataRow->vanning)){
                    $vanning = $dataRow->vanning;
                }
    
                $actual_price = $dataRow->fob;
               
                $discount = $dataRow->discount;
                $any_total = @$actual_price + @$freight + @$insurance + $vanning;
                $last_total = $any_total - @$discount;
                $grand_total += $last_total;
                $discountprice +=$discount;
                if(!empty($dataRow->country_name)){
                     $country_destination = $dataRow->country_name;
                }
              
                if(!empty($dataRow->deposit)){
                     $deposit = $dataRow->deposit;
                }
    
    
                switch ($dataRow->currency) {  
                  case 'USD':
                  $currency_mark = '$';
                  break;
                  case 'KRW':
                  $currency_mark = '₩';
                  break;    
                  case 'JPY':
                  $currency_mark = '&#165;';
                  break;
                  case 'EUR':
                  $currency_mark = '€';
                  break;   
                  default:
                  $currency_mark = '';
                  break;
                }
                if (!empty($dataRow->car_model_year)) {
                    $dateofpro = $dataRow->car_model_year;
                }
            $html .='<tr align="center">
              <td width="8%" height="15">'.$dataRow->car_stock_id.'</td>
              <td width="16%" height="15">'.$dataRow->car_make_name.'</td>
              <td width="6%" height="15">'.$modelYear.'</td>
              <td width="13%" height="15">'.$dataRow->chassis_number.'</td>
              <td width="5%" height="15">1</td>
              <td width="10%" height="15">'.$dataRow->color_name.'</td>
              <td width="8%" height="15">'.number_format($dataRow->fob).' '.$currency_mark.'</td>
              <td width="7%" height="15">'.number_format($freight).' '.$currency_mark.'</td>
              <td width="9%" height="15">'.number_format($insurance).' '.$currency_mark.'</td>
              <td width="8%" height="15">'.number_format($vanning).' '.$currency_mark.'</td>
              <td width="10%" height="15">'.number_format($any_total).' '.$currency_mark.'</td>
              
            </tr>';
            $total_unit = $total_unit + 1;
        } 
    
        $grant_balance = $grand_total - $deposit - $discountprice;
        $html .='</tbody></table>';                   
               
        // Print text using writeHTMLCell()
         PDF::writeHTMLCell(0, 0,'', '', $html, 0, 1, 0, true, '', true);
    
        $html = '<table style="border-collapse: collapse;">
        <tr> 
            <th colspan="7"></th>
            <th align="center" border="0.1" height="15">QUANTITY</th>
            <th align="center" border="0.1" height="15">TOTAL</th> 
            <th width="2%"></th>
            <th align="center" border="0.1" height="15">TOTAL</th>
            <th width="15%" align="center" border="0.1" height="15">'.number_format($grand_total).' '.$currency_mark.'</th>
        </tr>
        <tr> 
            <td colspan="7" border="0.1" style="color:red;"  height="15">TOTAL</td>
            <td align="center" border="0.1" height="15">'.$total_unit.'</td>
            <td align="center" border="0.1" height="15">'.number_format($grand_total).' '.$currency_mark.'</td>
            <td width="2%"></td>
            <td align="center" border="0.1" height="15">DEPOSIT</td>
            <td width="15%" align="center" border="0.1" height="15">'.number_format($deposit).' '.$currency_mark.'</td>
            
        </tr>
        <tr>
            <td colspan="10"  style="color:red;"  height="15"></td>
            <td align="center" border="0.1" height="15">DISCOUNT</td>
            <td width="15%" align="center" border="0.1" height="15">'.number_format($discountprice).' '.$currency_mark.'</td>
        </tr>
        <tr>
        <td colspan="10" style="color:red;"  height="15"></td>
            <td align="center" border="0.1" height="15">FINAL BALANCE</td>
            <td width="15%" align="center" border="0.1" height="15">&nbsp;<br/>'.number_format($grant_balance).' '.$currency_mark.'</td>
        </tr>
        </table>';
        
        PDF::writeHTMLCell(0, 0, '', '', utf8_decode($html), 0, 1, 0, true, '', true);
        
       $html = '<table style="width:300px;">
        <tbody>
            <tr> 
                <th style="border: 0.1px solid black; color:red;" height="15">Final destination </th>
                <td style="border: 0.1px solid black;" height="15">'.$final_destination.'</td>
            </tr>
          
        <tbody>    
        </table>';
    // Print text using writeHTMLCell()
    PDF::writeHTMLCell(0, 0,'', '', $html, 0, 1, 0, true, '', true);

    $html1 = '<p style="padding:0;margin:0;">BANK DETAILS</p>
   <p style="padding:0;margin:0;color:red; border:1px solid black;text-align:center;">BENEFICIARY BANk : '.@$data[0]->bank_eng_name.
   '<br/>BRANCH NAME : '.@$data[0]->branch_name.
   '<br/>SWIFT CODE : '.@$data[0]->swift_code.
   '<br/>BENEFICIARY ACCOUNT NUMBER : '.@$data[0]->account_number.
   '</p><br/><br/><br/>';

   // create some HTML content

    $html = '
    <table border="0">
    <tr> 
        <th style="">
            '.$html1.'<br/><br/>BENEFICIARY`S NAME & ADDRESS
            <p style="border:0.1px solid black; text-align:center;">Name: SILMI JAPAN CO., LTD.<br/>Address: 3-6-28, Miyanosaka, Hirakata-city, Osaka, Japan</p><br/>
        </th>
        <th align="center"><img src="'.public_path().'/uploads/silmi_signature.png" height="90" width="120">
            <br/><hr style="width:50%" ><br/>
            <h4>
                YOHEI MURASHIMA<br/>
                SILMI JAPAN CO., LTD.
                <p></p>
            </h4>
        </th>
    </tr>

    </table>';

    PDF::writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
        //Close and output PDF document
    return   PDF::Output('INVOICE.pdf', 'I');
 
}
function preview_invoice_cambodia_pdf_by_id($invoice_id){
    stream_context_set_default([
        'ssl' => [
            'verify_peer' => false,
            'verify_peer_name' => false,
        ]
    ]);

    $data = Invoice_model::get_data_proforma_invoice_for_customer_form_cambodia($invoice_id);

    if (!empty($data[0]->invoice_number)) {
        $invoice_no = $data[0]->invoice_number;
    } else {
        $invoice_no = $invoice_id;
    }


    $pdf = new PDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);
    // set document information
    // PDF::SetCreator(PDF_CREATOR);
    // PDF::SetAuthor('Nicola Asuni');
    PDF::SetTitle('INVOICE '.$invoice_id);
    PDF::SetSubject('TCPDF Tutorial');
    PDF::SetKeywords('TCPDF, PDF, example, test, guide');

    // remove default header/footer
    PDF::setPrintHeader(false);
    PDF::setPrintFooter(false);
    PDF::SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
    PDF::SetAutoPageBreak(TRUE, 0);

    // set image scale factor
    // PDF::setImageScale(PDF_IMAGE_SCALE_RATIO);

    // set some language-dependent strings (optional)
    if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
        require_once(dirname(__FILE__) . '/lang/eng.php');
        PDF::setLanguageArray($l);
    }

    // ---------------------------------------------------------

    // set font
    PDF::SetFont('times', '', 7);
    // add a page
    PDF::AddPage();
    // set cell padding
    PDF::setCellPaddings(1, 1, 1, 1);
    $image_file = public_path().'/uploads/silmi_logo_invoice1.png';
    // $image_file = file_get_contents('https://silmijapan.com/assets/fronend/images/logo/silmi_logo.png');
    PDF::Image($image_file, '', '', 40, 25, 'png', 'https://silmijapan.com', '', true, 150, '', false, false, 1, false, false, false);
    $html = <<<EOD
        <h2 style="text-align: center; color:#ED7D31">SILMI JAPAN CO., LTD.<br/>
        3-6-28, Miyanosaka, Hirakata-city, Osaka, Japan<br/>
        PHONE: +81-72-392-4971
        </h2>
        <h1 style="text-align: center; color:#FF0000">PROFORMA INVOICE</h1>
        EOD;

            // Print text using writeHTMLCell()
            PDF::writeHTMLCell(0, 0, 45, '', utf8_decode($html), 0, 1, 0, true, '', true);

            $html = <<<EOD
        <p>
        Home page: <a href="https://silmijapan.com" dir="ltr">https://silmijapan.com</a>
        </p>
        <br/>
        <hr>
        EOD;

            // Print text using writeHTMLCell()
            PDF::writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

            $html = '<table border="0" style="width:60%;">
        <tbody>
        <tr> 
        <th style="border: 0.1px solid black;padding:8px;" width="25%" height="15">CUSTOMER NAME </th>
        <td style="border: 0.1px solid black;vertical-align: middle" width="75%" height="15"><span>' . $data[0]->cus_name . '</span></td>
        </tr>
        <tr> 
        <th style="border: 0.1px solid black;" width="25%" height="15">PHONE NUMBER </th>
        <td style="border: 0.1px solid black;" width="75%" height="15">' . $data[0]->phone_number . '</td>
        </tr>
        <tr> 
        <th style="border: 0.1px solid black;">&nbsp;<br/>ADDRESS </th>
        <td style="border: 0.1px solid black;" height="25"><span>' . $data[0]->cus_address . '</span></td>
        </tr>
        <tbody>    
        </table>';


            // Print text using writeHTMLCell()
            PDF::writeHTMLCell(0, 0, '', 53, $html, 0, 1, 0, true, 'C', false);

            $html = '<table style="">
        <tbody>
        <tr> 
        <th style="border: 0.1px solid black;" height="15">DATE </th>
        <td style="border: 0.1px solid black;" height="15">' . $data[0]->issue_date . '</td>
        </tr>
        <tr> 
        <th style="border: 0.1px solid black;" height="15">INVOICE NUMBER </th>
        <td style="border: 0.1px solid black;" height="15">' . $invoice_no . '</td>
        </tr>
        <tr> 
        <th style="border: 0.1px solid black;" height="15">EXPIRATION DATE</th>
        <td style="border: 0.1px solid black;" height="15">' . $data[0]->due_date . '</td>

        </tr>
        <tbody>    
        </table><br/><br/><br/><br/>';


    // Print text using writeHTMLCell()
    PDF::writeHTMLCell(0, 0, 130, 53, $html, 0, 1, 0, true, 'C', true);

    $html = '<hr><br/><table border="0.1" style="width:100%">
    <thead>
        <tr align="center">
            <th width="8%" height="15">STOCK NO</th>
            <th width="16%" height="15">MAKER</th>
            <th width="6%" height="15">YEAR</th>
            <th width="13%" height="15">CHASSIS NUMBER</th>
            <th width="5%" height="15">UNIT</th>
            <th width="10%" height="15">COLOR</th>
            <th width="8%" height="15">PRICE</th>
            <th width="7%" height="15">FREIGHT</th>
            <th width="9%" height="15">TOTAL</th>
            <th width="9%" height="15">DEPOSIT </th>
            <th width="9%" height="15">BALANCE </th>
        </tr>
    </thead>
    <tbody>';

    $total_unit = 0;
        $any_total = 0;
        $actual_price = 0;
        $freight = 0;
        $any_total = 0;
        $insurance = 0;
        $vanning = 0;
        $discount = 0;
        $discountprice = 0;
        $grand_total = 0;
        $deposit = 0;
        $grandTotalCustomerDepoit = 0;
        $grandTotalCustomerBalance = 0;
        foreach ($data as $dataRow) {
            $dobs = trim($dataRow->date_of_production);
            if (!empty($dobs)) {
                $dop = $dataRow->date_of_production;
                $dopex = explode(' ', $dop);
                $numMonth = date('m', strtotime($dopex[0]));
                $modelYear = $dopex[1] . "/" . $numMonth;
            } else {
                $modelYear = $dataRow->car_model_year;
            }
            if ($dataRow->freight_fee > 0) {
                $freight = $dataRow->freight_fee;
            }
            if ($dataRow->insurance > 0) {
                $insurance = $dataRow->insurance;
            }
            $final_destination = '';
            if (!empty($dataRow->final_des_name)) {
                $final_destination = $dataRow->final_des_name;
            }
            if (!empty($dataRow->vanning)) {
                $vanning = $dataRow->vanning;
            }

            $actual_price = $dataRow->fob;

            $discount = $dataRow->discount;
            $any_total = @$actual_price + @$freight + @$insurance + $vanning;
            $last_total = $any_total - @$discount;
            $totalCustomerDepoit = $dataRow->total_deposit;
            $totalCustomerBalance = $dataRow->total_balance;
            $grandTotalCustomerDepoit += $totalCustomerDepoit;
            $grandTotalCustomerBalance += $totalCustomerBalance;
            $grand_total += $last_total;
            $discountprice += $discount;
            if (!empty($dataRow->country_name)) {
                $country_destination = $dataRow->country_name;
            }

            if (!empty($dataRow->deposit)) {
                $deposit = $dataRow->deposit;
            }


            switch ($dataRow->currency) {
                case 'USD':
                    $currency_mark = '$';
                    break;
                case 'KRW':
                    $currency_mark = '₩';
                    break;
                case 'JPY':
                    $currency_mark = '&#165;';
                    break;
                case 'EUR':
                    $currency_mark = '€';
                    break;
                default:
                    $currency_mark = '';
                    break;
            }
            if (!empty($dataRow->car_model_year)) {
                $dateofpro = $dataRow->car_model_year;
            }
            $html .= '<tr align="center">
                <td width="8%" height="15">' . $dataRow->car_stock_id . '</td>
                <td width="16%" height="15">' . $dataRow->car_make_name . '</td>
                <td width="6%" height="15">' . $modelYear . '</td>
                <td width="13%" height="15">' . $dataRow->chassis_number . '</td>
                <td width="5%" height="15">1</td>
                <td width="10%" height="15">' . $dataRow->color_name . '</td>
                <td width="8%" height="15">' . number_format($dataRow->fob) . ' ' . $currency_mark . '</td>
                <td width="7%" height="15">' . number_format($freight) . ' ' . $currency_mark . '</td>
                <td width="9%" height="15">' . number_format($any_total) . ' ' . $currency_mark . '</td>
                <td width="9%" height="15">' . number_format($totalCustomerDepoit) . ' ' . $currency_mark . '</td>
                <td width="9%" height="15">' . number_format($totalCustomerBalance) . ' ' . $currency_mark . '</td>
            </tr>';
                    $total_unit = $total_unit + 1;
                }

                $grant_balance = $grand_total - $deposit - $discountprice;
                $html .= '</tbody></table>';

                // Print text using writeHTMLCell()
                PDF::writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);

                $html = '<table style="border-collapse: collapse;">
        <tr> 
            <th colspan="6"></th>
            <th align="center" border="0.1" height="15">QUANTITY</th>
            <th align="center" border="0.1" height="15">TOTAL</th> 
            <th width="2%"></th>
            <th width="15%" align="center" border="0.1" height="15" colspan="2">TOTAL DEPOSIT</th>
            <th width="16%" align="center" border="0.1" height="15">' . number_format($grandTotalCustomerDepoit) . ' ' . $currency_mark . '</th>
        </tr>
        <tr> 
            <td colspan="6" border="0.1" style="color:red;"  height="15">TOTAL</td>
            <td align="center" border="0.1" height="15">' . $total_unit . '</td>
            <td align="center" border="0.1" height="15">' . number_format($grand_total) . ' ' . $currency_mark . '</td>
            <td width="2%"></td>
            <td width="15%" align="center" border="0.1" height="15" colspan="2">TOTAL BALANCE</td>
            <td width="16%" align="center" border="0.1" height="15">' . number_format($grandTotalCustomerBalance) . ' ' . $currency_mark . '</td>
            
        </tr>


        </table>';

                PDF::writeHTMLCell(0, 0, '', '', utf8_decode($html), 0, 1, 0, true, '', true);

                $html = '<table style="width:300px;">
        <tbody>
            <tr> 
                <th style="border: 0.1px solid black; color:red;" height="15">Final destination </th>
                <td style="border: 0.1px solid black;" height="15">' . $final_destination . '</td>
            </tr>
        
        <tbody>    
        </table>';
        PDF::writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
        $html1 = '<p style="padding:0;margin:0;">BANK DETAILS</p>
        <p style="padding:0;margin:0;color:red; border:1px solid black;text-align:center;">BENEFICIARY BANk : ' . @$data[0]->bank_eng_name .
            '<br/>BRANCH NAME : ' . @$data[0]->branch_name .
            '<br/>SWIFT CODE : ' . @$data[0]->swift_code .
            '<br/>BENEFICIARY ACCOUNT NUMBER : ' . @$data[0]->account_number .
            '</p><br/><br/><br/>';

        // create some HTML content

        $html = '
        <table border="0">
        <tr> 
            <th style="">
                ' . $html1 . '<br/><br/>BENEFICIARY`S NAME & ADDRESS
                <p style="border:0.1px solid black; text-align:center;">Name: SILMI JAPAN CO., LTD.<br/>Address: 3-6-28, Miyanosaka, Hirakata-city, Osaka, Japan</p><br/>
            </th>
            <th align="center"><img src="' . public_path() . '/uploads/silmi_signature.png" height="90" width="120">
               <br/><hr style="width:50%" ><br/>
            <h4>
                YOHEI MURASHIMA<br/>
                SILMI JAPAN CO., LTD.
            <p></p>
            </h4>
            </th>
        </tr>

        </table>';
    PDF::writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
        //Close and output PDF document
    return   PDF::Output('INVOICE.pdf', 'I');
    }

   
}