<?php

namespace App\Http\Controllers;

use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
class Sell_commission extends Controller
{
    public function get_stock_list_cars(Request $request)
    {
        $where_manul = " a.car_stock_id <>''";
        $where_manul .= " AND a.status > 1";
        $perPage = $request->get('perPage');
        $search = $request->get('search_data');
        $check = is_array(json_decode($search)) ? count(json_decode($search)) : 0;
        $where = array();
        $status_join = "";
        if ($check > 0) {
            foreach (json_decode($search) as $item) {
                if ($item->From_model_year) {
                    $where_manul .= " AND (a.car_model_year >= '" . $item->From_model_year . "' ) "; //
                }
                if ($item->To_model_year) {
                    $where_manul .= " AND (a.car_model_year <= '" . $item->To_model_year . "' ) "; //
                }
                if ($item->Car_mark) {
                    $where['a.car_make_en'] = $item->Car_mark; //
                }
                if ($item->Car_model) {
                    $where['a.car_model_en'] = $item->Car_model; //
                }
                if ($item->Car_status) {
                    $where['a.status'] = $item->Car_status; //
                }
                if ($item->Search_cus) {
                    $where['a.customer_id'] = $item->Search_cus; //
                }
                if ($item->Sales) {
                    $where['cus.staff_id'] = $item->Sales; //
                }
                $Search_option = $item->Search_option;
                if ($Search_option) {
                    if ($item->Search_box) {
                        if ($Search_option == "chassisno") {
                            $where_manul .= " AND (a.chassis_number LIKE '%" . trim($item->Search_box, ' ', ) . "%')";
                        } else if ($Search_option == "stockno") {
                            $con_stock = "";
                            $stock_ex = explode(" ", $item->Search_box);
                            foreach ($stock_ex as $val) {
                                $con_stock .= "'" . $val . "',";
                            }
                            $where_manul .= " AND ( a.stock_id IN(" . trim($con_stock, ",") . ") )";
                        }
                    }
                }
                $Search_date_start = $item->Search_date_start;
                $Search_date_ends = $item->Search_date_ends;
                if (!empty($Search_date_start) || !empty($Search_date_ends)) {
                    if ($item->Rang_date_option == "buying_date") {
                        if (!empty($Search_date_start) && !empty($Search_date_ends))
                            $where_manul .= " AND ( date(a.buying_date) >= '" . $Search_date_start . "' AND  date(a.buying_date) <= '" . $Search_date_ends . "' )";
                        elseif (!empty($Search_date_start) && empty($Search_date_ends))
                            $where_manul .= " AND ( date(a.buying_date) >= '" . $Search_date_start . "' ' )";
                        else
                            $where_manul .= " AND ( date(a.buying_date) <= '" . $Search_date_ends . "' )";
                    } elseif ($item->Rang_date_option == "paid_date") {
                        if (!empty($Search_date_start) && !empty($Search_date_ends))
                            $where_manul .= " AND ( date(a.paid_date) >= '" . $Search_date_start . "' AND  date(a.paid_date) <= '" . $Search_date_ends . "' )";
                        elseif (!empty($Search_date_start) && empty($Search_date_ends))
                            $where_manul .= " AND ( date(a.paid_date) >= '" . $Search_date_start . "'";
                        else
                            $where_manul .= " AND ( date(a.paid_date) <= '" . $Search_date_ends . "' )";
                    }
                }
            }
        }
        // DB::enableQueryLog();
        $his_tbl_filter = " SELECT * FROM `erp_cars_status_history` WHERE car_status_id IN ( SELECT MAX(car_status_id) FROM `erp_cars_status_history` GROUP BY stock_id) ";
        $data = DB::table('erp_stock_list as a')
            ->select('a.*', 'e.*', 'cus.*', 'st.full_name AS sale_name', 'cus.full_name AS cus_name')
            ->leftjoin('erp_stock_list_car_status As e', 'e.stock_list_car_status_id', '=', 'a.status')
            ->leftjoin('erp_customer AS cus', 'cus.customer_id', '=', 'a.customer_id')
            ->leftjoin('erp_staff AS st', 'cus.staff_id', '=', 'st.staff_id')
            ->leftjoin('erp_car_color AS color', 'color.color_id', '=', 'a.color')
            ->when($status_join == "show", function ($v) use ($his_tbl_filter) {
                $v->leftjoin(DB::raw('(' . $his_tbl_filter . ') AS his'), 'his.stock_id', '=', 'a.stock_id');
            })
            // ->groupBy('a.car_stock_id')
            ->orderBy('a.status', 'ASC')
            ->orderBy('a.buying_date', 'DESC')
            // ->toRawSql(20);
            ->whereRaw(DB::raw($where_manul))
            ->where($where)
            ->paginate($perPage);
        // dd(DB::getQueryLog());
        return response()->json([
            'stock_list_datas' => $data
        ], 200);
    }
    public function GetTotalCars(Request $request)
    {
        $where_manul = "a.car_stock_id <>''";
        $where_manul .= " AND a.status > 1";
        $status_join = "";
        $where = array();
        $search = $request->get('search_data');
        $check = is_array(json_decode($search)) ? count(json_decode($search)) : 0;
        if ($check > 0) {
            foreach (json_decode($search) as $item) {

                if ($item->Car_mark) {
                    $where['a.car_make_en'] = $item->Car_mark; //
                }
                if ($item->Car_model) {
                    $where['a.car_model_en'] = $item->Car_model; //
                }
                if ($item->Car_status) {
                    $where['a.status'] = $item->Car_status; //
                }
                if ($item->Search_cus) {
                    $where['a.customer_id'] = $item->Search_cus; //
                }
                if ($item->Sales) {
                    $where['cus.staff_id'] = $item->Sales; //
                }
                if ($item->From_model_year) {
                    $where_manul .= " AND (a.car_model_year >= '" . $item->From_model_year . "' ) "; //
                }
                if ($item->To_model_year) {
                    $where_manul .= " AND (a.car_model_year <= '" . $item->To_model_year . "' ) "; //
                }
                $Search_option = $item->Search_option;
                if ($Search_option) {
                    if ($item->Search_box) {
                        if ($Search_option == "chassisno") {
                            $where_manul .= " AND (a.chassis_number LIKE '%" . $item->Search_box . "%')"; //
                        } else if ($Search_option == "stockno") {
                            $con_stock = "";
                            $stock_ex = explode(" ", $item->Search_box);
                            foreach ($stock_ex as $val) {
                                $con_stock .= "'" . $val . "',";
                            }
                            $where_manul .= " AND ( a.stock_id IN(" . trim($con_stock, ",") . ") )";
                        }
                    }
                }
                $Search_date_start = $item->Search_date_start;
                $Search_date_ends = $item->Search_date_ends;
                if (!empty($Search_date_start) || !empty($Search_date_ends)) {
                    if ($item->Rang_date_option == "buying_date") {
                        if (!empty($Search_date_start) && !empty($Search_date_ends))
                            $where_manul .= " AND ( date(a.buying_date) >= '" . $Search_date_start . "' AND  date(a.buying_date) <= '" . $Search_date_ends . "' )";
                        elseif (!empty($Search_date_start) && empty($Search_date_ends))
                            $where_manul .= " AND ( date(a.buying_date) >= '" . $Search_date_start . "' ' )";
                        else
                            $where_manul .= " AND ( date(a.buying_date) <= '" . $Search_date_ends . "' )";
                    } elseif ($item->Rang_date_option == "paid_date") {
                        if (!empty($Search_date_start) && !empty($Search_date_ends))
                            $where_manul .= " AND ( date(a.paid_date) >= '" . $Search_date_start . "' AND  date(a.paid_date) <= '" . $Search_date_ends . "' )";
                        elseif (!empty($Search_date_start) && empty($Search_date_ends))
                            $where_manul .= " AND ( date(a.paid_date) >= '" . $Search_date_start . "'";
                        else
                            $where_manul .= " AND ( date(a.paid_date) <= '" . $Search_date_ends . "' )";
                    }
                }
            }
        }
        // DB::enableQueryLog();
        $his_tbl_filter = " SELECT * FROM `erp_cars_status_history` WHERE car_status_id IN ( SELECT MAX(car_status_id) FROM `erp_cars_status_history` GROUP BY stock_id) ";
        $data = DB::table('erp_stock_list as a')
            ->select(DB::raw("COUNT('a.*') AS total_car"))
            ->leftjoin('erp_stock_list_car_status As e', 'e.stock_list_car_status_id', '=', 'a.status')
            ->leftjoin('erp_customer AS cus', 'cus.customer_id', '=', 'a.customer_id')
            ->leftjoin('erp_staff AS st', 'cus.staff_id', '=', 'st.staff_id')
            ->leftjoin('erp_car_color AS color', 'color.color_id', '=', 'a.color')
            ->when($status_join == "show", function ($v) use ($his_tbl_filter) {
                $v->leftjoin(DB::raw('(' . $his_tbl_filter . ') AS his'), 'his.stock_id', '=', 'a.stock_id');
            })
            ->whereRaw(DB::raw($where_manul))
            ->where($where)
            ->orderBy('a.status', 'ASC')
            ->orderBy('a.buying_date', 'DESC')
            // ->toRawSql();
            ->get();
        //  dd(DB::getQueryLog());
        return response()->json([
            'total_car' => $data
        ], 200);
    }
    public function get_car_mark()
    {
        $data = DB::table('erp_car_make')
            ->select('*')
            ->from('erp_car_make')
            ->groupBy('car_make_id')
            ->orderBy('car_make_name', 'ASC')
            ->get();
        return response()->json([
            "CarMarks" => $data
        ], 200);
    }
    public function get_car_model()
    {
        //  DB::enableQueryLog();
        $data = DB::table('erp_car_model')
            ->select('erp_car_model.*')
            ->from('erp_car_model')
            ->join('erp_stock_list', 'erp_stock_list.car_model_id', '=', 'erp_car_model.car_model_id')
            ->groupBy('erp_car_model.car_model_id')
            ->orderBy('erp_car_model.car_model_name', 'ASC')
            ->get();
        //   dd(DB::getQueryLog());
        return response()->json([
            "CarModels" => $data
        ], 200);
    }
    public function get_car_status()
    {
        $data = DB::table('erp_stock_list_car_status')
            ->select('*')
            ->orderBy('stock_list_car_status_id', 'ASC')
            ->get();
        return response()->json([
            'CarStatus' => $data
        ], 200);
    }
    public function get_customer_info()
    {
        $data = DB::table('erp_customer AS a')
            ->select('a.*')
            ->leftjoin('erp_staff AS b', 'b.staff_id', '=', 'a.staff_id')
            ->where('a.full_name', '<>', '')
            ->orderBy('a.full_name', 'ASC')
            ->get();
        return response()->json([
            'GetCustomer' => $data
        ], 200);
    }
    public function select_sale()
    {
        $data = DB::table('erp_staff AS st')
            ->select('st.full_name', 'cs.customer_id AS cus_id', 'st.staff_id AS sale_id')
            ->leftjoin('erp_customer AS cs', 'cs.staff_id', '=', 'st.staff_id')
            ->where('st.full_name', '<>', '')
            ->groupBy('sale_id')
            ->orderBy('st.full_name', 'ASC')
            ->get();
        return response()->json([
            'GetSale' => $data
        ], 200);
    }
    public function Update_sell_commission(Request $request)
    {
        $edit_sell_com = $request->get('edit_sell_com');
        foreach (json_decode($edit_sell_com) as $item) {
            $stock_id = $item->Stock_id;
            $sell_commission = $item->Sell_commission;
            $paid_date = $item->Paid_date;
            $paid_status = $item->Paid_status;
            $data = array(
                'sell_commission' => $sell_commission,
                'paid_date' => empty($paid_date) ? NULL : $paid_date,
                'paid_status' => $paid_status
            );
            //============== add sell commission history  ==========//
            if (!empty($stock_id)) {
                // dd($stock_id);
                $get_car_info = DB::table('erp_stock_list')
                    ->select('*')
                    ->from('erp_stock_list')
                    ->leftjoin(
                        DB::raw('(SELECT bb.car_stock_id,bb.boss_price,bb.currency,bb.boss_price_type,bb.port_name FROM (SELECT * FROM erp_stock_list_boss_price ORDER BY boss_price_id DESC) AS bb GROUP BY bb.car_stock_id) AS boss', 'boss.car_stock_id = erp_stock_list.car_stock_id'),
                        function ($leftjoin) {
                            $leftjoin->on('boss.car_stock_id', '=', 'erp_stock_list.car_stock_id');
                        }
                    )
                    ->where('erp_stock_list.car_stock_id', $stock_id)
                    ->get();
            }
            if (@$get_car_info[0]->sell_commission != $sell_commission) {
                $user = Auth::user();
                // dd(   $user);
                $current_date_time = date('Y-m-d H:i:s');
                $data_sell_commission = array(
                    'stock_id' => $stock_id,
                    'sell_commission' => $sell_commission,
                    'create_dt' => $current_date_time,
                    'staff_id' => $user->staff_id,
                );

                DB::table('erp_sell_commission_history')
                    ->insert($data_sell_commission);
            }
            //============== Edit stocklist sell comission ==========//
            DB::table('erp_stock_list')
                ->where('stock_id', '=', $stock_id)
                ->update($data);
        }
    }

    public function get_stock_list_export_excel(Request $request)
    {
        $where_manul = " a.car_stock_id <>''";
        $where_manul .= " AND a.status > 1";
        $search = $request->get('search_data');
        $check = is_array(json_decode($search)) ? count(json_decode($search)) : 0;
        $where = array();
        if ($check > 0) {
            foreach (json_decode($search) as $item) {
                if ($item->From_model_year) {
                    $where_manul .= " AND (a.car_model_year >= '" . $item->From_model_year . "' ) "; //
                }
                if ($item->To_model_year) {
                    $where_manul .= " AND (a.car_model_year <= '" . $item->To_model_year . "' ) "; //
                }
                if ($item->Car_mark) {
                    $where['a.car_make_en'] = $item->Car_mark; //
                }
                if ($item->Car_model) {
                    $where['a.car_model_en'] = $item->Car_model; //
                }
                if ($item->Car_status) {
                    $where['a.status'] = $item->Car_status; //
                }
                if ($item->Search_cus) {
                    $where['a.customer_id'] = $item->Search_cus; //
                }
                if ($item->Sales) {
                    $where['cus.staff_id'] = $item->Sales; //
                }
                $Search_option = $item->Search_option;
                if ($Search_option) {
                    if ($item->Search_box) {
                        if ($Search_option == "chassisno") {
                            $where_manul .= " AND (a.chassis_number LIKE '%" . $item->Search_box . "%')"; //
                        } else if ($Search_option == "stockno") {
                            $con_stock = "";
                            $stock_ex = explode(" ", $item->Search_box);
                            foreach ($stock_ex as $val) {
                                $con_stock .= "'" . $val . "',";
                            }
                            $where_manul .= " AND ( a.stock_id IN(" . trim($con_stock, ",") . ") )";
                        }
                    }
                }
                $Search_date_start = $item->Search_date_start;
                $Search_date_ends = $item->Search_date_ends;
                if (!empty($Search_date_start) || !empty($Search_date_ends)) {
                    if ($item->Rang_date_option == "buying_date") {
                        if (!empty($Search_date_start) && !empty($Search_date_ends))
                            $where_manul .= " AND ( date(a.buying_date) >= '" . $Search_date_start . "' AND  date(a.buying_date) <= '" . $Search_date_ends . "' )";
                        elseif (!empty($Search_date_start) && empty($Search_date_ends))
                            $where_manul .= " AND ( date(a.buying_date) >= '" . $Search_date_start . "' ' )";
                        else
                            $where_manul .= " AND ( date(a.buying_date) <= '" . $Search_date_ends . "' )";
                    } elseif ($item->Rang_date_option == "paid_date") {
                        if (!empty($Search_date_start) && !empty($Search_date_ends))
                            $where_manul .= " AND ( date(a.paid_date) >= '" . $Search_date_start . "' AND  date(a.paid_date) <= '" . $Search_date_ends . "' )";
                        elseif (!empty($Search_date_start) && empty($Search_date_ends))
                            $where_manul .= " AND ( date(a.paid_date) >= '" . $Search_date_start . "'";
                        else
                            $where_manul .= " AND ( date(a.paid_date) <= '" . $Search_date_ends . "' )";
                    }
                }
            }
        }
        // DB::enableQueryLog();
        $data = DB::table('erp_stock_list as a')
            ->select('a.*', 'e.*', 'cus.*', 'st.full_name AS sale_name', 'cus.full_name AS cus_name', 'sold.total_sold_price AS sold_price', 'sold.currency AS sold_price_currency')
            ->from('erp_stock_list as a')
            ->leftjoin('erp_stock_list_car_status As e', 'e.stock_list_car_status_id', '=', 'a.status')
            ->leftjoin('erp_customer AS cus', 'cus.customer_id', '=', 'a.customer_id')
            ->leftjoin('erp_staff AS st', 'cus.staff_id', '=', 'st.staff_id')
            ->leftjoin('erp_car_color AS color', 'color.color_id', '=', 'a.color')
            ->leftjoin(
                DB::raw('(SELECT (IFNULL(res.fob,0) + IFNULL(res.freight_fee,0) + IFNULL(res.vanning,0) + IFNULL(res.insurance,0) + IFNULL(res.inspection,0) + IFNULL(res.other_fee,0) - IFNULL( res.discount, 0 )) AS total_sold_price,res.created_dt,res.stock_id, res.currency FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res GROUP BY res.stock_id) AS sold', 'sold.stock_id = a.stock_id'),
                function ($leftjoin) {
                    $leftjoin->on('sold.stock_id', '=', 'a.stock_id');
                }
            )
            ->whereRaw(DB::raw($where_manul))
            ->where($where)
            // ->groupBy('a.car_stock_id')
            ->orderBy('a.status', 'ASC')
            ->orderBy('a.buying_date', 'DESC')
            ->get();
        // dd(DB::getQueryLog());
        return response()->json([
            'stock_list_excel' => $data
        ], 200);
    }
}
