<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Shipping_model;
use App\Models\Stocklist_model;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;
use App\Http\Controllers\Status_update;
use Illuminate\Support\Facades\Mail;
use Illuminate\Mail\Mailable;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;
use File;
use ZipArchive;
use DateTime;

class Shipping extends Controller {

    public function index( Request $request ) {
        $tab = $request->get( 'tabs' );
        $perpage = $request->get( 'perPage' );
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list( $user->staff_id );

        if ( $tab == 'Vessel Master' ) {
            $sch_condition = $request->get( 'sch_condition' );

            $sch_discharge = $request->get( 'sch_discharge' );

            $sch_discharge      = trim( $sch_discharge );

            $sch_voyage    = $request->get( 'sch_voyage' );

            $sch_voyage      = trim( $sch_voyage );

            $sch_word      = $request->get( 'sch_word1' );

            $sch_word      = trim( $sch_word );

            $r_sch_condition = '';
            if ( $sch_condition == 'ship_invoice' ) {
                $r_sch_condition = 'erp_shipments.shipping_invoice_code';
            }
            if ( $sch_condition == 'shipping_company' ) {
                $r_sch_condition = 'shipping_co_name';
            }
            if ( $sch_condition == 'vessel_name' ) {
                $r_sch_condition = 'vessel_name';
            }
            if ( $sch_condition == 'yard' ) {
                $r_sch_condition = 'stock_yard_name';
            }
            if ( $sch_condition == 'port_of_loading' ) {
                $r_sch_condition = 'port_of_loading_name';
            }
            if ( $sch_condition == 'chassis_no' ) {

                $r_sch_condition = 'chassis_number';
            }
            $si = array();
            $bs = array();
            $sent_cancell = array();
            $pf = array();
            $get_bl = array();
            $total_car = array();

            $shiping_lists  = Shipping_model::get_shiping_list( $hide_pakistan, $perpage, $sch_discharge, $sch_voyage, $sch_condition, $r_sch_condition, $sch_word );
            $data[ 'shipping_company' ] = Shipping_model::get_shipping_company();
            $data[ 'discharges' ] = Shipping_model::get_discharge( $hide_pakistan );
            $data[ 'port_of_loading' ] = Shipping_model::get_port_of_loading();
            $count_freight = array();
            $created_dt_list = array();
            $sub_query = DB::raw( '(SELECT freight_fee AS count_freight,stock_id FROM erp_car_expenses
                                    WHERE
                                    freight_fee > 0
                                    GROUP BY
                                    stock_id
                                ) AS b' );
            $sub_query1 = DB::raw( ' (
                                        SELECT
                                            expenses_division_id,
                                            stock_id AS st_id
                                        FROM
                                            erp_car_expenses 
                                        WHERE freight_fee > 0
                                        GROUP BY
                                            stock_id
                                    ) AS b ' );
            foreach ( $shiping_lists as  $val ) {
                $count_freight_list = DB::table( 'erp_stock_list as a' )
                ->select( DB::raw( 'COUNT(b.count_freight) AS count_freight_fee' ) )
                ->leftjoin( $sub_query, 'b.stock_id', '=', 'a.stock_id' )
                ->where( 'a.shipment_id', '=', $val->shipment_id )
                ->get();
                $count_freight[ $val->shipment_id ] = $count_freight_list[ 0 ]->count_freight_fee;
                $created_dt = DB::table( 'erp_stock_list as a' )
                ->select( DB::raw( ' MAX(d.created_dt) as created_dt' ) )
                ->leftjoin( $sub_query1, 'b.st_id', '=', 'a.stock_id' )
                ->leftjoin( 'erp_expenses_division as c', 'c.expenses_division_id', '=', 'b.expenses_division_id' )
                ->leftjoin( 'erp_deposit_expense as d', 'd.deposit_expense_id', '=', 'c.deposit_expense_id' )
                ->where( 'shipment_id', '=', $val->shipment_id )
                ->get();
                $created_dt_list[ $val->shipment_id ] = $created_dt[ 0 ]->created_dt;

                if ( !empty( $val->invoice_si ) ) {
                    $si[ $val->shipment_id ]  = 1;
                } else {
                    $si[ $val->shipment_id ]  = 0;
                }
                if ( !empty( $val->booking_space ) ) {
                    $bs[ $val->shipment_id ]  = 1;
                } else {
                    $bs[ $val->shipment_id ]  = 0;
                }
                if ( !empty( $val->sent_cancellations ) ) {
                    $sent_cancell[ $val->shipment_id ]  = 1;
                } else {
                    $sent_cancell[ $val->shipment_id ]  = 0;
                }

                if ( !empty( $val->paid_freight ) ) {
                    $pf[ $val->shipment_id ]  = 1;
                } else {
                    $pf[ $val->shipment_id ]  = 0;
                }
                if ( !empty( $val->get_bl ) ) {
                    $get_bl[ $val->shipment_id ]  = 1;
                } else {
                    $get_bl[ $val->shipment_id ]  = 0;
                }

                if ( !empty( $val->total_car ) ) {
                    $total_car[ $val->shipment_id ]  = $val->total_car;
                } else {
                    $total_car[ $val->shipment_id ]  = 0;
                }
            }

            $data[ 'created_dt_list' ] = $created_dt_list;
            $data[ 'count_freight' ] = $count_freight;
            $data[ 'shiping_lists' ] = $shiping_lists;
            $data[ 'si' ] = $si;
            $data[ 'bs' ] = $bs;
            $data[ 'sent_cancell' ] = $sent_cancell;
            $data[ 'pf' ] = $pf;
            $data[ 'get_bl' ] = $get_bl;
            $data[ 'total_car' ] = $total_car;
        } else if ( $tab == 'Unbooked' ) {
            $sch_condition = $request->get( 'sch_condition' );
            $txt_search    = $request->get( 'txt_search' );
            $txt_search      = trim( $txt_search );

            $r_sch_condition = '';
            if ( $sch_condition == 'ship_invoice' ) {
                $r_sch_condition = 'invoice_no';
            }
            if ( $sch_condition == 'chassis_no' ) {
                $r_sch_condition = 'chassis_number';
            }

            $get_data_of_stocklist = Shipping_model::get_data_of_stocklist( $hide_pakistan, $perpage, $txt_search, $r_sch_condition );
            $result_bl = array();
            $result_lc = array();
            $result_invoice = array();
            $result_cancel = array();
            $result_certificate = array();
            $result_ec = array();
            foreach ( $get_data_of_stocklist as $val ) {

                $count_ec = DB::table( 'erp_stock_list_doc' )
                ->select( DB::raw( 'COUNT(*) as num_row' ) )
                ->whereRaw( 'doc_type="ec"' )
                ->where( 'stock_id', '=', $val->stock_id )
                ->get();
                $result_ec[ $val->stock_id ] = @$count_ec[ 0 ]->num_row;

                $count_bl = DB::table( 'erp_stock_list_doc' )
                ->select( DB::raw( 'COUNT(*) as num_row' ) )
                ->whereRaw( 'doc_type="bl"' )
                ->where( 'stock_id', '=', $val->stock_id )
                ->get();
                $result_bl[ $val->stock_id ] = @$count_bl[ 0 ]->num_row;

                $count_lc = DB::table( 'erp_stock_list_doc' )
                ->select( DB::raw( 'COUNT(*) as num_row' ) )
                ->whereRaw( 'doc_type="lc"' )
                ->where( 'stock_id', '=', $val->stock_id )
                ->get();
                $result_lc[ $val->stock_id ] = @$count_lc[ 0 ]->num_row;

                $count_invoice = DB::table( 'erp_stock_list_doc' )
                ->select( DB::raw( 'COUNT(*) as num_row' ) )
                ->whereRaw( 'doc_type="invoice"' )
                ->where( 'stock_id', '=', $val->stock_id )
                ->get();
                $result_invoice[ $val->stock_id ] = @$count_invoice[ 0 ]->num_row;

                $count_cancel = DB::table( 'erp_stock_list_doc' )
                ->select( DB::raw( 'COUNT(*) as num_row' ) )
                ->whereRaw( 'doc_type="cancel"' )
                ->where( 'stock_id', '=', $val->stock_id )
                ->get();
                $result_cancel[ $val->stock_id ] = @$count_cancel[ 0 ]->num_row;

                $count_certificate = DB::table( 'erp_stock_list_doc' )
                ->select( DB::raw( 'COUNT(*) as num_row' ) )
                ->whereRaw( 'doc_type="cancel"' )
                ->where( 'stock_id', '=', $val->stock_id )
                ->get();
                $result_certificate[ $val->stock_id ] = @$count_certificate[ 0 ]->num_row;

            }
            $data[ 'result_ec' ] = $result_ec;
            $data[ 'get_data_of_stocklist' ] = $get_data_of_stocklist;
            $data[ 'result_bl' ] = $result_bl;
            $data[ 'result_lc' ] = $result_lc;
            $data[ 'result_invoice' ] = $result_invoice;
            $data[ 'result_cancel' ] = $result_cancel;
            $data[ 'result_certificate' ] = $result_certificate;
        } else if ( $tab == 'BookList' ) {
            $user = Auth::user();
            $check_dubai_user = Shipping_model::check_dubai_users( $user->staff_id );
            $user_country = @$check_dubai_user[ 0 ]->country_list_id;
            $sch_condition = $request->get( 'sch_condition' );
            $txt_search    = $request->get( 'txt_search' );
            $sch_word      = trim( $txt_search );
            $sch_discharge = $request->get( 'sch_discharge' );
            $sch_discharge      = trim( $sch_discharge );
            $sch_voyage = $request->get( 'sch_voyage' );
            $sch_voyage      = trim( $sch_voyage );
            $sch_from = $request->get( 'sch_from' );
            $sch_from      = trim( $sch_from );

            $where = array();
            $where_manul = '';
            $r_sch_condition = '';

            if ( $sch_condition == 'ship_invoice' ) {
                $r_sch_condition = "erp_shipments.shipping_invoice_code LIKE '%".$sch_word."%'";
            }
            if ( $sch_condition == 'shipping_company' ) {

                $r_sch_condition = "shipping_co_name LIKE '%".$sch_word."%'";
            }
            if ( $sch_condition == 'vessel_name' ) {
                $r_sch_condition = "vessel_name LIKE '%".$sch_word."%'";
            }
            if ( $sch_condition == 'yard' ) {
                $r_sch_condition = "stock_yard_name LIKE '%".$sch_word."%'";
            }
            if ( $sch_condition == 'port_of_loading' ) {
                $r_sch_condition = "port_of_loading_name LIKE '%".$sch_word."%'";
            }

            if ( $sch_condition == 'chassis_no' ) {
                $shipment_id = 0;
                $shc_shipmetn_id = DB::table( 'erp_stock_list as a' )
                ->select( '*' )
                ->whereRaw( "chassis_number LIKE '%".$sch_word."%'" )
                ->get();
                if ( COUNT( $shc_shipmetn_id ) > 0 ) {
                    foreach ( $shc_shipmetn_id as $val ) {
                        $shipment_id = $val->shipment_id;
                    }
                }
                $where[ 'erp_shipments.shipment_id' ] = $shipment_id;

            }

            if ( !empty( $sch_word ) ) {
                if ( $sch_condition == 'customer_name' ) {
                    $shipment_id = '';
                    $sch_customer = DB::table( 'erp_stock_list as a' )
                    ->leftjoin( 'erp_customer as b', 'b.customer_id', '=', 'a.customer_id' )
                    ->whereRaw( "full_name LIKE '%".$sch_word."%'" )
                    ->whereRaw( 'a.shipment_id IS NOT NULL' )
                    ->groupBy( 'a.shipment_id' )
                    ->get();
                    if ( COUNT( $sch_customer ) > 0 ) {
                        foreach ( $sch_customer as $value ) {
                            $shipment_id .= $value->shipment_id.',';
                        }
                    }
                    if ( !empty( $shipment_id ) ) {
                        $where_manul = 'erp_shipments.shipment_id IN ('.trim( $shipment_id, ',' ).')';
                    } else {
                        $where_manul = 'erp_shipments.shipment_id IN ("")';
                    }
                } else if ( $sch_condition == 'car_yard_en' ) {
                    $shipment_id = '';
                    $sch_yard_en = DB::table( 'erp_stock_list as a' )
                    ->whereRaw( "a.car_yard_en LIKE '%".$sch_word."%'" )
                    ->whereRaw( 'a.shipment_id IS NOT NULL' )
                    ->groupBy( 'a.shipment_id' )
                    ->get();
                    if ( COUNT( $sch_yard_en ) > 0 ) {
                        foreach ( $sch_yard_en as $row ) {
                            $shipment_id .= $row->shipment_id.',';
                        }
                    }
                    if ( !empty( $shipment_id ) ) {
                        $where_manul = 'erp_shipments.shipment_id IN ('.trim( $shipment_id, ',' ).')';
                    } else {
                        $where_manul = 'erp_shipments.shipment_id IN ("")';
                    }
                    if ( !empty( $shipment_id ) ) {
                        $where_manul = 'erp_shipments.shipment_id IN ('.trim( $shipment_id, ',' ).')';
                    } else {
                        $where_manul = 'erp_shipments.shipment_id IN ("")';
                    }
                } else {
                    $where_manul = 'erp_shipments.shipment_id IS NOT NULL';
                }
            }

            //check car that shipping to dubai
            if ( $user_country == 248 ) {
                $where[ 'erp_shipments.discharge_id' ] = 40;
            }

            $get_data_from_shipment =  Shipping_model::get_shipment_invoice1();
            foreach ( $get_data_from_shipment as $row ) {
                $shipment_id = $row->shipment_id;
                $discharge_name = $row->discharge_name;
                $etd = $row->etd;
                $check_day = '';
                $Check_blD_shipment =  Shipping_model::check_bl_date( $shipment_id );
                $check_bl_status = false;
                foreach ( $Check_blD_shipment  as $value_bl ) {
                    if ( $value_bl->bl_date != '' ) {
                        $check_bl_status = true;
                    }

                }
                if ( $check_bl_status == true ) {
                    $alert_day = 5;
                    $check_day = $alert_day;
                } else {
                    if ( $discharge_name == 'JEBEL ALI' || $discharge_name == 'IQUIQUE,CHILE' || $discharge_name == 'SANTO DOMINGO, DOMINICAN REPUBLIC' ) {
                        $etD = date( 'Y-m-d', strtotime( '+14 day', strtotime( $etd ) ) );
                        $Ndate = date( 'Y-m-d' );
                        if ( $Ndate >= $etD ) {
                            $alert_day = 2;

                        } else {
                            $alert_day = 4;

                        }
                    } elseif ( $discharge_name == 'SIHANOUKVILLE, CAMBODIA' ) {
                        $etD = date( 'Y-m-d', strtotime( '+10 day', strtotime( $etd ) ) );
                        $Ndate = date( 'Y-m-d' );
                        if ( $Ndate >= $etD ) {
                            $alert_day = 2;
                        } else {
                            $alert_day = 4;
                        }

                    } else {
                        $alert_day = 4;
                    }

                    $check_day = $alert_day;
                }

                $data_row = array( 'check_day_shipment' => $check_day );
                DB::table( 'erp_shipments' )
                ->where( 'shipment_id', '=', $shipment_id )
                ->update( $data_row );
            }

            $get_shipment_invoice = Shipping_model::get_shipment_invoice( $hide_pakistan, $perpage, $where, $r_sch_condition, $where_manul, $sch_from, $sch_voyage, $sch_discharge );
            $data[ 'get_shipment_invoice' ] = $get_shipment_invoice;
        }
        return response()->json( [
            $data
        ] );
    }

    public function add_docs_date( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        $docs_date = $request->get( 'doc_date' );
        $data[ 'docs_date' ] = $docs_date;

        if ( !empty( $shipment_id ) && !empty( $docs_date ) ) {
            DB::table( 'erp_shipments' )
            ->where( 'shipment_id', '=', $shipment_id )
            ->update( $data );
        }
    }

    public function add_ship_company( Request $request ) {
        $ship_com = $request->get( 'new_company_name' );
        $insert_data = array(
            'shipping_co_name' => $ship_com,
            'create_date'      => date( 'Y-m-d' )
        );

        DB::table( 'erp_shipping_company' )
        ->insert( $insert_data );
        $data[ 'shipping_company' ] = Shipping_model::get_shipping_company();
        return response()->json( [
            $data
        ] );

    }

    public function add_port_loading( Request $request ) {
        $port_of_loading =  $request->get( 'new_port_loading' );

        $insert_data = array(
            'port_of_loading_name' => $port_of_loading,
            'create_date'      => date( 'Y-m-d' )
        );
        DB::table( 'erp_port_of_loading' )
        ->insert( $insert_data );
        $data[ 'port_of_loading' ] = Shipping_model::get_port_of_loading();
        return response()->json( [
            $data
        ] );

    }

    public function add_discharge( Request $request ) {
        $discharge =  $request->get( 'new_discharge' );

        $insert_data = array(
            'discharge_name' => $discharge,
            'create_date'      => date( 'Y-m-d' )
        );
        DB::table( 'erp_discharge' )
        ->insert( $insert_data );
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list( $user->staff_id );
        $data[ 'discharges' ] = Shipping_model::get_discharge( $hide_pakistan );
        return response()->json( [
            $data
        ] );

    }

    public function add_shipment( Request $request ) {
        $ship_invoice = $request->get( 'ship_invoice' );
        $stock_ids = $request->get( 'idxs' );
        $ship_co   = $request->get( 'ship_co_1' );
        $vessel_name = $request->get( 'vessel_name' );
        $voyage_no =   $request->get( 'voyage_no' );
        $car_amount =   $request->get( 'car_amount' );
        $port_loading = $request->get( 'port_loading' );
        $discharge = $request->get( 'discharge' );
        $booking = $request->get( 'booking' );
        $issue = $request->get( 'issue' );
        $freight = $request->get( 'freight' );
        $eta = $request->get( 'eta' );
        $etd = $request->get( 'etd' );
        if ( $eta == '' ) {
            $eta = date( 'Y-m-d' );
        }
        if ( $etd == '' ) {
            $etd = date( 'Y-m-d' );
        }
        $data = array(
            'shipping_invoice_code' => $ship_invoice,
            'shipping_co_id' => $ship_co,
            'vessel_name' => $vessel_name,
            'voyage_no' => $voyage_no,
            'car_amount' => 100,
            'port_of_loading_id' => $port_loading,
            'discharge_id' => $discharge,
            'eta' => $eta,
            'etd' => $etd,
            'booking' => $booking,
            'bl_issue_by' => $issue,
            'freight' => $freight,
        );
        DB::table( 'erp_shipments' )
        ->insert( $data );
        return response()->json( [
            'status' => true
        ] );

    }

    public function update_shipping_step( Request $request ) {
        $ship_invoice = $request->get( 'ship_invoice' );
        $stock_ids = $request->get( 'idxs' );
        $ship_co   = $request->get( 'ship_co_1' );
        $vessel_name = $request->get( 'vessel_name' );
        $voyage_no =   $request->get( 'voyage_no' );
        $car_amount =   $request->get( 'car_amount' );
        $port_loading = $request->get( 'port_loading' );
        $discharge = $request->get( 'discharge' );
        $booking = $request->get( 'booking' );
        $issue = $request->get( 'issue' );
        $freight = $request->get( 'freight' );
        $eta = $request->get( 'eta' );
        $etd = $request->get( 'etd' );
        $shipment_id = $request->get( 'shipment_id' );
        if ( $eta == '' ) {
            $eta = date( 'Y-m-d' );
        }
        if ( $etd == '' ) {
            $etd = date( 'Y-m-d' );
        }
        $data = array(
            'shipping_invoice_code' => $ship_invoice,
            'shipping_co_id' => $ship_co,
            'vessel_name' => $vessel_name,
            'voyage_no' => $voyage_no,
            'car_amount' => 100,
            'port_of_loading_id' => $port_loading,
            'discharge_id' => $discharge,
            'eta' => $eta,
            'etd' => $etd,
            'booking' => $booking,
            'bl_issue_by' => $issue,
            'freight' => $freight,
        );
        DB::table( 'erp_shipments' )
        ->where( 'shipment_id', '=', $shipment_id )
        ->update( $data );
        return response()->json( [
            'status' => true
        ] );
    }

    public function delete_invoice_by_shipping_invoice( Request $request ) {
        $shipment_ids = $request->get( 'shipment_ids' );
        $arr_shipment_id = explode( ',', $shipment_ids );

        foreach ( $arr_shipment_id as $shipment_id ) {
            $data = array(
                'shipment_id' => null
            );

            Shipping_model::update_shipment_stock_list( $shipment_id, $data );
            DB::table( 'erp_shipments' )
            ->where( 'shipment_id', '=', $shipment_id )
            ->delete();
        }
        return response()->json( [
            'status' => true
        ] );
    }

    public function add_note_to_vessel( Request $request ) {
        $shipment_id = $request->get( 'shipment_ids' );
        $getNote = $request->get( 'new_note' );
        $note_arr = array( 'note_spearpath' => $getNote );
        Shipping_model::update_note( $shipment_id, $note_arr );
        return response()->json( [
            'status' => true
        ] );
    }

    public function update_booking_spece( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        $booking_space = $request->get( 'booking' );
        if ( $booking_space == 0 ) {

            $data = array(
                'booking_space' => date( 'Y-m-d' )
            );
        } else {
            $data = array(
                'booking_space' => null
            );
        }
        Shipping_model::update_booking_spece( $shipment_id, $data );
        return response()->json( [
            'status' => true
        ] );
    }

    public function update_invoice_sl( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        $bs = $request->get( 'bs' );
        $si = $request->get( 'si' );
        if ( $si == 0 ) {
            $data = array(
                'invoice_si' => date( 'Y-m-d' )
            );
        } else {
            $data = array(
                'invoice_si' => null
            );
        }
        Shipping_model::update_booking_spece( $shipment_id, $data );
        return response()->json( [
            'status' => true
        ] );
    }

    public function update_get_bl( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        $get_bl = $request->get( 'get_bl' );
        if ( $get_bl == 0 ) {

            $data = array(
                'get_bl' => date( 'Y-m-d' )
            );
        } else {
            $data = array(
                'get_bl' => null
            );
        }
        Shipping_model::update_booking_spece( $shipment_id, $data );
        return response()->json( [
            'status' => true
        ] );
    }

    public function add_dhl_vessel( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        $txt_dlh = $request->get( 'txt_dlh' );
        $company_dhl = $request->get( 'company_dhl' );
        $contact_dhl = $request->get( 'contact_dhl' );
        $phone_dhl = $request->get( 'phone_dhl' );
        $email_dhl = $request->get( 'email_dhl' );
        $dlh_address = $request->get( 'dlh_address' );
        $data[ 'dhl_number' ] = $txt_dlh;
        $data[ 'company_dhl' ] = $company_dhl;
        $data[ 'contact_dhl' ] = $contact_dhl;
        $data[ 'phone_dhl' ] = $phone_dhl;
        $data[ 'email_dhl' ] = $email_dhl;
        $data[ 'dhl_address' ] = $dlh_address;
        if ( $shipment_id ) {
            DB::table( 'erp_stock_list' )
            ->where( 'shipment_id', '=', $shipment_id )
            ->update( $data );
        }

    }

    public function get_dhl_info( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        $Dhl_list = DB::table( 'erp_stock_list' )
        ->select( DB::raw( 'dhl_number,company_dhl,contact_dhl,phone_dhl,email_dhl,dhl_address,stock_id' ) )
        ->where( 'shipment_id', '=', $shipment_id )
        ->get();
        return response()->json( [
            'Dhl_list' => $Dhl_list
        ] );
    }

    public function upload_file_all_doc_cars_execute( Request $request ) {

        $file_data = $request->file( 'files' );
        $page = $request->get( 'page' );
        $shipment_id = $request->get( 'shipment_id' );
        $data = array();
        $check_insert = '';
        $photo_order = 0;

        if ( $request->hasFile( 'files' ) ) {
            $targetPath = 'uploads/pdf_files/';
            $apiKey  = 'vuthy32@gmail.com_eb090f7c04d550ee5a59c92455fcfbeee72711e9c7c66625507106c779d3b139cbc354f5';

            foreach ( $file_data as $file ) {
                $fname_compress = date( 'Ymd_His' ) . '_' . mt_rand( '0000000', '9999999' ) . '.' . 'pdf';
                $photo_order += 1;
                $fileName = time().'_'.$file->getClientOriginalName();
                $ext = explode( '.', $file->getClientOriginalName() );
                $ext = end( $ext );
                $ext = strtolower( $ext );
                $stock_id = '';
                if ( $ext != 'pdf' && $ext != 'gif' && $ext != 'jpg' && $ext != 'jpeg' && $ext != 'png' ) {
                    echo json_encode( 'You can upload only file pdf!' );
                }

                if ( $ext == 'pdf' ) {

                    $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                    '?name=' . urlencode( $file->getClientOriginalName() ) .
                    '&contenttype=application/octet-stream';
                    // Create request
                    $curl = curl_init();
                    curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                    curl_setopt( $curl, CURLOPT_URL, $url );
                    curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                    // Execute request
                    $result = curl_exec( $curl );

                    if ( curl_errno( $curl ) == 0 ) {
                        $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                        if ( $status_code == 200 ) {
                            $json = json_decode( $result, true );

                            // Get URL to use for the file upload
                            $uploadFileUrl = $json[ 'presignedUrl' ];
                            // Get URL of uploaded file to use with later API calls
                            $uploadedFileUrl = $json[ 'url' ];

                            // 2. UPLOAD THE FILE TO CLOUD.

                            $localFile = $file->getRealPath();
                            $fileHandle = fopen( $localFile, 'r' );

                            curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                            curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                            curl_setopt( $curl, CURLOPT_PUT, true );
                            curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                            curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $localFile ) );

                            // Execute request
                            curl_exec( $curl );

                            fclose( $fileHandle );

                            if ( curl_errno( $curl ) == 0 ) {
                                $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                if ( $status_code == 200 ) {
                                    // 3. OPTIMIZE UPLOADED PDF FILE

                                    $this->OptimizePdf( $apiKey, $uploadedFileUrl, $fname_compress );
                                } else {
                                    // Display request error
                                    dd( '<p>Status code: ' . $status_code . '</p>' );

                                    echo '<p>' . $result . '</p>';

                                }
                            } else {
                                // Display CURL error
                                dd( 'Error: ' . curl_error( $curl ) );
                            }
                        }
                    } else {
                        // Display CURL error
                        echo 'Error: ' . curl_error( $curl );
                    }
                    move_uploaded_file( $file->getRealPath(), storage_path( 'app/public/'.$targetPath.$fname_compress ) );
                } elseif ( $ext == 'png' || $ext == 'jpeg' || $ext == 'jpg' ) {

                    $uploadedFiles = array();
                    $name_pdf = $fname_compress;

                    $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                    '?name=' . urlencode( $file->getClientOriginalName() ) .
                    '&contenttype=application/octet-stream';

                    // Create request
                    $curl = curl_init();
                    curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                    curl_setopt( $curl, CURLOPT_URL, $url );
                    curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                    // Execute request
                    $result = curl_exec( $curl );

                    if ( curl_errno( $curl ) == 0 ) {
                        $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                        if ( $status_code == 200 ) {
                            $json = json_decode( $result, true );

                            // Get URL to use for the file upload
                            $uploadFileUrl = $json[ 'presignedUrl' ];
                            // Get URL of uploaded file to use with later API calls
                            $uploadedFileUrl = $json[ 'url' ];

                            $tmpFilePath = $file->getRealPath();

                            $fileHandle = fopen( $tmpFilePath, 'r' );

                            curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                            curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                            curl_setopt( $curl, CURLOPT_PUT, true );
                            curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                            curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $tmpFilePath ) );

                            // Execute request
                            curl_exec( $curl );

                            if ( curl_errno( $curl ) == 0 ) {
                                $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                if ( $status_code == 200 ) {
                                    $uploadedFiles[] = $uploadedFileUrl;
                                } else {
                                    // Display request error
                                    echo '<p>Uploading File Status code: ' . $status_code . ' : ' . $uploadedFileUrl . '</p>';

                                    echo '<p>error status for uploading files (1 means error related to php.ini config or tmp folder permissions): ' . $_FILES[ 'files' ][ 'error' ] . '</p>';
                                    echo '<p>' . $result . '</p>';

                                }
                            } else {
                                // Display CURL error
                                return response()->json( [
                                    'status1' => false,
                                    'message1' => curl_error( $curl )
                                ] );
                            }

                            fclose( $fileHandle );
                        } else {
                            // Display request error
                            return response()->json( [
                                'status' => $status_code,
                                'message' => $result
                            ] );
                        }
                    } else {
                        // Display CURL error
                        return response()->json( [
                            'status' => 200,
                            'message' => curl_error( $curl )
                        ] );
                    }

                    curl_close( $curl );

                    if ( count( $uploadedFiles ) > 0 ) {
                        $this->ImageToPdf( $apiKey, $uploadedFiles, $name_pdf, $fname_compress );
                    }
                }

            }

            // if ( file_exists( storage_path( 'app/public/uploads/pdf_files/'.$fname_compress ) ) ) {

            $user = Auth::user();
            $updateData = [
                'car_document_file' => $fname_compress,
                'car_documents' => 'y',
            ];
            $data_shipment = Shipping_model::get_stock_id_by_shipment_id( $shipment_id );
            foreach ( $data_shipment as $val ) {
                DB::table( 'erp_stock_list' )
                ->where( 'stock_id', '=', $val->stock_id )
                ->update( $updateData );

                if ( $page === 'shipment' ) {
                    $data_documents = array(
                        'stock_id'      => $val->stock_id,
                        'status'        => 'YES',
                        'updated_date'  => date( 'Y-m-d H:i:s' ),
                        'staff_id'      => $user->staff_id
                    );
                    $stock_id = $val->stock_id;
                    Stocklist_model::add_car_documents_history( $data_documents );
                }
            }

            // } else {
            //     echo 'Failed';
            // }
            return response()->json( [
                'status' => true,
                'stock_id' => $stock_id,
                'message' => 'successfully'
            ] );
        }
    }

    public function UploadFileDocumentCar( Request $request ) {
        $manager = new ImageManager( new Driver() );
        $file_data = $request->file( 'files' );
        $stock_id = $request->get( 'stock_id' );
        $doc_type = $request->get( 'doc_type' );
        $shipment_id = $request->get( 'shipmentid' );
        $data = array();
        $check_insert = '';
        $photo_order = 0;
        if ( $request->hasFile( 'files' ) ) {
            $targetPath = 'uploads/pdf_files/';
            $apiKey  = 'vuthy32@gmail.com_eb090f7c04d550ee5a59c92455fcfbeee72711e9c7c66625507106c779d3b139cbc354f5';

            foreach ( $file_data as $file ) {
                $fname_compress = date( 'Ymd_His' ) . '_' . mt_rand( '0000000', '9999999' ) . '.' . 'pdf';
                $photo_order += 1;
                $fileName = time().'_'.$file->getClientOriginalName();
                $ext = explode( '.', $file->getClientOriginalName() );
                $ext = end( $ext );
                $ext = strtolower( $ext );
                if ( $ext != 'pdf' && $ext != 'gif' && $ext != 'jpg' && $ext != 'jpeg' && $ext != 'png' ) {
                    echo json_encode( 'You can upload only file pdf!' );
                }

                if ( $ext == 'pdf' ) {

                    $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                    '?name=' . urlencode( $file->getClientOriginalName() ) .
                    '&contenttype=application/octet-stream';
                    // Create request
                    $curl = curl_init();
                    curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                    curl_setopt( $curl, CURLOPT_URL, $url );
                    curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                    // Execute request
                    $result = curl_exec( $curl );

                    if ( curl_errno( $curl ) == 0 ) {
                        $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                        if ( $status_code == 200 ) {
                            $json = json_decode( $result, true );

                            // Get URL to use for the file upload
                            $uploadFileUrl = $json[ 'presignedUrl' ];
                            // Get URL of uploaded file to use with later API calls
                            $uploadedFileUrl = $json[ 'url' ];

                            // 2. UPLOAD THE FILE TO CLOUD.

                            $localFile = $file->getRealPath();
                            $fileHandle = fopen( $localFile, 'r' );

                            curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                            curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                            curl_setopt( $curl, CURLOPT_PUT, true );
                            curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                            curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $localFile ) );

                            // Execute request
                            curl_exec( $curl );

                            fclose( $fileHandle );

                            if ( curl_errno( $curl ) == 0 ) {
                                $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                if ( $status_code == 200 ) {
                                    // 3. OPTIMIZE UPLOADED PDF FILE

                                    $this->OptimizePdf( $apiKey, $uploadedFileUrl, $fname_compress );
                                } else {
                                    // Display request error
                                    dd( '<p>Status code: ' . $status_code . '</p>' );

                                    echo '<p>' . $result . '</p>';

                                }
                            } else {
                                // Display CURL error
                                dd( 'Error: ' . curl_error( $curl ) );
                            }
                        }
                    } else {
                        // Display CURL error
                        echo 'Error: ' . curl_error( $curl );
                    }
                    move_uploaded_file( $file->getRealPath(), storage_path( 'app/public/'.$targetPath.$fname_compress ) );
                } elseif ( $ext == 'png' || $ext == 'jpeg' || $ext == 'jpg' ) {

                    $uploadedFiles = array();
                    $name_pdf = $fname_compress;

                    $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                    '?name=' . urlencode( $file->getClientOriginalName() ) .
                    '&contenttype=application/octet-stream';

                    // Create request
                    $curl = curl_init();
                    curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                    curl_setopt( $curl, CURLOPT_URL, $url );
                    curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                    // Execute request
                    $result = curl_exec( $curl );

                    if ( curl_errno( $curl ) == 0 ) {
                        $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                        if ( $status_code == 200 ) {
                            $json = json_decode( $result, true );

                            // Get URL to use for the file upload
                            $uploadFileUrl = $json[ 'presignedUrl' ];
                            // Get URL of uploaded file to use with later API calls
                            $uploadedFileUrl = $json[ 'url' ];

                            $tmpFilePath = $file->getRealPath();

                            $fileHandle = fopen( $tmpFilePath, 'r' );

                            curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                            curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                            curl_setopt( $curl, CURLOPT_PUT, true );
                            curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                            curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $tmpFilePath ) );

                            // Execute request
                            curl_exec( $curl );

                            if ( curl_errno( $curl ) == 0 ) {
                                $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                if ( $status_code == 200 ) {
                                    $uploadedFiles[] = $uploadedFileUrl;
                                } else {
                                    // Display request error
                                    echo '<p>Uploading File Status code: ' . $status_code . ' : ' . $uploadedFileUrl . '</p>';

                                    echo '<p>error status for uploading files (1 means error related to php.ini config or tmp folder permissions): ' . $_FILES[ 'files' ][ 'error' ] . '</p>';
                                    echo '<p>' . $result . '</p>';

                                }
                            } else {
                                // Display CURL error
                                return response()->json( [
                                    'status' => false,
                                    'message' => curl_error( $curl )
                                ] );
                            }

                            fclose( $fileHandle );
                        } else {
                            // Display request error
                            return response()->json( [
                                'status' => $status_code,
                                'message' => $result
                            ] );
                        }
                    } else {
                        // Display CURL error
                        return response()->json( [
                            'status' => 200,
                            'message' => curl_error( $curl )
                        ] );
                    }

                    curl_close( $curl );

                    if ( count( $uploadedFiles ) > 0 ) {
                        $this->ImageToPdf( $apiKey, $uploadedFiles, $name_pdf, $fname_compress );
                    }
                }

            }

            if ( file_exists( storage_path( 'app/public/uploads/pdf_files/'.$fname_compress ) ) ) {

                $targetPath = storage_path( 'app/public/uploads/pdf_files/' );

                //upload file type bl
                if ( $doc_type == 'bl' ) {
                    $data[ 'stock_id' ] = $stock_id;

                    $data[ 'doc_type' ] = $doc_type;

                    $data[ 'file_name' ] = $fname_compress;

                    $data[ 'file_path' ]  = '/uploads/pdf_files/';

                    $data[ 'upload_date' ] = date( 'Y-m-d H:i:s' );

                    $count_doc = Stocklist_model::select_count_file_upload( $stock_id, $doc_type );

                    if ( $count_doc[ 0 ]->numrows > 0 ) {
                        Stocklist_model::update_count_file_upload( $stock_id, $doc_type, $data );
                    } else {
                        Stocklist_model::insert_count_file_upload( $data );
                    }

                    $this->send_email_for_stock_id( $shipment_id, $stock_id );
                } else {
                    $data[ 'stock_id' ] = $stock_id;

                    $data[ 'doc_type' ] = $doc_type;

                    $data[ 'file_name' ] = $fname_compress;

                    $data[ 'file_path' ]  = '/uploads/pdf_files/';

                    $data[ 'upload_date' ] = date( 'Y-m-d H:i:s' );

                    $count_doc = Stocklist_model::select_count_file_upload( $stock_id, $doc_type );
                    if ( $count_doc[ 0 ]->numrows > 0 ) {
                        Stocklist_model::update_count_file_upload( $stock_id, $doc_type, $data );
                    } else {
                        Stocklist_model::insert_count_file_upload( $data );
                    }

                }

            } else {
                echo 'Failed';
            }
            return response()->json( [
                'status' => true,
                'message' => 'successfully'
            ] );
        }

    }

    public function send_email_for_stock_id( $shipment_id, $stock_id ) {
        $details_imformation_shipemnt = Shipping_model::get_car_in_stocklist_by_shipment_id1( $shipment_id );
        $details_infomation_id = Shipping_model::get_car_in_stocklist_for_email_of_id( $shipment_id, $stock_id );
        foreach ( $details_imformation_shipemnt as $value2 ) {

            $shipping_invoice_code = $value2->shipping_invoice_code;
            $vessel_name = $value2->vessel_name;
            $form = $value2->port_of_loading_name;
            $voyage_no = $value2->voyage_no;
            $discharge_name = $value2->discharge_name;
            $etd = $value2->etd;
            $eta = $value2->eta;
            $Nowdate = date( 'Y-m-d' );
            if ( $discharge_name == 'JEBEL ALI' ) {
                $data = array( 'shipping_invoice_code' => $shipping_invoice_code, 'vessel_name' => $vessel_name, 'port_of_loading_name' => $form );
                $emails = [ 'mehdi@silmijapan.com', 'bl@silmijapan.com' ];
                $sendgrid = new \SendGrid( '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' );
                $text = '';
                $text .= '<h2>BL HAS BEEN UPLOADED('.$Nowdate.')</h2>';
                $text .= '<p>INVOICE NO: '.strtoupper( $shipping_invoice_code ).'</p>';
                $text .= '<p>VESSEL : '.$vessel_name.'</p>';
                $text .= '<p>FROM    : '.$form.'</p>';
                $text .= '<p>TO        : '.$discharge_name.' </p>';
                $text .= '<p>ETD       : '.$etd.' </p>';
                $text .= '<p>ETA       : '.$eta.' </p>';
                $text .= "<table style='width:100%;margin-right: 10px; border-collapse: collapse;' ><th style='border: 1px solid  #ddd;padding:15px;'>STOCK ID</th><th style='border: 1px solid #ddd;padding:15px;'>MODEL</th><th style='border: 1px solid #ddd;padding:15px;'>YEAR</th><th style='border: 1px solid #ddd;padding:15px;'>COLOR</th><th style=' border: 1px solid #ddd;padding:15px;'>CHASSIS NUMBER</th><th style=' border: 1px solid #ddd;padding:15px;'>CUSTOMER</th>";
                foreach ( $details_infomation_id as $row1 ) {
                    $stock_id = $row1->stock_id;
                    $car_model_name = $row1->car_model_name;
                    $car_model_year = $row1->car_model_year;
                    $car_model_color = $row1->color_name;
                    $chassis_number = $row1->chassis_number;
                    $customer_name = $row1->full_name;
                    $text .= "<tr><td style=' border: 1px solid #ddd;text-align:center;'>".$stock_id."</td><td style=' border: 1px solid #ddd;text-align:center;'>".$car_model_name."</td><td style='border: 1px solid #ddd;text-align:center;'>".$car_model_year."</td><td style='border: 1px solid #ddd;text-align:center;'>".$car_model_color."</td><td style='border: 1px solid #ddd;text-align:center;'>".$chassis_number."</td><td style='border: 1px solid #ddd;text-align:center;'>".$customer_name.'</td></tr>';
                }

                $text .= '</table>';
                $html = $text;
                $check_domain = $this->silmi_japan_com();
                foreach ( $emails as  $value ) {

                    $email = new \SendGrid\Mail\Mail();
                    $email->setFrom( 'info@silmijapan.com' );
                    $email->setSubject( 'BL HAS BEEN UPLOADED ('.$shipping_invoice_code.')' );
                    $to_email =  $check_domain == 1 ? $value : 'chumniththeng@gmail.com';
                    $email->addTo( $to_email );
                    $email->addContent( 'text/html', $html );
                    try {
                        $response = $sendgrid->send( $email );
                    } catch ( Exception $e ) {
                        echo 'Caught exception: '.  $e->getMessage(). '\n';
                    }
                }
            }
        }
    }

    public function edit_dhl_info( Request $request ) {
        $stock_dis = $request->get( 'dataChecked' );
        $txt_dlh = $request->get( 'txt_dlh' );
        $company_dhl = $request->get( 'company_dhl' );
        $contact_dhl = $request->get( 'contact_dhl' );
        $phone_dhl = $request->get( 'phone_dhl' );
        $email_dhl = $request->get( 'email_dhl' );
        $dlh_address = $request->get( 'dlh_address' );
        $shipment_id = $request->get( 'shipment_id' );

        $data[ 'dhl_number' ] = $txt_dlh;
        $data[ 'company_dhl' ] = $company_dhl;
        $data[ 'contact_dhl' ] = $contact_dhl;
        $data[ 'phone_dhl' ] = $phone_dhl;
        $data[ 'email_dhl' ] = $email_dhl;
        $data[ 'dhl_address' ] = $dlh_address;
        $arr_stock = explode( ',', $stock_dis );
        if ( !empty( $shipment_id ) ) {
            foreach ( $arr_stock as $stock ) {
                DB::table( 'erp_stock_list' )
                ->where( 'stock_id', '=', $stock )
                ->where( 'shipment_id', '=', $shipment_id )
                ->update( $data );
            }
        }

        $data = Shipping_model::get_data_stock_list( $shipment_id, $stock_dis );
        $user = Auth::user();
        foreach ( $data as $val ) {
            Status_update::update_car_status( $val->stock_id, $val->customer_id, $user->staff_id );
            Status_update::cancel_soldout_status( $val->stock_id, $user->staff_id );
        }
        return response()->json( [
            'status' => true,
            'message' => 'successfully'
        ] );
    }

    public function Unbooked( Request $request ) {
        $stock_dis = $request->get( 'dataChecked' );
        $shipment_id = $request->get( 'shipment_id' );
        $arr_stock = explode( ',', $stock_dis );

        $user = Auth::user();
        foreach ( $arr_stock as $stock_id ) {
            $data_stock = array(
                'shipment_id' => null,
                'booked_date' => null,
                'car_etd' => null
            );

            Shipping_model::update_stock_list( $stock_id, $data_stock );
            Status_update::cancel_releasebl_status( $stock_id, $user->staff_id );
        }
        return response()->json( [
            'shipment_id' =>$shipment_id,
            'status' => true,
            'message' => 'successfully'
        ] );

    }

    function send_email_to( $shipmentId ) {
        $details1 = Shipping_model::get_car_in_stocklist_by_shipment_id1( $shipmentId );
        $details2 =  Shipping_model::get_car_in_stocklist_for_email( $shipmentId );
        foreach ( $details1 as $value ) {
            $shipping_invoice_code = $value->shipping_invoice_code;
            $vessel_name = $value->vessel_name;
            $form = $value->port_of_loading_name;
            $voyage_no = $value->voyage_no;
            $discharge_name = $value->discharge_name;
            $etd = $value->etd;
            $eta = $value->eta;
            $Nowdate = date( 'Y-m-d' );
            if ( $discharge_name == 'JEBEL ALI' ) {
                $data = array( 'shipping_invoice_code' => $shipping_invoice_code, 'vessel_name' => $vessel_name, 'port_of_loading_name' => $form );
                $emails = [ 'mehdi@silmijapan.com', 'bl@silmijapan.com' ];

                $sendgrid = new \SendGrid( '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' );
                $text = '';
                $text .= '<h2>BL HAS BEEN UPLOADED('.$Nowdate.')</h2>';
                $text .= '<p>INVOICE NO: '.strtoupper( $shipping_invoice_code ).'</p>';
                $text .= '<p>VESSEL : '.$vessel_name.'</p>';
                $text .= '<p>FROM    : '.$form.'</p>';
                $text .= '<p>TO        : '.$discharge_name.' </p>';
                $text .= '<p>ETD       : '.$etd.' </p>';
                $text .= '<p>ETA       : '.$eta.' </p>';
                $text .= "<table style='width:100%;margin-right: 10px; border: 1px solid #ddd;  border-collapse: collapse;' ><th style='border: 1px solid #ddd;padding:15px;'>STOCK ID</th><th style='border: 1px solid #ddd;padding:15px;'>MODEL</th><th style='border: 1px solid #ddd;padding:15px;'>YEAR</th><th style='border: 1px solid #ddd;padding:15px;'>COLOR</th><th style=' border: 1px solid #ddd;padding:15px;'>CHASSIS NUMBER</th><th style=' border: 1px solid #ddd;padding:15px;'>CUSTOMER</th>";
                foreach ( $details2 as $value1 ) {
                    $stock_id = $value1->stock_id;
                    $car_model_name = $value1->car_model_name;
                    $car_model_year = $value1->car_model_year;
                    $car_model_color = $value1->color_name;
                    $chassis_number = $value1->chassis_number;
                    $customer_name = $value1->full_name;
                    $text .= "<tr><td style=' border: 1px solid #ddd;text-align:center;'>".$stock_id."</td><td style=' border: 1px solid #ddd;text-align:center;'>".$car_model_name."</td><td style='border: 1px solid #ddd;text-align:center;'>".$car_model_year."</td><td style='border: 1px solid #ddd;text-align:center;'>".$car_model_color."</td><td style='border: 1px solid #ddd;text-align:center;'>".$chassis_number."</td><td style='border: 1px solid #ddd;text-align:center;'>".$customer_name.'</td></tr>';
                }
                $text .= '</table>';
                $html = $text;
                $check_domain = $this->silmi_japan_com();
                foreach ( $emails as  $value ) {
                    $email = new \SendGrid\Mail\Mail();
                    $email->setFrom( 'info@silmijapan.com' );
                    $email->setSubject( 'BL HAS BEEN UPLOADED ('.$shipping_invoice_code.')' );
                    $to_email = $check_domain == 1 ? $value : 'chumniththeng@gmail.com';
                    $email->addTo( $to_email );
                    $email->addContent( 'text/html', $html );
                    try {

                        $response = $sendgrid->send( $email );
                    } catch ( Exception $e ) {
                        echo 'Caught exception: '.  $e->getMessage(). '\n';
                    }
                }
            }
        }

    }

    function getHost() {
        $possibleHostSources = array( 'HTTP_X_FORWARDED_HOST', 'HTTP_HOST', 'SERVER_NAME', 'SERVER_ADDR' );
        $sourceTransformations = array(
            'HTTP_X_FORWARDED_HOST' => function( $value ) {
                $elements = explode( ',', $value );
                return trim( end( $elements ) );
            }
        );
        $host = '';
        foreach ( $possibleHostSources as $source ) {
            if ( !empty( $host ) ) break;
            if ( empty( $_SERVER[ $source ] ) ) continue;
            $host = $_SERVER[ $source ];
            if ( array_key_exists( $source, $sourceTransformations ) ) {
                $host = $sourceTransformations[ $source ]( $host );
            }

        }

        // Remove port number from host
        $host = preg_replace( '/:\d+$/', '', $host );

        return trim( $host );
    }

    function silmi_japan_com() {
        return $this->getHost() == 'silmijapan.com' ? 1 : 0;

    }

    public function UploadFileStock( Request $request ) {
        $manager = new ImageManager( new Driver() );
        $file_data = $request->file( 'files' );
        $stock_id = $request->get( 'stock_id' );
        $doc_type = $request->get( 'doc_type' );
        $shipment_id = $request->get( 'shipment_id' );
        $data = array();
        $check_insert = '';
        $photo_order = 0;
        if ( $request->hasFile( 'files' ) ) {
            $targetPath = 'uploads/pdf_files/';
            $apiKey  = 'vuthy32@gmail.com_eb090f7c04d550ee5a59c92455fcfbeee72711e9c7c66625507106c779d3b139cbc354f5';

            foreach ( $file_data as $file ) {
                $fname_compress = date( 'Ymd_His' ) . '_' . mt_rand( '0000000', '9999999' ) . '.' . 'pdf';
                $photo_order += 1;
                $fileName = time().'_'.$file->getClientOriginalName();
                $ext = explode( '.', $file->getClientOriginalName() );
                $ext = end( $ext );
                $ext = strtolower( $ext );
                if ( $ext != 'pdf' && $ext != 'gif' && $ext != 'jpg' && $ext != 'jpeg' && $ext != 'png' ) {
                    echo json_encode( 'You can upload only file pdf!' );
                }

                if ( $ext == 'pdf' ) {

                    $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                    '?name=' . urlencode( $file->getClientOriginalName() ) .
                    '&contenttype=application/octet-stream';
                    // Create request
                    $curl = curl_init();
                    curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                    curl_setopt( $curl, CURLOPT_URL, $url );
                    curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                    // Execute request
                    $result = curl_exec( $curl );

                    if ( curl_errno( $curl ) == 0 ) {
                        $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                        if ( $status_code == 200 ) {
                            $json = json_decode( $result, true );

                            // Get URL to use for the file upload
                            $uploadFileUrl = $json[ 'presignedUrl' ];
                            // Get URL of uploaded file to use with later API calls
                            $uploadedFileUrl = $json[ 'url' ];

                            // 2. UPLOAD THE FILE TO CLOUD.

                            $localFile = $file->getRealPath();
                            $fileHandle = fopen( $localFile, 'r' );

                            curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                            curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                            curl_setopt( $curl, CURLOPT_PUT, true );
                            curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                            curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $localFile ) );

                            // Execute request
                            curl_exec( $curl );

                            fclose( $fileHandle );

                            if ( curl_errno( $curl ) == 0 ) {
                                $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                if ( $status_code == 200 ) {
                                    // 3. OPTIMIZE UPLOADED PDF FILE

                                    $this->OptimizePdf( $apiKey, $uploadedFileUrl, $fname_compress );
                                } else {
                                    // Display request error
                                    dd( '<p>Status code: ' . $status_code . '</p>' );

                                    echo '<p>' . $result . '</p>';

                                }
                            } else {
                                // Display CURL error
                                dd( 'Error: ' . curl_error( $curl ) );
                            }
                        }
                    } else {
                        // Display CURL error
                        echo 'Error: ' . curl_error( $curl );
                    }
                    move_uploaded_file( $file->getRealPath(), storage_path( 'app/public/'.$targetPath.$fname_compress ) );
                } elseif ( $ext == 'png' || $ext == 'jpeg' || $ext == 'jpg' ) {

                    $uploadedFiles = array();
                    $name_pdf = $fname_compress;

                    $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                    '?name=' . urlencode( $file->getClientOriginalName() ) .
                    '&contenttype=application/octet-stream';

                    // Create request
                    $curl = curl_init();
                    curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                    curl_setopt( $curl, CURLOPT_URL, $url );
                    curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                    // Execute request
                    $result = curl_exec( $curl );

                    if ( curl_errno( $curl ) == 0 ) {
                        $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                        if ( $status_code == 200 ) {
                            $json = json_decode( $result, true );

                            // Get URL to use for the file upload
                            $uploadFileUrl = $json[ 'presignedUrl' ];
                            // Get URL of uploaded file to use with later API calls
                            $uploadedFileUrl = $json[ 'url' ];

                            $tmpFilePath = $file->getRealPath();

                            $fileHandle = fopen( $tmpFilePath, 'r' );

                            curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                            curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                            curl_setopt( $curl, CURLOPT_PUT, true );
                            curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                            curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $tmpFilePath ) );

                            // Execute request
                            curl_exec( $curl );

                            if ( curl_errno( $curl ) == 0 ) {
                                $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                if ( $status_code == 200 ) {
                                    $uploadedFiles[] = $uploadedFileUrl;
                                } else {
                                    // Display request error
                                    echo '<p>Uploading File Status code: ' . $status_code . ' : ' . $uploadedFileUrl . '</p>';

                                    echo '<p>error status for uploading files (1 means error related to php.ini config or tmp folder permissions): ' . $_FILES[ 'files' ][ 'error' ] . '</p>';
                                    echo '<p>' . $result . '</p>';

                                }
                            } else {
                                // Display CURL error
                                return response()->json( [
                                    'status' => false,
                                    'message' => curl_error( $curl )
                                ] );
                            }

                            fclose( $fileHandle );
                        } else {
                            // Display request error
                            return response()->json( [
                                'status' => $status_code,
                                'message' => $result
                            ] );
                        }
                    } else {
                        // Display CURL error
                        return response()->json( [
                            'status' => 200,
                            'message' => curl_error( $curl )
                        ] );
                    }

                    curl_close( $curl );

                    if ( count( $uploadedFiles ) > 0 ) {
                        $this->ImageToPdf( $apiKey, $uploadedFiles, $name_pdf, $fname_compress );
                    }
                }
            }

            if ( file_exists( storage_path( 'app/public/uploads/pdf_files/'.$fname_compress ) ) ) {

                $targetPath = storage_path( 'app/public/uploadspdf_files/' );

                //upload file type bl
                //    if ( $doc_type == 'bl' ) {
                //         $get_stock_id = Stocklist_model::get_stock_id( $stock_id, $doc_type );
                //         foreach ( $get_stock_id as $stock_id ) {
                //             $data[ 'stock_id' ] = $stock_id->stock_id;

                //             $data[ 'doc_type' ] = $doc_type;

                //             $data[ 'file_name' ] = $fileName;

                //             $data[ 'file_path' ]  = '/upload/pdf_files/';

                //             $data[ 'upload_date' ] = date( 'Y-m-d H:i:s' );

                //             $count_doc = Stocklist_model::select_count_file_upload( $stock_id, $doc_type );

                //             if ( $count_doc > 0 ) {
                //                 Stocklist_model::update_count_file_upload( $stock_id, $doc_type, $data );
                //             } else {
                //                 Stocklist_model::insert_count_file_upload( $data );
                //             }
                //         }

                //     } else {
                $data[ 'stock_id' ] = $stock_id;

                $data[ 'doc_type' ] = $doc_type;

                $data[ 'file_name' ] = $fname_compress;

                $data[ 'file_path' ]  = '/uploads/pdf_files/';

                $data[ 'upload_date' ] = date( 'Y-m-d H:i:s' );

                $count_doc = Stocklist_model::select_count_file_upload( $stock_id, $doc_type );
                if ( $count_doc[ 0 ]->numrows > 0 ) {
                    Stocklist_model::update_count_file_upload( $stock_id, $doc_type, $data );
                } else {
                    Stocklist_model::insert_count_file_upload( $data );
                }

                // }
                // $this->send_email_for_stock_id( $shipment_id, $stock_id );
            } else {
                echo 'Failed';
            }
            return response()->json( [
                'status' => true,
                'message' => 'successfully'
            ] );
        }
    }

    function OptimizePdf( $apiKey, $uploadedFileUrl, $fname_compress ) {

        // Prepare URL for `Optimize PDF` API call
        $url = 'https://api.pdf.co/v1/pdf/optimize';

        // Prepare requests params
        $parameters = array();
        $parameters[ 'name' ] = 'result.pdf';
        $parameters[ 'url' ] = $uploadedFileUrl;

        // Create Json payload
        $data = json_encode( $parameters );

        // Create request
        $curl = curl_init();
        curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey, 'Content-type: application/json' ) );
        curl_setopt( $curl, CURLOPT_URL, $url );
        curl_setopt( $curl, CURLOPT_POST, true );
        curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
        curl_setopt( $curl, CURLOPT_POSTFIELDS, $data );

        // Execute request
        $result = curl_exec( $curl );

        if ( curl_errno( $curl ) == 0 ) {

            $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

            if ( $status_code == 200 ) {
                $json = json_decode( $result, true );

                if ( !isset( $json[ 'error' ] ) || $json[ 'error' ] == false ) {
                    $resultFileUrl = $json[ 'url' ];
                    $file_name = $fname_compress;
                    $c = $file_name;
                    file_put_contents( storage_path( 'app/public/uploads/pdf_files/file_compressed/'.$c ), file_get_contents( $resultFileUrl ) );
                } else {
                    // Display service reported error
                    dd( '<p>Error: ' . $json[ 'message' ] . '</p>' );

                }
            } else {
                // Display request error
                echo '<p>Status code: ' . $status_code . '</p>';

                echo '<p>' . $result . '</p>';

            }
        } else {
            // Display CURL error
            echo 'Error: ' . curl_error( $curl );
        }

        // Cleanup
        curl_close( $curl );
    }

    function ImageToPdf( $apiKey, $uploadedFiles, $fname_compress ) {
        // Create URL
        $url = 'https://api.pdf.co/v1/pdf/convert/from/image';

        // Prepare requests params
        $parameters = array();
        $parameters[ 'name' ] = 'result.pdf';
        $parameters[ 'url' ] = join( ',', $uploadedFiles );

        // Create Json payload
        $data = json_encode( $parameters );

        // Create request
        $curl = curl_init();
        curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey, 'Content-type: application/json' ) );
        curl_setopt( $curl, CURLOPT_URL, $url );
        curl_setopt( $curl, CURLOPT_POST, true );
        curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
        curl_setopt( $curl, CURLOPT_POSTFIELDS, $data );

        // Execute request
        $result = curl_exec( $curl );

        if ( curl_errno( $curl ) == 0 ) {
            $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

            if ( $status_code == 200 ) {
                $json = json_decode( $result, true );

                if ( !isset( $json[ 'error' ] ) || $json[ 'error' ] == false ) {
                    $resultFileUrl = $json[ 'url' ];
                    $c = $fname_compress;
                    file_put_contents( storage_path( 'app/public'.'/uploads/pdf_files/file_compressed/'.$c ), file_get_contents( $resultFileUrl ) );
                    file_put_contents( storage_path( 'app/public'.'/uploads/pdf_files/'.$c ), file_get_contents( $resultFileUrl ) );
                } else {
                    // Display service reported error
                    echo '<p>PDF.co API execution Error: ' . $json[ 'message' ] . '</p>';

                }
            } else {
                // Display request error
                echo '<p>API Call Status code: ' . $status_code . ': ' . $url . '</p>';

                echo '<p>' . $result . '</p>';

            }
        } else {
            // Display CURL error
            echo 'cURL Error 2: ' . curl_error( $curl );
        }

        // Cleanup
        curl_close( $curl );
    }

    function ImageToPdf1( $apiKey, $uploadedFiles, $fname_compress ) {
        // Create URL
        $url = 'https://api.pdf.co/v1/pdf/convert/from/image';

        // Prepare requests params
        $parameters = array();
        $parameters[ 'name' ] = 'result.pdf';
        $parameters[ 'url' ] = join( ',', $uploadedFiles );

        // Create Json payload
        $data = json_encode( $parameters );

        // Create request
        $curl = curl_init();
        curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey, 'Content-type: application/json' ) );
        curl_setopt( $curl, CURLOPT_URL, $url );
        curl_setopt( $curl, CURLOPT_POST, true );
        curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
        curl_setopt( $curl, CURLOPT_POSTFIELDS, $data );

        // Execute request
        $result = curl_exec( $curl );

        if ( curl_errno( $curl ) == 0 ) {
            $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

            if ( $status_code == 200 ) {
                $json = json_decode( $result, true );

                if ( !isset( $json[ 'error' ] ) || $json[ 'error' ] == false ) {
                    $resultFileUrl = $json[ 'url' ];
                    $c = $fname_compress;
                    file_put_contents( storage_path( 'app/public'.'/uploads/pdf_files/file_compressed/'.$c ), file_get_contents( $resultFileUrl ) );
                } else {
                    // Display service reported error
                    echo '<p>PDF.co API execution Error: ' . $json[ 'message' ] . '</p>';

                }
            } else {
                // Display request error
                echo '<p>API Call Status code: ' . $status_code . ': ' . $url . '</p>';

                echo '<p>' . $result . '</p>';

            }
        } else {
            // Display CURL error
            echo 'cURL Error 2: ' . curl_error( $curl );
        }

        // Cleanup
        curl_close( $curl );
    }

    public function get_shipment_id( Request $request ) {
        $select_count = '( SELECT shipment_id AS ship_id,stock_yard_id,chassis_number,COUNT(*) AS total_car FROM erp_stock_list GROUP BY ship_id) AS a';
        $data[ 'get_shipment_id' ] = DB::table( 'erp_shipments' )
        ->leftjoin( DB::raw( $select_count ), 'a.ship_id', '=', 'erp_shipments.shipment_id' )
        ->leftjoin( 'erp_port_of_loading', 'erp_port_of_loading.port_of_loading_id', '=', 'erp_shipments.port_of_loading_id' )
        ->leftjoin( 'erp_discharge', 'erp_discharge.discharge_id', '=', 'erp_shipments.discharge_id' )
        ->leftjoin( 'erp_shipping_company', 'erp_shipping_company.shipping_co_id', '=', 'erp_shipments.shipping_co_id' )
        ->whereRaw( ' `erp_shipments`.`shipping_invoice_code` IS NOT NULL AND `erp_shipments`.`shipping_invoice_code` != ""  ' )
        ->orderBy( 'etd', 'DESC' )
        ->get();
        return response()->json( [
            $data
        ] );
    }

    public function add_car_to_booked( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        $stock_ids = $request->get( 'stock_ids' );
        $arr_stock = explode( ',', $stock_ids );
        $user = Auth::user();
        $etd = Shipping_model::get_shipment_etd( $shipment_id );
        foreach ( $arr_stock as $id ) {
            $data_stock = array(
                'shipment_id' => $shipment_id,
                'booked_date' => date( 'Y-m-d H:i:s' ),
                'car_etd' => $etd[ 0 ]->etd
            );

            Shipping_model::update_stock_list( $id, $data_stock );
            Status_update::update_releasebl_status( $id, $user->staff_id );
            Status_update::update_soldout_status( $id, $user->staff_id );
        }

        return response()->json( [
            'status' => true,
            'message' => 'successfully'
        ] );

    }

    public function get_car_in_stock_list_by_shipment_id( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        $details = Shipping_model::get_car_in_stocklist_by_shipment_id( $shipment_id );
        $user = Auth::user();
        $check_dubai_user = Shipping_model::check_dubai_users( $user->staff_id );
        $user_country = @$check_dubai_user[ 0 ]->country_list_id;
        $count_ec_n = array();
        $count_invoice_n = array();
        $count_bl_n = array();
        $count_cancel_n = array();
        $count_certificate_n = array();
        $data_days = array();
        $string_days = '';
        foreach ( $details as $val ) {
            $id = $val->stock_id;
            //EC
            $count_ec = DB::table( 'erp_stock_list_doc' )
            ->select( DB::raw( 'COUNT(*) AS ec' ) )
            ->where( 'stock_id', '=', $id )
            ->where( 'doc_type', '=', 'ec' )
            ->get();
            if ( $count_ec[ 0 ]->ec > 0 ) {
                if ( !empty( $val->car_ec_expires_date ) &&  $val->car_ec_expires_date != '0000-00-00' ) {
                    $ecExpiresDate  = new DateTime( $val->car_ec_expires_date );
                    $currentDate = new DateTime( date( 'Y-m-d' ) );
                    $intvl = $currentDate->diff( $ecExpiresDate );
                    $days = str_replace( '+', '', $intvl->format( '%R%a' ) );

                    if ( $days <= 3 ) {
                        $string_days =  $days;
                    }
                }
            }
            //BL
            $count_bl = DB::table( 'erp_stock_list_doc' )
            ->select( DB::raw( 'COUNT(*) AS bl' ) )
            ->where( 'stock_id', '=', $id )
            ->where( 'doc_type', '=', 'bl' )
            ->get();
            //Invoice
            $count_invoice  = DB::table( 'erp_stock_list_doc' )
            ->select( DB::raw( 'COUNT(*) AS invoice' ) )
            ->where( 'stock_id', '=', $id )
            ->where( 'doc_type', '=', 'invoice' )
            ->get();

            //cancel
            $count_cancel  = DB::table( 'erp_stock_list_doc' )
            ->select( DB::raw( 'COUNT(*) AS cancel' ) )
            ->where( 'stock_id', '=', $id )
            ->where( 'doc_type', '=', 'cancel' )
            ->get();
            //cancel
            $count_certificate  = DB::table( 'erp_stock_list_doc' )
            ->select( DB::raw( 'COUNT(*) AS certificate' ) )
            ->where( 'stock_id', '=', $id )
            ->where( 'doc_type', '=', 'certificate' )
            ->get();

            $data_days[ $id ] = $string_days;
            $count_ec_n[ $id ] = $count_ec[ 0 ]->ec;

            $count_bl_n[ $id ] = $count_bl[ 0 ]->bl;
            $count_invoice_n[ $id ] = $count_invoice[ 0 ]->invoice;
            $count_cancel_n[ $id ] = $count_cancel[ 0 ]->cancel;
            $count_certificate_n[ $id ] = $count_certificate[ 0 ]->certificate;

        }

        $data[ 'count_ec_n' ] = $count_ec_n;
        $data[ 'data_days' ] = $data_days;
        $data[ 'count_bl_n' ] = $count_bl_n;
        $data[ 'count_invoice_n' ] = $count_invoice_n ;
        $data[ 'count_cancel_n' ] = $count_cancel_n;
        $data[ 'count_certificate_n' ] = $count_certificate_n;
        $blockTab = $this->blockTab( $user->staff_id );
        $data[ 'blockTab' ] = $blockTab;
        $data[ 'user_country' ] = $user_country;
        $data[ 'details_info' ] = $details;
        return response()->json( [
            $data
        ] );
    }

    public function blockTab( $staff_id ) {
        $data = Shipping_model::blockTabVesselUnbookedListByCountries( $staff_id );
        foreach ( $data as $v ) {
            if ( $v->country_list_id == '248' ) {
                return true;
            }
        }
        return false;
    }

    public function count_stock_list_doc( $stock_id ) {

        if ( !empty( $stock_id ) ) {
            return !empty( $data ) ? $data : $default;
        }

        return  $default;
    }

    public function upload_images( Request $request ) {
        $pic_chassis = $request->file( 'pic_chassis' );
        $pic_car = $request->file( 'pic_car' );
        $stock_id = $request->get( 'stock_id' );
        $arrive_dt  = $request->get( 'arrive_dt' );
        if ( $request->hasFile( 'pic_chassis' ) || $request->hasFile( 'pic_car' ) && !empty( $stock_id ) ) {
            $imageData = array(
                'chassis' =>$pic_chassis,
                'car' =>$pic_car,
            );
            foreach ( $imageData as $key => $value ) {
                if ( $value != null ) {
                    $fileName = time().'_'.$value->getClientOriginalName();
                    $ext = explode( '.', $value->getClientOriginalName() );
                    $ext = end( $ext );
                    $ext = strtolower( $ext );

                    if ( $ext != 'pdf' && $ext != 'gif' && $ext != 'jpg' && $ext != 'jpeg' && $ext != 'png' ) {
                        return response()->json( [
                            'status' => false,
                            'message' => 'Please Check File type again!'
                        ] );
                    }

                    $fname = date( 'Ymd_His' ) . '_' . mt_rand( '0000000', '9999999' ) . '.' . $ext;
                    $fileName = $fname;
                    $targetPath = 'uploads/cars/';
                    $targetFile = $targetPath . $fileName ;

                    if ( $key == 'chassis' ) {
                        $data[ 'chassis_photo' ] = 'uploads/cars/'.$fileName;
                    }
                    if ( $key == 'car' ) {
                        $data[ 'car_photo' ] = 'uploads/cars/'.$fileName;
                    }
                    if ( !empty( $arrive_dt ) ) {
                        $data[ 'arrive_dt' ] = $arrive_dt;
                    } else {
                        $data[ 'arrive_dt' ] = date( 'Y-m-d' );
                    }

                    if ( move_uploaded_file( $value->getRealPath(), storage_path( 'app/public/'.$targetFile ) ) ) {
                        if ( !empty( $stock_id ) ) {
                            Shipping_model::update_image_arrived_status( $data, $stock_id );
                        }
                    }
                }

            }
            return response()->json( [
                'status' => true,
                'message' => 'Data Update Successfully!!'
            ] );
        }

    }

    public function upload_file_all_ec_cars( Request $request ) {
        $manager = new ImageManager( new Driver() );
        $file_data = $request->file( 'files' );
        $shipment_id = $request->get( 'shipment_id' );
        $type_doc = $request->get( 'type_doc' );
        $data = array();
        $check_insert = '';
        $photo_order = 0;
        if ( $request->hasFile( 'files' ) ) {
            $targetPath = 'uploads/pdf_files/';
            $apiKey  = 'vuthy32@gmail.com_eb090f7c04d550ee5a59c92455fcfbeee72711e9c7c66625507106c779d3b139cbc354f5';

            foreach ( $file_data as $file ) {
                $fname_compress = date( 'Ymd_His' ) . '_' . mt_rand( '0000000', '9999999' ) . '.' . 'pdf';
                $photo_order += 1;
                $fileName = time().'_'.$file->getClientOriginalName();
                $ext = explode( '.', $file->getClientOriginalName() );
                $ext = end( $ext );
                $ext = strtolower( $ext );
                if ( $ext != 'pdf' && $ext != 'gif' && $ext != 'jpg' && $ext != 'jpeg' && $ext != 'png' ) {
                    echo json_encode( 'You can upload only file pdf!' );
                }

                if ( $ext == 'pdf' ) {

                    // $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                    // '?name=' . urlencode( $file->getClientOriginalName() ) .
                    // '&contenttype=application/octet-stream';
                    //     // Create request
                    //     $curl = curl_init();
                    //     curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                    //     curl_setopt( $curl, CURLOPT_URL, $url );
                    //     curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                    //     // Execute request
                    //     $result = curl_exec( $curl );

                    //     if ( curl_errno( $curl ) == 0 )
                    // {
                    //         $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                    //         if ( $status_code == 200 )
                    // {
                    //             $json = json_decode( $result, true );

                    //             // Get URL to use for the file upload
                    //             $uploadFileUrl = $json[ 'presignedUrl' ];
                    //             // Get URL of uploaded file to use with later API calls
                    //             $uploadedFileUrl = $json[ 'url' ];

                    //             // 2. UPLOAD THE FILE TO CLOUD.

                    //             $localFile = $file->getRealPath();
                    //             $fileHandle = fopen( $localFile, 'r' );

                    //             curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                    //             curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                    //             curl_setopt( $curl, CURLOPT_PUT, true );
                    //             curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                    //             curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $localFile ) );

                    //             // Execute request
                    //             curl_exec( $curl );

                    //             fclose( $fileHandle );

                    //             if ( curl_errno( $curl ) == 0 )
                    // {
                    //                 $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                    //                 if ( $status_code == 200 )
                    // {
                    //                     // 3. OPTIMIZE UPLOADED PDF FILE

                    //                     $this->OptimizePdf( $apiKey, $uploadedFileUrl, $fname_compress );
                    //                 }
                    //                 else
                    // {
                    //                     // Display request error
                    //                     dd( '<p>Status code: ' . $status_code . '</p>' );

                    //                     echo '<p>' . $result . '</p>';

                    //                 }
                    //             }
                    //             else
                    // {
                    //                 // Display CURL error
                    //                 dd( 'Error: ' . curl_error( $curl ) );
                    //             }
                    //         }
                    // } else
                    // {
                    //     // Display CURL error
                    //     echo 'Error: ' . curl_error( $curl );
                    // }
                    move_uploaded_file( $file->getRealPath(), storage_path( 'app/public/'.$targetPath.$fname_compress ) );
                } elseif ( $ext == 'png' || $ext == 'jpeg' || $ext == 'jpg' ) {

                    $uploadedFiles = array();
                    $name_pdf = $fname_compress;

                    $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                    '?name=' . urlencode( $file->getClientOriginalName() ) .
                    '&contenttype=application/octet-stream';

                    // Create request
                    $curl = curl_init();
                    curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                    curl_setopt( $curl, CURLOPT_URL, $url );
                    curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                    // Execute request
                    $result = curl_exec( $curl );

                    if ( curl_errno( $curl ) == 0 ) {
                        $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                        if ( $status_code == 200 ) {
                            $json = json_decode( $result, true );

                            // Get URL to use for the file upload
                            $uploadFileUrl = $json[ 'presignedUrl' ];
                            // Get URL of uploaded file to use with later API calls
                            $uploadedFileUrl = $json[ 'url' ];

                            $tmpFilePath = $file->getRealPath();

                            $fileHandle = fopen( $tmpFilePath, 'r' );

                            curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                            curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                            curl_setopt( $curl, CURLOPT_PUT, true );
                            curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                            curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $tmpFilePath ) );

                            // Execute request
                            curl_exec( $curl );

                            if ( curl_errno( $curl ) == 0 ) {
                                $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                if ( $status_code == 200 ) {
                                    $uploadedFiles[] = $uploadedFileUrl;
                                } else {
                                    // Display request error
                                    echo '<p>Uploading File Status code: ' . $status_code . ' : ' . $uploadedFileUrl . '</p>';

                                    echo '<p>error status for uploading files (1 means error related to php.ini config or tmp folder permissions): ' . $_FILES[ 'files' ][ 'error' ] . '</p>';
                                    echo '<p>' . $result . '</p>';

                                }
                            } else {
                                // Display CURL error
                                return response()->json( [
                                    'status' => false,
                                    'message' => curl_error( $curl )
                                ] );
                            }

                            fclose( $fileHandle );
                        } else {
                            // Display request error
                            return response()->json( [
                                'status' => $status_code,
                                'message' => $result
                            ] );
                        }
                    } else {
                        // Display CURL error
                        return response()->json( [
                            'status' => 200,
                            'message' => curl_error( $curl )
                        ] );
                    }

                    curl_close( $curl );

                    if ( count( $uploadedFiles ) > 0 ) {
                        $this->ImageToPdf( $apiKey, $uploadedFiles, $name_pdf, $fname_compress );
                    }
                }

            }

            if ( file_exists( storage_path( 'app/public/uploads/pdf_files/'.$fname_compress ) ) ) {
                if ( $type_doc == 'ec' ) {
                    $this->insertBLFilesToAllCarsInShipment( $shipment_id, $fname_compress, $type_doc );
                    $this->send_email_to( $shipment_id );
                }
                if ( $type_doc == 'bl' ) {
                    $this->insertBLFilesToAllCarsInShipment( $shipment_id, $fname_compress, $type_doc );
                }
                return response()->json( [
                    'status' => true,
                    'message' => 'successfully'
                ] );
            }

        } else {
            return response()->json( [
                'message' => 'Failed'
            ] );
        }

    }

    public function insertBLFilesToAllCarsInShipment( $shipment_id, $fileName, $doc_type ) {
        $get_stock_id = Shipping_model::get_stock_id_by_shipment_id( $shipment_id );
        foreach ( $get_stock_id as $stock_id ) {

            $data[ 'stock_id' ] = $stock_id->stock_id;

            $data[ 'doc_type' ] = $doc_type;

            $data[ 'file_name' ] = $fileName;

            $data[ 'file_path' ]  = '/uploads/pdf_files/';

            $data[ 'upload_date' ] = date( 'Y-m-d H:i:s' );

            $count_doc = Stocklist_model::select_count_file_upload( $stock_id->stock_id, $doc_type );

            if ( $count_doc[ 0 ]->numrows > 0 ) {
                Stocklist_model::update_count_file_upload( $stock_id->stock_id, $doc_type, $data );
            } else {
                Stocklist_model::insert_count_file_upload( $data );
            }
            $this->send_email_for_stock_id( $shipment_id, $stock_id->stock_id );
        }
    }

    public function download_all_ec( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        $type_file = $request->get( 'downloadType' );

        if ( !empty( $shipment_id ) ) {
            $cars_doc_file =  Shipping_model::get_cars_by_shipment_id( $shipment_id );
            if ( !empty( $cars_doc_file ) ) {
                $filename = 'all_Doc_file.zip';
                $zip = new ZipArchive;
                $fileName = date( 'Y-m-d' ).' №'.$shipment_id.'_'.rand( 2000000000, 9999999999 ).'.zip';
                foreach ( $cars_doc_file as $ec ) {
                    $a = $ec->file_name;
                    $arr = explode( '.', $a );
                    if ( $arr[ 1 ] == 'pdf' ) {
                        // File path
                        if ( $type_file == 'compress' ) {
                            $path = public_path( '/storage/uploads/pdf_files/file_compressed/'.$ec->file_name );
                            $path1 =  public_path( '/storage/uploads/pdf_files/'.$ec->file_name );
                            $fname_compress = $ec->file_name;
                            $filepath1 = storage_path( 'app/public/uploads/pdf_files/file_compressed/'.$fname_compress );
                            if ( file_exists( $path ) ) {
                                if ( $zip->open( public_path( $fileName ), ZipArchive::CREATE ) === TRUE ) {
                                    $files = File::files( public_path( '/storage/uploads/pdf_files/file_compressed' ) );
                                    foreach ( $files as $val ) {
                                        if ( $ec->file_name == basename( $val ) ) {
                                            $relativeNameInZipFile = $ec->chassis_number.'.pdf';
                                            $zip->addFile( $val, $relativeNameInZipFile );
                                        }
                                    }
                                    $zip->close();
                                }
                            } else {
                                if(file_exists($path1)){
                                $apiKey = 'vuthy32@gmail.com_eb090f7c04d550ee5a59c92455fcfbeee72711e9c7c66625507106c779d3b139cbc354f5';
                                $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                                '?name=' . urlencode( $ec->file_name ) .
                                '&contenttype=application/octet-stream';

                                // Create request
                                $curl = curl_init();
                                curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                                curl_setopt( $curl, CURLOPT_URL, $url );
                                curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                                // Execute request
                                $result = curl_exec( $curl );

                                if ( curl_errno( $curl ) == 0 ) {
                                    $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                    if ( $status_code == 200 ) {
                                        $json = json_decode( $result, true );

                                        // Get URL to use for the file upload
                                        $uploadFileUrl = $json[ 'presignedUrl' ];
                                        // Get URL of uploaded file to use with later API calls
                                        $uploadedFileUrl = $json[ 'url' ];

                                        // 2. UPLOAD THE FILE TO CLOUD.

                                        $localFile = $path1;
                                        $fileHandle = fopen( $localFile, 'r' );
                                        $dirname = dirname( $ec->file_name );

                                        curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                                        curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                                        curl_setopt( $curl, CURLOPT_PUT, true );
                                        curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                                        curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $localFile ) );

                                        // Execute request
                                        curl_exec( $curl );

                                        fclose( $fileHandle );

                                        if ( curl_errno( $curl ) == 0 ) {
                                            $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                            if ( $status_code == 200 ) {
                                                // 3. OPTIMIZE UPLOADED PDF FILE

                                                $this->OptimizePdf( $apiKey, $uploadedFileUrl, $fname_compress );
                                            } else {
                                                // Display request error
                                                echo '<p>Status code: ' . $status_code . '</p>';

                                                echo '<p>' . $result . '</p>';

                                            }
                                        } else {
                                            // Display CURL error
                                            echo 'Error: ' . curl_error( $curl );
                                        }
                                    } else {
                                        // Display service reported error
                                        echo '<p>Status code: ' . $status_code . '</p>';

                                        echo '<p>' . $result . '</p>';

                                    }

                                    curl_close( $curl );
                                } else {
                                    // Display CURL error
                                    echo 'Error: ' . curl_error( $curl );
                                }
                                if ( $zip->open( public_path( $fileName ), ZipArchive::CREATE ) === TRUE ) {
                                    $files = File::files( public_path( '/storage/uploads/pdf_files/file_compressed/' ) );
                                    foreach ( $files as $val ) {
                                        if ( $ec->file_name == basename( $val ) ) {
                                            $relativeNameInZipFile = $ec->chassis_number.'.pdf';
                                            $zip->addFile( $val, $relativeNameInZipFile );
                                        }
                                    }
                                    $zip->close();
                                }
                            }
                            }
                        } else {
                            $filepath1 = storage_path( 'app/public/uploads/pdf_files/'.$ec->file_name );
                            if ( $zip->open( public_path( $fileName ), ZipArchive::CREATE ) === TRUE ) {
                                $files = File::files( public_path( '/storage/uploads/pdf_files/' ) );
                                foreach ( $files as $val ) {
                                    if ( $ec->file_name == basename( $val ) ) {
                                        $relativeNameInZipFile = $ec->chassis_number.'.pdf';
                                        $zip->addFile( $val, $relativeNameInZipFile );
                                    }
                                }
                                $zip->close();
                            }
                        }
                    } elseif ( $arr[ 1 ] == 'png' || $arr[ 1 ] == 'jpeg' || $arr[ 1 ] == 'jpg' ) {
                        if ( $type_file == 'compress' ) {
                            $path = public_path( '/storage/uploads/pdf_files/file_compressed/'.$arr[ 0 ].'.pdf' );
                            if ( file_exists( $path ) ) {
                                if ( $zip->open( public_path( $fileName ), ZipArchive::CREATE ) === TRUE ) {
                                    $files = File::files( public_path( '/storage/uploads/pdf_files/file_compressed' ) );
                                    foreach ( $files as $val ) {
                                        if ( $arr[ 0 ].'.pdf' == basename( $val ) ) {
                                            $relativeNameInZipFile = $ec->chassis_number.'.pdf';
                                            $zip->addFile( $val, $relativeNameInZipFile );
                                        }
                                    }
                                    $zip->close();
                                }
                            } else {
                                $uploadedFiles = array();
                                // $fileCount = count( $_FILES[ 'file' ][ 'name' ] );
                                $fname_compress = $arr[ 0 ].'.pdf';
                                $path2 = storage_path( 'app/public/uploads/pdf_files/'.$ec->file_name );
                                if(file_exists($path2)){
                                $name_pdf = $fname_compress;
                                $apiKey = 'vuthy32@gmail.com_eb090f7c04d550ee5a59c92455fcfbeee72711e9c7c66625507106c779d3b139cbc354f5';
                                $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                                '?name=' . urlencode( $ec->file_name ) .
                                '&contenttype=application/octet-stream';

                                // Create request
                                $curl = curl_init();
                                curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                                curl_setopt( $curl, CURLOPT_URL, $url );
                                curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                                // Execute request
                                $result = curl_exec( $curl );

                                if ( curl_errno( $curl ) == 0 ) {
                                    $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                    if ( $status_code == 200 ) {
                                        $json = json_decode( $result, true );

                                        // Get URL to use for the file upload
                                        $uploadFileUrl = $json[ 'presignedUrl' ];
                                        // Get URL of uploaded file to use with later API calls
                                        $uploadedFileUrl = $json[ 'url' ];

                                        $tmpFilePath = $path2;

                                        $fileHandle = fopen( $tmpFilePath, 'r' );

                                        curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                                        curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                                        curl_setopt( $curl, CURLOPT_PUT, true );
                                        curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                                        curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $tmpFilePath ) );

                                        // Execute request
                                        curl_exec( $curl );

                                        if ( curl_errno( $curl ) == 0 ) {
                                            $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                            if ( $status_code == 200 ) {
                                                $uploadedFiles[] = $uploadedFileUrl;
                                            } else {
                                                // Display request error
                                                echo '<p>Uploading File Status code: ' . $status_code . ' : ' . $uploadedFileUrl . '</p>';

                                                echo '<p>error status for uploading files (1 means error related to php.ini config or tmp folder permissions): ' . $_FILES[ 'files' ][ 'error' ] . '</p>';
                                                echo '<p>' . $result . '</p>';

                                            }
                                        } else {
                                            // Display CURL error
                                            echo 'cURL Error: ' . curl_error( $curl );
                                        }

                                        fclose( $fileHandle );
                                    } else {
                                        // Display request error
                                        echo '<p>Error Uploading: Status code: ' . $status_code . '</p>';

                                        echo '<p>' . $result . '</p>';

                                    }
                                } else {
                                    // Display CURL error
                                    echo 'cURL Error: ' . curl_error( $curl );
                                }

                                curl_close( $curl );

                                if ( count( $uploadedFiles ) > 0 ) {
                                    $this->ImageToPdf1( $apiKey, $uploadedFiles, $fname_compress );
                                }

                                if ( $zip->open( public_path( $fileName ), ZipArchive::CREATE ) === TRUE ) {
                                    $files = File::files( public_path( '/storage/uploads/pdf_files/file_compressed/' ) );
                                    foreach ( $files as $val ) {
                                        if ( $fname_compress == basename( $val ) ) {
                                            $relativeNameInZipFile = $ec->chassis_number.'.pdf';
                                            $zip->addFile( $val, $relativeNameInZipFile );
                                        }
                                    }
                                    $zip->close();
                                }
                            }
                            }
                        } else {
                            $filepath1 = storage_path( 'app/public/uploads/pdf_files/'.$ec->file_name );
                            if ( $zip->open( public_path( $fileName ), ZipArchive::CREATE ) === TRUE ) {
                                $files = File::files( public_path( '/storage/uploads/pdf_files/' ) );
                                foreach ( $files as $val ) {
                                    if ( $ec->file_name == basename( $val ) ) {
                                        $relativeNameInZipFile = $ec->chassis_number.'.'.$arr[ 1 ];
                                        $zip->addFile( $val, $relativeNameInZipFile );
                                    }
                                }
                                $zip->close();
                            }
                        }
                    }
                }
                return response()->download( public_path( $fileName ) );
            }
        }
    }

    public function download_all_bl( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        if ( !empty( $shipment_id ) ) {
            $zip = new ZipArchive;
            $fileName = date( 'Y-m-d' ).' №'.$shipment_id.'.zip';
            $cars_bl_file =  Shipping_model::get_shipment_car( $shipment_id );
            if ( !empty( $cars_bl_file ) ) {
                foreach ( $cars_bl_file as $bl ) {
                    if ( $zip->open( public_path( $fileName ), ZipArchive::CREATE ) === TRUE ) {
                        $files = File::files( public_path( '/storage/uploads/pdf_files/' ) );
                        foreach ( $files as $val ) {
                            if ( $bl->file_name == basename( $val ) ) {
                                $relativeNameInZipFile = $bl->chassis_number.'.pdf';
                                $zip->addFile( $val, $relativeNameInZipFile );
                            }
                        }
                        $zip->close();
                    }
                }

                return response()->download( public_path( $fileName ) );

            }
        }
    }

    public function download_all_doc( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        $type_file = $request->get( 'downloadType' );

        if ( !empty( $shipment_id ) ) {
            $cars_doc_file =  Shipping_model::get_cars_by_shipment_id1( $shipment_id );
            // dd( $cars_doc_file);
            if ( !empty( $cars_doc_file ) ) {
                $filename = 'all_Doc_file.zip';
                $zip = new ZipArchive;
                $fileName = date( 'Y-m-d' ).' №'.$shipment_id.'_'.rand( 2000000000, 9999999999 ).'.zip';
                foreach ( $cars_doc_file as $ec ) {
                    $a = $ec->car_document_file;
                    $arr = explode( '.', $a );
                    if (@$arr[ 1 ] == 'pdf' ) {
                        // File path
                        if ( $type_file == 'compress' ) {
                            $path = public_path( '/storage/uploads/pdf_files/file_compressed/'.$ec->car_document_file );
                            $path1 =  public_path( '/storage/uploads/pdf_files/'.$ec->car_document_file );
                            $fname_compress = $ec->car_document_file;
                            $filepath1 = storage_path( 'app/public/uploads/pdf_files/file_compressed/'.$fname_compress );
                            if ( file_exists( $path ) ) {
                                if ( $zip->open( public_path( $fileName ), ZipArchive::CREATE ) === TRUE ) {
                                    $files = File::files( public_path( '/storage/uploads/pdf_files/file_compressed' ) );
                                    foreach ( $files as $val ) {
                                        if ( $ec->car_document_file == basename( $val ) ) {
                                            $relativeNameInZipFile = $ec->chassis_number.'.pdf';
                                            $zip->addFile( $val, $relativeNameInZipFile );
                                        }
                                    }
                                    $zip->close();
                                }
                            } else {
                                if(file_exists($path1)){
                                $path1 =  public_path( '/storage/uploads/pdf_files/'.$ec->car_document_file );
                                $apiKey = 'vuthy32@gmail.com_eb090f7c04d550ee5a59c92455fcfbeee72711e9c7c66625507106c779d3b139cbc354f5';
                                $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                                '?name=' . urlencode( $ec->car_document_file ) .
                                '&contenttype=application/octet-stream';

                                // Create request
                                $curl = curl_init();
                                curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                                curl_setopt( $curl, CURLOPT_URL, $url );
                                curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                                // Execute request
                                $result = curl_exec( $curl );

                                if ( curl_errno( $curl ) == 0 ) {
                                    $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                    if ( $status_code == 200 ) {
                                        $json = json_decode( $result, true );

                                        // Get URL to use for the file upload
                                        $uploadFileUrl = $json[ 'presignedUrl' ];
                                        // Get URL of uploaded file to use with later API calls
                                        $uploadedFileUrl = $json[ 'url' ];

                                        // 2. UPLOAD THE FILE TO CLOUD.

                                        $localFile = $path1;
                                        $fileHandle = fopen( $localFile, 'r' );
                                        $dirname = dirname( $ec->car_document_file );

                                        curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                                        curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                                        curl_setopt( $curl, CURLOPT_PUT, true );
                                        curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                                        curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $localFile ) );

                                        // Execute request
                                        curl_exec( $curl );

                                        fclose( $fileHandle );

                                        if ( curl_errno( $curl ) == 0 ) {
                                            $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                            if ( $status_code == 200 ) {
                                                // 3. OPTIMIZE UPLOADED PDF FILE

                                                $this->OptimizePdf( $apiKey, $uploadedFileUrl, $fname_compress );
                                            } else {
                                                // Display request error
                                                echo '<p>Status code: ' . $status_code . '</p>';

                                                echo '<p>' . $result . '</p>';

                                            }
                                        } else {
                                            // Display CURL error
                                            echo 'Error: ' . curl_error( $curl );
                                        }
                                    } else {
                                        // Display service reported error
                                        echo '<p>Status code: ' . $status_code . '</p>';

                                        echo '<p>' . $result . '</p>';

                                    }

                                    curl_close( $curl );
                                } else {
                                    // Display CURL error
                                    echo 'Error: ' . curl_error( $curl );
                                }
                                if ( $zip->open( public_path( $fileName ), ZipArchive::CREATE ) === TRUE ) {
                                    $files = File::files( public_path( '/storage/uploads/pdf_files/file_compressed/' ) );
                                    foreach ( $files as $val ) {
                                        if ( $ec->car_document_file == basename( $val ) ) {
                                            $relativeNameInZipFile = $ec->chassis_number.'.pdf';
                                            $zip->addFile( $val, $relativeNameInZipFile );
                                        }
                                    }
                                    $zip->close();
                                }
                                }
                            }
                        } else {
                            $filepath1 = storage_path( 'app/public/uploads/pdf_files/'.$ec->car_document_file );
                            if ( $zip->open( public_path( $fileName ), ZipArchive::CREATE ) === TRUE ) {
                                $files = File::files( public_path( '/storage/uploads/pdf_files/' ) );
                                foreach ( $files as $val ) {
                                    if ( $ec->car_document_file == basename( $val ) ) {
                                        $relativeNameInZipFile = $ec->chassis_number.'.pdf';
                                        $zip->addFile( $val, $relativeNameInZipFile );
                                    }
                                }
                                $zip->close();
                            }
                        }
                    } elseif ( @$arr[ 1 ] == 'png' || @$arr[ 1 ] == 'jpeg' || @$arr[ 1 ] == 'jpg' ) {
                        if ( $type_file == 'compress' ) {
                            $path = public_path( '/storage/uploads/pdf_files/file_compressed/'.$arr[ 0 ].'.pdf' );

                            if ( file_exists( $path ) ) {
                                if ( $zip->open( public_path( $fileName ), ZipArchive::CREATE ) === TRUE ) {
                                    $files = File::files( public_path( '/storage/uploads/pdf_files/file_compressed' ) );
                                    foreach ( $files as $val ) {
                                        if ( $arr[ 0 ].'.pdf' == basename( $val ) ) {
                                            $relativeNameInZipFile = $ec->chassis_number.'.pdf';
                                            $zip->addFile( $val, $relativeNameInZipFile );
                                        }
                                    }
                                    $zip->close();
                                }
                            } else {
                                $uploadedFiles = array();
                                // $fileCount = count( $_FILES[ 'file' ][ 'name' ] );
                                $fname_compress = $arr[ 0 ].'.pdf';
                                $path2 = storage_path( 'app/public/uploads/pdf_files/'.$ec->car_document_file );
                                if(file_exists($path2)){
                                $name_pdf = $fname_compress;
                                $apiKey = 'vuthy32@gmail.com_eb090f7c04d550ee5a59c92455fcfbeee72711e9c7c66625507106c779d3b139cbc354f5';
                                $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                                '?name=' . urlencode( $ec->car_document_file ) .
                                '&contenttype=application/octet-stream';

                                // Create request
                                $curl = curl_init();
                                curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                                curl_setopt( $curl, CURLOPT_URL, $url );
                                curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                                // Execute request
                                $result = curl_exec( $curl );

                                if ( curl_errno( $curl ) == 0 ) {
                                    $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                    if ( $status_code == 200 ) {
                                        $json = json_decode( $result, true );

                                        // Get URL to use for the file upload
                                        $uploadFileUrl = $json[ 'presignedUrl' ];
                                        // Get URL of uploaded file to use with later API calls
                                        $uploadedFileUrl = $json[ 'url' ];

                                        $tmpFilePath = $path2;

                                        $fileHandle = fopen( $tmpFilePath, 'r' );

                                        curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                                        curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                                        curl_setopt( $curl, CURLOPT_PUT, true );
                                        curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                                        curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $tmpFilePath ) );

                                        // Execute request
                                        curl_exec( $curl );

                                        if ( curl_errno( $curl ) == 0 ) {
                                            $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                            if ( $status_code == 200 ) {
                                                $uploadedFiles[] = $uploadedFileUrl;
                                            } else {
                                                // Display request error
                                                echo '<p>Uploading File Status code: ' . $status_code . ' : ' . $uploadedFileUrl . '</p>';

                                                echo '<p>error status for uploading files (1 means error related to php.ini config or tmp folder permissions): ' . $_FILES[ 'files' ][ 'error' ] . '</p>';
                                                echo '<p>' . $result . '</p>';

                                            }
                                        } else {
                                            // Display CURL error
                                            echo 'cURL Error: ' . curl_error( $curl );
                                        }

                                        fclose( $fileHandle );
                                    } else {
                                        // Display request error
                                        echo '<p>Error Uploading: Status code: ' . $status_code . '</p>';

                                        echo '<p>' . $result . '</p>';

                                    }
                                } else {
                                    // Display CURL error
                                    echo 'cURL Error: ' . curl_error( $curl );
                                }

                                curl_close( $curl );

                                if ( count( $uploadedFiles ) > 0 ) {
                                    $this->ImageToPdf1( $apiKey, $uploadedFiles, $fname_compress );
                                }

                                if ( $zip->open( public_path( $fileName ), ZipArchive::CREATE ) === TRUE ) {
                                    $files = File::files( public_path( '/storage/uploads/pdf_files/file_compressed/' ) );
                                    foreach ( $files as $val ) {
                                        if ( $fname_compress == basename( $val ) ) {
                                            $relativeNameInZipFile = $ec->chassis_number.'.pdf';
                                            $zip->addFile( $val, $relativeNameInZipFile );
                                        }
                                    }
                                    $zip->close();
                                }
                            }
                            }
                        } else {

                            $filepath1 = storage_path( 'app/public/uploads/pdf_files/'.$ec->car_document_file );
                            if ( $zip->open( public_path( $fileName ), ZipArchive::CREATE ) === TRUE ) {
                                $files = File::files( public_path( '/storage/uploads/pdf_files/' ) );
                                foreach ( $files as $val ) {
                                    if ( $ec->car_document_file == basename( $val ) ) {
                                        $relativeNameInZipFile = $ec->chassis_number.'.'.$arr[ 1 ];
                                        $zip->addFile( $val, $relativeNameInZipFile );
                                    }
                                }
                                $zip->close();
                            }

                        }
                    }
                }
                return response()->download( public_path( $fileName ) );
            }
        }
    }

    public function update_comfirm( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        $type = $request->get( 'type' );
        $confirm_date_report = date( 'Y-m-d' );
        $note_arr = array(
            'confirm_report_shipment' => $type,
            'confirm_date_shipment' => $confirm_date_report
        );
        if ( Shipping_model::update_comfirm( $shipment_id, $note_arr ) ) {
            return response()->json( [
                'status' => true,
                'message' => $type == 'confirm' ? 'confirm successfully' : 'unconfirm successfully'
            ] );
        }
    }

    public function delete_sent_doc( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        $data = array(
            'docs_date' => null
        );
        DB::table( 'erp_shipments' )
        ->where( 'shipment_id', '=', $shipment_id )
        ->update( $data );
        return response()->json( [
            'status' => true,
            'message' => 'SENT DOC has been Delete !!!'
        ] );
    }

    public function add_bl_date( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        $bl_date = $request->get( 'bl_date' );
        $data[ 'bl_date' ] = $bl_date;
        $data[ 'get_bl' ] = $bl_date;
        DB::table( 'erp_shipments' )
        ->where( 'shipment_id', '=', $shipment_id )
        ->update( $data );
        return response()->json( [
            'status' => true,
            'message' => 'successfully'
        ] );
    }

    public function deletebl( Request $request ) {
        $shipment_id = $request->get( 'shipment_id' );
        $data = array(
            'bl_date' => null
        );
        DB::table( 'erp_shipments' )
        ->where( 'shipment_id', '=', $shipment_id )
        ->update( $data );
        return response()->json( [
            'status' => true,
            'message' => 'BL DATE has been Delete !!!'
        ] );
    }

    public function cif_invoice( Request $request ) {
        $invoice_type = $request->get( 'invoice_type' );
        $invoice_type_head = $request->get( 'invoice_type_head' );
        $ship_invoice = $request->get( 'ship_invoice' );
        $checkTypeHead = $invoice_type_head == 'combined' ? true : false;
        switch ( $invoice_type ) {
            case 'cambodia':
            $checkTypeHead ? $this->shipping_invoice_cambodia_combined( $ship_invoice ) : $this->shipping_invoice_cambodia_seperate( $ship_invoice );
            break;
            case 'jamaica':
            $checkTypeHead ? $this->shipping_invoice_jamica_combined( $ship_invoice ) : $this->shipping_invoice_jamica_seperate( $ship_invoice );
            break;
            case 'singapor':
            $checkTypeHead ? $this->shipping_invoice_singapor_combined( $ship_invoice ) : $this->shipping_invoice_singapor_separate( $ship_invoice );
            break;
            case 'kenya':
            $checkTypeHead ? $this->shipping_invoice_seperated( $ship_invoice ) : $this->shipping_invoice_seperated( $ship_invoice );
            break;
            case 'fiji':
            $checkTypeHead ? $this->shipping_invoice_seperated_fiji( $ship_invoice ) : $this->shipping_invoice_seperated_fiji( $ship_invoice );
            break;
            case 'chile':
            $checkTypeHead ? $this->shipping_invoice_chile( $ship_invoice ) : $this->shipping_invoice_chile_seperate( $ship_invoice );
            break;
            case 'dubai':
            $checkTypeHead ? $this->shipping_invoice_dubai( $ship_invoice ) : $this->shipping_invoice_dubai_seperate( $ship_invoice );
            break;
            case 'normal':
            $checkTypeHead ? $this->shipping_invoice_combined( $ship_invoice ) : $this->shipping_invoice_seperated( $ship_invoice );
            break;
            case 'Dominican':
            $checkTypeHead ? $this->shipping_invoice_dominican_republic( $ship_invoice ) : $this->shipping_invoice_dominican_republic_seperated( $ship_invoice );
            break;

            default:
            # code...
            break;
        }
    }

    public function shipping_invoice_jamica_seperate($ship_invoice){
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/shipping_invoice_jamica_separate_.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
        $data = Shipping_model::get_shipment_excel($ship_invoice);

        $insert_row_count1 = 0;
        $total_fobRow = 20;

        $baseRow = 21;
    
        $total =0;
        $cif_total =0;
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list( $user->staff_id );
        $shipping_company = Shipping_model::get_shipping_company();
        $discharges = Shipping_model::get_discharge($hide_pakistan);
        $port_of_loading = Shipping_model::get_port_of_loading();
        $arr_shipping_com = array();
        $arr_portloading = array();
        foreach ($shipping_company as $value) {
            $arr_shipping_com[$value->shipping_co_id]= $value->shipping_co_name;
        }
        foreach ($port_of_loading as $val1) {
            $arr_portloading[$val1->port_of_loading_id]= $val1->port_of_loading_name;
        }

        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->setTitle('INV');
        $objPHPExcel->getSheetByName('INV')
        ->setSheetState(\PhpOffice\PhpSpreadsheet\Worksheet\Worksheet::SHEETSTATE_VERYHIDDEN);
        $i = 0;
        $total_meas = 0;
        $total_weights = 0;
        $grand_total = 0;
        $invoice_no = "";
        $currency = '';

        $index = 0;
        $num_sheet = 1;
        $broombaseRow_inst = 24;
        foreach($data as $key => $dataRow) { 
            
            $modelYear = $dataRow->car_model_year;
            $fuel = "";
            $i += 1;
            $row = $baseRow + $key;
            $invoice_no = $dataRow->shipping_invoice_code; 
            $cc = $dataRow->engine_size;
            $meas = ($dataRow->car_length * $dataRow->car_width * $dataRow->car_height)/ 1000000;
            $total_meas += $meas;
            $total_weights += $dataRow->car_weight;
            $total_sold_price = $dataRow->fob + $dataRow->freight_fee + $dataRow->inspection + $dataRow->insurance - (float)$dataRow->discount; 
            $grand_total += $total_sold_price;
            $dop = explode(" ",$dataRow->date_of_production);
            $year = $dop[1];
            $month = date('m', strtotime($dop[0]));
            if($dataRow->currency == "USD"){
                $currency ='$';
            }else{
                $currency ='¥';
            }
            if($dataRow->car_fuel == "Petrol"){
                $fuel = "G";
            }elseif($dataRow->car_fuel == "Diesel"){
                $fuel = "D";
            }elseif($dataRow->car_fuel == "LPG"){
                $fuel = "LPG";
            }elseif($dataRow->car_fuel == "LPG_Pertrol"){
                $fuel = "L+G";
            }elseif($dataRow->car_fuel == "Hybrid"){
                $fuel = "H";
            }
            $invoice_no = $dataRow->shipping_invoice_code; 
            $next_sheets  = 1 + $index;
            $objWorkSheet = $objPHPExcel->createSheet($next_sheets);
            $objWorkSheet->setTitle("$num_sheet");
            $objPHPExcel->setActiveSheetIndex($next_sheets);
            //set column width
            $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(25);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(8);
            //set border thick aound
            $border_left_thick= array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            $border_top_thick= array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            //block border thin
            $border_top_thin= array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_left_thin= array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_bottom_thin= array(
                'borders' => array(
                    'bottom' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $styleArray = array(
            'font'  => array(
                'color' => array('rgb' => 'FF0000')
            ));

            $objPHPExcel->getActiveSheet()
            ->getStyle('E6')
            ->getAlignment()
            ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $objPHPExcel->getActiveSheet()->getStyle("A29:M29")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("A32:M32")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("A50:M50")->applyFromArray($border_top_thin);

            $objPHPExcel->getActiveSheet()->getStyle("H46:M46")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("H49:M49")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("H46:H48")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("N46:N48")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle('F43')->applyFromArray($styleArray);

            $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('A3')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('A10')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('A18')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('A22')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('A26')->getFont()->setUnderline(true);

            $objPHPExcel->getActiveSheet()->getStyle('E22')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('E26')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('B33')->getFont()->setUnderline(true);

            $objPHPExcel->getActiveSheet()->getStyle('H4')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('H7')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('H11')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('H14')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('H17')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('H18')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('H19')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('H22')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('C2')->getAlignment()->setWrapText(true);
            $objPHPExcel->getActiveSheet()->getStyle('C10')->getAlignment()->setWrapText(true);

            $objPHPExcel->getActiveSheet()->getStyle('A34:L34')->getAlignment()->setHorizontal('center');
            $objPHPExcel->getActiveSheet()->getStyle('F43')->getAlignment()->setHorizontal('center');
            $objPHPExcel->getActiveSheet()->getStyle('H46')->getAlignment()->setHorizontal('center');
            $objPHPExcel->getActiveSheet()->getStyle('B34')->getAlignment()->setHorizontal('left');
            $objPHPExcel->getActiveSheet()->getStyle('C34')->getAlignment()->setHorizontal('left');
    
            //merge cell
            $objPHPExcel->getActiveSheet()->mergeCells('A1:M1');
            $objPHPExcel->getActiveSheet()->mergeCells('C2:E7');
            $objPHPExcel->getActiveSheet()->mergeCells('A10:B10');
            $objPHPExcel->getActiveSheet()->mergeCells('C10:E14');
            $objPHPExcel->getActiveSheet()->mergeCells('H46:M48');
            $objPHPExcel->getActiveSheet()->mergeCells('A51:C51');
            $objPHPExcel->getActiveSheet()->mergeCells('A52:C52');
            $objPHPExcel->getActiveSheet()->mergeCells('A53:C53');
            $objPHPExcel->getActiveSheet()->mergeCells('D34:E34');
            $objPHPExcel->getActiveSheet()->mergeCells('H14:I14');
            $objPHPExcel->getActiveSheet()->mergeCells('H17:J17');
            $objPHPExcel->getActiveSheet()->mergeCells('H18:I18');
            $objPHPExcel->getActiveSheet()->mergeCells('H19:I19');
            $objPHPExcel->getActiveSheet()->mergeCells('F43:I43');
            
            //set label to cell
            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'SHIPPING INSTRUCTION')
                                          ->setCellValue('C2', 'SILMI JAPAN CO., LTD.'."\n".'3-6-28, Miyanosaka, Hirakata, Osaka, JAPAN'."\n".'PHONE: +81-72-392-4971'."\n".'EMAIL: jack@silmijapan.com')
                                          ->setCellValue('C10', $dataRow->full_name."\n".$dataRow->address."\nTEL: ".$dataRow->phone_number)
                                          ->setCellValue('H4', 'DATE')
                                          ->setCellValue('L4', date("Y-m-d"))

                                          ->setCellValue('H7', 'FREIGHT AGENT')
                                          ->setCellValue('H11', 'CARRIER')
                                          ->setCellValue('H14', 'BOOKING NO')
                                          ->setCellValue('H17', 'TYPE OF SERVICE')
                                          ->setCellValue('H18', 'LOADING :')
                                          ->setCellValue('H19', 'DISCHARGE :')
                                          ->setCellValue('H22', 'SAILING ON')
                                          
                                          ->setCellValue('A3', 'SHIPPER')
                                          ->setCellValue('A10', 'CONSIGNEE')
                                          ->setCellValue('A18', 'NOTIFY PARTY')
                                          ->setCellValue('A22', 'OCEAN VESSEL')
                                          ->setCellValue('A26', 'PORT OF DISCHARGE')
                                          ->setCellValue('A27', $dataRow->discharge_name)
                                          ->setCellValue('E22', 'PORT OF LOADING')

                                          ->setCellValue('E26', 'PLACE OF DELIVERY')
                                          ->setCellValue('B30', 'Description of Goods')
                                          ->setCellValue('B33', 'USED VEHICLE')
                                          ->setCellValue('E30', 'Quantity')
                                          ->setCellValue('G30', 'Weight')
                                          ->setCellValue('H30', 'LxWxH')
                                          ->setCellValue('M30', 'M3')
                                          ->setCellValue('A23', $dataRow->vessel_name)
                                          ->setCellValue('E23', $dataRow->port_of_loading_name)
                                          ->setCellValue('B34', $dataRow->car_make_name)
                                          ->setCellValue('B35', 'FIRST REG DATE')
                                          ->setCellValue('B36', 'MANUFACTURE YEAR')
                                          ->setCellValue('B37', 'HS CODE')
                                          ->setCellValue('B38', 'COLOR')

                                          ->setCellValue('C34', $dataRow->car_model_name)
                                          ->setCellValue('D34', $dataRow->chassis_number)
                                          ->setCellValue('C35', $year.'.'.$month)
                                          ->setCellValue('C36', $modelYear)
                                          ->setCellValue('C38', strtoupper($dataRow->color_name))

                                          ->setCellValue('I34', 'X')
                                          ->setCellValue('K34', 'X')
                                          ->setCellValue('F33', 'UNIT(S)')
                                          ->setCellValue('E33', '1')
                                          ->setCellValue('F34', $dataRow->car_weight)
                                          ->setCellValue('G34', 'KGS')
                                          ->setCellValue('H34', $dataRow->car_length)
                                          ->setCellValue('J34', $dataRow->car_width)
                                          ->setCellValue('L34', $dataRow->car_height)
                                          ->setCellValue('M34', $meas)
                                          ->setCellValue('F43', '"FREIGHT PREPAID""AS ARRANGED"')
                                          ->setCellValue('H46', 'SILMI JAPAN CO., LTD.')
                                          ->setCellValue('A51', 'B/L DATE')
                                          ->setCellValue('A52', 'B/L ISSUE: KOBE')
                                          ->setCellValue('A53', 'B/L ORIGINAL 3 COPY 3')
                                          ->setCellValue('H51', 'CASE MARK')
                                          ->setCellValue('H52', 'SILMI JAPAN CO., LTD.')
                                          ;

            // Number Format
            $objPHPExcel->getActiveSheet()->getStyle('M34')->getNumberFormat()->setFormatCode('0.000');


            //font bold 
            $bold = array(
                'font'  => array(
                    'bold'  => true,
                        'color' => array('rgb' => '000000'),
                    'name'  => 'Microsoft Sans Serif'
                )
            );
            //font italic
            $italic = array(
                'font'  => array(
                    'italic'  => true,
                )
            );
        
            //font size 14
            $font16 = array(
                'font'  => array(
                    'size'  => 16,
                )
            );
            $font11 = array(
                'font'  => array(
                    'size'  => 11,
                )
            );
            //font size 12
            $font12 = array(
                'font'  => array(
                    'size'  => 12,
                )
            );
            //font size 24
            $font20 = array(
                'font'  => array(
                    'size'  => 20,
                )
            );
            //font size 22
            $font22 = array(
                'font'  => array(
                    'size'  => 22,
                )
            );
            //font size 22
            $font9 = array(
                'font'  => array(
                    'size'  => 9,
                )
            );
            //font famili Time New Roman
            $time_new_toman = array(
                'font'  => array(
                    'name'  => 'Times New Roman'
                )
            );
            //text align center
            $align_center = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                )
            );
            $align_ver= array(
                'alignment' => array(
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                )
            );
            //text align left
            $align_left = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                )
            );
            $align_right = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('C2:E2')->applyFromArray($align_ver);
            $objPHPExcel->getActiveSheet()->getStyle('C10:E10')->applyFromArray($align_ver);
            $objPHPExcel->getActiveSheet()->getStyle('E21:H21')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($font16);
            $objPHPExcel->getActiveSheet()->getStyle('H46')->applyFromArray($font22);
            $objPHPExcel->getActiveSheet()->getStyle('A3:M44')->applyFromArray($font11);
            $objPHPExcel->getActiveSheet()->getStyle('A1:K24')->applyFromArray($time_new_toman);
            // $objDrawing = new PHPExcel_Worksheet_MemoryDrawing();
            // $objDrawing->setName('ru');
            // $objDrawing->setDescription('ru-japan');
            // // $objDrawing->setImageResource($gdImage);
            // $objDrawing->setRenderingFunction(PHPExcel_Worksheet_MemoryDrawing::RENDERING_PNG);
            // $objDrawing->setMimeType(PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_DEFAULT);
            // $objDrawing->setHeight(100);
            // $objDrawing->setCoordinates('B2');
            // $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

            //get data from db to cell
            
            
            //wrap text
            $objPHPExcel->getActiveSheet()->getStyle('E13:I18')->getAlignment()->setWrapText(true); 

            if($dataRow->consignee_name!=''){
                $objWorkSheet->setCellValue('C61',  'Name : '.'consignee_name')
                             ->setCellValue('C63',  'Phone : '.'consignee_phone')
                             ->setCellValue('C65',  'Address : '.'consignee_address');
            
            }
            $car_width  = $dataRow->car_width / 100;
            $car_length = $dataRow->car_length / 100;
            $car_height = $dataRow->car_height / 100;
            $car_meas = $car_width * $car_length * $car_height;
                                 

            $index++;
            $num_sheet++;
        }

        $objPHPExcel->setActiveSheetIndex(1);
        //INV 01
        $objPHPExcel->setActiveSheetIndex(0);
      
        $index = 0;
        $num_sheet = 1;
        $broombaseRow_inst = 24;
        foreach($data as $key => $dataRow) { 
            $modelYear = $dataRow->car_model_year;
            $fuel = "";
            $i += 1;
            $row = $baseRow + $key;
            $invoice_no = $dataRow->shipping_invoice_code; 
            $cc = $dataRow->engine_size;
            $meas = ($dataRow->car_length * $dataRow->car_width * $dataRow->car_height)/ 1000000;
            $total_meas += $meas;
            $total_weights += $dataRow->car_weight;
            $total_sold_price = $dataRow->fob + $dataRow->freight_fee + $dataRow->inspection + $dataRow->insurance - (float)$dataRow->discount; 
            $grand_total += $total_sold_price;
            
            if($dataRow->currency == "USD"){
                $currency ='$';
            }else{
                $currency ='¥';
            }
            if($dataRow->car_fuel == "Petrol"){
                $fuel = "G";
            }elseif($dataRow->car_fuel == "Diesel"){
                $fuel = "D";
            }elseif($dataRow->car_fuel == "LPG"){
                $fuel = "LPG";
            }elseif($dataRow->car_fuel == "LPG_Pertrol"){
                $fuel = "L+G";
            }elseif($dataRow->car_fuel == "Hybrid"){
                $fuel = "H";
            }
            $invoice_no = $dataRow->shipping_invoice_code; 
            $next_sheets  = 1 + $index;
            $objWorkSheet = $objPHPExcel->createSheet($next_sheets);
            $objWorkSheet->setTitle("Inv $num_sheet");
            $objPHPExcel->setActiveSheetIndex($next_sheets);
            // start design excel
            //set column width
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(5);
            $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(25);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(18);
            $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(15);
            $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setWidth(15);
            //set border thick aound
            $border_left_thick= array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            $border_top_thick= array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            //block border thin
            $border_top_thin= array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_left_thin= array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_bottom_thin= array(
                'borders' => array(
                    'bottom' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $objPHPExcel->getActiveSheet()
            ->getStyle('E6')
            ->getAlignment()
            ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $objPHPExcel->getActiveSheet()->getStyle("A18:K18")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("A35:K35")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("A19:K19")->applyFromArray($border_top_thin);

            $objPHPExcel->getActiveSheet()->getStyle("E33:K33")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("E33")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("E34")->applyFromArray($border_left_thin);

            $objPHPExcel->getActiveSheet()->getStyle("B18")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("C18")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("D18")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("E18")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("F18")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("G18")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("H18")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("I18")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("J18")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("K18")->applyFromArray($border_left_thin);

            $objPHPExcel->getActiveSheet()->getStyle("A25:K25")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("A26:K26")->applyFromArray($border_top_thin);

            $objPHPExcel->getActiveSheet()->getStyle("L1:L34")->applyFromArray($border_left_thin);

            $objPHPExcel->getActiveSheet()->getStyle('A1')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('I3')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('I9')->getFont()->setUnderline(true);

            $objPHPExcel->getActiveSheet()->getStyle('B9')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('B10')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('B11')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('B12')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('B13')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('B14')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('B15')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('B16')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('C2')->getAlignment()->setWrapText(true);

            $objPHPExcel->getActiveSheet()->getStyle('A16:N16')->getAlignment()->setHorizontal('center');
            $objPHPExcel->getActiveSheet()->getStyle('A17:N17')->getAlignment()->setHorizontal('center');

            $objPHPExcel->getActiveSheet()->getStyle('F24:F27')->getAlignment()->setHorizontal('right');
            $objPHPExcel->getActiveSheet()->getStyle('B16')->getAlignment()->setHorizontal('left');
            $objPHPExcel->getActiveSheet()->getStyle('C16')->getAlignment()->setHorizontal('left');
            //merge cell
            $objPHPExcel->getActiveSheet()->mergeCells('A1:K1');
            $objPHPExcel->getActiveSheet()->mergeCells('C2:G6');
            $objPHPExcel->getActiveSheet()->mergeCells('C9:D9');
            $objPHPExcel->getActiveSheet()->mergeCells('C13:D13');
            $objPHPExcel->getActiveSheet()->mergeCells('C15:D15');
            $objPHPExcel->getActiveSheet()->mergeCells('C16:D16');
            $objPHPExcel->getActiveSheet()->mergeCells('J9:K9');
            
            //set label to cell
            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'INVOICE')
                                          ->setCellValue('C2', $dataRow->full_name."\n".$dataRow->address."\nTEL: ".$dataRow->phone_number)
                                          ->setCellValue('I3', 'Date:')
                                          ->setCellValue('K3', date("Y-m-d"))
                                          ->setCellValue('B2', 'Merssrs')
                                          ->setCellValue('B9', 'Vessel Name:')
                                          ->setCellValue('B10', 'Voy. No.:')
                                          ->setCellValue('B11', 'On or about:')
                                          ->setCellValue('B12', 'From:')
                                          ->setCellValue('B13', 'TO')
                                          ->setCellValue('B14', 'Vai:')
                                          ->setCellValue('B15', 'Payment:')
                                          ->setCellValue('B16', 'Commodity:')
                                          ->setCellValue('C9', $dataRow->vessel_name)
                                          ->setCellValue('C10', $dataRow->voyage_no)
                                          ->setCellValue('C11', '')
                                          ->setCellValue('C12', $dataRow->port_of_loading_name)
                                          ->setCellValue('C13', $dataRow->final_des_name)
                                          ->setCellValue('C14', '')
                                          ->setCellValue('C15', 'T/T REMITTANCE')
                                          ->setCellValue('C16', 'USED VEHICLE(S)')

                                          ->setCellValue('I9', 'Shipping mark:')
                                          ->setCellValue('J9', 'SILMI JAPAN CO., LTD')
                                          ->setCellValue('B18', 'Make')
                                          ->setCellValue('C18', 'Model')
                                          ->setCellValue('D18', 'Chassis No.')
                                          ->setCellValue('E18', 'Year')
                                          ->setCellValue('F18', 'Seat')
                                          ->setCellValue('G18', 'Capacity')
                                          ->setCellValue('H18', 'Fuel')
                                          ->setCellValue('I18', 'N/G.Weight')
                                          ->setCellValue('J18', 'Price')

                                          ->setCellValue('B21', $dataRow->car_make_name)
                                          ->setCellValue('C21', $dataRow->car_model_name)
                                          ->setCellValue('D21', $dataRow->chassis_number)
                                          ->setCellValue('E21', $modelYear)
                                          ->setCellValue('F21', $dataRow->seats)
                                          ->setCellValue('G21', $dataRow->engine_size)
                                          ->setCellValue('H21', $fuel)
                                          ->setCellValue('I21', '')
                                          ->setCellValue('J21', '申告価格')

                                          ->setCellValue('C25', 'TOTAL')
                                          ->setCellValue('D25', '1')
                                          ->setCellValue('E25', 'UNIT(S)')
                                          ->setCellValue('J25', '')
                                          ->setCellValue('F21', $dataRow->seats)
                                          ->setCellValue('G19', '(CC)')
                                          ->setCellValue('I19', '(KGS)')
                                          ->setCellValue('J19', '(FOB Japan)')
                                          ->setCellValue('G21', $dataRow->engine_size)
                                          ->setCellValue('E29', 'SHIPPER名')
                                          ->setCellValue('G29', 'SILMI JAPAN CO., LTD.')
                                          ->setCellValue('E33', '住所')
                                          ->setCellValue('E34', '電話番号')
                                          ->setCellValue('G33', '3-6-28, Miyanosaka, Hirakata, Osaka, Japan')
                                          ->setCellValue('G34', '81-72-392-4971')
                                          ->setCellValue('J25', $currency." ".$total_sold_price)
                                          ->setCellValue('K21', $currency." ".$total_sold_price);
            //font bold 
            $bold = array(
                'font'  => array(
                    'bold'  => true,
                        'color' => array('rgb' => '000000'),
                    'name'  => 'Microsoft Sans Serif'
                )
            );
            //font italic
            $italic = array(
                'font'  => array(
                    'italic'  => true,
                )
            );
        
            //font size 14
            $font14 = array(
                'font'  => array(
                    'size'  => 14,
                )
            );
            $font11 = array(
                'font'  => array(
                    'size'  => 11,
                )
            );
            //font size 12
            $font12 = array(
                'font'  => array(
                    'size'  => 12,
                )
            );
            //font size 24
            $font20 = array(
                'font'  => array(
                    'size'  => 20,
                )
            );
            //font size 22
            $font22 = array(
                'font'  => array(
                    'size'  => 22,
                )
            );
            //font size 22
            $font9 = array(
                'font'  => array(
                    'size'  => 9,
                )
            );
            //font famili Time New Roman
            $time_new_toman = array(
                'font'  => array(
                    'name'  => 'Times New Roman'
                )
            );
            //text align center
            $align_center = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                )
            );
            //text align left
            $align_left = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                )
            );
            $align_right = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('C2:E2')->applyFromArray($align_ver);
            $objPHPExcel->getActiveSheet()->getStyle('E21:H21')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($bold);
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($font20);
            $objPHPExcel->getActiveSheet()->getStyle('B2:K24')->applyFromArray($font11);
            $objPHPExcel->getActiveSheet()->getStyle('A1:K24')->applyFromArray($time_new_toman);
            // $objDrawing = new PHPExcel_Worksheet_MemoryDrawing();
            // $objDrawing->setName('ru');
            // $objDrawing->setDescription('ru-japan');
            // // $objDrawing->setImageResource($gdImage);
            // $objDrawing->setRenderingFunction(PHPExcel_Worksheet_MemoryDrawing::RENDERING_PNG);
            // $objDrawing->setMimeType(PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_DEFAULT);
            // $objDrawing->setHeight(100);
            // $objDrawing->setCoordinates('B2');
            // $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

            //get data from db to cell
            
            
            //wrap text
            $objPHPExcel->getActiveSheet()->getStyle('E13:I18')->getAlignment()->setWrapText(true); 

            if($dataRow->consignee_name!=''){
                $objWorkSheet->setCellValue('C61',  'Name : '.'consignee_name')
                             ->setCellValue('C63',  'Phone : '.'consignee_phone')
                             ->setCellValue('C65',  'Address : '.'consignee_address');
            
            }
            $car_width  = $dataRow->car_width / 100;
            $car_length = $dataRow->car_length / 100;
            $car_height = $dataRow->car_height / 100;
            $car_meas = $car_width * $car_length * $car_height;
                                 

            $index++;
            $num_sheet++;
        }

        $objPHPExcel->setActiveSheetIndex(1);

        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="invoice_'.$ship_invoice.'.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        return response()->json([
            $writer->save('php://output')
        ]);
    }

    public function shipping_invoice_jamica_combined( $ship_invoice ) {
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/shipping_invoice_jamica_.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
        $data = Shipping_model::get_shipment_excel($ship_invoice);

        $insert_row_count1 = 0;
        $total_fobRow = 20;

        $baseRow = 21;
    
        $total =0;
        $cif_total =0;
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list( $user->staff_id );
        $shipping_company = Shipping_model::get_shipping_company();
        $discharges = Shipping_model::get_discharge($hide_pakistan);
        $port_of_loading = Shipping_model::get_port_of_loading();
        $arr_shipping_com = array();
        $arr_portloading = array();
        foreach ($shipping_company as $value) {
            $arr_shipping_com[$value->shipping_co_id]= $value->shipping_co_name;
        }
        foreach ($port_of_loading as $val1) {
            $arr_portloading[$val1->port_of_loading_id]= $val1->port_of_loading_name;
        }
        //boder all
        $border_all = array(
            'borders' => array(
                'allborders' => array(
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => array('rgb' => '000000')
                )
            )
        );

        //boder all
        $border_bottom = array(
            'borders' => array(
                'bottom' => array(
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,
                    'color' => array('rgb' => '000000')
                )
            )
        );
    

        //text align center
        $align_center = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
            )
        );
        //text align left
        $align_left = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
            )
        );
        $align_right = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
            )
        );

        $red = array(
        'font'  => array(
            'color' => array(
              'rgb' => 'FF0000'
            ) 
        )             
      );

        $time_new_toman = array(
            'font'  => array(
                'name'  => 'Times New Roman'
            )
        );
        $size11 = array(
            'font'  => array(
                'color' => array(
                  'rgb' => '000000'
                ),
                'size'  => 11
            )
          );
        $font24 = array(
            'font'  => array(
                'color' => array(
                  'rgb' => '000000'
                ),
                'size'  => 22
            )
          );

         // Rename worksheet
        

        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->setTitle('INV');
        $i = 0;
        $total_meas = 0;
        $total_weights = 0;
        $grand_total = 0;
        $invoice_no = "";
        $currency = '';
        
        foreach($data as $r => $dataRow) {
            $modelYear = $dataRow->car_model_year;
            $fuel = "";
            $i += 1;
            $row = $baseRow + $r;
            $invoice_no = $dataRow->shipping_invoice_code; 
            $cc = $dataRow->engine_size;
            $meas = ($dataRow->car_length * $dataRow->car_width * $dataRow->car_height)/ 1000000;
            $total_meas += $meas;
            $total_weights += $dataRow->car_weight;
            $total_sold_price = $dataRow->fob + $dataRow->freight_fee + $dataRow->inspection + $dataRow->insurance - (float)$dataRow->discount; 
            $grand_total += $total_sold_price;
            
            if($dataRow->currency == "USD"){
                $currency ='$';
            }else{
                $currency ='¥';
            }
            if($dataRow->car_fuel == "Petrol"){
                $fuel = "G";
            }elseif($dataRow->car_fuel == "Diesel"){
                $fuel = "D";
            }elseif($dataRow->car_fuel == "LPG"){
                $fuel = "LPG";
            }elseif($dataRow->car_fuel == "LPG_Pertrol"){
                $fuel = "L+G";
            }elseif($dataRow->car_fuel == "Hybrid"){
                $fuel = "H";
            }

            $objPHPExcel->getActiveSheet()->getStyle('B'.$row)->applyFromArray($align_left);
            $objPHPExcel->getActiveSheet()->getStyle('C'.$row)->applyFromArray($align_left);
            $objPHPExcel->getActiveSheet()->getStyle('D'.$row)->applyFromArray($align_left);
            $objPHPExcel->getActiveSheet()->getStyle('E'.$row)->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('F'.$row)->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('G'.$row)->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('H'.$row)->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('I'.$row)->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('J'.$row)->applyFromArray($align_left);
            $objPHPExcel->getActiveSheet()->getStyle('K'.$row)->applyFromArray($align_left);

            $objPHPExcel->getActiveSheet()->setCellValue('B'.$row, $dataRow->car_make_name)
                                        ->setCellValue('C'.$row, $dataRow->car_model_name)
                                        ->setCellValue('D'.$row, $dataRow->chassis_number)
                                        ->setCellValue('E'.$row, $modelYear)
                                        ->setCellValue('F'.$row, $dataRow->seats)
                                        ->setCellValue('G'.$row, $dataRow->engine_size)
                                        ->setCellValue('H'.$row, $fuel)
                                        ->setCellValue('I'.$row, '')
                                        ->setCellValue('J'.$row, '申告価格')
                                        ->setCellValue('K'.$row, $currency." ".$total_sold_price);

        
            
        }
        $r18 = 17+ $i;
        $r20 = 19+ $i;
        $r21 = 20+ $i;
        $r22 = 21+ $i;
        $r23 = 22+ $i;
        $r24 = 23+ $i;
        $r25 = 24+ $i;
        $r26 = 25+ $i;
        $r27 = 26+ $i;

        $objPHPExcel->getActiveSheet()->setCellValue('C09', $dataRow->vessel_name)
                                        ->setCellValue('C10', $dataRow->voyage_no)
                                        ->setCellValue('C11', '')
                                        ->setCellValue('C12', $dataRow->port_of_loading_name)
                                        ->setCellValue('C13', $dataRow->final_des_name)
                                        ->setCellValue('C14', '')
                                        ->setCellValue('C15', 'T/T REMITTANCE')
                                        ->setCellValue('C16', 'USED VEHICLE(S)')
                                        ->setCellValue('J9', 'SILMI JAPAN CO., LTD.')
                                        ->setCellValue('D36', $i)
                                        ->setCellValue('J36', $currency." ".$grand_total)
                                        ->setCellValue('K3', date("Y-m-d"))
                                        ->setCellValue('C2', $dataRow->full_name."\n".$dataRow->address."\nTEL: ".$dataRow->phone_number);

        $sumr= $r18-1; 

    // Sencond Sheet create //
        
        $objPHPExcel->setActiveSheetIndex(1);
        $objPHPExcel->getActiveSheet()->setTitle('SI');

                               
        $baseRow_inst = 34;
        $broombaseRow_inst = $baseRow_inst + 1;

        $total = 0;
        $full_length = 0;
        $full_width = 0;
        $full_height = 0;
        $full_weight = 0;
        $j = 0;
        $total_meas_inst = 0;
        $total_weights_inst = 0;
        $invoice_no_inst = "";
        $count_row = count($data) + $broombaseRow_inst;
        $rows = 0;
        $row2 = 0;
        $row3 = 0;
        $row4 = 0;
        $row5 = 0;
        $row6 = 0;
        foreach($data as $r => $dataRow) {
            $fuel = "";
            $j += 1;
            // $row = $baseRow_inst + $r;
            if($rows == 0){
                $rows = $baseRow_inst + $r;
            }else{
                $rows += 6;
            }
            $row2 = $rows + 1;
            $row3 = $rows + 2;
            $row4 = $rows + 3;
            $row5 = $rows + 4;
            $row6 = $rows + 5;
            
            $dop = explode(" ",$dataRow->date_of_production);
            $year = $dop[1];
            $mont = date('m', strtotime($dop[0]));
            $cc = $dataRow->engine_size;
            $meas_ins = ($dataRow->car_length * $dataRow->car_width * $dataRow->car_height)/ 1000000;
            $total_meas_inst += $meas_ins;
            $total_weights_inst += $dataRow->car_weight;

            $objPHPExcel->getActiveSheet()->getStyle('A'.$rows.':M'.$rows)->applyFromArray($time_new_toman);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$rows.':M'.$rows)->applyFromArray($size11);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$row2.':M'.$row2)->applyFromArray($time_new_toman);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$row2.':M'.$row2)->applyFromArray($size11);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$row3.':M'.$row3)->applyFromArray($time_new_toman);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$row3.':M'.$row3)->applyFromArray($size11);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$row4.':M'.$row4)->applyFromArray($time_new_toman);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$row4.':M'.$row4)->applyFromArray($size11);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$row5.':M'.$row5)->applyFromArray($time_new_toman);
            $objPHPExcel->getActiveSheet()->getStyle('A'.$row5.':M'.$row5)->applyFromArray($size11);

            $objPHPExcel->getActiveSheet()->mergeCells('D'.$rows.':E'.$rows);
            $objPHPExcel->getActiveSheet()->getStyle('H'.$rows)->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('I'.$rows)->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('J'.$rows)->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('K'.$rows)->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('L'.$rows)->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('F'.$rows)->applyFromArray($align_right);
            $objPHPExcel->getActiveSheet()->getStyle('M'.$rows)->applyFromArray($align_right);
            $objPHPExcel->getActiveSheet()->getStyle('C'.$row2)->applyFromArray($align_right);
            $objPHPExcel->getActiveSheet()->getStyle('C'.$row3)->applyFromArray($align_right);
            $objPHPExcel->getActiveSheet()->getStyle('C'.$row4)->applyFromArray($align_right);
            $objPHPExcel->getActiveSheet()->getStyle('C'.$row5)->applyFromArray($align_right);

            $objPHPExcel->getActiveSheet()->setCellValue('B'.$rows, $dataRow->car_make_name)
                                        ->setCellValue('C'.$rows, $dataRow->car_model_name)
                                        ->setCellValue('D'.$rows, $dataRow->chassis_number)
                                        ->setCellValue('F'.$rows, $dataRow->car_weight)
                                        ->setCellValue('G'.$rows, 'KGS')
                                        ->setCellValue('H'.$rows, $dataRow->car_length)
                                        ->setCellValue('I'.$rows, 'X')
                                        ->setCellValue('J'.$rows, $dataRow->car_width)
                                        ->setCellValue('K'.$rows, 'X')
                                        ->setCellValue('L'.$rows, $dataRow->car_height)
                                        ->setCellValue('M'.$rows, $meas_ins)
                                        ->setCellValue('B'.$row2, 'FIRST REG DATE')
                                        ->setCellValue('C'.$row2, $year.".".$mont)
                                        ->setCellValue('B'.$row3, 'MANUFACTURE YEAR')
                                        ->setCellValue('C'.$row3, $dataRow->car_model_year)
                                        ->setCellValue('B'.$row4, 'HS CODE')
                                        ->setCellValue('B'.$row5, 'COLOR')
                                        ->setCellValue('C'.$row5, strtoupper($dataRow->color_name))
                                        ->setCellValue('B'.$row6, '');

            // Number Format
            $objPHPExcel->getActiveSheet()->getStyle('M'.$rows)->getNumberFormat()->setFormatCode('0.000');
                                    
        }

        $plusRow4= $row6 + 4;
        $plusRow7= $row6 + 7;
        $plusRow8= $row6 + 8;
        $plusRow9= $row6 + 9;
        $plusRow10= $row6 + 10;
        $plusRow11= $row6 + 11;
        $plusRow12= $row6 + 12;
        $plusRow13= $row6 + 13;
        $plusRow14= $row6 + 14;

        $objPHPExcel->getActiveSheet()->getStyle('A'.$plusRow10.':M'.$plusRow10)->applyFromArray($border_bottom);
        $objPHPExcel->getActiveSheet()->getStyle('H'.$plusRow7.':M'.$plusRow9)->applyFromArray($border_all);
        $objPHPExcel->getActiveSheet()->getStyle('H'.$plusRow7)->applyFromArray($align_center);
        $objPHPExcel->getActiveSheet()->getStyle('F'.$plusRow4)->applyFromArray($red);
        $objPHPExcel->getActiveSheet()->getStyle('H'.$plusRow7)->applyFromArray($font24);
        $objPHPExcel->getActiveSheet()->mergeCells('H'.$plusRow7.':M'.$plusRow9);
        $objPHPExcel->getActiveSheet()->mergeCells('A'.$plusRow12.':C'.$plusRow12);
        $objPHPExcel->getActiveSheet()->mergeCells('A'.$plusRow13.':C'.$plusRow13);
        $objPHPExcel->getActiveSheet()->mergeCells('A'.$plusRow14.':C'.$plusRow14);
        $objPHPExcel->getActiveSheet()->mergeCells('H'.$plusRow12.':J'.$plusRow12);
        $objPHPExcel->getActiveSheet()->mergeCells('H'.$plusRow13.':L'.$plusRow13);
        $objPHPExcel->getActiveSheet()->mergeCells('F'.$plusRow4.':I'.$plusRow4);
        $objPHPExcel->getActiveSheet()->setCellValue('C3', 'SILMI JAPAN CO., LTD.'."\n".'3-6-28, Miyanosaka, Hirakata, Osaka, JAPAN'."\n".'PHONE: +81-72-392-4971'."\n".'EMAIL: jack@silmijapan.com')
                                        ->setCellValue('C10', $dataRow->full_name."\n".$dataRow->address."\nTEL: ".$dataRow->phone_number)
                                        ->setCellValue('L4', date('Y-m-d'))
                                        ->setCellValue('A23', $dataRow->vessel_name)
                                        ->setCellValue('E23', $dataRow->port_of_loading_name)
                                        ->setCellValue('F'.$plusRow4, '"FREIGHT PREPAID""AS ARRANGED"')
                                        ->setCellValue('H'.$plusRow7, 'SILMI JAPAN CO., LTD.')
                                        ->setCellValue('B'.$plusRow9, 'SAY :')
                                        ->setCellValue('C'.$plusRow9, 'ONE ('.$j.') UNIT(S) ONLY')
                                        ->setCellValue('A'.$plusRow12, 'B/L DATE')
                                        ->setCellValue('A'.$plusRow13, 'B/L ISSUE: KOBE')
                                        ->setCellValue('A'.$plusRow14, 'B/L ORIGINAL 3 COPY 3')
                                        ->setCellValue('H'.$plusRow12, 'CASE MARK')
                                        ->setCellValue('H'.$plusRow13, 'SILMI JAPAN CO., LTD.')
                                        ->setCellValue('E33', $j)
                                        ->setCellValue('A27', $dataRow->discharge_name)
                                        ;

        

        $objPHPExcel->setActiveSheetIndex(1);

        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="invoice_'.$ship_invoice.'.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        return response()->json([
            $writer->save('php://output')
        ]);
        
      
    }

    public function shipping_invoice_chile_seperate( $ship_invoice ){
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/shipping_invoice_chile_separate_.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
        $data = Shipping_model::get_shipment_excel($ship_invoice);

         // var_dump($data);
         $des = count($data)." UNITS OF USED CARS";

         $insert_row_count1 = 0;
         $total_fobRow = 20;
 
         $baseRow = 18;
     
         $total =0;
         $cif_total =0;
         $shipping_company = Shipping_model::get_shipping_company();
         $user = Auth::user();
         $hide_pakistan =  Stocklist_model::hide_car_on_stock_list( $user->staff_id );
         $discharges = Shipping_model::get_discharge($hide_pakistan);
         $port_of_loading = Shipping_model::get_port_of_loading();
         $arr_shipping_com = array();
         $arr_portloading = array();
         foreach ($shipping_company as $value) {
             $arr_shipping_com[$value->shipping_co_id]= $value->shipping_co_name;
         }
         foreach ($port_of_loading as $val1) {
             $arr_portloading[$val1->port_of_loading_id]= $val1->port_of_loading_name;
         }
 
          // Rename worksheet
         $objPHPExcel->getActiveSheet()->setTitle('Invoice');
 
         $objPHPExcel->setActiveSheetIndex(0);
         $objPHPExcel->getSheetByName('Invoice')
         ->setSheetState(\PhpOffice\PhpSpreadsheet\Worksheet\Worksheet::SHEETSTATE_VERYHIDDEN);
         
         $i = 0;
         $total_meas = 0;
         $total_weights = 0;
         $grand_total = 0;
         $invoice_no = "";
         $index = 0;
         $j=0;
         $num_sheet = 1;
         $broombaseRow_inst = 24;
         foreach($data as $key => $dataRow) { 
             
             $fuel ='';
             $j += 1;
             if($j == 1){
                 $invoice_no_inst = $dataRow->shipping_invoice_code;
             }
             $cc = $dataRow->engine_size;
             // echo $cc;die();
             if($dataRow->car_fuel == "Petrol"){
                 $fuel = "G";
             }elseif($dataRow->car_fuel == "Diesel"){
                 $fuel = "D";
             }elseif($dataRow->car_fuel == "LPG"){
                 $fuel = "LPG";
             }elseif($dataRow->car_fuel == "LPG_Pertrol"){
                 $fuel = "L+G";
             }elseif($dataRow->car_fuel == "Hybrid"){
                 $fuel = "H";
             }
             $total_sold_price = $dataRow->fob + $dataRow->freight_fee + $dataRow->inspection + $dataRow->insurance - (float)$dataRow->discount; 
             $grand_total += $total_sold_price;
             $invoice_no = $dataRow->shipping_invoice_code; 
             $next_sheets  = 1 + $index;
             $objWorkSheet = $objPHPExcel->createSheet($next_sheets);
             $objWorkSheet->setTitle("$num_sheet");
             $objPHPExcel->setActiveSheetIndex($next_sheets);
             // start design excel
             //set column width
             $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
             $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(6);
             $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(11);
             $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
             $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(6);
             $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(13);
             $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(13);
             $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(14);
             $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(6);
             //set border thick aound
             $border_left_thick= array(
                 'borders' => array(
                     'left' => array(
                         'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                     )
                 )
             );
             $border_top_thick= array(
                 'borders' => array(
                     'top' => array(
                         'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                     )
                 )
             );
             //block border thin
             $border_top_thin= array(
                 'borders' => array(
                     'top' => array(
                         'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                     )
                 )
             );
             $border_left_thin= array(
                 'borders' => array(
                     'left' => array(
                         'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                     )
                 )
             );
             $border_bottom_thin= array(
                 'borders' => array(
                     'bottom' => array(
                         'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                     )
                 )
             );
              //font famili Time New Roman
              $time_new_toman = array(
                'font'  => array(
                    'name'  => 'Microsoft Sans Serif'
                )
            );
             $objPHPExcel->getActiveSheet()
             ->getStyle('E6')
             ->getAlignment()
             ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
             $objPHPExcel->getActiveSheet()->getStyle("K32:N32")->applyFromArray($border_top_thin);
             $objPHPExcel->getActiveSheet()->getStyle("K36:N36")->applyFromArray($border_top_thin);
             $objPHPExcel->getActiveSheet()->getStyle("K32:K35")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("O32:O35")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle('A6')->getFont()->setUnderline(true);
             $objPHPExcel->getActiveSheet()->getStyle('M7')->getFont()->setUnderline(true);
             $objPHPExcel->getActiveSheet()->getStyle('D13')->getAlignment()->setWrapText(true);
             $objPHPExcel->getActiveSheet()->getStyle('A:O')->applyFromArray($time_new_toman);
             //merge cell
             $objPHPExcel->getActiveSheet()->mergeCells('A1:N1');
             $objPHPExcel->getActiveSheet()->mergeCells('A2:N2');
             $objPHPExcel->getActiveSheet()->mergeCells('A3:N3');
             $objPHPExcel->getActiveSheet()->mergeCells('A4:N4');
             $objPHPExcel->getActiveSheet()->mergeCells('A6:N6');
             $objPHPExcel->getActiveSheet()->mergeCells('A8:B8');
             $objPHPExcel->getActiveSheet()->mergeCells('M7:N7');
             $objPHPExcel->getActiveSheet()->mergeCells('D8:F8');
             $objPHPExcel->getActiveSheet()->mergeCells('M8:N8');
             $objPHPExcel->getActiveSheet()->mergeCells('D9:G9');
             $objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
             $objPHPExcel->getActiveSheet()->mergeCells('D11:F11');
             $objPHPExcel->getActiveSheet()->mergeCells('A13:B13');
             $objPHPExcel->getActiveSheet()->mergeCells('D13:H17');
             $objPHPExcel->getActiveSheet()->mergeCells('A20:C20');
             $objPHPExcel->getActiveSheet()->mergeCells('D20:M20');
             $objPHPExcel->getActiveSheet()->mergeCells('A22:C22');
 
             $objPHPExcel->getActiveSheet()->mergeCells('D22:F22');
             $objPHPExcel->getActiveSheet()->mergeCells('D24:F24');
             $objPHPExcel->getActiveSheet()->mergeCells('A25:B25');
             $objPHPExcel->getActiveSheet()->mergeCells('D25:F25');
             $objPHPExcel->getActiveSheet()->mergeCells('D26:L26');
             $objPHPExcel->getActiveSheet()->mergeCells('A31:C31');
             $objPHPExcel->getActiveSheet()->mergeCells('A32:C32');
             $objPHPExcel->getActiveSheet()->mergeCells('A33:C33');
             $objPHPExcel->getActiveSheet()->mergeCells('A34:C34');
             $objPHPExcel->getActiveSheet()->mergeCells('A35:C35');
             $objPHPExcel->getActiveSheet()->mergeCells('A36:C36');
             $objPHPExcel->getActiveSheet()->mergeCells('A37:C37');
             $objPHPExcel->getActiveSheet()->mergeCells('A38:C38');
             $objPHPExcel->getActiveSheet()->mergeCells('A39:C39');
 
             $objPHPExcel->getActiveSheet()->mergeCells('K32:N32');
             $objPHPExcel->getActiveSheet()->mergeCells('K33:N33');
             $objPHPExcel->getActiveSheet()->mergeCells('K34:N34');
             $objPHPExcel->getActiveSheet()->mergeCells('K35:N35');
 
             $objPHPExcel->getActiveSheet()->mergeCells('D31:F31');
             $objPHPExcel->getActiveSheet()->mergeCells('D32:F32');
             $objPHPExcel->getActiveSheet()->mergeCells('D33:F33');
             $objPHPExcel->getActiveSheet()->mergeCells('D34:F34');
             $objPHPExcel->getActiveSheet()->mergeCells('D35:F35');
             $objPHPExcel->getActiveSheet()->mergeCells('D36:F36');
             $objPHPExcel->getActiveSheet()->mergeCells('D37:F37');
 
             //set label to cell
             $objPHPExcel->getActiveSheet()->setCellValue('A1', 'SILMI Japan Co., Ltd.')
                                           ->setCellValue('A2', '3-6-28, Miyanosaka, Hirakata-city,')
                                           ->setCellValue('A3', ' Osaka, Japan')
                                           ->setCellValue('A4', 'PHONE: +81-72-392-4971')
                                           ->setCellValue('A6', 'SHIPPING INSTRUCTION')
                                           ->setCellValue('M7', date("Y-m-d"))
                                           ->setCellValue('M8', $invoice_no_inst)
                                           ->setCellValue('J7', 'DATE:')
                                           ->setCellValue('J8', 'INV NO')
                                           ->setCellValue('A8', 'SHIPPER:')
                                           ->setCellValue('D8', 'SILMI JAPAN CO., LTD.')
                                           ->setCellValue('D9', '3-6-28 Miyanosaka, Hirakata, Osaka, JAPAN')
                                           ->setCellValue('D10', 'PHONE: +81-72-392-4971')
                                           ->setCellValue('D11', 'EMAIL: jack@silmijapan.com')
                                           ->setCellValue('D24', '1 CONTAINER SAID TO CONTAIN')
                                           ->setCellValue('D25', '1 UNITS OF USED CARS')
                                           ->setCellValue('A13', 'CONSIGNEE :')
                                           ->setCellValue('D13', 'NIGATAKE ENTERPRISES LTDA SANTA ROSA DE HUARA MZ D,'."\n".' SITIO 32, LOCAL 8, ZOFRI-IQUIQUE'."\n".'TEL: (PH) 0056-57-2417102 (EMAIL) SERENA2363@YAHOO.ES'."\n".'(RUT) 78.746.580-3')
                                           ->setCellValue('A20', 'NOTIFY PARTY :')
                                           ->setCellValue('D20', "SAME AS CONSIGNEE")
                                           ->setCellValue('A22', 'FINAL DESTINATION :')
                                           ->setCellValue('D22', "IQUIQUE,CHILE")
                                           ->setCellValue('D24', '1 CONTAINER SAID TO CONTAIN')
                                           ->setCellValue('D25', '4 UNITS OF USED CARS')
                                           ->setCellValue('D26', "BRAND : ". $dataRow->car_make_name." ".$dataRow->car_model_name." ENGINE :".$cc."CC"." ".$dataRow->drive_type." LEFT HAND DRIVE"." CHASSIS NO : ".$dataRow->chassis_number." ")
                                           ->setCellValue('A31', 'SHIPPING FROM :')
                                           ->setCellValue('A32', 'SHIPPED TO :')
                                           ->setCellValue('A33', 'SHIPPED PER :')
                                           ->setCellValue('A34', 'VOY :')
                                           ->setCellValue('A35', 'SHIPPED ON :')
                                           ->setCellValue('A36', 'BOOKING :')
                                           ->setCellValue('A37', 'SHIPPING COMPANY :')
                                           ->setCellValue('A39', 'SILMI JAPAN CO., LTD.')
                                           ->setCellValue('G31', 'FREIGHT :')
                                           ->setCellValue('G32', 'B/L ISSUE BY :')
                                           ->setCellValue('G33', 'B/L')
                                           ->setCellValue('K31', 'MARKS & NO.S')
                                           ->setCellValue('K32', 'SILMI JAPAN CO., LTD.')
                                           ->setCellValue('K34', "IQUIQUE")
 
                                           ->setCellValue('H31', "PREPAID AS ARRANGED" )
                                           ->setCellValue('H32', $dataRow->bl_issue_by)
                                           ->setCellValue('H33', 'COPY 1')
                                           ->setCellValue('D31', $dataRow->port_of_loading_name)
                                           ->setCellValue('D32', "IQUIQUE")
                                           ->setCellValue('D33', $dataRow->vessel_name)
                                           ->setCellValue('D34', $dataRow->voyage_no)
                                           ->setCellValue('D35', $dataRow->etd)
                                           ->setCellValue('D36', $dataRow->booking)
                                           ->setCellValue('D37', $arr_shipping_com[$dataRow->shipping_co_id]);
                                           
             //font bold 
             $bold = array(
                 'font'  => array(
                     'bold'  => true,
                         'color' => array('rgb' => '000000'),
                     'name'  => 'Microsoft Sans Serif'
                 )
             );
             //font italic
             $italic = array(
                 'font'  => array(
                     'italic'  => true,
                 )
             );
         
             //font size 14
             $font14 = array(
                 'font'  => array(
                     'size'  => 14,
                 )
             );
             //font size 12
             $font12 = array(
                 'font'  => array(
                     'size'  => 12,
                 )
             );
             //font size 24
             $font24 = array(
                 'font'  => array(
                     'size'  => 24,
                 )
             );
             //font size 22
             $font22 = array(
                 'font'  => array(
                     'size'  => 22,
                 )
             );
             //font size 22
             $font9 = array(
                 'font'  => array(
                     'size'  => 9,
                 )
             );
             //font famili Time New Roman
             $time_new_toman = array(
                 'font'  => array(
                     'name'  => 'Microsoft Sans Serif'
                 )
             );
             //text align center
             $align_center = array(
                 'alignment' => array(
                     'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                 )
             );
             //text align left
             $align_left = array(
                 'alignment' => array(
                     'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                 )
             );
             $align_right = array(
                 'alignment' => array(
                     'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                 )
             );
             $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($align_center);
             $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($bold);
             $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($font12);
             $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($align_center);
             $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($bold);
             $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($font12);
           
            //  $objDrawing = new PHPExcel_Worksheet_MemoryDrawing();
            //  $objDrawing->setName('ru');
            //  $objDrawing->setDescription('ru-japan');
            //  // $objDrawing->setImageResource($gdImage);
            //  $objDrawing->setRenderingFunction(PHPExcel_Worksheet_MemoryDrawing::RENDERING_PNG);
            //  $objDrawing->setMimeType(PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_DEFAULT);
            //  $objDrawing->setHeight(100);
            //  $objDrawing->setCoordinates('B2');
            //  $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
             
             //wrap text
             $objPHPExcel->getActiveSheet()->getStyle('E13:I18')->getAlignment()->setWrapText(true); 
 
             if($dataRow->consignee_name!=''){
                 $objWorkSheet->setCellValue('C61',  'Name : '.'consignee_name')
                              ->setCellValue('C63',  'Phone : '.'consignee_phone')
                              ->setCellValue('C65',  'Address : '.'consignee_address');
             
             }
             $car_width  = $dataRow->car_width / 100;
             $car_length = $dataRow->car_length / 100;
             $car_height = $dataRow->car_height / 100;
             $car_meas = $car_width * $car_length * $car_height;
                                  
 
             $index++;
             $num_sheet++;
         }
 
         $objPHPExcel->setActiveSheetIndex(0);
       
         $index = 0;
         $num_sheet = 1;
         $broombaseRow_inst = 24;
         foreach($data as $key => $dataRow) { 
             $modelYear = $dataRow->car_model_year;
             $invoice_no = $dataRow->shipping_invoice_code; 
             $next_sheets  = 1 + $index;
             $objWorkSheet = $objPHPExcel->createSheet($next_sheets);
             $objWorkSheet->setTitle("Inv $num_sheet");
             $objPHPExcel->setActiveSheetIndex($next_sheets);
             // start design excel
             //set column width
             $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(6);
             $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
             $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(11);
             $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
             $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
             $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(13);
             $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(13);
             $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(14);
             $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(6);
             //set border thick aound
             $border_left_thick= array(
                 'borders' => array(
                     'left' => array(
                         'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                     )
                 )
             );
             $border_top_thick= array(
                 'borders' => array(
                     'top' => array(
                         'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                     )
                 )
             );
             //block border thin
             $border_top_thin= array(
                 'borders' => array(
                     'top' => array(
                         'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                     )
                 )
             );
             $border_left_thin= array(
                 'borders' => array(
                     'left' => array(
                         'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                     )
                 )
             );
             $border_bottom_thin= array(
                 'borders' => array(
                     'bottom' => array(
                         'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                     )
                 )
             );
             $objPHPExcel->getActiveSheet()
             ->getStyle('E6')
             ->getAlignment()
             ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
             $objPHPExcel->getActiveSheet()->getStyle("L20:O20")->applyFromArray($border_top_thin);
             $objPHPExcel->getActiveSheet()->getStyle("L24:O24")->applyFromArray($border_top_thin);
             $objPHPExcel->getActiveSheet()->getStyle("L20:L23")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("P20:P23")->applyFromArray($border_left_thin);
 
             $objPHPExcel->getActiveSheet()->getStyle("A16:N16")->applyFromArray($border_top_thin);
             $objPHPExcel->getActiveSheet()->getStyle("A17:N17")->applyFromArray($border_top_thin);
             $objPHPExcel->getActiveSheet()->getStyle("A18:N18")->applyFromArray($border_top_thin);
 
             $objPHPExcel->getActiveSheet()->getStyle("A16:A17")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("B16:B17")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("C16:C17")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("D16:D17")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("E16:E17")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("F16:F17")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("G16:G17")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("H16:H17")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("I16:I17")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("J16:J17")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("K16:K17")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("L16:L17")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("M16:M17")->applyFromArray($border_left_thin);
             $objPHPExcel->getActiveSheet()->getStyle("N16:N17")->applyFromArray($border_left_thin);
 
             $objPHPExcel->getActiveSheet()->getStyle("O16:O17")->applyFromArray($border_left_thin);
 
             $objPHPExcel->getActiveSheet()->getStyle('A6')->getFont()->setUnderline(true);
             $objPHPExcel->getActiveSheet()->getStyle('M7')->getFont()->setUnderline(true);
             $objPHPExcel->getActiveSheet()->getStyle('D8')->getAlignment()->setWrapText(true);
 
             $objPHPExcel->getActiveSheet()->getStyle('A16:N16')->getAlignment()->setHorizontal('center');
             $objPHPExcel->getActiveSheet()->getStyle('A17:N17')->getAlignment()->setHorizontal('center');
 
             $objPHPExcel->getActiveSheet()->getStyle('F24:F27')->getAlignment()->setHorizontal('right');
             //merge cell
             $objPHPExcel->getActiveSheet()->mergeCells('A1:N1');
             $objPHPExcel->getActiveSheet()->mergeCells('A2:N2');
             $objPHPExcel->getActiveSheet()->mergeCells('A3:N3');
             $objPHPExcel->getActiveSheet()->mergeCells('A4:N4');
             $objPHPExcel->getActiveSheet()->mergeCells('A6:N6');
             $objPHPExcel->getActiveSheet()->mergeCells('A8:B8');
             $objPHPExcel->getActiveSheet()->mergeCells('M7:N7');
             $objPHPExcel->getActiveSheet()->mergeCells('D8:G13');
             $objPHPExcel->getActiveSheet()->mergeCells('M8:N8');
             $objPHPExcel->getActiveSheet()->mergeCells('D9:G9');
             $objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
             $objPHPExcel->getActiveSheet()->mergeCells('D11:F11');
             $objPHPExcel->getActiveSheet()->mergeCells('A13:B13');
             $objPHPExcel->getActiveSheet()->mergeCells('D8:H13');
             $objPHPExcel->getActiveSheet()->mergeCells('A20:C20');
             $objPHPExcel->getActiveSheet()->mergeCells('A22:C22');
 
             $objPHPExcel->getActiveSheet()->mergeCells('A19:C19');
             $objPHPExcel->getActiveSheet()->mergeCells('A20:C20');
             $objPHPExcel->getActiveSheet()->mergeCells('A21:C21');
             $objPHPExcel->getActiveSheet()->mergeCells('A22:C22');
             $objPHPExcel->getActiveSheet()->mergeCells('A23:C23');
             $objPHPExcel->getActiveSheet()->mergeCells('A24:C24');
             $objPHPExcel->getActiveSheet()->mergeCells('A25:C25');
             $objPHPExcel->getActiveSheet()->mergeCells('A26:B26');
             $objPHPExcel->getActiveSheet()->mergeCells('A28:C28');
 
             $objPHPExcel->getActiveSheet()->mergeCells('D19:E19');
             $objPHPExcel->getActiveSheet()->mergeCells('D20:E20');
             $objPHPExcel->getActiveSheet()->mergeCells('D21:E21');
             $objPHPExcel->getActiveSheet()->mergeCells('D22:E22');
             $objPHPExcel->getActiveSheet()->mergeCells('D23:E23');
             $objPHPExcel->getActiveSheet()->mergeCells('D24:E24');
             $objPHPExcel->getActiveSheet()->mergeCells('D25:E25');
             $objPHPExcel->getActiveSheet()->mergeCells('D26:E26');
 
             $objPHPExcel->getActiveSheet()->mergeCells('F24:G24');
             $objPHPExcel->getActiveSheet()->mergeCells('F25:G25');
             $objPHPExcel->getActiveSheet()->mergeCells('F26:G26');
 
             $objPHPExcel->getActiveSheet()->mergeCells('H25:H25');
             $objPHPExcel->getActiveSheet()->mergeCells('H26:H26');
             $objPHPExcel->getActiveSheet()->mergeCells('H24:I24');
             //set label to cell
             $objPHPExcel->getActiveSheet()->setCellValue('A1', 'SILMI Japan Co., Ltd.')
                                           ->setCellValue('A2', '3-6-28, Miyanosaka, Hirakata, Osaka, Japan')
                                           ->setCellValue('A3', 'PHONE: +81-72-392-4971')
                                           ->setCellValue('A4', ' EMAIL: jack@silmijapan.com')
                                           ->setCellValue('A6', 'I N V O I C E')
                                           ->setCellValue('M7', date("Y-m-d"))
                                           ->setCellValue('M8', $invoice_no_inst)
                                           ->setCellValue('J7', 'DATE:')
                                           ->setCellValue('J8', 'INV NO')
                                           ->setCellValue('A8', 'SOLD TO:')
                                         ->setCellValue('D8', 'NIGATAKE ENTERPRISES LTDA SANTA ROSA DE HUARA MZ D,'."\n".' SITIO 32, LOCAL 8, ZOFRI-IQUIQUE'."\n".'TEL: (PH) 0056-57-2417102 (EMAIL) SERENA2363@YAHOO.ES'."\n".'(RUT) 78.746.580-3')
                                           ->setCellValue('A14', 'FINAL DESTINATION')
                                           ->setCellValue('D14', "IQUIQUE,CHILE")
                                           ->setCellValue('A16', 'NO')
                                           ->setCellValue('B16', 'YEAR')
                                           ->setCellValue('C16', 'MAKER')
                                           ->setCellValue('D16', 'NAME')
                                           ->setCellValue('E16', 'CHASSIS NO')
                                           ->setCellValue('F16', 'WEIGHT')
                                           ->setCellValue('G16', 'LENGTH')
                                           ->setCellValue('H16', 'WIDTH')
                                           ->setCellValue('I16', 'HEIGHT')
                                           ->setCellValue('J16', 'MEAS')
                                           ->setCellValue('K16', 'DISP')
                                           ->setCellValue('L16', 'FUEL')
                                           ->setCellValue('M16', 'SEAT')
                                           ->setCellValue('N16', 'CIF')
                                           ->setCellValue('A17', '1')
                                           ->setCellValue('B17', $modelYear)
                                           ->setCellValue('C17', $dataRow->car_make_name)
                                           ->setCellValue('D17', $dataRow->car_model_name)
                                           ->setCellValue('E17', $dataRow->chassis_number)
                                           ->setCellValue('F17', $dataRow->car_weight)
                                           ->setCellValue('G17', $dataRow->car_length)
                                           ->setCellValue('H17', $dataRow->car_width)
                                           ->setCellValue('I17', $dataRow->car_height)
                                           ->setCellValue('J17', '=(G17*H17*I17)/1000000')
                                           ->setCellValue('K17', $dataRow->engine_size)
                                           ->setCellValue('L17', $fuel)
                                           ->setCellValue('M17', $dataRow->seats)
                                           ->setCellValue('N17', $total_sold_price)
 
                                           ->setCellValue('A19', 'SHIPPING FROM :')
                                           ->setCellValue('A20', 'SHIPPED TO :')
                                           ->setCellValue('A21', 'SHIPPED PER :')
                                           ->setCellValue('A22', 'VOY :')
                                           ->setCellValue('A23', 'SHIPPED ON :')
                                           ->setCellValue('A24', 'BOOKING :')
                                           ->setCellValue('A25', 'SHIPPING COMPANY')
                                           ->setCellValue('A26', 'PAYMENT')
                                           ->setCellValue('A28', 'SILMI JAPAN CO., LTD.')
 
                                           ->setCellValue('F24', 'FREIGHT:')
                                           ->setCellValue('F25', 'B/L ISSUE BY:')
                                           ->setCellValue('F26', 'B/L')
                                           ->setCellValue('H24', 'PREPAID AS ARRANGED')
                                           ->setCellValue('H25', $dataRow->bl_issue_by)
                                           ->setCellValue('H26', 'ORIGINAL 3')
 
                                           ->setCellValue('L19', 'MARKS & NO.S')
                                           ->setCellValue('L20', 'SILMI JAPAN CO., LTD')
                                           ->setCellValue('L21', "IQUIQUE")
 
                                           ->setCellValue('D19', $dataRow->port_of_loading_name)
                                           ->setCellValue('D20', "IQUIQUE")
                                           ->setCellValue('D21', $dataRow->vessel_name)
                                           ->setCellValue('D22', $dataRow->voyage_no)
                                           ->setCellValue('D23', $dataRow->etd)
                                           ->setCellValue('D24', $dataRow->booking)
                                           ->setCellValue('D25', $arr_shipping_com[$dataRow->shipping_co_id])
                                           ->setCellValue('D26', 'T/T REMITTANCE');
 
             // Number Format
             $objPHPExcel->getActiveSheet()->getStyle('J17')->getNumberFormat()->setFormatCode('0.000');
 
             //font bold 
             $bold = array(
                 'font'  => array(
                     'bold'  => true,
                         'color' => array('rgb' => '000000'),
                     'name'  => 'Microsoft Sans Serif'
                 )
             );
             //font italic
             $italic = array(
                 'font'  => array(
                     'italic'  => true,
                 )
             );
         
             //font size 14
             $font14 = array(
                 'font'  => array(
                     'size'  => 14,
                 )
             );
             //font size 12
             $font12 = array(
                 'font'  => array(
                     'size'  => 12,
                 )
             );
             //font size 24
             $font24 = array(
                 'font'  => array(
                     'size'  => 24,
                 )
             );
             //font size 22
             $font22 = array(
                 'font'  => array(
                     'size'  => 22,
                 )
             );
             //font size 22
             $font9 = array(
                 'font'  => array(
                     'size'  => 9,
                 )
             );
             //font famili Time New Roman
             $time_new_toman = array(
                 'font'  => array(
                     'name'  => 'Microsoft Sans Serif'
                 )
             );
             //text align center
             $align_center = array(
                 'alignment' => array(
                     'horizontal' =>  \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                 )
             );
             //text align left
             $align_left = array(
                 'alignment' => array(
                     'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                 )
             );
             $align_right = array(
                 'alignment' => array(
                     'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                 )
             );
             $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($align_center);
             $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($bold);
             $objPHPExcel->getActiveSheet()->getStyle('A:O')->applyFromArray($time_new_toman);
            
             $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($font12);
             $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($align_center);
             $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($bold);
             $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($font12);
             // //create new line in cell B55                             
            //  $objDrawing = new PHPExcel_Worksheet_MemoryDrawing();
            //  $objDrawing->setName('ru');
            //  $objDrawing->setDescription('ru-japan');
            //  // $objDrawing->setImageResource($gdImage);
            //  $objDrawing->setRenderingFunction(PHPExcel_Worksheet_MemoryDrawing::RENDERING_PNG);
            //  $objDrawing->setMimeType(PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_DEFAULT);
            //  $objDrawing->setHeight(100);
            //  $objDrawing->setCoordinates('B2');
            //  $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());
 
             //get data from db to cell
             
             
             //wrap text
             $objPHPExcel->getActiveSheet()->getStyle('E13:I18')->getAlignment()->setWrapText(true); 
 
             if($dataRow->consignee_name!=''){
                 $objWorkSheet->setCellValue('C61',  'Name : '.'consignee_name')
                              ->setCellValue('C63',  'Phone : '.'consignee_phone')
                              ->setCellValue('C65',  'Address : '.'consignee_address');
             
             }
             $car_width  = $dataRow->car_width / 100;
             $car_length = $dataRow->car_length / 100;
             $car_height = $dataRow->car_height / 100;
             $car_meas = $car_width * $car_length * $car_height;
                                  
 
             $index++;
             $num_sheet++;
         }
 
         $objPHPExcel->setActiveSheetIndex(1);

         $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="invoice_'.$ship_invoice.'.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        return response()->json([
            $writer->save('php://output')
        ]);
    }

    public function shipping_invoice_chile( $ship_invoice ){
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/shipping_invoice_chile_.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
        $data = Shipping_model::get_shipment_excel($ship_invoice);

        $insert_row_count1 = 0;
        $total_fobRow = 20;

        $baseRow = 18;
    
        $total =0;
        $cif_total =0;
        $shipping_company = Shipping_model::get_shipping_company();
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list( $user->staff_id );
        $discharges = Shipping_model::get_discharge($hide_pakistan);
        $port_of_loading = Shipping_model::get_port_of_loading();
        $arr_shipping_com = array();
        $arr_portloading = array();
        foreach ($shipping_company as $value) {
            $arr_shipping_com[$value->shipping_co_id]= $value->shipping_co_name;
        }
        foreach ($port_of_loading as $val1) {
            $arr_portloading[$val1->port_of_loading_id]= $val1->port_of_loading_name;
        }

         // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Invoice');

        $objPHPExcel->setActiveSheetIndex(0);
        $i = 0;
        $total_meas = 0;
        $total_weights = 0;
        $grand_total = 0;
        $invoice_no = "";
        
        foreach($data as $r => $dataRow) {
            
            $modelYear = $dataRow->car_model_year;
            $fuel = "";
            $i += 1;
            $row = $baseRow + $r;
            $invoice_no = $dataRow->shipping_invoice_code; 
            $cc = $dataRow->engine_size;
            $meas = ($dataRow->car_length * $dataRow->car_width * $dataRow->car_height)/ 1000000;
            $total_meas += $meas;
            $total_weights += $dataRow->car_weight;
            $total_sold_price = $dataRow->fob + $dataRow->freight_fee + $dataRow->inspection + $dataRow->insurance - (float)$dataRow->discount; 
            $grand_total += $total_sold_price;
            if($dataRow->car_fuel == "Petrol"){
                $fuel = "G";
            }elseif($dataRow->car_fuel == "Diesel"){
                $fuel = "D";
            }elseif($dataRow->car_fuel == "LPG"){
                $fuel = "LPG";
            }elseif($dataRow->car_fuel == "LPG_Pertrol"){
                $fuel = "L+G";
            }elseif($dataRow->car_fuel == "Hybrid"){
                $fuel = "H";
            }
            $objPHPExcel->getActiveSheet()->insertNewRowBefore($row,1);


            $objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $i)
                    ->setCellValue('B'.$row, $modelYear)
                    ->setCellValue('C'.$row, $dataRow->car_make_name)
                    ->setCellValue('D'.$row, $dataRow->car_model_name)
                    ->setCellValue('E'.$row, $dataRow->chassis_number)
                    ->setCellValue('F'.$row, $dataRow->car_weight)
                    ->setCellValue('G'.$row, $dataRow->car_length)
                    ->setCellValue('H'.$row, $dataRow->car_width)
                    ->setCellValue('I'.$row, $dataRow->car_height)
                    ->setCellValue('J'.$row, '=+(G'.$row.'*H'.$row.'*I'.$row.')/1000000')
                    ->setCellValue('K'.$row, $dataRow->engine_size)
                    ->setCellValue('L'.$row, $fuel)
                    ->setCellValue('M'.$row, $dataRow->seats)
                    ->setCellValue('N'.$row, $total_sold_price);
        // Number Format
        $objPHPExcel->getActiveSheet()->getStyle('J'.$row)->getNumberFormat()->setFormatCode('0.000');
            
        }
        $r18 = 17+ $i;
        $r20 = 19+ $i;
        $r21 = 20+ $i;
        $r22 = 21+ $i;
        $r23 = 22+ $i;
        $r24 = 23+ $i;
        $r25 = 24+ $i;
        $r26 = 25+ $i;
        $r27 = 26+ $i;

        $sumr= $r18-1;
        $objPHPExcel->getActiveSheet()->removeRow($baseRow-1,1);
        // Number Format
        $objPHPExcel->getActiveSheet()->getStyle('I'.$r18)->getNumberFormat()->setFormatCode('0.000');
        $objPHPExcel->getActiveSheet()->setCellValue('C'.$r18, $i)
                                        ->setCellValue('E'.$r18, '=+SUM(F17:F'.$sumr.')')
                                        ->setCellValue('J'.$r18, '=+SUM(J17:J'.$sumr.')')
                                        ->setCellValue('N'.$r18, $grand_total)
                                        ->setCellValue('H'.$r26, $dataRow->bl_issue_by)
                                        ->setCellValue('H'.$r25, 'PREPAID AS ARRANGED')
                                        ->setCellValue('L'.$r22, "IQUIQUE")
                                        ->setCellValue('D'.$r26, $arr_shipping_com[$dataRow->shipping_co_id])
                                        ->setCellValue('D'.$r25, $dataRow->booking)
                                        ->setCellValue('D'.$r24, $dataRow->etd)
                                        ->setCellValue('D'.$r23, $dataRow->voyage_no)
                                        ->setCellValue('D'.$r20, $dataRow->port_of_loading_name)
                                        ->setCellValue('D'.$r22, $dataRow->vessel_name)
                                        ->setCellValue('D'.$r21, "IQUIQUE");
     
        $objPHPExcel->getActiveSheet()->setCellValue('D14', "IQUIQUE,CHILE")
                                        ->setCellValue('M7', date("Y-m-d"))
                                        ->setCellValue('M8', $invoice_no);  

    // Sencond Sheet create //
        $objPHPExcel->setActiveSheetIndex(1);
        $objPHPExcel->getActiveSheet()->setTitle('INST');
                               
        $baseRow_inst = 27;
        $broombaseRow_inst = $baseRow_inst + 1;

        $total = 0;
        $full_length = 0;
        $full_width = 0;
        $full_height = 0;
        $full_weight = 0;
        $j = 0;
        $total_meas_inst = 0;
        $total_weights_inst = 0;
        $invoice_no_inst = "";
        $count_row = count($data) + $broombaseRow_inst; 
        foreach($data as $r => $dataRow) {
            $fuel = "";
            $j += 1;
            if($j == 1){
                $invoice_no_inst = $dataRow->shipping_invoice_code;
            }
            $row = $baseRow_inst + $r;
            $row2 = $row + $r + 3;
            $cc = $dataRow->engine_size;
            $meas_ins = ($dataRow->car_length * $dataRow->car_width * $dataRow->car_height)/ 1000000;
            $total_meas_inst += $meas_ins;
            $total_weights_inst += $dataRow->car_weight;
            $objPHPExcel->getActiveSheet()->insertNewRowBefore($row,1);
            $objPHPExcel->getActiveSheet()->mergeCells('D'.$row.':J'.$row);

            $objPHPExcel->getActiveSheet()->setCellValue('D'.$row, $dataRow->car_make_name." ".$dataRow->car_model_name." YEAR ".$dataRow->car_model_year." CHASSIS NO: ".$dataRow->chassis_number." (".$dataRow->car_length."*".$dataRow->car_width."*".$dataRow->car_height.")")
            ->setCellValue('K'.$row, $dataRow->car_length)
            ->setCellValue('L'.$row, $dataRow->car_width)
            ->setCellValue('M'.$row, $dataRow->car_height)
            ->setCellValue('N'.$row, $meas_ins)
            ->setCellValue('O'.$row, $dataRow->car_weight);                             
        }

        $r26 = 27+ ($j);
        $r27 = 28-1+ ($j);
        $r28 = 29+ ($j);
        $r29 = 30+ ($j);
        $r30 = 31+ ($j);
        $r31 = 32+ ($j);
        $r32 = 33+ ($j);
        $r33 = 34+ ($j);
        $r34 = 35+ ($j);

        $align_right = array(
            'alignment' => array(
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
            )
        );
        $objPHPExcel->getActiveSheet()->getStyle('M'.$r27)->applyFromArray($align_right);
        $objPHPExcel->getActiveSheet()->getStyle('N'.$r27)->applyFromArray($align_right);
        $objPHPExcel->getActiveSheet()->getStyle('O'.$r27)->applyFromArray($align_right);
        
        $objPHPExcel->getActiveSheet()->setCellValue('D22', "IQUIQUE")
                                        ->setCellValue('M7', date("Y-m-d"))
                                        ->setCellValue('M8', $invoice_no_inst)
                                        ->setCellValue('D20', "SAME AS CONSIGNEE");
                                       

        $objPHPExcel->getActiveSheet()->setCellValue('M'.$r27,'TOTAL')
                                        ->setCellValue('N'.$r27,'=TEXT('.$total_meas_inst.',"0.000")')
                                        ->setCellValue('O'.$r27,  $total_weights_inst) 
                                        ->setCellValue('H'.$r30,$dataRow->bl_issue_by)
                                        ->setCellValue('H'.$r29, "PREPAID AS ARRANGED")
                                        ->setCellValue('K'.$r30, "IQUIQUE")
                                        ->setCellValue('D'.$r34, $arr_shipping_com[$dataRow->shipping_co_id])
                                        ->setCellValue('D'.$r33, $dataRow->booking)
                                        ->setCellValue('D'.$r32, $dataRow->etd)
                                        ->setCellValue('D'.$r31, $dataRow->voyage_no)
                                        ->setCellValue('D'.$r28, $dataRow->port_of_loading_name)
                                        ->setCellValue('D'.$r30, $dataRow->vessel_name)
                                        ->setCellValue('D'.$r29, "IQUIQUE");

        

        $objPHPExcel->getActiveSheet()->removeRow($baseRow_inst-1,1);
        $objPHPExcel->getActiveSheet()->removeRow($count_row-1,1);

        $objPHPExcel->setActiveSheetIndex(1);

        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="invoice_'.$ship_invoice.'.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        return response()->json([
            $writer->save('php://output')
        ]);

    }

    public function shipping_invoice_cambodia_seperate( $ship_invoice ){
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/SI_CAMBODIA_SETPARATE.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
        $data = Shipping_model::get_shipment_excel($ship_invoice);

        $des = count($data)." UNITS OF USED CARS";

        $insert_row_count1 = 0;
        $total_fobRow = 20;

        $baseRow = 18;
    
        $total =0;
        $cif_total =0;
        $shipping_company = Shipping_model::get_shipping_company();
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list( $user->staff_id );
        $discharges = Shipping_model::get_discharge($hide_pakistan);
        $port_of_loading = Shipping_model::get_port_of_loading();
        $arr_shipping_com = array();
        $arr_portloading = array();
        foreach ($shipping_company as $value) {
            $arr_shipping_com[$value->shipping_co_id]= $value->shipping_co_name;
        }
        foreach ($port_of_loading as $val1) {
            $arr_portloading[$val1->port_of_loading_id]= $val1->port_of_loading_name;
        }

         // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Invoice');

        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getSheetByName('Invoice')
        ->setSheetState(\PhpOffice\PhpSpreadsheet\Worksheet\Worksheet::SHEETSTATE_VERYHIDDEN);
        
        $i = 0;
        $total_meas = 0;
        $total_weights = 0;
        $grand_total = 0;
        $invoice_no = "";
        $index = 0;
        $j=0;
        $num_sheet = 1;
        $broombaseRow_inst = 24;
        foreach($data as $key => $dataRow) { 
            $fuel ='';
            $j += 1;
            if($j == 1){
                $invoice_no_inst = $dataRow->shipping_invoice_code;
            }
            $cc = $dataRow->engine_size;
            if( $dataRow->engine_size <= '10'){
                $cc = $dataRow->engine_size * 1000;
            }
            if($dataRow->car_fuel == "Petrol"){
                $fuel = "G";
            }elseif($dataRow->car_fuel == "Diesel"){
                $fuel = "D";
            }elseif($dataRow->car_fuel == "LPG"){
                $fuel = "LPG";
            }elseif($dataRow->car_fuel == "LPG_Pertrol"){
                $fuel = "L+G";
            }elseif($dataRow->car_fuel == "Hybrid"){
                $fuel = "H";
            }
            $total_sold_price = $dataRow->fob + $dataRow->freight_fee + $dataRow->inspection + $dataRow->insurance - (float)$dataRow->discount; 
            $grand_total += $total_sold_price;
            $invoice_no = $dataRow->shipping_invoice_code; 
            $next_sheets  = 1 + $index;
            $objWorkSheet = $objPHPExcel->createSheet($next_sheets);
            $objWorkSheet->setTitle("$num_sheet");
            $objPHPExcel->setActiveSheetIndex($next_sheets);
            // start design excel
            //set column width
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(6);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(6);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(6);
            //set border thick aound
            $border_left_thick= array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            $border_top_thick= array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            //block border thin
            $border_top_thin= array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_left_thin= array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_bottom_thin= array(
                'borders' => array(
                    'bottom' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $objPHPExcel->getActiveSheet()
            ->getStyle('E6')
            ->getAlignment()
            ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $objPHPExcel->getActiveSheet()->getStyle("K32:N32")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("K36:N36")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("K32:K35")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("O32:O35")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('M7')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('D13')->getAlignment()->setWrapText(true);
            //merge cell
            $objPHPExcel->getActiveSheet()->mergeCells('A1:N1');
            $objPHPExcel->getActiveSheet()->mergeCells('A2:N2');
            $objPHPExcel->getActiveSheet()->mergeCells('A3:N3');
            $objPHPExcel->getActiveSheet()->mergeCells('A4:N4');
            $objPHPExcel->getActiveSheet()->mergeCells('A6:N6');
            $objPHPExcel->getActiveSheet()->mergeCells('A8:B8');
            $objPHPExcel->getActiveSheet()->mergeCells('M7:N7');
            $objPHPExcel->getActiveSheet()->mergeCells('D8:F8');
            $objPHPExcel->getActiveSheet()->mergeCells('M8:N8');
            $objPHPExcel->getActiveSheet()->mergeCells('D9:G9');
            $objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
            $objPHPExcel->getActiveSheet()->mergeCells('D11:F11');
            $objPHPExcel->getActiveSheet()->mergeCells('A13:B13');
            $objPHPExcel->getActiveSheet()->mergeCells('D13:H17');
            $objPHPExcel->getActiveSheet()->mergeCells('A20:C20');
            $objPHPExcel->getActiveSheet()->mergeCells('D20:M20');
            $objPHPExcel->getActiveSheet()->mergeCells('A22:C22');

            $objPHPExcel->getActiveSheet()->mergeCells('D22:F22');
            $objPHPExcel->getActiveSheet()->mergeCells('D24:F24');
            $objPHPExcel->getActiveSheet()->mergeCells('A25:B25');
            $objPHPExcel->getActiveSheet()->mergeCells('D25:F25');
            $objPHPExcel->getActiveSheet()->mergeCells('D26:L26');
            $objPHPExcel->getActiveSheet()->mergeCells('A31:C31');
            $objPHPExcel->getActiveSheet()->mergeCells('A32:C32');
            $objPHPExcel->getActiveSheet()->mergeCells('A33:C33');
            $objPHPExcel->getActiveSheet()->mergeCells('A34:C34');
            $objPHPExcel->getActiveSheet()->mergeCells('A35:C35');
            $objPHPExcel->getActiveSheet()->mergeCells('A36:C36');
            $objPHPExcel->getActiveSheet()->mergeCells('A37:C37');
            $objPHPExcel->getActiveSheet()->mergeCells('A38:C38');
            $objPHPExcel->getActiveSheet()->mergeCells('A39:C39');

            $objPHPExcel->getActiveSheet()->mergeCells('K32:N32');
            $objPHPExcel->getActiveSheet()->mergeCells('K33:N33');
            $objPHPExcel->getActiveSheet()->mergeCells('K34:N34');
            $objPHPExcel->getActiveSheet()->mergeCells('K35:N35');

            $objPHPExcel->getActiveSheet()->mergeCells('D31:F31');
            $objPHPExcel->getActiveSheet()->mergeCells('D32:F32');
            $objPHPExcel->getActiveSheet()->mergeCells('D33:F33');
            $objPHPExcel->getActiveSheet()->mergeCells('D34:F34');
            $objPHPExcel->getActiveSheet()->mergeCells('D35:F35');
            $objPHPExcel->getActiveSheet()->mergeCells('D36:F36');
            $objPHPExcel->getActiveSheet()->mergeCells('D37:F37');

            //set label to cell
            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'SILMI Japan Co., Ltd.')
                                          ->setCellValue('A2', '3-6-28, Miyanosaka, Hirakata-city,')
                                          ->setCellValue('A3', ' Osaka, Japan')
                                          ->setCellValue('A4', 'PHONE: +81-72-392-4971')
                                          ->setCellValue('A6', 'SHIPPING INSTRUCTION')
                                          ->setCellValue('M7', date("Y-m-d"))
                                          ->setCellValue('M8', $invoice_no_inst)
                                          ->setCellValue('J7', 'DATE:')
                                          ->setCellValue('J8', 'INV NO')
                                          ->setCellValue('A8', 'SHIPPER:')
                                          ->setCellValue('D8', 'SILMI JAPAN CO., LTD.')
                                          ->setCellValue('D9', '3-6-28 Miyanosaka, Hirakata, Osaka, JAPAN')
                                          ->setCellValue('D10', 'PHONE: +81-72-392-4971')
                                          ->setCellValue('D11', 'EMAIL: jack@silmijapan.com')
                                          ->setCellValue('D24', '1 CONTAINER SAID TO CONTAIN')
                                          ->setCellValue('D25', '1 UNITS OF USED CARS')
                                          ->setCellValue('A13', 'CONSIGNEE :')
                                          ->setCellValue('D13', $dataRow->con_name."\n".$dataRow->con_add."\nTEL: ".$dataRow->con_phone."\n".$dataRow->con_other_info)
                                          ->setCellValue('A20', 'NOTIFY PARTY :')
                                          ->setCellValue('D20', $dataRow->notify_party)
                                          ->setCellValue('A22', 'FINAL DESTINATION :')
                                          ->setCellValue('D22', $dataRow->final_des_name)
                                          ->setCellValue('D24', '1 CONTAINER SAID TO CONTAIN')
                                          ->setCellValue('D25', '4 UNITS OF USED CARS')
                                          ->setCellValue('D26', "BRAND : ". $dataRow->car_make_name." ".$dataRow->car_model_name." ENGINE :".$cc."CC"." ".$dataRow->drive_type." LEFT HAND DRIVE"." CHASSIS NO : ".$dataRow->chassis_number." ")
                                          ->setCellValue('A31', 'SHIPPING FROM :')
                                          ->setCellValue('A32', 'SHIPPED TO :')
                                          ->setCellValue('A33', 'SHIPPED PER :')
                                          ->setCellValue('A34', 'VOY :')
                                          ->setCellValue('A35', 'SHIPPED ON :')
                                          ->setCellValue('A36', 'BOOKING :')
                                          ->setCellValue('A37', 'SHIPPING COMPANY :')
                                          ->setCellValue('A39', 'SILMI JAPAN CO., LTD.')
                                          ->setCellValue('G31', 'FREIGHT :')
                                          ->setCellValue('G32', 'B/L ISSUE BY :')
                                          ->setCellValue('G33', 'B/L')
                                          ->setCellValue('K31', 'MARKS & NO.S')
                                          ->setCellValue('K32', 'SILMI JAPAN CO., LTD.')
                                          ->setCellValue('K34',$dataRow->final_des_name)

                                          ->setCellValue('H31', 'PREPAID AS ARRANGED')
                                          ->setCellValue('H32', $dataRow->bl_issue_by)
                                          ->setCellValue('H33', 'COPY 1')
                                          ->setCellValue('D31', $dataRow->port_of_loading_name)
                                          ->setCellValue('D32', $dataRow->final_des_name)
                                          ->setCellValue('D33', $dataRow->vessel_name)
                                          ->setCellValue('D34', $dataRow->voyage_no)
                                          ->setCellValue('D35', $dataRow->etd)
                                          ->setCellValue('D36', $dataRow->booking)
                                          ->setCellValue('D37', $arr_shipping_com[$dataRow->shipping_co_id]);
                                          
            //font bold 
            $bold = array(
                'font'  => array(
                    'bold'  => true,
                        'color' => array('rgb' => '000000'),
                    'name'  => 'Microsoft Sans Serif'
                )
            );
            //font bold 
            $bold_normal = array(
                'font'  => array(
                    'bold'  => false,
                        'color' => array('rgb' => '000000'),
                    'name'  => 'Hiragino Mincho ProN'
                )
            );
            //font italic
            $italic = array(
                'font'  => array(
                    'italic'  => true,
                )
            );
        
            //font size 14
            $font14 = array(
                'font'  => array(
                    'size'  => 14,
                )
            );
            //font size 12
            $font12 = array(
                'font'  => array(
                    'size'  => 12,
                )
            );
            //font size 24
            $font24 = array(
                'font'  => array(
                    'size'  => 24,
                )
            );
            //font size 22
            $font22 = array(
                'font'  => array(
                    'size'  => 22,
                )
            );
            //font size 22
            $font9 = array(
                'font'  => array(
                    'size'  => 9,
                )
            );
            //font famili Time New Roman
            $time_new_toman = array(
                'font'  => array(
                    'name'  => 'Microsoft Sans Serif'
                )
            );
            //text align center
            $align_center = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                )
            );
            //text align left
            $align_left = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                )
            );
            $align_right = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($bold);
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($font12);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($bold);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($font12);
          
            // $objDrawing = new PHPExcel_Worksheet_MemoryDrawing();
            // $objDrawing->setName('ru');
            // $objDrawing->setDescription('ru-japan');
            // // $objDrawing->setImageResource($gdImage);
            // $objDrawing->setRenderingFunction(PHPExcel_Worksheet_MemoryDrawing::RENDERING_PNG);
            // $objDrawing->setMimeType(PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_DEFAULT);
            // $objDrawing->setHeight(100);
            // $objDrawing->setCoordinates('B2');
            // $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

            //get data from db to cell
            
            
            //wrap text
            $objPHPExcel->getActiveSheet()->getStyle('E13:I18')->getAlignment()->setWrapText(true); 

            if($dataRow->consignee_name!=''){
                $objWorkSheet->setCellValue('C61',  'Name : '.'consignee_name')
                             ->setCellValue('C63',  'Phone : '.'consignee_phone')
                             ->setCellValue('C65',  'Address : '.'consignee_address');
            
            }
            $car_width  = $dataRow->car_width / 100;
            $car_length = $dataRow->car_length / 100;
            $car_height = $dataRow->car_height / 100;
            $car_meas = $car_width * $car_length * $car_height;
                                 

            $index++;
            $num_sheet++;
        }

        $objPHPExcel->setActiveSheetIndex(0);
      
        $index = 0;
        $num_sheet = 1;
        $broombaseRow_inst = 24;
        foreach($data as $key => $dataRow) { 
            
            $modelYear = $dataRow->car_model_year;
            $invoice_no = $dataRow->shipping_invoice_code; 
            $next_sheets  = 1 + $index;
            $objWorkSheet = $objPHPExcel->createSheet($next_sheets);
            $objWorkSheet->setTitle("Inv $num_sheet");
            $objPHPExcel->setActiveSheetIndex($next_sheets);
            //set column width
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(6);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(6);
            //set border thick aound
            $border_left_thick= array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            $border_top_thick= array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            //block border thin
            $border_top_thin= array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_left_thin= array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_bottom_thin= array(
                'borders' => array(
                    'bottom' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $objPHPExcel->getActiveSheet()
            ->getStyle('E6')
            ->getAlignment()
            ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $objPHPExcel->getActiveSheet()->getStyle("L20:O20")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("L24:O24")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("L20:L23")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("P20:P23")->applyFromArray($border_left_thin);

            $objPHPExcel->getActiveSheet()->getStyle("A16:N16")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("A17:N17")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("A18:N18")->applyFromArray($border_top_thin);

            $objPHPExcel->getActiveSheet()->getStyle("A16:A17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("B16:B17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("C16:C17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("D16:D17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("E16:E17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("F16:F17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("G16:G17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("H16:H17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("I16:I17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("J16:J17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("K16:K17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("L16:L17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("M16:M17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("N16:N17")->applyFromArray($border_left_thin);

            $objPHPExcel->getActiveSheet()->getStyle("O16:O17")->applyFromArray($border_left_thin);

            $objPHPExcel->getActiveSheet()->getStyle('A6')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('M7')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('D8')->getAlignment()->setWrapText(true);

            $objPHPExcel->getActiveSheet()->getStyle('A16:N16')->getAlignment()->setHorizontal('center');
            $objPHPExcel->getActiveSheet()->getStyle('A17:N17')->getAlignment()->setHorizontal('center');

            $objPHPExcel->getActiveSheet()->getStyle('F24:F27')->getAlignment()->setHorizontal('right');
            //merge cell
            $objPHPExcel->getActiveSheet()->mergeCells('A1:N1');
            $objPHPExcel->getActiveSheet()->mergeCells('A2:N2');
            $objPHPExcel->getActiveSheet()->mergeCells('A3:N3');
            $objPHPExcel->getActiveSheet()->mergeCells('A4:N4');
            $objPHPExcel->getActiveSheet()->mergeCells('A6:N6');
            $objPHPExcel->getActiveSheet()->mergeCells('A8:B8');
            $objPHPExcel->getActiveSheet()->mergeCells('M7:N7');
            $objPHPExcel->getActiveSheet()->mergeCells('D8:F8');
            $objPHPExcel->getActiveSheet()->mergeCells('M8:N8');
            $objPHPExcel->getActiveSheet()->mergeCells('D9:G9');
            $objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
            $objPHPExcel->getActiveSheet()->mergeCells('D11:F11');
            $objPHPExcel->getActiveSheet()->mergeCells('A13:B13');
            $objPHPExcel->getActiveSheet()->mergeCells('D8:H13');
            $objPHPExcel->getActiveSheet()->mergeCells('A20:C20');
            $objPHPExcel->getActiveSheet()->mergeCells('A22:C22');

            $objPHPExcel->getActiveSheet()->mergeCells('A19:C19');
            $objPHPExcel->getActiveSheet()->mergeCells('A20:C20');
            $objPHPExcel->getActiveSheet()->mergeCells('A21:C21');
            $objPHPExcel->getActiveSheet()->mergeCells('A22:C22');
            $objPHPExcel->getActiveSheet()->mergeCells('A23:C23');
            $objPHPExcel->getActiveSheet()->mergeCells('A24:C24');
            $objPHPExcel->getActiveSheet()->mergeCells('A25:C25');
            $objPHPExcel->getActiveSheet()->mergeCells('A26:B26');
            $objPHPExcel->getActiveSheet()->mergeCells('A28:C28');

            $objPHPExcel->getActiveSheet()->mergeCells('D19:E19');
            $objPHPExcel->getActiveSheet()->mergeCells('D20:E20');
            $objPHPExcel->getActiveSheet()->mergeCells('D21:E21');
            $objPHPExcel->getActiveSheet()->mergeCells('D22:E22');
            $objPHPExcel->getActiveSheet()->mergeCells('D23:E23');
            $objPHPExcel->getActiveSheet()->mergeCells('D24:E24');
            $objPHPExcel->getActiveSheet()->mergeCells('D25:E25');
            $objPHPExcel->getActiveSheet()->mergeCells('D26:E26');

            $objPHPExcel->getActiveSheet()->mergeCells('F24:G24');
            $objPHPExcel->getActiveSheet()->mergeCells('F25:G25');
            $objPHPExcel->getActiveSheet()->mergeCells('F26:G26');

            $objPHPExcel->getActiveSheet()->mergeCells('H24:I24');
            $objPHPExcel->getActiveSheet()->mergeCells('H25:H25');
            $objPHPExcel->getActiveSheet()->mergeCells('H26:H26');
            //set label to cell
            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'SILMI Japan Co., Ltd.')
                                          ->setCellValue('A2', '3-6-28, Miyanosaka, Hirakata, Osaka, Japan')
                                          ->setCellValue('A3', 'PHONE: +81-72-392-4971')
                                          ->setCellValue('A4', ' EMAIL: jack@silmijapan.com')
                                          ->setCellValue('A6', 'I N V O I C E')
                                          ->setCellValue('M7', date("Y-m-d"))
                                          ->setCellValue('M8', $invoice_no_inst)
                                          ->setCellValue('J7', 'DATE:')
                                          ->setCellValue('J8', 'INV NO')
                                          ->setCellValue('A8', 'SOLD TO:')
                                          ->setCellValue('D8', $dataRow->con_name."\n".$dataRow->con_add."\nTEL: ".$dataRow->con_phone."\n".$dataRow->con_other_info)
                                          ->setCellValue('A14', 'FINAL DESTINATION')
                                          ->setCellValue('D14', $dataRow->final_des_name)
                                          ->setCellValue('A16', 'NO')
                                          ->setCellValue('B16', 'YEAR  ')
                                          ->setCellValue('C16', 'MAKER')
                                          ->setCellValue('D16', 'NAME')
                                          ->setCellValue('E16', 'CHASSIS NO')
                                          ->setCellValue('F16', 'WEIGHT')
                                          ->setCellValue('G16', 'LENGTH')
                                          ->setCellValue('H16', 'WIDTH')
                                          ->setCellValue('I16', 'HEIGHT')
                                          ->setCellValue('J16', 'MEAS')
                                          ->setCellValue('K16', 'DISP')
                                          ->setCellValue('L16', 'FUEL')
                                          ->setCellValue('M16', 'SEAT')
                                          ->setCellValue('N16', 'CIF')
                                          ->setCellValue('A17', '1')
                                          ->setCellValue('B17', $modelYear)
                                          ->setCellValue('C17', $dataRow->car_make_name)
                                          ->setCellValue('D17', $dataRow->car_model_name)
                                          ->setCellValue('E17', $dataRow->chassis_number)
                                          ->setCellValue('F17', $dataRow->car_weight)
                                          ->setCellValue('G17', $dataRow->car_length)
                                          ->setCellValue('H17', $dataRow->car_width)
                                          ->setCellValue('I17', $dataRow->car_height)
                                          ->setCellValue('J17', '=(G17*H17*I17)/1000000')
                                          ->setCellValue('K17', $dataRow->engine_size)
                                          ->setCellValue('L17', $fuel)
                                          ->setCellValue('M17', $dataRow->seats)
                                          ->setCellValue('N17', $total_sold_price)

                                          ->setCellValue('A19', 'SHIPPING FROM :')
                                          ->setCellValue('A20', 'SHIPPED TO :')
                                          ->setCellValue('A21', 'SHIPPED PER :')
                                          ->setCellValue('A22', 'VOY :')
                                          ->setCellValue('A23', 'SHIPPED ON :')
                                          ->setCellValue('A24', 'BOOKING :')
                                          ->setCellValue('A25', 'SHIPPING COMPANY')
                                          ->setCellValue('A26', 'PAYMENT')
                                          ->setCellValue('A28', 'SILMI JAPAN CO., LTD.')

                                          ->setCellValue('F24', 'FREIGHT:')
                                          ->setCellValue('F25', 'B/L ISSUE BY:')
                                          ->setCellValue('F26', 'B/L')
                                          ->setCellValue('H24', 'PREPAID AS ARRANGED')
                                          ->setCellValue('H25', $dataRow->bl_issue_by)
                                          ->setCellValue('H26', 'ORIGINAL 3')

                                          ->setCellValue('L19', 'MARKS & NO.S')
                                          ->setCellValue('L20', 'SILMI JAPAN CO., LTD')
                                          ->setCellValue('L21', $dataRow->final_des_name)

                                          ->setCellValue('D19', $dataRow->port_of_loading_name)
                                          ->setCellValue('D20', $dataRow->final_des_name)
                                          ->setCellValue('D21', $dataRow->vessel_name)
                                          ->setCellValue('D22', $dataRow->voyage_no)
                                          ->setCellValue('D23', $dataRow->etd)
                                          ->setCellValue('D24', $dataRow->booking)
                                          ->setCellValue('D25', $arr_shipping_com[$dataRow->shipping_co_id])
                                          ->setCellValue('D26', 'T/T REMITTANCE');
            //Number Format
            $objPHPExcel->getActiveSheet()->getStyle('J17')->getNumberFormat()->setFormatCode('0.000');
            //font bold 
            $bold = array(
                'font'  => array(
                    'bold'  => true,
                        'color' => array('rgb' => '000000'),
                    'name'  => 'Microsoft Sans Serif'
                )
            );
            //font italic
            $italic = array(
                'font'  => array(
                    'italic'  => true,
                )
            );
        
            //font size 14
            $font14 = array(
                'font'  => array(
                    'size'  => 14,
                )
            );
            //font size 12
            $font12 = array(
                'font'  => array(
                    'size'  => 12,
                )
            );
            //font size 24
            $font24 = array(
                'font'  => array(
                    'size'  => 24,
                )
            );
            //font size 22
            $font22 = array(
                'font'  => array(
                    'size'  => 22,
                )
            );
            //font size 22
            $font9 = array(
                'font'  => array(
                    'size'  => 9,
                )
            );
            //font famili Time New Roman
            $time_new_toman = array(
                'font'  => array(
                    'name'  => 'Microsoft Sans Serif'
                )
            );
            //text align center
            $align_center = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                )
            );
            //text align left
            $align_left = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                )
            );
            $align_right = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($bold);
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($font12);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($bold);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($font12);
        
            // $objDrawing = new PHPExcel_Worksheet_MemoryDrawing();
            // $objDrawing->setName('ru');
            // $objDrawing->setDescription('ru-japan');
            // // $objDrawing->setImageResource($gdImage);
            // $objDrawing->setRenderingFunction(PHPExcel_Worksheet_MemoryDrawing::RENDERING_PNG);
            // $objDrawing->setMimeType(PHPExcel_Worksheet_MemoryDrawing::MIMETYPE_DEFAULT);
            // $objDrawing->setHeight(100);
            // $objDrawing->setCoordinates('B2');
            // $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

            //wrap text
            $objPHPExcel->getActiveSheet()->getStyle('E13:I18')->getAlignment()->setWrapText(true); 

            if($dataRow->consignee_name!=''){
                $objWorkSheet->setCellValue('C61',  'Name : '.'consignee_name')
                             ->setCellValue('C63',  'Phone : '.'consignee_phone')
                             ->setCellValue('C65',  'Address : '.'consignee_address');
            
            }
            $car_width  = $dataRow->car_width / 100;
            $car_length = $dataRow->car_length / 100;
            $car_height = $dataRow->car_height / 100;
            $car_meas = $car_width * $car_length * $car_height;
                                 

            $index++;
            $num_sheet++;
        }

        $objPHPExcel->setActiveSheetIndex(1);

        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="invoice_'.$ship_invoice.'.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        return response()->json([
            $writer->save('php://output')
        ]);
    }

    public function shipping_invoice_cambodia_combined( $ship_invoice ){
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/SI_CAMBODIA_NEW.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
        $data = Shipping_model::get_shipment_excel($ship_invoice);

        $des = count($data)." UNITS OF USED CARS";

        $insert_row_count1 = 0;
        $total_fobRow = 20;

        $baseRow = 18;
    
        $total =0;
        $cif_total =0;
        $shipping_company = Shipping_model::get_shipping_company();
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list( $user->staff_id );
        $discharges =  Shipping_model::get_discharge($hide_pakistan);
        $port_of_loading = Shipping_model::get_port_of_loading();
        $arr_shipping_com = array();
        $arr_portloading = array();
        foreach ($shipping_company as $value) {
            $arr_shipping_com[$value->shipping_co_id]= $value->shipping_co_name;
        }
        foreach ($port_of_loading as $val1) {
            $arr_portloading[$val1->port_of_loading_id]= $val1->port_of_loading_name;
        }

         // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Invoice');

        $objPHPExcel->setActiveSheetIndex(0);
        $i = 0;
        $total_meas = 0;
        $total_weights = 0;
        $grand_total = 0;
        $invoice_no = "";
        
        foreach($data as $r => $dataRow) {

            $modelYear = $dataRow->car_model_year;
            $fuel = "";
            $i += 1;
            $row = $baseRow + $r;
            $invoice_no = $dataRow->shipping_invoice_code; 
            $cc = $dataRow->engine_size;
            $meas = ($dataRow->car_length * $dataRow->car_width * $dataRow->car_height)/ 1000000;
            $total_meas += $meas;
            $total_weights += $dataRow->car_weight;
            $total_sold_price = $dataRow->fob + $dataRow->freight_fee + $dataRow->inspection + $dataRow->insurance - (float)$dataRow->discount; 
            $grand_total += $total_sold_price;
            if($dataRow->car_fuel == "Petrol"){
                $fuel = "G";
            }elseif($dataRow->car_fuel == "Diesel"){
                $fuel = "D";
            }elseif($dataRow->car_fuel == "LPG"){
                $fuel = "LPG";
            }elseif($dataRow->car_fuel == "LPG_Pertrol"){
                $fuel = "L+G";
            }elseif($dataRow->car_fuel == "Hybrid"){
                $fuel = "H";
            }
            $objPHPExcel->getActiveSheet()->insertNewRowBefore($row,1);

            $objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $i)
                    ->setCellValue('B'.$row, $modelYear )
                    ->setCellValue('C'.$row, $dataRow->car_make_name)
                    ->setCellValue('D'.$row, $dataRow->car_model_name)
                    ->setCellValue('E'.$row, $dataRow->chassis_number)
                    ->setCellValue('F'.$row, $dataRow->car_weight)
                    ->setCellValue('G'.$row, $dataRow->car_length)
                    ->setCellValue('H'.$row, $dataRow->car_width)
                    ->setCellValue('J'.$row, '=(G'.$row.'*H'.$row.'*I'.$row.')/1000000')
                    ->setCellValue('K'.$row, $dataRow->engine_size)
                    ->setCellValue('L'.$row, $fuel)
                    ->setCellValue('M'.$row, $dataRow->seats)
                    ->setCellValue('N'.$row, $total_sold_price);

              $objPHPExcel->getActiveSheet()->getStyle('J'.$row)->getNumberFormat()->setFormatCode('0.000');
            
        }
        $r18 = 17+ $i;
        $r20 = 19+ $i;
        $r21 = 20+ $i;
        $r22 = 21+ $i;
        $r23 = 22+ $i;
        $r24 = 23+ $i;
        $r25 = 24+ $i;
        $r26 = 25+ $i;
        $r27 = 26+ $i;

        $sumr= $r18-1;

        $objPHPExcel->getActiveSheet()->removeRow($baseRow-1,1);

        $objPHPExcel->getActiveSheet()->setCellValue('C'.$r18, $i)
                                        ->setCellValue('E'.$r18, '=SUM(F17:F'.$sumr.')')
                                        ->setCellValue('J'.$r18, '=SUM(J17:J'.$sumr.')')
                                        ->setCellValue('N'.$r18, $grand_total)
                                        ->setCellValue('H'.$r26, $dataRow->bl_issue_by)
                                        ->setCellValue('H'.$r25, 'PREPAID AS ARRANGED')
                                        ->setCellValue('L'.$r22, $dataRow->final_des_name)
                                        ->setCellValue('D'.$r26, $arr_shipping_com[$dataRow->shipping_co_id])
                                        ->setCellValue('D'.$r25, $dataRow->booking)
                                        ->setCellValue('D'.$r24, $dataRow->etd)
                                        ->setCellValue('D'.$r23, $dataRow->voyage_no)
                                        ->setCellValue('D'.$r20, $dataRow->port_of_loading_name)
                                        ->setCellValue('D'.$r22, $dataRow->vessel_name)
                                        ->setCellValue('D'.$r21, $dataRow->final_des_name);
        $objPHPExcel->getActiveSheet()->setCellValue('D8', $dataRow->con_name."\n".$dataRow->con_add."\nTEL: ".$dataRow->con_phone."\n".$dataRow->con_other_info)
                                        ->setCellValue('D14', $dataRow->final_des_name)
                                        ->setCellValue('M7', date("Y-m-d"))
                                        ->setCellValue('M8', $invoice_no);
        $objPHPExcel->getActiveSheet()->getStyle('I'.$r18)->getNumberFormat()->setFormatCode('0.000');

    // Sencond Sheet create //
        $objPHPExcel->setActiveSheetIndex(1);
        $objPHPExcel->getActiveSheet()->setTitle('INST');
                               
        $baseRow_inst = 27;
        $broombaseRow_inst = $baseRow_inst + 1;

        $total = 0;
        $full_length = 0;
        $full_width = 0;
        $full_height = 0;
        $full_weight = 0;
        $j = 0;
        $total_meas_inst = 0;
        $total_weights_inst = 0;
        $invoice_no_inst = "";
        $count_row = count($data) + $broombaseRow_inst; 
        $note_spearpath = "";
        foreach($data as $r => $dataRow) {
            $note_spearpath = $dataRow->note_spearpath;
            $fuel = "";
            $j += 1;
            if($j == 1){
                $invoice_no_inst = $dataRow->shipping_invoice_code;
            }
            $row = $baseRow_inst + $r;
            $row2 = $row + $r + 3;
            $cc = $dataRow->engine_size;
            if( $cc <= '10' ){
                $cc = $dataRow->engine_size * 1000 ;
            }

            $meas_ins = ($dataRow->car_length * $dataRow->car_weight * $dataRow->car_height)/ 1000000;
            $total_meas_inst += $meas_ins;
            $total_weights_inst += $dataRow->car_weight;
            $objPHPExcel->getActiveSheet()->insertNewRowBefore($row,1);
            $objPHPExcel->getActiveSheet()->mergeCells('D'.$row.':L'.$row);

             $objPHPExcel->getActiveSheet()->setCellValue('D'.$row,"BRAND : ". $dataRow->car_make_name." ".$dataRow->car_model_name." ENGINE :".$cc."CC"." ".$dataRow->drive_type." LEFT HAND DRIVE"." CHASSIS NO : ".$dataRow->chassis_number." ");
                                    
        }
        $row_after = 29 + $j;
        $r26 = 26+ $j;
        $r27 = 27+ $j + 4;
        $r28 = 28+ $j + 4;
        $r29 = 29+ $j + 4;
        $r30 = 30+ $j + 4;
        $r31 = 31+ $j + 4;
        $r32 = 32+ $j + 4;
        $r33 = 33+ $j + 4;
        $r34 = 34+ $j + 4;
        $objPHPExcel->getActiveSheet()->mergeCells('D'.$row_after.':L'.$row_after);
        $objPHPExcel->getActiveSheet()->setCellValue('D'.$row_after, @$note_spearpath);
        $objPHPExcel->getActiveSheet()->setCellValue('D13', $dataRow->con_name."\n".$dataRow->con_add."\nTEL: ".$dataRow->con_phone."\n".$dataRow->con_other_info)
                                        ->setCellValue('D22', $dataRow->final_des_name)
                                        ->setCellValue('D25', $des)
                                        ->setCellValue('M7', date("Y-m-d"))
                                        ->setCellValue('M8', $invoice_no_inst)
                                        ->setCellValue('D20', $dataRow->notify_party);

        $objPHPExcel->getActiveSheet()  ->setCellValue('H'.$r29, $dataRow->bl_issue_by)
                                        ->setCellValue('H'.$r28, 'PREPAID AS ARRANGED')
                                        ->setCellValue('H'.$r30, 'COPY 3')
                                        ->setCellValue('K'.$r30, $dataRow->final_des_name)
                                        ->setCellValue('D'.$r34, $arr_shipping_com[$dataRow->shipping_co_id])
                                        ->setCellValue('D'.$r33, $dataRow->booking)
                                        ->setCellValue('D'.$r32, $dataRow->etd)
                                        ->setCellValue('D'.$r31, $dataRow->voyage_no)
                                        ->setCellValue('D'.$r28, $dataRow->port_of_loading_name)
                                        ->setCellValue('D'.$r30, $dataRow->vessel_name)
                                        ->setCellValue('D'.$r29, $dataRow->final_des_name);

        

        $objPHPExcel->getActiveSheet()->removeRow($baseRow_inst-1,1);
        $objPHPExcel->getActiveSheet()->removeRow($count_row-1,1);

        $objPHPExcel->setActiveSheetIndex(1);

        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="invoice_'.$ship_invoice.'.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        return response()->json([
            $writer->save('php://output')
        ]);
    }

    public function shipping_invoice_dominican_republic_seperated( $ship_invoice ){
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/SI_REPUBLIC_SEPERATED.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
        $data = Shipping_model::get_shipment_excel($ship_invoice);
        
        $des = count($data)." UNITS OF USED CARS";

        $insert_row_count1 = 0;
        $total_fobRow = 20;

        $baseRow = 18;
    
        $total =0;
        $cif_total =0;
        $shipping_company =  Shipping_model::get_shipping_company();
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list( $user->staff_id );
        $discharges =  Shipping_model::get_discharge($hide_pakistan);
        $port_of_loading =  Shipping_model::get_port_of_loading();
        $arr_shipping_com = array();
        $arr_portloading = array();
        foreach ($shipping_company as $value) {
            $arr_shipping_com[$value->shipping_co_id]= $value->shipping_co_name;
        }
        foreach ($port_of_loading as $val1) {
            $arr_portloading[$val1->port_of_loading_id]= $val1->port_of_loading_name;
        }

         // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Invoice');

        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getSheetByName('Invoice')
        ->setSheetState(\PhpOffice\PhpSpreadsheet\Worksheet\Worksheet::SHEETSTATE_VERYHIDDEN);
        
        $i = 0;
        $total_meas = 0;
        $total_weights = 0;
        $grand_total = 0;
        $invoice_no = "";
        $index = 0;
        $j=0;
        $num_sheet = 1;
        $broombaseRow_inst = 24;
        foreach($data as $key => $dataRow) { 
            $fuel ='';
            $j += 1;
            if($j == 1){
                $invoice_no_inst = $dataRow->shipping_invoice_code;
            }
            $cc = $dataRow->engine_size;
            if( $dataRow->engine_size <= '10'){
                $cc = $dataRow->engine_size * 1000;
            }
            if($dataRow->car_fuel == "Petrol"){
                $fuel = "G";
            }elseif($dataRow->car_fuel == "Diesel"){
                $fuel = "D";
            }elseif($dataRow->car_fuel == "LPG"){
                $fuel = "LPG";
            }elseif($dataRow->car_fuel == "LPG_Pertrol"){
                $fuel = "L+G";
            }elseif($dataRow->car_fuel == "Hybrid"){
                $fuel = "H";
            }
            $total_sold_price = $dataRow->fob + $dataRow->freight_fee + $dataRow->inspection + $dataRow->insurance - (float)$dataRow->discount; 
            $grand_total += $total_sold_price;
            $invoice_no = $dataRow->shipping_invoice_code; 
            $next_sheets  = 1 + $index;
            $objWorkSheet = $objPHPExcel->createSheet($next_sheets);
            $objWorkSheet->setTitle("$num_sheet");
            $objPHPExcel->setActiveSheetIndex($next_sheets);
            // start design excel
            //set column width
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(6);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(6);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setWidth(16);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(6);
            //set border thick aound
            $border_left_thick= array(
                'borders' => array(
                    'left' => array(
                        'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            $border_top_thick= array(
                'borders' => array(
                    'top' => array(
                        'style' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            //block border thin
            $border_top_thin= array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_left_thin= array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_bottom_thin= array(
                'borders' => array(
                    'bottom' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $objPHPExcel->getActiveSheet()
            ->getStyle('E6')
            ->getAlignment()
            ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $objPHPExcel->getActiveSheet()->getStyle("K32:N32")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("K36:N36")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("K32:K35")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("O32:O35")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('M7')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('D13')->getAlignment()->setWrapText(true);
            //merge cell
            $objPHPExcel->getActiveSheet()->mergeCells('A1:N1');
            $objPHPExcel->getActiveSheet()->mergeCells('A2:N2');
            $objPHPExcel->getActiveSheet()->mergeCells('A3:N3');
            $objPHPExcel->getActiveSheet()->mergeCells('A4:N4');
            $objPHPExcel->getActiveSheet()->mergeCells('A6:N6');
            $objPHPExcel->getActiveSheet()->mergeCells('A8:B8');
            $objPHPExcel->getActiveSheet()->mergeCells('M7:N7');
            $objPHPExcel->getActiveSheet()->mergeCells('D8:F8');
            $objPHPExcel->getActiveSheet()->mergeCells('M8:N8');
            $objPHPExcel->getActiveSheet()->mergeCells('D9:G9');
            $objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
            $objPHPExcel->getActiveSheet()->mergeCells('D11:F11');
            $objPHPExcel->getActiveSheet()->mergeCells('A13:B13');
            $objPHPExcel->getActiveSheet()->mergeCells('D13:H17');
            $objPHPExcel->getActiveSheet()->mergeCells('A20:C20');
            $objPHPExcel->getActiveSheet()->mergeCells('D20:M20');
            $objPHPExcel->getActiveSheet()->mergeCells('A22:C22');

            $objPHPExcel->getActiveSheet()->mergeCells('D22:F22');
            $objPHPExcel->getActiveSheet()->mergeCells('D24:F24');
            $objPHPExcel->getActiveSheet()->mergeCells('A25:B25');
            $objPHPExcel->getActiveSheet()->mergeCells('D25:F25');
            $objPHPExcel->getActiveSheet()->mergeCells('D26:N26');
            $objPHPExcel->getActiveSheet()->mergeCells('A31:C31');
            $objPHPExcel->getActiveSheet()->mergeCells('A32:C32');
            $objPHPExcel->getActiveSheet()->mergeCells('A33:C33');
            $objPHPExcel->getActiveSheet()->mergeCells('A34:C34');
            $objPHPExcel->getActiveSheet()->mergeCells('A35:C35');
            $objPHPExcel->getActiveSheet()->mergeCells('A36:C36');
            $objPHPExcel->getActiveSheet()->mergeCells('A37:C37');
            $objPHPExcel->getActiveSheet()->mergeCells('A38:C38');
            $objPHPExcel->getActiveSheet()->mergeCells('A39:C39');

            $objPHPExcel->getActiveSheet()->mergeCells('K32:N32');
            $objPHPExcel->getActiveSheet()->mergeCells('K33:N33');
            $objPHPExcel->getActiveSheet()->mergeCells('K34:N34');
            $objPHPExcel->getActiveSheet()->mergeCells('K35:N35');

            $objPHPExcel->getActiveSheet()->mergeCells('D31:F31');
            $objPHPExcel->getActiveSheet()->mergeCells('D32:F32');
            $objPHPExcel->getActiveSheet()->mergeCells('D33:F33');
            $objPHPExcel->getActiveSheet()->mergeCells('D34:F34');
            $objPHPExcel->getActiveSheet()->mergeCells('D35:F35');
            $objPHPExcel->getActiveSheet()->mergeCells('D36:F36');
            $objPHPExcel->getActiveSheet()->mergeCells('D37:F37');

            //set label to cell
            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'SILMI Japan Co., Ltd.')
                                          ->setCellValue('A2', '3-6-28, Miyanosaka, Hirakata-city,')
                                          ->setCellValue('A3', ' Osaka, Japan')
                                          ->setCellValue('A4', 'PHONE: +81-72-392-4971')
                                          ->setCellValue('A6', 'SHIPPING INSTRUCTION')
                                          ->setCellValue('M7', date("Y-m-d"))
                                          ->setCellValue('M8', $invoice_no_inst)
                                          ->setCellValue('J7', 'DATE:')
                                          ->setCellValue('J8', 'INV NO')
                                          ->setCellValue('A8', 'SHIPPER:')
                                          ->setCellValue('D8', 'SILMI JAPAN CO., LTD.')
                                          ->setCellValue('D9', '3-6-28 Miyanosaka, Hirakata, Osaka, JAPAN')
                                          ->setCellValue('D10', 'PHONE: +81-72-392-4971')
                                          ->setCellValue('D11', 'EMAIL: jack@silmijapan.com')
                                          ->setCellValue('D25', '1 UNITS OF USED CARS')
                                          ->setCellValue('A13', 'CONSIGNEE :')
                                          ->setCellValue('D13', $dataRow->con_name."\n".$dataRow->con_other_info."\n".$dataRow->con_add."\nTEL: ".$dataRow->con_phone)
                                          ->setCellValue('A20', 'NOTIFY PARTY :')
                                          ->setCellValue('D20', $dataRow->notify_party)
                                          ->setCellValue('A22', 'FINAL DESTINATION :')
                                          ->setCellValue('D22', $dataRow->final_des_name)
                                          ->setCellValue('D25', '4 UNITS OF USED CARS')
                                          ->setCellValue('D26', $dataRow->car_make_name." ".$dataRow->car_model_name." ".$cc."CC"." ".$dataRow->drive_type." LEFT HAND DRIVE"." CHASSIS NO : ".$dataRow->chassis_number." YEAR : ".$dataRow->car_model_year." COLOR : ".$dataRow->color_name." ")
                                          ->setCellValue('A31', 'SHIPPING FROM :')
                                          ->setCellValue('A32', 'SHIPPED TO :')
                                          ->setCellValue('A33', 'SHIPPED PER :')
                                          ->setCellValue('A34', 'VOY :')
                                          ->setCellValue('A35', 'SHIPPED ON :')
                                          ->setCellValue('A36', 'BOOKING :')
                                          ->setCellValue('A37', 'SHIPPING COMPANY :')
                                          ->setCellValue('A39', 'SILMI JAPAN CO., LTD.')
                                          ->setCellValue('G31', 'FREIGHT :')
                                          ->setCellValue('G32', 'B/L ISSUE BY :')
                                          ->setCellValue('G33', 'B/L')
                                          ->setCellValue('K31', 'MARKS & NO.S')
                                          ->setCellValue('K32', 'SILMI JAPAN CO., LTD.')
                                          ->setCellValue('K33',$dataRow->final_des_name)

                                          ->setCellValue('H31', 'PREPAID AS ARRANGED')
                                          ->setCellValue('H32', $dataRow->bl_issue_by)
                                          ->setCellValue('H33', 'COPY 1')
                                          ->setCellValue('D31', $dataRow->port_of_loading_name)
                                          ->setCellValue('D32', $dataRow->final_des_name)
                                          ->setCellValue('D33', $dataRow->vessel_name)
                                          ->setCellValue('D34', $dataRow->voyage_no)
                                          ->setCellValue('D35', $dataRow->etd)
                                          ->setCellValue('D36', $dataRow->booking)
                                          ->setCellValue('D37', $arr_shipping_com[$dataRow->shipping_co_id]);
                                          
            //font bold 
            $bold = array(
                'font'  => array(
                    'bold'  => true,
                        'color' => array('rgb' => '000000'),
                    'name'  => 'Microsoft Sans Serif'
                )
            );
            //font italic
            $italic = array(
                'font'  => array(
                    'italic'  => true,
                )
            );
        
            //font size 14
            $font14 = array(
                'font'  => array(
                    'size'  => 14,
                )
            );
            //font size 12
            $font12 = array(
                'font'  => array(
                    'size'  => 12,
                )
            );
            //font size 24
            $font24 = array(
                'font'  => array(
                    'size'  => 24,
                )
            );
            //font size 22
            $font22 = array(
                'font'  => array(
                    'size'  => 22,
                )
            );
            //font size 22
            $font9 = array(
                'font'  => array(
                    'size'  => 9,
                )
            );
            //font famili Time New Roman
            $time_new_toman = array(
                'font'  => array(
                    'name'  => 'Microsoft Sans Serif'
                )
            );
            //text align center
            $align_center = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                )
            );
            //text align left
            $align_left = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                )
            );
            $align_right = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($bold);
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($font12);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($bold);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($font12);

            //wrap text
            $objPHPExcel->getActiveSheet()->getStyle('E13:I18')->getAlignment()->setWrapText(true); 

            if($dataRow->consignee_name!=''){
                $objWorkSheet->setCellValue('C61',  'Name : '.'consignee_name')
                             ->setCellValue('C63',  'Phone : '.'consignee_phone')
                             ->setCellValue('C65',  'Address : '.'consignee_address');
            
            }
            $car_width  = $dataRow->car_width / 100;
            $car_length = $dataRow->car_length / 100;
            $car_height = $dataRow->car_height / 100;
            $car_meas = $car_width * $car_length * $car_height;
                                 

            $index++;
            $num_sheet++;
        }

        $objPHPExcel->setActiveSheetIndex(0);
      
        $index = 0;
        $num_sheet = 1;
        $broombaseRow_inst = 24;
        foreach($data as $key => $dataRow) { 
            
            $modelYear = $dataRow->car_model_year;
            $invoice_no = $dataRow->shipping_invoice_code; 
            $next_sheets  = 1 + $index;
            $objWorkSheet = $objPHPExcel->createSheet($next_sheets);
            $objWorkSheet->setTitle("Inv $num_sheet");
            $objPHPExcel->setActiveSheetIndex($next_sheets);
            // start design excel
            //set column width
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(6);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(6);
            //set border thick aound
            $border_left_thick= array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            $border_top_thick= array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            //block border thin
            $border_top_thin= array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_left_thin= array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_bottom_thin= array(
                'borders' => array(
                    'bottom' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN,'color' => array('rgb' => '00000'),
                    )
                )
            );
            $objPHPExcel->getActiveSheet()
            ->getStyle('E6')
            ->getAlignment()
            ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $objPHPExcel->getActiveSheet()->getStyle("L20:O20")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("L24:O24")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("L20:L23")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("P20:P23")->applyFromArray($border_left_thin);

            $objPHPExcel->getActiveSheet()->getStyle("A16:N16")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("A17:N17")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("A18:N18")->applyFromArray($border_top_thin);

            $objPHPExcel->getActiveSheet()->getStyle("A16:A17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("B16:B17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("C16:C17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("D16:D17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("E16:E17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("F16:F17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("G16:G17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("H16:H17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("I16:I17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("J16:J17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("K16:K17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("L16:L17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("M16:M17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("N16:N17")->applyFromArray($border_left_thin);

            $objPHPExcel->getActiveSheet()->getStyle("O16:O17")->applyFromArray($border_left_thin);

            $objPHPExcel->getActiveSheet()->getStyle('A6')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('M7')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('D8')->getAlignment()->setWrapText(true);

            $objPHPExcel->getActiveSheet()->getStyle('A16:N16')->getAlignment()->setHorizontal('center');
            $objPHPExcel->getActiveSheet()->getStyle('A17:N17')->getAlignment()->setHorizontal('center');

            $objPHPExcel->getActiveSheet()->getStyle('F24:F27')->getAlignment()->setHorizontal('right');
            //merge cell
            $objPHPExcel->getActiveSheet()->mergeCells('A1:N1');
            $objPHPExcel->getActiveSheet()->mergeCells('A2:N2');
            $objPHPExcel->getActiveSheet()->mergeCells('A3:N3');
            $objPHPExcel->getActiveSheet()->mergeCells('A4:N4');
            $objPHPExcel->getActiveSheet()->mergeCells('A6:N6');
            $objPHPExcel->getActiveSheet()->mergeCells('A8:B8');
            $objPHPExcel->getActiveSheet()->mergeCells('M7:N7');
            $objPHPExcel->getActiveSheet()->mergeCells('M8:N8');
            $objPHPExcel->getActiveSheet()->mergeCells('D8:H13');
            $objPHPExcel->getActiveSheet()->mergeCells('D9:G9');
            $objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
            $objPHPExcel->getActiveSheet()->mergeCells('D11:F11');
            $objPHPExcel->getActiveSheet()->mergeCells('A13:B13');
            
            $objPHPExcel->getActiveSheet()->mergeCells('A20:C20');
            $objPHPExcel->getActiveSheet()->mergeCells('A22:C22');

            $objPHPExcel->getActiveSheet()->mergeCells('A19:C19');
            $objPHPExcel->getActiveSheet()->mergeCells('A20:C20');
            $objPHPExcel->getActiveSheet()->mergeCells('A21:C21');
            $objPHPExcel->getActiveSheet()->mergeCells('A22:C22');
            $objPHPExcel->getActiveSheet()->mergeCells('A23:C23');
            $objPHPExcel->getActiveSheet()->mergeCells('A24:C24');
            $objPHPExcel->getActiveSheet()->mergeCells('A25:C25');
            $objPHPExcel->getActiveSheet()->mergeCells('A26:B26');
            $objPHPExcel->getActiveSheet()->mergeCells('A28:C28');

            $objPHPExcel->getActiveSheet()->mergeCells('D19:E19');
            $objPHPExcel->getActiveSheet()->mergeCells('D20:E20');
            $objPHPExcel->getActiveSheet()->mergeCells('D21:E21');
            $objPHPExcel->getActiveSheet()->mergeCells('D22:E22');
            $objPHPExcel->getActiveSheet()->mergeCells('D23:E23');
            $objPHPExcel->getActiveSheet()->mergeCells('D24:E24');
            $objPHPExcel->getActiveSheet()->mergeCells('D25:E25');
            $objPHPExcel->getActiveSheet()->mergeCells('D26:E26');

            $objPHPExcel->getActiveSheet()->mergeCells('F24:G24');
            $objPHPExcel->getActiveSheet()->mergeCells('F25:G25');
            $objPHPExcel->getActiveSheet()->mergeCells('F26:G26');

            $objPHPExcel->getActiveSheet()->mergeCells('H24:I24');
            $objPHPExcel->getActiveSheet()->mergeCells('H25:H25');
            $objPHPExcel->getActiveSheet()->mergeCells('H26:H26');
            //set label to cell
            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'SILMI Japan Co., Ltd.')
                                          ->setCellValue('A2', '3-6-28, Miyanosaka, Hirakata, Osaka, Japan')
                                          ->setCellValue('A3', 'PHONE: +81-72-392-4971')
                                          ->setCellValue('A4', ' EMAIL: jack@silmijapan.com')
                                          ->setCellValue('A6', 'I N V O I C E')
                                          ->setCellValue('M7', date("Y-m-d"))
                                          ->setCellValue('M8', $invoice_no_inst)
                                          ->setCellValue('J7', 'DATE:')
                                          ->setCellValue('J8', 'INV NO')
                                          ->setCellValue('A8', 'SOLD TO:')
                                          ->setCellValue('D8', $dataRow->con_name."\n".$dataRow->con_other_info."\n".$dataRow->con_add."\nTEL: ".$dataRow->con_phone)
                                          ->setCellValue('A14', 'FINAL DESTINATION')
                                          ->setCellValue('D14', $dataRow->final_des_name)
                                          ->setCellValue('A16', 'NO')
                                          ->setCellValue('B16', 'YEAR  ')
                                          ->setCellValue('C16', 'MAKER')
                                          ->setCellValue('D16', 'NAME')
                                          ->setCellValue('E16', 'CHASSIS NO')
                                          ->setCellValue('F16', 'WEIGHT')
                                          ->setCellValue('G16', 'LENGTH')
                                          ->setCellValue('H16', 'WIDTH')
                                          ->setCellValue('I16', 'HEIGHT')
                                          ->setCellValue('J16', 'MEAS')
                                          ->setCellValue('K16', 'DISP')
                                          ->setCellValue('L16', 'FUEL')
                                          ->setCellValue('M16', 'SEAT')
                                          ->setCellValue('N16', 'CIF')
                                          ->setCellValue('A17', '1')
                                          ->setCellValue('B17', $modelYear)
                                          ->setCellValue('C17', $dataRow->car_make_name)
                                          ->setCellValue('D17', $dataRow->car_model_name)
                                          ->setCellValue('E17', $dataRow->chassis_number)
                                          ->setCellValue('F17', $dataRow->car_weight)
                                          ->setCellValue('G17', $dataRow->car_length)
                                          ->setCellValue('H17', $dataRow->car_width)
                                          ->setCellValue('I17', $dataRow->car_height)
                                          ->setCellValue('J17', '=(G17*H17*I17)/1000000')
                                          ->setCellValue('K17', $dataRow->engine_size)
                                          ->setCellValue('L17', $fuel)
                                          ->setCellValue('M17', $dataRow->seats)
                                          ->setCellValue('N17', $total_sold_price)

                                          ->setCellValue('A19', 'SHIPPING FROM :')
                                          ->setCellValue('A20', 'SHIPPED TO :')
                                          ->setCellValue('A21', 'SHIPPED PER :')
                                          ->setCellValue('A22', 'VOY :')
                                          ->setCellValue('A23', 'SHIPPED ON :')
                                          ->setCellValue('A24', 'BOOKING :')
                                          ->setCellValue('A25', 'SHIPPING COMPANY')
                                          ->setCellValue('A26', 'PAYMENT')
                                          ->setCellValue('A28', 'SILMI JAPAN CO., LTD.')

                                          ->setCellValue('F24', 'FREIGHT:')
                                          ->setCellValue('F25', 'B/L ISSUE BY:')
                                          ->setCellValue('F26', 'B/L')
                                          ->setCellValue('H24', 'PREPAID AS ARRANGED')
                                          ->setCellValue('H25', $dataRow->bl_issue_by)
                                          ->setCellValue('H26', 'ORIGINAL 3')

                                          ->setCellValue('L19', 'MARKS & NO.S')
                                          ->setCellValue('L20', 'SILMI JAPAN CO., LTD')
                                          ->setCellValue('L21', $dataRow->final_des_name)

                                          ->setCellValue('D19', $dataRow->port_of_loading_name)
                                          ->setCellValue('D20', $dataRow->final_des_name)
                                          ->setCellValue('D21', $dataRow->vessel_name)
                                          ->setCellValue('D22', $dataRow->voyage_no)
                                          ->setCellValue('D23', $dataRow->etd)
                                          ->setCellValue('D24', $dataRow->booking)
                                          ->setCellValue('D25', $arr_shipping_com[$dataRow->shipping_co_id])
                                          ->setCellValue('D26', 'T/T REMITTANCE');
            //Number Format
            $objPHPExcel->getActiveSheet()->getStyle('J17')->getNumberFormat()->setFormatCode('0.000');
            //font bold 
            $bold = array(
                'font'  => array(
                    'bold'  => true,
                        'color' => array('rgb' => '000000'),
                    'name'  => 'Microsoft Sans Serif'
                )
            );
            //font italic
            $italic = array(
                'font'  => array(
                    'italic'  => true,
                )
            );
        
            //font size 14
            $font14 = array(
                'font'  => array(
                    'size'  => 14,
                )
            );
            //font size 12
            $font12 = array(
                'font'  => array(
                    'size'  => 12,
                )
            );
            //font size 24
            $font24 = array(
                'font'  => array(
                    'size'  => 24,
                )
            );
            //font size 22
            $font22 = array(
                'font'  => array(
                    'size'  => 22,
                )
            );
            //font size 22
            $font9 = array(
                'font'  => array(
                    'size'  => 9,
                )
            );
            //font famili Time New Roman
            $time_new_toman = array(
                'font'  => array(
                    'name'  => 'Microsoft Sans Serif'
                )
            );
            //text align center
            $align_center = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                )
            );
            //text align left
            $align_left = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                )
            );
            $align_right = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($bold);
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($font12);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($bold);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($font12);
            
            //wrap text
            $objPHPExcel->getActiveSheet()->getStyle('E13:I18')->getAlignment()->setWrapText(true); 

            if($dataRow->consignee_name!=''){
                $objWorkSheet->setCellValue('C61',  'Name : '.'consignee_name')
                             ->setCellValue('C63',  'Phone : '.'consignee_phone')
                             ->setCellValue('C65',  'Address : '.'consignee_address');
            
            }
            $car_width  = $dataRow->car_width / 100;
            $car_length = $dataRow->car_length / 100;
            $car_height = $dataRow->car_height / 100;
            $car_meas = $car_width * $car_length * $car_height;
                                 

            $index++;
            $num_sheet++;
        }

        $objPHPExcel->setActiveSheetIndex(1);  
        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="invoice_'.$ship_invoice.'.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        return response()->json([
            $writer->save('php://output')
        ]);
    }

    public function shipping_invoice_dominican_republic( $ship_invoice ){
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/SI_REPUBLIC_new.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
        $data = Shipping_model::get_shipment_excel($ship_invoice);
        
        $des = count($data)." UNITS OF USED CARS";

        $insert_row_count1 = 0;
        $total_fobRow = 20;

        $baseRow = 18;
    
        $total =0;
        $cif_total =0;
        $shipping_company = Shipping_model::get_shipping_company();
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list( $user->staff_id );
        $discharges = Shipping_model::get_discharge($hide_pakistan);
        $port_of_loading = Shipping_model::get_port_of_loading();
        $arr_shipping_com = array();
        $arr_portloading = array();
        foreach ($shipping_company as $value) {
            $arr_shipping_com[$value->shipping_co_id]= $value->shipping_co_name;
        }
        foreach ($port_of_loading as $val1) {
            $arr_portloading[$val1->port_of_loading_id]= $val1->port_of_loading_name;
        }

         // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Invoice');

        $objPHPExcel->setActiveSheetIndex(0);
        $i = 0;
        $total_meas = 0;
        $total_weights = 0;
        $grand_total = 0;
        $invoice_no = "";
        
        foreach($data as $r => $dataRow) {

            $modelYear = $dataRow->car_model_year;
            $fuel = "";
            $i += 1;
            $row = $baseRow + $r;
            $invoice_no = $dataRow->shipping_invoice_code; 
            $cc = $dataRow->engine_size;
            $meas = ($dataRow->car_length * $dataRow->car_width * $dataRow->car_height)/ 1000000;
            $total_meas += $meas;
            $total_weights += $dataRow->car_weight;
            $total_sold_price = $dataRow->fob + $dataRow->freight_fee + $dataRow->inspection + $dataRow->insurance - (float)$dataRow->discount; 
            $grand_total += $total_sold_price;
            if($dataRow->car_fuel == "Petrol"){
                $fuel = "G";
            }elseif($dataRow->car_fuel == "Diesel"){
                $fuel = "D";
            }elseif($dataRow->car_fuel == "LPG"){
                $fuel = "LPG";
            }elseif($dataRow->car_fuel == "LPG_Pertrol"){
                $fuel = "L+G";
            }elseif($dataRow->car_fuel == "Hybrid"){
                $fuel = "H";
            }
            $objPHPExcel->getActiveSheet()->insertNewRowBefore($row,1);

            $objPHPExcel->getActiveSheet()->setCellValue('A'.$row, $i)
                    ->setCellValue('B'.$row, $modelYear )
                    ->setCellValue('C'.$row, $dataRow->car_make_name)
                    ->setCellValue('D'.$row, $dataRow->car_model_name)
                    ->setCellValue('E'.$row, $dataRow->chassis_number)
                    ->setCellValue('F'.$row, $dataRow->car_weight)
                    ->setCellValue('G'.$row, $dataRow->car_length)
                    ->setCellValue('H'.$row, $dataRow->car_width)
                    ->setCellValue('I'.$row, $dataRow->car_height)
                    // ->setCellValue('J'.$row, $meas)
                    ->setCellValue('J'.$row, '=(G'.$row.'*H'.$row.'*I'.$row.')/1000000')
                    ->setCellValue('K'.$row, $dataRow->engine_size)
                    ->setCellValue('L'.$row, $fuel)
                    ->setCellValue('M'.$row, $dataRow->seats)
                    ->setCellValue('N'.$row, $total_sold_price);

                //$total_unit = $total_unit + 1;
              $objPHPExcel->getActiveSheet()->getStyle('J'.$row)->getNumberFormat()->setFormatCode('0.000');
            
        }
        $r18 = 17+ $i;
        $r20 = 19+ $i;
        $r21 = 20+ $i;
        $r22 = 21+ $i;
        $r23 = 22+ $i;
        $r24 = 23+ $i;
        $r25 = 24+ $i;
        $r26 = 25+ $i;
        $r27 = 26+ $i;

        $sumr= $r18-1;

        $objPHPExcel->getActiveSheet()->removeRow($baseRow-1,1);

        $objPHPExcel->getActiveSheet()->setCellValue('C'.$r18, $i)
                                        ->setCellValue('E'.$r18, '=SUM(F17:F'.$sumr.')')
                                        ->setCellValue('J'.$r18, '=SUM(J17:J'.$sumr.')')
                                        ->setCellValue('N'.$r18, $grand_total)
                                        ->setCellValue('H'.$r26, $dataRow->bl_issue_by)
                                        ->setCellValue('H'.$r25, 'PREPAID AS ARRANGED')
                                        ->setCellValue('L'.$r22, 'CAUCEDO, DOMINICAN REPUBLIC')
                                        ->setCellValue('D'.$r26, $arr_shipping_com[$dataRow->shipping_co_id])
                                        ->setCellValue('D'.$r25, $dataRow->booking)
                                        ->setCellValue('D'.$r24, $dataRow->etd)
                                        ->setCellValue('D'.$r23, $dataRow->voyage_no)
                                        ->setCellValue('D'.$r20, $dataRow->port_of_loading_name)
                                        ->setCellValue('D'.$r22, $dataRow->vessel_name)
                                        ->setCellValue('D'.$r21, 'CAUCEDO, DOMINICAN REPUBLIC');
        $objPHPExcel->getActiveSheet()->setCellValue('D8', $dataRow->con_name."\n".$dataRow->con_other_info."\n".$dataRow->con_add."\nTEL: ".$dataRow->con_phone)
                                        ->setCellValue('D14', 'CAUCEDO, DOMINICAN REPUBLIC')
                                        ->setCellValue('M7', date("Y-m-d"))
                                        ->setCellValue('M8', $invoice_no);
        $objPHPExcel->getActiveSheet()->getStyle('I'.$r18)->getNumberFormat()->setFormatCode('0.000');    

       // Sencond Sheet create //
        $objPHPExcel->setActiveSheetIndex(1);
        $objPHPExcel->getActiveSheet()->setTitle('INST');
                               
        $baseRow_inst = 27;
        $broombaseRow_inst = $baseRow_inst + 1;

        $total = 0;
        $full_length = 0;
        $full_width = 0;
        $full_height = 0;
        $full_weight = 0;
        $j = 0;
        $total_meas_inst = 0;
        $total_weights_inst = 0;
        $invoice_no_inst = "";
        $count_row = count($data) + $broombaseRow_inst; 
        $note_spearpath = "";
        foreach($data as $r => $dataRow) {
            $note_spearpath = $dataRow->note_spearpath;
            $fuel = "";
            $j += 1;
            if($j == 1){
                $invoice_no_inst = $dataRow->shipping_invoice_code;
            }
            $row = $baseRow_inst + $r;
            $row2 = $row + $r + 3;
            $cc = $dataRow->engine_size;
            if( $cc <= '10' ){
                $cc = $dataRow->engine_size * 1000 ;
            }

            $meas_ins = ($dataRow->car_length * $dataRow->car_weight * $dataRow->car_height)/ 1000000;
            $total_meas_inst += $meas_ins;
            $total_weights_inst += $dataRow->car_weight;
            $objPHPExcel->getActiveSheet()->insertNewRowBefore($row,1);
            $objPHPExcel->getActiveSheet()->mergeCells('D'.$row.':N'.$row);

            $objPHPExcel->getActiveSheet()->setCellValue('D'.$row," ". $dataRow->car_make_name." ".$dataRow->car_model_name." ".$cc."CC"." ".$dataRow->drive_type." LEFT HAND DRIVE"." CHASSIS NO : ".$dataRow->chassis_number." YEAR : ".$dataRow->car_model_year." COLOR : ".$dataRow->color_name." ");
        }
        $row_after = 29 + $j;
        $r26 = 26+ $j;
        $r27 = 27+ $j + 4;
        $r28 = 28+ $j + 4;
        $r29 = 29+ $j + 4;
        $r30 = 30+ $j + 4;
        $r31 = 31+ $j + 4;
        $r32 = 32+ $j + 4;
        $r33 = 33+ $j + 4;
        $r34 = 34+ $j + 4;
        $objPHPExcel->getActiveSheet()->mergeCells('D'.$row_after.':L'.$row_after);
        $objPHPExcel->getActiveSheet()->setCellValue('D'.$row_after, @$note_spearpath);
        $objPHPExcel->getActiveSheet()->setCellValue('D13', $dataRow->con_name."\n".$dataRow->con_other_info."\n".$dataRow->con_add."\nTEL: ".$dataRow->con_phone)
                                        ->setCellValue('D22', 'CAUCEDO, DOMINICAN REPUBLIC')
                                        ->setCellValue('D25', $des)
                                        ->setCellValue('M7', date("Y-m-d"))
                                        ->setCellValue('M8', $invoice_no_inst)
                                        ->setCellValue('D20', $dataRow->notify_party);

        $objPHPExcel->getActiveSheet()  ->setCellValue('H'.$r29, $dataRow->bl_issue_by)
                                        ->setCellValue('H'.$r28, 'CAUCEDO, DOMINICAN REPUBLIC')
                                        ->setCellValue('H'.$r30, 'COPY 3')
                                        ->setCellValue('K'.$r30, 'CAUCEDO, DOMINICAN REPUBLIC')
                                        ->setCellValue('D'.$r34, $arr_shipping_com[$dataRow->shipping_co_id])
                                        ->setCellValue('D'.$r33, $dataRow->booking)
                                        ->setCellValue('D'.$r32, $dataRow->etd)
                                        ->setCellValue('D'.$r31, $dataRow->voyage_no)
                                        ->setCellValue('D'.$r28, $dataRow->port_of_loading_name)
                                        ->setCellValue('D'.$r30, $dataRow->vessel_name)
                                        ->setCellValue('D'.$r29, 'CAUCEDO, DOMINICAN REPUBLIC');


        $objPHPExcel->getActiveSheet()->removeRow($baseRow_inst-1,1);
        $objPHPExcel->getActiveSheet()->removeRow($count_row-1,1);

        $objPHPExcel->setActiveSheetIndex(1);

        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="invoice_'.$ship_invoice.'.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        return response()->json([
            $writer->save('php://output')
        ]);
    }

    public function shipping_invoice_dubai_seperate( $ship_invoice ){
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/shipping_invoice_dubai_separate_new.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
        $data = Shipping_model::get_shipment_excel($ship_invoice);

        $des = count($data) . " UNITS OF USED CARS";

        $insert_row_count1 = 0;
        $total_fobRow = 20;

        $baseRow = 18;

        $total = 0;
        $cif_total = 0;
        $shipping_company = Shipping_model::get_shipping_company();
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list( $user->staff_id );
        $discharges = Shipping_model::get_discharge($hide_pakistan);
        $port_of_loading = Shipping_model::get_port_of_loading();
        $arr_shipping_com = array();
        $arr_portloading = array();
        foreach ($shipping_company as $value) {
            $arr_shipping_com[$value->shipping_co_id] = $value->shipping_co_name;
        }
        foreach ($port_of_loading as $val1) {
            $arr_portloading[$val1->port_of_loading_id] = $val1->port_of_loading_name;
        }

        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Invoice');

        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getSheetByName('Invoice')
        ->setSheetState(\PhpOffice\PhpSpreadsheet\Worksheet\Worksheet::SHEETSTATE_VERYHIDDEN);

        $i = 0;
        $total_meas = 0;
        $total_weights = 0;
        $grand_total = 0;
        $invoice_no = "";
        $index = 0;
        $j = 0;
        $num_sheet = 1;
        $broombaseRow_inst = 24;
        foreach ($data as $key => $dataRow) {
            $fuel = '';
            $j += 1;
            if ($j == 1) {
                $invoice_no_inst = $dataRow->shipping_invoice_code;
            }
            $cc = $dataRow->engine_size;
            if ($dataRow->car_fuel == "Petrol") {
                $fuel = "G";
            } elseif ($dataRow->car_fuel == "Diesel") {
                $fuel = "D";
            } elseif ($dataRow->car_fuel == "LPG") {
                $fuel = "LPG";
            } elseif ($dataRow->car_fuel == "LPG_Pertrol") {
                $fuel = "L+G";
            } elseif ($dataRow->car_fuel == "Hybrid") {
                $fuel = "H";
            }
            $total_sold_price = $dataRow->fob + $dataRow->freight_fee + $dataRow->inspection + $dataRow->insurance - (float)$dataRow->discount;
            $grand_total += $total_sold_price;
            $invoice_no = $dataRow->shipping_invoice_code;
            $next_sheets  = 1 + $index;
            $objWorkSheet = $objPHPExcel->createSheet($next_sheets);
            $objWorkSheet->setTitle("$num_sheet");
            $objPHPExcel->setActiveSheetIndex($next_sheets);
            // start design excel
            //set column width
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(6);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(6);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(6);
            //set border thick aound
            $border_left_thick = array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK, 'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            $border_top_thick = array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK, 'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            //block border thin
            $border_top_thin = array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_left_thin = array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_bottom_thin = array(
                'borders' => array(
                    'bottom' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array('rgb' => '00000'),
                    )
                )
            );
            $objPHPExcel->getActiveSheet()
                ->getStyle('E6')
                ->getAlignment()
                ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $objPHPExcel->getActiveSheet()->getStyle("K32:N32")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("K36:N36")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("K32:K35")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("O32:O35")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('M7')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('D13')->getAlignment()->setWrapText(true);
            //merge cell
            $objPHPExcel->getActiveSheet()->mergeCells('A1:N1');
            $objPHPExcel->getActiveSheet()->mergeCells('A2:N2');
            $objPHPExcel->getActiveSheet()->mergeCells('A3:N3');
            $objPHPExcel->getActiveSheet()->mergeCells('A4:N4');
            $objPHPExcel->getActiveSheet()->mergeCells('A6:N6');
            $objPHPExcel->getActiveSheet()->mergeCells('A8:B8');
            $objPHPExcel->getActiveSheet()->mergeCells('M7:N7');
            $objPHPExcel->getActiveSheet()->mergeCells('D8:F8');
            $objPHPExcel->getActiveSheet()->mergeCells('M8:N8');
            $objPHPExcel->getActiveSheet()->mergeCells('D9:G9');
            $objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
            $objPHPExcel->getActiveSheet()->mergeCells('D11:F11');
            $objPHPExcel->getActiveSheet()->mergeCells('A13:B13');
            $objPHPExcel->getActiveSheet()->mergeCells('D13:H17');
            $objPHPExcel->getActiveSheet()->mergeCells('A20:C20');
            $objPHPExcel->getActiveSheet()->mergeCells('D20:M20');
            $objPHPExcel->getActiveSheet()->mergeCells('A22:C22');

            $objPHPExcel->getActiveSheet()->mergeCells('D22:F22');
            $objPHPExcel->getActiveSheet()->mergeCells('D24:F24');
            $objPHPExcel->getActiveSheet()->mergeCells('A25:B25');
            $objPHPExcel->getActiveSheet()->mergeCells('D25:F25');
            $objPHPExcel->getActiveSheet()->mergeCells('D26:L26');
            $objPHPExcel->getActiveSheet()->mergeCells('A31:C31');
            $objPHPExcel->getActiveSheet()->mergeCells('A32:C32');
            $objPHPExcel->getActiveSheet()->mergeCells('A33:C33');
            $objPHPExcel->getActiveSheet()->mergeCells('A34:C34');
            $objPHPExcel->getActiveSheet()->mergeCells('A35:C35');
            $objPHPExcel->getActiveSheet()->mergeCells('A36:C36');
            $objPHPExcel->getActiveSheet()->mergeCells('A37:C37');
            $objPHPExcel->getActiveSheet()->mergeCells('A38:C38');
            $objPHPExcel->getActiveSheet()->mergeCells('A39:C39');

            $objPHPExcel->getActiveSheet()->mergeCells('K32:N32');
            $objPHPExcel->getActiveSheet()->mergeCells('K33:N33');
            $objPHPExcel->getActiveSheet()->mergeCells('K34:N34');
            $objPHPExcel->getActiveSheet()->mergeCells('K35:N35');

            $objPHPExcel->getActiveSheet()->mergeCells('D31:F31');
            $objPHPExcel->getActiveSheet()->mergeCells('D32:F32');
            $objPHPExcel->getActiveSheet()->mergeCells('D33:F33');
            $objPHPExcel->getActiveSheet()->mergeCells('D34:F34');
            $objPHPExcel->getActiveSheet()->mergeCells('D35:F35');
            $objPHPExcel->getActiveSheet()->mergeCells('D36:F36');
            $objPHPExcel->getActiveSheet()->mergeCells('D37:F37');
            //$objPHPExcel->getActiveSheet()->mergeCells('E38:I38');

            //set label to cell
            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'SILMI Japan Co., Ltd.')
            ->setCellValue('A2', '3-6-28, Miyanosaka, Hirakata-city,')
            ->setCellValue('A3', ' Osaka, Japan')
            ->setCellValue('A4', 'PHONE: +81-72-392-4971')
            ->setCellValue('A6', 'SHIPPING INSTRUCTION')
            ->setCellValue('M7', date("Y-m-d"))
            ->setCellValue('M8', $invoice_no_inst)
                ->setCellValue('J7', 'DATE:')
                ->setCellValue('J8', 'INV NO')
                ->setCellValue('A8', 'SHIPPER:')
                ->setCellValue('D8', 'SILMI JAPAN CO., LTD.')
                ->setCellValue('D9', '3-6-28 Miyanosaka, Hirakata, Osaka, JAPAN')
                ->setCellValue('D10', 'PHONE: +81-72-392-4971')
                ->setCellValue('D11', 'EMAIL: jack@silmijapan.com')
                ->setCellValue('D24', '1 CONTAINER SAID TO CONTAIN')
                ->setCellValue('D25', '1 UNITS OF USED CARS')
                ->setCellValue('A13', 'CONSIGNEE :')
                ->setCellValue('D13', "SEENA USED AUTO SPARE PARTS TR. LLC"."\n"."SA3, Arjumandi Building, Alkhan street,Industrial area 8, Sharjah, UAE"."\nTEL: "."+971507864862"."\n"."mehdi50me@yahoo.com")
                ->setCellValue('A20', 'NOTIFY PARTY :')
                ->setCellValue('D20', 'SAME AS CONSIGNEE')
                ->setCellValue('A22', 'FINAL DESTINATION :')
                ->setCellValue('D22', "JEBEL ALI")
                ->setCellValue('D24', '1 CONTAINER SAID TO CONTAIN')
                ->setCellValue('D25', '4 UNITS OF USED CARS')
                ->setCellValue('D26', "BRAND : " . $dataRow->car_make_name . " " . $dataRow->car_model_name . " ENGINE :" . $cc . "CC" . " " . $dataRow->drive_type . " LEFT HAND DRIVE" . " CHASSIS NO : " . $dataRow->chassis_number . " ")
                ->setCellValue('A31', 'SHIPPING FROM :')
                ->setCellValue('A32', 'SHIPPED TO :')
                ->setCellValue('A33', 'SHIPPED PER :')
                ->setCellValue('A34', 'VOY :')
                ->setCellValue('A35', 'SHIPPED ON :')
                ->setCellValue('A36', 'BOOKING :')
                ->setCellValue('A37', 'SHIPPING COMPANY :')
                ->setCellValue('A39', 'SILMI JAPAN CO., LTD.')
                ->setCellValue('G31', 'FREIGHT :')
                ->setCellValue('G32', 'B/L ISSUE BY :')
                ->setCellValue('G33', 'B/L')
                ->setCellValue('K31', 'MARKS & NO.S')
                ->setCellValue('K32', 'SILMI JAPAN CO., LTD.')
                ->setCellValue('K34', "JEBEL ALI")

                ->setCellValue('H31', "JEBEL ALI" )
                ->setCellValue('H32', $dataRow->bl_issue_by)
                ->setCellValue('H33', 'ORIGINAL 3')
                ->setCellValue('D31', $dataRow->port_of_loading_name)
                ->setCellValue('D32', "JEBEL ALI")
                ->setCellValue('D33', $dataRow->vessel_name)
                ->setCellValue('D34', $dataRow->voyage_no)
                ->setCellValue('D35', $dataRow->etd)
                ->setCellValue('D36', $dataRow->booking)
                ->setCellValue('D37', $arr_shipping_com[$dataRow->shipping_co_id]);

            //font bold 
            $bold = array(
                'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => '000000'),
                    'name'  => 'Microsoft Sans Serif'
                )
            );
            //font italic
            $italic = array(
                'font'  => array(
                    'italic'  => true,
                )
            );

            //font size 14
            $font14 = array(
                'font'  => array(
                    'size'  => 14,
                )
            );
            //font size 12
            $font12 = array(
                'font'  => array(
                    'size'  => 12,
                )
            );
            //font size 24
            $font24 = array(
                'font'  => array(
                    'size'  => 24,
                )
            );
            //font size 22
            $font22 = array(
                'font'  => array(
                    'size'  => 22,
                )
            );
            //font size 22
            $font9 = array(
                'font'  => array(
                    'size'  => 9,
                )
            );
            //font famili Time New Roman
            $time_new_toman = array(
                'font'  => array(
                    'name'  => 'Microsoft Sans Serif'
                )
            );
            //text align center
            $align_center = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                )
            );
            //text align left
            $align_left = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                )
            );
            $align_right = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($bold);
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($font12);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($bold);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($font12);
            $objPHPExcel->getActiveSheet()->getStyle('A:O')->applyFromArray( $time_new_toman);
           
            // $gdImage = public_path().'/uploads/silmi_logo_invoice1.png';
            // $objDrawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
            // $objDrawing->setName( 'Silmi' );
            // $objDrawing->setDescription( 'Silmijapan' );
            // $objDrawing->setPath( $gdImage );
            // $objDrawing->setHeight( 100 );
            // $objDrawing->setCoordinates('B2');
            // $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

            //get data from db to cell


            //wrap text
            $objPHPExcel->getActiveSheet()->getStyle('E13:I18')->getAlignment()->setWrapText(true);

            if ($dataRow->consignee_name != '') {
                $objWorkSheet->setCellValue('C61',  'Name : ' . 'consignee_name')
                ->setCellValue('C63',  'Phone : ' . 'consignee_phone')
                ->setCellValue('C65',  'Address : ' . 'consignee_address');
            }
            $car_width  = $dataRow->car_width / 100;
            $car_length = $dataRow->car_length / 100;
            $car_height = $dataRow->car_height / 100;
            $car_meas = $car_width * $car_length * $car_height;


            $index++;
            $num_sheet++;
        }

        $objPHPExcel->setActiveSheetIndex(0);

        $index = 0;
        $num_sheet = 1;
        $broombaseRow_inst = 24;
        foreach ($data as $key => $dataRow) {
            $modelYear = $dataRow->car_model_year;
            $invoice_no = $dataRow->shipping_invoice_code;
            $next_sheets  = 1 + $index;
            $objWorkSheet = $objPHPExcel->createSheet($next_sheets);
            $objWorkSheet->setTitle("Inv $num_sheet");
            $objPHPExcel->setActiveSheetIndex($next_sheets);
            // start design excel
            //set column width
            $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(6);
            $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(11);
            $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(10);
            $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
            $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setWidth(13);
            $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setWidth(14);
            $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setWidth(6);
            //set border thick aound
            $border_left_thick = array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK, 'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            $border_top_thick = array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK, 'color' => array('rgb' => '0000ff'),
                    )
                )
            );
            //block border thin
            $border_top_thin = array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_left_thin = array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array('rgb' => '00000'),
                    )
                )
            );
            $border_bottom_thin = array(
                'borders' => array(
                    'bottom' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array('rgb' => '00000'),
                    )
                )
            );
            $objPHPExcel->getActiveSheet()
                ->getStyle('E6')
                ->getAlignment()
                ->setHorizontal(\PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT);
            $objPHPExcel->getActiveSheet()->getStyle("L20:O20")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("L24:O24")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("L20:L23")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("P20:P23")->applyFromArray($border_left_thin);

            $objPHPExcel->getActiveSheet()->getStyle("A16:N16")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("A17:N17")->applyFromArray($border_top_thin);
            $objPHPExcel->getActiveSheet()->getStyle("A18:N18")->applyFromArray($border_top_thin);

            $objPHPExcel->getActiveSheet()->getStyle("A16:A17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("B16:B17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("C16:C17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("D16:D17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("E16:E17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("F16:F17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("G16:G17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("H16:H17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("I16:I17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("J16:J17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("K16:K17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("L16:L17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("M16:M17")->applyFromArray($border_left_thin);
            $objPHPExcel->getActiveSheet()->getStyle("N16:N17")->applyFromArray($border_left_thin);

            $objPHPExcel->getActiveSheet()->getStyle("O16:O17")->applyFromArray($border_left_thin);

            $objPHPExcel->getActiveSheet()->getStyle('A6')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('M7')->getFont()->setUnderline(true);
            $objPHPExcel->getActiveSheet()->getStyle('D8')->getAlignment()->setWrapText(true);

            $objPHPExcel->getActiveSheet()->getStyle('A16:N16')->getAlignment()->setHorizontal('center');
            $objPHPExcel->getActiveSheet()->getStyle('A17:N17')->getAlignment()->setHorizontal('center');

            $objPHPExcel->getActiveSheet()->getStyle('F24:F27')->getAlignment()->setHorizontal('right');
            //merge cell
            $objPHPExcel->getActiveSheet()->mergeCells('A1:N1');
            $objPHPExcel->getActiveSheet()->mergeCells('A2:N2');
            $objPHPExcel->getActiveSheet()->mergeCells('A3:N3');
            $objPHPExcel->getActiveSheet()->mergeCells('A4:N4');
            $objPHPExcel->getActiveSheet()->mergeCells('A6:N6');
            $objPHPExcel->getActiveSheet()->mergeCells('A8:B8');
            $objPHPExcel->getActiveSheet()->mergeCells('M7:N7');
            $objPHPExcel->getActiveSheet()->mergeCells('D8:F8');
            $objPHPExcel->getActiveSheet()->mergeCells('M8:N8');
            $objPHPExcel->getActiveSheet()->mergeCells('D9:G9');
            $objPHPExcel->getActiveSheet()->mergeCells('D10:F10');
            $objPHPExcel->getActiveSheet()->mergeCells('D11:F11');
            $objPHPExcel->getActiveSheet()->mergeCells('A13:B13');
            $objPHPExcel->getActiveSheet()->mergeCells('D8:H13');
            $objPHPExcel->getActiveSheet()->mergeCells('A20:C20');
            $objPHPExcel->getActiveSheet()->mergeCells('A22:C22');

            $objPHPExcel->getActiveSheet()->mergeCells('A19:C19');
            $objPHPExcel->getActiveSheet()->mergeCells('A20:C20');
            $objPHPExcel->getActiveSheet()->mergeCells('A21:C21');
            $objPHPExcel->getActiveSheet()->mergeCells('A22:C22');
            $objPHPExcel->getActiveSheet()->mergeCells('A23:C23');
            $objPHPExcel->getActiveSheet()->mergeCells('A24:C24');
            $objPHPExcel->getActiveSheet()->mergeCells('A25:C25');
            $objPHPExcel->getActiveSheet()->mergeCells('A26:B26');
            $objPHPExcel->getActiveSheet()->mergeCells('A28:C28');

            $objPHPExcel->getActiveSheet()->mergeCells('D19:E19');
            $objPHPExcel->getActiveSheet()->mergeCells('D20:E20');
            $objPHPExcel->getActiveSheet()->mergeCells('D21:E21');
            $objPHPExcel->getActiveSheet()->mergeCells('D22:E22');
            $objPHPExcel->getActiveSheet()->mergeCells('D23:E23');
            $objPHPExcel->getActiveSheet()->mergeCells('D24:E24');
            $objPHPExcel->getActiveSheet()->mergeCells('D25:E25');
            $objPHPExcel->getActiveSheet()->mergeCells('D26:E26');

            $objPHPExcel->getActiveSheet()->mergeCells('F24:G24');
            $objPHPExcel->getActiveSheet()->mergeCells('F25:G25');
            $objPHPExcel->getActiveSheet()->mergeCells('F26:G26');

            $objPHPExcel->getActiveSheet()->mergeCells('H24:I24');
            $objPHPExcel->getActiveSheet()->mergeCells('H25:H25');
            $objPHPExcel->getActiveSheet()->mergeCells('H26:H26');
            //set label to cell
            $objPHPExcel->getActiveSheet()->setCellValue('A1', 'SILMI Japan Co., Ltd.')
            ->setCellValue('A2', '3-6-28, Miyanosaka, Hirakata, Osaka, Japan')
            ->setCellValue('A3', 'PHONE: +81-72-392-4971')
            ->setCellValue('A4', ' EMAIL: jack@silmijapan.com')
            ->setCellValue('A6', 'I N V O I C E')
            ->setCellValue('M7', date("Y-m-d"))
            ->setCellValue('M8', $invoice_no_inst)
                ->setCellValue('J7', 'DATE:')
                ->setCellValue('J8', 'INV NO')
                ->setCellValue('A8', 'SOLD TO:')
                  ->setCellValue('D8', "SEENA USED AUTO SPARE PARTS TR. LLC"."\n"."SA3, Arjumandi Building, Alkhan street,Industrial area 8, Sharjah, UAE"."\nTEL: "."+971507864862"."\n"."mehdi50me@yahoo.com")
                
                ->setCellValue('A14', 'FINAL DESTINATION')
                ->setCellValue('D14', "JEBEL ALI")
                ->setCellValue('A16', 'NO')
                ->setCellValue('B16', 'YEAR')
                ->setCellValue('C16', 'MAKER')
                ->setCellValue('D16', 'NAME')
                ->setCellValue('E16', 'CHASSIS NO')
                ->setCellValue('F16', 'WEIGHT')
                ->setCellValue('G16', 'LENGTH')
                ->setCellValue('H16', 'WIDTH')
                ->setCellValue('I16', 'HEIGHT')
                ->setCellValue('J16', 'MEAS')
                ->setCellValue('K16', 'DISP')
                ->setCellValue('L16', 'FUEL')
                ->setCellValue('M16', 'SEAT')
                ->setCellValue('N16', 'CIF')
                ->setCellValue('A17', '1')
                ->setCellValue('B17', $modelYear)
                ->setCellValue('C17', $dataRow->car_make_name)
                ->setCellValue('D17', $dataRow->car_model_name)
                ->setCellValue('E17', $dataRow->chassis_number)
                ->setCellValue('F17', $dataRow->car_weight)
                ->setCellValue('G17', $dataRow->car_length)
                ->setCellValue('H17', $dataRow->car_width)
                ->setCellValue('I17', $dataRow->car_height)
                ->setCellValue('J17', '=(G17*H17*I17)/1000000')
                ->setCellValue('K17', $dataRow->engine_size)
                ->setCellValue('L17', $fuel)
                ->setCellValue('M17', $dataRow->seats)
                ->setCellValue('N17', $total_sold_price)

                ->setCellValue('A19', 'SHIPPING FROM :')
                ->setCellValue('A20', 'SHIPPED TO :')
                ->setCellValue('A21', 'SHIPPED PER :')
                ->setCellValue('A22', 'VOY :')
                ->setCellValue('A23', 'SHIPPED ON :')
                ->setCellValue('A24', 'BOOKING :')
                ->setCellValue('A25', 'SHIPPING COMPANY')
                ->setCellValue('A26', 'PAYMENT')
                ->setCellValue('A28', 'SILMI JAPAN CO., LTD.')

                ->setCellValue('F24', 'FREIGHT:')
                ->setCellValue('F25', 'B/L ISSUE BY:')
                ->setCellValue('F26', 'B/L')
                ->setCellValue('H24', 'PREPAID AS ARRANGED')
                ->setCellValue('H25', $dataRow->bl_issue_by)
                ->setCellValue('H26', 'ORIGINAL 3')

                ->setCellValue('L19', 'MARKS & NO.S')
                ->setCellValue('L20', 'SILMI JAPAN CO., LTD')
                ->setCellValue('L21', "JEBEL ALI")

                ->setCellValue('D19', $dataRow->port_of_loading_name)
                ->setCellValue('D20', "JEBEL ALI")
                ->setCellValue('D21', $dataRow->vessel_name)
                ->setCellValue('D22', $dataRow->voyage_no)
                ->setCellValue('D23', $dataRow->etd)
                ->setCellValue('D24', $dataRow->booking)
                ->setCellValue('D25', $arr_shipping_com[$dataRow->shipping_co_id])
                ->setCellValue('D26', 'T/T REMITTANCE');

            // Number Format
            $objPHPExcel->getActiveSheet()->getStyle('J17')->getNumberFormat()->setFormatCode('0.000');

            //font bold 
            $bold = array(
                'font'  => array(
                    'bold'  => true,
                    'color' => array('rgb' => '000000'),
                    'name'  => 'Microsoft Sans Serif'
                )
            );
            //font italic
            $italic = array(
                'font'  => array(
                    'italic'  => true,
                )
            );

            //font size 14
            $font14 = array(
                'font'  => array(
                    'size'  => 14,
                )
            );
            //font size 12
            $font12 = array(
                'font'  => array(
                    'size'  => 12,
                )
            );
            //font size 24
            $font24 = array(
                'font'  => array(
                    'size'  => 24,
                )
            );
            //font size 22
            $font22 = array(
                'font'  => array(
                    'size'  => 22,
                )
            );
            //font size 22
            $font9 = array(
                'font'  => array(
                    'size'  => 9,
                )
            );
            //font famili Time New Roman
            $time_new_toman = array(
                'font'  => array(
                    'name'  => 'Microsoft Sans Serif'
                )
            );
            //text align center
            $align_center = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                )
            );
            //text align left
            $align_left = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                )
            );
            $align_right = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('A1')->applyFromArray($bold);
            $objPHPExcel->getActiveSheet()->getStyle('A1:A4')->applyFromArray($font12);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($align_center);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($bold);
            $objPHPExcel->getActiveSheet()->getStyle('A6')->applyFromArray($font12);
     $objPHPExcel->getActiveSheet()->getStyle('A:O')->applyFromArray( $time_new_toman);
            // $gdImage = public_path().'/uploads/silmi_logo_invoice1.png';
            // $objDrawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
            // $objDrawing->setName( 'Silmi' );
            // $objDrawing->setDescription( 'Silmijapan' );
            // $objDrawing->setPath( $gdImage );
            // $objDrawing->setHeight( 100 );
            // $objDrawing->setCoordinates('B2');
            // $objDrawing->setWorksheet($objPHPExcel->getActiveSheet());

            //wrap text
            $objPHPExcel->getActiveSheet()->getStyle('E13:I18')->getAlignment()->setWrapText(true);

            if ($dataRow->consignee_name != '') {
                $objWorkSheet->setCellValue('C61',  'Name : ' . 'consignee_name')
                ->setCellValue('C63',  'Phone : ' . 'consignee_phone')
                ->setCellValue('C65',  'Address : ' . 'consignee_address');
            }
            $car_width  = $dataRow->car_width / 100;
            $car_length = $dataRow->car_length / 100;
            $car_height = $dataRow->car_height / 100;
            $car_meas = $car_width * $car_length * $car_height;


            $index++;
            $num_sheet++;
        }

        $objPHPExcel->setActiveSheetIndex(1);

        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="invoice_'.$ship_invoice.'.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        return response()->json([
            $writer->save('php://output')
        ]);
    }

    public function shipping_invoice_dubai( $ship_invoice ){

        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/shipping_invoice_dubai_new.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );

        $data = Shipping_model::get_shipment_excel($ship_invoice);
        $insert_row_count1 = 0;
        $total_fobRow = 20;

        $baseRow = 18;

        $total = 0;
        $cif_total = 0;
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list( $user->staff_id );
        $shipping_company = Shipping_model::get_shipping_company();
        $discharges = Shipping_model::get_discharge($hide_pakistan);
        $port_of_loading = Shipping_model::get_port_of_loading();
        $arr_shipping_com = array();
        $arr_portloading = array();
        foreach ($shipping_company as $value) {
            $arr_shipping_com[$value->shipping_co_id] = $value->shipping_co_name;
        }
        foreach ($port_of_loading as $val1) {
            $arr_portloading[$val1->port_of_loading_id] = $val1->port_of_loading_name;
        }

        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Invoice');

        $objPHPExcel->setActiveSheetIndex(0);
        $i = 0;
        $total_meas = 0;
        $total_weights = 0;
        $grand_total = 0;
        $invoice_no = "";

        foreach ($data as $r => $dataRow) {
            
            $modelYear = $dataRow->car_model_year;
            
            $fuel = "";
            $i += 1;
            $row = $baseRow + $r;
            $invoice_no = $dataRow->shipping_invoice_code;
            $cc = $dataRow->engine_size;
            $meas = ($dataRow->car_length * $dataRow->car_width * $dataRow->car_height) / 1000000;
            $total_meas += $meas;
            $total_weights += $dataRow->car_weight;
            $total_sold_price = $dataRow->fob + $dataRow->freight_fee + $dataRow->inspection + $dataRow->insurance - (float)$dataRow->discount;
            $grand_total += $total_sold_price;
            if ($dataRow->car_fuel == "Petrol") {
                $fuel = "G";
            } elseif ($dataRow->car_fuel == "Diesel") {
                $fuel = "D";
            } elseif ($dataRow->car_fuel == "LPG") {
                $fuel = "LPG";
            } elseif ($dataRow->car_fuel == "LPG_Pertrol") {
                $fuel = "L+G";
            } elseif ($dataRow->car_fuel == "Hybrid") {
                $fuel = "H";
            }
            $objPHPExcel->getActiveSheet()->insertNewRowBefore($row, 1);


            $objPHPExcel->getActiveSheet()->setCellValue('A' . $row, $i)
                ->setCellValue('B' . $row, $modelYear)
                ->setCellValue('C' . $row, $dataRow->car_make_name)
                ->setCellValue('D' . $row, $dataRow->car_model_name)
                ->setCellValue('E' . $row, $dataRow->chassis_number)
                ->setCellValue('F' . $row, $dataRow->car_weight)
                ->setCellValue('G' . $row, $dataRow->car_length)
                ->setCellValue('H' . $row, $dataRow->car_width)
                ->setCellValue('I' . $row, $dataRow->car_height)
                //->setCellValue('J'.$row, $meas)
                ->setCellValue('J' . $row, '=+(G' . $row . '*H' . $row . '*I' . $row . ')/1000000')
                ->setCellValue('K' . $row, $dataRow->engine_size)
                ->setCellValue('L' . $row, $fuel)
                ->setCellValue('M' . $row, $dataRow->seats)
                ->setCellValue('N' . $row, $total_sold_price);

            //$total_unit = $total_unit + 1;
            // Number Format
            $objPHPExcel->getActiveSheet()->getStyle('J' . $row)->getNumberFormat()->setFormatCode('0.000');
        }
        $r18 = 17 + $i;
        $r20 = 19 + $i;
        $r21 = 20 + $i;
        $r22 = 21 + $i;
        $r23 = 22 + $i;
        $r24 = 23 + $i;
        $r25 = 24 + $i;
        $r26 = 25 + $i;
        $r27 = 26 + $i;

        $sumr = $r18 - 1;
        $objPHPExcel->getActiveSheet()->removeRow($baseRow - 1, 1);
        // Number Format
        $objPHPExcel->getActiveSheet()->getStyle('I' . $r18)->getNumberFormat()->setFormatCode('0.000');
        $objPHPExcel->getActiveSheet()->setCellValue('C' . $r18, $i)
            ->setCellValue('E' . $r18, '=+SUM(F17:F' . $sumr . ')')
            ->setCellValue('J' . $r18, '=+SUM(J17:J' . $sumr . ')')
            ->setCellValue('N' . $r18, $grand_total)
            ->setCellValue('H' . $r26, $dataRow->bl_issue_by)
            ->setCellValue('H' . $r25, 'PREPAID AS ARRANGED')
            ->setCellValue('L' . $r22, "JEBEL ALI")
            ->setCellValue('D' . $r26, $arr_shipping_com[$dataRow->shipping_co_id])
            ->setCellValue('D' . $r25, $dataRow->booking)
            ->setCellValue('D' . $r24, $dataRow->etd)
            ->setCellValue('D' . $r23, $dataRow->voyage_no)
            ->setCellValue('D' . $r20, $dataRow->port_of_loading_name)
            ->setCellValue('D' . $r22, $dataRow->vessel_name)
            ->setCellValue('D' . $r21, "JEBEL ALI");
        $objPHPExcel->getActiveSheet()->setCellValue('D8', "SEENA USED AUTO SPARE PARTS TR. LLC"."\n"."SA3, Arjumandi Building, Alkhan street,Industrial area 8, Sharjah, UAE"."\nTEL: "."+971507864862"."\n"."mehdi50me@yahoo.com");
        $objPHPExcel->getActiveSheet()->setCellValue('D14', "JEBEL ALI")
        ->setCellValue('M7', date("Y-m-d"))
        ->setCellValue('M8', $invoice_no);

        $align_h_left = array(
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
            ]
        );
        $center_ver = array(
            'alignment' => [
                'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
            ]
        );
        $objPHPExcel->getActiveSheet()->getStyle( 'D8' )->getAlignment()->setWrapText( true );
        $objPHPExcel->getActiveSheet()->getStyle('D8')->applyFromArray($align_h_left);
        $objPHPExcel->getActiveSheet()->getStyle('D8')->applyFromArray($center_ver);

        //end data for first sheet (INVOICE)
        //$shipping_from = 25 + $r;        

        ////////// Sencond Sheet create //////////////////////////////////////////////////////////////////////////////
        $objPHPExcel->setActiveSheetIndex(1);
        $objPHPExcel->getActiveSheet()->setTitle('INST');

        $baseRow_inst = 27;
        $broombaseRow_inst = $baseRow_inst + 1;

        $total = 0;
        $full_length = 0;
        $full_width = 0;
        $full_height = 0;
        $full_weight = 0;
        $j = 0;
        $total_meas_inst = 0;
        $total_weights_inst = 0;
        $invoice_no_inst = "";

        $data_Car_model_name="";
        $alpahrd_and_velfire_inst=87032312;
        $vits_and_belta_inst=87032112;
    
        $count_row = count($data) + $broombaseRow_inst;
        foreach ($data as $r => $dataRow) {
            $fuel = "";
            $j += 1;
            if ($j == 1) {
                $invoice_no_inst = $dataRow->shipping_invoice_code;
            }
            if($dataRow->car_model_id == "488" || $dataRow->car_model_id == '494' || $dataRow->car_model_id == '626'){
                $data_Car_model_name=$alpahrd_and_velfire_inst;
            }elseif($dataRow->car_model_id == "486" || $dataRow->car_model_id == '544'){
                $data_Car_model_name=$vits_and_belta_inst;
            }else{
                $data_Car_model_name="";
            }



            $row = $baseRow_inst + $r;
            $row2 = $row + $r + 3;
            $cc = $dataRow->engine_size;
            $meas_ins = ($dataRow->car_length * $dataRow->car_width * $dataRow->car_height) / 1000000;
            $total_meas_inst += $meas_ins;
            $total_weights_inst += $dataRow->car_weight;
            $objPHPExcel->getActiveSheet()->insertNewRowBefore($row, 1);
            $objPHPExcel->getActiveSheet()->mergeCells('D' . $row . ':L' . $row);

            $objPHPExcel->getActiveSheet()->setCellValue('D' . $row, $dataRow->car_make_name . " " . $dataRow->car_model_name . " YEAR " . $dataRow->car_model_year . " CHASSIS NO: " . $dataRow->chassis_number . " (" . $dataRow->car_length . "*" . $dataRow->car_width . "*" . $dataRow->car_height . ")")
            ->setCellValue('M' . $row, '=TEXT('.$data_Car_model_name.',"0")')
            ->setCellValue('N' . $row, $meas_ins)
            ->setCellValue('O' . $row, $dataRow->car_weight);


        }
        // $r18 = 18 + ($j);
        $r26 = 27 + ($j);
        $r27 = 28 - 1 + ($j);
        $r28 = 29 + ($j);
        $r29 = 30 + ($j);
        $r30 = 31 + ($j);
        $r31 = 32 + ($j);
        $r32 = 33 + ($j);
        $r33 = 34 + ($j);
        $r34 = 35 + ($j);

        $align_right = array(
            'alignment' => [
                'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
            ]
        );
        $objPHPExcel->getActiveSheet()->getStyle('M' . $r27)->applyFromArray($align_right);
        $objPHPExcel->getActiveSheet()->getStyle('N' . $r27)->applyFromArray($align_right);
        $objPHPExcel->getActiveSheet()->getStyle('O' . $r27)->applyFromArray($align_right);
        $objPHPExcel->getActiveSheet()->setCellValue('D13', "SEENA USED AUTO SPARE PARTS TR. LLC"."\n"."SA3, Arjumandi Building, Alkhan street,Industrial area 8, Sharjah, UAE"."\nTEL: "."+971507864862"."\n"."mehdi50me@yahoo.com")
        ->setCellValue('M25', "HS CODE")
        ->setCellValue('D22', "JEBEL ALI")
        ->setCellValue('M7', date("Y-m-d"))
        ->setCellValue('M8', $invoice_no_inst)
            ->setCellValue('D20', "SAME AS CONSIGNEE");


        $objPHPExcel->getActiveSheet()->setCellValue('M' . $r27, 'TOTAL')
            // ->setCellValue('M' . $r18, 'TOTAL')
            ->setCellValue('N' . $r27, $total_meas_inst)
            ->setCellValue('O' . $r27,  $total_weights_inst)
            ->setCellValue('H' . $r30, $dataRow->bl_issue_by)
            ->setCellValue('H' . $r29, "JEBEL ALI")
            ->setCellValue('K' . $r30, "JEBEL ALI")
            ->setCellValue('D' . $r34, $arr_shipping_com[$dataRow->shipping_co_id])
            ->setCellValue('D' . $r33, $dataRow->booking)
            ->setCellValue('D' . $r32, $dataRow->etd)
            ->setCellValue('D' . $r31, $dataRow->voyage_no)
            ->setCellValue('D' . $r28, $dataRow->port_of_loading_name)
            ->setCellValue('D' . $r30, $dataRow->vessel_name)
            ->setCellValue('D' . $r29, "JEBEL ALI");

        //wrap text
        $objPHPExcel->getActiveSheet()->getStyle( 'D13' )->getAlignment()->setWrapText( true );
        $objPHPExcel->getActiveSheet()->getStyle('D13')->applyFromArray($align_h_left);
        $objPHPExcel->getActiveSheet()->getStyle('D13')->applyFromArray($center_ver);

        $objPHPExcel->getActiveSheet()->removeRow($baseRow_inst - 1, 1);
        $objPHPExcel->getActiveSheet()->removeRow($count_row - 1, 1);

        $objPHPExcel->setActiveSheetIndex(1);

        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($objPHPExcel);

        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="invoice_'.$ship_invoice.'.xls"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
        header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
        header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
        header ('Pragma: public'); // HTTP/1.0
        return response()->json([
            $writer->save('php://output')
        ]);
    }

    public function shipping_invoice_seperated( $ship_invoice ) {
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/shipping_incoice_sp.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );

        $data = Shipping_model::get_shipment_excel( $ship_invoice );
        $insert_row_count1 = 0;
        $total_fobRow = 20;

        $baseRow = 38;

        $total = 0;
        $cif_total = 0;
        foreach ( $data as $r => $dataRow ) {

            $modelYear = $dataRow->car_model_year;
            $row0 = $baseRow;
            $row1 = $baseRow + 1;
            $row2 = $baseRow + 2;
            $row3 = $baseRow + 3;
            $row4 = $baseRow + 4;
            $row5 = $baseRow + 5;
            $row6 = $baseRow + 6;
            $row7 = $baseRow + 7;
            $row8 = $baseRow + 8;
            $row9 = $baseRow + 9;
            $row10 = $baseRow + 10;
            $row11 = $baseRow + 11;
            $row12 = $baseRow + 12;
            $row13 = $baseRow + 13;
            $row14 = $baseRow + 14;
            $row15 = $baseRow + 15;
            $row16 = $baseRow + 16;
            $row17 = $baseRow + 17;
            $row18 = $baseRow + 18;
            $row_border = $baseRow + 15;

            switch ( $dataRow->currency ) {
                case 'USD':
                $currency = '$';
                break;
                case 'KRW':
                $currency = '₩';
                break;

                case 'JPY':
                $currency = 'Ұ';
                break;
                case 'EUR':
                $currency = '€';
                break;

                default:
                $currency = '';
                break;
            }

            $total = $dataRow->fob + $dataRow->insurance + $dataRow->freight_fee;

            $cif_total += $total;

            $objPHPExcel->getActiveSheet()->setCellValue( 'E'.$row0, '01 UNIT USED VEHICLE' )
            ->setCellValue( 'E'.$row1, 'MAKER:' )
            ->setCellValue( 'E'.$row2, 'TYPE OF VEHICLE :' )
            ->setCellValue( 'E'.$row3, 'MODEL :' )
            ->setCellValue( 'E'.$row4, 'GRADE :' )
            ->setCellValue( 'E'.$row5, 'YEAR/MONTH (FIRST REG) :' )
            ->setCellValue( 'E'.$row6, 'CC :' )
            ->setCellValue( 'E'.$row7, 'FUEL TYPE :' )
            ->setCellValue( 'E'.$row8, 'CHASSIS NO :' )
            ->setCellValue( 'E'.$row9, 'COST:' )
            ->setCellValue( 'E'.$row10, 'INSURANCE:' )
            ->setCellValue( 'E'.$row11, 'FREIGHT :' )
            ->setCellValue( 'E'.$row12, '' )
            ->setCellValue( 'E'.$row13, '' )
            ->setCellValue( 'E'.$row14, '' )

            ->setCellValue( 'B'.$row5, 'SILMI-JAPAN' )
            ->setCellValue( 'M'.$row0, empty( $total ) ? 0 : $currency.' '. number_format( $total ) );

            //det dynamic data to cell
            $objPHPExcel->getActiveSheet()->setCellValue( 'N13', $dataRow->issue_date )
            ->setCellValue( 'N14', $dataRow->invoice_id )
            ->setCellValue( 'N15', date( 'Y-m-d' ) )
            ->setCellValue( 'N17', $dataRow->vessel_name.' '.$dataRow->voyage_no )
            ->setCellValue( 'N18', $dataRow->etd )
            ->setCellValue( 'N19', $dataRow->port_of_loading_name )
            ->setCellValue( 'N20', $dataRow->discharge_name )
            ->setCellValue( 'N35', $dataRow->invoice_id )
            ->setCellValue( 'Q35', date( 'Y-m-d' ) )

            ->setCellValue( 'I'.$row1, $dataRow->car_make_name )
            ->setCellValue( 'I'.$row2, $dataRow->car_body_type )
            ->setCellValue( 'I'.$row3, $dataRow->car_model_name )
            ->setCellValue( 'I'.$row4, $dataRow->grade )
            ->setCellValue( 'I'.$row5, $modelYear )
            ->setCellValue( 'I'.$row6, $dataRow->engine_size )
            ->setCellValue( 'I'.$row7, $dataRow->car_fuel )
            ->setCellValue( 'I'.$row8, $dataRow->chassis_number )
            ->setCellValue( 'I'.$row9, $dataRow->fob )
            ->setCellValue( 'I'.$row10, $dataRow->insurance )
            ->setCellValue( 'I'.$row11, $dataRow->freight_fee );

            // merge cell
            $objPHPExcel->getActiveSheet()->mergeCells( 'E'.$row0.':L'.$row0 )
            ->mergeCells( 'E'.$row1.':H'.$row1 )
            ->mergeCells( 'I'.$row1.':L'.$row1 )

            ->mergeCells( 'E'.$row2.':H'.$row2 )
            ->mergeCells( 'I'.$row2.':L'.$row2 )

            ->mergeCells( 'E'.$row3.':H'.$row3 )
            ->mergeCells( 'I'.$row3.':L'.$row3 )

            ->mergeCells( 'E'.$row4.':H'.$row4 )
            ->mergeCells( 'I'.$row4.':L'.$row4 )

            ->mergeCells( 'E'.$row5.':H'.$row5 )
            ->mergeCells( 'I'.$row5.':L'.$row5 )

            ->mergeCells( 'E'.$row6.':H'.$row6 )
            ->mergeCells( 'I'.$row6.':L'.$row6 )

            ->mergeCells( 'E'.$row7.':H'.$row7 )
            ->mergeCells( 'I'.$row7.':L'.$row7 )

            ->mergeCells( 'E'.$row8.':H'.$row8 )
            ->mergeCells( 'I'.$row8.':L'.$row8 )

            ->mergeCells( 'E'.$row9.':H'.$row9 )
            ->mergeCells( 'I'.$row9.':L'.$row9 )

            ->mergeCells( 'E'.$row10.':H'.$row10 )
            ->mergeCells( 'I'.$row10.':L'.$row10 )

            ->mergeCells( 'E'.$row11.':H'.$row11 )
            ->mergeCells( 'I'.$row11.':L'.$row11 )

            ->mergeCells( 'E'.$row11.':H'.$row11 )
            ->mergeCells( 'I'.$row11.':L'.$row11 )

            ->mergeCells( 'E'.$row12.':H'.$row12 )
            ->mergeCells( 'I'.$row12.':L'.$row12 )

            ->mergeCells( 'E'.$row13.':H'.$row13 )
            ->mergeCells( 'I'.$row13.':L'.$row13 )

            ->mergeCells( 'E'.$row14.':H'.$row14 )
            ->mergeCells( 'I'.$row14.':L'.$row14 )

            ->mergeCells( 'B'.$row5.':D'.$row7 )
            ->mergeCells( 'M'.$row0.':P'.$row15 );
            //set border right
            $right = array(
                'borders' => array(
                    'right' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 
                        'color' => [ 'rgb' => '000000' ],
                    )
                )
            );
          
            $objPHPExcel->getActiveSheet()->getStyle( 'A'.$row0.':A'.$row_border )->applyFromArray( $right );
            $objPHPExcel->getActiveSheet()->getStyle( 'D'.$row0.':D'.$row_border )->applyFromArray( $right );
            $objPHPExcel->getActiveSheet()->getStyle( 'L'.$row0.':L'.$row_border )->applyFromArray( $right );
            $objPHPExcel->getActiveSheet()->getStyle( 'P'.$row0.':P'.$row_border )->applyFromArray( $right );
            //border left
            $left = array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK, 
                        'color' => ['rgb' => '0000ff']  ,
                    )
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle( 'T'.$row0.':T'.$row_border )->applyFromArray( $left );
            $objPHPExcel->getActiveSheet()->getStyle( 'A'.$row0.':A'.$row_border )->applyFromArray( $left );
            //border bottom
            $bottom = array(
                'borders' => array(
                    'bottom' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 
                        'color' => [ 'rgb' => '000000' ],
                    )
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle( 'B'.$row15.':D'.$row15 )->applyFromArray( $bottom );
            $objPHPExcel->getActiveSheet()->getStyle( 'E'.$row15.':L'.$row15 )->applyFromArray( $bottom );
            $objPHPExcel->getActiveSheet()->getStyle( 'M'.$row15.':P'.$row15 )->applyFromArray( $bottom );

            //set text align center
            $center = array(
                'alignment' => [
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                ]
            );
            $center_ver = array(
                'alignment' => [
                    'vertical' => \PhpOffice\PhpSpreadsheet\Style\Alignment::VERTICAL_CENTER,
                ]
            );
            $objPHPExcel->getActiveSheet()->getStyle( 'B'.$row5 )->applyFromArray( $center );
            $objPHPExcel->getActiveSheet()->getStyle( 'E'.$row0.':L'.$row14 )->applyFromArray( $center );
            $objPHPExcel->getActiveSheet()->getStyle( 'M'.$row0 )->applyFromArray($center_ver);
            $objPHPExcel->getActiveSheet()->getStyle( 'M'.$row0 )->applyFromArray($center);

            // set font bold
            $bold = array(
                'font' => array(
                    'bold' => true,
                    'size' => 16
                )
            );
            $size_c = array(
                'font' => array(
                    'size' => 16
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle( 'E'.$row0.':I'.$row14 )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'I'.$row0.':L'.$row14 )->applyFromArray( $size_c );

            $baseRow = $baseRow + 16;
        }
        /**********************END LOOP*********************/
        // exit();
        $row53 = $baseRow;
        $row54 = $baseRow + 1;
        $row55 = $baseRow + 2;
        $row56 = $baseRow + 3;
        $row57 = $baseRow + 4;
        $row58 = $baseRow + 5;
        $row59 = $baseRow + 6;
        $row61 = $baseRow + 8;
        $row66 = $baseRow + 13;
        $row68 = $baseRow + 15;
        $row69 = $baseRow + 16;
        $row70 = $baseRow + 17;
        $row73 = $baseRow + 19;

        $objPHPExcel->getActiveSheet()->setCellValue( 'E'.$row54, '[ ✔]' )
        ->setCellValue( 'F'.$row54, 'Automatic Transmition' )
        ->setCellValue( 'E'.$row55, '[ ✔]' )
        ->setCellValue( 'F'.$row55, 'Anti-Locking Brake System' )
        ->setCellValue( 'E'.$row56, '[ ✔]' )
        ->setCellValue( 'F'.$row56, 'Airs Bags' );
        // merge cell
        $objPHPExcel->getActiveSheet()->mergeCells( 'F'.$row54.':I'.$row54 )
        ->mergeCells( 'F'.$row55.':I'.$row55 )
        ->mergeCells( 'F'.$row56.':I'.$row56 )
        ->mergeCells( 'B'.$row58.':D'.$row59 )
        ->mergeCells( 'E'.$row58.':L'.$row59 )
        ->mergeCells( 'M'.$row58.':P'.$row59 )
        ->mergeCells( 'B'.$row61.':L'.$row61 )
        ->mergeCells( 'B'.$row68.':G'.$row68 )
        ->mergeCells( 'B'.$row69.':G'.$row69 )
        ->mergeCells( 'B'.$row70.':G'.$row70 );
        //set text align left
        $left1 = array(
           'alignment' => [
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                ]
        );
        $objPHPExcel->getActiveSheet()->getStyle( 'E'.$row54.':F'.$row56 )->applyFromArray( $left1 );
        $objPHPExcel->getActiveSheet()->getStyle( 'B'.$row61 )->applyFromArray( $left1 );
        //border right thin
        $objPHPExcel->getActiveSheet()->getStyle( 'A'.$row53.':A'.$row57 )->applyFromArray( $right );
        $objPHPExcel->getActiveSheet()->getStyle( 'D'.$row53.':D'.$row57 )->applyFromArray( $right );
        $objPHPExcel->getActiveSheet()->getStyle( 'L'.$row53.':L'.$row57 )->applyFromArray( $right );
        $objPHPExcel->getActiveSheet()->getStyle( 'P'.$row53.':P'.$row57 )->applyFromArray( $right );

        $objPHPExcel->getActiveSheet()->getStyle( 'A'.$row58.':A'.$row59 )->applyFromArray( $right );
        $objPHPExcel->getActiveSheet()->getStyle( 'D'.$row58.':D'.$row59 )->applyFromArray( $right );
        $objPHPExcel->getActiveSheet()->getStyle( 'L'.$row58.':L'.$row59 )->applyFromArray( $right );
        $objPHPExcel->getActiveSheet()->getStyle( 'P'.$row58.':P'.$row59 )->applyFromArray( $right );
        //border bottom thin
        $objPHPExcel->getActiveSheet()->getStyle( 'B'.$row57.':P'.$row57 )->applyFromArray( $bottom );
        $objPHPExcel->getActiveSheet()->getStyle( 'B'.$row61.':R'.$row61 )->applyFromArray( $bottom );
        $objPHPExcel->getActiveSheet()->getStyle( 'B'.$row59.':P'.$row59 )->applyFromArray( $bottom );
        $objPHPExcel->getActiveSheet()->getStyle( 'L'.$row66.':P'.$row66 )->applyFromArray( $bottom );
        //border bottom thick
        $b_thick = array(
            'borders' => array(
                'bottom' => array(
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK,
                     'color' => [ 'rgb' => '000000' ],
                )
            )
        );
        $objPHPExcel->getActiveSheet()->getStyle( 'B'.$row66.':G'.$row66 )->applyFromArray( $b_thick );

        //border left thick
        $objPHPExcel->getActiveSheet()->getStyle( 'A'.$row53.':A'.$row73 )->applyFromArray( $left );
        $objPHPExcel->getActiveSheet()->getStyle( 'T'.$row53.':T'.$row73 )->applyFromArray( $left );
        //border bottom thick blue
        $blue_thick = array(
            'borders' => array(
                'bottom' => array(
                    'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK, 
                    'color' => array( 'rgb' => '0000ff' ),
                )
            )
        );

        $objPHPExcel->getActiveSheet()->getStyle( 'E'.$row58 )->applyFromArray( $center );
        $objPHPExcel->getActiveSheet()->getStyle( 'E'.$row58 )->applyFromArray( $center_ver );
        $objPHPExcel->getActiveSheet()->getStyle( 'M'.$row58 )->applyFromArray( $center );
        $objPHPExcel->getActiveSheet()->getStyle( 'M'.$row58 )->applyFromArray( $center_ver );
        $objPHPExcel->getActiveSheet()->getStyle( 'A'.$row73.':S'.$row73 )->applyFromArray( $blue_thick );
        //set cell value
        $objPHPExcel->getActiveSheet()->setCellValue( 'E'.$row58, 'TOTAL CIF' );
        $objPHPExcel->getActiveSheet()->setCellValue( 'M'.$row58, empty( $cif_total ) ? 0 : $currency.' '. number_format( $cif_total ) );

        $objPHPExcel->getActiveSheet()->setCellValue( 'B'.$row61, 'We hereby certify that the above mentioned goods are of JAPANESE ORIGIN.' );
        $objPHPExcel->getActiveSheet()->setCellValue( 'B'.$row68, 'SILMI JAPAN CO.,LTD' );
        $objPHPExcel->getActiveSheet()->setCellValue( 'B'.$row69, 'GENERAL MANAGER' );
        $objPHPExcel->getActiveSheet()->setCellValue( 'B'.$row70, 'YOHEI MURASHIMA' );
        // set font bold
        $objPHPExcel->getActiveSheet()->getStyle( 'E'.$row57.':P'.$row59 )->applyFromArray( $bold );
        //set color red
        $red = array(
            'font'  => array(
                'color' => array(
                    'rgb' => 'FF0000'
                )
            )
        );

        $objPHPExcel->getActiveSheet()->getStyle( 'E'.$row57.':P'.$row59 )->applyFromArray( $red );
        //set font size 22
        $size22 =[
            'font'  => [
                'bold'  => true,
                'color' => [
                    'rgb' => 'FF0000'
                ],
                'size'  => 22
            ]
            ];
        $objPHPExcel->getActiveSheet()->getStyle( 'E'.$row57.':L'.$row59 )->applyFromArray( $size22 );
        // size 24
        $size24 = [
            'font'  => [
                'color' => [
                    'rgb' => '000000'
            ],
                'size'  => 24
            ]
            ];
        $objPHPExcel->getActiveSheet()->getStyle( 'B'.$row68.':B'.$row70 )->applyFromArray( $size24 );
        $objPHPExcel->getActiveSheet()->getStyle( 'B'.$row68.':B'.$row70 )->applyFromArray( $center );
        $objPHPExcel->getActiveSheet()->getStyle('B'.$row68.':B'.$row70 )->applyFromArray($center_ver);
        $objPHPExcel->getActiveSheet()->getDefaultRowDimension('B'.$row68.':B'.$row70)->setRowHeight(24);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle( 'Invoice' );

        $objPHPExcel->setActiveSheetIndex( 0 );

        //start create sub sheet
        $sheet_data = array();
        $index = 0;
        $num_sheet = 1;
        $broombaseRow_inst = 24;

        foreach ( $data as $key => $dataRow ) {

            $next_sheets  = 1 + $index;
            $objWorkSheet = $objPHPExcel->createSheet( $next_sheets );
            $objWorkSheet->setTitle( "$num_sheet" );
            $objPHPExcel->setActiveSheetIndex( $next_sheets );
            // start design excel
            //set column width
            $objPHPExcel->getActiveSheet()->getColumnDimension( 'A' )->setWidth( 10 );
            $objPHPExcel->getActiveSheet()->getColumnDimension( 'C' )->setWidth( 11 );
            $objPHPExcel->getActiveSheet()->getColumnDimension( 'D' )->setWidth( 5 );
            $objPHPExcel->getActiveSheet()->getColumnDimension( 'E' )->setWidth( 10 );
            $objPHPExcel->getActiveSheet()->getColumnDimension( 'F' )->setWidth( 10 );
            $objPHPExcel->getActiveSheet()->getColumnDimension( 'G' )->setWidth( 10 );
            $objPHPExcel->getActiveSheet()->getColumnDimension( 'H' )->setWidth( 15 );
            $objPHPExcel->getActiveSheet()->getColumnDimension( 'I' )->setWidth( 17 );
            $objPHPExcel->getActiveSheet()->getColumnDimension( 'J' )->setWidth( 15 );
            $objPHPExcel->getActiveSheet()->getColumnDimension( 'K' )->setWidth( 20 );
            $objPHPExcel->getActiveSheet()->getColumnDimension( 'L' )->setWidth( 20 );

            //set border thick aound
            $border_left_thick = array(
                'borders' => array(
                    'left' => [
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK, 
                        'color' => [ 'rgb' => '0000ff' ],
                    ]
                )
            );
            $border_top_thick = array(
                'borders' => array(
                    'top' => [
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THICK, 
                        'color' => ['rgb' => '0000ff' ],
                    ]
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle( 'A1:A109' )->applyFromArray( $border_left_thick );
            $objPHPExcel->getActiveSheet()->getStyle( 'N1:N109' )->applyFromArray( $border_left_thick );
            $objPHPExcel->getActiveSheet()->getStyle( 'A1:M1' )->applyFromArray( $border_top_thick );
            $objPHPExcel->getActiveSheet()->getStyle( 'A110:M110' )->applyFromArray( $border_top_thick );
            $objPHPExcel->getActiveSheet()->getStyle( 'A52:M52' )->applyFromArray( $border_top_thick );
            //block border thin
            $border_top_thin = array(
                'borders' => array(
                    'top' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '00000' ),
                    )
                )
            );
            $border_left_thin = array(
                'borders' => array(
                    'left' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '00000' ),
                    )
                )
            );
            $border_bottom_thin = array(
                'borders' => array(
                    'bottom' => array(
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN, 'color' => array( 'rgb' => '00000' ),
                    )
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle( 'B11:L11' )->applyFromArray( $border_top_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'B21:L21' )->applyFromArray( $border_top_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'B22:L22' )->applyFromArray( $border_top_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'B49:L49' )->applyFromArray( $border_top_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'B50:L50' )->applyFromArray( $border_top_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'B54:L54' )->applyFromArray( $border_top_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'B60:I60' )->applyFromArray( $border_top_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'B67:I67' )->applyFromArray( $border_top_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'B75:L75' )->applyFromArray( $border_top_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'B84:L84' )->applyFromArray( $border_top_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'B85:L85' )->applyFromArray( $border_top_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'B109:L109' )->applyFromArray( $border_top_thin );

            $objPHPExcel->getActiveSheet()->getStyle( 'B11:B49' )->applyFromArray( $border_left_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'M11:M49' )->applyFromArray( $border_left_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'B54:B108' )->applyFromArray( $border_left_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'D11:B21' )->applyFromArray( $border_left_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'H21' )->applyFromArray( $border_left_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'K11:K21' )->applyFromArray( $border_left_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'M11:M21' )->applyFromArray( $border_left_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'B54:B108' )->applyFromArray( $border_left_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'J54:J74' )->applyFromArray( $border_left_thin );
            $objPHPExcel->getActiveSheet()->getStyle( 'M54:M108' )->applyFromArray( $border_left_thin );

            //merge cell
            $objPHPExcel->getActiveSheet()->mergeCells( 'E2:I2' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E3:I3' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E4:I4' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E5:I5' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'C8:E8' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'J3:L3' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'B12:C12' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'B14:C14' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E13:I18' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'K13:L13' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'K15:L15' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'K17:L17' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'K19:L19' );

            $objPHPExcel->getActiveSheet()->mergeCells( 'B21:C21' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E21:G21' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'H21:I21' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E24:G24' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'F25:G25' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'F26:G26' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'F27:G27' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E29:G29' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E30:G30' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E31:G31' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E32:G32' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E33:G33' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E34:G34' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E35:G35' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E36:G36' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E37:G37' );

            $objPHPExcel->getActiveSheet()->mergeCells( 'B54:D54' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'B55:I58' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'D60:I60' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'C61:I62' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'C63:I64' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'C65:I66' );

            $objPHPExcel->getActiveSheet()->mergeCells( 'B68:I72' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'F80:G80' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'F82:G82' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'B84:C84' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E84:F84' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'H84:I84' );

            $objPHPExcel->getActiveSheet()->mergeCells( 'E87:G87' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E88:G88' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E89:G89' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E90:G90' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E91:G91' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E92:G92' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E93:G93' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E94:G94' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E95:G95' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'E103:H103' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'J67:K67' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'J68:K68' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'B78:D78' );
            $objPHPExcel->getActiveSheet()->mergeCells( 'G101:H101' );

            //set label to cell
            $objPHPExcel->getActiveSheet()->setCellValue( 'E2', 'SILMI Japan Co., Ltd.' )
            ->setCellValue( 'E3', '3-6-28, Miyanosaka, Hirakata-city,' )
            ->setCellValue( 'E4', 'Osaka, Japan' )
            ->setCellValue( 'E5', 'PHONE: +81-72-392-4971' )
            ->setCellValue( 'C8', 'INVOICE' )
            ->setCellValue( 'J8', 'NO.' )
            ->setCellValue( 'J9', 'DATE :' )
            ->setCellValue( 'B12', 'MARKS & NOS.' )
            ->setCellValue( 'B14', 'SILMI-JAPAN' )
            ->setCellValue( 'E12', 'SOLD TO:' )
            ->setCellValue( 'K11', 'SHIPMENT :' )
            ->setCellValue( 'K12', 'FROM :' )
            ->setCellValue( 'K14', 'TO :' )
            ->setCellValue( 'K16', 'PER :' )
            ->setCellValue( 'K18', 'DATE :' )
            ->setCellValue( 'B21', 'ITEM NO.' )
            ->setCellValue( 'E21', 'DESCRIPTION OF GOODS' )
            ->setCellValue( 'H21', 'QUANTITY' )
            ->setCellValue( 'K21', 'EXTENSION  T/T' )
            ->setCellValue( 'E24', 'JAPANESE USED VEHICLE.' )
            ->setCellValue( 'E87', 'JAPANESE USED VEHICLE.' )
            ->setCellValue( 'K28', 'KGS.' )
            ->setCellValue( 'E29', 'MAKER :' )
            ->setCellValue( 'E30', 'MODEL :' )
            ->setCellValue( 'E31', 'ENGINE:' )
            ->setCellValue( 'E32', 'CHASSIS NUMBER :' )
            ->setCellValue( 'E33', 'COLOR :' )
            ->setCellValue( 'E34', 'YEAR :' )
            ->setCellValue( 'E35', 'MODEL CODE:' )
            ->setCellValue( 'E36', 'FINAL DESTINATION :' )
            ->setCellValue( 'E37', 'CFS :' )
            ->setCellValue( 'E38', 'MARK :' )
            ->setCellValue( 'I49', '1 UNIT' )
            ->setCellValue( 'E44', 'FREIGHT:' )
            ->setCellValue( 'H37', 'SILMI-JAPAN' )
            ->setCellValue( 'H44', 'PREPAID AS ARRANGED' )
            ->setCellValue( 'K28', 'KGS.' )
            ->setCellValue( 'K30', 'COST:' )
            ->setCellValue( 'K49', 'KGS' )
            ->setCellValue( 'B54', "Shipper's Name on B/L:" )
            ->setCellValue( 'B55', "SILMI Japan Co．Ltd\n3-6-28, Miyanosaka, Hirakata-city, Osaka, Japan\nPHONE: +81-72-392-4971\ninfo@silmijapan.com" )
            ->setCellValue( 'B60', 'Consignee :' )
            ->setCellValue( 'B67', 'Notify party:' )
            ->setCellValue( 'K56', 'SHIPPING INSTRUCTION' )
            ->setCellValue( 'J67', '※NOTIFY　1行目は' )
            ->setCellValue( 'J68', '会社名だけにして下さい。' )
            ->setCellValue( 'C77', 'Ocean Vessel :' )
            ->setCellValue( 'F80', 'Port of Loading :' )
            ->setCellValue( 'F82', 'No.of Original B/L' )
            ->setCellValue( 'I80', 'Port of Discharge :' )
            ->setCellValue( 'I82', 'Place of issue :' )
            ->setCellValue( 'B84', 'Marks and Nos.' )
            ->setCellValue( 'E84', "Nos of P'kgs" )
            ->setCellValue( 'H84', 'Description of goods' )
            ->setCellValue( 'L84', "Weight & M'ment" )
            ->setCellValue( 'B86', 'SILMI-JAPAN' )
            ->setCellValue( 'E89', 'MAKER :' )
            ->setCellValue( 'E90', 'MODEL :' )
            ->setCellValue( 'E91', 'ENGINE :' )
            ->setCellValue( 'E92', 'CHASSIS NUMBER :' )
            ->setCellValue( 'E93', 'COLOR :' )
            ->setCellValue( 'E94', 'YEAR :' )
            ->setCellValue( 'E95', 'MODEL CODE:' )
            ->setCellValue( 'E96', 'FINAL DESTINATION :' )
            ->setCellValue( 'E97', 'CFS :' )
            ->setCellValue( 'E98', 'MARK :' )
            ->setCellValue( 'E101', 'FREIGHT :' )
            ->setCellValue( 'G101', 'PREPAID AS ARRANGED' )
            ->setCellValue( 'I101', 'M3' )
            ->setCellValue( 'I99', 'KGS' )
            ->setCellValue( 'K99', 'L' )
            ->setCellValue( 'K100', 'W' )
            ->setCellValue( 'K101', 'H' );
            //font bold
            $bold = array(
                'font'  => array(
                    'bold'  => true,
                    'color' => array( 'rgb' => '000000' ),
                    'name'  => 'Times New Roman'
                )
            );
            //font italic
            $italic = array(
                'font'  => array(
                    'italic'  => true,
                )
            );

            //font size 14
            $font14 = array(
                'font'  => array(
                    'size'  => 14,
                )
            );
            //font size 12
            $font12 = array(
                'font'  => array(
                    'size'  => 12,
                )
            );
            //font size 24
            $font24 = array(
                'font'  => array(
                    'size'  => 24,
                )
            );
            //font size 22
            $font22 = array(
                'font'  => array(
                    'size'  => 22,
                )
            );
            //font size 22
            $font9 = array(
                'font'  => array(
                    'size'  => 9,
                )
            );
            //font famili Time New Roman
            $time_new_toman = array(
                'font'  => array(
                    'name'  => 'Times New Roman'
                )
            );
            //text align center
            $align_center = array(
                'alignment' => array(
                    'horizontal' =>  \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                )
            );
            //text align left
            $align_left = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_LEFT,
                )
            );
            $align_right = array(
                'alignment' => array(
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT,
                )
            );
            $objPHPExcel->getActiveSheet()->getStyle( 'E1:E5' )->applyFromArray( $align_center );
            $objPHPExcel->getActiveSheet()->getStyle( 'E1:E5' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'E1:E5' )->applyFromArray( $font14 );
            $objPHPExcel->getActiveSheet()->getStyle( 'A1:M109' )->applyFromArray( $time_new_toman );
            $objPHPExcel->getActiveSheet()->getStyle( 'J3' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'J3' )->applyFromArray( $font22 );
            $objPHPExcel->getActiveSheet()->getStyle( 'J3' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'C8' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'C8' )->applyFromArray( $font24 );
            $objPHPExcel->getActiveSheet()->getStyle( 'C8' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'J8:J9' )->applyFromArray( $font12 );
            $objPHPExcel->getActiveSheet()->getStyle( 'J8:J9' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'J8:J9' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'K8:K9' )->applyFromArray( $align_left );
            $objPHPExcel->getActiveSheet()->getStyle( 'B12' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'E12' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'E12' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'K11:K12' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'K11:K12' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'K14' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'K16' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'K18' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'K14' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'K16' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'K18' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'B11:K21' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'F25:F27' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'K30' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'B54' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'B55' )->applyFromArray( $align_center );
            $objPHPExcel->getActiveSheet()->getStyle( 'B55' )->applyFromArray( $font9 );
            $objPHPExcel->getActiveSheet()->getStyle( 'K56' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'K56' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'B60' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'B67' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'J67:J68' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'F80:I80' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'F80:I80' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'F82:I82' )->applyFromArray( $bold );
            $objPHPExcel->getActiveSheet()->getStyle( 'F82:I82' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'B84:L84' )->applyFromArray( $italic );
            $objPHPExcel->getActiveSheet()->getStyle( 'L30' )->applyFromArray( $align_center );
            $objPHPExcel->getActiveSheet()->getStyle( 'C61' )->applyFromArray( $align_left );
            $objPHPExcel->getActiveSheet()->getStyle( 'C63' )->applyFromArray( $align_left );
            $objPHPExcel->getActiveSheet()->getStyle( 'C65' )->applyFromArray( $align_left );
            $objPHPExcel->getActiveSheet()->getStyle( 'B68' )->applyFromArray( $align_center );
            $objPHPExcel->getActiveSheet()->getStyle( 'K13' )->applyFromArray( $align_center );
            $objPHPExcel->getActiveSheet()->getStyle( 'K15' )->applyFromArray( $align_center );
            $objPHPExcel->getActiveSheet()->getStyle( 'K17' )->applyFromArray( $align_center );
            $objPHPExcel->getActiveSheet()->getStyle( 'K19' )->applyFromArray( $align_center );
            $objPHPExcel->getActiveSheet()->getStyle( 'B78' )->applyFromArray( $align_center );
            $objPHPExcel->getActiveSheet()->getStyle( 'H29:H37' )->applyFromArray( $align_left );
            $objPHPExcel->getActiveSheet()->getStyle( 'H87:H95' )->applyFromArray( $align_left );
            $objPHPExcel->getActiveSheet()->getStyle( 'I99:I101' )->applyFromArray( $align_right );
            $objPHPExcel->getActiveSheet()->getStyle( 'K99:K101' )->applyFromArray( $align_right );
            $objPHPExcel->getActiveSheet()->getStyle( 'L99:L101' )->applyFromArray( $align_left );
            //text underline
            $objPHPExcel->getActiveSheet()->getStyle( 'B54' )->getFont()->setUnderline( true );
            $objPHPExcel->getActiveSheet()->getStyle( 'J56' )->getFont()->setUnderline( true );
            $objPHPExcel->getActiveSheet()->getStyle( 'B60' )->getFont()->setUnderline( true );
            $objPHPExcel->getActiveSheet()->getStyle( 'B67' )->getFont()->setUnderline( true );
            $objPHPExcel->getActiveSheet()->getStyle( 'C77' )->getFont()->setUnderline( true );
            $objPHPExcel->getActiveSheet()->getStyle( 'F80' )->getFont()->setUnderline( true );
            $objPHPExcel->getActiveSheet()->getStyle( 'I80' )->getFont()->setUnderline( true );
            $objPHPExcel->getActiveSheet()->getStyle( 'F82' )->getFont()->setUnderline( true );
            $objPHPExcel->getActiveSheet()->getStyle( 'I82' )->getFont()->setUnderline( true );
            $objPHPExcel->getActiveSheet()->getStyle( 'K56' )->getFont()->setUnderline( true );
            //create new line in cell B55
            $objPHPExcel->getActiveSheet()->getStyle( 'B55' )->getAlignment()->setWrapText( true );
            $objPHPExcel->getActiveSheet()->getStyle( 'B55' )->getAlignment()->setWrapText( true );

            //insert image ru.jpg to cell b2
            $gdImage = public_path().'/uploads/silmi_logo_invoice1.png';
            $objDrawing = new \PhpOffice\PhpSpreadsheet\Worksheet\Drawing();
            $objDrawing->setName( 'Silmi' );
            $objDrawing->setDescription( 'Silmijapan' );
            $objDrawing->setPath( $gdImage );
            $objDrawing->setHeight( 100 );
            $objDrawing->setCoordinates( 'B2' );
            $objDrawing->setWorksheet( $objPHPExcel->getActiveSheet() );

            //get data from db to cell

            $objPHPExcel->getActiveSheet()->setCellValue( 'K8',  $ship_invoice )
            ->setCellValue( 'K9', Date( 'Y-m-d' ) )
            ->setCellValue( 'K13', $dataRow->port_of_loading_name )
            ->setCellValue( 'K15', strtoupper( $dataRow->discharge_name ) )
            ->setCellValue( 'K17', $dataRow->vessel_name.' V '.$dataRow->voyage_no )
            ->setCellValue( 'K19', $dataRow->etd )

            ->setCellValue( 'H29', $dataRow->car_make_name )
            ->setCellValue( 'H30', $dataRow->car_model_name )
            ->setCellValue( 'H31', $dataRow->engine_size )
            ->setCellValue( 'H32', $dataRow->chassis_number )
            ->setCellValue( 'H33', $dataRow->color_name )
            ->setCellValue( 'H34', $modelYear )
            ->setCellValue( 'H35', $dataRow->model_code )
            ->setCellValue( 'H36', $dataRow->final_des_name )
            ->setCellValue( 'H37', '' )
            ->setCellValue( 'H38', 'SILMI JAPAN' )
            ->setCellValue( 'J28', $dataRow->car_weight )
            ->setCellValue( 'L30', $dataRow->boss_price.' '.$dataRow->currency )
            //->setCellValue( 'J38', $ship_invoice )
            ->setCellValue( 'F39', '' )
            ->setCellValue( 'J49', $dataRow->car_weight )
            ->setCellValue( 'L49', '' )
            ->setCellValue( 'B78', $dataRow->vessel_name.' V '.$dataRow->voyage_no )
            ->setCellValue( 'I83', $dataRow->bl_issue_by );
            //wrap text
            $objPHPExcel->getActiveSheet()->getStyle( 'E13:I18' )->getAlignment()->setWrapText( true );

            //sold to
            if ( $dataRow->con_name != '' ) {
                $objWorkSheet->setCellValue( 'E13',  'Name :'.$dataRow->con_name.'\nAddress :'.$dataRow->con_add.'\nPhone :'.$dataRow->con_phone );

            }

            if ( $dataRow->con_name != '' ) {
                $objWorkSheet->setCellValue( 'C61',  'Name : '.$dataRow->con_name )
                ->setCellValue( 'C63',  'Address : '.$dataRow->con_add )
                ->setCellValue( 'C65',  'Phone : '.$dataRow->con_phone );

            }
            $car_width  = $dataRow->car_width / 100;
            $car_length = $dataRow->car_length / 100;
            $car_height = $dataRow->car_height / 100;
            $car_meas = $car_width * $car_length * $car_height;
            $objPHPExcel->getActiveSheet()->setCellValue( 'B68', $dataRow->notify_party )
            ->setCellValue( 'F81', $dataRow->port_of_loading_name )
            ->setCellValue( 'I81', $dataRow->discharge_name )
            ->setCellValue( 'F83', 'bl_no' )

            ->setCellValue( 'H89', $dataRow->car_make_name )
            ->setCellValue( 'H90', $dataRow->car_model_name )
            ->setCellValue( 'H91', $dataRow->engine_size )
            ->setCellValue( 'H92', $dataRow->chassis_number )
            ->setCellValue( 'H93', $dataRow->color_name )
            ->setCellValue( 'H94', $modelYear )
            ->setCellValue( 'H95', $dataRow->model_code )
            ->setCellValue( 'H96', $dataRow->final_des_name )
            ->setCellValue( 'H97', '' )
            ->setCellValue( 'H98', 'SILMI JAPAN' )
            ->setCellValue( 'J99', $dataRow->car_weight )
            ->setCellValue( 'L99', $dataRow->car_length )
            ->setCellValue( 'L100', $dataRow->car_width )
            ->setCellValue( 'L101', $dataRow->car_height )
            ->setCellValue( 'J101', $car_meas )
            ->setCellValue( 'F97', '' );

            $index++;
            $num_sheet++;
        }

        $objPHPExcel->setActiveSheetIndex( 0 );
        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls( $objPHPExcel );

        // Redirect output to a client’s web browser ( Excel5 )
        header( 'Content-Type: application/vnd.ms-excel' );
        header( 'Content-Disposition: attachment;filename="invoice_'.$ship_invoice.'.xls"' );
        header( 'Cache-Control: max-age=0' );
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age = 1');
        // If you're serving to IE over SSL, then the following may be needed
        header ( 'Expires: Mon, 26 Jul 1997 05:00:00 GMT' );
        // Date in the past
        header ( 'Last-Modified: '.gmdate( 'D, d M Y H:i:s' ).' GMT' );
        // always modified
        header ( 'Cache-Control: cache, must-revalidate' );
        // HTTP/1.1
        header ( 'Pragma: public' );
        // HTTP/1.0
        return response()->json( [
            $writer->save( 'php://output' )
        ] );
    }

    public function shipping_invoice_combined( $ship_invoice ) {
        require '../vendor/autoload.php';
        $objPHPExcel = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/shipping_invoice.xls' );
        $objPHPExcel = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );

        $objPHPExcel->getActiveSheet()->setTitle( 'Invoice' );
        $objPHPExcel->setActiveSheetIndex( 0 );

        $data = Shipping_model::get_shipment_excel( $ship_invoice );

        $insert_row_count1 = 0;
        $total_fobRow = 20;
        $baseRow = 18;

        $total = 0;
        $cif_total = 0;
        $shipping_company = Shipping_model::get_shipping_company();
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list( $user->staff_id );
        $discharges = Shipping_model::get_discharge( $hide_pakistan );
        $port_of_loading = Shipping_model::get_port_of_loading();
        $arr_shipping_com = array();
        $arr_portloading = array();
        foreach ( $shipping_company as $value ) {
            $arr_shipping_com[ $value->shipping_co_id ] = $value->shipping_co_name;
        }
        foreach ( $port_of_loading as $val1 ) {
            $arr_portloading[ $val1->port_of_loading_id ] = $val1->port_of_loading_name;
        }
        $i = 0;
        $total_meas = 0;
        $total_weights = 0;
        $grand_total = 0;
        $invoice_no = '';
        $totalMeas = 0;

        foreach ( $data as $r => $dataRow ) {

            $modelYear = $dataRow->car_model_year;
            $fuel = '';
            $i += 1;
            $row = $baseRow + $r;
            // dd( $row );
            $invoice_no = $dataRow->shipping_invoice_code;

            $cc = $dataRow->engine_size;
            $meas = ( $dataRow->car_length * $dataRow->car_width * $dataRow->car_height )/ 1000000;
            $total_meas += $meas;
            $total_weights += $dataRow->car_weight;
            $total_sold_price = $dataRow->fob + $dataRow->freight_fee + $dataRow->inspection + $dataRow->insurance - ( float )$dataRow->discount;

            $grand_total += $total_sold_price;
            if ( $dataRow->car_fuel == 'Petrol' ) {
                $fuel = 'G';
            } elseif ( $dataRow->car_fuel == 'Diesel' ) {
                $fuel = 'D';
            } elseif ( $dataRow->car_fuel == 'LPG' ) {
                $fuel = 'LPG';
            } elseif ( $dataRow->car_fuel == 'LPG_Pertrol' ) {
                $fuel = 'L+G';
            } elseif ( $dataRow->car_fuel == 'Hybrid' ) {
                $fuel = 'H';
            }

            $meas = round( ( $dataRow->car_length * $dataRow->car_width * $dataRow->car_height )/1000000, 3 );
            $totalMeas += $meas;
            $objPHPExcel->getActiveSheet()->insertNewRowBefore( $row, 1 );

            $objPHPExcel->getActiveSheet()->setCellValue( 'A'.$row, $i )
            ->setCellValue( 'B'.$row, $modelYear )
            ->setCellValue( 'C'.$row, $dataRow->car_make_name )
            ->setCellValue( 'D'.$row, $dataRow->car_model_name )
            ->setCellValue( 'E'.$row, $dataRow->chassis_number )
            ->setCellValue( 'F'.$row, $dataRow->car_weight )
            ->setCellValue( 'G'.$row, $dataRow->car_length )
            ->setCellValue( 'H'.$row, $dataRow->car_width )
            ->setCellValue( 'I'.$row, $dataRow->car_height )
            ->setCellValue( 'J'.$row, $meas )
            ->setCellValue( 'K'.$row, $dataRow->engine_size )
            ->setCellValue( 'L'.$row, $fuel )
            ->setCellValue( 'M'.$row, $dataRow->seats )
            ->setCellValue( 'N'.$row, $total_sold_price );

            //
        }

        $r18 = 17+ $i;
        $r20 = 19+ $i;
        $r21 = 20+ $i;
        $r22 = 21+ $i;
        $r23 = 22+ $i;
        $r24 = 23+ $i;
        $r25 = 24+ $i;
        $r26 = 25+ $i;
        $r27 = 26+ $i;

        $sumr = $r18-1;
        $freight = 'PREPAID AS ARRANGED';
        $objPHPExcel->getActiveSheet()->removeRow( $baseRow-1, 1 );
        $objPHPExcel->setActiveSheetIndex( 0 )->mergeCells( 'G'.$r18.':I'.$r18 );
        $objPHPExcel->getActiveSheet()->getStyle( 'G'.$r18.':I'.$r18 )->getAlignment()->setHorizontal( \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_RIGHT );
        $objPHPExcel->getActiveSheet()->setCellValue( 'C'.$r18, $i )
        ->setCellValue( 'E'.$r18, '=+SUM(F17:F'.$sumr.')' )
        ->setCellValue( 'J'.$r18, $totalMeas )
        ->setCellValue( 'N'.$r18, $grand_total )
        ->setCellValue( 'H'.$r26, $dataRow->bl_issue_by )
        ->setCellValue( 'H'.$r25, $freight )
        ->setCellValue( 'D'.$r26, $arr_shipping_com[ $dataRow->shipping_co_id ] )
        ->setCellValue( 'D'.$r25, $dataRow->booking )
        ->setCellValue( 'D'.$r24, $dataRow->etd )
        ->setCellValue( 'D'.$r23, $dataRow->voyage_no )
        ->setCellValue( 'D'.$r20, $dataRow->port_of_loading_name )
        ->setCellValue( 'D'.$r22, $dataRow->vessel_name )
        ->setCellValue( 'D'.$r21, $dataRow->discharge_name );
        $objPHPExcel->getActiveSheet()->setCellValue( 'D8', $dataRow->con_name.'\n'.$dataRow->con_add.'\nTEL: '.$dataRow->con_phone.'\n'.$dataRow->con_other_info )
        ->setCellValue( 'D14', $dataRow->discharge_name )
        ->setCellValue( 'M7', date( 'Y-m-d' ) )
        ->setCellValue( 'M8', $invoice_no );

        // //end data for first sheet ( INVOICE )
        //    //$shipping_from = 25 + $r;

        // ////////// Sencond Sheet create //////////////////////////////////////////////////////////////////////////////
        $objPHPExcel->setActiveSheetIndex( 1 );
        $objPHPExcel->getActiveSheet()->setTitle( 'INST' );

        $baseRow_inst = 27;
        $broombaseRow_inst = $baseRow_inst + 1;

        $total = 0;
        $full_length = 0;
        $full_width = 0;
        $full_height = 0;
        $full_weight = 0;
        $j = 0;
        $total_meas_inst = 0;
        $total_weights_inst = 0;
        $invoice_no_inst = '';
        $totalMeasIns = 0;
        $totalWeight = 0;
        $count_row = count( $data ) + $broombaseRow_inst;

        foreach ( $data as $r => $dataRow ) {
            $fuel = '';
            $j += 1;
            if ( $j == 1 ) {
                $invoice_no_inst = $dataRow->shipping_invoice_code;
            }
            $row = $baseRow_inst + $r;
            $row2 = $row + $r + 3;
            $cc = $dataRow->engine_size;
            $meas_ins = ( $dataRow->car_length * $dataRow->car_weight * $dataRow->car_height )/ 1000000;
            $total_meas_inst += $meas_ins;
            $measIns = round( ( $dataRow->car_length * $dataRow->car_width * $dataRow->car_height )/1000000, 6 );
            $totalMeasIns += $measIns;
            $total_weights_inst += $dataRow->car_weight;
            $totalWeight +=  $dataRow->car_weight;
            $objPHPExcel->getActiveSheet()->insertNewRowBefore( $row, 1 );
            $objPHPExcel->getActiveSheet()->mergeCells( 'D'.$row.':M'.$row );

            $objPHPExcel->getActiveSheet()->setCellValue( 'D'.$row, $dataRow->car_make_name.' '.$dataRow->car_model_name.' YEAR '.$dataRow->car_model_year.' CHASSIS NO : '.$dataRow->chassis_number.' ('.$dataRow->car_length.'*'.$dataRow->car_width.'*'.$dataRow->car_height.')' )
            ->setCellValue( 'N'.$row, $measIns )
            ->setCellValue( 'O'.$row, $dataRow->car_weight );

        }
        $r26 = 26+ $j;
        $r27 = 27+ $j;
        $r28 = 28+ $j;
        $r29 = 29+ $j;
        $r30 = 30+ $j;
        $r31 = 31+ $j;
        $r32 = 32+ $j;
        $r33 = 33+ $j;
        $r34 = 34+ $j;
        $sumd = $r26 -1;
        $rTotal = $r27;

        $objPHPExcel->getActiveSheet()->setCellValue( 'D13', $dataRow->con_name.'\n'.$dataRow->con_add.'\nTEL: '.$dataRow->con_phone.'\n'.$dataRow->con_other_info )
        ->setCellValue( 'D22', $dataRow->discharge_name )
        ->setCellValue( 'M7', date( 'Y-m-d' ) )
        ->setCellValue( 'M8', $invoice_no_inst )
        ->setCellValue( 'D20', $dataRow->notify_party );

        $objPHPExcel->getActiveSheet()->setCellValue( 'F'.$r26, $i )
        ->setCellValue( 'H'.$r26, '=SUM(I29:I'.$sumd.')' )
        ->setCellValue( 'L'.$r26, $total_meas )
        ->setCellValue( 'H'.$r30, $dataRow->bl_issue_by )
        ->setCellValue( 'H'.$r29, $freight )
        ->setCellValue( 'N'.$rTotal, $totalMeasIns )
        ->setCellValue( 'O'.$rTotal, $totalWeight )
        ->setCellValue( 'D'.$r34, $arr_shipping_com[ $dataRow->shipping_co_id ] )
        ->setCellValue( 'D'.$r33, $dataRow->booking )
        ->setCellValue( 'D'.$r32, $dataRow->etd )
        ->setCellValue( 'D'.$r31, $dataRow->voyage_no )
        ->setCellValue( 'D'.$r28, $dataRow->port_of_loading_name )
        ->setCellValue( 'D'.$r30, $dataRow->vessel_name )
        ->setCellValue( 'D'.$r29, $dataRow->discharge_name );

        $objPHPExcel->getActiveSheet()->removeRow( $baseRow_inst-1, 1 );
        $objPHPExcel->getActiveSheet()->removeRow( $count_row-1, 1 );

        $objPHPExcel->setActiveSheetIndex( 1 );
        $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls( $objPHPExcel );

        // Redirect output to a client’s web browser ( Excel5 )
        header( 'Content-Type: application/vnd.ms-excel' );
        header( 'Content-Disposition: attachment;filename="invoice_'.'.xls"' );
        header( 'Cache-Control: max-age=0' );
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age = 1');
        // If you're serving to IE over SSL, then the following may be needed
        header ( 'Expires: Mon, 26 Jul 1997 05:00:00 GMT' );
        // Date in the past
        header ( 'Last-Modified: '.gmdate( 'D, d M Y H:i:s' ).' GMT' );
        // always modified
        header ( 'Cache-Control: cache, must-revalidate' );
        // HTTP/1.1
        header ( 'Pragma: public' );
        // HTTP/1.0
        return response()->json( [
            $writer->save( 'php://output' )
        ] );

    }

    public function get_data_shipment(Request $request){
        $shipment_id = $request->get('shipment_id');
        if(!empty($shipment_id)){
            $data = Shipping_model::get_data_shipment($shipment_id);
            return response()->json([
                'shipment_data' => $data
            ]);
        }
    }

    public function sumbit_data_sort(Request $request){
        $DataSort = $request->get('DataSort');
        // dd(json_decode($DataSort));
        foreach(json_decode($DataSort) as $key => $value){
            $stock_id = $value->stock_id;
            $arr_update=array(
                    'order_shipment'=>$key+1
                );
            DB::table('erp_stock_list')
              ->where('car_stock_id','=',$stock_id)
              ->update($arr_update);
        }
        return response()->json([
            'status' => true
        ]);
    }

    function get_pdf_view(Request $request){
        $stock_id = $request->get('stock_id');
        $type_file= $request->get('type_file');
        $get_file_uploaded = Shipping_model::select_file_upload_doc($stock_id);
        if( $type_file  == 'compress' ){
            foreach($get_file_uploaded as $row){
                $arr_name = explode('.',$row->car_document_file);
                $ext= $arr_name[1];
                $name = $arr_name[0];
                $path = public_path( '/storage/uploads/pdf_files/file_compressed/'.$name.'.pdf');
                $path = public_path( '/storage/uploads/pdf_files/file_compressed/'.$name.'.pdf' );
                if(file_exists($path)){
                    return response()->json([
                        'file_path' => '/uploads/pdf_files/file_compressed/',
                        'file_name' => $row->car_document_file,
                    ]);
                }else{
                    if($ext == 'pdf'){
                        $path = public_path( '/storage/uploads/pdf_files/file_compressed/'.$row->car_document_file );
                        $path1 =  public_path( '/storage/uploads/pdf_files/'.$row->car_document_file );
                        $fname_compress = $row->car_document_file;
                        $filepath1 = storage_path( 'app/public/uploads/pdf_files/file_compressed/'.$fname_compress );
                        $apiKey = 'vuthy32@gmail.com_eb090f7c04d550ee5a59c92455fcfbeee72711e9c7c66625507106c779d3b139cbc354f5';
                            $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                            '?name=' . urlencode( $row->car_document_file ) .
                            '&contenttype=application/octet-stream';

                            // Create request
                            $curl = curl_init();
                            curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                            curl_setopt( $curl, CURLOPT_URL, $url );
                            curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                            // Execute request
                            $result = curl_exec( $curl );

                            if ( curl_errno( $curl ) == 0 ) {
                                $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                if ( $status_code == 200 ) {
                                    $json = json_decode( $result, true );

                                    // Get URL to use for the file upload
                                    $uploadFileUrl = $json[ 'presignedUrl' ];
                                    // Get URL of uploaded file to use with later API calls
                                    $uploadedFileUrl = $json[ 'url' ];

                                    // 2. UPLOAD THE FILE TO CLOUD.

                                    $localFile = $path1;
                                    $fileHandle = fopen( $localFile, 'r' );
                                    $dirname = dirname( $row->car_document_file );

                                    curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                                    curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                                    curl_setopt( $curl, CURLOPT_PUT, true );
                                    curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                                    curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $localFile ) );

                                    // Execute request
                                    curl_exec( $curl );

                                    fclose( $fileHandle );

                                    if ( curl_errno( $curl ) == 0 ) {
                                        $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                        if ( $status_code == 200 ) {
                                            // 3. OPTIMIZE UPLOADED PDF FILE

                                            $this->OptimizePdf( $apiKey, $uploadedFileUrl, $fname_compress );
                                        } else {
                                            // Display request error
                                            echo '<p>Status code: ' . $status_code . '</p>';

                                            echo '<p>' . $result . '</p>';

                                        }
                                    } else {
                                        // Display CURL error
                                        echo 'Error: ' . curl_error( $curl );
                                    }
                                } else {
                                    // Display service reported error
                                    echo '<p>Status code: ' . $status_code . '</p>';

                                    echo '<p>' . $result . '</p>';

                                }

                                curl_close( $curl );
                            } else {
                                // Display CURL error
                                echo 'Error: ' . curl_error( $curl );
                            }
                    return response()->json([
                        'file_path' => '/uploads/pdf_files/file_compressed/',
                        'file_name' => $row->car_document_file,
                    ]);
                    } elseif ( $ext == 'png' || $ext == 'jpeg' || $ext == 'jpg' ) {
                        if ( $type_file == 'compress' ) {
                            $path = public_path( '/storage/uploads/pdf_files/file_compressed/'.$name.'.pdf' );

                
                                $uploadedFiles = array();
                                // $fileCount = count( $_FILES[ 'file' ][ 'name' ] );
                                $fname_compress = $name.'.pdf';
                                $path2 = storage_path( 'app/public/uploads/pdf_files/'.$row->car_document_file );
                                $name_pdf = $fname_compress;
                                $apiKey = 'vuthy32@gmail.com_eb090f7c04d550ee5a59c92455fcfbeee72711e9c7c66625507106c779d3b139cbc354f5';
                                $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                                '?name=' . urlencode( $row->car_document_file ) .
                                '&contenttype=application/octet-stream';

                                // Create request
                                $curl = curl_init();
                                curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                                curl_setopt( $curl, CURLOPT_URL, $url );
                                curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                                // Execute request
                                $result = curl_exec( $curl );

                                if ( curl_errno( $curl ) == 0 ) {
                                    $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                    if ( $status_code == 200 ) {
                                        $json = json_decode( $result, true );

                                        // Get URL to use for the file upload
                                        $uploadFileUrl = $json[ 'presignedUrl' ];
                                        // Get URL of uploaded file to use with later API calls
                                        $uploadedFileUrl = $json[ 'url' ];

                                        $tmpFilePath = $path2;

                                        $fileHandle = fopen( $tmpFilePath, 'r' );

                                        curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                                        curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                                        curl_setopt( $curl, CURLOPT_PUT, true );
                                        curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                                        curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $tmpFilePath ) );

                                        // Execute request
                                        curl_exec( $curl );

                                        if ( curl_errno( $curl ) == 0 ) {
                                            $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                            if ( $status_code == 200 ) {
                                                $uploadedFiles[] = $uploadedFileUrl;
                                            } else {
                                                // Display request error
                                                echo '<p>Uploading File Status code: ' . $status_code . ' : ' . $uploadedFileUrl . '</p>';

                                                echo '<p>error status for uploading files (1 means error related to php.ini config or tmp folder permissions): ' . $_FILES[ 'files' ][ 'error' ] . '</p>';
                                                echo '<p>' . $result . '</p>';

                                            }
                                        } else {
                                            // Display CURL error
                                            echo 'cURL Error: ' . curl_error( $curl );
                                        }

                                        fclose( $fileHandle );
                                    } else {
                                        // Display request error
                                        echo '<p>Error Uploading: Status code: ' . $status_code . '</p>';

                                        echo '<p>' . $result . '</p>';

                                    }
                                } else {
                                    // Display CURL error
                                    echo 'cURL Error: ' . curl_error( $curl );
                                }

                                curl_close( $curl );

                                if ( count( $uploadedFiles ) > 0 ) {
                                    $this->ImageToPdf1( $apiKey, $uploadedFiles, $fname_compress );
                                }

                                return response()->json([
                                    'file_path' => '/uploads/pdf_files/file_compressed/',
                                    'file_name' => $name.'.pdf',
                                ]);
                            

                        } else {

                           

                        }
                    }
                }

            }
        }else{
            foreach($get_file_uploaded as $row){
                return response()->json([
                    'file_path' => '/uploads/pdf_files/',
                    'file_name' => $row->car_document_file,
                ]);
            }
           
        }
    }

    public function get_pdf_view_ec(Request $request){
        $stock_id = $request->get('stock_id');
        $condition= $request->get('type_file');
        $doc_type = 'ec';
        $get_file_uploaded = Shipping_model::select_file_upload($stock_id,$doc_type);
        if($condition == 'compress'){
           foreach( $get_file_uploaded as $row){
                $arr_name = explode('.',$row->file_name);
                $ext= $arr_name[1];
                $name = $arr_name[0];
                $fname_compress =$row->file_name;
                $path = public_path( '/storage/uploads/pdf_files/file_compressed/'.$name.'.pdf');
                $path1 = public_path( '/storage/uploads/pdf_files/'.$name.'.pdf');
                if(file_exists($path)){
                    return response()->json([
                        'file_path' => '/uploads/pdf_files/file_compressed/',
                        'file_name' => $row->file_name,
                    ]);
                }else{
                    if($ext == 'pdf'){
                        $apiKey = 'vuthy32@gmail.com_eb090f7c04d550ee5a59c92455fcfbeee72711e9c7c66625507106c779d3b139cbc354f5';
                        $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                        '?name=' .  urlencode($row->file_name) .
                        '&contenttype=application/octet-stream';
                        // Create request
                        $curl = curl_init();
                        curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                        curl_setopt( $curl, CURLOPT_URL, $url );
                        curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                        // Execute request
                        $result = curl_exec( $curl );
    
                        if ( curl_errno( $curl ) == 0 ) {
                            $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );
    
                            if ( $status_code == 200 ) {
                                $json = json_decode( $result, true );
    
                                // Get URL to use for the file upload
                                $uploadFileUrl = $json[ 'presignedUrl' ];
                                // Get URL of uploaded file to use with later API calls
                                $uploadedFileUrl = $json[ 'url' ];
    
                                // 2. UPLOAD THE FILE TO CLOUD.
    
                                $localFile = $path1;
                                $fileHandle = fopen( $localFile, 'r' );
                                $dirname = dirname($row->file_name);
                                
                                curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                                curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                                curl_setopt( $curl, CURLOPT_PUT, true );
                                curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                                curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $localFile ) );
    
                                // Execute request
                                curl_exec( $curl );
    
                                fclose( $fileHandle );
    
                                if ( curl_errno( $curl ) == 0 ) {
                                    $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );
    
                                    if ( $status_code == 200 ) {
                                        // 3. OPTIMIZE UPLOADED PDF FILE
    
                                        $this->OptimizePdf( $apiKey, $uploadedFileUrl, $fname_compress );
                                    } else {
                                        // Display request error
                                        dd( '<p>Status code: ' . $status_code . '</p>' );
    
                                        echo '<p>' . $result . '</p>';
    
                                    }
                                } else {
                                    // Display CURL error
                                    dd( 'Error: ' . curl_error( $curl ) );
                                }
                            }
                        } else {
                            // Display CURL error
                            echo 'Error: ' . curl_error( $curl );
                        }
                        return response()->json([
                            'file_path' => '/uploads/pdf_files/file_compressed/',
                            'file_name' => $row->file_name,
                        ]);
                    }elseif ( $ext == 'png' || $ext == 'jpeg' || $ext == 'jpg' ) {

                               $path2 = public_path( '/storage/uploads/pdf_files/'.$row->file_name );
                                $uploadedFiles = array();
                                $fname_compress = $name.'.pdf';
                                $name_pdf = $fname_compress;
                                $apiKey = 'vuthy32@gmail.com_eb090f7c04d550ee5a59c92455fcfbeee72711e9c7c66625507106c779d3b139cbc354f5';
                                $url = 'https://api.pdf.co/v1/file/upload/get-presigned-url' .
                                '?name=' . urlencode( $row->file_name ) .
                                '&contenttype=application/octet-stream';

                                // Create request
                                $curl = curl_init();
                                curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'x-api-key: ' . $apiKey ) );
                                curl_setopt( $curl, CURLOPT_URL, $url );
                                curl_setopt( $curl, CURLOPT_RETURNTRANSFER, 1 );
                                // Execute request
                                $result = curl_exec( $curl );

                                if ( curl_errno( $curl ) == 0 ) {
                                    $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                    if ( $status_code == 200 ) {
                                        $json = json_decode( $result, true );

                                        // Get URL to use for the file upload
                                        $uploadFileUrl = $json[ 'presignedUrl' ];
                                        // Get URL of uploaded file to use with later API calls
                                        $uploadedFileUrl = $json[ 'url' ];

                                        $tmpFilePath = $path2;

                                        $fileHandle = fopen( $tmpFilePath, 'r' );

                                        curl_setopt( $curl, CURLOPT_URL, $uploadFileUrl );
                                        curl_setopt( $curl, CURLOPT_HTTPHEADER, array( 'content-type: application/octet-stream' ) );
                                        curl_setopt( $curl, CURLOPT_PUT, true );
                                        curl_setopt( $curl, CURLOPT_INFILE, $fileHandle );
                                        curl_setopt( $curl, CURLOPT_INFILESIZE, filesize( $tmpFilePath ) );

                                        // Execute request
                                        curl_exec( $curl );

                                        if ( curl_errno( $curl ) == 0 ) {
                                            $status_code = curl_getinfo( $curl, CURLINFO_HTTP_CODE );

                                            if ( $status_code == 200 ) {
                                                $uploadedFiles[] = $uploadedFileUrl;
                                            } else {
                                                // Display request error
                                                echo '<p>Uploading File Status code: ' . $status_code . ' : ' . $uploadedFileUrl . '</p>';

                                                echo '<p>error status for uploading files (1 means error related to php.ini config or tmp folder permissions): ' . $_FILES[ 'files' ][ 'error' ] . '</p>';
                                                echo '<p>' . $result . '</p>';

                                            }
                                        } else {
                                            // Display CURL error
                                            echo 'cURL Error: ' . curl_error( $curl );
                                        }

                                        fclose( $fileHandle );
                                    } else {
                                        // Display request error
                                        echo '<p>Error Uploading: Status code: ' . $status_code . '</p>';

                                        echo '<p>' . $result . '</p>';

                                    }
                                } else {
                                    // Display CURL error
                                    echo 'cURL Error: ' . curl_error( $curl );
                                }

                                curl_close( $curl );

                                if ( count( $uploadedFiles ) > 0 ) {
                                    $this->ImageToPdf1( $apiKey, $uploadedFiles, $fname_compress );
                                }

                                return response()->json([
                                    'file_path' => '/uploads/pdf_files/file_compressed/',
                                    'file_name' => $name.'.pdf',
                                ]);
                        
                    }
                }
           }
        }else{
            foreach($get_file_uploaded as $row){
                return response()->json([
                    'file_path' => '/uploads/pdf_files/',
                    'file_name' => $row->file_name,
                ]);
            }
        }
    }

    public function get_car_list(Request $request){
        $shipment_id = $request->get('shpiment_id');
        $sql="SELECT
                *
            FROM
                `erp_stock_list`
            LEFT JOIN `erp_car_make` ON `erp_car_make`.`car_make_id` = `erp_stock_list`.`car_make_id`
            LEFT JOIN `erp_car_model` ON `erp_car_model`.`car_model_id` = `erp_stock_list`.`car_model_id`
            LEFT JOIN `erp_customer` ON `erp_customer`.`customer_id` = `erp_stock_list`.`customer_id`
            LEFT JOIN (
                SELECT
                    SUM(freight_fee) AS total_freight_fee,
                    expenses_division_id,
                    stock_id AS st_id,
                    created_date
                FROM
                    erp_car_expenses
                WHERE freight_fee >0
                GROUP BY
                    stock_id
            ) AS b ON b.st_id = erp_stock_list.stock_id
            LEFT JOIN erp_expenses_division c ON c.expenses_division_id=b.expenses_division_id
            LEFT JOIN erp_deposit_expense d ON d.deposit_expense_id=c.deposit_expense_id
            WHERE
                `shipment_id` = $shipment_id ";
            $car_list = DB::select($sql);
        return response()->json([
            'car_list' => $car_list
        ]);
    }

    public function GetBookListCar(Request $request){
        $sql ="SELECT * FROM erp_stock_list
        LEFT JOIN `erp_customer` ON `erp_customer`.`customer_id` = `erp_stock_list`.`customer_id`
        WHERE shipment_id IS NULL AND (status = 7  OR instruction ='on_the_way_to') AND car_stock_id <> '' ";
        $data = DB::select( $sql);
        return response()->json([
            'car_info' =>  $data
        ]);
    }

    public function AddShipInvoiceToCar(request $request){
        $shipment_id = $request->get('shipment_id');
        $trim_chassis = $request->get('chassis');
        $invoice_number = $request->get('invoice_number');
        $etd = Shipping_model::get_shipment_etd($shipment_id);
        $stock_id = Shipping_model::get_car_stock_id_by_chassis($trim_chassis);
        $data = array(
            'shipment_id' => $shipment_id,
            'booked_date' => date('Y-m-d H:i:s'),
            'car_etd' => $etd[0]->etd
        );
        $user = Auth::user();
        Shipping_model::add_ship_invoice_to_car($data,$trim_chassis);
        Status_update::update_releasebl_status($stock_id,$user->staff_id);
        return response()->json([
            'status' => true,
            'message' => 'successfully'
        ]);
    }

    public function delete_invoice_by_stock_id(Request $request){
        $stock_ids = $request->get('DataChecked');
        $arr_stock = explode(',',$stock_ids);
        $sql_param = array();
        $user = Auth::user();
        
        foreach($arr_stock as $stock_id){
            $data_stock = array(
             'shipment_id' => null,
             'booked_date' => null,
             'car_etd' => null
            ); 
            Shipping_model::update_stock_list($stock_id, $data_stock);
            Status_update::cancel_releasebl_status($stock_id,$user->staff_id);
        } 
        return response()->json([
            'status' => true,
            'message' => 'succesffully'
        ]);
    }
}