<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Income_model;
use Illuminate\Support\Facades\Auth;

class Status_update extends Controller
{
    public static function update_car_status($stock_id,$cus_id,$staff_id){
        $totalSoldPrice = 0;
        $totalSoldPriceCurrency = "";
        $totalAllocate = 0;
        $totalAllocateCurrency = "";
        $shipOkCondition = 100;
        $cus_allocate = Income_model::get_all_amount_customer_allocate($stock_id);
        $total_sell_price = Income_model::get_total_sell_price_from_stock($stock_id);
        $ship_ok_condition = Income_model::get_ship_ok_condition($cus_id);
        $car_status = Income_model::get_car_status_info($stock_id);

        if(count($cus_allocate) > 0){
            $totalAllocate = $cus_allocate[0]->car_allocate;
            $totalAllocateCurrency =  $cus_allocate[0]->car_allocate_currency;
        }
        if(count($total_sell_price) > 0){
            $totalSoldPrice = $total_sell_price[0]->selling_price;
            $totalSoldPriceCurrency = $total_sell_price[0]->currency;
        }
        if(!empty($ship_ok_condition[0]->payment_terms)){
            $shipOkCondition = $ship_ok_condition[0]->payment_terms;
        }

        if($totalSoldPrice > 0 && $totalAllocate > 0){
            $devide_percent = $shipOkCondition / 100;
            $cal_percent = $devide_percent * $totalSoldPrice;
            if(intval($totalAllocate) >= $cal_percent){
                if($car_status[0]->status < 7){
                    // update status to ship ok in stock list
                    $stock_arr = array('status' => '7');
                    Income_model::update_car_data($stock_arr,$stock_id);

                    // add shipok history
                    $status_arr = array(
                                    'stock_id'=>$stock_id,
                                    'car_status'=>'shipok',
                                    'create_date'=>date('Y-m-d H:i:s'),
                                    'staff_id'=>$staff_id
                                    );
                    Income_model::add_history_car($status_arr);
                }
            }
        }

    }

    public static function update_soldout_status($stock_id,$staff_id){
        $car_status = Income_model::get_car_status_info($stock_id);
        if(!empty($car_status[0]->dhl_number)){
            $dhl_num = $car_status[0]->dhl_number;
        }else{
            $dhl_num = "";
        }
           // check for update status to soldout
        if($car_status[0]->status == 8){
            if($dhl_num != ""){
                if($car_status[0]->status < 9){
                    // update status to soldout in stock list
                    $stock_arr_soldout = array('status' => '9');
                    Income_model::update_car_data($stock_arr_soldout,$stock_id);

                    // add soldout history
                    $status_arr_soldout = array(
                                    'stock_id'=>$stock_id,
                                    'car_status'=>'soldout',
                                    'create_date'=>date('Y-m-d H:i:s'),
                                    'staff_id'=>$staff_id
                                    );
                    Income_model::add_history_car($status_arr_soldout);
                }
            }
        }
    }

    public static function cancel_soldout_status($stock_id,$staff_id){
        $car_status =Income_model::get_car_status_info($stock_id);
        if(!empty($car_status[0]->dhl_number)){
            $dhl_num = $car_status[0]->dhl_number;
        }else{
            $dhl_num = "";
        }
        if($car_status[0]->status == 9){
            if($dhl_num == ""){
                // update status to releasebl in stock list
                $stock_arr_release = array('status' => '8');
                Income_model::update_car_data($stock_arr_release,$stock_id);

                // add releasebl history
                $status_arr_release = array(
                                'stock_id'=>$stock_id,
                                'car_status'=>'releasebl',
                                'create_date'=>date('Y-m-d H:i:s'),
                                'staff_id'=>$staff_id
                                );
                Income_model::add_history_car($status_arr_release);
            }
        }
    }

    public static function update_releasebl_status($stock_id,$staff_id){
        $totalSoldPrice = 0;
        $totalSoldPriceCurrency = "";
        $totalAllocate = 0;
        $totalAllocateCurrency = "";
        $shipOkCondition = 100;

        $cus_allocate = Income_model::get_all_amount_customer_allocate($stock_id);
        $total_sell_price = Income_model::get_total_sell_price_from_stock($stock_id);
        $car_status = Income_model::get_car_status_info($stock_id);

        if(count($cus_allocate) > 0){
            $totalAllocate = $cus_allocate[0]->car_allocate;
            $totalAllocateCurrency =  $cus_allocate[0]->car_allocate_currency;
        }
        if(count($total_sell_price) > 0){
            $totalSoldPrice = $total_sell_price[0]->selling_price;
            $totalSoldPriceCurrency = $total_sell_price[0]->currency;
        }

   

        // check for update status to release bl
        if($car_status[0]->etd!='' || $car_status[0]->etd!= NULL){
            $current_date = date('Y-m-d');
            // check update car status to release bl if car equal status shipok and etd >= current date and full payment can update
            $time = strtotime($car_status[0]->etd);
            $etd = date('Y-m-d',$time);
            if($current_date >=  $etd){
                if($totalSoldPrice > 0 && $totalAllocate > 0){
                    if(intval($totalAllocate) == intval($totalSoldPrice)){
                        if($car_status[0]->status < 8){
                            // update status to releasebl in stock list
                            $stock_arr_release = array('status' => '8');
                            $Income_model::update_car_data($stock_arr_release,$stock_id);

                            // add releasebl history
                            $status_arr_release = array(
                                            'stock_id'=>$stock_id,
                                            'car_status'=>'releasebl',
                                            'create_date'=>date('Y-m-d H:i:s'),
                                            'staff_id'=>$staff_id
                                            );
                            Income_model::add_history_car($status_arr_release);
                        }
                    }  
                }
            }
        }
    }

    public static function cancel_releasebl_status($stock_id,$staff_id){
        $totalSoldPrice = 0;
        $totalSoldPriceCurrency = "";
        $totalAllocate = 0;
        $totalAllocateCurrency = "";
        $shipOkCondition = 100;
        $cus_allocate = Income_model::get_all_amount_customer_allocate($stock_id);
        $total_sell_price = Income_model::get_total_sell_price_from_stock($stock_id);
        $car_status = Income_model::get_car_status_info($stock_id);
        if(count($cus_allocate) > 0){
            $totalAllocate = $cus_allocate[0]->car_allocate;
            $totalAllocateCurrency =  $cus_allocate[0]->car_allocate_currency;
        }
        if(count($total_sell_price) > 0){
            $totalSoldPrice = $total_sell_price[0]->selling_price;
            $totalSoldPriceCurrency = $total_sell_price[0]->currency;
        }
        if($car_status[0]->status == 8){
            if(empty($car_status[0]->shipment_id)){
                // update status to releasebl in stock list
                $stock_arr_release = array('status' => '7');
                Income_model::update_car_data($stock_arr_release,$stock_id);

                // add releasebl history
                $status_arr_release = array(
                                'stock_id'=>$stock_id,
                                'car_status'=>'Shipok',
                                'create_date'=>date('Y-m-d H:i:s'),
                                'staff_id'=>$staff_id
                                );
                Income_model::add_history_car($status_arr_release);
            }
        }
    }

    public static function update_car_status_car_reserve($stock_id,$cus_id,$staff_id){
        $totalSoldPrice = 0;
        $totalSoldPriceCurrency = "";
        $totalAllocate = 0;
        $totalAllocateCurrency = "";
        $shipOkCondition = 100;
        $cus_allocate = Income_model::get_all_amount_customer_allocate($stock_id);
        $total_sell_price = Income_model::get_total_sell_price_from_stock($stock_id);
        $ship_ok_condition = Income_model::get_ship_ok_condition($cus_id);
        $car_status = Income_model::get_car_status_info($stock_id);

        if(count($cus_allocate) > 0){
            $totalAllocate = $cus_allocate[0]->car_allocate;
            $totalAllocateCurrency =  $cus_allocate[0]->car_allocate_currency;
        }
        if(count($total_sell_price) > 0){
            $totalSoldPrice = $total_sell_price[0]->selling_price;
            $totalSoldPriceCurrency = $total_sell_price[0]->currency;
        }
        if(!empty($ship_ok_condition[0]->payment_terms)){
            $shipOkCondition = $ship_ok_condition[0]->payment_terms;
        }

        if($totalSoldPrice > 0 && $totalAllocate > 0){
            $devide_percent = $shipOkCondition / 100;
            $cal_percent = $devide_percent * $totalSoldPrice;
            if(intval($totalAllocate) >= $cal_percent){
                if($car_status[0]->status < 7){
                    // update status to ship ok in stock list
                    $stock_arr = array('status' => '7');
                    Income_model::update_car_data($stock_arr,$stock_id);

                    // add shipok history
                    $status_arr = array(
                                    'stock_id'=>$stock_id,
                                    'car_status'=>'shipok',
                                    'create_date'=>date('Y-m-d H:i:s'),
                                    'staff_id'=>$staff_id
                                    );
                    Income_model::add_history_car($status_arr);
                }
            }
        }

    }
}
