<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\Stocklist_model;
use App\Models\Invoice_model;
use App\Models\Income_model;
use App\Models\Expenses_model;
use App\Http\Controllers\Status_update;
use Illuminate\Support\Facades\Storage;
use Intervention\Image\ImageManager;
use Intervention\Image\Drivers\Gd\Driver;
use Illuminate\Support\Facades\Auth;
use File;
use ZipArchive;
use PDF;
use App\Jobs\ExportExcelStock;
use App\Jobs\ExportExcelStockForwarding;
use App\Jobs\ExportExcelTransportation;
use App\Jobs\ExportExcelSoldOut;
use App\Jobs\ExportExcelStaff;
use App\Jobs\ExportExcelCarAllocation;
use Illuminate\Support\Facades\Bus;
use Illuminate\Bus\Batchable;
use Illuminate\Bus\Batch;
use Illuminate\Support\Facades\Response;

class Stock_list extends Controller
{
    public function index(Request $request){
        $perPage = $request->get('perPage');
        $purpose = $request->get('purpose');
        $car_status = $request->get('car_status');
        $car_mark = $request->get('car_mark');
        $search_car_document = $request->get('search_car_document');
        $purchase_name = $request->get('purchase_name');
        $location = $request->get('location');
        $car_model = $request->get('car_model');
        $shipok_status = $request->get('shipok_status');
        $shipout_status = $request->get('shipout_status');
        $soldout_status = $request->get('soldout_status');
        $search_reexport = $request->get('search_reexport');
        $search_re_export = $request->get('search_re_export');
        $ec_status = $request->get('ec_status');
        $city = $request->get('city');
        $booking_status = $request->get('booking_status');
        $search_yard_photo1 = $request->get('search_yard_photo1');
        $search_cus = $request->get('search_cus');
        $yard = $request->get('yard');
        $from_year_model = $request->get('from_year_model');
        $to_year_model = $request->get('to_year_model');
        $releasebl_status = $request->get('releasebl_status');
        $search_yard_photo2 = $request->get('search_yard_photo2');
        $searchSales = $request->get('searchSales');
        $color = $request->get('color');
        $search_option = $request->get('search_option');
        $search_boxs = trim($request->get('search_boxs'));
        $recycle_ok_status = $request->get('recycle_ok_status');
        $market = $request->get('market');
        $where=array();
        $where_manul = "a.car_stock_id <> ''";
        $status_join ="";
                if(!empty($purpose)){
                    $where['a.purpose'] = $purpose;
                }
                if(!empty($car_status)){
                    $where['a.status'] = $car_status;
                }
                if(!empty($car_mark)){
                    $where['a.car_make_en'] = $car_mark;
                }
                if(!empty($search_car_document)){
                   if($search_car_document =="Y"){
                        $where['a.car_documents'] ="y";
                   }else{
                        $where_manul .= " AND (a.car_documents <> 'y' OR a.car_documents IS NULL) ";
                   }
                }
                if(!empty($purchase_name)){
                    $where['a.purchaser'] =  $purchase_name;
                }
                if(!empty($location)){
                    $where['a.car_location_en'] = $location;//
                }
                if(!empty($car_model)){
                    $where['a.car_model_en'] = $car_model;//
                }
                if(!empty($shipok_status)){
                    if($shipok_status=="already"){
                        $where['a.status'] = '7';
                    }else{
                        $where_manul .= " AND (a.status < '7') ";//
                    }
                   
                }

                if(!empty($market)){
                    $where['a.car_market_en'] = $market;
                }
                
                if(!empty($shipout_status)){
                    if($shipout_status=="already"){
                        $where_manul .= "AND (sh.etd <= '".date("Y-m-d")."')";
                    }else{
                        $where_manul .= "AND sh.etd >='".date("Y-m-d")."' OR sh.etd IS NULL";//
                    }
                }
                if(!empty($soldout_status)){
                    if($soldout_status=="already"){
                        $where['a.status'] = '9';
                    }else{
                        $where_manul .= " AND (a.status < '9') ";//
                    }  
                }
                if(!empty($search_reexport)){
                    $where['a.car_reexport'] = $search_reexport;//
                }
                if(!empty($search_re_export)){
                    if($search_re_export == "yes"){
                        $where_manul .= "AND ( `a`.`car_reexport` is not NULL and a.car_reexport > 0 AND date(shd.etd) <= '".date('Y-m-d')."')";
                    }
                    if($search_re_export == "no"){
                        $where_manul .= "AND (date(shd.etd) > '".date('Y-m-d')."' OR shd.etd IS NULL)";//
                    }
                }
                if(!empty($ec_status)){
                    if ($ec_status=='notyet') {
                        $where_manul .= " AND (doc.doc_type IS NULL)";
                    }else{
                        $where_manul .= " AND ( doc.doc_type  IN ('ec','ecj','ece')) ";//
                        
                    }
                }
                if(!empty($city)){
                    $where['a.car_city_en'] = $city;//
                }
   
                if(!empty($booking_status)){
                    if($booking_status=="already"){
                        $where_manul .= " AND (a.shipment_id <> '')";//
                
                    }else{
                        $where_manul .= " AND (a.shipment_id IS NULL)";//
                    }
                }
                if(!empty($search_yard_photo1)){
                    if($search_yard_photo1=="yes"){
                        $where_manul .= " AND (a.car_yard_photo <> '')";//
                    }else{
                        $where_manul .= " AND (a.car_yard_photo IS NULL)"; //
                    }
                }
                if(!empty($search_cus)){
                    $where['a.customer_id'] = $search_cus;//
                }
                if(!empty($recycle_ok_status)){
                    if($recycle_ok_status=="already"){
                        $where['a.recycle_ok']= "Y";
                    }else{
                        $where_manul .= " AND (a.recycle_ok <> 'Y' OR a.recycle_ok IS NULL) ";//
                    }
                }
                if(!empty($yard)){
                    $where['k.stock_yard_name'] = $yard;//
                }

                if(!empty($from_year_model)){
                    $where_manul .= " AND (a.car_model_year >= '".$from_year_model."' ) ";//
                }

                if($to_year_model){
                    $where_manul .= " AND (a.car_model_year <= '".$to_year_model."' ) ";//
                }
              
                if($releasebl_status){
                    if($releasebl_status=="already"){
                        $where['a.status']='8';
                    }else{
                        $where_manul .= " AND (a.status < 8) ";//
                    }
                }
                if($search_yard_photo2){
                    if($search_yard_photo2=="yes"){
                        $where_manul .= " AND ( a.car_yard_photo_two <> '' )";//
                    }else{
                        $where_manul .= " AND ( a.car_yard_photo_two IS NULL )";//
                    }
                }
               
                if($searchSales){
                    $where['cus.staff_id'] = $searchSales;//
                }
                if($color){
                    $where['a.color'] = $color;
                }
                if($search_option){
                    if($search_boxs){
                        if($search_option == "chassisno"){
                            $where_manul .= " AND (a.chassis_number LIKE '%".$search_boxs."%')";//
                        }else if($search_option == "stockno"){
                            $con_stock = "";
                            $stock_ex = explode(" ",$search_boxs);
                            foreach ($stock_ex as $val) {
                                $con_stock .= "'".$val."',";
                            }
                            $where_manul .= " AND ( a.stock_id IN(".trim($con_stock,",").") )";
                        }else  if($search_option == "invoice_no"){
                            $where['a.invoice_no'] = $search_boxs;
                        }else  if($search_option == "proforma_invoice_no"){
                            $where['a.invoice_id']= $search_boxs;
                        }else if($search_option == "order_id"){
                            $where['a.order_id'] = $search_boxs;
                        }
                    }
                }
                $start_date = $request->get('search_date_starts1');
                $end_date = $request->get('search_date_ends1');
                $rang_date_option = $request->get('rang_date_option');
                if(!empty($start_date) || !empty($end_date)){

                    if($rang_date_option == "buying_date"){
                        if(!empty($start_date) && !empty($end_date))
                           $where_manul .= " AND ( date(a.buying_date) >= '".$start_date."' AND  date(a.buying_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                           $where_manul .= " AND ( date(a.buying_date) >= '".$start_date."' ' )";
                        else
                            $where_manul .= " AND ( date(a.buying_date) <= '".$end_date."' )";
                    }elseif($rang_date_option == "reserved"){
                        $where['a.status']= "2";
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($rang_date_option == "shipok"){
                        $where['a.status']='7';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($rang_date_option == "releasebl"){
                        $where['a.status']='8';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($rang_date_option == "soldout"){
                        $where['a.status']='9';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($rang_date_option == "etd_re_export"){
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(shd.etd) >= '".$start_date."' AND  date(shd.etd) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(shd.etd) >= '".$start_date."' )";
                        else
                            $where_manul .= " AND ( date(shd.etd) <= '".$end_date."' )";  
                    }elseif($rang_date_option == "etd"){
                       
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(sh.etd) >= '".$start_date."' AND  date(sh.etd) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(sh.etd) >= '".$start_date."' )";
                        else
                            $where_manul .= " AND ( date(sh.etd) <= '".$end_date."' )";
                        }        
                }    
        $erp_stock_list_doc = DB::table('erp_stock_list_doc')
                              ->select('*')
                              ->whereIn('doc_type',['ec','ecj','ece'])
                              ->groupBy('stock_id')->toRawSql();
        $his_tbl_filter = " SELECT * FROM `erp_cars_status_history` WHERE car_status_id IN ( SELECT MAX(car_status_id) FROM `erp_cars_status_history` GROUP BY stock_id) ";
        $data = DB::table('erp_stock_list as a')
                ->select('e.*','sh.*','cus.*','st.full_name AS sale_name','cus.full_name AS cus_name',
                'doc.doc_type','k.stock_yard_name','scl.stock_city_name','a.*')
                ->leftjoin('erp_stock_list_car_status As e','e.stock_list_car_status_id','=','a.status')
                ->leftjoin('erp_shipments AS sh','sh.shipment_id','=','a.shipment_id')
                ->leftjoin('erp_shipments_dubai AS shd','shd.shipment_id','=','a.shipment_dubia_id')
                ->leftjoin('erp_customer AS cus','cus.customer_id','=','a.customer_id')
                ->leftjoin('erp_staff AS st','cus.staff_id','=','st.staff_id')
                ->leftjoin(DB::raw('('.$erp_stock_list_doc.') AS doc'), 'doc.stock_id','=','a.stock_id')
                ->when($status_join == "show",function ($v) use ($his_tbl_filter) {
                    $v->leftjoin(DB::raw('('.$his_tbl_filter.') AS his'), 'his.stock_id','=','a.stock_id');
                })
                ->leftjoin('erp_car_color AS color','color.color_id','=','a.color')
                ->leftjoin('erp_stock_yard_location AS k','k.stock_yard_id','=','a.stock_yard_id')
                ->leftjoin('erp_stock_city_location AS scl','scl.stock_city_id','=','a.stock_city_id')
                ->leftjoin('erp_stock_city_location AS l','l.stock_city_id','=','a.stock_city_id')
                ->whereRaw(DB::raw($where_manul))
                ->where($where)
                ->orderBy('a.status', 'ASC')
                ->orderBy('a.buying_date','DESC')
                ->paginate($perPage);
                return response()->json([
                    'stock_list_data' => $data
                ], 200);
    }

    public function GetTotal(Request $request){
        $search = $request->get('search_data');
        $check = is_array(json_decode($search)) ? count(json_decode($search)) : 0;
        $where=array();
        $where_manul = "a.car_stock_id <> ''";
        $status_join ="";
        if($check > 0){
            foreach(json_decode($search) as $item){
                if($item->purpose){
                    $where['a.purpose'] = $item->purpose;//
                }
                if($item->car_status){
                    $where['a.status'] = $item->car_status;//
                }
                if($item->car_mark){
                    $where['a.car_make_en'] = $item->car_mark;//
                }
                if($item->search_car_document){
                   if($item->search_car_document =="Y"){
                        $where['a.car_documents'] ="y";
                   }else{
                            $where_manul .= " AND (a.car_documents <> 'y' OR a.car_documents IS NULL) ";
                   }
                }
                if($item->purchase_name){
                    $where['a.purchaser'] = $item->purchase_name;//
                }
                if($item->location){
                    $where['a.car_location_en'] = $item->location;//
                }
                if($item->car_model){
                    $where['a.car_model_en'] = $item->car_model;//
                }
                if($item->shipok_status){
                    if($item->shipok_status=="already"){
                        $where['a.status'] = '7';
                    }else{
                        $where_manul .= " AND (a.status < '7') ";//
                    }
                   
                }
                
                if($item->shipout_status){
                    if($item->shipout_status=="already"){
                        $where_manul .= "AND (sh.etd <= '".date("Y-m-d")."')";
                    }else{
                        $where_manul .= "AND sh.etd >='".date("Y-m-d")."' OR sh.etd IS NULL";//
                    }
                }
                if($item->soldout_status){
                    if($item->soldout_status=="already"){
                        $where['a.status'] = '9';
                    }else{
                        $where_manul .= " AND (a.status < '9') ";//
                    }  
                }
                if($item->search_reexport){
                    $where['a.car_reexport'] = $item->search_reexport;//
                }
                if($item->search_re_export){
                    if($item->search_re_export == "yes"){
                        $where_manul .= "AND ( `a`.`car_reexport` is not NULL and a.car_reexport > 0 AND date(shd.etd) <= '".date('Y-m-d')."')";
                    }
                    if($item->search_re_export == "no"){
                        $where_manul .= "AND (date(shd.etd) > '".date('Y-m-d')."' OR shd.etd IS NULL)";//
                    }
                }
                if($item->ec_status){
                    if ($item->ec_status=='notyet') {
                        $where_manul .= " AND (doc.doc_type IS NULL)";
                    }else{
                        $where_manul .= " AND ( doc.doc_type  IN ('ec','ecj','ece')) ";//
                        
                    }
                }
                if($item->city){
                    $where['a.car_city_en'] = $item->city;//
                }
                if($item->booking_status){
                    if($item->booking_status=="already"){
                        $where_manul .= " AND (a.shipment_id <> '')";//
                
                    }else{
                        $where_manul .= " AND (a.shipment_id IS NULL)";//
                    }
                }
                if($item->search_yard_photo1){
                    if($item->search_yard_photo1=="yes"){
                        $where_manul .= " AND (a.car_yard_photo <> '')";//
                    }else{
                        $where_manul .= " AND (a.car_yard_photo IS NULL)"; //
                    }
                }
                if($item->search_cus){
                    $where['a.customer_id'] = $item->search_cus;//
                }
                if($item->recycle_ok_status){
                    if($item->recycle_ok_status=="already"){
                        $where['a.recycle_ok']= "Y";
                    }else{
                        $where_manul .= " AND (a.recycle_ok <> 'Y' OR a.recycle_ok IS NULL) ";//
                    }
                }
                if($item->yard){
                    $where['k.stock_yard_name'] = $item->yard;//
                }

                if($item->from_year_model){
                    $where_manul .= " AND (a.car_model_year >= '".$item->from_year_model."' ) ";//
                }

                if($item->to_year_model){
                    $where_manul .= " AND (a.car_model_year <= '".$item->to_year_model."' ) ";//
                }
              
                if($item->releasebl_status){
                    if($item->releasebl_status=="already"){
                        $where['a.status']='8';
                    }else{
                        $where_manul .= " AND (a.status < 8) ";//
                    }
                }
                if($item->search_yard_photo2){
                    if($item->search_yard_photo2=="yes"){
                        $where_manul .= " AND ( a.car_yard_photo_two <> '' )";//
                    }else{
                        $where_manul .= " AND ( a.car_yard_photo_two IS NULL )";//
                    }
                }
                if($item->searchSales){
                    $where['cus.staff_id'] = $item->searchSales;//
                }
                if($item->color){
                    $where['a.color'] = $item->color;
                }
                $search_option = $item->search_option;
                if($search_option){
                    if($item->search_boxs){
                        if($search_option == "chassisno"){
                            $where_manul .= " AND (a.chassis_number LIKE '%".$item->search_boxs."%')";//
                        }else if($search_option == "stockno"){
                            $con_stock = "";
                            $stock_ex = explode(" ",$item->search_boxs);
                            foreach ($stock_ex as $val) {
                                $con_stock .= "'".$val."',";
                            }
                            $where_manul .= " AND ( a.stock_id IN(".trim($con_stock,",").") )";
                        }else  if($search_option == "invoice_no"){
                            $where['a.invoice_no'] = $item->search_boxs;
                        }else  if($search_option == "proforma_invoice_no"){
                            $where['a.invoice_id']= $item->search_boxs;
                        }else if($search_option == "order_id"){
                            $where['a.order_id'] = $item->search_boxs;
                        }
                    }
                }
                $start_date = $item->search_date_starts;
                $end_date = $item->search_date_ends;
                if(!empty($start_date) || !empty($end_date)){

                    if($item->rang_date_option == "buying_date"){
                        if(!empty($start_date) && !empty($end_date))
                           $where_manul .= " AND ( date(a.buying_date) >= '".$start_date."' AND  date(a.buying_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                           $where_manul .= " AND ( date(a.buying_date) >= '".$start_date."' ' )";
                        else
                            $where_manul .= " AND ( date(a.buying_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "reserved"){
                        $where['a.status']= "2";
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "shipok"){
                        $where['a.status']='7';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "releasebl"){
                        $where['a.status']='8';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "soldout"){
                        $where['a.status']='9';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "etd_re_export"){
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(shd.etd) >= '".$start_date."' AND  date(shd.etd) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(shd.etd) >= '".$start_date."' )";
                        else
                            $where_manul .= " AND ( date(shd.etd) <= '".$end_date."' )";  
                    }elseif($item->rang_date_option == "etd"){
                       
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(sh.etd) >= '".$start_date."' AND  date(sh.etd) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(sh.etd) >= '".$start_date."' )";
                        else
                            $where_manul .= " AND ( date(sh.etd) <= '".$end_date."' )";
                        }        
                }
              } 
        }
        
        $erp_stock_list_doc = DB::table('erp_stock_list_doc')
                              ->select('*')
                              ->whereIn('doc_type',['ec','ecj','ece'])
                              ->groupBy('stock_id')->toRawSql();
        $his_tbl_filter = " SELECT * FROM `erp_cars_status_history` WHERE car_status_id IN ( SELECT MAX(car_status_id) FROM `erp_cars_status_history` GROUP BY stock_id) ";
        $data = DB::table('erp_stock_list as a')
                ->select(DB::raw("COUNT('a.*') AS total_car"))
                ->leftjoin('erp_stock_list_car_status As e','e.stock_list_car_status_id','=','a.status')
                ->leftjoin('erp_shipments AS sh','sh.shipment_id','=','a.shipment_id')
                ->leftjoin('erp_shipments_dubai AS shd','shd.shipment_id','=','a.shipment_dubia_id')
                ->leftjoin('erp_customer AS cus','cus.customer_id','=','a.customer_id')
                ->leftjoin('erp_staff AS st','cus.staff_id','=','st.staff_id')
                ->leftjoin(DB::raw('('.$erp_stock_list_doc.') AS doc'), 'doc.stock_id','=','a.stock_id')
                ->when($status_join == "show",function ($v) use ($his_tbl_filter) {
                    $v->leftjoin(DB::raw('('.$his_tbl_filter.') AS his'), 'his.stock_id','=','a.stock_id');
                })
                ->leftjoin('erp_car_color AS color','color.color_id','=','a.color')
                ->leftjoin('erp_stock_yard_location AS k','k.stock_yard_id','=','a.stock_yard_id')
                ->leftjoin('erp_stock_city_location AS scl','scl.stock_city_id','=','a.stock_city_id')
                ->leftjoin('erp_stock_city_location AS l','l.stock_city_id','=','a.stock_city_id')
            
                ->whereRaw(DB::raw($where_manul))
                ->where($where)
                ->orderBy('a.status', 'ASC')
                ->orderBy('a.buying_date','DESC')
                // ->toRawSql();  
                ->get();
                return response()->json([
                    'total_car' => $data
                ], 200);
    }
    public function GetMake(){
        $data = DB::table('erp_car_make')
                ->select('*')
                ->groupBy('car_make_id')
                ->orderBy('car_make_name','ASC')
                ->get();
        return response()->json([
            'Marks' => $data
        ],200);

    }

    public function get_car_status(){
        $data = DB::table('erp_stock_list_car_status')
                ->select('*')
                ->orderBy('stock_list_car_status_id','ASC')
                ->get();
        return response()->json([
            'CarStatus' => $data
        ],200);
    }

    public function getPurchaser(){
        $data = DB::table('erp_stock_list')
                ->select('purchaser')
                ->whereNotNull('purchaser')
                ->whereIn('purchaser',['RU- JAPAN','yamagin'])
                ->groupBy('purchaser')
                ->get();
        return response()->json([
            'Purchasers' => $data
        ],200);
    }

    public function get_car_location_country(){
        $data = DB::table('erp_stock_country_location')
                ->select('country_name','stock_location_id','erp_country_list.country_list_id')
                ->leftjoin('erp_country_list','erp_country_list.country_list_id','=','erp_stock_country_location.country_list_id')
                ->get();
        return response()->json([
            "Countries" => $data
        ]);
    }

    public function get_car_model(){
        $data = DB::table('erp_car_model')
                ->select('*')
                ->leftjoin('erp_stock_list','erp_stock_list.car_model_id','=','erp_car_model.car_model_id')
                ->groupBy('erp_car_model.car_model_id')
                ->orderBy('erp_car_model.car_model_name','ASC')
                ->get();
        return response()->json([
            'CarModels' => $data
        ],200);
    }

    function ChangeCarModel(Request $request){
        $model_id = $request->get('model_id');
        $data = DB::table('erp_car_model')
        ->select('erp_car_model.*')
        ->leftjoin('erp_stock_list','erp_stock_list.car_model_id','=','erp_car_model.car_model_id')
        ->where("erp_car_model.car_make_id",'=',$model_id)
        ->groupBy('erp_car_model.car_model_id')
        ->get();
        return response()->json([
            'CarModels' => $data
        ],200);
    }

    public function get_car_city(){
        $data = DB::table('erp_stock_city_location')
                ->select('*')
                ->orderBy('stock_city_name','ASC')
                ->get();
        return response()->json([
            'GetCity' => $data
        ], 200);
    }

    public function get_customer_info(){
        // $show = array();
        // if(!empty($this->session->userdata('hide_pakistan_only'))){
        //         foreach ($this->get_country_list_id_block() as $key => $value) {
        //                 array_push($show, strtolower($value->country_list_id));
        //         }
        //  }
        // if(!empty($this->session->userdata('hide_paragay_only'))){
        //         foreach ($this->get_country_list_for_paragay() as $key => $value) {
        //                 array_push($show, strtolower($value->country_list_id));
        //         }
        //  }
        $data = DB::table('erp_customer AS a')
                ->select('a.*')
                ->leftjoin('erp_staff AS b','b.staff_id','=','a.staff_id')
                ->where('a.full_name','<>','')
                ->orderBy('a.full_name','ASC')
                ->get();
        return response()->json([
            'GetCustomer' => $data
        ],200);
        // if(!empty($this->session->userdata('hide_pakistan_only'))){
        //     $this->db->where_in('b.country_list_id',$show);
        //     }
        //     if(!empty($this->session->userdata('hide_paragay_only'))){
        //     $this->db->where_in('b.country_list_id',$show);
        //     }
    }
    public function get_car_yard(){
        $data = DB::table('erp_stock_yard_location')
                ->select('*')
                ->orderBy('stock_yard_name','ASC')
                ->get();
        return response()->json([
            'GetCarYard' => $data
        ],200);
    }
    public function select_sales(){
        $data = DB::table('erp_staff AS st')
                ->select('st.full_name','cs.customer_id AS cus_id','st.staff_id AS sale_id')
                ->leftjoin('erp_customer AS cs','cs.staff_id','=','st.staff_id')
                ->where('st.full_name','<>','')
                ->groupBy('sale_id')
                ->orderBy('st.full_name','ASC')
                ->get();
        return response()->json([
            'GetSales' => $data
        ],200);
    }
    public function get_car_market_country(){
        $data = DB::table('erp_market_country')
                ->select('country_name','market_country_id','erp_country_list.country_list_id')
                ->leftjoin('erp_country_list','erp_country_list.country_list_id','=','erp_market_country.country_list_id')
                ->orderBy('country_name','ASC')
                ->get();
        return response()->json([
            'GetMarkets'=>$data
        ],200);
    }

    public function getCarColors(){
        $data = DB::table('erp_car_color')
                ->select('*')
                ->where('color_name','<>','')
                ->whereNotNull('color_name')
                ->orderBy('color_name','ASC')
                ->get();
        return response()->json([
            'GetColor' =>$data
        ],200);

    }
    public function UpdateRecycleOk(Request $request){
        $recycle = $request->get('recycle');
        $stock_dis = $request->get('dataChecked');
        $arr_stock = explode(',',$stock_dis);
       foreach($arr_stock as $stock){
          DB::table('erp_stock_list')
            ->where('stock_id','=',$stock)
            ->update(['recycle_ok' => $recycle ]);
       } 
       return 'Add Recycle Ok successfully.';
    }
    public function GetStockType(){
        $data = DB::table('erp_stock_type')
                ->select('*')
                ->get();
        return response()->json([
            'StockType' =>$data
        ],200);
    }
    public function GetMarketCountry(){
        $data = DB::table('erp_market_country AS a')
                ->select('*')
                ->leftjoin('erp_country_list AS b','b.country_list_id','=','a.country_list_id')
                ->orderBy('b.country_name','ASC')
                ->get();
                return response()->json([
                    'MarketCountry' => $data
                ], 200);
    }

    public function AddCity(Request $request){
        $city_name = $request->get('city_name');
        $country_location = $request->get('country_location');
        $data = array(
            'stock_location_id' => $country_location,
            'stock_city_name' => $city_name,   
        );

        DB::table('erp_stock_city_location')
          ->insert($data);
        return 'City has been create successfully!';
    }

    public function get_city_with_location(Request $request){
        $location = $request->get('country_location');
        $data = DB::table('erp_stock_city_location')
        ->select('*')
        ->where('stock_location_id','=',$location)
        ->orderBy('stock_city_name','ASC')
        ->get();
        return response()->json([
            'GetCity' => $data
        ], 200);
    }

    public function Get_Yard(Request $request){
        $city_id = $request->get('city_id');
        $data = DB::table('erp_stock_yard_location')
        ->select('*')
        ->where('stock_city_id','=',$city_id)
        ->orderBy('stock_yard_name','ASC')
        ->get();
        return response()->json([
            'GetCarYard' => $data
        ],200);
    }

    public function Add_Yard(Request $request){
        $yard_name = $request->get('yard_name');
        $city_location = $request->get('city_location');
        $data = array(
            'stock_city_id' => $city_location,
            'stock_yard_name' => $yard_name,   
        );

        DB::table('erp_stock_yard_location')
          ->insert($data);
        return 'Yard has been create successfully!';
    }

    public function Add_Make(Request $request){
        $make_name = $request->get('make_name');
        $data = DB::table('erp_car_make')
                ->where('car_make_name','=',$make_name)
                ->get();
        if(COUNT($data) == 0){
            $where = array(
                'car_make_name'=>$make_name
            );
            DB::table('erp_car_make')
              ->insert($where);
          return 'Make has been create successfully!';
        }
        return 'This Make have already!';
    }

    public function Add_Mdoel(Request $request){
        $txt_model = $request->get('txt_model');
        $make_id = $request->get('make_id');

        $data = DB::table('erp_car_model')
                ->where('car_make_id','=',$make_id)
                ->where('car_model_name','=',$txt_model)
                ->get();
        if(COUNT($data) == 0){
            $where = array(
                'car_model_name'=>$txt_model,
                'car_make_id' =>$make_id
            );
            DB::table('erp_car_model')
              ->insert($where);
          return 'Model has been create successfully!';
        }
        return 'This Model have already!';

    }

    public function Add_Color(Request $request){
        $txt_color = $request->get('txt_color');
            $where = array(
                'color_name'=>$txt_color
            );
            DB::table('erp_car_color')
              ->insert($where);
          return 'Color has been create successfully!';
    }

    public function Get_Discharge(){
        $data = DB::table('erp_discharge')
                ->select('*')
                ->orderBy('discharge_id','ASC')
                ->get();
        return response()->json([
            'DischargeData' => $data
        ],200);
    }

    public function Check_Chassis(Request $request){
         $car_chassis = $request->get('car_chassis');
         $data = DB::table('erp_stock_list')
                   ->select(DB::raw("COUNT(*) AS numrows"))
                   ->where('chassis_number','=',$car_chassis)
                   ->get();
        if($data[0]->numrows == 0){
            return true;
        }
        return false;
    }

    public function insert_draft(){
        $stock_id = Stocklist_model::insert_draft();
        return response()->json([
            'stock_ids' => $stock_id
        ],200);
    }

    public function SaveData(Request $request){
        // $car_info = $request->get('car_info');
        // foreach(json_decode($car_info) as $item){
            $stock_id =  $request->get('stock_id');

           //Check Car Image
            $get_pic_yard = Stocklist_model::select_photo_yard($stock_id);
            $get_pic_yard_two = Stocklist_model::select_photo_yard_two($stock_id);
            $get_pic_auction = Stocklist_model::select_photo_auction($stock_id);
            $car_marketcountry_id = '';
            $car_marketcountry_en = '';
            $car_make_id ='';
            $car_make_en ='';
            $status = '';
            $status_en = '';
            $city_location_id = '';
            $city_location_en = '';
            $country_location_id = '';
            $country_location_en = '';
            $yard_location_id = '';
            $yard_location_en = '';

            if(!empty( $request->get('car_marketcountry'))){
                $car_marketcountry_id = explode(':', @$request->get('car_marketcountry'))[0];
                $car_marketcountry_en = explode(':', @$request->get('car_marketcountry'))[1];
                if($car_marketcountry_id !='247'){
                    $reexport =  NULL;
                    $data ['car_reexport'] = $request->get('reexport');
                }
            }
            if(!empty($request->get('car_make'))){
                $car_make_id = explode(':', @$request->get('car_make'))[0];
                $car_make_en = explode(':', @$request->get('car_make'))[1];
            }
            if(!empty($request->get('car_model'))){
                $car_model_id = explode(':', @$request->get('car_model'))[0];
                $car_model_en = explode(':', $request->get('car_model'))[1];
            }
            if(!empty($request->get('car_status'))){
                $status = explode(':', @$request->get('car_status'))[0];
                $status_en = explode(':', @$request->get('car_status'))[1];
            }
            if(!empty($request->get('city_location'))){
                $city_location_id = explode(':', @$request->get('city_location'))[0];
                $city_location_en = explode(':', @$request->get('city_location'))[1];
            }
            if(!empty($request->get('country_location'))){
                $country_location_id = explode(':', @$request->get('country_location'))[0];
                $country_location_en = explode(':', @$request->get('country_location'))[1];
            }
            if(!empty($request->get('yard_location'))){
                $yard_location_id = explode(':', @$request->get('yard_location'))[0];
                $yard_location_en = explode(':', @$request->get('yard_location'))[1];
            }

            $user = Auth::user();
            //get prev data in stock list
            $get_car_info = Stocklist_model::select_data_stock_list($stock_id);
            $car_model_year = $request->get('car_year');
            $grade = $request->get('car_grade');
            $yard_date =  @$request->get('yard_date');
            $chassis_number = $request->get('car_chassis');
            $engine_size = $request->get('engine_size');
            $car_of_month = $request->get('car_of_month');
            $car_of_year =  $request->get('car_of_year');
            $auction_supplier = @$request->get('car_auction_supplier');
            $auction_lot = $request->get('car_auctionlot');
            $purchaser = $request->get('car_purchase');
            $mileage = $request->get('car_mileage');
            $color = $request->get('car_color');
            $stock_type_id = $request->get('car_stock_type');
            $buying_date = $request->get('car_buying_date');
            $memo_for_web = $request->get('car_memo_for_web');
            $memo_for_erp = $request->get('car_memo_for_erp');
            $notify_party = $request->get('car_notify_party');
            $car_length = $request->get('car_length');
            $car_width = $request->get('car_width');
            $car_height = $request->get('car_height');
            $car_weight = $request->get('car_weight');
            $consignee_name = @$request->get('car_consignee_name');
            $consignee_address = @$request->get('car_consignee_address');
            $consignee_phone = @$request->get('car_consignee_phone');
            $consignee_other_info = @$request->get('car_consignee_other');
            $car_body_type = $request->get('car_body_type');
            $car_fuel = $request->get('car_fuel');
            $car_discount = $request->get('car_discount');
            $transimission = $request->get('car_transimission');
            $seats = $request->get('car_seats');
            $drive_type = $request->get('car_drive_type');
            $hour = @$request->get('car_hour');
            $tons = @$request->get('car_tons');
            $purpose = $request->get('purpose');
            $recycle_ok = $request->get('car_recycleok');
            $inspection_certificate_ok = @$request->get('car_inspection_certificate');
            $inspection_booked = $request->get('car_inspection_booked');
            $inspection_result = $request->get('car_inspection_result');
            $inspection_date = $request->get('car_inspection_date');
            $order_id = $request->get('order_id');
            $model_code = @$request->get('model_code');
            $car_model_en=explode(':', $request->get('car_model'))[1];
            $car_selling_price_amount=$request->get('car_boss_price');
            $car_selling_price_type=$request->get('boss_price_type');
            $car_selling_price_currency=$request->get('currency_opt_bossprice');
            $transportation=$request->get('transportation');
            $estimate_date_arrival=@$request->get('estimate_date_arrival');
            $instruction=$request->get('instruction');
            $upload_yard_date=@$request->get('upload_yard_date');
            $show_website = $request->get('status_show_car_to_web');
            $car_reexport = $request->get('reexport');
            $car_ec_expires_date = $request->get('car_ec_expires_date');
            $other_info = $request->get('car_other_info');
            $registatio_date_month =$request->get('registatio_date_month');
            $registatio_date_year=$request->get('registatio_date_year');
            $consignee_id=@$request->get('car_consignee_id');
            $dashbord=$request->get('dashbord_o_c');
         
            $data=array(
                'car_stock_id' => $stock_id,
                'car_make_id'=>$car_make_id,
                'car_model_id'=>$car_model_id,
                'car_model_year'=> !empty($car_model_year) ? $car_model_year : '',
                'grade'=> !empty($grade) ? $grade : '',
                'yard_date'=> !empty($yard_date) ? $yard_date : '',
                'chassis_number'=> !empty($chassis_number) ? $chassis_number : '',
                'engine_size'=> !empty($engine_size) ? $engine_size : '',
                'date_of_production'=> $car_of_month.' '.$car_of_year,
                'auction_supplier'=>!empty($auction_supplier) && $auction_supplier != "null" ? $auction_supplier : '',
                'auction_lot'=>!empty($auction_lot) && $auction_lot != "null" ? $auction_lot : '',
                'purchaser'=>!empty($purchaser) && $purchaser != "null" ? $purchaser : '',
                'mileage'=>!empty($mileage) ? $mileage : '',
                'color'=>!empty($mileage) ? $mileage : '',
                'stock_type_id'=> !empty($stock_type_id) ? $stock_type_id : '',
                'buying_date'=>!empty($buying_date) ? $buying_date : '',
                'status'=>!empty($status) ? $status : '',
                'memo_for_web'=>!empty($memo_for_web) && $memo_for_web != "null" ? $memo_for_web : '',
                'memo_for_erp'=>!empty($memo_for_erp) && $memo_for_erp != "null" ? $memo_for_erp : '',
                'market_country_id'=>!empty($market_country_id) ? $market_country_id : '',
                'notify_party'=>!empty($notify_party) && $notify_party != "null" ? $notify_party : '',
                'car_length'=>!empty($car_length) ? $car_length : '',
                'car_width'=>!empty($car_width) ? $car_width : '',
                'car_height'=>!empty($car_height) ? $car_height : '',
                'car_weight'=>!empty($car_weight) ? $car_weight : '',
                'consignee_name'=>!empty($consignee_name)  && $consignee_name != "null" ? $consignee_name : '',
                'consignee_address'=>!empty($consignee_address)  && $consignee_address != "null" ? $consignee_address : '',
                'consignee_phone'=>!empty($consignee_phone)  && $consignee_phone != "null" ? $consignee_phone : '',
                'consignee_other_info'=> !empty($consignee_other_info)  && $consignee_other_info != "null" ? @$consignee_other_info : '',
                'car_body_type'=>!empty($car_body_type) ? $car_body_type : '',
                'car_fuel'=>!empty($car_fuel) ? $car_fuel : '',
                'car_discount'=>!empty($car_discount) ? $car_discount : '',
                'stock_location_id'=>!empty($stock_location_id) ? $stock_location_id : '',
                'stock_city_id'=>!empty($stock_city_id) ? $stock_city_id : '',
                'stock_yard_id'=>!empty($stock_yard_id) ? $stock_yard_id : '',
                'transimission'=>!empty($transimission) ? $transimission : '',
                'seats'=>!empty($seats) && $seats !="null" ? $seats : '',
                'drive_type'=>!empty($drive_type) ? $drive_type : '',
                'hour'=>!empty($hour) ? $hour : '',
                'tons'=>!empty($tons) ? $tons : '',
                'purpose'=>!empty($purpose) ? $purpose : '',
                // 'manufactured'=>$request->get('car_manufactured,
                'recycle_ok'=>!empty($recycle_ok) ? $recycle_ok : '',
                'inspection_certificate_ok'=>!empty($inspection_certificate_ok) && $inspection_certificate_ok != "null" ? $inspection_certificate_ok : '',
                'inspection_booked'=>!empty($inspection_booked)  && $inspection_booked != "null" ? $inspection_booked : '',
                'inspection_result'=>!empty($inspection_result)   && $inspection_result != "null" ? $inspection_result : '',
                'inspection_date'=>!empty($inspection_date)  && $inspection_date != "null" ? $inspection_date : '',
                // 'car_fob'=>$request->get('car_fob_price'),
                // 'car_fob_currency'=>$request->get('currency_opt_fob'),
                'order_id'=>!empty($order_id) ? $order_id : '',
                'model_code'=>!empty($model_code) ? $model_code : '',
                'car_make_en' =>!empty($car_make_en) ? $car_make_en : '',
                'car_model_en' =>$car_model_en,
                'car_city_en' => $city_location_en,
                'car_status_en' => $status_en,
                'car_market_en' => $car_marketcountry_en,
                'car_yard_en' => $yard_location_en,
                'car_location_en' => $country_location_en,
                'car_selling_price_amount' => !empty($car_selling_price_amount) ? $car_selling_price_amount : '',
                'car_selling_price_type' =>  !empty($car_selling_price_type) && $car_selling_price_type != "null" ? $car_selling_price_type : '',
                'car_selling_price_currency' => !empty($car_selling_price_currency) && $car_selling_price_currency != "null" ? $car_selling_price_currency : '',
                'car_auction_photo' =>  !empty(@$get_pic_auction[0]->photo_short_link) &&  @$get_pic_auction[0]->photo_short_link != "null" ? @$get_pic_auction[0]->photo_short_link : '',
                'car_yard_photo' => !empty(@$get_pic_yard[0]->photo_short_link) &&   @$get_pic_yard[0]->photo_short_link != "null" ?   @$get_pic_yard[0]->photo_short_link : '',
                'car_yard_photo_two' =>  !empty(@$get_pic_yard_two[0]->photo_short_link) &&  @$get_pic_yard_two[0]->photo_short_link != "null" ?  @$get_pic_yard_two[0]->photo_short_link : '',
                'transportation' =>  !empty($transportation) ? $transportation : '',
                'estimate_date_arrival' =>  !empty($estimate_date_arrival) ? $estimate_date_arrival : '',
                'instruction' => !empty($instruction) ? $instruction : '',
                'upload_yard_date' => !empty($upload_yard_date) ? $upload_yard_date : '',
                'show_website'=>!empty($show_website) ? $show_website : '',
                // 'car_documents'=>$request->get('_car_document'),
                'car_reexport'=>!empty($car_reexport) ? $car_reexport : '',
                'car_ec_expires_date'=>!empty($car_ec_expires_date) ? $car_ec_expires_date : '',
                'other_info'=>!empty($other_info) ? $other_info : '',
                'car_register_date' =>$registatio_date_month.' '.$registatio_date_year,
                'consignee_id' =>!empty($consignee_id) ? $consignee_id : '',
                'dashbord' => !empty($dashbord) ? $dashbord : '',
            );

            $data_bossprice = array(
                'car_stock_id'=>$stock_id,
                'boss_price'=>$request->get('car_boss_price'),
                'create_date'=>date('Y-m-d H::i:s'),
                'staff_id'=>$user->staff_id,
                'currency'=>$request->get('currency_opt_bossprice'),
                'port_name'=>$request->get('port_boss_price'),
                'boss_price_type'=>$request->get('boss_price_type')
                );

            $data_photo = $request->get('youtubelink');
            Stocklist_model::update_stock_list($stock_id,$data);
            if($data_photo){
                Stocklist_model::Update_data_video_url($stock_id,$data_photo);
            }

            //update final distination
            $discharge_id = $request->get('final_destination');
            $arrayName = array('discharge_id' =>  $discharge_id );
            $resid = Stocklist_model::get_reserve_id($stock_id);

            if (@$resid[0]->reserve_id != '') {  
                Stocklist_model::update_car_reserve_id($arrayName,$resid[0]->reserve_id);
            }

            //update boss price
            $boss_prices = Stocklist_model::select_boss_price($stock_id);
            if ($request->get('car_boss_price') != @$boss_prices[0]->boss_price || $request->get('port_boss_price') != @$boss_prices[0]->port_name || $request->get('currency_opt_bossprice') != @$boss_prices[0]->currency || $request->get('boss_price_type') != @$boss_prices[0]->boss_price_type) {
                Stocklist_model::insert_boss_price($data_bossprice);
            }
      
        return response()->json([
            'status' => true
        ],200);
    }

    public function UploadFile(Request $request){
        $manager = new ImageManager(new Driver());
        $file_data = $request->file('files');
        $stock_id = $request->get('stock_id');
        $data = array();
        $check_insert = '';
        $photo_order= 0;
        $photo_order_l = Stocklist_model::get_last_auction_photoes($stock_id);
        if(COUNT($photo_order_l) > 0){
            $photo_order = $photo_order_l[0]->photo_order;
        }
        if($request->hasFile('files')){
            $targetPath = 'uploads/cars/';
            $targetPath_thumb =  'uploads/cars/thumb/';
            $targetPath_thumb_small = 'uploads/cars/thumb_small/';
            foreach($file_data as $file){
                $photo_order +=1;
                $fileName = time().'_'.$file->getClientOriginalName();
                // $path = $file->storeAs($targetPath, $fileName);
                 // open an image file
                $image = $manager->read($file->getRealPath());
                $image->resize( 800,600);
                $image->save(storage_path('app/public/'.$targetPath.$fileName));

                $image_thumb = $manager->read($file->getRealPath());
                $image_thumb->resize( 150,110);
                $image_thumb->save(storage_path('app/public/'.$targetPath_thumb.$fileName));

                $image_thumb_small = $manager->read($file->getRealPath());
                $image_thumb_small->resize( 72,54);
                $image_thumb_small->save(storage_path('app/public/'.$targetPath_thumb_small.$fileName));

                $data['stock_id'] = $stock_id;

                $data['photo_type'] = 'auction_photo';
    
                $data['photo_short_link'] = $fileName;
                
                $data['server_file_path']  = '/uploads/cars/';
    
                $data['photo_order'] = $photo_order;
                
                $check_insert = Stocklist_model::insert_images_upload($data);
            }
            if($check_insert){
                $get_pic_auction = Stocklist_model::select_photo_auction($stock_id);
                $data1 = array('car_auction_photo' => @$get_pic_auction[0]->photo_short_link);
                Stocklist_model::Update_image_stock($data1,$stock_id);
                return response()->json([
                    'status' => true
                ],200);
            }

        }

    }

    public function UploadFileYard(Request $request){
        $manager = new ImageManager(new Driver());
        $file_data = $request->file('files');
        $stock_id = $request->get('stock_id');
        $data = array();
        $check_insert = '';
        $photo_order= 0;
        $photo_order_l = Stocklist_model::get_last_yard_photoes($stock_id);
        if(COUNT($photo_order_l) > 0){
            $photo_order = $photo_order_l[0]->photo_order;
        }
        if($request->hasFile('files')){
            $targetPath = 'uploads/cars/';
            $targetPath_thumb =  'uploads/cars/thumb/';
            $targetPath_thumb_small = 'uploads/cars/thumb_small/';
            foreach($file_data as $file){
                $photo_order +=1;
                $fileName = time().'_'.$file->getClientOriginalName();
                // $path = $file->storeAs($targetPath, $fileName);
                 // open an image file
                $image = $manager->read($file->getRealPath());
                $image->resize( 800,600);
                $image->save(storage_path('app/public/'.$targetPath.$fileName));

                $image_thumb = $manager->read($file->getRealPath());
                $image_thumb->resize( 150,110);
                $image_thumb->save(storage_path('app/public/'.$targetPath_thumb.$fileName));

                $image_thumb_small = $manager->read($file->getRealPath());
                $image_thumb_small->resize( 72,54);
                $image_thumb_small->save(storage_path('app/public/'.$targetPath_thumb_small.$fileName));

                $data['stock_id'] = $stock_id;

                $data['photo_type'] = 'yard_photo';
    
                $data['photo_short_link'] = $fileName;
                
                $data['server_file_path']  = '/uploads/cars/';
    
                $data['photo_order'] = $photo_order;
                
                $check_insert = Stocklist_model::insert_images_upload($data);
            }
            if($check_insert){
                $get_pic_auction = Stocklist_model::select_photo_yard($stock_id);
                $data1 = array('car_yard_photo' => @$get_pic_auction[0]->photo_short_link);
                Stocklist_model::Update_image_stock($data1,$stock_id);
                return response()->json([
                    'status' => true
                ],200);
            }

        }

    }

    public function add_toyard_two(Request $request){
        $photo_ids = $request->get('photo_ids');
        $stock_id = $request->get('stock_id');
        $arr_stock = explode(',',$photo_ids);
        $baseUrl = $request->root();
        foreach($arr_stock as $val){
            $where = array('photo_id'=>$val);
            $detail_image = Stocklist_model::select_detail_image($where);
         
            if(count($detail_image)>0){
                foreach ($detail_image as $detail_img) {
                    $stock_idz=$detail_img->stock_id;
                    $photo_short_link=$detail_img->photo_short_link;
                }
            }
            $name_radom = rand(2000000000,9999999999);
            $image_name = date("Y-m-d").$name_radom;
         
            $check = false;
            $remote_files="";
            if(\strpos($photo_short_link, 'https://p3.aleado.com') !== false ){
                $local_file=$_SERVER["DOCUMENT_ROOT"]."/storage/uploads/cars/".$image_name.".jpg";
                $remote_file=$photo_short_link;
                $remote_page = $this->getPage($remote_file);
                $this->saveToFile($remote_page , false, $local_file);

                $local_file=$_SERVER["DOCUMENT_ROOT"]."/storage/uploads/cars/thumb/".$image_name.".jpg";
                $remote_files=$photo_short_link.'&w=128';
                $remote_pages = $this->getPage($remote_files);
                $this->saveToFile($remote_pages , false, $local_file);

                $data['stock_id']=$stock_idz;
                $data['photo_short_link']=$image_name.".jpg";
                $data['server_file_path']='/uploads/cars/';
                $data['photo_type']='yard_photo';
                $data['photo_order'] = '50';
                $insert_image = Stocklist_model::insert_yart($data);
            }else if(\strpos($photo_short_link, 'https://image-cardata.com') !== false ){
                $local_file=$_SERVER["DOCUMENT_ROOT"]."/storage/upload/cars/".$image_name.".jpg";
                $remote_file=$photo_short_link;
                // Storage::disk('photos')->put($image_name.".jpg",file_get_contents($remote_file));
                $remote_page = $this->getPage($remote_file);
                $this->saveToFile($remote_page , false, $local_file);

                $local_files=$_SERVER["DOCUMENT_ROOT"]."/storage/uploads/cars/thumb/".$image_name.".jpg";
                $remote_pages = $this->getPage($remote_file);
                $this->saveToFile($remote_pages , false, $local_files);
                // Storage::disk('photos_thumb')->put($image_name.".jpg",file_get_contents($remote_file));
                $data['stock_id']=$stock_idz;
                $data['photo_short_link']=$image_name.".jpg";
                $data['server_file_path']='/uploads/cars/';
                $data['photo_type']='yard_photo';
                $data['photo_order'] = '50';
                $insert_image = Stocklist_model::insert_yart($data);
            }else{
                $local_file=$_SERVER["DOCUMENT_ROOT"]."/storage/uploads/cars/".$image_name.".jpg";
                // $remote_file=$baseUrl."/storage/uploads/cars/".$photo_short_link;
                // $remote_page = $this->getPage($remote_file);
                // $this->saveToFile($remote_page , false, $local_file);
                $remote_file=storage_path("app/public/uploads/cars/".$photo_short_link);
                Storage::disk('photos')->put($image_name.".jpg",file_get_contents($remote_file));

                $local_files=$_SERVER["DOCUMENT_ROOT"]."/storage/uploads/cars/thumb/".$image_name.".jpg";
                $remote_files=storage_path("app/public/uploads/cars/thumb/".$photo_short_link);
                // $remote_files=$baseUrl."/storage/uploads/cars/thumb/".$photo_short_link;
                // $remote_pages = $this->getPage($remote_files);
                // $this->saveToFile($remote_pages , false, $local_files);
                // file_put_contents($local_files, $remote_files,false ? LOCK_EX : 0);
                Storage::disk('photos_thumb')->put($image_name.".jpg",file_get_contents($remote_files));
                $data['stock_id']=$stock_idz;
                $data['photo_short_link']=$image_name.".jpg";
                $data['server_file_path']='/uploads/cars/';
                $data['photo_type']='yard_photo';
                $data['photo_order'] = '50';
                $insert_image = Stocklist_model::insert_yart($data);
            }
        }
        return response()->json([
            'status' => true,
            'message' => 'Add image to yard successfully'
        ]);
    }

    public function upload_images_car_exec_yard_two(Request $request){
        $manager = new ImageManager(new Driver());
        $file_data = $request->file('files');
        $stock_id = $request->get('stock_id');
        $data = array();
        $check_insert = '';
        $photo_order= 0;
        $photo_order_l = Stocklist_model::get_last_yard_photoes_two($stock_id);
        if(COUNT($photo_order_l) > 0){
            $photo_order = $photo_order_l[0]->photo_order;
        }
        if($request->hasFile('files')){
            $targetPath = 'uploads/cars/';
            $targetPath_thumb =  'uploads/cars/thumb/';
            $targetPath_thumb_small = 'uploads/cars/thumb_small/';
            foreach($file_data as $file){
                $photo_order +=1;
                $fileName = time().'_'.$file->getClientOriginalName();
                // $path = $file->storeAs($targetPath, $fileName);
                 // open an image file
                $image = $manager->read($file->getRealPath());
                $image->resize( 800,600);
                $image->save(storage_path('app/public/'.$targetPath.$fileName));

                $image_thumb = $manager->read($file->getRealPath());
                $image_thumb->resize( 150,110);
                $image_thumb->save(storage_path('app/public/'.$targetPath_thumb.$fileName));

                $image_thumb_small = $manager->read($file->getRealPath());
                $image_thumb_small->resize( 72,54);
                $image_thumb_small->save(storage_path('app/public/'.$targetPath_thumb_small.$fileName));

                $data['stock_id'] = $stock_id;

                $data['photo_type'] = 'yard_photo_two';
    
                $data['photo_short_link'] = $fileName;
                
                $data['server_file_path']  = '/uploads/cars/';
    
                $data['photo_order'] = $photo_order;
                $check_photo=Stocklist_model::check_car_photo($stock_id);
                if (empty($check_photo[0]->car_yard_photo_two)) {
                    $photo=array('car_yard_photo_two'=>$fileName);
                    Stocklist_model::update_photo_yard_two($stock_id,$photo);
                }
                $check_insert = Stocklist_model::insert_images_upload($data);
            }
            if($check_insert){
                $get_pic_auction = Stocklist_model::select_photo_yard_two($stock_id);
                // dd($get_pic_auction);
                $data1 = array('car_yard_photo_two' => @$get_pic_auction[0]->photo_short_link);
                Stocklist_model::Update_image_stock($data1,$stock_id);
                return response()->json([
                    'status' => true
                ],200);
            }

        }

    }

    public function select_image_upload(Request $request){
        $id = $request->get('stock_id');
        $data = DB::table('erp_stock_list_photo')
         ->select('*')
         ->where('stock_id','=',$id)
         ->where('photo_type','=','auction_photo')
         ->orderBy('photo_order','ASC')
         ->get();
        //  dd($data);
        return response()->json([
            'data_auctions' => $data
        ],200);
    }

    public function deleted_image(Request $request){
    $photo_id = $request->get('photo_id');
    DB::table('erp_stock_list_photo')
    ->where('photo_id','=',$photo_id)
    ->delete();
    return response()->json([
        'status' => true
    ],200);
    }

    public function deleted_image_checked(Request $request){
        $photo_id = $request->get('photo_id');
        foreach(explode(',',$photo_id) as $value){
          DB::table('erp_stock_list_photo')
            ->where('photo_id',$value)
            ->delete();
        }
        return response()->json([
            'status' => true
        ],200);
    }
    public function hide_image_checked(Request $request){
        $photo_id = $request->get('photo_id');
        $data = $request->get('is_hide');
          DB::table('erp_stock_list_photo')
            ->where('photo_id','=',intval($photo_id))
            ->update(['is_hide'=>intval($data)]);
        return response()->json([
            'status' => true
        ],200);
    }

    public function set_primary_image(Request $request){
        $photo_id = $request->get('photo_id');
        $stock_id = $request->get('stock_id');
        $photo_order_l = Stocklist_model::resortExceptSelect($stock_id,$photo_id);
        $order = 0;
        foreach($photo_order_l as $val){
            $order++;
            Stocklist_model::update_images_primary($val->photo_id,$order);
        }
        $get_pic_auction = Stocklist_model::select_photo_auction($stock_id);
        $data1 = array('car_auction_photo' => @$get_pic_auction[0]->photo_short_link);
        Stocklist_model::Update_image_stock($data1,$stock_id);
        return response()->json([
            'status' => true
        ],200);
    }

    public function set_primary_image_yard(Request $request){
        $photo_id = $request->get('photo_id');
        $stock_id = $request->get('stock_id');
        $photo_order_l = Stocklist_model::resortExceptSelectYard($stock_id,$photo_id);
        $order = 0;
        foreach($photo_order_l as $val){
            $order++;
            Stocklist_model::update_images_primary($val->photo_id,$order);
        }
        $get_pic_auction = Stocklist_model::select_photo_yard($stock_id);
        $data1 = array('car_yard_photo' => @$get_pic_auction[0]->photo_short_link);
        Stocklist_model::Update_image_stock($data1,$stock_id);
        return response()->json([
            'status' => true
        ],200);
    }

    public function set_primary_image_yard_two(Request $request){
        $photo_id = $request->get('photo_id');
        $stock_id = $request->get('stock_id');
        $photo_order_l = Stocklist_model::resortExceptSelectYardTwo($stock_id,$photo_id);
        $order = 0;
        foreach($photo_order_l as $val){
            $order++;
            Stocklist_model::update_images_primary($val->photo_id,$order);
        }
        $get_pic_auction = Stocklist_model::select_photo_yard_two($stock_id);
        $data1 = array('car_yard_photo_two' => @$get_pic_auction[0]->photo_short_link);
        Stocklist_model::Update_image_stock($data1,$stock_id);
        return response()->json([
            'status' => true
        ],200);
    }

    public function dragged_image(Request $request){
        $data_image = $request->get('data_image');
        $stock_id = $request->get('stock_id');
       
        foreach( json_decode($data_image) as $key => $item){
            echo $item->photo_id.'<br />';
           Stocklist_model::update_images_primary($item->photo_id,$key+1);
        }
        return response()->json([
            'status' => true
        ],200);
    }

    public function select_yard_image(Request $request){
        $id = $request->get('stock_id');
        $data = DB::table('erp_stock_list_photo')
         ->select('*')
         ->where('stock_id','=',$id)
         ->where('photo_type','=','yard_photo')
         ->orderBy('photo_order','ASC')
         ->get();
        //  dd($data);
        return response()->json([
            'data_auctions' => $data
        ],200);
    }

    public function select_image_upload_yard_two(Request $request){
        $id = $request->get('stock_id');
        $data = DB::table('erp_stock_list_photo')
         ->select('*')
         ->where('stock_id','=',$id)
         ->where('photo_type','=','yard_photo_two')
         ->orderBy('photo_order','ASC')
         ->get();
        //  dd($data);
        return response()->json([
            'data_auctions' => $data
        ],200);
    }

    function location_list(Request $request){
        $where_manul = "stock_location_id > 0";
        $locationInfo = $request->get('search_data');
        $check = is_array(json_decode($locationInfo)) ? count(json_decode($locationInfo)) : 0;
        if($check > 0){
            foreach(json_decode($locationInfo) as $lo){
                if(!empty($lo->stock_location_id)){
                    $where_manul = "stock_location_id=".$lo->stock_location_id;
                }
                
            }
        }
        
        $data = DB::table('erp_stock_country_location')
        ->select('country_name','stock_location_id','erp_country_list.country_list_id')
        ->leftjoin('erp_country_list','erp_country_list.country_list_id','=','erp_stock_country_location.country_list_id')
        ->whereRaw(DB::raw($where_manul))
        ->get();

        return response()->json([
            "location_list" => $data
        ], 200);
    }
    function get_all_country(){
        $data = DB::table('erp_country_list')
        ->select('*')
        ->get();

        return response()->json([
            "country_list" => $data
        ], 200);
    }
    public function save_location_info(Request $request){
        $locationInfo = $request->get('location_info');
        foreach(json_decode($locationInfo) as $lo){
            $data=array(
                'country_list_id'=>$lo->country,
            );
            if($lo->location_id > 0){
                DB::table('erp_stock_country_location')
                ->where('stock_location_id','=',$lo->location_id)
                ->update($data);
            }else{

                DB::table('erp_stock_country_location')
                ->insert($data);
            }
            
        }
        
    }
    public function delete_location(Request $request){
        $locationInfo = $request->get('location_info');
        foreach(json_decode($locationInfo) as $lo){
            DB::table('erp_stock_country_location')
            ->where('stock_location_id','=',$lo->location_id)
            ->delete();
        }
        
    }

    public function get_location_combo(){
        $data = DB::table('erp_stock_country_location')
        ->select('country_name','stock_location_id','erp_country_list.country_list_id')
        ->leftjoin('erp_country_list','erp_country_list.country_list_id','=','erp_stock_country_location.country_list_id')
        ->get();

        return response()->json([
            "location_list_combo" => $data
        ], 200);
    }
    public function get_group_type(Request $request){
        $user = Auth::user();
        $data = DB::table('users_groups')
          ->select('group_id')
          ->where('staff_id','=',$user->staff_id)
          ->get();
          return response()->json([
             $data[0]->group_id
        ], 200);
    }

    public function get_stock_list_detail(Request $request){
        $stock_id = $request->get('stock_id');
        $baseUrl = $request->root();
        //Get Session data
        $user = Auth::user();
        $permission = $this->data_group_user($user->staff_id);
        $cambodia_staff = $this->staff_cambodia($user->staff_id);
     
        //Update Car Profile
        $this->update_profit($stock_id);
        $stock_info = Stocklist_model::get_stock_list_detail_data($stock_id);
        $get_expense_car_amount = Stocklist_model::get_total_cost($stock_id);
        $get_boss_prices = Stocklist_model::get_boss_price($stock_id);
        $get_sell_commission = Stocklist_model::get_sell_commission($stock_id);
        $final_dist_list = Stocklist_model::final_destination_info();
        $get_reserved_info = Stocklist_model::get_sold_price_distination($stock_id);
        $get_stock_list_doc = Stocklist_model::get_stock_list_doc($stock_id);
        $photo_auction = Stocklist_model::select_image_auction($stock_id);
        $photo_yard = Stocklist_model::select_image_upload_yard($stock_id);
        $photo_yard_two  = Stocklist_model::select_image_upload_yard_two($stock_id);
           //Get total cost
           $total_cost     = 0;
           $buying_price   = 0;
           $tax_fee        = 0;
           $auction_fee    = 0;
           $transportation_fee  = 0;
           $car_tax_fee    = 0;
           $recycle_fee    = 0;
           $freight_fee    = 0;
           $repair_fee     = 0;
           $inspection_fee = 0;
           $shipping_charge_fee = 0;
           $shipping_charge_cost= 0;
           $insurance_fee       = 0;
           $other_fee_amount    = 0;
           $other_refund_amount = 0;
           $ea_fee         = 0;
           $total_refund   = 0;
           $currency       ='';
           $total_price    = 0;
           $currency_type_ex = "";

           if($get_expense_car_amount){
             foreach( $get_expense_car_amount as $val){
                $currency       = $val->currency_type;
                $expense_id     = $val->car_expense_id;
                $division_id    = $val->expenses_division_id;
                $rate_exchange  = $val->exchange_rate;
                if($stock_info[0]->location_name== "Japan"){
                    $currency_type_ex ='JPY';
                    if($currency=='USD'){
                        $buying         = $val->buying_price * $rate_exchange;
                        $auction        = $val->auction_fee * $rate_exchange;
                        $tax            = $val->tax_fee * $rate_exchange;
                        $car_tax        = $val->car_tax_fee * $rate_exchange;
                        $transportation = $val->transportation_fee * $rate_exchange;
                        $recycle        = $val->recycle_fee * $rate_exchange;
                        $freight        = $val->freight_fee * $rate_exchange;
                        $repair         = $val->repair_fee * $rate_exchange;
                        $inspection     = $val->inspection_fee * $rate_exchange;
                        $shipping_charge= $val->shipping_charge_fee * $rate_exchange;
                        $insurance      = $val->insurance_fee * $rate_exchange;
                        $ea_cost        = $val->ea_fee * $rate_exchange;
                    }else{
                    
                        $buying         = $val->buying_price;
                        $auction        = $val->auction_fee;
                        $tax            = $val->tax_fee;
                        $car_tax        = $val->car_tax_fee;
                        $transportation = $val->transportation_fee;
                        $recycle        = $val->recycle_fee;
                        $freight        = $val->freight_fee;
                        $repair         = $val->repair_fee;
                        $inspection     = $val->inspection_fee;
                        $shipping_charge= $val->shipping_charge_fee;
                        $insurance      = $val->insurance_fee;
                        $ea_cost        = $val->ea_fee; 
                    }
                }else{
                    $currency_type_ex ='USD';
                    $buying         = $val->buying_price;
                    $auction        = $val->auction_fee;
                    $tax            = $val->tax_fee;
                    $car_tax        = $val->car_tax_fee;
                    $transportation = $val->transportation_fee;
                    $recycle        = $val->recycle_fee;
                    $freight        = $val->freight_fee;
                    $repair         = $val->repair_fee;
                    $inspection     = $val->inspection_fee;
                    $shipping_charge= $val->shipping_charge_fee;
                    $insurance      = $val->insurance_fee;
                    $ea_cost        = $val->ea_fee; 
                }
                $buying_price       += !empty($buying) ? $buying : 0;
                $tax_fee            += !empty($tax) ? $tax : 0;
                $auction_fee        += !empty($auction) ? $auction : 0;
                $transportation_fee += !empty($transportation) ? $transportation : 0;
                $recycle_fee        += !empty($recycle) ? $recycle : 0;
                $car_tax_fee        += !empty($car_tax) ? $car_tax : 0;
                $freight_fee        += !empty($freight) ? $freight : 0;
                $repair_fee         += !empty($repair) ? $repair : 0;
                $inspection_fee     += !empty($inspection) ? $inspection : 0;
                $shipping_charge_fee+= !empty($shipping_charge) ? $shipping_charge : 0;
                $insurance_fee      += !empty($insurance) ? $insurance : 0;
                $expenses_other_fee = Stocklist_model::get_car_expenses_other_fee($expense_id);
                if($expenses_other_fee){
                    foreach($expenses_other_fee as $row){
                        if($stock_info[0]->location_name== "Japan"){
                            if($row->currency_type=='USD'){
                                $other_fee = $row->amount * $rate_exchange;
                            }else{
                                $other_fee = $row->amount;
                            }
                        }else{
                            $other_fee = $row->amount;
                        }
                        $other_fee_amount += !empty($other_fee) ? $other_fee : 0;
                    }
                }
                $expenses_other_refund =  Stocklist_model::get_car_expenses_other_refund($expense_id);
                if($expenses_other_refund){
                    foreach ($expenses_other_refund as $row) {
                        if($stock_info[0]->location_name== "Japan"){
                            if($row->currency_type=='USD'){
                                $other_refund = $row->amount * $rate_exchange;
                            }else{
                                $other_refund = $row->amount;
                            }
                        }else{
                            $other_refund = $row->amount;
                        }
                        
                        $other_refund_amount += !empty($other_refund) ? $other_refund : 0;
                    } 
                }
                $total_refund = $other_refund_amount + $tax_fee + $recycle_fee;

                $total_cost = $other_fee_amount + $buying_price + $auction_fee + 
                $transportation_fee +  $car_tax_fee + $freight_fee + $repair_fee + 
                $inspection_fee + $shipping_charge_fee + $insurance_fee + $ea_fee;

                $total_price = $total_refund + $total_cost;
             }
            
           }

           $get_sold_price = Stocklist_model::get_sold_price($stock_id);

           //get auction income
           $get_auction_income = Stocklist_model::get_auction_income($stock_id);
           $total_auction_income = 0;
           $total_income = 0;
           $with_chassis_currency ='';
           $car_allocate_origin_currency ='';
           $customer_deposit_type='';
           
           if($get_auction_income){
           
            foreach ($get_auction_income as $row) {
            
                if($row->customer_deposit_type=='customer_deposit' || $row->customer_deposit_type=='customer_auction_deposit'){
                    $total_income += !empty($row->car_allocate) ? $row->car_allocate : 0;
                    $car_allocate_origin_currency = $row->car_allocate_currency;
                    
                }else{
                    if( $row->car_allocate_origin_currency == "USD"){
    
                        $total_auction_income += !empty($row->car_allocate) ? $row->car_allocate : 0;
                        $with_chassis_currency = $row->car_allocate_currency;
                    } else {
    
                        $total_auction_income += !empty($row->car_allocate_origin) ? $row->car_allocate_origin : 0;
                        $with_chassis_currency = $row->car_allocate_origin_currency;
                    }
                }
                
                $customer_deposit_type = $row->customer_deposit_type;
            } 
           }
           $data_photo_auction = array();
           foreach($photo_auction as $img){
                if ($img->server_file_path == "") {
                    $url_auction_photo = $img->photo_short_link;
                    $url_auction_photo_src = $img->photo_short_link;
                } else {
                    $url_auction_photo = $baseUrl.'/storage/'.$img->server_file_path . $img->photo_short_link;
                    $url_auction_photo_src = $baseUrl.'/storage/'.$img->server_file_path . 'thumb/' . $img->photo_short_link;
                }
                array_push($data_photo_auction, array(
                    'url_auction_photo' => $url_auction_photo,
                    'url_auction_photo_src' =>  $url_auction_photo_src
                ));
           }

            return response()->json([
                  'data_car_detail' => $stock_info,
                  'permission' => $permission[0]->name,
                  'cambodia_staff' => $cambodia_staff,
                  'total_cost' => $total_cost,
                  'currency_type_ex' => $currency_type_ex,
                  'buying_price'  => $buying_price,
                  'car_tax_fee' => $car_tax_fee,
                  'auction_fee' => $auction_fee,
                  'transportation_fee' => $transportation_fee,
                  'freight_fee' => $freight_fee,
                  'repair_fee' => $repair_fee,
                  'inspection_fee' => $inspection_fee,
                  'shipping_charge_fee' =>$shipping_charge_fee,
                  'insurance_fee' => $insurance_fee,
                  'other_fee_amount' => $other_fee_amount,
                  'ea_fee' => $ea_fee,
                  'total_refund' => $total_refund,
                  'tax_fee' => $tax_fee,
                  'recycle_fee' => $recycle_fee,
                  'other_refund_amount' => $other_refund_amount,
                  'total_price' => $total_price,
                  'get_boss_price' => $get_sold_price,
                  'final_dist_list' => $final_dist_list,
                  'get_reserved_info' => $get_reserved_info,
                  'total_auction_income' => $total_auction_income,
                  'with_chassis_currency' => $with_chassis_currency,
                  'total_income' => $total_income,
                  'car_allocate_origin_currency' => $car_allocate_origin_currency,
                  'data_stock_list_doc' => $get_stock_list_doc,
                  'photo_auction' => $data_photo_auction,
                  'photo_yard' => $photo_yard,
                  'photo_yard_two' => $photo_yard_two
               ], 200);
    }

    public function select_reserve_info(Request $request){
        $stock_id = $request->get('stock_id');
        $currency_type_ex = "";
        $select = "a.*,b.*,boss.*,d.*,e.*,sold.*,a.customer_id as cus_id,sold.currency AS sold_cur,boss.currency AS boss_currency,cus.full_name AS cus_name";
        $boss_price = "SELECT cc.car_stock_id,cc.boss_price,cc.currency,cc.boss_price_type FROM (SELECT * FROM erp_stock_list_boss_price ORDER BY boss_price_id DESC) AS cc GROUP BY cc.car_stock_id";
        $reserv = "SELECT * FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res 	WHERE res.reserve_id IN ( SELECT MAX( reserve_id ) AS max_id FROM erp_car_reserve GROUP BY stock_id) GROUP BY stock_id";
        $data = DB::table('erp_stock_list AS a')
                   ->select(DB::raw($select))
                   ->leftjoin('erp_car_make AS b','b.car_make_id','=','a.car_make_id')
                   ->leftjoin(DB::raw('('.$boss_price.') AS boss'),'boss.car_stock_id','=','a.car_stock_id')
                   ->leftjoin('erp_stock_list_car_status AS e','e.stock_list_car_status_id','=','a.status')
                   ->leftjoin('erp_car_model AS d','d.car_model_id','=','a.car_model_id')
                   ->leftjoin(DB::raw('('.$reserv.') AS sold'),'sold.stock_id','=','a.stock_id')
                   ->leftjoin('erp_customer AS cus','cus.customer_id','=','a.customer_id')
                   ->whereIn('a.stock_id',[$stock_id])
                   ->get();
        return response()->json([
        'data_car_reserve' => $data
        ], 200);
    }

    public function update_profit($id){
        $total_cost = $this->get_all_cost($id);
        $total_allocate = Income_model::get_total_allocate($id);
        $get_purpos = Income_model::get_car_status_info($id);
        $total_amount = 0;

        foreach ($total_allocate as $val) {
            if ($val->car_allocate_currency == "USD") {
                $exchange_amount = $val->car_allocate * ($val->exchange_rate - 1 );
                 $total_amount += $exchange_amount; 
            }else{
                $total_amount += $val->car_allocate;
            }
        }
        if($get_purpos[0]->purpose == "export"){
            $profit = $total_amount - @$total_cost['total_cost']; 
        }else{
            $profit = $total_amount - @$total_cost['total_price'];
        }
        $arr_profit = array('profit' => $profit);
        Income_model::update_car_profit($id,$arr_profit);
    }
    public function get_all_cost($id){
        $result['total_cost'] = 0;
        $result['total_price'] = 0;
        $total_allocate_ex = Income_model::get_total_cost($id);
        $buying_price = 0;
        $auction_fee = 0;
        $transport_fee = 0;
        $fright_fee = 0;
        $repair = 0;
        $inspect = 0;
        $shipping_charge = 0;
        $tax = 0;
        $car_tax = 0;
        $insurence = 0;
        $recycle = 0;
        $redaition = 0;
        $other_fee_amount = 0;
        $ea_fee = 0;
        $other_refund_amount = 0;
        foreach($total_allocate_ex as $val){
            if($val->currency_type == "USD"){
                $buying_price += $val->buying_price * $val->exchange_rate;
                $auction_fee += $val->auction_fee * $val->exchange_rate;
                $transport_fee += $val->transportation_fee * $val->exchange_rate;
                $fright_fee += $val->freight_fee * $val->exchange_rate;
                $repair += $val->repair_fee * $val->exchange_rate;
                $inspect += $val->inspection_fee * $val->exchange_rate;
                $shipping_charge += $val->shipping_charge_fee * $val->exchange_rate;
                $tax += $val->tax_fee * $val->exchange_rate;
                $car_tax += $val->car_tax_fee * $val->exchange_rate;
                $insurence += $val->insurance_fee * $val->exchange_rate;
                $recycle += $val->recycle_fee * $val->exchange_rate;
                $redaition += $val->rediation_fee * $val->exchange_rate;
                $ea_fee += $val->ea_fee * $val->exchange_rate;
                $other_fee_amount += $val->total_other_fee * $val->exchange_rate;
                $other_refund_amount += $val->total_other_refund * $val->exchange_rate;

            }else{

                $buying_price += $val->buying_price;
                $auction_fee += $val->auction_fee;
                $transport_fee += $val->transportation_fee;
                $fright_fee += $val->freight_fee;
                $repair += $val->repair_fee;
                $inspect += $val->inspection_fee;
                $shipping_charge += $val->shipping_charge_fee;
                $tax += $val->tax_fee;
                $car_tax += $val->car_tax_fee;
                $insurence += $val->insurance_fee;
                $recycle += $val->recycle_fee;
                $redaition += $val->rediation_fee;
                $ea_fee += $val->ea_fee;
                $other_fee_amount += $val->total_other_fee;
                $other_refund_amount += $val->total_other_refund;
            }
            $result['total_cost'] = $buying_price + $auction_fee + $car_tax + $transport_fee + $fright_fee + $repair + $inspect + $shipping_charge + $other_fee_amount + $redaition + $insurence + $ea_fee;
            $result['total_price']= $buying_price + $auction_fee + $car_tax + $transport_fee + $fright_fee + $repair + $inspect + $shipping_charge + $other_fee_amount + $redaition + $tax + $recycle + $other_refund_amount + $insurence + $ea_fee;
            return $result;
        }
    }
    public function get_purpose_history(Request $request){
        $stock_id = $request->get('stock_id');
        $data = DB::table('erp_purpose_history AS a')
                   ->select('a.*','b.full_name')
                   ->leftjoin('erp_staff AS b','a.staff_id','=','b.staff_id')
                   ->where('a.stock_id','=',$stock_id)
                   ->orderBy('a.id','ASC')
                   ->get();
                  
        return response()->json([
        'data_purpose_history' => $data
        ], 200);
    }
    public function get_car_status_history(Request $request){
        $stock_id = $request->get('stock_id');
        $data = DB::table('erp_cars_status_history AS a')
                  ->select('*')
                  ->leftjoin('erp_staff AS b','a.staff_id','=','b.staff_id')
                  ->where('stock_id','=',$stock_id)
                  ->where('status','=','active')
                  ->get();
        return response()->json([
            'data_status_history' => $data
        ]);
    }
    public function get_instruction_history(Request $request){
        $stock_id = $request->get('stock_id');
        $data = DB::table('erp_instruction_history AS a')
                ->select('a.*','b.full_name')
                ->leftjoin('erp_staff AS b','a.staff_id','=','b.staff_id')
                ->where('a.stock_id','=',$stock_id)
                ->orderBy('a.id','ASC')
                ->get();
        return response()->json([
            'data_instruction_history' => $data
        ]);
    }
    public function get_location_history(Request $request){
        $stock_id = $request->get('stock_id');
        $select = "a.*,b.full_name,j.stock_city_name,k.stock_yard_name,l.country_name";
        $data = DB::table('erp_location_history AS a')
                ->select(DB::raw($select))
                ->leftjoin('erp_staff AS b','a.staff_id','=','b.staff_id')
                ->leftjoin('erp_stock_city_location AS j','j.stock_city_id','=','a.stock_city_id')
                ->leftjoin('erp_stock_yard_location AS k','k.stock_yard_id','=','a.stock_yard_id')
                ->leftjoin('erp_country_list AS l', 'l.country_list_id','=','a.stock_location_id')
                ->where('a.stock_id','=',$stock_id)
                ->orderBy('a.id','ASC')
                ->get();
        return response()->json([
            'data_location_history' => $data
        ]);
    }
    public function GetInfoFromjp(Request $request){
        $chassis_number = $request->get('chassis_number');
        $car_make = $request->get('car_make');
       $response = file_get_contents("https://jpauction24.com/get_date_of_production.php?company_en=".$car_make."&chassis=".$chassis_number."");
       return $response;
    }
    public function get_car_recycleok_history(Request $request){
        $stock_id = $request->get('stock_id');
        $data = DB::table('erp_recycle_ok_history AS a')
                ->select('a.*','b.full_name')
                ->leftjoin('erp_staff AS b','a.staff_id','=','b.staff_id')
                ->where('a.stock_id','=',$stock_id)
                ->get();
    return response()->json([
        'data_recycle_history' => $data
    ]);
    }
    public function get_showonwebsite_history(Request $request){
        $stock_id = $request->get('stock_id');
        $data = DB::table('erp_showonwebsite_history AS a')
                ->select('a.*','b.full_name')
                ->leftjoin('erp_staff AS b','a.staff_id','=','b.staff_id')
                ->where('a.stock_id','=',$stock_id)
                ->orderBy('a.id','ASC')
                ->get();

        return response()->json([
            'data_showonwebsite_history' => $data
        ]);
    }
    public function get_expense_info(Request $request){
        $stock_id = $request->get('stock_id');
        $type_select = $request->get('type');
        $get_expense_car_info = Stocklist_model::get_total_cost($stock_id); 
        $other_refund_amount = 0;
        $other_fee_amount=0;
        $type_info = "";
        $income_id = '';
        $income_desc = "";
        $dep_amount = "";
        $dep_date ='';
       $get_expense_info = array();
        if($get_expense_car_info){
            foreach($get_expense_car_info as $val){
                $expense_id = $val->car_expense_id;
                $expenses_other_fee =  Expenses_model::get_car_expenses_other_fee($expense_id);
                if($expenses_other_fee){
                    foreach ($expenses_other_fee as $row) {
                        $other_fee_amount += !empty($row->amount) ? $row->amount : 0;
                    }
                }
                $expenses_other_refund =  Expenses_model::get_car_expenses_other_refund($expense_id);
                if($expenses_other_refund){
                    foreach ($expenses_other_refund as $row) {
                        $other_refund_amount += !empty($row->amount) ? $row->amount : 0;
                    }   
                
                }
                if(!empty($val->expenses_division_id)){
                     $data_expenses_division = Expenses_model::data_expenses_division($val->expenses_division_id);
                     foreach ($data_expenses_division as $income){
                        $cur = $income->currency_type;
                        $income_id = $income->deposit_expense_id;
                        $income_desc = $income->description;
                        $dep_amount = $income->amount;
                        $dep_date = $income->created_dt;
                      }
                }else{
                      $data_deposit_income = Expenses_model::data_deposit_income($val->customer_deposit_id);
                      foreach ($data_deposit_income as $income){
                        $cur = $income->customer_deposit_currency;
                        $income_id = $income->deposit_income_id;
                        $income_desc = $income->description;
                        $dep_amount = $income->deposit_amount;
                        $dep_date = $income->deposit_date;
                      }
                }
                if($type_select == "buying_price"){
                    $type_info = $val->buying_price;
                }else if($type_select == "tax"){
                    $type_info = $val->tax_fee;
                }else if($type_select == "transportation"){
                    $type_info = $val->transportation_fee;
                }else if($type_select == "auction_fee"){
                    $type_info = $val->auction_fee;
                }else if($type_select == "frieght"){
                    $type_info = $val->freight_fee;
                }else if($type_select == "repair"){
                    $type_info = $val->repair_fee;
                }else if($type_select == "inspection"){
                    $type_info = $val->inspection_fee;
                }else if($type_select == "shipping_charge"){
                    $type_info = $val->shipping_charge_fee;
                }else if($type_select == "car_tax"){
                    $type_info = $val->car_tax_fee;
                }else if($type_select == "recycle_fee"){
                    $type_info = $val->recycle_fee;
                }else if($type_select == "insurance"){
                    $type_info = $val->insurance_fee;
                }else if($type_select == "other_fee"){
                    $type_info = $other_fee_amount;
                }else if($type_select == "other_refund"){
                    $type_info = $other_refund_amount;
                }else if($type_select == "ea_fee"){
                    $type_info = $val->ea_fee;
                }
                $arr = array(
                    'type_info' => $type_info,
                    'currency_type' => $cur,
                    'income_id' => $income_id,
                    'description' => $income_desc,
                    'amount' =>$dep_amount,
                    'dep_date' => $dep_date,
                    'full_name' => $val->full_name
                );
                if($type_info > 0) {
                    array_push($get_expense_info,$arr );
                }
                 
            }
            return response()->json([
                'get_expense_info' => $get_expense_info,
                'type_select' => $type_select
            ]);
        }
    }
    public function get_other_fee_info(Request $request) {
        $stock_id = $request->get('stock_id');
        $get_expense_car_info = Stocklist_model::get_total_cost($stock_id); 
        $data_other_fee_info = array();
        if($get_expense_car_info){
            foreach($get_expense_car_info as $val){
                 $expense_id = $val->car_expense_id;
                 $data_other_fee =Stocklist_model::get_car_expenses_other_fee($expense_id);
                 foreach($data_other_fee as $row){
                    if ($row->currency_type == 'JPY') {
                        $amount = number_format($row->amount);
                    } else {
                        $amount = number_format($row->amount, 2);
                    }
                  array_push($data_other_fee_info,array('title' => $row->title,
                  'amount' => $amount,
                  'currency' => $row->currency_type,
                  'create_date' =>  date('Y-m-d', strtotime($row->create_date))
                   ));
                 }
            }
        }
        return response()->json([
            'get_expense_amount_other_fee' => $data_other_fee_info
        ]);
    }

    public function get_refund_info_detail(Request $request){
        $stock_id = $request->get('stock_id');
        $get_expense_car_info = Stocklist_model::get_total_cost($stock_id); 
        $data_refund_info = array();
        if($get_expense_car_info){
            foreach($get_expense_car_info as $val){
                 $expense_id = $val->car_expense_id;
                 $expenses_other_refund =Stocklist_model::get_car_expenses_refund_info($expense_id);
                 if ($expenses_other_refund) {
                    foreach ($expenses_other_refund as $row) {
                        if ($row->currency_type == 'JPY') {
                            $amount = number_format($row->amount);
                        } else {
                            $amount = number_format($row->amount, 2);
                        }
                        array_push($data_refund_info, array(
                            'title' => $row->title,
                            'amount' => $amount,
                            'currency'   => $row->currency_type,
                            'create_date' =>date('Y-m-d', strtotime($row->create_date)) 
                        ));
                    }
                 }
            }
        }
        return response()->json([
            'data_refund_info' => $data_refund_info
        ]);
    }

    public function detail_sold_price(Request $request){
        $stock_id = $request->get('stock_id');
        $select = "erp_car_reserve_history.*,erp_customer.full_name,erp_final_destination.final_des_name";
        $detail_sold_price = DB::table('erp_car_reserve_history') 
                              ->select(DB::raw($select))
                              ->leftjoin('erp_customer','erp_customer.customer_id','=','erp_car_reserve_history.customer_id')
                              ->leftjoin('erp_final_destination','erp_car_reserve_history.discharge_id','=','erp_final_destination.id')
                              ->where('stock_id','=',$stock_id)
                              ->orderBy('reserve_id','ASC')
                              ->get();
        return response()->json([
            'detail_sold_price' => $detail_sold_price
        ]);
    }

    public function get_selling_price_detail(Request $request){
        $stock_id = $request->get('stock_id');
        $get_boss_price = Stocklist_model::get_boss_price($stock_id);
        $selling_info = array();
        if($get_boss_price){
            foreach($get_boss_price as $row){
                if ($row->currency == 'JPY') {
                    $boss_price = number_format($row->boss_price);
                } else {
                    $boss_price = number_format($row->boss_price, 2);
                }
                $create_date = $row->create_date;
                if (empty($row->full_name)) {
                    $updater = $row->staff_id;
                } else {
                    $updater = $row->full_name;
                }
                array_push($selling_info,array(
                 'boss_price_id' => $row->boss_price_id,
                 'boss_price_type' =>  $row->boss_price_type,
                 'currency' => $row->currency,
                 'boss_price' =>  $boss_price,
                 'port_name' => $row->port_name,
                 'updater' => $updater,
                 'create_date' => $create_date
                ));
            }
        }
        return response()->json([
            'selling_detail_info' =>  $selling_info 
        ]);
    }

    public function get_auction_income_detail(Request $request){
        $stock_id = $request->get('stock_id');
        $bl_date = $request->get('bl_date');
        $get_auction_income = Stocklist_model::get_auction_income($stock_id);
        $data_auction_income_info = array();
        if($get_auction_income ){
            foreach($get_auction_income as $row ){
                $exchangeAmount ="";
                if ($row->customer_deposit_type != 'customer_deposit' || $row->customer_deposit_type == '') {
                    if ($row->customer_deposit_type != 'customer_auction_deposit') {
                        $currencyAllocat = "";
                        $car_allocate = number_format($row->car_allocate, 2);
                        if ($row->car_allocate_origin_currency == 'USD') {
                            $currencyAllocat = $row->car_allocate_currency;
                        } else {
                            $exchangeAmount = number_format($row->exchange_amount);	
                            $currencyAllocat = $row->car_allocate_origin_currency;
                        }

                        if ($row->allocate_date == NULL || $row->allocate_date == "") {
                            $allocate_date = "";
                        } else {
                            $allocate_date = date('Y-m-d', strtotime($row->allocate_date));
                        }

                        if(!empty($row->expenses_division_id)){
                            $deposit_no = $row->deposit_expense_id;
                        }else{
                            $deposit_no = $row->deposit_income_id;
                        }

                        if(!empty($row->expenses_division_id)){
                            $sender = $row->description_expense;
                        }else{
                            $sender = $row->description;
                        }

                        $car_allocate = number_format($row->car_allocate, 2);

                        if (date($row->allocate_date) < date($bl_date)) {
                            $status = "Befor BLDATE";
                        } else {
                            $status = "After BLDATE";
                        }

                        if(!empty($row->expenses_division_id)){
                            $allcate_from  = 'From Expense';
                        }else{
                            $allcate_from  = 'From Income';
                        } 

                        $data_arr = array(
                            'deposit_no' => $deposit_no,
                            'sender' => $sender,
                            'allocate_title' => $row->allocate_title,
                            'amount' => $row->car_allocate_origin.' '.$row->car_allocate_origin_currency,
                            'exchange_amount' =>  $car_allocate.' '.$row->car_allocate_currency,
                            'exchange_rate' => $row->exchange_rate,
                            'allocate_date' =>$allocate_date,
                            'status' => $status,
                            'staff_name' => $row->full_name,
                            'allcate_from' => $allcate_from 
                        );
                        array_push($data_auction_income_info,$data_arr);
                    }
                }
            }
        }
        return response()->json([
            'data_auction_income_info' =>  $data_auction_income_info 
        ]);
    }

    public function get_income_detail(Request $request){
        $stock_id = $request->get('stock_id');
        $bl_date = $request->get('bl_date');
        $get_auction_income = Stocklist_model::get_auction_income($stock_id);
        $data_income_info = array();
        if($get_auction_income ){
            foreach($get_auction_income as $row ){
                $exchangeAmount ="";
                if ($row->customer_deposit_type == 'customer_deposit' || $row->customer_deposit_type == 'customer_auction_deposit') {
                       
                        if ($row->car_allocate_currency == 'JPY') {
                            $car_allocate = number_format($row->car_allocate);
                        } else {
                            $car_allocate = number_format($row->car_allocate, 2);
                        }
                        if ($row->car_allocate_origin_currency == 'JPY') {
                            $car_allocate_origin = number_format($row->car_allocate_origin);
                        } else {
                            $car_allocate_origin = number_format($row->car_allocate_origin, 2);
                        }

                        if (date($row->allocate_date) < date($bl_date)) {
                           $allocate_date = "Befor BLDATE";
                        } else {
                            $allocate_date = "After BLDATE";
                        }

                        $data_arr = array(
                            'sender' => $row->description,
                            'amount' => $car_allocate_origin.' '.$row->car_allocate_origin_currency,
                            'exchange_rate' => $row->exchange_rate,
                            'exchange_amount' => $car_allocate.' '.$row->car_allocate_currency,
                            'allocate_date' => date('Y-m-d', strtotime($row->allocate_date)),
                            'deposit_date' => date('Y-m-d', strtotime($row->deposit_date)),
                            'status' => $allocate_date,
                            'staff_name' => $row->full_name 
                        );
                        array_push($data_income_info,$data_arr);
                }
            }
        }
        return response()->json([
            'data_income_info' =>  $data_income_info 
        ]);
    }

    public function add_dhl(Request $request){
        $user = Auth::user();
        $stock_id = $request->get('stock_id');
        $txt_dlh = $request->get('txt_dlh');
        $company_dhl = $request->get('company_dhl');
        $contact_dhl = $request->get('contact_dhl');
        $phone_dhl = $request->get('phone_dhl');
        $email_dhl = $request->get('email_dhl');
        $dlh_address = $request->get('dlh_address');
        $data['dhl_number'] = $txt_dlh;
        $data['company_dhl'] = $company_dhl;
        $data['contact_dhl'] = $contact_dhl;
        $data['phone_dhl'] = $phone_dhl;
        $data['email_dhl'] = $email_dhl;
        $data['dhl_address'] = $dlh_address;

        if($stock_id){
            DB::table('erp_stock_list')
                ->where('stock_id','=',$stock_id)
                ->update($data);
                //Update status car 
                $car_info = Income_model::get_car_status_info($stock_id);
                Status_update::update_car_status($stock_id,@$car_info[0]->customer_id,$user->staff_id);
                Status_update::update_soldout_status($stock_id,$user->staff_id);
                Status_update::cancel_soldout_status($stock_id,$user->staff_id);
        }
    }

    public function delete_car_document_file(Request $request){
       $stock_id = $request->get('stock_id');
       $fileName = $request->get('fileName');
       $user = Auth::user();
       $checkFile = $_SERVER["DOCUMENT_ROOT"] . '/' .$fileName;
       $message = "";
       if(file_exists($checkFile) == 1){
        if (is_readable($fileName) && unlink($fileName)) 
        {
            $updateData = array( 
            'car_document_file' => null,
            'car_documents' => "n");
            DB::table('erp_stock_list')
              ->where('stock_id','=',$stock_id)
              ->update($updateData);

            $data_documents=array(
                'stock_id'      => $stock_id,
                'status'        => 'NO',
                'updated_date'  => date('Y-m-d H:i:s'),
                'staff_id'      => $user->staff_id
            );
            Stocklist_model::add_car_documents_history($data_documents);

            $message = "The file has been deleted";
        } 
       }
       return $message;
    }

    public function delete_car_doc(Request $request){
        $doc_id = $request->get('doc_id');
        DB::table('erp_stock_list_doc')
           ->where('id','=',$doc_id)
           ->delete();
    }

    public function download_auction_zip(Request $request){
        $stock_id = $request->get('stock_id');
        $auction_photos = Stocklist_model::select_image_auction($stock_id);
        $arr1 = array();
        foreach ($auction_photos as $auction_photo) {
            $_SESSION["stock_id"] =$auction_photo->stock_id;
            $picture     = $auction_photo->photo_short_link;
            $name_radom  = rand(2000000000,9999999999);
            $image_name  = date("Y-m-d").$name_radom;
            $remote_file = $picture;
            $local_file  = $_SERVER["DOCUMENT_ROOT"]."/storage/upload/cars/temp_zip/".$image_name.".jpg";
            // copy('https://image-cardata.com/uploads/car_images/2023-09-09/2023-09-09_60222_79_2.jpg', $local_file);
            $check = false;
            if(\strpos($picture, 'https://p3.aleado.com') !== false ){
                $remote_page = $this->getPage($remote_file);
                $this->saveToFile($remote_page , false, $local_file);    
            }else if (\strpos($picture, 'https://image-cardata.com/') !== false ) {
                $remote_page = $this->getPage($remote_file);
                $this->saveToFile($remote_page , false, $local_file);    
            }else if (\strpos($picture, 'https://yjapanauction.com/') !== false ) {
                $remote_page = $this->getPage($remote_file);
                $this->saveToFile($remote_page , false, $local_file);    
            }else{
                $remote_file=public_path("/storage/uploads/cars/".$auction_photo->photo_short_link);
        
                // $remote_page = $this->getPage($remote_file);
                // $this->saveToFile($remote_file , false, $local_file);  
     
                $check = true;
            }
            $get_pic[]= $image_name;
        }
        $zip = new ZipArchive;
        $fileName = date("Y-m-d").' №'.$stock_id.'_'.rand(2000000000,9999999999).'.zip';
        if($check == true){
                if ($zip->open(public_path($fileName), ZipArchive::CREATE) === TRUE)
                {
                    $files = File::files(public_path('/storage/uploads/cars'));
                    foreach($auction_photos as $image ){     
                        foreach($files as $val ){
                            if($image->photo_short_link == basename($val)){
                                $relativeNameInZipFile = $image->photo_short_link.'.jpg';
                                $zip->addFile($val, $relativeNameInZipFile);
                            }
                        }
                        
                    }
                    $zip->close();
        
                }
                return response()->download(public_path($fileName));
        }else{
            if ($zip->open(public_path($fileName), ZipArchive::CREATE) === TRUE)
            {
                $files = File::files(public_path('/storage/upload/cars/temp_zip'));
                foreach($files as $val ){  
                        $relativeNameInZipFile =basename($val);
                        $zip->addFile($val, $relativeNameInZipFile);
                }
                $zip->close();
    
            }
            foreach($files as $val ){  
                @unlink($val);
            }
            return response()->download(public_path($fileName));
        }
       
    }


    function getPage($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, FALSE);
        curl_setopt($ch, CURLOPT_HEADER, false);
        curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 50);
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_REFERER, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        $result = curl_exec($ch);
        curl_close($ch);
        return $result;
    }

    function saveToFile($base, $decode=false, $output_file)
    {
            $ifp = fopen($output_file, "wb");
            if ($decode){
              fwrite($ifp, base64_decode($base));
            }else{
              fwrite($ifp, $base);
            }
            fclose($ifp);
            return($output_file);
    }

    function saveTomachine($get_pic){
        $zip = new ZipArchive;
        $fileName = 'itsolutionsguides.zip';

        if ($zip->open(public_path($fileName), ZipArchive::CREATE) === TRUE)
        {
            foreach($get_pic as $value ){
                $files = File::files(public_path('/storage/upload/cars'));
                foreach($files as $val ){        
                    $relativeNameInZipFile = $value.'.jpg';
                    $zip->addFile($val, $relativeNameInZipFile);
                }
            }
            $zip->close();
        }
       return response()->download(public_path($fileName));
    }

    public function download_yard_zip(Request $request){
        $stock_id = $request->get('stock_id');
        $chassis_no = $request->get('chassis_no');
        $images =  Stocklist_model::select_image_upload_yard($stock_id);
        $zip = new ZipArchive;
        $fileName = $chassis_no.'_'.rand(2000000000,9999999999).'.zip';
        if ($zip->open(public_path($fileName), ZipArchive::CREATE) === TRUE)
        {
            $files = File::files(public_path('/storage/uploads/cars'));
            foreach($images as $image ){     
                foreach($files as $val ){
                    if($image->photo_short_link == basename($val)){
                        $relativeNameInZipFile = $image->photo_short_link.'.jpg';
                        $zip->addFile($val, $relativeNameInZipFile);
                    }
                }     
            }
            $zip->close();
        }
        return response()->download(public_path($fileName));
    }

    public function download_yard_two_zip(Request $request){
        $stock_id = $request->get('stock_id');
        $chassis_no = $request->get('chassis_no');
        $images =  Stocklist_model::select_image_upload_yard_two($stock_id);
        $zip = new ZipArchive;
        $fileName = $chassis_no.'_'.rand(2000000000,9999999999).'.zip';
        if ($zip->open(public_path($fileName), ZipArchive::CREATE) === TRUE)
        {
            $files = File::files(public_path('/storage/uploads/cars'));
            foreach($images as $image ){     
                foreach($files as $val ){
                    if($image->photo_short_link == basename($val)){
                        $relativeNameInZipFile = $image->photo_short_link.'.jpg';
                        $zip->addFile($val, $relativeNameInZipFile);
                    }
                }     
            }
            $zip->close();
        }
        return response()->download(public_path($fileName));
    }

    public function get_final_destination(){
        $final_dist_list = Stocklist_model::final_destination_info();
        return response()->json([
            'final_dist_list_info' => $final_dist_list
        ]);
    }
    

    public function GetCustomerInfo(){
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list($user->staff_id);
        $hide_paragay =  Stocklist_model::hide_car_paragay_on_stock_list($user->staff_id);
        $customer_info = Stocklist_model::select_customers_for_stock($hide_pakistan,$hide_paragay);

        return response()->json([
            'customer_info' => $customer_info
        ]);
    }
    public function yard_list(Request $request){
        $where_manul = "stock_yard_id <> ''" ;
        $perPage     = $request->get('perPage');
        $search      = $request->get('search_data');
        $check       = is_array(json_decode($search)) ? count(json_decode($search)) : 0;
        //  dd($search );
        if($check > 0){
            foreach(json_decode($search) as $val){
                // dd($search);
                if(!empty($val->City_Fitler)){
                    $where_manul = "erp_stock_yard_location.stock_city_id=".$val->City_Fitler;
                }
                if(!empty($val->Yard_Filter)){
                    $where_manul .= " AND erp_stock_yard_location.stock_yard_name LIKE '%".$val->Yard_Filter."%'";
                }
             }
         }
        //  DB::enableQueryLog();
        $data = DB::table('erp_stock_yard_location')
        ->select('*')
        ->leftjoin('erp_stock_city_location','erp_stock_yard_location.stock_city_id','=','erp_stock_city_location.stock_city_id')
        ->whereRaw(DB::raw($where_manul))
        ->orderBy('stock_yard_id','DESC')
        ->paginate($perPage);
        // dd(DB::getQueryLog());
        return response()->json([
            "yard_lists" => $data
        ], 200);
    }
    public function get_city_combo(){
        $data = DB::table('erp_stock_city_location')
        ->select('*')
        ->from('erp_stock_city_location')
        ->orderBy('stock_city_name','ASC')
        ->get();
        return response()->json([
            "city_list_combo" => $data
        ], 200);
    }
    public function insert_yard(Request $request){
        $insertYard = $request->get('insertYard');
        // dd($insertYard);
        foreach(json_decode($insertYard) as $val){
            $data=array(
                'stock_city_id'   =>$val->City_Name,
                'stock_yard_name' =>$val->Yard_Name,
            );
            // dd($data);
            $check_data = $this-> check_data($val->City_Name,$val->Yard_Name);
            if(count($check_data) > 0){
                return 'This Yard has Already!!!';
            }else{
                DB::table('erp_stock_yard_location')
                ->insert($data);
            }
        }
    }
    public function edit_yard(Request $request){
        $updateyard = $request->get('updateyard');
        // dd($updateyard);
        foreach(json_decode($updateyard) as $item){
            $yard_id =$item->yard_id;
            $city_edit=$item->City_edit;
            $yard_Name=$item->Yard_Name;
            $data=array(
                'stock_city_id'=>$city_edit,
                'stock_yard_name'=> $yard_Name,
            );
            // dd($data);
                DB::table('erp_stock_yard_location')
                ->where('stock_yard_id','=', $yard_id )
                ->update($data);
        }
    }
    public function delete_yard(Request $request){

        $delete_yard = $request->get('delete_yard');
        // dd($delete_yard);
        foreach(json_decode($delete_yard) as $item){
            $yard_id=$item->Stock_yard_id;
              DB::table('erp_stock_yard_location')
                 ->where('stock_yard_id','=', $yard_id)
                 ->delete();
    }
}
    public function check_data($City_Name,$Yard_Name){
        // DB::enableQueryLog();
        $data = DB::table('erp_stock_yard_location')
        ->select('*')
        ->leftjoin('erp_stock_city_location','erp_stock_yard_location.stock_city_id','=','erp_stock_city_location.stock_city_id')
        ->where('erp_stock_yard_location.stock_city_id','=',$City_Name)
        ->where('erp_stock_yard_location.stock_yard_name','=',$Yard_Name)
        ->get();
        // dd(DB::getQueryLog());
        return $data;

    }
    public function market_list(Request $request){
        $where_manul = "market_country_id <> ''" ;
        $perPage = $request->get('perPage');
        $search= $request->get('search_market_country');
        $check  = is_array(json_decode($search)) ? count(json_decode($search)) : 0;
            //  dd($search_market_country );
        if($check > 0){
                foreach(json_decode($search) as $val){
                    // dd($search);
                    if(!empty($val->Search_market_country)){
                        $where_manul = "erp_country_list.country_list_id=".$val->Search_market_country;
                    }
                 }
             }
        $data = DB::table('erp_market_country')
        ->select('country_name','market_country_id','erp_country_list.country_list_id')
        ->from('erp_market_country')
        ->leftJoin('erp_country_list','erp_country_list.country_list_id','=','erp_market_country.country_list_id')
        ->whereRaw(DB::raw($where_manul))
        ->orderBy('country_name','ASC')
        ->paginate($perPage);
        // dd(DB::getQueryLog());
        return response()->json([
            "market_lists" => $data
        ], 200);
}
    public function country_all(){
        $data = DB::table('erp_country_list')
        ->select('*')
        ->get();
        return response()->json([
            "country_list_all" => $data
        ], 200);
    }
    public function save_market(Request $request){
        $insertmarket = $request->get('insertmarket');
        // dd($insertmarket);
        foreach(json_decode($insertmarket) as $val){
            $array_stock_market=array(
                'country_list_id'   =>$val->country_name,
            );
            $check_market = $this-> check_market($val->country_name);
            if (count( $check_market) > 0) {
                 return'Market has already!!!!';
             }else{
                DB::table('erp_market_country')
                ->insert($array_stock_market);
            }
        }
    }
    public function insert_new_country(Request $request){
        $insert_new = $request->get('insert_new');
        // dd($insert_new);
        foreach(json_decode($insert_new) as $val){
            $array_country_new=array(
                'country_name'   =>$val->country_new,
            );
            $check_new_country = $this-> check_new_country($val->country_new);
            if (count($check_new_country) > 0) {
            }else{
            $id = DB::table('erp_country_list')
            ->insertGetId($array_country_new);
              return  $id ;
          }
        }
    }
    public function check_market($country_name){
        //  DB::enableQueryLog();
      $data = DB::table('erp_market_country')
        ->select('country_name','market_country_id','erp_country_list.country_list_id')
        ->from('erp_market_country')
        ->leftJoin('erp_country_list','erp_country_list.country_list_id','=','erp_market_country.country_list_id')
        ->where('erp_country_list.country_list_id','=',$country_name)
        ->orderBy('country_name','ASC')
        ->get();
        //   dd(DB::getQueryLog());
        return $data;
    }
    public function check_new_country($country_new){
        $data = DB::table('erp_country_list')
        ->select('*')
        ->where('erp_country_list.country_name','=',$country_new)
        ->get();
        return $data;
    }
    public function edit_market(Request $request){
        $edit_data = $request->get('edit_data');
        // dd($edit_data);
        foreach(json_decode($edit_data) as $item){
            $market_country_id =$item->market_country_id;
            $country_edit=$item-> Market_edit;
            $array_stock_market=array(
                'market_country_id'=> $market_country_id,
                'country_list_id'=> $country_edit,
            );
            //  dd( $array_stock_market);
            $check_market_country= $this->check_market_country_edit($country_edit);
            // dd(count($check_market_country));
            if(count($check_market_country) > 0){
                return 'Market has already!!';
            }else{
                DB::table('erp_market_country')
                ->where('market_country_id','=',$market_country_id)
                ->update($array_stock_market);
            }
        }
    }
    public function delete_market(Request $request){
        $delete_market_stcok = $request->get('delete_market_stcok');
           //  dd($delete_market_stcok);
        foreach(json_decode($delete_market_stcok) as $item){
            $market_country_id=$item->market_country_id;
              DB::table('erp_market_country')
                 ->where('market_country_id','=', $market_country_id)
                 ->delete();
        }
    }
    public function check_market_country_edit($country_edit){
        $data = DB::table('erp_market_country')
        ->select('country_name','market_country_id','erp_country_list.country_list_id')
        ->from('erp_market_country')
        ->leftJoin('erp_country_list','erp_country_list.country_list_id','=','erp_market_country.country_list_id')
        ->where('erp_country_list.country_list_id','=',$country_edit)
        ->orderBy('country_name','ASC')
        ->get();
        return $data;
    }
    public function get_cbm_list(){
            // DB::enableQueryLog();
        $data = DB::table('erp_car_price_cbm')
        ->select('erp_car_price_cbm.*','erp_staff.full_name','erp_country_list.country_name')
        ->from('erp_car_price_cbm')
        ->leftJoin('erp_country_list','erp_country_list.country_list_id','=','erp_car_price_cbm.country_id')
        ->leftJoin('erp_staff','erp_staff.staff_id','=','erp_car_price_cbm.staff_id')
        ->get();
        //  dd(DB::getQueryLog());
        return response()->json([
            "cbm_lists" => $data
        ], 200);
    }
    public function get_all_country_list(){
        $data = DB::table('erp_country_list')
        ->select('*')
        ->get();
        return response()->json([
            "all_country_lists" => $data
        ], 200);
    }
    public function insert_cbm(Request $request){
        $save_cbm  = $request->get('save_cbm');
        $user = Auth::user();
        // dd($user);
        foreach(json_decode($save_cbm) as $val){
            $current_date_time = date('Y-m-d H:i:s');
            $array_cbm=array(
                'country_id'     => $val->Add_country,
                'port_name'      => $val->Port_name,
                'cbm_price'      => $val->Price_cbm,
                'insurance'      => $val->Insurance,
                'inspection'     => $val->Inspection,
                'currency'       => $val->Currency,
                'create_date'    => $current_date_time,
                'staff_id'       => $user->staff_id,
            );
                // dd( $array_cbm);
             DB::table('erp_car_price_cbm')
            ->insert($array_cbm);
        }
    }
    public function cbm_modify(Request $request){
        $edit_cbm = $request->get('edit_cbm');
        $user = Auth::user();
        // dd($edit_data);
        foreach(json_decode($edit_cbm) as $item){
            $car_price_cbm_id   =$item-> Car_price_cbm_id;
            $country_edit       =$item-> Country_edit;
            $port_name_edit     =$item-> Port_name_edit;
            $price_cbm_edit     =$item-> Price_cbm_edit;
            $insurance_edit     =$item-> Insurance_edit;
            $inspection_edit    =$item-> Inspection_edit;
            $currency_edit      =$item-> Currency_edit;
            $array_cbm=array(
                'car_price_cbm_id'=> $car_price_cbm_id,
                'country_id'      => $country_edit,
                'port_name'       => $port_name_edit,
                'cbm_price'       => $price_cbm_edit,
                'insurance'       => $insurance_edit,
                'inspection'      => $inspection_edit,
                'currency'        => $currency_edit,
                'staff_id'        => $user->staff_id,
            );
                DB::table('erp_car_price_cbm')
                ->where('car_price_cbm_id','=',$car_price_cbm_id)
                ->update( $array_cbm,$user->staff_id);
        }
    }
    public function delete_cbm(Request $request){
        $cbm_delete = $request->get('cbm_delete');
        //  dd($cbm_delete);
     foreach(json_decode($cbm_delete) as $item){
         $dataChecked =$item->Car_price_cbm_id;
        //   dd($dataChecked );
           DB::table('erp_car_price_cbm')
              ->whereIntegerInRaw('car_price_cbm_id',[$dataChecked] )
              ->delete();
        }
    }

    // Car_size_model
    public function get_car_model_size_list(){
        //  DB::enableQueryLog();
        $data = DB::table('erp_car_model_size')
        ->select('erp_car_model_size.*','erp_staff.full_name')
        ->from('erp_car_model_size')
        ->leftJoin('erp_staff','erp_staff.staff_id','=','erp_car_model_size.staff_id')
        ->get();
        //   dd(DB::getQueryLog());
        return response()->json([
            "car_model_size_lists" => $data
        ], 200);
    }
    public function get_car_model_list(){
        $data = DB::table('erp_car_model')
        ->select('*')
        ->from('erp_car_model')
        ->orderBy("car_model_name","ASC")
        ->get();
        return response()->json([
            "all_car_model_list" => $data
        ], 200);
    }
    public function insert_car_model_size(Request $request){
        $save_car_size = $request->get('save_car_size');
        $user = Auth::user();
        //   dd( $user_data);
        foreach(json_decode($save_car_size) as $val){
            $current_date_time = date('Y-m-d h:i:sa');
            $array_car_model_size=array(
                'car_model'         =>$val->Add_model_car,
                'car_model_code'    =>$val->Model_code,
                'car_size'          =>$val->Cbm_value,
                'create_date'       =>$current_date_time,
                'staff_id'          => $user->staff_id,
            );
              DB::table('erp_car_model_size')
             ->insert($array_car_model_size);
        }
    }
    public function car_model_size_modify(Request $request){
        $modify_model_car_size = $request->get('modify_model_car_size');
        $user = Auth::user();
        // dd($modify_model_car_size);
        foreach(json_decode($modify_model_car_size) as $item){
            $car_model_size_id   =$item-> Car_model_size_id;
            $model_edit          =$item-> Model_edit;
            $model_code_edit     =$item-> Model_code_edit;
            $cbm_value_edit      =$item-> Cbm_value_edit;

            $array_car_model_size=array(
                'car_model_size_id' => $car_model_size_id ,
                'car_model'         => $model_edit,
                'car_model_code'    => $model_code_edit,
                'car_size'          => $cbm_value_edit,
                'staff_id'          => $user->staff_id,
            );
                DB::table('erp_car_model_size')
                ->where('car_model_size_id','=', $car_model_size_id)
                ->update($array_car_model_size,$user->staff_id);
        }
    }
    public function delete_car_model_size(Request $request){
        $car_model_car_delete = $request->get('car_model_car_delete');
        //  dd($car_model_car_delete);
        foreach(json_decode($car_model_car_delete) as $item){
                $dataChecked =$item-> Car_model_size_id;
               //   dd($dataChecked );
                  DB::table('erp_car_model_size')
                     ->whereIntegerInRaw('car_model_size_id',[$dataChecked] )
                     ->delete();
            }
        }
        
        ///========Final Destination========///
    public function get_final_des_list(Request $request)
    {
        $perPage = $request->get('perPage');
        $where_manul = "id <>''";
        $search_txt_des = $request->get('search_txt_des');
        $check = is_array(json_decode($search_txt_des)) ? count(json_decode($search_txt_des)) : 0;
        // dd($search_txt_des);
        if ($check > 0) {
            foreach (json_decode($search_txt_des) as $val) {
                if (!empty($val->Search_final_des)) {
                    $where_manul = "erp_final_destination.final_des_name LIKE '%" . $val->Search_final_des . "%'";
                }
            }
        }
        $data = DB::table('erp_final_destination')
            ->select('*')
            ->whereRaw(DB::raw($where_manul))
            ->paginate($perPage);
        return response()->json([
            "final_des_lists" => $data
        ], 200);
    }
    public function insert_final_des_stock(Request $request)
    {
        $insertfinaldes = $request->get('insertfinaldes');
        //    dd( $insertfinaldes);
        foreach (json_decode($insertfinaldes) as $val) {
            $current_date_time = date('Y-m-d H:i:s');
            $array_final_des = array(
                'final_des_name' => $val->Final_des_name,
                'created_dt' => $current_date_time
            );
            DB::table('erp_final_destination')
                ->insert($array_final_des);
        }
    }
    public function update_final_des_stock(Request $request)
    {
        $edit_final_des = $request->get('edit_final_des');
        // dd($edit_final_des);
        foreach (json_decode($edit_final_des) as $item) {
            $id = $item->final_id;
            $final_des_name_edit = $item->Final_des_name_edit;
            $array_final_des = array(
                'id' => $id,
                'final_des_name' => $final_des_name_edit,
            );
            DB::table('erp_final_destination')
                ->where('id', '=', $id)
                ->update($array_final_des);
        }
    }
    public function delete_final_des_stock(Request $request)
    {
        $deletefinaldes = $request->get('deletefinaldes');
        // dd($deletefinaldes);
        foreach (json_decode($deletefinaldes) as $item) {
            $id = $item->final_id;
            DB::table('erp_final_destination')
                ->where('id', '=', $id)
                ->delete();
        }
    }

    public function staff_cambodia($staff_id){
        $status = false;
        $data = DB::table('erp_staff AS s')
                  ->select('s.staff_id','s.full_name','c.country_name')
                  ->leftjoin('erp_country_list AS c','s.country_list_id','=','c.country_list_id')
                  ->where('s.staff_id','=',$staff_id)
                  ->get();
        foreach($data as $val){
            if ($val->country_name === "Cambodia") {
                $status = true;
            }
        }
        return $status;
    }

    public function data_group_user($id){
        $data = DB::table('users_groups AS a')
          ->select('b.name')
          ->leftjoin('groups AS b','b.id','a.group_id')
          ->where('a.staff_id','=',$id)
          ->get();
          return $data;
     }

     public function stock_list_modify(Request $request){
        $stock_id = $request->get('stock_id');
        $erp_stock_lists= Stocklist_model::select_data_stock_list($stock_id);
        $get_reserved_info = Stocklist_model::get_sold_price_distination($stock_id);
        $all_car_documents = Stocklist_model::getAllCarDocumentsByStockId($stock_id);
        $erp_country_list = Stocklist_model::country_list();
        $erp_car_color = Stocklist_model::get_car_color();
        $erp_stock_type = Stocklist_model::GetStockType();
        $erp_stock_status = Stocklist_model::get_car_status();
        $erp_discharge_list = Stocklist_model::discharge_info();
        $final_dist_list = Stocklist_model::final_destination_info();
        $erp_customer_list = Stocklist_model::get_customer_list();
        $get_market_country = Stocklist_model::GetMarketCountry();
        $get_car_location_country = Stocklist_model::get_car_location_country();
        $get_car_city =  Stocklist_model::get_car_city();
        $get_car_yard = Stocklist_model::get_car_yard();
        $get_make_car = Stocklist_model::GetMake();
        $car_make_id =  $erp_stock_lists[0]->car_make_id;
        $get_car_model =  Stocklist_model::ChangeCarModel($car_make_id);
        $get_boss_prices = Stocklist_model::get_boss_price_modify($stock_id);

        //Count file document
        $count_ec = Stocklist_model::count_file_doc($stock_id,'ec');
        $count_ece = Stocklist_model::count_file_doc($stock_id,'ece');
        $count_lc = Stocklist_model::count_file_doc($stock_id,'lc');
        $count_certificate = Stocklist_model::count_file_doc($stock_id,'certificate');
        $customer_id = $erp_stock_lists[0]->customer_id;
        $data['car_consignee'] = '';
        if(!empty($customer_id)){
            $data['car_consignee']=Stocklist_model::select_car_consignee($customer_id);
        }
  
        $data['erp_stock_lists'] =  $erp_stock_lists;
        $data['erp_stock_type'] = $erp_stock_type;
        $data['get_reserved_info'] =  $get_reserved_info;
        $data['erp_country_list'] = $erp_country_list;
        $data['get_market_country'] =$get_market_country;
        $data['get_stock_status'] = $erp_stock_status;
        $data['get_car_location_country'] = $get_car_location_country;
        $data['get_car_city'] = $get_car_city;
        $data['get_car_yard'] = $get_car_yard;
        $data['get_make_car'] = $get_make_car;
        $data['get_car_model'] = $get_car_model;
        $data['erp_car_color'] =  $erp_car_color;
        $data['count_ec'] = @$count_ec[0]->count;
        $data['count_ece'] = @$count_ece[0]->count;
        $data['count_lc'] = @$count_lc[0]->count;
        $data['all_car_documents'] = $all_car_documents;
        $data['count_certificate'] = @$count_certificate[0]->count;
        $data['get_boss_prices'] = $get_boss_prices;
  
        return response()->json([
          $data
        ]);
      }

      public function get_consignee_for_car(Request $request){
        $consignee_id = $request->get('consignee_id');
        $data = array();
        if(!empty($consignee_id)){
            $data=Stocklist_model::select_car_consignee_with_id($consignee_id);
        }
        return response()->json([
            'consignee_data' => $data
        ]);
      }

      public function upload_file_execute(Request $request){
        $manager = new ImageManager(new Driver());
        $file_data = $request->file('files');
        $stock_id = $request->get('stock_id');
        $page = $request->get('page');
        $data = array();
        $check_insert = '';
        $photo_order= 0;
        if($request->hasFile('files')){
            $targetPath = 'uploads/pdf_files/';
            $apiKey  = 'vuthy32@gmail.com_eb090f7c04d550ee5a59c92455fcfbeee72711e9c7c66625507106c779d3b139cbc354f5';
           
            foreach($file_data as $file){
                $fname_compress = date('Ymd_His') . '_' . mt_rand('0000000','9999999') . '.' . "pdf";
                $photo_order +=1;
                $fileName = time().'_'.$file->getClientOriginalName();
                $ext = explode('.', $file->getClientOriginalName());
                $ext = end($ext);
                $ext = strtolower($ext);
                if($ext != "pdf" && $ext != "gif" && $ext != "jpg" && $ext != "jpeg" && $ext != "png"){
                   echo json_encode('You can upload only file pdf!');
                }
      
                if($ext =='pdf'){
                    
                    $url = "https://api.pdf.co/v1/file/upload/get-presigned-url" . 
                    "?name=" . urlencode($file->getClientOriginalName()) .
                    "&contenttype=application/octet-stream";
                        // Create request
                        $curl = curl_init();
                        curl_setopt($curl, CURLOPT_HTTPHEADER, array("x-api-key: " . $apiKey));
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                        // Execute request
                        $result = curl_exec($curl);

                        if (curl_errno($curl) == 0)
                        {
                            $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                            
                            if ($status_code == 200)
                            {
                                $json = json_decode($result, true);
                                
                                // Get URL to use for the file upload
                                $uploadFileUrl = $json["presignedUrl"];
                                // Get URL of uploaded file to use with later API calls
                                $uploadedFileUrl = $json["url"];
                                
                                // 2. UPLOAD THE FILE TO CLOUD.
                                
                                $localFile = $file->getRealPath();
                                $fileHandle = fopen($localFile, "r");
                                
                                curl_setopt($curl, CURLOPT_URL, $uploadFileUrl);
                                curl_setopt($curl, CURLOPT_HTTPHEADER, array("content-type: application/octet-stream"));
                                curl_setopt($curl, CURLOPT_PUT, true);
                                curl_setopt($curl, CURLOPT_INFILE, $fileHandle);
                                curl_setopt($curl, CURLOPT_INFILESIZE, filesize($localFile));
                
                                // Execute request
                                curl_exec($curl);
                                
                                fclose($fileHandle);
                                
                                if (curl_errno($curl) == 0)
                                {
                                    $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                                    
                                    if ($status_code == 200)
                                    {
                                        // 3. OPTIMIZE UPLOADED PDF FILE
                                        
                                        $this->OptimizePdf($apiKey, $uploadedFileUrl, $fname_compress);
                                    }
                                    else
                                    {
                                        // Display request error
                                        dd("<p>Status code: " . $status_code . "</p>"); 
                                        echo "<p>" . $result . "</p>"; 
                                    }
                                }
                                else
                                {
                                    // Display CURL error
                                    dd("Error: " . curl_error($curl));
                                }
                            }
                    } else
                    {
                        // Display CURL error
                        echo "Error: " . curl_error($curl);
                    }
                    move_uploaded_file($file->getRealPath(), storage_path('app/public/'.$targetPath.$fname_compress));
                }elseif($ext == "png" || $ext=="jpeg" || $ext == 'jpg'){

                    $uploadedFiles = array();
                    $name_pdf =$fname_compress;
                    
                        $url = "https://api.pdf.co/v1/file/upload/get-presigned-url" . 
                            "?name=" . urlencode($file->getClientOriginalName()) .
                            "&contenttype=application/octet-stream";

                        // Create request
                        $curl = curl_init();
                        curl_setopt($curl, CURLOPT_HTTPHEADER, array("x-api-key: " . $apiKey));
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                        // Execute request
                        $result = curl_exec($curl);

                        if (curl_errno($curl) == 0)
                        {
                            $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

                            if ($status_code == 200)
                            {
                                $json = json_decode($result, true);

                                // Get URL to use for the file upload
                                $uploadFileUrl = $json["presignedUrl"];
                                // Get URL of uploaded file to use with later API calls
                                $uploadedFileUrl = $json["url"];   

                                $tmpFilePath = $file->getRealPath();

                                $fileHandle = fopen($tmpFilePath, "r");

                                curl_setopt($curl, CURLOPT_URL, $uploadFileUrl);
                                curl_setopt($curl, CURLOPT_HTTPHEADER, array("content-type: application/octet-stream"));
                                curl_setopt($curl, CURLOPT_PUT, true);
                                curl_setopt($curl, CURLOPT_INFILE, $fileHandle);
                                curl_setopt($curl, CURLOPT_INFILESIZE, filesize($tmpFilePath));

                                // Execute request
                                curl_exec($curl);

                                if (curl_errno($curl) == 0)
                                {
                                    $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

                                    if ($status_code == 200)
                                    {
                                        $uploadedFiles[] = $uploadedFileUrl;
                                    }
                                    else
                                    {
                                        // Display request error
                                        echo "<p>Uploading File Status code: " . $status_code . " : " . $uploadedFileUrl . "</p>"; 
                                        echo "<p>error status for uploading files (1 means error related to php.ini config or tmp folder permissions): " . $_FILES['files']['error'] . "</p>";
                                        echo "<p>" . $result . "</p>"; 
                                    }
                                }
                                else
                                {
                                    // Display CURL error
                                    return response()->json([
                                        'status' => false,
                                        'message' => curl_error($curl)
                                    ]);
                                }

                                fclose($fileHandle);
                            }
                            else
                            {
                                // Display request error
                                return response()->json([
                                   'status' => $status_code,
                                    'message' => $result
                                ]);
                            }
                        }
                        else
                        {
                            // Display CURL error
                            return response()->json([
                                'status' => 200,
                                'message' => curl_error($curl)
                            ]);
                        }

                        curl_close($curl); 

                    if (count($uploadedFiles) > 0) 
                    {
                        $this->ImageToPdf($apiKey, $uploadedFiles,$name_pdf,$fname_compress);
                    }
                }
              
            }
          
            if (!empty($stock_id)) {
                if (file_exists(storage_path('app/public/uploads/pdf_files/'.$fname_compress))) {

                    $user = Auth::user();
                
                    $car_document_file =  $fname_compress;
                    $updateData = [
                        'car_document_file' => $car_document_file,
                        'car_documents' => "y",
                    ];
                    DB::table('erp_stock_list')
                        ->where('stock_id','=',$stock_id)
                        ->update($updateData);

                    if($page === 'shipment'){
                        $data_documents=array(
                            'stock_id'      => $stock_id,
                            'status'        => 'YES',
                            'updated_date'  => date('Y-m-d H:i:s'),
                            'staff_id'      => $user->staff_id
                        );
                        Stocklist_model::add_car_documents_history($data_documents);
                    }
                    
                }else{
                    echo 'Failed';
                }
            }
            return response()->json([
                'status' => true,
                'message' => 'successfully'
            ]);
        }
      }

      public function UploadFileDocument(Request $request){
        $manager = new ImageManager(new Driver());
        $file_data = $request->file('files');
        $stock_id = $request->get('stock_id');
        $doc_type = $request->get('doc_type');
        $data = array();
        $check_insert = '';
        $photo_order= 0;
        if($request->hasFile('files')){
            $targetPath = 'uploads/pdf_files/';
            $apiKey  = 'vuthy32@gmail.com_eb090f7c04d550ee5a59c92455fcfbeee72711e9c7c66625507106c779d3b139cbc354f5';
           
            foreach($file_data as $file){
                $fname_compress = date('Ymd_His') . '_' . mt_rand('0000000','9999999') . '.' . "pdf";
                $photo_order +=1;
                $fileName = time().'_'.$file->getClientOriginalName();
                $ext = explode('.', $file->getClientOriginalName());
                $ext = end($ext);
                $ext = strtolower($ext);
                if($ext != "pdf" && $ext != "gif" && $ext != "jpg" && $ext != "jpeg" && $ext != "png"){
                   echo json_encode('You can upload only file pdf!');
                }
      
                if($ext =='pdf'){
                    
                    $url = "https://api.pdf.co/v1/file/upload/get-presigned-url" . 
                    "?name=" . urlencode($file->getClientOriginalName()) .
                    "&contenttype=application/octet-stream";
                        // Create request
                        $curl = curl_init();
                        curl_setopt($curl, CURLOPT_HTTPHEADER, array("x-api-key: " . $apiKey));
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                        // Execute request
                        $result = curl_exec($curl);

                        if (curl_errno($curl) == 0)
                        {
                            $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                            
                            if ($status_code == 200)
                            {
                                $json = json_decode($result, true);
                                
                                // Get URL to use for the file upload
                                $uploadFileUrl = $json["presignedUrl"];
                                // Get URL of uploaded file to use with later API calls
                                $uploadedFileUrl = $json["url"];
                                
                                // 2. UPLOAD THE FILE TO CLOUD.
                                
                                $localFile = $file->getRealPath();
                                $fileHandle = fopen($localFile, "r");
                                
                                curl_setopt($curl, CURLOPT_URL, $uploadFileUrl);
                                curl_setopt($curl, CURLOPT_HTTPHEADER, array("content-type: application/octet-stream"));
                                curl_setopt($curl, CURLOPT_PUT, true);
                                curl_setopt($curl, CURLOPT_INFILE, $fileHandle);
                                curl_setopt($curl, CURLOPT_INFILESIZE, filesize($localFile));
                
                                // Execute request
                                curl_exec($curl);
                                
                                fclose($fileHandle);
                                
                                if (curl_errno($curl) == 0)
                                {
                                    $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
                                    
                                    if ($status_code == 200)
                                    {
                                        // 3. OPTIMIZE UPLOADED PDF FILE
                                        
                                        $this->OptimizePdf($apiKey, $uploadedFileUrl, $fname_compress);
                                    }
                                    else
                                    {
                                        // Display request error
                                        dd("<p>Status code: " . $status_code . "</p>"); 
                                        echo "<p>" . $result . "</p>"; 
                                    }
                                }
                                else
                                {
                                    // Display CURL error
                                    dd("Error: " . curl_error($curl));
                                }
                            }
                    } else
                    {
                        // Display CURL error
                        echo "Error: " . curl_error($curl);
                    }
                    move_uploaded_file($file->getRealPath(), storage_path('app/public/'.$targetPath.$fname_compress));
                }elseif($ext == "png" || $ext=="jpeg" || $ext == 'jpg'){

                    $uploadedFiles = array();
                    $name_pdf =$fname_compress;
                    
                        $url = "https://api.pdf.co/v1/file/upload/get-presigned-url" . 
                            "?name=" . urlencode($file->getClientOriginalName()) .
                            "&contenttype=application/octet-stream";

                        // Create request
                        $curl = curl_init();
                        curl_setopt($curl, CURLOPT_HTTPHEADER, array("x-api-key: " . $apiKey));
                        curl_setopt($curl, CURLOPT_URL, $url);
                        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
                        // Execute request
                        $result = curl_exec($curl);

                        if (curl_errno($curl) == 0)
                        {
                            $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

                            if ($status_code == 200)
                            {
                                $json = json_decode($result, true);

                                // Get URL to use for the file upload
                                $uploadFileUrl = $json["presignedUrl"];
                                // Get URL of uploaded file to use with later API calls
                                $uploadedFileUrl = $json["url"];   

                                $tmpFilePath = $file->getRealPath();

                                $fileHandle = fopen($tmpFilePath, "r");

                                curl_setopt($curl, CURLOPT_URL, $uploadFileUrl);
                                curl_setopt($curl, CURLOPT_HTTPHEADER, array("content-type: application/octet-stream"));
                                curl_setopt($curl, CURLOPT_PUT, true);
                                curl_setopt($curl, CURLOPT_INFILE, $fileHandle);
                                curl_setopt($curl, CURLOPT_INFILESIZE, filesize($tmpFilePath));

                                // Execute request
                                curl_exec($curl);

                                if (curl_errno($curl) == 0)
                                {
                                    $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

                                    if ($status_code == 200)
                                    {
                                        $uploadedFiles[] = $uploadedFileUrl;
                                    }
                                    else
                                    {
                                        // Display request error
                                        echo "<p>Uploading File Status code: " . $status_code . " : " . $uploadedFileUrl . "</p>"; 
                                        echo "<p>error status for uploading files (1 means error related to php.ini config or tmp folder permissions): " . $_FILES['files']['error'] . "</p>";
                                        echo "<p>" . $result . "</p>"; 
                                    }
                                }
                                else
                                {
                                    // Display CURL error
                                    return response()->json([
                                        'status' => false,
                                        'message' => curl_error($curl)
                                    ]);
                                }

                                fclose($fileHandle);
                            }
                            else
                            {
                                // Display request error
                                return response()->json([
                                   'status' => $status_code,
                                    'message' => $result
                                ]);
                            }
                        }
                        else
                        {
                            // Display CURL error
                            return response()->json([
                                'status' => 200,
                                'message' => curl_error($curl)
                            ]);
                        }

                        curl_close($curl); 

                    if (count($uploadedFiles) > 0) 
                    {
                        $this->ImageToPdf($apiKey, $uploadedFiles,$name_pdf,$fname_compress);
                    }
                }
              
            }
          

            if (file_exists(storage_path('app/public/uploads/pdf_files/'.$fname_compress))) {

                $targetPath =storage_path('app/public/uploads/pdf_files/');

               //upload file type bl
               if($doc_type=="bl"){
                    $get_stock_id = Stocklist_model::get_stock_id($stock_id,$doc_type);
                    foreach ($get_stock_id as $stock_id) {
                        $data['stock_id'] = $stock_id->stock_id;

                        $data['doc_type'] = $doc_type;

                        $data['file_name'] = $fileName;
                        
                        $data['file_path']  = '/upload/pdf_files/';

                        $data['upload_date'] = date('Y-m-d H:i:s');

                        $count_doc = Stocklist_model::select_count_file_upload($stock_id,$doc_type);
                       
                        if($count_doc > 0){
                            Stocklist_model::update_count_file_upload($stock_id,$doc_type,$data);
                        }else{
                            Stocklist_model::insert_count_file_upload($data);
                        }
                    }
                    
                }else{
                    $data['stock_id'] = $stock_id;

                    $data['doc_type'] = $doc_type;
    
                    $data['file_name'] = $fname_compress;
                    
                    $data['file_path']  = '/uploads/pdf_files/';
    
                    $data['upload_date'] = date('Y-m-d H:i:s');
    
                   $count_doc = Stocklist_model::select_count_file_upload($stock_id,$doc_type);
                   if($count_doc[0]->numrows > 0){
                        Stocklist_model::update_count_file_upload($stock_id,$doc_type,$data);
                   }else{
                        Stocklist_model::insert_count_file_upload($data);
                   }
    
                }
                // $this->send_email_for_stock_id($shipment_id,$stock_id);
            }else{
                echo 'Failed';
            }
            return response()->json([
                'status' => true,
                'message' => 'successfully'
            ]);
        }

    }
    function OptimizePdf($apiKey, $uploadedFileUrl,$fname_compress) 
    {

    
        // Prepare URL for `Optimize PDF` API call
        $url = "https://api.pdf.co/v1/pdf/optimize";
    
        // Prepare requests params
        $parameters = array();
        $parameters["name"] = "result.pdf";
        $parameters["url"] = $uploadedFileUrl;

        // Create Json payload
        $data = json_encode($parameters);

        // Create request
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("x-api-key: " . $apiKey, "Content-type: application/json"));
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);

        // Execute request
        $result = curl_exec($curl);
        
        if (curl_errno($curl) == 0)
        {
        
            $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
            
            if ($status_code == 200)
            {
                $json = json_decode($result, true);
                
                if (!isset($json["error"]) || $json["error"] == false)
                {
                    $resultFileUrl = $json["url"];
                    $file_name = $fname_compress;
                    $c= $file_name;
                    file_put_contents(storage_path('app/public/uploads/pdf_files/file_compressed/'.$c), file_get_contents($resultFileUrl));
                }
                else
                {
                    // Display service reported error
                    dd("<p>Error: " . $json["message"] . "</p>"); 
                }
            }
            else
            {
                // Display request error
                echo "<p>Status code: " . $status_code . "</p>"; 
                echo "<p>" . $result . "</p>"; 
            }
        }
        else
        {
            // Display CURL error
            echo "Error: " . curl_error($curl);
        }
        
        // Cleanup
        curl_close($curl);
    }

    function ImageToPdf($apiKey, $uploadedFiles,$fname_compress) 
    {
        // Create URL
        $url = "https://api.pdf.co/v1/pdf/convert/from/image";

        // Prepare requests params
        $parameters = array();
        $parameters["name"] = "result.pdf";
        $parameters["url"] = join(",", $uploadedFiles);

        // Create Json payload
        $data = json_encode($parameters);

        // Create request
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_HTTPHEADER, array("x-api-key: " . $apiKey, "Content-type: application/json"));
        curl_setopt($curl, CURLOPT_URL, $url);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $data);

        // Execute request
        $result = curl_exec($curl);

        if (curl_errno($curl) == 0)
        {
            $status_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);

            if ($status_code == 200)
            {
                $json = json_decode($result, true);

                if (!isset($json["error"]) || $json["error"] == false)
                {
                    $resultFileUrl = $json["url"];
                    $c =$fname_compress;
                    file_put_contents(storage_path('app/public'.'/uploads/pdf_files/file_compressed/'.$c), file_get_contents($resultFileUrl));
                    file_put_contents(storage_path('app/public'.'/uploads/pdf_files/'.$c), file_get_contents($resultFileUrl));
                }
                else
                {
                    // Display service reported error
                    echo "<p>PDF.co API execution Error: " . $json["message"] . "</p>"; 
                }
            }
            else
            {
                // Display request error
                echo "<p>API Call Status code: " . $status_code . ": " . $url . "</p>"; 
                echo "<p>" . $result . "</p>"; 
            }
        }
        else
        {
            // Display CURL error
            echo "cURL Error 2: " . curl_error($curl);
        }

        // Cleanup
        curl_close($curl);
    }

    function get_file_upload_doc(Request $request){
        $data = DB::table('erp_stock_list_doc')
                  ->where('stock_id',$request->stock_id)
                  ->where('doc_type',$request->doc_type)
                  ->get();
        return response()->json([
          'data_auctions' => $data
        ]);
    }

    function get_file_upload_ship(Request $request){
        $stock_id = $request->get('stock_id');
        $data = DB::table('erp_stock_list')
            ->select('*')
            ->where('stock_id','=',$stock_id)
            ->get();
        return response()->json([
        'data_auctions' => $data
        ]);
    }



    public function check_status(Request $request){
        $stock_id = $request->get('stock_id');
        $data = DB::table('erp_stock_list')
                 ->select('status')
                 ->where('stock_id','=',$stock_id)
                 ->get();
        return response()->json([
            'status' => $data[0]->status
        ]);

    }

    public function check_status_all(Request $request){   
        $stock_dis = $request->get('dataChecked');
        $arr_stock = explode(',',$stock_dis);
        foreach($arr_stock as $stock){
            $data = DB::table('erp_stock_list')
                    ->select('status')
                    ->where('stock_id','=',$stock)
                    ->get();
            if($data[0]->status != 7){
                return response()->json([
                    'status' => false
                ]);
            }
        } 
        return response()->json([
            'status' => true
        ]);
    }

    public function check_status_reserve(Request $request){   
        $stock_dis = $request->get('dataChecked');
        $arr_stock = explode(',',$stock_dis);
        foreach($arr_stock as $stock){
            $data = DB::table('erp_stock_list')
                    ->select('status')
                    ->where('stock_id','=',$stock)
                    ->get();
            if($data[0]->status != 2){
                return response()->json([
                    'status' => false
                ]);
            }
        } 
        return response()->json([
            'status' => true
        ]);
    }

    public function cancel_reserve(Request $request){
        $stock_dis = $request->get('dataChecked');
        $arr_stock = explode(',',$stock_dis);
        $data_stock_list = array(
            'customer_id' => NULL,
            'status' => 1,
            'car_customer_en' => NULL,
            'car_sale_en' => NULL,
            'car_customer_en' => NULL
        );
        $data_stock_list1 = array(
            'customer_id' => NULL,
            'status' => 1,
            'car_customer_en' => NULL,
            'car_sale_en' => NULL,
            'consignee_name' => NULL,
            'consignee_address' => NULL,
            'consignee_phone' => NULL,
            'car_customer_en' => NULL,
            'car_sale_en' => NULL,
            'consignee_other_info' => NULL
        );

        if(!empty($arr_stock)){
            foreach($arr_stock as $stock){
                $get_stock_info = Stocklist_model::get_shipment_car_info($stock);
                $date_now = date("Y-m-d");
                if($get_stock_info[0]->etd >= $date_now){
                    // update stock list
                    DB::table('erp_stock_list')
                      ->where('stock_id','=',$stock)
                      ->update($data_stock_list1);
                }else{
                    // update stock list
                    DB::table('erp_stock_list')
                      ->where('stock_id','=',$stock)
                      ->update($data_stock_list);
                }
                //delete from car reserve
                DB::table('erp_car_reserve')
                   ->where('stock_id','=',$stock)
                   ->delete();

                //insert to car history
                $user = Auth::user();
                $data_car_history = array(
                    'stock_id' =>$stock,
                    'status' => 'active',
                    'car_status' => 'Canceled',
                    'staff_id' => $user->staff_id,
                    'create_date'      => date('Y-m-d H:i:s')
                );
      
                DB::table('erp_cars_status_history')
                  ->insert($data_car_history);
                  
                //delete from car payment
                $sql = "customer_deposit_type = 'customer_deposit' OR customer_deposit_type = 'customer_auction_deposit'";
                    DB::table('erp_carpayments as a')
                    ->leftjoin('erp_customer_deposit as b','a.customer_deposit_id','=','b.customer_deposit_id')
                    ->leftjoin('erp_deposit_income as d','d.deposit_income_id','=','b.deposit_income_id')
                    ->where('a.stock_id','=',$stock)
                    ->whereRaw(DB::raw($sql))
                    ->delete(); 
            }
        }

    }

    public function select_car_reserve(Request $request){
        $stock_dis = $request->get('dataChecked');
        $arr_stock = explode(',',$stock_dis);
            $sub_query = '(SELECT cc.car_stock_id,cc.boss_price,cc.currency,cc.boss_price_type FROM (SELECT * FROM erp_stock_list_boss_price ) AS cc
            WHERE cc.boss_price_id IN (SELECT MAX( boss_price_id ) FROM erp_stock_list_boss_price GROUP BY car_stock_id ))
             AS boss';
             $data = DB::table('erp_stock_list AS a')
             ->leftjoin('erp_car_make AS b','b.car_make_id','=','a.car_make_id')
             ->leftjoin(DB::raw($sub_query),'boss.car_stock_id','=','a.car_stock_id')
             ->leftjoin('erp_stock_list_car_status AS e','e.stock_list_car_status_id','=','a.status')
             ->leftjoin('erp_car_model AS d','d.car_model_id','=','a.car_model_id')
             ->whereIn("a.stock_id",$arr_stock)
             ->get();
        return response()->json([
            'car_lists_reserve' => $data
        ]);
                                   
    }

    public function cancel_shipok(Request $request){
        $stock_dis = $request->get('dataChecked');
        $arr_stock = explode(',',$stock_dis);
        $data_stock_list = array(
            'status' => 2
        );
        $user = Auth::user();
        if(!empty($arr_stock)){
            foreach($arr_stock as $stock){
                DB::table('erp_stock_list')
                  ->where('stock_id','=',$stock)
                  ->update($data_stock_list);

                //insert to car history
                $data_car_history = array(
                    'stock_id' => $stock,
                    'status' => 'active',
                    'car_status' => 'Cancel ShipOk',
                    'staff_id' => $user->staff_id,
                    'create_date'      => date('Y-m-d H:i:s')
                );
                DB::table('erp_cars_status_history')
                  ->insert($data_car_history);

                //delete from car payment
                $sql = "customer_deposit_type = 'customer_deposit' OR customer_deposit_type = 'customer_auction_deposit'";
                DB::table('erp_carpayments as a')
                  ->leftjoin('erp_customer_deposit as b','a.customer_deposit_id','=','b.customer_deposit_id')
                  ->leftjoin('erp_deposit_income as d','d.deposit_income_id','=','b.deposit_income_id')
                  ->where('a.stock_id','=',$stock)
                  ->whereRaw(DB::raw($sql))
                  ->delete();
            }
        }
    }

    public function save_reserve_car(Request $request){
        $stock_ids = $request->get('search_data');
        foreach(json_decode($stock_ids) as $val){
            $user = Auth::user();
            $reserve_customers = $val->reserve_customers_p;
            $customer = explode(',', $reserve_customers);
            if ($val->res_type_p == 'CIF') {
                $data = array(
                    'stock_id' => $val->stock_id_p,
                    'fob' => $val->fob_p,
                    'freight_fee' => $val->freight_fee_p,
                    'customer_id' => $customer[0],
                    'staff_id' => $user->staff_id,
                    'vessel' => $val->reserve_vessel_p,
                    'currency' => $val->car_currency,
                    'created_dt' => date('Y-m-d'),
                    'insurance' => $val->insurance_p,
                    'discharge_id' => $val->reserve_discharge_p,
                    'other_fee' => $val->v_other_fee_p,
                    'price_type' =>$val->res_type_p,
                    'vanning'  => $val->vanning_p
                );
            }else if ($val->res_type_p == 'FOB') {
                $data = array(
                    'stock_id' => $val->stock_id_p,
                    'fob' => $val->fob_p,
                    'freight_fee' => $val->freight_fee_p,
                    'customer_id' => $customer[0],
                    'vessel' => $val->reserve_vessel_p,
                    'currency' => $val->car_currency,
                    'created_dt' => date('Y-m-d'),
                    'discharge_id' => $val->reserve_discharge_p,
                    'other_fee' => $val->v_other_fee_p,
                    'price_type' =>$val->res_type_p,
                    'vanning'  => $val->vanning_p
                );
            }else if ($val->res_type_p == 'CNF'){
                $data = array(
                    'stock_id' => $val->stock_id_p,
                    'fob' => $val->fob_p,
                    'freight_fee' => $val->freight_fee_p,
                    'customer_id' => $customer[0],
                    'staff_id' => $user->staff_id,
                    'vessel' => $val->reserve_vessel_p,
                    'currency' => $val->car_currency,
                    'created_dt' => date('Y-m-d'),
                    'discharge_id' => $val->reserve_discharge_p,
                    'other_fee' => $val->v_other_fee_p,
                    'price_type' =>$val->res_type_p,
                    'vanning'  => $val->vanning_p
                );
            }
            $sale_name = Stocklist_model::get_sale_name($customer[0]);
            $data_history = array(
                'customer_id' => $customer[0],
                'staff_id' => $user->staff_id,
                'car_status' => 'Reserved',
                'stock_id' => $val->stock_id_p,
                'create_date' => date('Y-m-d h:i:sa'),
                'status' => 'active'
            );
            $data_stocklist = array(
                'customer_id' => $customer[0],
                'status' => '2', 
                'sale_agent_id' => @$sale_name[0]->staff_id,
                'car_customer_en' => @$customer[1],
                'car_sale_en' => @$sale_name[0]->full_name
            );
            Stocklist_model::insert_reserve($data);
            Stocklist_model::insert_reserve_history($data);
            Stocklist_model::insert_reserve_status_history($data_history);
            Stocklist_model::update_stock_list_reserve($val->stock_id_p,$data_stocklist);
            return response()->json([
                'status' => true,
                'message' => 'This car has been reserved successfully.'
            ]);
        }
    }

    public function delete_car_from_erp(Request $request){
        $stock_id = $request->get('stock_id');
        // return expense
        $return_car_expense =  Stocklist_model::return_car_expense($stock_id);

        foreach($return_car_expense as $value){
            $car_expense_id = $value->car_expense_id;
            $updata = array(
               'buying_price'=> NULL,
               'auction_fee'=> NULL,
               'transportation_fee'=> NULL,
               'freight_fee'=> NULL,
               'repair_fee'=> NULL,
               'inspection_fee'=> NULL,
               'shipping_charge_fee'=> NULL,
               'insurance_fee'=> NULL,
               'tax_fee'=> NULL,
               'car_tax_fee'=> NULL,
               'recycle_fee'=> NULL,
               'exchange_rate'=> NULL,
               'currency_type'=> NULL,
               'month_of_expense'=> NULL,
               'created_date' => NULL
           );
           Stocklist_model::update_car_expense($updata,$car_expense_id);
           $get_other_fee = Stocklist_model::get_other_fee_by_car_expense_id($car_expense_id);

           foreach ($get_other_fee as $row1) {
                $other_fee_id = $row1->other_fee_id;
                Stocklist_model::delete_other_fee($other_fee_id);
            }

            $get_other_refund =Stocklist_model::get_other_refund_by_car_expense_id($car_expense_id);
            foreach ($get_other_refund as $row2) {
                    $other_refund_id = $row2->other_refund_id;
                    Stocklist_model::delete_other_refund($other_refund_id);
            }
        }

        $get_car_payment_by_stock_id =Stocklist_model::get_car_payment_by_stock_id($stock_id);

        foreach ($get_car_payment_by_stock_id as  $val) {
            Stocklist_model::delete_row_amount_from_payment($val->car_payment_id);
        }
        $chassis_status = Stocklist_model::deleteCar($stock_id);
    }

    public function hide_from_web_mul(Request $request){
        $show_on_web = $request->get('show_on_web');
        $stock_dis = $request->get('dataChecked');
        $arr_stock = explode(',',$stock_dis);
       foreach($arr_stock as $stock){
          DB::table('erp_stock_list')
            ->where('stock_id','=',$stock)
            ->update(['show_website' => $show_on_web ]);
       } 
       return 'Updated successfully.';
    }

    public function save_multi_instrction(Request $request){
        $status             = $request->get('option_instrction');
        $stock_dis          = $request->get('dataChecked');
        $date_today         =date("Y-m-d h:i");
        $data               = array(
            'instruction'=>$status
        );
        $user = Auth::user();
        $arr_stock = explode(',',$stock_dis);
        foreach($arr_stock as $val){
            
            $data1  = array(
                'status'=>$status,
                'stock_id'=>$val,
                'updated_date'=>$date_today,
                'staff_id'=>$user->staff_id
            );

            Stocklist_model::save_multi_instrction($val,$data);
            Stocklist_model::update_instrction_history($data1);
           
        }
        return 'Updated successfully.';
    }

    function GetLacationYardData(){
        $get_car_yard = Stocklist_model::get_car_yard();
        $get_car_city =  Stocklist_model::get_car_city();
        $data['car_city'] = $get_car_city;
        $data['car_yard'] = $get_car_yard;
        return response()->json([
            $data
        ]);
    }

    function update_car_location(Request $request){
        $city_car_en        = $request->get('car_city');
        $yard_car_en        = $request->get('car_yard');
        $stock_dis          = $request->get('dataChecked');
        $arr_stock = explode(',',$stock_dis);
        $data = array(
            'stock_yard_id' => $yard_car_en,
            'stock_city_id' => $city_car_en
        );
       
        if($city_car_en != '' || $yard_car_en != ''){
            $user = Auth::user();
            foreach($arr_stock as $val){
                Stocklist_model::update_location_car($val,$data);
                $data_location=array(
                    'stock_id'      =>$val,
                    'stock_city_id'=>$city_car_en,
                    'stock_yard_id'=>$yard_car_en,
                    'updated_date'  =>date('Y-m-d H:i:s'),
                    'staff_id'      =>$user->staff_id
                );

                Stocklist_model::add_location_history($data_location);
                $get_last_location_history = Stocklist_model::get_last_location_history($val);
                foreach($get_last_location_history as $val_lo_id){
                    if($val_lo_id->stock_city_id == '31'){
                        Stocklist_model::delete_location_city_Aichi('32',$val);
                    }
                    if($val_lo_id->stock_city_id == '32'){
                        Stocklist_model::delete_location_city_Aichi('31',$val);
                    }
                }
            }
            return 'Updated successfully.';
        }else{
            return 'Can not update null value.';
        }
    }

    function add_shipok(Request $request){
        $stock_dis  = $request->get('stock_ids');
        $data_stock_list = array(
            'status' => 7
        );
        $user = Auth::user();
        $arr_stock = explode(',',$stock_dis);
        foreach($arr_stock as $val){
            DB::table('erp_stock_list')
              ->where('stock_id',$val)
              ->update($data_stock_list);

            $data_car_history = array(
                'stock_id' => $val,
                'status' => 'active',
                'car_status' => 'ShipOk',
                'staff_id' => $user->staff_id,
                'create_date'      => date('Y-m-d H:i:s')
            );
            DB::table('erp_cars_status_history')
              ->insert($data_car_history);
        }
        return 'Update successfully';
    }

    public function export_excel_car_allocate(Request $request){
        $search = $request->get('search_data');
        $stock_ids = $request->get('dataChecked');
        $filename =  md5(date('Y-m-d H:i:s:u'));
        $filepath = storage_path('app/public/PHPEXCEL/Excel_Car_Allocate_'.$filename.'.xls');
        $user = Auth::user();
        $batch = Bus::batch([
           new ExportExcelCarAllocation($search,$stock_ids,$user,$filepath)
        ])->then(function (Batch $batch) {
            // All jobs completed successfully...
            logger('Batch ' . $batch->id . ' finished successfully!');            
        })->catch(function (Batch $batch, Throwable $e) {
            // First batch job failure detected...
            logger('Batch ' . $batch->id . ' did not finish successfully!');
        })->finally(function (Batch $batch) {
            // The batch has finished executing...
            logger('Cleaning leftovers from batch ' . $batch->id);
        })->name('export_excel_car_allocate')->allowFailures()->dispatch();
        $data['batch_id'] = $batch->id; 
        $data['path'] = $filepath; 
        return response()->json([
            $data
        ]);
       
    }
    public function get_stock_sold_out(Request $request){
        $search = $request->get('search_data');
        $stock_ids = $request->get('dataChecked');
        $filename =  md5(date('Y-m-d H:i:s:u'));
        $filepath = storage_path('app/public/PHPEXCEL/Excel_stock_sold_out_'.$filename.'.xls');
        $user = Auth::user();
        $batch = Bus::batch([
           new ExportExcelSoldOut($search,$stock_ids,$user,$filepath)
        ])->then(function (Batch $batch) {
            // All jobs completed successfully...
            logger('Batch ' . $batch->id . ' finished successfully!');            
        })->catch(function (Batch $batch, Throwable $e) {
            // First batch job failure detected...
            logger('Batch ' . $batch->id . ' did not finish successfully!');
        })->finally(function (Batch $batch) {
            // The batch has finished executing...
            logger('Cleaning leftovers from batch ' . $batch->id);
        })->name('get_stock_sold_out')->allowFailures()->dispatch();
        $data['batch_id'] = $batch->id; 
        $data['path'] = $filepath; 
        return response()->json([
            $data
        ]);
    }

    function export_transport_excel(Request $request){
        $search = $request->get('search_data');
        $stock_ids = $request->get('dataChecked');
        $filename =  md5(date('Y-m-d H:i:s:u'));
        $filepath = storage_path('app/public/PHPEXCEL/transport_'.$filename.'.xls');
        $user = Auth::user();
        $batch = Bus::batch([
           new ExportExcelTransportation($search,$stock_ids,$user,$filepath)
        ])->then(function (Batch $batch) {
            // All jobs completed successfully...
            logger('Batch ' . $batch->id . ' finished successfully!');            
        })->catch(function (Batch $batch, Throwable $e) {
            // First batch job failure detected...
            logger('Batch ' . $batch->id . ' did not finish successfully!');
        })->finally(function (Batch $batch) {
            // The batch has finished executing...
            logger('Cleaning leftovers from batch ' . $batch->id);
        })->name('export_transport_excel')->allowFailures()->dispatch();
        $data['batch_id'] = $batch->id; 
        $data['path'] = $filepath; 
        return response()->json([
            $data
        ]);
    }

    function get_stock_excel(Request $request){
        $search = $request->get('search_data');
        $stock_ids = $request->get('dataChecked');
        $filename =  md5(date('Y-m-d H:i:s:u'));
        $filepath = storage_path('app/public/PHPEXCEL/'.$filename.'.xls');
        $user = Auth::user();
        $batch = Bus::batch([
           new ExportExcelStock($search,$stock_ids,$user,$filepath)
        ])->then(function (Batch $batch) {
            // All jobs completed successfully...
            logger('Batch ' . $batch->id . ' finished successfully!');            
        })->catch(function (Batch $batch, Throwable $e) {
            // First batch job failure detected...
            logger('Batch ' . $batch->id . ' did not finish successfully!');
        })->finally(function (Batch $batch) {
            // The batch has finished executing...
            logger('Cleaning leftovers from batch ' . $batch->id);
        })->name('get_stock_excel')->allowFailures()->dispatch();
        $data['batch_id'] = $batch->id; 
        $data['path'] = $filepath; 
        return response()->json([
            $data
        ]);
    }

    function downloadExcel(Request $request){
        $path = $request->get('path');
       return  Response::download($path,'filename.xls');
    }

    function checkForwardingProgress(Request $request){
        $batches = DB::table('job_batches')->where([['pending_jobs','>',0],['name','=','get_stock_excel_forwarding'],['id','=',$request->get('batch_id')]])->orderBy('created_at', 'desc')->limit(10)->get();
        if(count($batches) > 0){
             return 1;
        }else{
            $response = 0;
        return $response;
        }
    }

    function checkTransportProgress(Request $request){
        $batches = DB::table('job_batches')->where([['pending_jobs','>',0],['name','=','export_transport_excel'],['id','=',$request->get('batch_id')]])->orderBy('created_at', 'desc')->limit(10)->get();
        if(count($batches) > 0){
             return 1;
        }else{
            $response = 0;
        return $response;
        }
    }

    function checkSoldOutProgress(Request $request){
        $batches = DB::table('job_batches')->where([['pending_jobs','>',0],['name','=','get_stock_sold_out'],['id','=',$request->get('batch_id')]])->orderBy('created_at', 'desc')->limit(10)->get();
        if(count($batches) > 0){
             return 1;
        }else{
            $response = 0;
        return $response;
        }
    }

    function checkAllocateProgress(Request $request){
        $batches = DB::table('job_batches')->where([['pending_jobs','>',0],['name','=','export_excel_car_allocate'],['id','=',$request->get('batch_id')]])->orderBy('created_at', 'desc')->limit(10)->get();
        if(count($batches) > 0){
             return 1;
        }else{
            $response = 0;
        return $response;
        }
    }

    function checkStaffProgress(Request $request){
        $batches = DB::table('job_batches')->where([['pending_jobs','>',0],['name','=','get_stock_excel_staff'],['id','=',$request->get('batch_id')]])->orderBy('created_at', 'desc')->limit(10)->get();
        if(count($batches) > 0){
             return 1;
        }else{
            $response = 0;
        return $response;
        }
    }

    public function checkBatchProgress(Request $request)
    {
        $batches = DB::table('job_batches')->where([['pending_jobs','>',0],['name','=','get_stock_excel'],['id','=',$request->get('batch_id')]])->orderBy('created_at', 'desc')->limit(10)->get();
        if(count($batches) > 0){
             return 1;
        }else{
            $response = 0;
        return $response;
        }
    }

    public function get_stock_excel_forwarding(Request $request){
        $search = $request->get('search_data');
        $stock_ids = $request->get('dataChecked');
        $filename =  md5(date('Y-m-d H:i:s:u'));
        $filepath = storage_path('app/public/PHPEXCEL/forwarding_'.$filename.'.xls');
        $user = Auth::user();
        $batch = Bus::batch([
            new ExportExcelStockForwarding($search,$stock_ids,$user,$filepath)
         ])->then(function (Batch $batch) {
             // All jobs completed successfully...
             logger('Batch ' . $batch->id . ' finished successfully!');            
         })->catch(function (Batch $batch, Throwable $e) {
             // First batch job failure detected...
             logger('Batch ' . $batch->id . ' did not finish successfully!');
         })->finally(function (Batch $batch) {
             // The batch has finished executing...
             logger('Cleaning leftovers from batch ' . $batch->id);
         })->name('get_stock_excel_forwarding')->allowFailures()->dispatch();
         $data['batch_id'] = $batch->id; 
         $data['path'] = $filepath; 
         return response()->json([
             $data
         ]);
        
    }

    public static function get_for_export_selectbox(){
        $erp_port= DB::table('erp_port_of_loading')
                  ->select('*')
                  ->get();
        $country_list=Stocklist_model::country_for_cbm();
        $data['erp_port_of_loading'] = $erp_port;
        $data['country_list'] = $country_list;
        return response()->json([
            $data
        ]);
    }

    public function get_stock_staff_excel(Request $request){
        $search = $request->get('search_data');
        $stock_ids = $request->get('dataChecked');
        $filename =  md5(date('Y-m-d H:i:s:u'));
        $filepath = storage_path('app/public/PHPEXCEL/Excel_staff_'.$filename.'.xls');
        $user = Auth::user();
        $baseUrl = $request->root();
        $batch = Bus::batch([
            new ExportExcelStaff($search,$stock_ids,$user,$filepath,$baseUrl)
         ])->then(function (Batch $batch) {
             // All jobs completed successfully...
             logger('Batch ' . $batch->id . ' finished successfully!');            
         })->catch(function (Batch $batch, Throwable $e) {
             // First batch job failure detected...
             logger('Batch ' . $batch->id . ' did not finish successfully!');
         })->finally(function (Batch $batch) {
             // The batch has finished executing...
             logger('Cleaning leftovers from batch ' . $batch->id);
         })->name('get_stock_excel_staff')->allowFailures()->dispatch();
         $data['batch_id'] = $batch->id; 
         $data['path'] = $filepath; 
         return response()->json([
             $data
         ]);
       
    }

    public function submit_add_proforma(Request $request){
        $stock_ids = $request->get('stock_ids');
        $customer_id = $request->get('customer_id');
        $bank_account = $request->get('bank_account_id');
        $issue_date = $request->get('issue_date');
        $due_date = $request->get('due_date');
        $deposit = $request->get('deposit');
        $discount = $request->get('discount');
        $percentag_dep = $request->get('percentag_dep');
        $user = Auth::user();
        $data=array('staff_id' => $user->staff_id,
            'customer_id' => $customer_id,
            'issue_date' => $issue_date,
            'due_date' => $due_date,
            'invoice_type' => 'invoice',
            'bank_account_id' => $bank_account,
            'invoice_status' => 'unpaid',
            'deposit' => $deposit,
            'discount' => $discount,
            'dep_percentage' => $percentag_dep
        );
  
        $return_id = Stocklist_model::insert_proforma_invoice($data);
        $update_stock = Stocklist_model::update_stock_list_invoice($stock_ids,$return_id);
        

        $php_current_date = date("Ymdhis");
        $arr_stock = explode(',',$stock_ids);
        foreach( $arr_stock as $get_id){
            $data_history = array(
            'stock_no'=>$get_id,
            'invoice_no'=>$return_id,
            'Date'=>$issue_date,
            'file_pdf'=>$php_current_date.'.pdf'
        );
            $this->create_invoice_history_pdf($return_id , $php_current_date);
            Stocklist_model::history_invoice($data_history);
        }
    }

    public function create_invoice_history_pdf($invoice_id , $php_current_date){
        stream_context_set_default([
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
            ]
        ]);
        $data = Invoice_model::get_data_proforma_invoice_for_customer_form_cambodia($invoice_id);
        if (!empty($data[0]->invoice_number)) {
            $invoice_no = $data[0]->invoice_number;
        } else {
            $invoice_no = $invoice_id;
        }
        $pdf = new PDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

         // set document information
         PDF::SetTitle('TCPDF Example 002');
         PDF::SetSubject('TCPDF Tutorial');
         PDF::SetKeywords('TCPDF, PDF, example, test, guide');
 
         // remove default header/footer
         PDF::setPrintHeader(false);
         PDF::setPrintFooter(false);
 
         // set default monospaced font
         PDF::SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);
 
         // set margins
         PDF::SetAutoPageBreak(TRUE, 0);
 
         // set image scale factor
         PDF::setImageScale(PDF_IMAGE_SCALE_RATIO);
 
         // set some language-dependent strings (optional)
         if (@file_exists(dirname(__FILE__) . '/lang/eng.php')) {
             require_once(dirname(__FILE__) . '/lang/eng.php');
             PDF::setLanguageArray($l);
         }
         // set font
         PDF::SetFont('times', '', 7);
         PDF::AddPage();
         PDF::setCellPaddings(1, 1, 1, 1);
         $image_file = public_path().'/uploads/silmi_logo_invoice1.png';
         PDF::Image($image_file, '', '', 40, 25, 'png', 'https://silmijapan.com', '', true, 150, '', false, false, 1, false, false, false);
         $html = <<<EOD
            <h2 style="text-align: center; color:#ED7D31">SILMI JAPAN CO., LTD.<br/>
            3-6-28, Miyanosaka, Hirakata-city, Osaka, Japan<br/>
            PHONE: +81-72-392-4971
            </h2>
            <h1 style="text-align: center; color:#FF0000">PROFORMA INVOICE</h1>
            EOD;
            
                    // Print text using writeHTMLCell()
                    PDF::writeHTMLCell(0, 0, 45, '', utf8_decode($html), 0, 1, 0, true, '', true);
            
                    $html = <<<EOD
            <p>
            Home page: <a href="https://silmijapan.com" dir="ltr">https://silmijapan.com</a>
            </p>
            <br/>
            <hr>
            EOD;
            
                    // Print text using writeHTMLCell()
                    PDF::writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
            
                    $html = '<table border="0" style="width:60%;">
            <tbody>
            <tr> 
                <th style="border: 0.1px solid black;padding:8px;" width="25%" height="15">CUSTOMER NAME </th>
                <td style="border: 0.1px solid black;vertical-align: middle" width="75%" height="15"><span>' . $data[0]->cus_name . '</span></td>
            </tr>
            <tr> 
                <th style="border: 0.1px solid black;" width="25%" height="15">PHONE NUMBER </th>
                <td style="border: 0.1px solid black;" width="75%" height="15">' . $data[0]->phone_number . '</td>
            </tr>
            <tr> 
                <th style="border: 0.1px solid black;">&nbsp;<br/>ADDRESS </th>
                <td style="border: 0.1px solid black;" height="25"><span>' . $data[0]->cus_address . '</span></td>
            </tr>
            <tbody>    
            </table>';
            
            
                    // Print text using writeHTMLCell()
                    PDF::writeHTMLCell(0, 0, '', 53, $html, 0, 1, 0, true, 'C', false);
            
                    $html = '<table style="">
            <tbody>
            <tr> 
                <th style="border: 0.1px solid black;" height="15">DATE </th>
                <td style="border: 0.1px solid black;" height="15">' . $data[0]->issue_date . '</td>
            </tr>
            <tr> 
                <th style="border: 0.1px solid black;" height="15">INVOICE NUMBER </th>
                <td style="border: 0.1px solid black;" height="15">' . $invoice_no . '</td>
            </tr>
            <tr> 
                <th style="border: 0.1px solid black;" height="15">EXPIRATION DATE</th>
                <td style="border: 0.1px solid black;" height="15">' . $data[0]->due_date . '</td>
            
            </tr>
            <tbody>    
            </table><br/><br/><br/><br/>';
 
 
         // Print text using writeHTMLCell()
         PDF::writeHTMLCell(0, 0, 130, 53, $html, 0, 1, 0, true, 'C', true);
 
         $html = '<hr><br/><table border="0.1" style="width:100%">
         <thead>
             <tr align="center">
                 <th width="8%" height="15">STOCK NO</th>
                 <th width="16%" height="15">MAKER</th>
                 <th width="6%" height="15">YEAR</th>
                 <th width="13%" height="15">CHASSIS NUMBER</th>
                 <th width="5%" height="15">UNIT</th>
                 <th width="10%" height="15">COLOR</th>
                 <th width="8%" height="15">PRICE</th>
                 <th width="7%" height="15">FREIGHT</th>
                 <th width="9%" height="15">TOTAL</th>
                 <th width="9%" height="15">DEPOSIT </th>
                 <th width="9%" height="15">BALANCE </th>
             </tr>
         </thead>
         <tbody>';
 
         
         $total_unit = 0;
         $any_total = 0;
         $actual_price = 0;
         $freight = 0;
         $any_total = 0;
         $insurance = 0;
         $vanning = 0;
         $discount = 0;
         $discountprice = 0;
         $grand_total = 0;
         $grandTotalCustomerDepoit = 0;
         $grandTotalCustomerBalance = 0;
         foreach ($data as $dataRow) {
         
             $dobs = trim($dataRow->date_of_production);
             if (!empty($dobs)) {
                 $dop = $dataRow->date_of_production;
                 $dopex = explode(' ', $dop);
                 $numMonth = date('m', strtotime($dopex[0]));
                 $modelYear = $dopex[1] . "/" . $numMonth;
             } else {
                 $modelYear = $dataRow->car_model_year;
             }
             $final_destination ='';
             if (!empty($dataRow->final_des_name)) {
                 $final_destination = $dataRow->final_des_name;
             }
 
             $actual_price = $dataRow->fob;
             $freight = $dataRow->freight_fee;
             $insurance = $dataRow->insurance;
             $vanning = $dataRow->vanning;
             $totalCustomerDepoit = $dataRow->total_deposit;
             $discount = $dataRow->discount;
             $any_total = @$actual_price + @$freight + @$insurance + $vanning;
             $last_total = $any_total - @$discount;
 
             $deposit   = 0;
             $dep_per   = 0;
 
             if($totalCustomerDepoit == 0){
                 $dep_per =$dataRow->dep_percentage;
                 $cal_dep =($any_total)*(($dep_per)/100);
                 $deposit = $cal_dep;
             }else{
                 $deposit = $totalCustomerDepoit;
             }
 
             
             $totalCustomerBalance       =   $any_total - $deposit;
             $grandTotalCustomerDepoit   += $deposit;
             $grandTotalCustomerBalance  += $totalCustomerBalance;
             $grand_total    += $last_total;
             $discountprice  += $discount;
             if (!empty($dataRow->country_name)) {
                 $country_destination = $dataRow->country_name;
             }
 
             switch ($dataRow->currency) {
                 case 'USD':
                     $currency_mark = '$';
                     break;
                 case 'KRW':
                     $currency_mark = '₩';
                     break;
                 case 'JPY':
                     $currency_mark = '&#165;';
                     break;
                 case 'EUR':
                     $currency_mark = '€';
                     break;
                 default:
                     $currency_mark = '';
                     break;
             }
             if (!empty($dataRow->car_model_year)) {
                 $dateofpro = $dataRow->car_model_year;
             }
             $html .= '<tr align="center">
                <td width="8%" height="15">' . $dataRow->car_stock_id . '</td>
                <td width="16%" height="15">' . $dataRow->car_make_name . '</td>
                <td width="6%" height="15">' . $modelYear . '</td>
                <td width="13%" height="15">' . $dataRow->chassis_number . '</td>
                <td width="5%" height="15">1</td>
                <td width="10%" height="15">' . $dataRow->color_name . '</td>
                <td width="8%" height="15">' . number_format($dataRow->fob) . ' ' . $currency_mark . '</td>
                <td width="7%" height="15">' . number_format($freight) . ' ' . $currency_mark . '</td>
                <td width="9%" height="15">' . number_format($any_total) . ' ' . $currency_mark . '</td>
                <td width="9%" height="15">' . number_format($totalCustomerBalance) . ' ' . $currency_mark . '</td>
                
                
                </tr>';
                        $total_unit = $total_unit + 1;
                    }
            
                    $grant_balance = $grand_total - $deposit - $discountprice;
                    $html .= '</tbody></table>';
            
                    // Print text using writeHTMLCell()
                    PDF::writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
            
                    $html = '<table style="border-collapse: collapse;">
            <tr> 
                <th colspan="6"></th>
                <th align="center" border="0.1" height="15">QUANTITY</th>
                <th align="center" border="0.1" height="15">TOTAL</th> 
                <th width="2%"></th>
                <th width="15%" align="center" border="0.1" height="15" colspan="2">TOTAL DEPOSIT</th>
                <th width="16%" align="center" border="0.1" height="15">' . number_format($grandTotalCustomerDepoit) . ' ' . $currency_mark . '</th>
            </tr>
            <tr> 
                <td colspan="6" border="0.1" style="color:red;"  height="15">TOTAL</td>
                <td align="center" border="0.1" height="15">' . $total_unit . '</td>
                <td align="center" border="0.1" height="15">' . number_format($grand_total) . ' ' . $currency_mark . '</td>
                <td width="2%"></td>
                <td width="15%" align="center" border="0.1" height="15" colspan="2">TOTAL BALANCE</td>
                <td width="16%" align="center" border="0.1" height="15">' . number_format($grandTotalCustomerBalance) . ' ' . $currency_mark . '</td>
                
            </tr>
            
            
            </table>';
            
                    PDF::writeHTMLCell(0, 0, '', '', utf8_decode($html), 0, 1, 0, true, '', true);
            
                    $html = '<table style="width:300px;">
            <tbody>
                <tr> 
                    <th style="border: 0.1px solid black; color:red;" height="15">Final destination </th>
                    <td style="border: 0.1px solid black;" height="15">' . $final_destination . '</td>
                </tr>
            
            <tbody>    
            </table>';
            
            
                    // Print text using writeHTMLCell()
                    PDF::writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
            
            
            
                    $html1 = '<p style="padding:0;margin:0;">BANK DETAILS</p>
            <p style="padding:0;margin:0;color:red; border:1px solid black;text-align:center;">BENEFICIARY BANk : ' . @$data[0]->bank_name .
                        '<br/>BRANCH NAME : ' . @$data[0]->branch_name .
                        '<br/>SWIFT CODE : ' . @$data[0]->swift_code .
                        '<br/>BENEFICIARY ACCOUNT NUMBER : ' . @$data[0]->account_number .
                        '</p><br/><br/><br/>';
            
                    // create some HTML content
            
                    $html = '
            <table border="0">
            <tr> 
            <th style="">
                ' . $html1 . '<br/><br/>BENEFICIARY`S NAME & ADDRESS
                <p style="border:0.1px solid black; text-align:center;">Name: SILMI JAPAN CO., LTD.<br/>Address: 3-6-28, Miyanosaka, Hirakata-city, Osaka, Japan</p><br/>
            </th>
            <th align="center"><img src="' . public_path() . '/uploads/silmi_signature.png" height="90" width="120">
                <br/><hr style="width:50%" ><br/>
                <h4>
                    YOHEI MURASHIMA<br/>
                    SILMI JAPAN CO., LTD.
                    <p></p>
                </h4>
            </th>
            </tr>
            
            </table>';
 
         // Print text using writeHTMLCell()
         PDF::writeHTMLCell(0, 0, '', '', $html, 0, 1, 0, true, '', true);
 
 
         ob_end_clean();
 
         //Close and output PDF document
         PDF::Output(storage_path().'/app/public/uploads/pdf_invoices/'.$php_current_date.'.pdf', 'F');
         PDF::Output('INVOICE-' . $invoice_no . '.pdf', 'I');

    }

    public function proforma_invoices(Request $request){
        $stock_ids = $request->get('stock_ids');
        $user = Auth::user();
        $hide_pakistan =  Stocklist_model::hide_car_on_stock_list($user->staff_id);
        $hide_paragay =  Stocklist_model::hide_car_paragay_on_stock_list($user->staff_id);
        $data['customer_info'] = Stocklist_model::select_customers_for_stock($hide_pakistan,$hide_paragay);
        $data['bank_accounting'] = Invoice_model::select_bank_accounting($hide_pakistan);
        $data['car_lists_proforma'] = Stocklist_model::get_car_list_proforma($stock_ids);
        $data['total_incomes'] = Stocklist_model::get_total_income($stock_ids);
        return response()->json([
            $data
        ]);
     }
     
    // Update Car Reserve
    public function update_reserve_car(Request $request){
        $updatedata = $request->get('updatedata');
        $stock_id   = $request->get('stock_id');
        $user = Auth::user();
        foreach(json_decode($updatedata) as $val){
            $old_id_customer= $val->old_id_customer;
            $reserve_customers= $val->reserve_customers;
            $reserve_customers_name= $val->reserve_customers_name;
            $data = array(
                'stock_id'    => $stock_id,
                'fob'         => $val->car_price,
                'freight_fee' => $val->car_freight_fee,
                'vanning'     => $val->vanning,
                'customer_id' => $val->reserve_customers,
                'staff_id'    => $user->staff_id,
                'vessel'      => $val->reserve_vessel,
                'currency'    => $val->reserve_currency,
                'created_dt'  => date('Y-m-d'),
                'insurance'   => $val->reserve_insurance,
                'other_fee'   => $val->other_fee_cost,
                'discount'    => $val->reserve_discount,
                'discharge_id'=> $val->reserve_discharges,
                'price_type'  => $val->car_price_type
            );

            if($old_id_customer !== $reserve_customers ){
                $data_customer  = $this->get_data_customer($stock_id);
                foreach(json_decode($data_customer) as $val){
                    if($val->customer_deposit_type == 'customer_deposit'  || $val->customer_deposit_type=='customer_auction_deposit'){
                        // delete from carpayment
                        $car_payment_id = $val->car_payment_id;
                        DB::table('erp_carpayments')
                        ->where('car_payment_id', '=', $car_payment_id)
                        ->where('payment_type', '=', 'customer_deposit')
                        ->delete();
                   }
                }
           }

            $sale_name = $this->get_sale_name( $reserve_customers); 
            $data_stocklist = array(
               'customer_id'       => $reserve_customers,
               'sale_agent_id'     => $sale_name[0]->staff_id,
               'car_customer_en'   => $reserve_customers_name,
               'car_sale_en'       => $sale_name[0]->full_name
           );
            Stocklist_model::insert_reserve_sold_price($data);
            Stocklist_model::insert_reserve_history_sold_price($data);
            if(!empty($stock_id)){
                Stocklist_model::update_stock_list_editsoldprince($stock_id,$data_stocklist);
            }
                Status_update::update_car_status_car_reserve($stock_id,$reserve_customers,$user->staff_id);
                return response()->json([
                    'status' => true,
                    'message' => 'This car has been Update reserved successfully.'
            ]);
        }
    }

    public function get_data_customer($stock_id){
        $data = DB::table('erp_carpayments As a')
                ->select('*')
                ->leftjoin('erp_customer_deposit  As b','a.customer_deposit_id','=','b.customer_deposit_id')
                ->where("a.stock_id",'=',$stock_id)
                ->get();
        return $data;
    }
    public function get_sale_name($reserve_customers){
        $data = DB::table('erp_customer As a')
                ->select('b.full_name','b.staff_id')
                ->leftjoin('erp_staff As b','b.staff_id','=','a.staff_id')
                ->where("customer_id",'=',$reserve_customers)
                ->get();
        return $data;
    }
}
