<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Auth;

class Users extends Controller
{
    public function get_staff_list(Request $request)
    {
        $where_manul = "id <> ''";
        $perPage = $request->get('perPage');
        $search = $request->get('search_data');
        $check = is_array(json_decode($search)) ? count(json_decode($search)) : 0;
        if ($check > 0) {
            foreach (json_decode($search) as $item) {
                if (!empty($item->Full_name)) {
                    $where_manul = "erp_staff.full_name LIKE '%" . $item->Full_name . "%'";
                }
                if (!empty($item->Phone)) {
                    $where_manul .= ' AND erp_staff.telephone LIKE "%' . $item->Phone . '%"';
                }
                if (!empty($item->Country)) {
                    $where_manul .= " AND erp_staff.country_list_id =" . $item->Country;
                }
            }
        }
        $data['users'] = DB::table('erp_staff')
            ->select('erp_staff.*', 'erp_country_list.country_name')
            ->join('erp_country_list', 'erp_country_list.country_list_id', '=', 'erp_staff.country_list_id')
            ->leftJoin('users_groups', 'erp_staff.staff_id', '=', 'users_groups.staff_id')
            ->whereRaw(DB::raw($where_manul))
            ->where('erp_staff.active', 1)
            ->orderBy('last_login', 'DESC')
            ->paginate($perPage);

        $arr_group_staff = array();
        $userselect = array();
        $user = array();
        $userlog = array();

        foreach ($data['users'] as $u) {
            $staff_id = $u->staff_id;
            // dd( $staff_id);
            $arr_group = DB::table('users_groups')
                ->select('users_groups.group_id AS id', 'groups.name', 'groups.description')
                ->join('groups', 'users_groups.group_id', '=', 'groups.id')
                ->where('users_groups.staff_id', $staff_id)
                ->get();

            $user = Auth::user();
            $arr_user_log = DB::table('users_groups')
                ->select('*')
                ->where('staff_id', '=', $user->staff_id)
                ->get();

            $arr_user_select = DB::table('users_groups')
                ->select('*')
                ->where('staff_id', '=', $staff_id)
                ->get();

            $arr_group_staff[$staff_id] = $arr_group[0]->name;
            $userselect[$staff_id] = $arr_user_select[0]->group_id;
            $userlog = $arr_user_log[0]->group_id;

        }

        $data['arr_group_staff'] = $arr_group_staff;
        $data['userselect'] = $userselect;
        $data['user'] = Auth::user();
        $data['userlog'] = $userlog;

        return response()->json([
            $data
        ], 200);
    }
    public function select_country_list()
    {
        $data = DB::table('erp_country_list')
            ->select('*')
            ->from('erp_country_list')
            ->get();
        return response()->json([
            "country_list" => $data
        ], 200);
    }
    public function get_member_group()
    {
        $data = DB::table('groups')
            ->select('*')
            ->get();
        return response()->json([
            "group" => $data
        ], 200);
    }
    public function insert_user(Request $request)
    {
        $login_id = $request->get('log_in_id');
        $full_name = $request->get('full_name');
        $country_list_id = $request->get('country');
        $company = $request->get('company');
        $address = $request->get('address');
        $email = $request->get('email');
        $phone_number = $request->get('telephone');
        $password = $request->get('password');
        $hashedPassword = Hash::make($request->password);
        $ip_group = $request->get('ip_group');
        $create_date = date('Y-m-d ');
        $group = $request->get('group');
        $additional_data = array(
            'log_in_id' => $login_id,
            'full_name' => $full_name,
            'country_list_id' => $country_list_id,
            'company' => $company,
            'address' => $address,
            'email' => $email,
            'telephone' => $phone_number,
            'password' => $hashedPassword,
            'raw_password' => $password,
            'joint_date' => $create_date,
            'ip_group' => $ip_group,
        );

        // validation insert
        $validator = Validator::make($request->all(), [
            'log_in_id' => 'required|min:5|unique:erp_staff',
            'full_name' => 'required',
            'country' => 'required',
            'email' => 'required|regex:/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/|unique:erp_staff',
            'password' => 'required|min:5',
            'comfirm_password' => 'required|same:password',
            'telephone' => 'required|numeric|unique:erp_staff',
            'ip_group' => 'required',
            'group' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors()
            ], 422);
        }
        // insert to database 
        $get_staff_id = DB::table('erp_staff')
            ->insertGetId($additional_data);

        $staffid = $this->get_staffid();
        $data_livechat = array(
            'staff_id' => $staffid[0]->staff_id,
            'status' => '0',
            'username' => $staffid[0]->log_in_id,
            'password' => $staffid[0]->password,
            'email' => $staffid[0]->email,
            'name' => $staffid[0]->log_in_id,
            'joined' => $create_date,
            'country' => $staffid[0]->country_list_id,
        );
        // insert to database
        DB::table('lance_userdata')
            ->insert($data_livechat);
        $data = array(
            'staff_id' => $staffid[0]->staff_id,
            'group_id' => $group
        );
        // insert to database
        DB::table('users_groups')
            ->insert($data);
        return $get_staff_id;

    }
    public function get_staffid()
    {
        $data = DB::table('erp_staff')
            ->select('*')
            ->where('active', 1)
            ->orderBy('staff_id', 'DESC')
            ->get();
        return $data;
    }

    public function get_country_combo_list()
    {
        $data = DB::table('erp_country_list')
            ->select('*')
            ->get();
        return response()->json([
            "country_list" => $data
        ], 200);
    }

    public function get_staff_update(Request $request)
    {
        $staff_id = $request->get('staff_id');
        $data['staff'] = DB::table('erp_staff')
            ->select('*')
            ->where('staff_id', $staff_id)
            ->where('active', 1)
            ->get();

        $arr_groups = array();
        foreach ($data['staff'] as $user) {
            $staff_id = $user->staff_id;
            $arr_group = DB::table('users_groups')
                ->select('users_groups.group_id AS id', 'groups.name', 'groups.description')
                ->join('groups', 'users_groups.group_id', '=', 'groups.id')
                ->where('users_groups.staff_id', $staff_id)
                ->get();
            $arr_groups = $arr_group[0]->id;
        }
        $data['arr_groups'] = $arr_groups;

        return response()->json([
            $data
        ], 200);
    }
    public function get_group()
    {
        $data = DB::table('groups')
            ->select('*')
            ->get();
        return response()->json([
            "groups" => $data
        ], 200);
    }
    public function country_list()
    {
        $data = DB::table('erp_country_list')
            ->select('*')
            ->get();
        return response()->json([
            "country_list" => $data
        ], 200);
    }
    public function edit_users(Request $request)
    {
        $login_id = $request->get('log_in_id');
        $full_name = $request->get('full_name');
        $country_list_id = $request->get('country');
        $company = $request->get('company');
        $address = $request->get('address');
        $email = $request->get('email');
        $phone_number = $request->get('telephone');
        $password = $request->get('password');
        $hashedPassword = Hash::make($request->password);
        $ip_group = $request->get('ip_group');
        $create_date = date('Y-m-d ');
        $group = $request->get('group');
        $staff_id = $request->get('staff_id');
        // dd($staff_id);
        $data = array(
            'log_in_id' => $login_id,
            'full_name' => $full_name,
            'country_list_id' => $country_list_id,
            'company' => $company,
            'address' => $address,
            'email' => $email,
            'telephone' => $phone_number,
            'password' => $hashedPassword,
            'raw_password' => $password,
            'joint_date' => $create_date,
            'ip_group' => $ip_group,
        );
        $ckhogin_id = "";
        $ckemail = "";
        $ckphone_num = "";
        $check_data = $this->check_data_edit($staff_id);
        if ($login_id !== $check_data[0]->log_in_id) {
            $ckhogin_id = 'required|min:5|unique:erp_staff';
        } else {
            $ckhogin_id = 'required';
        }
        if ($email !== $check_data[0]->email) {
            $ckemail = 'required|regex:/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/|unique:erp_staff';
        } else {
            $ckemail = 'required|regex:/^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,}$/';
        }
        if ($phone_number !== $check_data[0]->telephone) {
            $ckphone_num = 'required|numeric|unique:erp_staff';
        } else {
            $ckphone_num = 'required|numeric';
        }

        // validation edit
        $validator = Validator::make($request->all(), [
            'log_in_id' => $ckhogin_id,
            'full_name' => 'required',
            'country' => 'required',
            'email' => $ckemail,
            'password' => 'required|min:5',
            'comfirm_password' => 'required|same:password',
            'telephone' => $ckphone_num,
            'ip_group' => 'required',
            'group' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'error' => $validator->errors()
            ], 422);
        }

        DB::table('erp_staff')
            ->where('staff_id', '=', $staff_id)
            ->update($data);

        $staffid_update = $this->get_staff_id_update();
        $data_livechat = array(
            'username' => $staffid_update[0]->log_in_id,
            'password' => $staffid_update[0]->password,
            'email' => $staffid_update[0]->email,
            'name' => $staffid_update[0]->log_in_id,
            'country' => $staffid_update[0]->country_list_id,
        );

        DB::table('lance_userdata')
            ->where('staff_id', '=', $staff_id)
            ->update($data_livechat);

        $data_group = array(
            'staff_id' => $staff_id,
            'group_id' => $group
        );

        DB::table('users_groups')
            ->where('staff_id', '=', $staff_id)
            ->update($data_group);
    }
    public function get_staff_id_update()
    {
        $data = DB::table('erp_staff')
            ->select('*')
            ->where('active', 1)
            ->orderBy('staff_id', 'DESC')
            ->get();
        return $data;
    }
    public function check_data_edit($staff_id)
    {
        $data = DB::table('erp_staff')
            ->select('*')
            ->where('erp_staff.staff_id', '=', $staff_id)
            ->orderBy('erp_staff.staff_id', 'DESC')
            ->get();
        return $data;
    }

    public function data_group_user($id)
    {
        $data = DB::table('users_groups AS a')
            ->select('b.name')
            ->leftjoin('groups AS b', 'b.id', 'a.group_id')
            ->where('a.staff_id', '=', $id)
            ->get();
        return $data;
    }
  
    public function delete_user(Request $request)
    {
        $deletedata = $request->get('deletedata');
        foreach (json_decode($deletedata) as $item) {
            $staff_id = $item->staff_id;
            $data = array('active' => '0');
            DB::table('erp_staff')
                ->where('staff_id', $staff_id)
                ->update($data);
        }
    }
    public function get_user_info(Request $request)
    {
        $staff_id = $request->get('staff_id');
        $data['user_info'] = DB::table('erp_staff')
            ->select('*')
            ->where('staff_id', $staff_id)
            ->get();

        $arr_groups_staff = array();
        foreach ($data['user_info'] as $user) {
            $staff_id = $user->staff_id;
            // dd( $staff_id);
            $arr_groups = DB::table('users_groups')
                ->select('users_groups.group_id AS id', 'groups.name', 'groups.description')
                ->join('groups', 'users_groups.group_id', '=', 'groups.id')
                ->where('users_groups.staff_id', $staff_id)
                ->get();

            $arr_groups_staff[$staff_id] = $arr_groups[0]->name;
        }
        $data['arr_groups_staff'] = $arr_groups_staff;
        return response()->json([
            $data
        ], 200);
    }
    public function get_history_login(Request $request)
    {
        $staff_id = $request->get('staff_id');
        $last_login = $request->get('last_login');
        $last_log = gmdate('Y-m-d', $last_login);
        $data['data_history_login'] = DB::table('erp_staff_login_history AS a')
            ->select('a.*', 'b.full_name', 'b.last_login', 'b.last_logout')
            ->where('a.staff_id', $staff_id)
            ->where('b.active', 1)
            ->where(DB::raw("(DATE(a.login_date))"), $last_log)
            ->leftjoin('erp_staff AS b', 'b.staff_id', '=', 'a.staff_id')
            ->orderBy('a.login_date', 'DESC')
            ->get();

        $arr_total = array();
        foreach ($data['data_history_login'] as $row) {
            $starttime = (!empty($row->login_date)) ? date('h:i:s', strtotime($row->login_date)) : 0;
            $stoptime = (!empty($row->logout_date)) ? date('h:i:s', strtotime($row->logout_date)) : 0;

            $diff = (strtotime($stoptime) - strtotime($starttime));
            $total = $diff / 60;
            $arr_total_hour = sprintf("%02dh %02dm", floor($total / 60), $total % 60);
            $arr_total = ($arr_total_hour < 0) ? '0h' : $arr_total_hour;
        }
        $data['arr_total'] = $arr_total;
        return response()->json([
            $data
        ], 200);
    }
}


