<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
// use GuzzleHttp\Psr7\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\DB;
use function Laravel\Prompts\alert;

class banklist extends Controller
{
    public function index()
    {

        $data = DB::table('erp_bank_account')
            ->select('*')
            ->from('erp_bank_account')
            ->where('status', 'Enable')
            ->orderBy('order_bank', 'ASC')
            ->get();
        return response()->json([

            'data_banks' => $data
        ], 200);
    }
    public function insert_bank_accounting(Request $request)
    {
        $savedata = $request->get('savedata');
        //  dd($savedata);
        foreach (json_decode($savedata) as $item) {
            $bank_full_name = '';
            $bank_eng_name = '';
            $currency = '';
            $bank_swift_code = '';
            $bank_account_number = '';
            $bank_brand_name = '';
            $bank_address = '';

            if (!empty($item->bank_full_name)) {
                $bank_full_name = $item->bank_full_name;
            }

            if (!empty($item->bank_eng_name)) {
                $bank_eng_name = $item->bank_eng_name;
            }

            if (!empty($item->currency)) {
                $currency = $item->currency;
            }

            if (!empty($item->bank_swift_code)) {
                $bank_swift_code = $item->bank_swift_code;
            }

            if (!empty($item->bank_account_number)) {
                $bank_account_number = $item->bank_account_number;
            }

            if (!empty($item->bank_brand_name)) {
                $bank_brand_name = $item->bank_brand_name;
            }

            if (!empty($item->bank_address)) {
                $bank_address = $item->bank_address;
            }
            $data = array(
                'bank_name' => $bank_full_name,
                'bank_full_name' => $bank_full_name,
                'bank_eng_name' => $bank_eng_name,
                'bank_currency' => $currency,
                'swift_code' => $bank_swift_code,
                'account_number' => $bank_account_number,
                'branch_name' => $bank_brand_name,
                'address' => $bank_address,
                'status' => 'Enable',
            );
            DB::table('erp_bank_account')
                ->insert($data);
        }
    }
    public function update_bank_accounting(Request $request)
    {
        $updatedata = $request->get('updatedata');
        foreach (json_decode($updatedata) as $item) {
            $bank_id = $item->bank_account_id;
            $bank_full_name = $item->bank_full_name;
            $bank_eng_name = $item->bank_eng_name;
            $currency = $item->currency;
            $bank_swift_code = $item->bank_swift_code;
            $bank_account_number = $item->bank_account_number;
            $bank_brand_name = $item->bank_brand_name;
            $bank_address = $item->bank_address;
            $data = array(
                'bank_name' => $bank_full_name,
                'bank_full_name' => $bank_full_name,
                'bank_eng_name' => $bank_eng_name,
                'bank_currency' => $currency,
                'swift_code' => $bank_swift_code,
                'account_number' => $bank_account_number,
                'branch_name' => $bank_brand_name,
                'address' => $bank_address,
            );
            DB::table('erp_bank_account')
                ->where('bank_account_id', '=', $bank_id)
                ->update($data);
        }
    }
    public function delete_bank_accounting(Request $request)
    {
        $deletedata = $request->get('deletedata');
        foreach (json_decode($deletedata) as $item) {
            $bank_id = $item->bank_account_id;
            $data = array(
                'status' => 'Disable',
            );

            DB::table('erp_bank_account')
                ->where('bank_account_id', '=', $bank_id)
                ->update($data);
        }
    }

    public function save_data_sort(Request $request)
    {
        $DataSort = $request->get('DataSort');

        foreach (json_decode($DataSort) as $key => $value) {

            DB::table('erp_bank_account')
                ->where('bank_account_id', $value->bank_account_id)
                ->update(['order_bank' => $key + 1]);
        }
    }
}
