<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Carbon;

class CheckIdleTimeout
{

    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::check()) {
            $user = Auth::user();
            $idleLimit = Carbon::now()->subHours(3); 
            // $idleLimit = Carbon::now()->subSeconds(10);
            if ($user->last_activity && Carbon::parse($user->last_activity)->lt($idleLimit)) {
                // $user->tokens->each(function ($token) {
                // });
                return response()->json(['message' => 'Session expired due to inactivity'], 401);
            }
        }

        return $next($request);
    }
}
