<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Carbon;
class UpdateLastActivity
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if (Auth::check()) {
            // Update last_activity timestamp when a user is authenticated
            // Auth::user()->update(['last_activity' => now()]);
            $user = Auth::user();
            $currentTime = Carbon::now();
            $arr_time = $currentTime->toArray();
            // dd( $arr_time);
            // echo $arr_time['timestamp'];
            DB::table('erp_staff')
              ->where('staff_id','=',$user->staff_id)
              ->update(['last_activity'=> $currentTime]);
        }

        return $next($request);
    }
}
