<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use App\Models\Stocklist_model;
use Illuminate\Bus\Batchable;

class ExportExcelCarAllocation implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, Batchable;
    private $stockId;
    private $search;
    private $user;
    private $filepath;
    /**
     * Create a new job instance.
     */
    public function __construct($search,$stockId,$user,$filepath)
    {
        $this->stockId = $stockId;
        $this->search = $search;
        $this->user = $user;
        $this->filepath = $filepath;
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        if ($this->batch()->cancelled()) {
            return;
        }
        require trim($_SERVER["DOCUMENT_ROOT"],'public').'vendor/autoload.php';
        $spreadsheet = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/staffs_new.xls' );
        $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
       
        $spreadsheet->getActiveSheet()->setTitle( 'SHEET' );
        $check = is_array(json_decode( $this->search)) ? count(json_decode( $this->search)) : 0;
        $where=array();
        $where_manul = "a.car_stock_id <> ''";
        $status_join ="";
        if($check > 0){
            foreach(json_decode( $this->search) as $item){
                if($item->purpose){
                    $where['a.purpose'] = $item->purpose;//
                }
                if($item->car_status){
                    $where['a.status'] = $item->car_status;//
                }
                if($item->car_mark){
                    $where['a.car_make_en'] = $item->car_mark;//
                }
                if($item->search_car_document){
                   if($item->search_car_document =="Y"){
                        $where['a.car_documents'] ="y";
                   }else{
                        $where_manul .= " AND (a.car_documents <> 'y' OR a.car_documents IS NULL) ";
                   }
                }
                if($item->purchase_name){
                    $where['a.purchaser'] = $item->purchase_name;//
                }
                if($item->location){
                    $where['a.car_location_en'] = $item->location;//
                }
                if($item->car_model){
                    $where['a.car_model_en'] = $item->car_model;//
                }
                if($item->shipok_status){
                    if($item->shipok_status=="already"){
                        $where['a.status'] = '7';
                    }else{
                        $where_manul .= " AND (a.status < '7') ";//
                    }
                   
                }
                
                if($item->shipout_status){
                    if($item->shipout_status=="already"){
                        $where_manul .= "AND (sh.etd <= '".date("Y-m-d")."')";
                    }else{
                        $where_manul .= "AND sh.etd >='".date("Y-m-d")."' OR sh.etd IS NULL";//
                    }
                }
                if($item->soldout_status){
                    if($item->soldout_status=="already"){
                        $where['a.status'] = '9';
                    }else{
                        $where_manul .= " AND (a.status < '9') ";//
                    }  
                }
                if($item->search_reexport){
                    $where['a.car_reexport'] = $item->search_reexport;//
                }
                if($item->search_re_export){
                    if($item->search_re_export == "yes"){
                        $where_manul .= "AND ( `a`.`car_reexport` is not NULL and a.car_reexport > 0 AND date(shd.etd) <= '".date('Y-m-d')."')";
                    }
                    if($item->search_re_export == "no"){
                        $where_manul .= "AND (date(shd.etd) > '".date('Y-m-d')."' OR shd.etd IS NULL)";//
                    }
                }
                if($item->ec_status){
                    if ($item->ec_status=='notyet') {
                        $where_manul .= " AND (doc.doc_type IS NULL)";
                    }else{
                        $where_manul .= " AND ( doc.doc_type  IN ('ec','ecj','ece')) ";//
                        
                    }
                }
                if($item->city){
                    $where['a.car_city_en'] = $item->city;//
                }
                if($item->booking_status){
                    if($item->booking_status=="already"){
                        $where_manul .= " AND (a.shipment_id <> '')";//
                
                    }else{
                        $where_manul .= " AND (a.shipment_id IS NULL)";//
                    }
                }
                if($item->search_yard_photo1){
                    if($item->search_yard_photo1=="yes"){
                        $where_manul .= " AND (a.car_yard_photo <> '')";//
                    }else{
                        $where_manul .= " AND (a.car_yard_photo IS NULL)"; //
                    }
                }
                if($item->search_cus){
                    $where['a.customer_id'] = $item->search_cus;//
                }
                if($item->recycle_ok_status){
                    if($item->recycle_ok_status=="already"){
                        $where['a.recycle_ok']= "Y";
                    }else{
                        $where_manul .= " AND (a.recycle_ok <> 'Y' OR a.recycle_ok IS NULL) ";//
                    }
                }
                if($item->yard){
                    $where['k.stock_yard_name'] = $item->yard;//
                }

                if($item->from_year_model){
                    $where_manul .= " AND (a.car_model_year >= '".$item->from_year_model."' ) ";//
                }

                if($item->to_year_model){
                    $where_manul .= " AND (a.car_model_year <= '".$item->to_year_model."' ) ";//
                }
              
                if($item->releasebl_status){
                    if($item->releasebl_status=="already"){
                        $where['a.status']='8';
                    }else{
                        $where_manul .= " AND (a.status < 8) ";//
                    }
                }
                if($item->search_yard_photo2){
                    if($item->search_yard_photo2=="yes"){
                        $where_manul .= " AND ( a.car_yard_photo_two <> '' )";//
                    }else{
                        $where_manul .= " AND ( a.car_yard_photo_two IS NULL )";//
                    }
                }
                if($item->searchSales){
                    $where['cus.staff_id'] = $item->searchSales;//
                }
                if($item->color){
                    $where['a.color'] = $item->color;
                }
                $search_option = $item->search_option;
                if($search_option){
                    if($item->search_boxs){
                        if($search_option == "chassisno"){
                            $where_manul .= " AND (a.chassis_number LIKE '%".$item->search_boxs."%')";//
                        }else if($search_option == "stockno"){
                            $con_stock = "";
                            $stock_ex = explode(" ",$item->search_boxs);
                            foreach ($stock_ex as $val) {
                                $con_stock .= "'".$val."',";
                            }
                            $where_manul .= " AND ( a.stock_id IN(".trim($con_stock,",").") )";
                        }else  if($search_option == "invoice_no"){
                            $where['a.invoice_no'] = $item->search_boxs;
                        }else  if($search_option == "proforma_invoice_no"){
                            $where['a.invoice_id']= $item->search_boxs;
                        }else if($search_option == "order_id"){
                            $where['a.order_id'] = $item->search_boxs;
                        }
                    }
                }
                $start_date = $item->search_date_starts;
                $end_date = $item->search_date_ends;
                if(!empty($start_date) || !empty($end_date)){

                    if($item->rang_date_option == "buying_date"){
                        if(!empty($start_date) && !empty($end_date))
                           $where_manul .= " AND ( date(a.buying_date) >= '".$start_date."' AND  date(a.buying_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                           $where_manul .= " AND ( date(a.buying_date) >= '".$start_date."' ' )";
                        else
                            $where_manul .= " AND ( date(a.buying_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "reserved"){
                        $where['a.status']= "2";
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "shipok"){
                        $where['a.status']='7';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "releasebl"){
                        $where['a.status']='8';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "soldout"){
                        $where['a.status']='9';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "etd_re_export"){
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(shd.etd) >= '".$start_date."' AND  date(shd.etd) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(shd.etd) >= '".$start_date."' )";
                        else
                            $where_manul .= " AND ( date(shd.etd) <= '".$end_date."' )";  
                    }elseif($item->rang_date_option == "etd"){
                       
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(sh.etd) >= '".$start_date."' AND  date(sh.etd) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(sh.etd) >= '".$start_date."' )";
                        else
                            $where_manul .= " AND ( date(sh.etd) <= '".$end_date."' )";
                    }        
                }
                $arr_data = array();
                $record_excel_allcate = Stocklist_model::get_total_record_excel_allcate($status_join,$where,$where_manul,$item->rang_date_option,$this->stockId);
          
                $k = 1;
                foreach($record_excel_allcate as $val){
                    $k += 1;
                    $data_car_allocate = Stocklist_model::get_data_car_allocate($val->stock_id);
                    $first = "";
                    $date1 = "";
                    $description1 = "";
                    $secord = "";
                    $date2 = "";
                    $description2 = "";
                    $third = "";
                    $date3 = "";
                    $description3 = "";
                    $four = "";
                    $date4 = "";
                    $description4 = "";
                    $five = "";
                    $date5 = "";
                    $description5 = ""; 
                    $six = "";
                    $date6 = "";
                    $description6 = "";
                    $cus_name ="";
                    $i = 0;
               
                    foreach($data_car_allocate as $value){
                        $i += 1;
                        if($i == 1){
                            $first = $value->car_allocate_currency == 'USD' ? number_format($value->car_allocate,2) : number_format($value->car_allocate);
                            $date1 = date_format(date_create($value->deposit_date),'Y-m-d');
                            $description1 = $value->des_income;
                        }elseif($i == 2){
                            $secord = $value->car_allocate_currency == 'USD' ? number_format($value->car_allocate,2) : number_format($value->car_allocate);
                            $date2 =date_format(date_create($value->deposit_date),'Y-m-d');
                            $description2 = $value->des_income;
                        }elseif($i == 3){
                            $third = $value->car_allocate_currency == 'USD' ? number_format($value->car_allocate,2) : number_format($value->car_allocate);
                            $date3 = date_format(date_create($value->deposit_date),'Y-m-d');
                            $description3 = $value->des_income;
                        }elseif($i == 4){
                            $four = $value->car_allocate_currency == 'USD' ? number_format($value->car_allocate,2) : number_format($value->car_allocate);
                            $date4 =date_format(date_create($value->deposit_date),'Y-m-d');
                            $description4 = $value->des_income;
                        }elseif($i == 5){
                            $five = $value->car_allocate_currency == 'USD' ? number_format($value->car_allocate,2) : number_format($value->car_allocate);
                            $date5 =date_format(date_create($value->deposit_date),'Y-m-d');
                            $description5 = $value->des_income;
                        }elseif($i == 6){
                            $six = $value->car_allocate_currency == 'USD' ? number_format($value->car_allocate,2) : number_format($value->car_allocate);
                            $date6 =date_format(date_create($value->deposit_date),'Y-m-d');
                            $description6 = $value->des_income;
                        }
                    }
                    $total_sold_price = $val->sold_price_currency == 'USD' ? number_format($val->total_sold_price,2) : number_format($val->total_sold_price);
                    $boss_price = $val->boss_currency == 'USD' ? number_format($val->boss_price,2) : number_format($val->boss_price);
                    $spreadsheet->getActiveSheet()->setCellValue('A'.$k, $val->stock_id);
                    $spreadsheet->getActiveSheet()->setCellValue('B'.$k, $val->car_model_name);
                    $spreadsheet->getActiveSheet()->setCellValue('C'.$k, $val->chassis_number);
                    $spreadsheet->getActiveSheet()->setCellValue('D'.$k, $boss_price);
                    $spreadsheet->getActiveSheet()->setCellValue('E'.$k, $total_sold_price);
                    $spreadsheet->getActiveSheet()->setCellValue('F'.$k, $val->boss_currency);
                    $spreadsheet->getActiveSheet()->setCellValue('G'.$k,str_replace('-','/', $val->etd));
                    $spreadsheet->getActiveSheet()->setCellValue('H'.$k,str_replace('-','/', $val->bl_date));
                    $spreadsheet->getActiveSheet()->setCellValue('I'.$k, $val->customer_id);
                    $spreadsheet->getActiveSheet()->setCellValue('J'.$k, $val->cus_name);
                    $spreadsheet->getActiveSheet()->setCellValue('K'.$k,$description1);
                    $spreadsheet->getActiveSheet()->setCellValue('L'.$k,str_replace('-','/', $date1));
                    $spreadsheet->getActiveSheet()->setCellValue('M'.$k, $first);
                    $spreadsheet->getActiveSheet()->setCellValue('N'.$k,$description2);
                    $spreadsheet->getActiveSheet()->setCellValue('O'.$k,str_replace('-','/', $date2));
                    $spreadsheet->getActiveSheet()->setCellValue('P'.$k, $secord);
                    $spreadsheet->getActiveSheet()->setCellValue('Q'.$k,$description3);
                    $spreadsheet->getActiveSheet()->setCellValue('R'.$k,str_replace('-','/', $date3));
                    $spreadsheet->getActiveSheet()->setCellValue('S'.$k, $third);
                    $spreadsheet->getActiveSheet()->setCellValue('T'.$k,$description4);
                    $spreadsheet->getActiveSheet()->setCellValue('U'.$k,str_replace('-','/', $date4));
                    $spreadsheet->getActiveSheet()->setCellValue('V'.$k, $four);
                    $spreadsheet->getActiveSheet()->setCellValue('W'.$k,$description5);
                    $spreadsheet->getActiveSheet()->setCellValue('X'.$k,str_replace('-','/', $date5));
                    $spreadsheet->getActiveSheet()->setCellValue('Y'.$k, $five);
                    $spreadsheet->getActiveSheet()->setCellValue('Z'.$k,$description6);
                    $spreadsheet->getActiveSheet()->setCellValue('AA'.$k,str_replace('-','/', $date6));
                    $spreadsheet->getActiveSheet()->setCellValue('AB'.$k, $six);
                   
                }

                $styleArray = [
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                        ],
                    ],
                ];
    
                $spreadsheet->getActiveSheet()->getStyle( 'A2:AB'.$k )->applyFromArray( $styleArray );
                $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($spreadsheet);
        
                // header( 'Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' );
                $writer->save($this->filepath);
              } 
        }
    }
}
