<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use App\Models\Stocklist_model;
use Illuminate\Bus\Batchable;

class ExportExcelStaff implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, Batchable;
    private $stockId;
    private $search;
    private $user;
    private $filepath;
    private $baseUrl;
    /**
     * Create a new job instance.
     */
    public function __construct($search,$stockId,$user,$filepath,$baseUrl)
    {
        $this->stockId = $stockId;
        $this->search = $search;
        $this->user = $user;
        $this->filepath = $filepath;
        $this->baseUrl = $baseUrl;
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        if ($this->batch()->cancelled()) {
            return;
        }
        require trim($_SERVER["DOCUMENT_ROOT"],'public').'vendor/autoload.php';
        $spreadsheet = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/bbs_excel_customer.xls' );
        $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
       
        $spreadsheet->getActiveSheet()->setTitle( 'SHEET' );
        $check = is_array(json_decode($this->search)) ? count(json_decode($this->search)) : 0;
        $where=array();
        $where_manul = "a.car_stock_id <> ''";
        $status_join ="";
     
        if($check > 0){
            foreach(json_decode($this->search) as $item){
                if($item->purpose){
                    $where['a.purpose'] = $item->purpose;//
                }
                if($item->car_status){
                    $where['a.status'] = $item->car_status;//
                }
                if($item->car_mark){
                    $where['a.car_make_en'] = $item->car_mark;//
                }
                if($item->search_car_document){
                   if($item->search_car_document =="Y"){
                        $where['a.car_documents'] ="y";
                   }else{
                        $where_manul .= " AND (a.car_documents <> 'y' OR a.car_documents IS NULL) ";
                   }
                }
                if($item->purchase_name){
                    $where['a.purchaser'] = $item->purchase_name;//
                }
                if($item->location){
                    $where['a.car_location_en'] = $item->location;//
                }
                if($item->car_model){
                    $where['a.car_model_en'] = $item->car_model;//
                }
                if($item->shipok_status){
                    if($item->shipok_status=="already"){
                        $where['a.status'] = '7';
                    }else{
                        $where_manul .= " AND (a.status < '7') ";//
                    }
                   
                }
                
                if($item->shipout_status){
                    if($item->shipout_status=="already"){
                        $where_manul .= "AND (sh.etd <= '".date("Y-m-d")."')";
                    }else{
                        $where_manul .= "AND sh.etd >='".date("Y-m-d")."' OR sh.etd IS NULL";//
                    }
                }
                if($item->soldout_status){
                    if($item->soldout_status=="already"){
                        $where['a.status'] = '9';
                    }else{
                        $where_manul .= " AND (a.status < '9') ";//
                    }  
                }
                if($item->search_reexport){
                    $where['a.car_reexport'] = $item->search_reexport;//
                }
                if($item->search_re_export){
                    if($item->search_re_export == "yes"){
                        $where_manul .= "AND ( `a`.`car_reexport` is not NULL and a.car_reexport > 0 AND date(shd.etd) <= '".date('Y-m-d')."')";
                    }
                    if($item->search_re_export == "no"){
                        $where_manul .= "AND (date(shd.etd) > '".date('Y-m-d')."' OR shd.etd IS NULL)";//
                    }
                }
                // if($item->ec_status){
                //     if ($item->ec_status=='notyet') {
                //         $where_manul .= " AND (doc.doc_type IS NULL)";
                //     }else{
                //         $where_manul .= " AND ( doc.doc_type  IN ('ec','ecj','ece')) ";//
                        
                //     }
                // }
                if($item->city){
                    $where['a.car_city_en'] = $item->city;//
                }
                if($item->booking_status){
                    if($item->booking_status=="already"){
                        $where_manul .= " AND (a.shipment_id <> '')";//
                
                    }else{
                        $where_manul .= " AND (a.shipment_id IS NULL)";//
                    }
                }
                if($item->search_yard_photo1){
                    if($item->search_yard_photo1=="yes"){
                        $where_manul .= " AND (a.car_yard_photo <> '')";//
                    }else{
                        $where_manul .= " AND (a.car_yard_photo IS NULL)"; //
                    }
                }
                if($item->search_cus){
                    $where['a.customer_id'] = $item->search_cus;//
                }
                if($item->recycle_ok_status){
                    if($item->recycle_ok_status=="already"){
                        $where['a.recycle_ok']= "Y";
                    }else{
                        $where_manul .= " AND (a.recycle_ok <> 'Y' OR a.recycle_ok IS NULL) ";//
                    }
                }
                if($item->yard){
                    $where['k.stock_yard_name'] = $item->yard;//
                }

                if($item->from_year_model){
                    $where_manul .= " AND (a.car_model_year >= '".$item->from_year_model."' ) ";//
                }

                if($item->to_year_model){
                    $where_manul .= " AND (a.car_model_year <= '".$item->to_year_model."' ) ";//
                }
              
                if($item->releasebl_status){
                    if($item->releasebl_status=="already"){
                        $where['a.status']='8';
                    }else{
                        $where_manul .= " AND (a.status < 8) ";//
                    }
                }
                if($item->search_yard_photo2){
                    if($item->search_yard_photo2=="yes"){
                        $where_manul .= " AND ( a.car_yard_photo_two <> '' )";//
                    }else{
                        $where_manul .= " AND ( a.car_yard_photo_two IS NULL )";//
                    }
                }
                if($item->searchSales){
                    $where['cus.staff_id'] = $item->searchSales;//
                }
                if($item->color){
                    $where['a.color'] = $item->color;
                }
               
                $search_option = $item->search_option;
                if($search_option){
                    if($item->search_boxs){
                        if($search_option == "chassisno"){
                            $where_manul .= " AND (a.chassis_number LIKE '%".$item->search_boxs."%')";//
                        }else if($search_option == "stockno"){
                            $con_stock = "";
                            $stock_ex = explode(" ",$item->search_boxs);
                            foreach ($stock_ex as $val) {
                                $con_stock .= "'".$val."',";
                            }
                            $where_manul .= " AND ( a.stock_id IN(".trim($con_stock,",").") )";
                        }else  if($search_option == "invoice_no"){
                            $where['a.invoice_no'] = $item->search_boxs;
                        }else  if($search_option == "proforma_invoice_no"){
                            $where['a.invoice_id']= $item->search_boxs;
                        }else if($search_option == "order_id"){
                            $where['a.order_id'] = $item->search_boxs;
                        }
                    }
                }
                $start_date = $item->search_date_starts;
                $end_date = $item->search_date_ends;
                if(!empty($start_date) || !empty($end_date)){

                    if($item->rang_date_option == "buying_date"){
                        if(!empty($start_date) && !empty($end_date))
                           $where_manul .= " AND ( date(a.buying_date) >= '".$start_date."' AND  date(a.buying_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                           $where_manul .= " AND ( date(a.buying_date) >= '".$start_date."' ' )";
                        else
                            $where_manul .= " AND ( date(a.buying_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "reserved"){
                        $where['a.status']= "2";
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "shipok"){
                        $where['a.status']='7';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "releasebl"){
                        $where['a.status']='8';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "soldout"){
                        $where['a.status']='9';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "etd_re_export"){
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(shd.etd) >= '".$start_date."' AND  date(shd.etd) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(shd.etd) >= '".$start_date."' )";
                        else
                            $where_manul .= " AND ( date(shd.etd) <= '".$end_date."' )";  
                    }elseif($item->rang_date_option == "etd"){
                       
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(sh.etd) >= '".$start_date."' AND  date(sh.etd) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(sh.etd) >= '".$start_date."' )";
                        else
                            $where_manul .= " AND ( date(sh.etd) <= '".$end_date."' )";
                    }        
                }
              
                $user_data = $this->user;
                $permission = Stocklist_model::data_group_user($user_data->staff_id);
                if($permission == 'Sale'){
                  $where_manul .= " AND (cus.staff_id =  ".$user_data->staff_id." OR  cus.staff_id IS NULL)  ";
                }
                $to_hide = array();
                $hide_pakistan =  Stocklist_model::hide_car_on_stock_list($user_data->staff_id);
                if ($hide_pakistan) {
                    $get_country_list_id_block =   Stocklist_model::get_country_list_id_block();
                       foreach ($get_country_list_id_block as $k => $row) {
                           array_push($to_hide, $row->country_name);
                   }
                }
                
                $export_transport_data = Stocklist_model::get_total_record_excel($status_join,$where,$where_manul,$item->rang_date_option,$this->stockId,$to_hide);
                $row = 1;
                foreach($export_transport_data as $val){

                    $row += 1;
                    if($val->status == "1"){
                        $car_status = "Sale";
                    }elseif($val->status == "2"){
                        $car_status = "Reserved";
                    }elseif($val->status == "3"){
                        $car_status = "Repair";
                    }elseif($val->status == "4"){
                        $car_status = "undernegotiate";
                    }elseif($val->status == "5"){
                        $car_status = "Canceled";
                    }elseif($val->status == "6"){
                        $car_status = "Customer order";
                    }elseif($val->status == "7"){
                        $car_status = "Shipok";
                    }elseif($val->status == "8"){
                        $car_status = "Releasebl";
                    }else{
                        $car_status = "Soldout";
                    }

                    $get_sold_price = Stocklist_model::get_sold_price_from_reserve($val->stock_id);
                    $fob =0;
                    $freight=0;
                    $total_sold_price = 0;
                    $currency_reseved = '';
                    if(COUNT($get_sold_price) >0){
                        foreach ($get_sold_price as $rows) {
                            $currency_reseved = $rows->currency;
                            $fob += !empty($rows->fob) ? $rows->fob : 0;
                            $freight += !empty($rows->freight) ? $rows->freight : 0;
                        }
                        $total_sold_price =  $fob +  $freight;      
                    }

                    $deposit = 0;
                    $cur_dep = '';
                    $income = Stocklist_model::get_car_income($val->stock_id);
                    if(count($income) > 0){
                        $deposit = $income[0]->total_allocate;
                        $cur_dep = $income[0]->car_allocate_currency;
                    }
                  
                    $deposit_auction = 0;
                    $cur_dep_auction = '';
                    $income_auction = Stocklist_model::get_car_auction_income($val->stock_id);
                    if(count($income_auction) > 0){
                        $deposit_auction = $income_auction[0]->total_allocate;
                        $cur_dep_auction = $income_auction[0]->car_allocate_currency;
                    }

                    if($val->etd > date("Y-m-d")){
                        $ship_out_stat = "O";
                    }else{
                        $ship_out_stat = "X";
                    }
                    if(!empty($val->shipment_id)){
                        $booking_sta = "O";
                    }else{
                        $booking_sta = "X";
                    }

                    @$car_chassis = explode("-",$val->chassis_number);
                    $car_model_size = Stocklist_model::get_model_size_stocklist();
                    $get_cbm_info = Stocklist_model::get_cbm_value($item->county_excel,$item->port_excel);
                  
                    $total_freight =0;
                    $total_price = 0;
                    foreach ($car_model_size as $value) {
            
                        if($value->car_model == $val->car_model_en && $value->car_model_code==$car_chassis){
                            $total_freight = $value->car_size * @$get_cbm_info[0]->cbm_price;
                            $inspection = $get_cbm_info[0]->inspection;
                            $insurance = $get_cbm_info[0]->insurance;
                        }else{
                            $total_freight = 0;
                            $inspection = 0;
                            $insurance = 0;
                        }
                        if(count($get_cbm_info) > 0){
            
                            $total_price = $val->car_selling_price_amount + $total_freight + $get_cbm_info[0]->inspection + $get_cbm_info[0]->insurance - $val->car_discount;
            
                        }
                    }
                   
                    $link_car =$this->baseUrl."/home/car_details/".$val->stock_id;
                    $spreadsheet->getActiveSheet()->setCellValue('A'.$row, $val->stock_id)                 
                                                    ->setCellValue('B'.$row, $val->car_location_en)
                                                    ->setCellValue('C'.$row, $val->car_city_en)
                                                    ->setCellValue('D'.$row, $val->car_yard_en)
                                                    ->setCellValue('E'.$row, $car_status)
                                                    ->setCellValue('F'.$row, $val->car_model_en)
                                                    ->setCellValue('G'.$row, $val->chassis_number)
                                                    ->setCellValue('H'.$row, $val->car_model_year)
                                                    ->setCellValue('I'.$row, $val->date_of_production)
                                                    ->setCellValue('J'.$row, "")
                                                    ->setCellValue('K'.$row, $val->grade)
                                                    ->setCellValue('L'.$row, $val->car_fuel)
                                                    ->setCellValue('M'.$row, $val->engine_size)
                                                    ->setCellValue('N'.$row, "")
                                                    ->setCellValue('O'.$row, $val->color_name)
                                                    ->setCellValue('P'.$row, $val->seats)
                                                    ->setCellValue('Q'.$row, $val->memo_for_web)
                                                    ->setCellValue('R'.$row, $val->car_fob_type)
                                                    ->setCellValue('S'.$row, $val->car_fob)
                                                    ->setCellValue('T'.$row, '=Hyperlink("'.$link_car.'","LINK PHOTO")')
                                                    ->setCellValue('U'.$row, $total_price)
                                                    ->setCellValue('V'.$row, $val->car_discount);
                }
               
                $styleArray = [
                    'borders' => [
                        'allBorders' => [
                            'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                        ],
                    ],
                ];
    
                $spreadsheet->getActiveSheet()->getStyle( 'A2:V'.$row )->applyFromArray( $styleArray );
                $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($spreadsheet);
        
                // header( 'Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' );
                $writer->save($this->filepath);
            }
        }
    }
}
