<?php

namespace App\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use PhpOffice\PhpSpreadsheet\Style\Border;
use PhpOffice\PhpSpreadsheet\Style\Alignment;
use App\Models\Stocklist_model;
use Illuminate\Bus\Batchable;
class ExportExcelStock implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels, Batchable;
    private $stockId;
    private $search;
    private $user;
    private $filepath;
    /**
     * Create a new job instance.
     */
    public function __construct($search,$stockId,$user,$filepath)
    {
        $this->stockId = $stockId;
        $this->search = $search;
        $this->user = $user;
        $this->filepath = $filepath;
    }

    /**
     * Execute the job.
     */
    public function handle()
    {
        if ($this->batch()->cancelled()) {
            return;
        }
        require trim($_SERVER["DOCUMENT_ROOT"],'public').'vendor/autoload.php';
        $spreadsheet = new Spreadsheet();
        $inputFileName = storage_path( 'app/public/PHPEXCEL/bbs_excel_staff.xls' );
        $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load( $inputFileName );
       
        $spreadsheet->getActiveSheet()->setTitle( 'SHEET' );
        $check = is_array(json_decode($this->search)) ? count(json_decode($this->search)) : 0;
   
        $where=array();
        $where_manul = "a.car_stock_id <> ''";
        $status_join ="";
           if($check > 0){
            foreach(json_decode($this->search) as $item){
               
                if($item->purpose){
                    $where['a.purpose'] = $item->purpose;//
                }
                if($item->car_status){
                    $where['a.status'] = $item->car_status;//
                }
                if($item->car_mark){
                    $where['a.car_make_en'] = $item->car_mark;//
                }
                if($item->search_car_document){
                   if($item->search_car_document =="Y"){
                        $where['a.car_documents'] ="y";
                   }else{
                        $where_manul .= " AND (a.car_documents <> 'y' OR a.car_documents IS NULL) ";
                   }
                }
                if($item->purchase_name){
                    $where['a.purchaser'] = $item->purchase_name;//
                }
                if($item->location){
                    $where['a.car_location_en'] = $item->location;//
                }
                if($item->car_model){
                    $where['a.car_model_en'] = $item->car_model;//
                }
                if($item->shipok_status){
                    if($item->shipok_status=="already"){
                        $where['a.status'] = '7';
                    }else{
                        $where_manul .= " AND (a.status < '7') ";//
                    }
                   
                }
                
                if($item->shipout_status){
                    if($item->shipout_status=="already"){
                        $where_manul .= "AND (sh.etd <= '".date("Y-m-d")."')";
                    }else{
                        $where_manul .= "AND sh.etd >='".date("Y-m-d")."' OR sh.etd IS NULL";//
                    }
                }
                if($item->soldout_status){
                    if($item->soldout_status=="already"){
                        $where['a.status'] = '9';
                    }else{
                        $where_manul .= " AND (a.status < '9') ";//
                    }  
                }
                if($item->search_reexport){
                    $where['a.car_reexport'] = $item->search_reexport;//
                }
                if($item->search_re_export){
                    if($item->search_re_export == "yes"){
                        $where_manul .= "AND ( `a`.`car_reexport` is not NULL and a.car_reexport > 0 AND date(shd.etd) <= '".date('Y-m-d')."')";
                    }
                    if($item->search_re_export == "no"){
                        $where_manul .= "AND (date(shd.etd) > '".date('Y-m-d')."' OR shd.etd IS NULL)";//
                    }
                }
                if($item->city){
                    $where['a.car_city_en'] = $item->city;//
                }
                if($item->booking_status){
                    if($item->booking_status=="already"){
                        $where_manul .= " AND (a.shipment_id <> '')";//
                
                    }else{
                        $where_manul .= " AND (a.shipment_id IS NULL)";//
                    }
                }
                if($item->search_yard_photo1){
                    if($item->search_yard_photo1=="yes"){
                        $where_manul .= " AND (a.car_yard_photo <> '')";//
                    }else{
                        $where_manul .= " AND (a.car_yard_photo IS NULL)"; //
                    }
                }
                if($item->search_cus){
                    $where['a.customer_id'] = $item->search_cus;//
                }
                if($item->recycle_ok_status){
                    if($item->recycle_ok_status=="already"){
                        $where['a.recycle_ok']= "Y";
                    }else{
                        $where_manul .= " AND (a.recycle_ok <> 'Y' OR a.recycle_ok IS NULL) ";//
                    }
                }
                if($item->yard){
                    $where['k.stock_yard_name'] = $item->yard;//
                }

                if($item->from_year_model){
                    $where_manul .= " AND (a.car_model_year >= '".$item->from_year_model."' ) ";//
                }

                if($item->to_year_model){
                    $where_manul .= " AND (a.car_model_year <= '".$item->to_year_model."' ) ";//
                }
              
                if($item->releasebl_status){
                    if($item->releasebl_status=="already"){
                        $where['a.status']='8';
                    }else{
                        $where_manul .= " AND (a.status < 8) ";//
                    }
                }
                if($item->search_yard_photo2){
                    if($item->search_yard_photo2=="yes"){
                        $where_manul .= " AND ( a.car_yard_photo_two <> '' )";//
                    }else{
                        $where_manul .= " AND ( a.car_yard_photo_two IS NULL )";//
                    }
                }
                if($item->searchSales){
                    $where['cus.staff_id'] = $item->searchSales;//
                }
                if($item->color){
                    $where['a.color'] = $item->color;
                }
                $search_option = $item->search_option;
                if($search_option){
                    if($item->search_boxs){
                        if($search_option == "chassisno"){
                            $where_manul .= " AND (a.chassis_number LIKE '%".$item->search_boxs."%')";//
                        }else if($search_option == "stockno"){
                            $con_stock = "";
                            $stock_ex = explode(" ",$item->search_boxs);
                            foreach ($stock_ex as $val) {
                                $con_stock .= "'".$val."',";
                            }
                            $where_manul .= " AND ( a.stock_id IN(".trim($con_stock,",").") )";
                        }else  if($search_option == "invoice_no"){
                            $where['a.invoice_no'] = $item->search_boxs;
                        }else  if($search_option == "proforma_invoice_no"){
                            $where['a.invoice_id']= $item->search_boxs;
                        }else if($search_option == "order_id"){
                            $where['a.order_id'] = $item->search_boxs;
                        }
                    }
                }
                $start_date = $item->search_date_starts;
                $end_date = $item->search_date_ends;
                if(!empty($start_date) || !empty($end_date)){

                    if($item->rang_date_option == "buying_date"){
                        if(!empty($start_date) && !empty($end_date))
                           $where_manul .= " AND ( date(a.buying_date) >= '".$start_date."' AND  date(a.buying_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                           $where_manul .= " AND ( date(a.buying_date) >= '".$start_date."' ' )";
                        else
                            $where_manul .= " AND ( date(a.buying_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "reserved"){
                        $where['a.status']= "2";
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "shipok"){
                        $where['a.status']='7';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "releasebl"){
                        $where['a.status']='8';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "soldout"){
                        $where['a.status']='9';
                        $status_join ="show";
                        $where['his.status']='active';
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."' AND  date(his.create_date) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(his.create_date) >= '".$start_date."'";
                        else
                            $where_manul .= " AND ( date(his.create_date) <= '".$end_date."' )";
                    }elseif($item->rang_date_option == "etd_re_export"){
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(shd.etd) >= '".$start_date."' AND  date(shd.etd) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(shd.etd) >= '".$start_date."' )";
                        else
                            $where_manul .= " AND ( date(shd.etd) <= '".$end_date."' )";  
                    }elseif($item->rang_date_option == "etd"){
                       
                        if(!empty($start_date) && !empty($end_date))
                            $where_manul .= " AND ( date(sh.etd) >= '".$start_date."' AND  date(sh.etd) <= '".$end_date."' )";
                        elseif (!empty($start_date) && empty($end_date))
                            $where_manul .= " AND ( date(sh.etd) >= '".$start_date."' )";
                        else
                            $where_manul .= " AND ( date(sh.etd) <= '".$end_date."' )";
                    }        
                }
               
                $data_user = $this->user;
                $permission =Stocklist_model::data_group_user($data_user->staff_id);
           
                if($permission == 'Sale'){
                  $where_manul .= " AND (cus.staff_id =  ".$data_user->staff_id." OR  cus.staff_id IS NULL)  ";
                }
                $to_hide = array();

                $hide_pakistan =  Stocklist_model::hide_car_on_stock_list($data_user->staff_id);
           
                if ($hide_pakistan) {
                    $get_country_list_id_block =   Stocklist_model::get_country_list_id_block();
                       foreach ($get_country_list_id_block as $k => $row) {
                           array_push($to_hide, $row->country_name);
                   }
                }
                $get_auction_income = array();
                $export_transport_data = Stocklist_model::get_total_record_excel($status_join,$where,$where_manul,$item->rang_date_option,$this->stockId,$to_hide);

                $row = 2;
               
                foreach($export_transport_data as $val){

                    if($val->status == "1"){
                        $car_status = "Sale";
                    }elseif($val->status == "2"){
                        $car_status = "Reserved";
                    }elseif($val->status == "3"){
                        $car_status = "Repair";
                    }elseif($val->status == "4"){
                        $car_status = "undernegotiate";
                    }elseif($val->status == "5"){
                        $car_status = "Canceled";
                    }elseif($val->status == "6"){
                        $car_status = "Customer order";
                    }elseif($val->status == "7"){
                        $car_status = "Shipok";
                    }elseif($val->status == "8"){
                        $car_status = "Releasebl";
                    }else{
                        $car_status = "Soldout";
                    }
                    
                    $ec_stat = "X";
                    $bl_stat = "X";
                    $count_ec = Stocklist_model::get_count_doc_by_type('ec',$val->stock_id);
                    if($count_ec > 0){
                        $ec_sta = "O";
                    }
                    $count_bl = Stocklist_model::get_count_doc_by_type('bl',$val->stock_id);
                    if($count_bl > 0){
                        $bl_stat = "O";
                    }

                    if($val->instruction == "repair"){
                        $instruction = "repair";
                    }elseif ($val->instruction == "under_conversion") {
                        $instruction = "Under Conversion";
                    }elseif ($val->instruction == "on_the_way_to") {
                        $instruction = "Shipping to";
                    }else{
                        $instruction = "";
                    }
                 
                    $mp3 = ($val->car_width*$val->car_height*$val->car_length) / 100;
                  
                    $paid_per = 0;
                    $cal_per = 0;
                    $total_sold_price = 1;
                    if(!empty($val->total_sold_price)){
                        $total_sold_price =$total_sold_price;
                    }
                    if ($val->sold_price_currency == "USD" && $val->sumusd != '') {
                        $cal_per = $val->sumusd/$total_sold_price;
                        $paid_per = $cal_per *100; 
                    }elseif ($val->sold_price_currency == "JPY" && $val->sumjpy != '') {
                        $cal_per = $val->sumjpy/$total_sold_price;
                        $paid_per = $cal_per *100;
                    }
                    
                    @$paid_percent = $val->car_allocate*100 / $total_sold_price;
                    
                    $cur_dep_auction = '';
                    $deposit_auction = 0;
                    $cur_dep_auction = 0;
                    $income_auction = Stocklist_model::get_car_auction_income($val->stock_id);
                    if(count($income_auction) > 0){
                        $deposit_auction = $income_auction[0]->total_allocate;
                        $cur_dep_auction = $income_auction[0]->car_allocate_currency;
                    }
                   
                    if($val->etd > date("Y-m-d")){
                        $ship_out_stat = "O";
                    }else{
                        $ship_out_stat = "X";
                    }
                    if(!empty($val->shipment_id)){
                        $booking_sta = "O";
                    }else{
                        $booking_sta = "X";
                    }
                    if($val->location_name=='Japan'){
                        $expense_cur="JPY";
                    }else{
                        $expense_cur="USD";
                    }
                    if (!empty($val->bl_dubai)) {
                        $bl_dubai='O';
                    }else{
                        $bl_dubai='X';
                    }
                    if (!empty($val->car_yard_photo_two)) {
                        $yard_two='O';
                    }else{
                        $yard_two='X';
                    }

                    $car_doc = "X";
                    if($val->car_documents =='y'){
                        $car_doc = "O";
                    }
                    $bl_dubai_number = "";
                    if(!empty($val->bl_dubai_number)){
                        $bl_dubai_number = $val->bl_dubai_number;
                    }

                    $spreadsheet->getActiveSheet()->setCellValue( 'A' . $row, $val->stock_id )
                                                  ->setCellValue( 'B' . $row, $val->car_location_en)
                                                  ->setCellValue( 'C' . $row, $val->auction_supplier)
                                                  ->setCellValue( 'D' . $row, $val->car_city_en)
                                                  ->setCellValue( 'E' . $row, $val->car_yard_en)
                                                  ->setCellValue( 'F' . $row, $val->car_market_en)
                                                  ->setCellValue( 'G' . $row, $car_status)
                                                  ->setCellValue( 'H' . $row, $instruction)
                                                  ->setCellValue( 'I' . $row, $val->car_model_en)
                                                  ->setCellValue( 'J' . $row, $val->chassis_number)
                                                  ->setCellValue( 'K' . $row, $val->car_model_year)
                                                  ->setCellValue( 'L' . $row, $val->color_name)
                                                  ->setCellValue( 'M' . $row, $val->buying_date)
                                                  ->setCellValue( 'N' . $row, $expense_cur)
                                                  ->setCellValue( 'O' . $row, $val->buying_price)
                                                  ->setCellValue( 'B' . $row, $val->auction_fee)
                                                  ->setCellValue( 'B' . $row, $val->transportation_fee)
                                                  ->setCellValue( 'B' . $row, $val->repair_fee)
                                                  ->setCellValue( 'B' . $row, $val->inspection_fee)
                                                  ->setCellValue('T'.$row, $val->freight_fee)
                                                  ->setCellValue('U'.$row, $val->shipping_charge_fee)
                                                  ->setCellValue('V'.$row, $val->insurance_fee)
                                                  ->setCellValue('W'.$row, $val->car_tax_fee)
                                                  ->setCellValue('X'.$row, $val->other_fee_amount)
                                                  ->setCellValue('Y'.$row, $val->ea_fee)
                                                  ->setCellValue('Z'.$row, $val->tax_fee)
                                                  ->setCellValue('AA'.$row, $val->recycle_fee)
                                                  ->setCellValue('AB'.$row, $val->other_refund_amount)
                                                  ->setCellValue('AC'.$row, $val->car_selling_price_currency)
                                                  ->setCellValue('AD'.$row, $val->car_selling_price_type)
                                                  ->setCellValue('AE'.$row, $val->car_selling_price_amount)
                                                  ->setCellValue('AF'.$row, $val->sold_price_currency)
                                                  ->setCellValue('AG'.$row, $val->total_sold_price)
                                                  ->setCellValue('AH'.$row, "JPY")
                                                  ->setCellValue('AI'.$row, round($val->profit))
                                                  ->setCellValue('AJ'.$row, number_format($deposit_auction))
                                                  ->setCellValue('AK'.$row, $val->car_allocate_currency)
                                                  ->setCellValue('AL'.$row, $val->car_allocate)
                                                  ->setCellValue('AM'.$row, $val->sumusd)
                                                  ->setCellValue('AN'.$row, $val->sumjpy)
                                                  ->setCellValue('AO'.$row, ($paid_percent != 0) ? number_format($paid_percent, 2).'%' : '0 %')
                                                  ->setCellValue('AP'.$row, $val->sale_name)
                                                  ->setCellValue('AQ'.$row, $val->customer_name)
                                                  ->setCellValue('AR'.$row, $val->reserved_date)
                                                  ->setCellValue('AS'.$row, $val->shipping_co_name)
                                                  ->setCellValue('AT'.$row, $val->discharge_name)
                                                  ->setCellValue('AU'.$row, $val->etd)
                                                  ->setCellValue('AV'.$row, $val->eta)
                                                  ->setCellValue('AW'.$row, $val->vessel_name)
                                                  ->setCellValue('AX'.$row, $booking_sta)
                                                  ->setCellValue('AY'.$row, $ship_out_stat)
                                                  ->setCellValue('AZ'.$row, $car_doc)
                                                  ->setCellValue('BA'.$row, $ec_stat)
                                                  ->setCellValue('BB'.$row, ($val->inspection_booked == "Pass") ? "O":"X")
                                                  ->setCellValue('BC'.$row, $bl_stat)
                                                  ->setCellValue('BD'.$row, $val->recycle_ok)
                                                  ->setCellValue('BE'.$row, $val->inspection_certificate_ok)
                                                  ->setCellValue('BF'.$row, ($val->status >= '7') ? 'O' : 'X')
                                                  ->setCellValue('BG'.$row, ($val->status >= '8') ? 'O' : 'X')
                                                  ->setCellValue('BH'.$row, $val->purpose)
                                                  ->setCellValue('BI'.$row, $val->car_weight)
                                                  ->setCellValue('BJ'.$row, $val->car_length)
                                                  ->setCellValue('BK'.$row, $val->car_width)
                                                  ->setCellValue('BL'.$row, $val->car_height)
                                                  ->setCellValue('BM'.$row, $mp3)
                                                  ->setCellValue('BN'.$row, $val->car_reexport)
                                                  ->setCellValue('BO'.$row, $val->dubai_etd)
                                                  ->setCellValue('BP'.$row, $val->dubai_eta)
                                                  ->setCellValue('BQ'.$row, $bl_dubai_number)
                                                  ->setCellValue('BR'.$row, $val->dubai_vessel)
                                                  ->setCellValue('BS'.$row, $val->arrive_dt)
                                                  ->setCellValue('BT'.$row, $val->convert_dt)
                                                  ->setCellValue('BU'.$row, $yard_two)
                                                  ->setCellValue('BV'.$row, $bl_dubai);
                    $row++;
                }

           

            $styleArray = [
                'borders' => [
                    'allBorders' => [
                        'borderStyle' => \PhpOffice\PhpSpreadsheet\Style\Border::BORDER_THIN
                    ],
                ],
            ];

            $spreadsheet->getActiveSheet()->getStyle( 'A2:BV'.$row )->applyFromArray( $styleArray );
            $writer =  new \PhpOffice\PhpSpreadsheet\Writer\Xls($spreadsheet);
    
            // header( 'Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' );
            $writer->save($this->filepath);
            }
        }
    }
}

