<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Customer_model extends Model
{
    use HasFactory;
    public static function get_cusdep_allocat_remain($customer_id){
        $sql = "SELECT
        erp_stock_list.stock_id,
        SUM(sold.total_sold_price) AS total_soldprice,
        sold.currency,
        SUM(pay.car_allocate) AS car_allocate,
        pay.car_allocate_currency,
        (
            IFNULL(
                SUM(sold.total_sold_price),
                0
            ) - IFNULL(SUM(pay.car_allocate), 0)
        ) AS total_remaining
    FROM
        erp_stock_list
    LEFT JOIN (
        SELECT
            (
                IFNULL(res.fob, 0) + IFNULL(res.freight_fee, 0) + IFNULL(res.insurance, 0) + IFNULL(res.inspection, 0) - IFNULL(res.discount,0)+ IFNULL(res.other_fee,0)+ IFNULL(res.vanning,0)
            ) AS total_sold_price,
            res.created_dt,
            res.stock_id,
            res.currency
        FROM
            (
                SELECT
                    *
                FROM
                    erp_car_reserve
                ORDER BY
                    reserve_id DESC
            ) AS res
        LEFT JOIN erp_stock_list sto ON sto.stock_id = res.stock_id
        
        GROUP BY
            res.stock_id
    ) AS sold ON sold.stock_id = erp_stock_list.stock_id
    LEFT JOIN (
        SELECT
            SUM(car_allocate) AS car_allocate,
            car_allocate_currency,
            stock_id,
            b.customer_deposit_type

        FROM
            erp_carpayments a
        LEFT JOIN erp_customer_deposit b ON b.customer_deposit_id=a.customer_deposit_id
        WHERE b.customer_deposit_type = 'customer_deposit'
        OR b.customer_deposit_type = 'customer_auction_deposit'
        GROUP BY
            stock_id
    ) AS pay ON pay.stock_id = erp_stock_list.stock_id
    WHERE
        customer_id = $customer_id
        AND `status` < 9
    GROUP BY
        sold.currency";
            $data = DB::select($sql);
            return $data;
    }

    public static function update_new($id,$data){
      DB::table('erp_customer')
        ->where('customer_id','=',$id)
        ->update($data);
    } 

}
