<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Expenses_model extends Model
{
    use HasFactory;

    public static function get_car_expenses_other_fee($expense_id){
        $data = DB::table('erp_car_expenses_other_fee')
                ->select('*')
                ->where('car_expense_id','=',$expense_id)
                ->get();
        return $data;
    }

    public static function get_car_expenses_other_refund($expense_id){
        $data = DB::table('erp_car_expenses_other_refund')
               ->select('*')
               ->where('car_expense_id','=',$expense_id)
               ->get();
        return $data;
    }

    public static function data_expenses_division($id){
        $data = DB::table('erp_expenses_division AS a')
                   ->select('*')
                   ->leftjoin('erp_deposit_expense AS b','b.deposit_expense_id','=','a.deposit_expense_id')
                   ->where('expenses_division_id','=',$id)
                   ->get();
        return $data;
    }

    public static function data_deposit_income($customer_deposit_id){
       $select = "SELECT deposit_date,b.deposit_amount,customer_deposit_currency,b.deposit_income_id,description";
       $data = DB::table('erp_customer_deposit AS a')
                ->select(DB::raw($select))
                ->leftjoin('erp_deposit_income AS b','a.deposit_income_id','=','b.deposit_income_id')
                ->where('customer_deposit_id','=',$customer_deposit_id)
                ->get();
        return $data;
    }

    public static function get_car_exp_cus_dep_id($customer_id){
        $data = DB::table('erp_car_expenses')
                  ->select("car_expense_id")
                  ->where('customer_deposit_id','=',$customer_id)
                  ->get();
        return $data;
    }

    public static function remove_other_fee($car_expense_id){
        DB::table('erp_car_expenses_other_fee')
          ->where('car_expense_id','=',$car_expense_id)
          ->delete();
    }

    public static function remove_other_refund($car_expense_id){
        DB::table('erp_car_expenses_other_refund')
          ->where('car_expense_id','=',$car_expense_id)
          ->delete();
    }

    public static function remove_car_expense($id){
        DB::table('erp_car_expenses')
          ->where('car_expense_id','=',$id)
          ->delete();
    }

    public static function expenses_deposit($Perpage,$StartDate,$desc){
        $sql_select_sum = "( SELECT SUM(amount) AS total_amount,deposit_expense_id FROM erp_expenses_division GROUP BY deposit_expense_id) as b";
        $data = DB::table('erp_deposit_expense AS a')
                  ->select(DB::raw("a.deposit_expense_id,a.deposit_raw,a.description,a.deposit,b.total_amount,c.bank_full_name,a.currency_type,a.bank_account_id,a.created_dt,(IFNULL(deposit_raw, 0) - IFNULL(total_amount, 0)) AS total_balance"))
                  ->leftjoin(DB::raw($sql_select_sum),'a.deposit_expense_id','=','b.deposit_expense_id')
                  ->leftjoin('erp_bank_account AS c','a.bank_account_id','=','c.bank_account_id')
                  ->whereRaw("IFNULL(deposit_raw, 0) - IFNULL(total_amount, 0) > 0")
                  ->whereRaw("c.bank_account_id <> 9")
                  ->when(!empty($StartDate),function ($v) use ($StartDate) {
                    $v->whereRaw("date(a.created_dt)='".$StartDate."'");
                  })
                  ->when(!empty($desc),function ($v) use ($desc) {
                    $v->whereRaw("a.description LIKE '%".$desc."%'");
                  })
                  ->orderBy('created_dt','DESC')
                  ->paginate($Perpage);
        return $data;
    }

    public static function expenses_deposit_history($Perpage,$StartDate,$desc){
        $sql = "(SELECT SUM(amount) as total_allocate,deposit_expense_id FROM erp_expenses_division GROUP BY deposit_expense_id) as c";
        $data = DB::table('erp_deposit_expense as a')
                  ->select(DB::raw('a.*,b.bank_full_name'))
                  ->leftjoin('erp_bank_account as b','b.bank_account_id','=','a.bank_account_id')
                  ->leftjoin(DB::raw($sql),'c.deposit_expense_id','=','a.deposit_expense_id')
                  ->whereRaw("(IFNULL(a.deposit_raw,0) - IFNULL(c.total_allocate,0)) <= 0")
                  ->when(!empty($StartDate),function ($v) use ($StartDate) {
                    $v->whereRaw("date(a.created_dt)='".$StartDate."'");
                  })
                  ->when(!empty($desc),function ($v) use ($desc) {
                    $v->whereRaw("a.description LIKE '%".$desc."%'");
                  })
                  ->groupBy('a.deposit_expense_id')
                  ->orderBy('created_dt','DESC')
                  ->paginate($Perpage);
        return $data;
    }

    public static function select_customer_deposit(){
        $sql_select_pay = "( SELECT SUM(IFNULL(car_allocate_origin, 0)) AS total_allocate,car_allocate_origin_currency,customer_deposit_id FROM erp_carpayments WHERE payment_type = 'customer_deposit' OR payment_type = 'refund' GROUP BY customer_deposit_id ) AS car_pay";
        $data = DB::table('erp_customer_deposit AS cus_dep')
                  ->select(DB::raw("cus_dep.customer_deposit_id,deposit_income_id,cus_dep.customer_id,deposit_amount,cus_dep.create_date,car_pay.car_allocate_origin_currency,IFNULL(total_allocate, 0) AS total_allocate,cus.full_name,cus_dep.customer_deposit_currency AS cur_type,(IFNULL(cus_dep.deposit_amount, 0) - IFNULL(total_allocate, 0)) AS total_balance"))
                  ->leftjoin(DB::raw($sql_select_pay),'cus_dep.customer_deposit_id','=','car_pay.customer_deposit_id')
                  ->leftjoin('erp_customer AS cus','cus.customer_id','=','cus_dep.customer_id')
                  ->whereRaw("cus_dep.customer_deposit_type = 'customer_deposit' AND IFNULL(cus_dep.deposit_amount, 0) - IFNULL(total_allocate, 0) > 0")
                  ->orderBy('cus_dep.create_date','DESC')
                  ->get();
        return $data;
    }

    public static function get_current_distribute($where){
       $data = DB::table('erp_expenses_division')
                 ->select('*')
                 ->where($where)
                 ->get();
        return $data;
    }

    public static function echecking_data($expense_types,$customer_id,$amount,$currency_type,$deposit_expense_id,$create_date){
        $data = DB::table('erp_expenses_division')
                  ->select('*')
                  ->where('expense_types','=',$expense_types)
                  ->where('customer_id','=',$customer_id)
                  ->where('amount','=',$amount)
                  ->where('currency_type','=',$currency_type)
                  ->where('deposit_expense_id','=',$deposit_expense_id)
                  ->whereRaw('date(create_date)="'.$create_date.'"')
                  ->get();
        return $data;
    }

    public static function distribute_exec($DataInsert){
        DB::table('erp_expenses_division')
          ->insert($DataInsert);
    }


    public static function data_exponse_deposit($dep_date,$desc){
        $data = DB::table('erp_deposit_expense as a')
                  ->select(DB::raw("a.deposit_expense_id,a.deposit_raw,a.description,a.deposit,b.amount,c.bank_full_name,a.currency_type,a.bank_account_id,a.created_dt"))
                  ->leftjoin('erp_expenses_division as b','a.deposit_expense_id','=','b.deposit_expense_id')
                  ->leftjoin('erp_bank_account as c','a.bank_account_id','=','c.bank_account_id')
                  ->whereRaw('a.deposit > 0')
                  ->when(!empty($dep_date),function ($v) use ($dep_date) {
                    $v->whereRaw("date(a.created_dt) = '".$dep_date."'");
                  })
                  ->when(!empty($desc),function ($v) use ($desc) {
                    $v->whereRaw("description LIKE '%".$desc."%'");
                  })
                  ->orderBy('a.created_dt','DESC')
                  ->groupBy('a.deposit_expense_id')
                  ->get();
        return $data;
    }

    public static  function data_deposit_history($dep_date,$desc){
        $data = DB::table('erp_deposit_expense as a')
                  ->select('*')
                  ->leftjoin('erp_bank_account as b','b.bank_account_id','=','a.bank_account_id')
                  ->leftjoin('erp_expenses_division as c','c.deposit_expense_id','=','a.deposit_expense_id')
                  ->whereRaw('a.deposit <= 0')
                  ->when(!empty($dep_date),function ($v) use ($dep_date) {
                    $v->whereRaw("date(a.created_dt) = '".$dep_date."'");
                  })
                  ->when(!empty($desc),function ($v) use ($desc) {
                    $v->whereRaw("description LIKE '%".$desc."%'");
                  })
                  ->orderBy('a.created_dt','DESC')
                  ->get();
        return $data;

    }

    public static function get_all_history($id){
        $data = DB::table('erp_deposit_expense as a')
                ->select('*')
                ->leftjoin('erp_bank_account as b','b.bank_account_id','=','a.bank_account_id')
                ->leftjoin('erp_expenses_division as c','c.deposit_expense_id','=','a.deposit_expense_id')
                ->where('a.deposit_expense_id','=',$id)
                ->get();
        return $data;
    }

    public static function get_expense_car_amount($divi_id){
        $data = DB::table('erp_car_expenses as a')
                  ->select('*')
                  ->leftjoin('erp_stock_list as b','b.stock_id','=','a.stock_id')
                  ->leftjoin('erp_expenses_division as c','c.expenses_division_id','=','a.expenses_division_id')
                  ->where('a.expenses_division_id','=',$divi_id)
                  ->get();
        return $data;
    }

    public static function getIncomeAmont($divi_id){
        $data = DB::table('erp_carpayments as a')
                  ->select('*')
                  ->leftjoin('erp_stock_list as b','b.stock_id','=','a.stock_id')
                  ->leftjoin('erp_car_reserve as c','c.stock_id','=','a.stock_id')
                  ->where('a.expenses_division_id','=',$divi_id)
                  ->get();
        return $data;
    }

    public static function getIncomeAmontByDivion($division_id){
        $data = DB::table('erp_carpayments')
                  ->select(DB::raw("SUM(car_allocate_origin) AS amount_income"))
                  ->where('expenses_division_id','=',$division_id)
                  ->get();
        return $data;
    }

    public static function get_car_expense_with_chasiss($perPage,$whereRaw){
        $sql = DB::raw("(
        SELECT
          car_expenses.expenses_division_id,
          SUM(IFNULL(buying_price, 0)) + SUM(IFNULL(tax_fee, 0)) + SUM(IFNULL(auction_fee, 0)) + SUM(
            IFNULL(transportation_fee, 0)
          ) + SUM(IFNULL(recycle_fee, 0)) + SUM(IFNULL(car_tax_fee, 0)) + SUM(IFNULL(freight_fee, 0)) + SUM(IFNULL(repair_fee, 0)) + SUM(IFNULL(inspection_fee, 0)) + SUM(
            IFNULL(shipping_charge_fee, 0)
          ) + SUM(IFNULL(insurance_fee, 0)) + SUM(IFNULL(ea_fee, 0)) + SUM(IFNULL(total_other_fee, 0)) + SUM(
            IFNULL(total_other_refund, 0)
          ) AS total_car_expense,
          SUM(IFNULL(total_other_fee, 0)) AS total_other_fee,
          SUM(
            IFNULL(total_other_refund, 0)
          ) AS total_other_refund
        FROM
          erp_car_expenses AS car_expenses
        LEFT JOIN (
          SELECT
            SUM(amount) AS total_other_fee,
            car_expense_id
          FROM
            erp_car_expenses_other_fee
          GROUP BY
            car_expense_id
        ) AS other_fee ON other_fee.car_expense_id = car_expenses.car_expense_id
        LEFT JOIN (
          SELECT
            SUM(amount) AS total_other_refund,
            car_expense_id
          FROM
            erp_car_expenses_other_refund
          GROUP BY
            car_expense_id
        ) AS other_refund ON other_refund.car_expense_id = car_expenses.car_expense_id
        GROUP BY
          car_expenses.expenses_division_id
        ) AS expenses_detial");
        $sql1 = "(
        SELECT
          SUM(
            IFNULL(car_allocate_origin, 0)
          ) AS total_income,
          expenses_division_id
        FROM
          erp_carpayments
        GROUP BY
          expenses_division_id
        ) AS car_payment";
        $data = DB::table('erp_expenses_division')
                  ->select(DB::raw("*,erp_expenses_division.expenses_division_id AS exp_division_id"))
                  ->leftjoin($sql,'expenses_detial.expenses_division_id','=','erp_expenses_division.expenses_division_id')
                  ->leftjoin(DB::raw($sql1),'car_payment.expenses_division_id','=','erp_expenses_division.expenses_division_id')
                  ->leftjoin('erp_deposit_expense AS deposit_expense','deposit_expense.deposit_expense_id','=','erp_expenses_division.deposit_expense_id')
                  ->leftjoin('erp_bank_account','erp_bank_account.bank_account_id','=','deposit_expense.bank_account_id')
                  ->whereRaw("(IFNULL(amount, 0) - IFNULL(total_car_expense, 0)) + IFNULL(total_income, 0) <> 0 AND erp_bank_account.bank_account_id <> 9")
                  ->where('expense_types','=','car')
                  ->when(!empty($whereRaw),function ($v) use ($whereRaw) {
                    $v->whereRaw($whereRaw);
                  })
                  ->orderBy('erp_expenses_division.expenses_division_id','DESC')
                  ->paginate($perPage);
                  // ->get();
        return $data;
    }

    public static function get_car_expense_with_chasiss_history($Perpage,$whereRaw){
        $sql = "(
        SELECT
          car_expenses.expenses_division_id,
          SUM(IFNULL(buying_price, 0)) + SUM(IFNULL(tax_fee, 0)) + SUM(IFNULL(auction_fee, 0)) + SUM(
            IFNULL(transportation_fee, 0)
          ) + SUM(IFNULL(recycle_fee, 0)) + SUM(IFNULL(car_tax_fee, 0)) + SUM(IFNULL(freight_fee, 0)) + SUM(IFNULL(repair_fee, 0)) + SUM(IFNULL(inspection_fee, 0)) + SUM(
            IFNULL(shipping_charge_fee, 0)
          ) + SUM(IFNULL(insurance_fee, 0)) + SUM(IFNULL(ea_fee, 0)) + SUM(IFNULL(total_other_fee, 0)) + SUM(
            IFNULL(total_other_refund, 0)
          ) AS total_car_expense,
          SUM(IFNULL(total_other_fee, 0)) AS total_other_fee,
          SUM(
            IFNULL(total_other_refund, 0)
          ) AS total_other_refund
        FROM
          erp_car_expenses AS car_expenses
        LEFT JOIN (
          SELECT
            SUM(amount) AS total_other_fee,
            car_expense_id
          FROM
            erp_car_expenses_other_fee
          GROUP BY
            car_expense_id
        ) AS other_fee ON other_fee.car_expense_id = car_expenses.car_expense_id
        LEFT JOIN (
          SELECT
            SUM(amount) AS total_other_refund,
            car_expense_id
          FROM
            erp_car_expenses_other_refund
          GROUP BY
            car_expense_id
        ) AS other_refund ON other_refund.car_expense_id = car_expenses.car_expense_id
        GROUP BY
          car_expenses.expenses_division_id
        ) AS expenses_detial";
        $sql1= "
        (
        SELECT
          SUM(
            IFNULL(car_allocate_origin, 0)
          ) AS total_income,
          expenses_division_id
        FROM
          erp_carpayments
        GROUP BY
          expenses_division_id
        ) AS car_payment";
        $data = DB::table('erp_expenses_division')
                  ->select(DB::raw("*,erp_expenses_division.expenses_division_id AS exp_division_id"))
                  ->leftjoin(DB::raw($sql),'expenses_detial.expenses_division_id','=','erp_expenses_division.expenses_division_id')
                  ->leftjoin(DB::raw($sql1),'car_payment.expenses_division_id','=','erp_expenses_division.expenses_division_id')
                  ->leftjoin('erp_deposit_expense as deposit_expense','deposit_expense.deposit_expense_id','=','erp_expenses_division.deposit_expense_id')
                  ->leftjoin('erp_bank_account','erp_bank_account.bank_account_id','=','deposit_expense.bank_account_id')
                  ->whereRaw("(IFNULL(amount, 0) - IFNULL(total_car_expense, 0)) + IFNULL(total_income, 0) = 0 AND erp_bank_account.bank_account_id <> 9")
                  ->where('expense_types','=','car')
                  ->when(!empty($whereRaw),function ($v) use ($whereRaw) {
                    $v->whereRaw($whereRaw);
                  })
                  ->orderBy('erp_expenses_division.expenses_division_id','DESC')
                  ->paginate($Perpage);
        return $data;
        
    }

    public static function get_car_data_office($Perpage,$type,$whereRaw){
        $data= DB::table('erp_expenses_division')
                 ->select('*')
                 ->leftjoin('erp_deposit_expense','erp_deposit_expense.deposit_expense_id','=','erp_expenses_division.deposit_expense_id')
                 ->leftjoin('erp_bank_account','erp_bank_account.bank_account_id','=','erp_deposit_expense.bank_account_id')
                 ->where("expense_types",'=',$type)
                 ->whereRaw("erp_bank_account.bank_account_id <> 9")
                 ->when(!empty($whereRaw),function ($v) use ($whereRaw) {
                  $v->whereRaw($whereRaw);
                })
                 ->orderBy('expenses_division_id','DESC')
                 ->paginate($Perpage);
        return $data;
    }

    public static function get_car_data_refund($Perpage,$type,$whereRaw){
        $data = DB::table('erp_expenses_division')
                  ->select('*','erp_deposit_expense.created_dt as date')
                  ->leftjoin('erp_deposit_expense','erp_deposit_expense.deposit_expense_id','=','erp_expenses_division.deposit_expense_id')
                  ->leftjoin('erp_bank_account','erp_bank_account.bank_account_id','=','erp_deposit_expense.bank_account_id')
                  ->leftjoin('erp_customer','erp_expenses_division.customer_id','=','erp_customer.customer_id')
                  ->where('expense_types','=',$type)
                  ->when(!empty($whereRaw),function ($v) use ($whereRaw) {
                    $v->whereRaw($whereRaw);
                  })
                  ->orderBy('expenses_division_id','DESC')
                  ->paginate($Perpage);
        return $data;
    }

    public static function SelectCarWithChassis($chassis_no){
      $data = DB::table('erp_stock_list')
                ->select('stock_id')
                ->where('chassis_number','=',$chassis_no)
                ->get();
      return $data;
    }

    public static function get_chassis_num($chassis){
      $data = DB::table('erp_stock_list')
                ->select(DB::raw('COUNT(*) as nums'))
                ->where('chassis_number','=',$chassis)
                ->get();
                if(COUNT($data) > 0){
                  return $data[0]->nums;
                }
      return 0;
    }

    public static function get_expense_car($chassis,$division_id){
        $data = DB::table('erp_car_expenses')
                  ->select('*')
                  ->leftjoin(DB::raw("(SELECT SUM(amount) AS other_fee_amount,car_expense_id AS car_expense_id1,currency_type AS other_fee_currency FROM erp_car_expenses_other_fee GROUP BY car_expense_id) AS other_fee"),'erp_car_expenses.car_expense_id','=','other_fee.car_expense_id1')
                  ->leftjoin(DB::raw("(SELECT SUM(amount) AS other_refund_amount,car_expense_id AS car_expense_id2 FROM erp_car_expenses_other_refund GROUP BY car_expense_id) AS other_refund"),'erp_car_expenses.car_expense_id','=','other_refund.car_expense_id2')
                  ->where('expenses_division_id','=',$division_id)
                  ->where('chassis_number','=',$chassis)
                  ->leftjoin('erp_stock_list','erp_stock_list.stock_id','=','erp_car_expenses.stock_id')
                  ->get();
        return $data;
    }

    public static function get_exchange_rate($rateWhere){
       $data = DB::table('erp_exchange_rate')
                 ->select('*')
                 ->where($rateWhere)
                 ->get();
        if(COUNT($data) > 0){
          return $data;
        }
    }

    public static function get_latest_exchange_rate($where){
      $data = DB::table('erp_exchange_rate')
                ->select('*')
                ->where($where)
                ->orderBy('id','DESC')
                ->limit(1)
                ->get();
      return $data;
    }

    public static function get_car_stock_list($stock_id){
      $data = DB::table('erp_stock_list as a')
                ->select('*')
                ->where('a.stock_id','=',$stock_id)
                ->leftjoin('erp_car_reserve as b','b.stock_id','=','a.stock_id')
                ->get();
      return $data;
    }

    public static function insert_car_payment($data_income){
       DB::table('erp_carpayments')
         ->insert($data_income);
    }

    public static function update_expense_car($where,$inData){
      DB::table('erp_car_expenses')
        ->where($where)
        ->update($inData);
    }

    public static function insert_car_expenses($data){
      $return_id = DB::table('erp_car_expenses')
                      ->insertGetId($data);
      return $return_id;
    }

    public static function erp_car_expenses_other_refund($data){
      DB::table('erp_car_expenses_other_refund')
        ->insert($data);
    }

    public static function insert_car_other_refund($data){
        DB::table('erp_car_expenses_other_refund')
          ->insert($data);
    }

    public static function update_other_refund($where,$data){
        DB::table('erp_car_expenses_other_refund')
           ->where($where)
          ->update($data);
    }

    public static function insert_other_fee($data){
        DB::table('erp_car_expenses_other_fee')
          ->insert($data);
    }

    public static function update_other_fee($where,$data){
      DB::table('erp_car_expenses_other_fee')
        ->where($where)
        ->update($data);
    }

    public static function get_car_exp($exp_id){
      $data = DB::table('erp_car_expenses')
                ->select('car_expense_id')
                ->where('expenses_division_id','=',$exp_id)
                ->get();
      return $data;
    }

    public static function get_deposit_id($exp_id){
      $data = DB::table('erp_expenses_division')
                ->select('*')
                ->where('expenses_division_id','=',$exp_id)
                ->get();
      return $data;
    }

    public static function get_current_amount($deposit_id){
       $data = DB::table('erp_deposit_expense')
                 ->select('deposit')
                 ->where('deposit_expense_id','=',$deposit_id)
                 ->get();
      return $data;
     }

     public static function update_deposit_exp_amount($up_amount, $deposit_id){
         DB::table('erp_deposit_expense')
           ->where('deposit_expense_id','=',$deposit_id)
           ->update($up_amount);
     }

     public static function remove_exp_division($where){
         DB::table('erp_expenses_division')
           ->where('expenses_division_id','=',$where)
           ->delete();
     }

     public static function get_car_expense_with_chasiss_history_excel($whereRaw){
      $sql = "(
        SELECT
          car_expenses.expenses_division_id,
          SUM(IFNULL(buying_price, 0)) + SUM(IFNULL(tax_fee, 0)) + SUM(IFNULL(auction_fee, 0)) + SUM(
            IFNULL(transportation_fee, 0)
          ) + SUM(IFNULL(recycle_fee, 0)) + SUM(IFNULL(car_tax_fee, 0)) + SUM(IFNULL(freight_fee, 0)) + SUM(IFNULL(repair_fee, 0)) + SUM(IFNULL(inspection_fee, 0)) + SUM(
            IFNULL(shipping_charge_fee, 0)
          ) + SUM(IFNULL(insurance_fee, 0)) + SUM(IFNULL(ea_fee, 0)) + SUM(IFNULL(total_other_fee, 0)) + SUM(
            IFNULL(total_other_refund, 0)
          ) AS total_car_expense,
          SUM(IFNULL(total_other_fee, 0)) AS total_other_fee,
          SUM(
            IFNULL(total_other_refund, 0)
          ) AS total_other_refund
        FROM
          erp_car_expenses AS car_expenses
        LEFT JOIN (
          SELECT
            SUM(amount) AS total_other_fee,
            car_expense_id
          FROM
            erp_car_expenses_other_fee
          GROUP BY
            car_expense_id
        ) AS other_fee ON other_fee.car_expense_id = car_expenses.car_expense_id
        LEFT JOIN (
          SELECT
            SUM(amount) AS total_other_refund,
            car_expense_id
          FROM
            erp_car_expenses_other_refund
          GROUP BY
            car_expense_id
        ) AS other_refund ON other_refund.car_expense_id = car_expenses.car_expense_id
        GROUP BY
          car_expenses.expenses_division_id
        ) AS expenses_detial";
        $sql1= "
        (
        SELECT
          SUM(
            IFNULL(car_allocate_origin, 0)
          ) AS total_income,
          expenses_division_id
        FROM
          erp_carpayments
        GROUP BY
          expenses_division_id
        ) AS car_payment";
        $data = DB::table('erp_expenses_division')
                  ->select(DB::raw("*,erp_expenses_division.expenses_division_id AS exp_division_id"))
                  ->leftjoin(DB::raw($sql),'expenses_detial.expenses_division_id','=','erp_expenses_division.expenses_division_id')
                  ->leftjoin(DB::raw($sql1),'car_payment.expenses_division_id','=','erp_expenses_division.expenses_division_id')
                  ->leftjoin('erp_deposit_expense as deposit_expense','deposit_expense.deposit_expense_id','=','erp_expenses_division.deposit_expense_id')
                  ->leftjoin('erp_bank_account','erp_bank_account.bank_account_id','=','deposit_expense.bank_account_id')
                  ->whereRaw("(IFNULL(amount, 0) - IFNULL(total_car_expense, 0)) + IFNULL(total_income, 0) = 0 AND erp_bank_account.bank_account_id <> 9")
                  ->where('expense_types','=','car')
                  ->when(!empty($whereRaw),function ($v) use ($whereRaw) {
                    $v->whereRaw($whereRaw);
                  })
                  ->orderBy('erp_expenses_division.expenses_division_id','DESC')
                   ->get();
        return $data;
     }

     public static function get_car_distribute1($type,$whereRaw){
        $sql = DB::raw("(
          SELECT
            car_expenses.expenses_division_id,
            SUM(IFNULL(buying_price, 0)) + SUM(IFNULL(tax_fee, 0)) + SUM(IFNULL(auction_fee, 0)) + SUM(
              IFNULL(transportation_fee, 0)
            ) + SUM(IFNULL(recycle_fee, 0)) + SUM(IFNULL(car_tax_fee, 0)) + SUM(IFNULL(freight_fee, 0)) + SUM(IFNULL(repair_fee, 0)) + SUM(IFNULL(inspection_fee, 0)) + SUM(
              IFNULL(shipping_charge_fee, 0)
            ) + SUM(IFNULL(insurance_fee, 0)) + SUM(IFNULL(ea_fee, 0)) + SUM(IFNULL(total_other_fee, 0)) + SUM(
              IFNULL(total_other_refund, 0)
            ) AS total_car_expense,
            SUM(IFNULL(total_other_fee, 0)) AS total_other_fee,
            SUM(
              IFNULL(total_other_refund, 0)
            ) AS total_other_refund
          FROM
            erp_car_expenses AS car_expenses
          LEFT JOIN (
            SELECT
              SUM(amount) AS total_other_fee,
              car_expense_id
            FROM
              erp_car_expenses_other_fee
            GROUP BY
              car_expense_id
          ) AS other_fee ON other_fee.car_expense_id = car_expenses.car_expense_id
          LEFT JOIN (
            SELECT
              SUM(amount) AS total_other_refund,
              car_expense_id
            FROM
              erp_car_expenses_other_refund
            GROUP BY
              car_expense_id
          ) AS other_refund ON other_refund.car_expense_id = car_expenses.car_expense_id
          GROUP BY
            car_expenses.expenses_division_id
          ) AS expenses_detial");
          $sql1 = "(
          SELECT
            SUM(
              IFNULL(car_allocate_origin, 0)
            ) AS total_income,
            expenses_division_id
          FROM
            erp_carpayments
          GROUP BY
            expenses_division_id
          ) AS car_payment";
          $data = DB::table('erp_expenses_division')
                    ->select(DB::raw("*,erp_expenses_division.expenses_division_id AS exp_division_id"))
                    ->leftjoin($sql,'expenses_detial.expenses_division_id','=','erp_expenses_division.expenses_division_id')
                    ->leftjoin(DB::raw($sql1),'car_payment.expenses_division_id','=','erp_expenses_division.expenses_division_id')
                    ->leftjoin('erp_deposit_expense AS deposit_expense','deposit_expense.deposit_expense_id','=','erp_expenses_division.deposit_expense_id')
                    ->leftjoin('erp_bank_account','erp_bank_account.bank_account_id','=','deposit_expense.bank_account_id')
                    ->whereRaw("(IFNULL(amount, 0) - IFNULL(total_car_expense, 0)) + IFNULL(total_income, 0) <> 0 AND erp_bank_account.bank_account_id <> 9")
                    ->where('expense_types','=','car')
                    ->when(!empty($whereRaw),function ($v) use ($whereRaw) {
                      $v->whereRaw($whereRaw);
                    })
                    ->orderBy('erp_expenses_division.expenses_division_id','DESC')
                    ->get();
                  return $data;
     }

     public static function get_car_data_office_excel($type,$whereRaw){
      $data= DB::table('erp_expenses_division')
               ->select('*')
               ->leftjoin('erp_deposit_expense','erp_deposit_expense.deposit_expense_id','=','erp_expenses_division.deposit_expense_id')
               ->leftjoin('erp_bank_account','erp_bank_account.bank_account_id','=','erp_deposit_expense.bank_account_id')
               ->where("expense_types",'=',$type)
               ->whereRaw("erp_bank_account.bank_account_id <> 9")
               ->when(!empty($whereRaw),function ($v) use ($whereRaw) {
                $v->whereRaw($whereRaw);
              })
               ->orderBy('expenses_division_id','DESC')
               ->get();
      return $data;
  }

  public static function get_car_data_refund_excel($type,$whereRaw){
    $data = DB::table('erp_expenses_division')
              ->select('*','erp_deposit_expense.created_dt as date')
              ->leftjoin('erp_deposit_expense','erp_deposit_expense.deposit_expense_id','=','erp_expenses_division.deposit_expense_id')
              ->leftjoin('erp_bank_account','erp_bank_account.bank_account_id','=','erp_deposit_expense.bank_account_id')
              ->leftjoin('erp_customer','erp_expenses_division.customer_id','=','erp_customer.customer_id')
              ->where('expense_types','=',$type)
              ->when(!empty($whereRaw),function ($v) use ($whereRaw) {
                $v->whereRaw($whereRaw);
              })
              ->orderBy('expenses_division_id','DESC')
              ->get();
    return $data;
}

    



}
