<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
class Income_model extends Model
{
    use HasFactory;
   
    public static function get_total_cost($stock_id){
        $other_fee_tbl = " SELECT car_expense_id, SUM(amount) AS total_other_fee FROM erp_car_expenses_other_fee GROUP BY car_expense_id ";
        $other_refund_tbl = " SELECT car_expense_id,SUM(amount) AS total_other_refund FROM erp_car_expenses_other_refund GROUP BY car_expense_id ";
        $data = DB::table('erp_car_expenses AS car_ex')
                ->select('*')
                ->leftjoin(DB::raw('('.$other_fee_tbl.') AS other_fee'),'other_fee.car_expense_id','=','car_ex.car_expense_id')
                ->leftjoin(db::RAW('('.$other_refund_tbl.') AS other_refund'),'other_refund.car_expense_id','=','car_ex.car_expense_id')
                ->where('stock_id','=',$stock_id)
                ->get();
        return $data;
    }
    public static function get_total_allocate($stock_id){
        $data = DB::table('erp_carpayments')
                ->select('*')
                ->where('stock_id','=',$stock_id)
                ->get();
        return $data;
    }
    public static function get_car_status_info($stock_id){
        $select = "status,purpose,dhl_number,customer_id,etd,erp_stock_list.shipment_id";
        $data= DB::table('erp_stock_list')
               ->select(DB::raw($select))
               ->leftjoin('erp_shipments','erp_stock_list.shipment_id','=','erp_shipments.shipment_id')
               ->where('stock_id','=',$stock_id)
               ->get();
        return $data;
    }
    public static function update_car_profit($stock,$data){
       DB::table('erp_stock_list')
         ->where('stock_id','=',$stock)
         ->update($data);
    }

    public static function get_all_amount_customer_allocate($stock_id){
        $select = "SUM(car_allocate) AS car_allocate,car_allocate_currency,stock_id";
        $data = DB::table('erp_carpayments AS a')
                  ->select(DB::raw($select))
                  ->leftjoin('erp_customer_deposit AS b','a.customer_deposit_id','=','b.customer_deposit_id')
                  ->where('stock_id','=',$stock_id)
                  ->where('b.customer_deposit_type','=','b.customer_deposit_type')
                  ->groupBy('stock_id')
                  ->get();
                  
        return $data;
    }

    public static function get_total_sell_price_from_stock($stock_id){
        $select = "((IFNULL(fob,0) + IFNULL(freight_fee,0) + IFNULL(inspection,0) + IFNULL(inspection,0) + IFNULL(vanning,0) + IFNULL(other_fee,0)+ IFNULL(insurance,0)) - IFNULL(discount,0)) AS selling_price,currency,stock_id";
        $data = DB::table('erp_car_reserve')
                  ->select(DB::raw($select))
                  ->where('stock_id','=',$stock_id)
                  ->orderBy('reserve_id','DESC')
                  ->limit(1)
                  ->get();
        return $data;
    }

    public static function get_ship_ok_condition($cus_id){
       $data = DB::table('erp_customer')
                  ->select('payment_terms')
                  ->where('customer_id','=',$cus_id)
                  ->get();
        return $data;
    }

    public static function update_car_data($arr_data,$stock_id){
        DB::table('erp_stock_list')
        ->where('stock_id','=',$stock_id)
        ->update($arr_data);
    }

    public static function add_history_car($status_arr){
         DB::table('erp_cars_status_history')
           ->insert($status_arr);
    }

    public static function income_deposit($hide_pakistan,$perpage,$txt_search_date,$txt_search_left,$txt_search_to_date){
        $show =   array('14','15');
        $sql = "(SELECT SUM(deposit_amount) as total_deposit,deposit_income_id FROM erp_customer_deposit GROUP BY deposit_income_id)  AS cus_dep";
        $data = DB::table('erp_deposit_income')
                  ->select(DB::raw("erp_deposit_income.deposit_income_id,deposit_raw,description,deposit_amount,bank_full_name,deposit_currency,erp_deposit_income.bank_account_id,deposit_date,(IFNULL(deposit_raw, 0) - IFNULL(total_deposit, 0)) AS total_balance"))
                  ->leftjoin('erp_bank_account','erp_deposit_income.bank_account_id','=','erp_bank_account.bank_account_id')
                  ->leftjoin(DB::raw($sql),'cus_dep.deposit_income_id','=','erp_deposit_income.deposit_income_id')
                  ->whereRaw("IFNULL(deposit_raw, 0) - IFNULL(total_deposit, 0) > 0")
                  ->whereRaw("description <> 'begin-initiailize-bank-09-30'")
                  ->when(!empty($txt_search_left),function ($v) use ($txt_search_left) {
                    $v->whereRaw("description LIKE '%".$txt_search_left."%'");
                  })
                  ->when(!empty($txt_search_date),function ($v) use ($txt_search_date) {
                    $v->whereRaw("date(deposit_date)>='".$txt_search_date."'");
                  })
                  ->when(!empty($txt_search_to_date),function ($v) use ($txt_search_to_date) {
                    $v->whereRaw("date(deposit_date)<='".$txt_search_to_date."'");
                  })
                  ->when(!empty($hide_pakistan),function ($v) use ($show) {
                    $v->whereIn(DB::raw('erp_deposit_income.bank_account_id'),$show);
                  })
                  ->orderBy('deposit_date','DESC')
                  ->paginate($perpage);
        return $data;
    }

    public static function income_deposit_history($hide_pakistan,$perpage,$txt_search_date,$txt_search_left,$txt_search_to_date){
        $show =   array('14','15');
        $sql = "(SELECT SUM(deposit_amount) as total_deposit,deposit_income_id FROM erp_customer_deposit GROUP BY deposit_income_id) AS cus_dep";
        $data = DB::table('erp_deposit_income')
                  ->select(DB::raw("erp_deposit_income.deposit_income_id,deposit_raw,description,deposit_amount,bank_full_name,deposit_currency,erp_deposit_income.bank_account_id,deposit_date"))
                  ->leftjoin('erp_bank_account','erp_deposit_income.bank_account_id','=','erp_bank_account.bank_account_id')
                  ->leftjoin(DB::raw($sql),'cus_dep.deposit_income_id','=','erp_deposit_income.deposit_income_id')
                  ->whereRaw("IFNULL(deposit_raw, 0) - IFNULL(total_deposit, 0) <= 0")
                  ->whereRaw("description <> 'begin-initiailize-bank-09-30'")
                  ->when(!empty($txt_search_left),function ($v) use ($txt_search_left) {
                    $v->whereRaw("description LIKE '%".$txt_search_left."%'");
                  })
                  ->when(!empty($txt_search_date),function ($v) use ($txt_search_date) {
                    $v->whereRaw("date(deposit_date)>='".$txt_search_date."'");
                  })
                  ->when(!empty($txt_search_to_date),function ($v) use ($txt_search_to_date) {
                    $v->whereRaw("date(deposit_date)<='".$txt_search_to_date."'");
                  })
                  ->when(!empty($hide_pakistan),function ($v) use ($show) {
                    $v->whereIn(DB::raw('erp_deposit_income.bank_account_id'),$show);
                  })
                  ->orderBy('deposit_date','DESC')
                  ->paginate($perpage);
        return $data;
    }

    public static function get_deposit_income_by_id($deposit_id){
        $sql = "(SELECT SUM(deposit_amount) as total_deposit,deposit_income_id FROM erp_customer_deposit GROUP BY deposit_income_id) AS cus_dep";
        $data = DB::table('erp_deposit_income')
                  ->select(DB::raw("erp_deposit_income.deposit_income_id,deposit_raw,description,deposit_amount,bank_full_name,deposit_currency,erp_deposit_income.bank_account_id,deposit_date,(IFNULL(deposit_raw, 0) - IFNULL(total_deposit, 0)) AS total_balance"))
                  ->leftjoin('erp_bank_account','erp_deposit_income.bank_account_id','=','erp_bank_account.bank_account_id')
                  ->leftjoin(DB::raw($sql),'cus_dep.deposit_income_id','=','erp_deposit_income.deposit_income_id')
                  ->whereRaw("IFNULL(deposit_raw, 0) - IFNULL(total_deposit, 0) > 0")
                  ->whereRaw("description <> 'begin-initiailize-bank-09-30'")
                  ->where('erp_deposit_income.deposit_income_id','=',$deposit_id)
                  ->get();
                 
        return $data;
    }

    public static function get_customer_info(){
        $data = DB::table('erp_customer')
                  ->select('*')
                  ->whereRaw("active <>'0'")
                  ->whereRaw("full_name <> ''")
                  ->orderBy('full_name','ASC')
                  ->get();
        return $data;
    }

    public static function get_customer_info_by_search($search_condition,$customer_name,$show){
        $data = DB::table('erp_customer')
                  ->select('*')
                  ->when($search_condition == 'customer_name', function ($v) use ($customer_name) {
                    $v->whereRaw("full_name LIKE'%".$customer_name."%'");
                  })
                  ->when($search_condition == 'customer_email',function ($v) use ($customer_name) {
                    $v->whereRaw("email1 LIKE'%".$customer_name."%'",);
                  })
                  ->when($search_condition == 'customer_id',function ($v) use ($customer_name) {
                    $v->whereRaw("$customer_name LIKE'%".$customer_name."%'");
                  })
                  ->when(!empty($show),function ($v) use ($show) {
                    $v->whereIn(DB::raw('country_list_id'),$show);
                  })
                  ->whereRaw("active <>'0'")
                  ->whereRaw("full_name <> ''")
                  ->orderBy('full_name','ASC')
                  ->get();
                //   dd($data);
        return $data;
    }


    public static function check_amount_distribute($distype,$dep_id,$dep_cur,$dep_date,$amount,$cus_id,$user_id){
      $data = DB::table('erp_customer_deposit')
                ->select('*')
                ->where('customer_deposit_type','=',$distype)
                ->where('deposit_income_id',$dep_id)
                ->where('customer_deposit_currency','=',$dep_cur)
                ->whereRaw("DATE(create_date) = '".$dep_date."'")
                ->where('deposit_amount','=',$amount)
                ->where('customer_id','=',$cus_id)
                ->where('author_id','=',$user_id)
                ->get();
      return $data;
    }

    public static function check_amount_distribute_other($distype,$dep_id,$dep_cur,$dep_date,$amount,$user_id){
      $data = DB::table('erp_customer_deposit')
                ->select('*')
                ->where('customer_deposit_type','=',$distype)
                ->where('deposit_income_id',$dep_id)
                ->where('customer_deposit_currency','=',$dep_cur)
                ->whereRaw("DATE(create_date) = '".$dep_date."'")
                ->where('deposit_amount','=',$amount)
                ->where('author_id','=',$user_id)
                ->get();
      return $data;
    }

    public static function insert_data_customer_deposit($data_insert){
      DB::table('erp_customer_deposit')
         ->insert($data_insert);
    }

    public static function get_deposit_info_by_id($deposit_income_id){
        $data = DB::table('erp_customer_deposit AS dep')
                  ->select(DB::raw("customer_deposit_id,deposit_amount,customer_deposit_currency,customer_deposit_type,dep.create_date,full_name"))
                  ->leftjoin('erp_customer AS cus','dep.customer_id','=','cus.customer_id')
                  ->where('deposit_income_id','=',$deposit_income_id)
                  ->get();
        return $data;
    }
    public static function get_car_info_customer_id($customer_deposit_id){
      $data = DB::table('erp_carpayments AS car_pay')
                ->select(DB::raw("car_pay.stock_id,chassis_number,SUM(car_allocate_origin) AS car_allocate_origin,car_allocate_origin_currency,full_name,car_pay.create_date,car_pay.car_payment_id"))
                ->leftjoin('erp_stock_list AS stock','stock.stock_id','=','car_pay.stock_id')
                ->leftjoin('erp_staff AS staff','staff.staff_id','=','car_pay.author_id')
                ->where('car_pay.customer_deposit_id','=',$customer_deposit_id)
                ->groupBy('car_pay.stock_id')
                ->get();
      return $data;
    }

    public static function getStockIdByCarpaymentId($pay_id){
      $data= DB::table('erp_carpayments')
               ->select('stock_id')
               ->where('car_payment_id','=',$pay_id)
               ->get();
               if(Count($data)>0){
                return $data[0]->stock_id;
               }
      return ;
    }

    public static function get_customer_id_by_dep_ids($cus_dep_id){
      $data = DB::table('erp_customer_deposit')
                ->select('*')
                ->where('customer_deposit_id','=',$cus_dep_id)
                ->get();
      return $data;
    }

    public static function get_deposit_info( $customer_deposit_id){
      $data = DB::table('erp_customer_deposit')
                ->select("*")
                ->where('customer_deposit_id','=',$customer_deposit_id)
                ->get();
      return $data;
    }

    public static function income_deposit_history_excel($hide_pakistan,$txt_search_left,$txt_search_date,$txt_search_to_date){
      $show =   array('14','15');
      $sql = "(SELECT SUM(deposit_amount) as total_deposit,deposit_income_id FROM erp_customer_deposit GROUP BY deposit_income_id) AS cus_dep";
      $data = DB::table('erp_deposit_income')
                ->select(DB::raw("erp_deposit_income.deposit_income_id,deposit_raw,description,deposit_amount,bank_full_name,deposit_currency,erp_deposit_income.bank_account_id,deposit_date"))
                ->leftjoin("erp_bank_account","erp_deposit_income.deposit_income_id",'=',"erp_bank_account.bank_account_id")
                ->leftjoin(DB::raw($sql),'cus_dep.deposit_income_id','=','erp_deposit_income.deposit_income_id')
                ->whereRaw("IFNULL(deposit_raw, 0) - IFNULL(total_deposit, 0) <= 0")
                ->whereRaw("description <> 'begin-initiailize-bank-09-30'")
                ->when(!empty($txt_search_left),function ($v) use ($txt_search_left) {
                  $v->whereRaw("description LIKE '%".$txt_search_left."%'");
                })
                ->when(!empty($txt_search_date),function ($v) use ($txt_search_date) {
                  $v->whereRaw("date(deposit_date)>='".$txt_search_date."'");
                })
                ->when(!empty($txt_search_to_date),function ($v) use ($txt_search_to_date) {
                  $v->whereRaw("date(deposit_date)<='".$txt_search_to_date."'");
                })
                ->when(!empty($hide_pakistan),function ($v) use ($show) {
                  $v->whereIn(DB::raw('erp_deposit_income.bank_account_id'),$show);
                })
                ->orderBy('deposit_date','DESC')
                ->get();
      return $data;
    }

    public static function get_data_check_type($id){
      $data= DB::table('erp_customer_deposit')
               ->select('*')
               ->where('deposit_income_id','=',$id)
               ->get();
      return $data;
    }

    public static function get_car_info_for_excel($id){
       $data = DB::table('erp_carpayments AS car_pay')
                 ->select(DB::raw("chassis_number,car_allocate_origin,car_allocate_origin_currency,etd"))
                 ->leftjoin("erp_stock_list AS stock",'stock.stock_id','=',"car_pay.stock_id")
                 ->leftjoin("erp_shipments AS shipment","shipment.shipment_id",'=',"stock.shipment_id")
                 ->where("car_pay.customer_deposit_id",'=',$id)
                 ->get();
        return $data;
    }

    public static function customer_deposit($hide_pakistan,$perPage,$cus_name,$date_dep){
      $show =   array('14','15');
      $sql_select_pay = "( SELECT SUM(IFNULL(car_allocate_origin, 0)) AS total_allocate,car_allocate_origin_currency,customer_deposit_id FROM erp_carpayments WHERE payment_type = 'customer_deposit' OR payment_type = 'refund' GROUP BY customer_deposit_id ) AS car_pay";
      $data = DB::table('erp_customer_deposit AS cus_dep')
                ->select(DB::raw("cus_dep.customer_deposit_id,cus_dep.deposit_income_id,cus_dep.customer_id,cus_dep.deposit_amount,cus_dep.create_date,car_pay.car_allocate_origin_currency,IFNULL(total_allocate, 0) AS total_allocate,cus.full_name,cus_dep.customer_deposit_currency AS cur_type,bank_full_name,dep.deposit_tt_att"))
                ->leftjoin(DB::raw($sql_select_pay), 'cus_dep.customer_deposit_id','=','car_pay.customer_deposit_id')
                ->leftjoin('erp_customer AS cus','cus.customer_id','=','cus_dep.customer_id')
                ->leftjoin('erp_deposit_income as dep','dep.deposit_income_id','=','cus_dep.deposit_income_id')
                ->leftjoin('erp_bank_account as bank','bank.bank_account_id','=','dep.bank_account_id')
                ->whereRaw("cus_dep.customer_deposit_type = 'customer_deposit' AND IFNULL(cus_dep.deposit_amount, 0) - IFNULL(total_allocate, 0) > 0")
                ->when(!empty($date_dep),function ($v) use ($date_dep) {
                  $v->whereRaw("date(dep.deposit_date)='".$date_dep."'");
                })
                ->when(!empty($cus_name),function ($v) use ($cus_name) {
                  $v->whereRaw("cus.full_name LIKE '".$cus_name."'");
                })
                ->when(!empty($hide_pakistan),function ($v) use ($show) {
                  $v->whereIn(DB::raw('erp_deposit_income.bank_account_id'),$show);
                })
                ->orderBy('cus_dep.create_date','DESC')
                ->paginate($perPage);
      return $data;
    }

    public static function get_customer_history_list($hide_pakistan,$perPage,$cus_name,$date_dep){
       $show =   array('14','15');
        $data = DB::table('erp_customer_deposit AS dep')
                  ->select(DB::raw("dep.customer_deposit_id,dep.deposit_amount,dep.customer_deposit_currency,dep.customer_deposit_type,dep.create_date,full_name,depincom.deposit_date,bank.bank_name"))
                  ->leftjoin('erp_customer AS cus','dep.customer_id','=','cus.customer_id')
                  ->leftjoin('erp_deposit_income as depincom','dep.deposit_income_id','=','depincom.deposit_income_id')
                  ->leftjoin('erp_bank_account AS bank','depincom.bank_account_id','=','bank.bank_account_id')
                  ->where('customer_deposit_type','=',"customer_deposit")
                  ->when(!empty($date_dep),function ($v) use ($date_dep) {
                    $v->whereRaw("date(depincom.deposit_date)='".$date_dep."'");
                  })
                  ->when(!empty($cus_name),function ($v) use ($cus_name) {
                    $v->whereRaw("cus.full_name LIKE '%".$cus_name."%'");
                  })
                  ->when(!empty($hide_pakistan),function ($v) use ($show) {
                    $v->whereIn(DB::raw('depincom.bank_account_id'),$show);
                  })
                  ->orderBy('depincom.deposit_date','DESC')
                  ->paginate($perPage);
                
      return $data;
    }

    public static function customer_with_chassis($hide_pakistan,$perPage,$date_dep){
      $show =   array('14','15');
      $sql_select_pay = "( SELECT SUM(IFNULL(car_allocate, 0)) AS total_allocate,car_allocate_currency,customer_deposit_id FROM erp_carpayments GROUP BY customer_deposit_id )  AS car_pay";
      $data = DB::table('erp_customer_deposit AS cus_dep')
                ->select(DB::raw("cus_dep.customer_deposit_id,cus_dep.deposit_income_id,cus_dep.customer_id,cus_dep.deposit_amount,cus_dep.create_date,car_pay.car_allocate_currency,IFNULL(total_allocate, 0) AS total_allocate,cus.full_name,cus_dep.customer_deposit_currency AS cur_type,bank_name,description,deposit_date"))
                ->leftjoin(DB::raw($sql_select_pay),'cus_dep.customer_deposit_id','=','car_pay.customer_deposit_id')
                ->leftjoin('erp_customer AS cus','cus.customer_id','=','cus_dep.customer_id')
                ->leftjoin('erp_deposit_income AS dep','dep.deposit_income_id','=','cus_dep.deposit_income_id')
                ->leftjoin('erp_bank_account AS bank','bank.bank_account_id','=','dep.bank_account_id')
                ->whereRaw("cus_dep.customer_deposit_type = 'with_chassis' AND IFNULL(cus_dep.deposit_amount, 0) - IFNULL(total_allocate, 0) > 0")
                ->when(!empty($date_dep),function ($v) use ($date_dep) {
                  $v->whereRaw("date(depincom.deposit_date)='".$date_dep."'");
                })
                ->when(!empty($hide_pakistan),function ($v) use ($show) {
                  $v->whereIn(DB::raw('depincom.bank_account_id'),$show);
                })
                ->orderBy('cus_dep.create_date','DESC')
                ->paginate($perPage);
      return $data;

    }

    public static function get_customer_deposit_by_id($cus_id){
      $data = DB::table('erp_customer_deposit')
                ->select('*')
                ->where('customer_deposit_id','=',$cus_id)
                ->get();
      return $data;
    }

    public static function get_customer_dep_info($cus_dep_id){
      $sql_select_pay = "( SELECT SUM(car_allocate_origin) AS sum_allocate,customer_deposit_id FROM erp_carpayments GROUP BY customer_deposit_id) AS car_pay";
      $data = DB::table('erp_customer_deposit as cus_dep')
                ->select(DB::raw("SUM(IFNULL(cus_dep.deposit_amount,0) - IFNULL(sum_allocate,0)) AS balance,customer_id,customer_deposit_currency,cus_dep.customer_deposit_id,create_date,deposit_date"))
                ->leftjoin(DB::raw($sql_select_pay), 'car_pay.customer_deposit_id','=','cus_dep.customer_deposit_id')
                ->leftjoin('erp_deposit_income as dep','dep.deposit_income_id','=','cus_dep.deposit_income_id')
                ->where('cus_dep.customer_deposit_id','=',$cus_dep_id)
                ->get();
      return $data;
    }

    public static function get_all_car_by_cus_id($customer_id){
      $sql = "(SELECT SUM(car_allocate) AS car_allocate,SUM(IF(car_allocate_origin_currency='USD', car_allocate_origin, 0)) AS sumusd,SUM(IF( car_allocate_origin_currency ='JPY', car_allocate_origin, 0)) AS sumjpy,car_allocate_currency,stock_id FROM erp_carpayments x LEFT JOIN erp_customer_deposit z ON x.customer_deposit_id = z.customer_deposit_id WHERE z.customer_deposit_type = 'customer_deposit' GROUP BY stock_id) AS pay";
      $sql1 = "(SELECT (IFNULL(res.fob,0) + IFNULL(res.freight_fee,0) + IFNULL(res.insurance,0) + IFNULL(res.inspection,0)+ IFNULL( res.vanning, 0 ) + IFNULL(res.other_fee, 0) - IFNULL( res.discount, 0 )) AS total_sold_price,res.created_dt,res.stock_id, res.currency FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res GROUP BY res.stock_id) AS sold";
      $data = DB::table('erp_stock_list as a')
                 ->select(DB::raw("a.stock_id,a.chassis_number,car_model_name,sold.total_sold_price,sold.currency,pay.car_allocate,pay.car_allocate_currency"))
                 ->leftjoin("erp_car_make as f",'f.car_make_id','=','a.car_make_id')
                 ->leftjoin("erp_car_model as gg","gg.car_model_id",'=','a.car_model_id')
                 ->leftjoin(DB::raw($sql),'pay.stock_id','=','a.stock_id')
                 ->leftjoin(DB::raw($sql1),'sold.stock_id','=','a.stock_id')
                 ->where("customer_id",'=',$customer_id)
                 ->whereRaw('a.status < 9')
                 ->get();
                //  dd($data);
      return $data;
    }

    public static function get_car_info_by_cus_id($cus_Depid,$search_word){
      $sql = "(SELECT SUM(car_allocate) AS car_allocate,SUM(IF(car_allocate_origin_currency='USD', car_allocate_origin, 0)) AS sumusd,SUM(IF( car_allocate_origin_currency ='JPY', car_allocate_origin, 0)) AS sumjpy,car_allocate_currency,stock_id FROM erp_carpayments x LEFT JOIN erp_customer_deposit z ON x.customer_deposit_id = z.customer_deposit_id WHERE z.customer_deposit_type = 'customer_deposit' GROUP BY stock_id) AS pay";
      $sql1 = "(SELECT (IFNULL(res.fob,0) + IFNULL(res.freight_fee,0) + IFNULL(res.insurance,0) + IFNULL(res.inspection,0)+ IFNULL( res.vanning, 0 ) + IFNULL(res.other_fee, 0) - IFNULL( res.discount, 0 )) AS total_sold_price,res.created_dt,res.stock_id, res.currency FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res GROUP BY res.stock_id) AS sold";
      $data = DB::table('erp_stock_list as a')
                 ->select(DB::raw("a.stock_id,a.chassis_number,car_model_name,sold.total_sold_price,sold.currency,pay.car_allocate,pay.car_allocate_currency"))
                 ->leftjoin("erp_car_make as f",'f.car_make_id','=','a.car_make_id')
                 ->leftjoin("erp_car_model as gg","gg.car_model_id",'=','a.car_model_id')
                 ->leftjoin(DB::raw($sql),'pay.stock_id','=','a.stock_id')
                 ->leftjoin(DB::raw($sql1),'sold.stock_id','=','a.stock_id')
                 ->when(!empty($search_word),function ($v) use ($search_word) {
                  $v->whereRaw("a.chassis_number LIKE '%".$search_word."%'");
                })
                 ->where("a.customer_id",'=',$cus_Depid)
                 ->whereRaw('a.status < 9')
                 ->get();
                 
      return  $data;
    }

    public static function get_car_info_by_stock_id($stock_id){
        $data = DB::table('erp_car_reserve')
                  ->select("*")
                  ->where('stock_id','=',$stock_id)
                  ->orderBy("reserve_id",'DESC')
                  ->limit(1)
                  ->get();
        return $data;
    }

    public static function get_exchange_rate($where=array()){
        $data= DB::table('erp_exchange_rate')
                 ->select('*')
                 ->when(!empty($where),function ($v) use ($where) {
                  $v->where($where);
                })
                ->get();
        return $data;
    }

    public static function check_allocate_duble($con){
       $data = DB::table('erp_carpayments')
                 ->select('*')
                 ->where('stock_id','=',$con['stock_id'])
                 ->where('customer_deposit_id','=',$con['customer_deposit_id'])
                 ->where('car_allocate_currency','=',$con['car_allocate_currency'])
                 ->where('car_allocate_origin','=',$con['car_allocate_origin'])
                 ->where('car_allocate_origin_currency','=',$con['car_allocate_origin_currency'])
                 ->where('payment_type','=',$con['payment_type'])
                 ->whereRaw('DATE(create_date) = '.date("Y-m-d").'')
                 ->where('author_id','=',$con['author_id'])
                ->get();
      return $data;
    }

    public static function insert_car_payment_data($data){
        DB::table('erp_carpayments')
          ->insert($data);
    }

    public static function get_customer_info_cus_dep_id($cus_id){
      $data = DB::table('erp_customer_deposit')
                ->select('*')
                ->where('customer_deposit_id','=',$cus_id)
                ->get();
      return $data;
    }

    public static function getStatusChassis($chassis_no){
      $data = DB::table('erp_stock_list')
                ->select(DB::raw('COUNT(*) AS num'))
                ->whereRaw("LOWER(chassis_number) = '".strtolower(strval($chassis_no))."'")
                ->get();
      foreach($data as $val){
        return $val->num;
      }
      return 0;
    }

    public static function getDataDepositIncomeById($deposit_income_id){
      $data = DB::table('erp_deposit_income')
                ->select('deposit_date')
                ->where('deposit_income_id','=',$deposit_income_id)
                ->get();
      return $data;
    }

    public static function getExchangeRateByDate($date,$fromCurrency,$toCurrency){
      $data = DB::table('erp_exchange_rate')
                ->select('*')
                ->where('created_dt','=',date('Y-m-d', strtotime($date)))
                ->where('from_currency','=',$fromCurrency)
                ->where('to_currency','=',$toCurrency)
                ->get();
      return $data;
    }

    public static function get_stock_id_by_chassis($chassis){
      $data = DB::table('erp_stock_list')
                ->select('stock_id')
                ->where('chassis_number','=',$chassis)
                ->get();
      if(COUNT($data) > 0){
         return $data[0]->stock_id;
      }
      return;
    }

    public static function insert_withchassis($data){
      DB::table('erp_carpayments')
        ->insert($data);
    }

    public static function insert_car_expense($data){
      DB::table('erp_car_expenses')
        ->insert($data);
    }

    public static function get_last_car_expense_id(){
      $data = DB::table('erp_car_expenses')
                ->select('car_expense_id')
                ->orderBy('car_expense_id','DESC')
                ->limit(1)
                ->get();
      if(COUNT($data) > 0){
        return $data[0]->car_expense_id;
      }
      return;
    }

    public static function insert_car_expense_other_refund($data){
      DB::table('erp_car_expenses_other_refund')
         ->insert($data);
    }

    public static function insert_car_expense_other_fee($data){
      DB::table('erp_car_expenses_other_fee')
        ->insert($data);
    } 

    public static function customer_with_chassis_history($hide_pakistan,$perPage,$date_dep){
      $show =   array('14','15');
      $sql_select_pay = "( SELECT SUM(IFNULL(car_allocate, 0)) AS total_allocate,car_allocate_currency,customer_deposit_id FROM erp_carpayments GROUP BY customer_deposit_id ) AS car_pay";
      $data = DB::table('erp_customer_deposit AS cus_dep')
                ->select(DB::raw("cus_dep.customer_deposit_id,cus_dep.deposit_income_id,cus_dep.customer_id,cus_dep.deposit_amount,cus_dep.create_date,car_pay.car_allocate_currency,IFNULL(total_allocate, 0) AS total_allocate,cus.full_name,cus_dep.customer_deposit_currency AS cur_type,bank_name,description,deposit_date"))
                ->leftjoin(DB::raw($sql_select_pay),'cus_dep.deposit_income_id','=','car_pay.customer_deposit_id')
                ->leftjoin('erp_customer as cus','cus.customer_id','=','cus_dep.customer_id')
                ->leftjoin('erp_deposit_income as dep','dep.deposit_income_id','=','cus_dep.deposit_income_id')
                ->leftjoin('erp_bank_account as bank','bank.bank_account_id','=','dep.bank_account_id')
                ->whereRaw("cus_dep.customer_deposit_type = 'with_chassis' AND IFNULL(cus_dep.deposit_amount, 0) - IFNULL(total_allocate, 0) <= 0")
                ->when(!empty($date_dep),function ($v) use ($date_dep) {
                  $v->whereRaw("date(dep.deposit_date)='".$date_dep."'");
                })
                ->when(!empty($hide_pakistan),function ($v) use ($show) {
                  $v->whereIn(DB::raw('dep.bank_account_id'),$show);
                })
                ->orderBy('cus_dep.create_date','DESC')
                // ->get();
                ->paginate($perPage);
                // dd($data );
      return $data;
    }

    public static function get_income_car_cus_dep_id($cus_id){
       $data = DB::table('erp_carpayments')
                 ->select('*')
                 ->leftjoin('erp_stock_list','erp_stock_list.stock_id','=','erp_carpayments.stock_id')
                 ->where("customer_deposit_id",'=',$cus_id)
                 ->get();
      return $data;
    }
   public static function get_expense_car_cus_dep_id($cus_id){
    $data = DB::table('erp_car_expenses')
              ->select('*')
              ->leftjoin('erp_stock_list','erp_stock_list.stock_id','=','erp_car_expenses.stock_id')
              ->where('customer_deposit_id','=',$cus_id)
              ->get();
    return $data;
   } 
   
   public static function return_money_dep_with_cha($arr_update_dep, $deposit_id){
     DB::table('erp_deposit_income')
       ->where('deposit_income_id','=',$deposit_id)
       ->update($arr_update_dep);
   }

   public static function delete_money_car_payment_with_cha($customer_id){
    DB::table('erp_carpayments')
      ->where('customer_deposit_id','=',$customer_id)
      ->delete();
   }

   public static function return_money_cus_with_cha($where){
    DB::table('erp_customer_deposit')
      ->where($where)
      ->delete();
   }

   public static function customer_without_chassis($hide_pakistan,$perPage,$date_dep){
    $show =   array('14','15');
    $data = DB::table('erp_customer_deposit')
              ->select(DB::raw("erp_customer_deposit.deposit_income_id,customer_deposit_id,description,erp_customer_deposit.deposit_amount,customer_deposit_currency,erp_deposit_income.deposit_date,bank_name"))
              ->leftjoin('erp_customer','erp_customer.customer_id','=','erp_customer_deposit.customer_id')
              ->leftjoin('erp_deposit_income','erp_deposit_income.deposit_income_id','=','erp_customer_deposit.deposit_income_id')
              ->leftjoin('erp_bank_account','erp_deposit_income.bank_account_id','=','erp_bank_account.bank_account_id')
              ->whereRaw("customer_deposit_type = 'without_chassis'")
              ->when(!empty($date_dep),function ($v) use ($date_dep) {
                $v->whereRaw("date(erp_deposit_income.deposit_date)='".$date_dep."'");
              })
              ->when(!empty($hide_pakistan),function ($v) use ($show) {
                $v->whereIn(DB::raw('erp_deposit_income.bank_account_id'),$show);
              })
              ->orderBy('erp_customer_deposit.create_date','DESC')
              ->paginate($perPage);
    return $data;
   }

   public static function get_customer_auction($hide_pakistan,$perPage,$cus_name,$date_dep){
    $show =   array('14','15');
    $sql_select_pay = "( SELECT SUM(IFNULL(car_allocate_origin, 0)) AS total_allocate,car_allocate_origin_currency,customer_deposit_id FROM erp_carpayments WHERE payment_type = 'customer_deposit' OR payment_type = 'refund' GROUP BY customer_deposit_id ) AS car_pay";
    $data = DB::table('erp_customer_deposit AS cus_dep')
              ->select(DB::raw("cus_dep.customer_deposit_id,cus_dep.deposit_income_id,cus_dep.customer_id,cus_dep.deposit_amount,cus_dep.create_date,dep.deposit_date,car_pay.car_allocate_origin_currency,IFNULL(total_allocate, 0) AS total_allocate,cus.full_name,cus_dep.customer_deposit_currency AS cur_type,bank_full_name,dep.deposit_tt_att"))
              ->leftjoin(DB::raw($sql_select_pay),'cus_dep.customer_deposit_id','=','car_pay.customer_deposit_id')
              ->leftjoin('erp_customer AS cus','cus.customer_id','=','cus_dep.customer_id')
              ->leftjoin('erp_deposit_income AS dep','dep.deposit_income_id','=','cus_dep.deposit_income_id')
              ->leftjoin('erp_bank_account AS bank','bank.bank_account_id','=','dep.bank_account_id')
              ->whereRaw("cus_dep.customer_deposit_type = 'customer_auction_deposit' AND IFNULL(cus_dep.deposit_amount, 0) - IFNULL(total_allocate, 0) > 0")
              ->when(!empty($cus_name),function ($v) use ($cus_name) {
                $v->where("cus.full_name LIKE'%".$cus_name."%'");
              })
              ->when(!empty($date_dep),function ($v) use ($date_dep) {
                $v->whereRaw("date(dep.deposit_date)='".$date_dep."'");
              })
              ->when(!empty($hide_pakistan),function ($v) use ($show) {
                $v->whereIn(DB::raw('dep.bank_account_id'),$show);
              })
              ->orderBy('cus_dep.create_date', "DESC")
              ->paginate($perPage);
    return $data;
   }

   public static function customer_furikae($hide_pakistan,$perPage,$date_dep){
    $show =   array('14','15');
    $data = DB::table('erp_customer_deposit')
              ->select(DB::raw("erp_customer_deposit.deposit_income_id,customer_deposit_id,description,erp_customer_deposit.deposit_amount,customer_deposit_currency,erp_deposit_income.deposit_date,bank_name"))
              ->leftjoin("erp_customer",'erp_customer.customer_id','=','erp_customer_deposit.customer_id')
              ->leftjoin("erp_deposit_income",'erp_deposit_income.deposit_income_id','=','erp_customer_deposit.deposit_income_id')
              ->leftjoin("erp_bank_account",'erp_deposit_income.bank_account_id','=','erp_bank_account.bank_account_id')
              ->whereRaw("customer_deposit_type = 'furikae'")
              ->when(!empty($date_dep),function ($v) use ($date_dep) {
                $v->whereRaw("date(erp_deposit_income.deposit_date)='".$date_dep."'");
              })
              ->when(!empty($hide_pakistan),function ($v) use ($show) {
                $v->whereIn(DB::raw('erp_deposit_income.bank_account_id'),$show);
              })
              ->orderBy('erp_customer_deposit.create_date','DESC')
              ->paginate($perPage);
    return $data;
   }

   public static  function checking_date_have_or_not($dep_id,$car_allocat,$currency,$refund,$date,$user_id){
    $data = DB::table('erp_carpayments')
              ->select('*')
              ->where('customer_deposit_id','=',$dep_id)
              ->where('car_allocate','=',$car_allocat)
              ->where('car_allocate_origin','=',$car_allocat)
              ->where('car_allocate_currency','=',$currency)
              ->where('car_allocate_origin_currency','=',$currency)
              ->where('payment_type','=',$refund)
              ->whereRaw('date(create_date)="'.$date.'"')
              ->where('author_id','=',$user_id)
              ->get();
     return $data;
  }




}
