<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Invoice_model extends Model
{
    use HasFactory;
    public static function Getinvoice_history($id){
        $data = DB::table('erp_stock_list')
                  ->select('stock_id')
                  ->where('invoice_id','=',$id)
                  ->get();
         return $data;
     }

    public static function Getinvoice_history_data($stock_ids){
        $data = DB::table('invoice_history')
                  ->select('*')
                  ->whereIn('stock_no',[$stock_ids])
                  ->orderBy('invoice_no','DESC')
                  ->get();
        return $data;
    }

    public static function deletes_invoice_stocklist($invoice_id){
        $data['invoice_id'] = '';
        DB::table('erp_stock_list')
          ->where('invoice_id','=',$invoice_id)
          ->update($data);
          return true;
    }

    public static function deletes_invoice($invoice_id){
        DB::table('erp_invoice')
           ->where('invoice_id','=',$invoice_id)
           ->delete();
        return true;
    }

    public static function update_status_invoice($invoice_id,$data){
        DB::table('erp_invoice')
          ->where('invoice_id','=',$invoice_id)
          ->update($data);
    }

    public static function get_data_proforma_invoice($invoice_id){
       $data = DB::table('erp_invoice AS a')
                 ->select(DB::raw('g.bank_eng_name,a.invoice_id,a.bank_account_id,a.issue_date,a.due_date,a.deposit, a.discount as discount_price, b.car_stock_id,b.car_make_id,b.car_model_id,b.car_model_year,b.sale_agent_id,b.chassis_number,b.date_of_production,b.color,b.invoice_id,b.consignee_name,b.consignee_address,b.consignee_phone,b.consignee_other_info,b.final_destination,c.car_make_id,c.car_make_name,d.car_model_id,d.car_make_id,d.car_model_name,f.color_id,f.color_name,g.bank_account_id,g.bank_name,g.swift_code,g.account_number,g.branch_name,g.address,h.stock_id,h.fob,h.freight_fee,h.staff_id,h.currency, h.insurance,h.vanning,h.hs_code,h.discount,h.vessel, b.car_selling_price_type, k.staff_id, k.full_name,cl.country_name, b.transimission,b.engine_size,cus.full_name AS cus_name,cus.phone_number,cus.customer_id,ship.voyage_no, ship.etd,ship.eta,dis.discharge_name, pot.port_of_loading_name,sc.shipping_co_name,b.memo_for_web,h.final_des_name,cus.address AS cus_address'))
                 ->leftjoin('erp_stock_list as b','b.invoice_id','=','a.invoice_id')
                 ->leftjoin('erp_car_make as c','c.car_make_id','=','b.car_make_id')
                 ->leftjoin('erp_car_model as d','d.car_model_id','=','b.car_model_id')
                 ->leftjoin('erp_shipments as ship','ship.shipment_id','=','b.shipment_id')
                 ->leftjoin('erp_discharge as dis','dis.discharge_id','=','ship.discharge_id')
                 ->leftjoin('erp_port_of_loading as pot','pot.port_of_loading_id','=','ship.port_of_loading_id')
                 ->leftjoin('erp_shipping_company as sc','sc.shipping_co_id','=','ship.shipping_co_id')
                 ->leftjoin('erp_car_color as f','f.color_id','=','b.color')
                 ->leftjoin('erp_bank_account as g','g.bank_account_id','=','a.bank_account_id')
                 ->leftjoin(DB::raw('(SELECT res.fob,res.freight_fee,res.insurance,res.vanning,res.inspection,res.created_dt,res.stock_id, res.currency,res.staff_id,res.hs_code,res.discount,res.vessel,erp_final_destination.final_des_name FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res LEFT JOIN erp_final_destination ON res.discharge_id = erp_final_destination.id GROUP BY res.stock_id) AS h'),'h.stock_id','=','b.stock_id')
                 ->leftjoin('erp_staff as k','k.staff_id','=','b.sale_agent_id')
                 ->leftjoin('erp_customer as cus','cus.customer_id','=','a.customer_id')
                 ->leftjoin('erp_country_list as cl','cl.country_list_id','=','cus.country_list_id')
                 ->where('a.invoice_id','=',$invoice_id)
                 ->get();
        return $data;
        }
    public static function get_customer_form_cambodia($cus_id){
        $data = DB::table('erp_customer')
                ->select(DB::raw('COUNT(*) as num_rows'))
                ->where('customer_id','=',$cus_id)
                ->where('country_list_id','=','37')
                ->get();
        if(COUNT($data) > 0){
        return $data[0]->num_rows;
        }
        return 0;  
    }

    public static function get_data_proforma_invoice_for_customer_form_cambodia($invoice_id){
        $getTotalCustomerDeposit = DB::raw('(
            SELECT
                SUM( `car_allocate` ) AS total_deposit,
                a.stock_id 
            FROM
                `erp_carpayments` `a`
                LEFT JOIN `erp_customer_deposit` `b` ON `a`.`customer_deposit_id` = `b`.`customer_deposit_id`
                LEFT JOIN `erp_deposit_income` `d` ON `d`.`deposit_income_id` = `b`.`deposit_income_id`
                LEFT JOIN `erp_staff` `e` ON `e`.`staff_id` = `a`.`author_id` 
            WHERE customer_deposit_type IN("customer_deposit","customer_auction_deposit")
            GROUP BY
                `a`.`stock_id` 
            ) AS customer_deposit ');
            $selectTotalDepositAndBalance = ' IFNULL( customer_deposit.total_deposit, 0 ) AS total_deposit,(IFNULL( `h`.`fob`, 0 ) + IFNULL( `h`.`freight_fee`, 0 ) + IFNULL( `h`.`insurance`, 0 ) + IFNULL( `h`.`vanning`, 0 ) - IFNULL( `h`.`discount`, 0 ) - IFNULL( customer_deposit.total_deposit, 0 )) AS total_balance ';
            $data = DB::table('erp_invoice as a')
                    ->select(DB::raw('g.bank_eng_name,a.dep_percentage,a.invoice_id,a.bank_account_id,a.issue_date,a.due_date,a.deposit, a.discount as discount_price, b.car_stock_id,b.car_make_id,b.car_model_id,b.car_model_year,b.sale_agent_id,b.chassis_number,b.date_of_production,b.color,b.invoice_id,b.consignee_name,b.consignee_address,b.consignee_phone,b.consignee_other_info,b.final_destination,c.car_make_id,c.car_make_name,d.car_model_id,d.car_make_id,d.car_model_name,f.color_id,f.color_name,g.bank_account_id,g.bank_name,g.swift_code,g.account_number,g.branch_name,g.address,h.stock_id,h.fob,h.freight_fee,h.staff_id,h.currency, h.insurance,h.vanning,h.hs_code,h.discount,h.vessel, b.car_selling_price_type, k.staff_id, k.full_name,cl.country_name, b.transimission,b.engine_size,cus.full_name AS cus_name,cus.phone_number,cus.customer_id,ship.voyage_no, ship.etd,ship.eta,dis.discharge_name, pot.port_of_loading_name,sc.shipping_co_name,b.memo_for_web,h.final_des_name,cus.address AS cus_address,'.$selectTotalDepositAndBalance))
                    ->leftjoin('erp_stock_list as b','b.invoice_id','=','a.invoice_id')
                    ->leftjoin('erp_car_make as c','c.car_make_id','=','b.car_make_id')
                    ->leftjoin('erp_car_model as d','d.car_model_id','=','b.car_model_id')
                    ->leftjoin('erp_shipments as ship','ship.shipment_id','=','b.shipment_id')
                    ->leftjoin('erp_discharge as dis','dis.discharge_id','=','ship.discharge_id')
                    ->leftjoin('erp_port_of_loading as pot','pot.port_of_loading_id','=','ship.port_of_loading_id')
                    ->leftjoin('erp_shipping_company as sc','sc.shipping_co_id','=','ship.shipping_co_id')
                    ->leftjoin('erp_car_color as f','f.color_id','=','b.color')
                    ->leftjoin('erp_bank_account as g','g.bank_account_id','=','a.bank_account_id')
                    ->leftjoin(DB::raw('(SELECT res.fob,res.freight_fee,res.insurance,res.vanning,res.inspection,res.created_dt,res.stock_id, res.currency,res.staff_id,res.hs_code,res.discount,res.vessel,erp_final_destination.final_des_name FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res LEFT JOIN erp_final_destination ON res.discharge_id = erp_final_destination.id GROUP BY res.stock_id) AS h'),'h.stock_id','=','b.stock_id')
                    ->leftjoin('erp_staff as k','k.staff_id','=','b.sale_agent_id')
                    ->leftjoin('erp_customer as cus','cus.customer_id','=','a.customer_id')
                    ->leftjoin('erp_country_list as cl','cl.country_list_id','=','cus.country_list_id')
                    ->leftjoin($getTotalCustomerDeposit,'customer_deposit.stock_id','=','b.stock_id')
                    ->where('a.invoice_id','=',$invoice_id)
                    ->get();
            return $data;
    }

    public static function get_data_invoice_items($invoice_id){
        $data = DB::table('erp_invoice_item AS a')
                ->select(DB::raw('a.*,b.*,c.*,k.*,d.full_name as customer_name,d.address as customer_address'))
                ->leftjoin('erp_invoice as b','b.invoice_id','=','a.invoice_id')
                ->leftjoin('erp_customer as d','d.customer_id','=','b.customer_id')
                ->leftjoin('erp_bank_account as c','c.bank_account_id','=','b.bank_account_id')
                ->leftjoin('erp_staff as k','k.staff_id','=','a.staff_id')
                ->where('a.invoice_id','=',$invoice_id)
                ->get();
        return $data;
    }

    public static function select_invoice_items($perPage,$where_manul,$where){
        $data = DB::table('erp_invoice_item AS a')
                ->select(DB::raw('SUM(a.qty)as qtysum,SUM(a.item_amount)as itemsum,a.item_description,a.invoice_id,a.created_dt'))
                ->leftjoin('erp_invoice AS b','b.invoice_id','=','a.invoice_id')
                ->where($where)
                ->when(!empty($where_manul),function ($v) use ($where_manul) {
                    $v->whereRaw(DB::raw($where_manul));
                })
                ->groupBy('a.invoice_id')
                ->orderBy('a.invoice_id','DESC')
                //    ->toRawSql();
                //    dd($data);
                ->paginate($perPage);
        return $data;
    }

    public static function deletes_invoice_items($invoice_id){
        if(!empty($hide_pakistan)){
            $country_list = DB::table('erp_block_countries as t1')
                            ->select('t1.*','c.*')
                            ->leftjoin('erp_block_countries as t2','t1.parent_id','=','t2.parent_id')
                            ->leftjoin('erp_country_list as c','t1.country_list_id','=','c.country_list_id')
                            ->groupBy('t1.country_list_id')
                            ->get();
            foreach  ($country_list as $key => $value) {
                    array_push($show, strtolower($value->country_list_id));
            }
        }
        DB::table('erp_invoice_item')
        ->where('invoice_id','=',$invoice_id)
        ->delete();
        return true;
    }

    public static function select_bank_accounting($hide_pakistan){
        $show =   array('14','15');
        $data = DB::table('erp_bank_account')
                ->select('*')
                ->where('status','=','Enable')
                ->orderBy('order_bank','ASC')
                ->when(!empty($hide_pakistan),function ($v) use ($show) {
                    $v->whereIn(DB::raw('bank_account_id'),$show);
                })
                ->get();
        return $data;
    }

    public static function insert_invoice($data){
        $invoiceid = DB::table('erp_invoice')
        ->insertGetId($data);
        return $invoiceid;
    }

    public static function insert_invoice_item($data_invoiceitem){
        DB::table('erp_invoice_item')
        ->insert($data_invoiceitem);
    }

    public static function get_customer_info_by_cus_id($p_customer_id){
        $data = DB::table('erp_customer')
                ->select('*')
                ->where('customer_id','=',$p_customer_id)
                ->get();
        return $data;
    }
    public static function get_bank_info_by_bank_id($bank_id){
        $data = DB::table('erp_bank_account')
                ->select('*')
                ->where('bank_account_id','=',$bank_id)
                ->get();
        return $data;
    }

    public static function get_data_proforma_invoice_multi_stock($stock_trim){
        $data = DB::table('erp_stock_list as b')
                  ->select(DB::raw('a.invoice_id,a.bank_account_id,a.issue_date,a.due_date,b.car_stock_id,b.car_make_id,b.car_model_id,b.car_model_year,b.sale_agent_id,b.chassis_number,b.date_of_production,b.color,b.invoice_id,b.consignee_name,b.consignee_address,b.consignee_phone,b.consignee_other_info,b.final_destination,c.car_make_id,c.car_make_name,d.car_model_id,d.car_make_id,d.car_model_name,f.color_id,f.color_name,g.bank_account_id,g.bank_name,g.swift_code,g.account_number,g.branch_name,g.address,h.stock_id,h.fob,h.freight_fee,h.staff_id,h.currency, h.insurance,h.hs_code,h.discount,h.vessel, b.car_selling_price_type, k.staff_id, k.full_name,cl.country_name, b.transimission,b.engine_size,cus.full_name AS cus_name,cus.customer_id,ship.voyage_no, ship.etd,ship.eta,dis.discharge_name, pot.port_of_loading_name,sc.shipping_co_name,b.memo_for_web,h.final_des_name'))
                  ->leftjoin('erp_invoice as a','b.invoice_id','=','a.invoice_id')
                  ->leftjoin('erp_car_make as c','c.car_make_id','=','b.car_make_id')
                  ->leftjoin('erp_car_model as d','d.car_model_id','=','b.car_model_id')
                  ->leftjoin('erp_shipments as ship','ship.shipment_id','=','b.shipment_id')
                  ->leftjoin('erp_discharge as dis','dis.discharge_id','=','ship.discharge_id')
                  ->leftjoin('erp_port_of_loading as pot','pot.port_of_loading_id','=','ship.port_of_loading_id')
                  ->leftjoin('erp_shipping_company as sc','sc.shipping_co_id','=','ship.shipping_co_id')
                  ->leftjoin('erp_car_color as f','f.color_id','=','b.color')
                  ->leftjoin('erp_bank_account as g','g.bank_account_id','=','a.bank_account_id')
                  ->leftjoin(DB::raw('(SELECT res.fob,res.freight_fee,res.insurance,res.inspection,res.created_dt,res.stock_id, res.currency,res.staff_id,res.hs_code,res.discount,res.vessel,erp_final_destination.final_des_name FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res LEFT JOIN erp_final_destination ON res.discharge_id = erp_final_destination.id GROUP BY res.stock_id) AS h'),'h.stock_id','=','b.stock_id')
                  ->leftjoin('erp_staff as k','k.staff_id','=','b.sale_agent_id')
                  ->leftjoin('erp_customer as cus','cus.customer_id','=','b.customer_id')
                  ->leftjoin('erp_country_list as cl','cl.country_list_id','=','cus.country_list_id')
                  ->whereRaw('b.stock_id IN ('.$stock_trim.')')
                  ->get();
        return $data;
    }
}


