<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Shipping_model extends Model
{
    use HasFactory;

    public static function get_shiping_list($hide_pakistan,$perpage,$sch_discharge,$sch_voyage,$sch_condition,$r_sch_condition, $sch_word){
        $show = array();
        if(!empty($hide_pakistan)){
            $country_list = DB::table('erp_block_countries as t1')
                            ->select('t1.*','c.*')
                            ->leftjoin('erp_block_countries as t2','t1.parent_id','=','t2.parent_id')
                            ->leftjoin('erp_country_list as c','t1.country_list_id','=','c.country_list_id')
                            ->groupBy('t1.country_list_id')
                            ->get();
            foreach  ($country_list as $key => $value) {
                    array_push($show, strtolower($value->country_name));
            }
        }
        $select_count = DB::raw('( SELECT shipment_id AS ship_id,dhl_number,stock_yard_id,chassis_number,booked_date,COUNT(*) AS total_car FROM erp_stock_list GROUP BY shipment_id) AS a');
        $data = DB::table('erp_shipments')
                  ->select('*')
                  ->leftjoin($select_count, 'a.ship_id','=','erp_shipments.shipment_id')
                  ->leftjoin('erp_port_of_loading','erp_port_of_loading.port_of_loading_id','=','erp_shipments.port_of_loading_id')
                  ->leftjoin('erp_discharge','erp_discharge.discharge_id','=','erp_shipments.discharge_id')
                  ->leftjoin('erp_shipping_company','erp_shipping_company.shipping_co_id','=','erp_shipments.shipping_co_id')
                  ->leftjoin('erp_stock_yard_location','erp_stock_yard_location.stock_yard_id','=','a.stock_yard_id')
                  ->when(!empty($hide_pakistan),function ($v) use ($show) {
                    $v->whereIn(DB::raw('LOWER(SUBSTRING_INDEX(REPLACE(discharge_name, " ", ""), ",", - 1 ))'),$show);
                   })
                   ->when(!empty($sch_discharge),function ($v) use ($sch_discharge) {
                    $v->whereRaw(DB::raw('discharge_name LIKE "%'.$sch_discharge.'%"'));
                   })
                   ->when(!empty($sch_voyage),function ($v) use ($sch_voyage) {
                    $v->whereRaw(DB::raw('voyage_no LIKE "%'.$sch_voyage.'%"'));
                   })
                   ->when(!empty($sch_word),function ($v) use ($sch_word,$r_sch_condition) {
                    $v->whereRaw(DB::raw(''.$r_sch_condition.' LIKE "%'.$sch_word.'%"'));
                   })
                  ->orderBy('erp_shipments.etd','DESC')
                  ->orderBy('erp_shipments.shipment_id','DESC')
                  ->paginate($perpage);
                return $data;
    }

    public static function get_data_of_stocklist($hide_pakistan,$perpage,$sch_word,$r_sch_condition){
        $show = array();
        if(!empty($hide_pakistan)){
            $country_list = DB::table('erp_block_countries as t1')
                            ->select('t1.*','c.*')
                            ->leftjoin('erp_block_countries as t2','t1.parent_id','=','t2.parent_id')
                            ->leftjoin('erp_country_list as c','t1.country_list_id','=','c.country_list_id')
                            ->groupBy('t1.country_list_id')
                            ->get();
            foreach  ($country_list as $key => $value) {
                    array_push($show, strtolower($value->country_list_id));
            }
        }

        $data = DB::table('erp_stock_list as a')
                  ->select('*')
                  ->leftjoin('erp_country_list as d','d.country_list_id','=','a.market_country_id')
                  ->leftjoin('erp_stock_list_car_status as e','e.stock_list_car_status_id','=','a.status')
                  ->leftjoin('erp_stock_yard_location','erp_stock_yard_location.stock_yard_id','=','a.stock_yard_id')
                  ->leftjoin('erp_car_make','erp_car_make.car_make_id','=','a.car_make_id')
                  ->leftjoin('erp_car_model','erp_car_model.car_model_id','=','a.car_model_id')
                  ->leftjoin('erp_customer','erp_customer.customer_id','=','a.customer_id')
                  ->whereRaw('shipment_id IS NULL')
                  ->whereRaw("(status=7 OR instruction ='on_the_way_to')")
                  ->when(!empty($sch_word),function ($v) use ($sch_word,$r_sch_condition) {
                    $v->whereRaw(DB::raw(''.$r_sch_condition.' LIKE "%'.$sch_word.'%"'));
                   })
                   ->when(!empty($hide_pakistan),function ($v) use ($show) {
                    $v->whereIn(DB::raw('a.market_country_id'),$show);
                    })
                  ->orderBy('a.stock_id','DESC')
                  ->paginate($perpage);
        return $data;
    }

    public static function get_shipping_company(){
        $data = DB::table('erp_shipping_company')
                  ->select('*')
                  ->orderBy('shipping_co_name','ASC')
                  ->get();
        return $data;
    }

    public static function get_discharge($hide_pakistan){
        $show = array();
        if(!empty($hide_pakistan)){
            $country_list = DB::table('erp_block_countries as t1')
                            ->select('t1.*','c.*')
                            ->leftjoin('erp_block_countries as t2','t1.parent_id','=','t2.parent_id')
                            ->leftjoin('erp_country_list as c','t1.country_list_id','=','c.country_list_id')
                            ->groupBy('t1.country_list_id')
                            ->get();
            foreach  ($country_list as $key => $value) {
                    array_push($show, strtolower($value->country_name));
            }
        }
        $data = DB::table('erp_discharge')
                  ->select('*')
                  ->when(!empty($hide_pakistan),function ($v) use ($show) {
                    $v->whereIn(DB::raw('LOWER(SUBSTRING_INDEX(REPLACE(discharge_name, " ", ""), ",", - 1 ))'),$show);
                   })
                  ->groupBy('discharge_name')
                  ->orderBy('discharge_name','ASC')
                  ->get();
        return $data;
    }

    public static function get_port_of_loading(){
        $data = DB::table('erp_port_of_loading')
                  ->orderBy('port_of_loading_name','ASC')
                  ->get();
        return $data;
    }

    public static function update_shipment_stock_list($shipment_id,$data){
        DB::table('erp_stock_list')
          ->where('shipment_id','=',$shipment_id)
          ->update($data);
    }

    public static function update_note($shipId,$note_arr){
        DB::table('erp_shipments')
          ->where('shipment_id','=',$shipId)
          ->update($note_arr);
    }

    public static function update_booking_spece($shipment_id,$data){
        DB::table('erp_shipments')
          ->where('shipment_id','=',$shipment_id)
          ->update($data);
    }

    public static function get_car_in_stocklist_by_shipment_id1($shipment_id){
        $select_count = "( SELECT shipment_id AS ship_id,stock_yard_id,chassis_number,COUNT(*) AS total_car FROM erp_stock_list GROUP BY ship_id) AS a";
        $data = DB::table('erp_shipments')
                  ->select('*')
                  ->leftjoin(DB::raw($select_count),'a.ship_id','=','erp_shipments.shipment_id')
                  ->leftjoin('erp_port_of_loading','erp_port_of_loading.port_of_loading_id','=','erp_shipments.port_of_loading_id')
                  ->leftjoin('erp_discharge','erp_discharge.discharge_id','=','erp_shipments.discharge_id')
                  ->leftjoin('erp_shipping_company','erp_shipping_company.shipping_co_id','=','erp_shipments.shipping_co_id')
                  ->where('erp_shipments.shipment_id','=',$shipment_id)
                  ->orderBy('erp_shipments.shipment_id','DESC')
                  ->get();
        return $data;
    }

    public static function get_car_in_stocklist_for_email_of_id($shipment_id,$stock_id){
        $data = DB::table('erp_stock_list as a')
                  ->select('*')
                  ->leftjoin('erp_country_list as d','d.country_list_id','=','a.market_country_id')
                  ->leftjoin('erp_stock_list_car_status as e','e.stock_list_car_status_id','=','a.status')
                  ->leftjoin('erp_car_make','erp_car_make.car_make_id','=','a.car_make_id')
                  ->leftjoin('erp_car_model','erp_car_model.car_model_id','=','a.car_model_id')
                  ->leftjoin('erp_car_color','erp_car_color.color_id','=','a.color')
                  ->leftjoin('erp_customer','erp_customer.customer_id','=','a.customer_id')
                  ->orderBy('a.order_shipment','ASC')
                  ->whereRaw("a.shipment_id IS NOT NULL")
                  ->where("a.shipment_id",'=', $shipment_id)
                  ->where("a.stock_id",'=',$stock_id)
                  ->get();
        return $data;
    }

    public static function get_shipment_etd($shipment_id){
        $data = DB::table('erp_shipments')
                  ->select('*')
                  ->where('shipment_id','=',$shipment_id)
                  ->get();
        return $data;
    }

    public static function update_stock_list($stock_id, $data_stock){
        DB::table('erp_stock_list')
          ->where('stock_id','=',$stock_id)
          ->update($data_stock);
    }

    public static function get_shipment_invoice($hide_pakistan,$perpage,$where,$r_sch_condition,$where_manul,$sch_from,$sch_voyage,$sch_discharge){
        $show = array();
        if(!empty($hide_pakistan)){
            $country_list = DB::table('erp_block_countries as t1')
                            ->select('t1.*','c.*')
                            ->leftjoin('erp_block_countries as t2','t1.parent_id','=','t2.parent_id')
                            ->leftjoin('erp_country_list as c','t1.country_list_id','=','c.country_list_id')
                            ->groupBy('t1.country_list_id')
                            ->get();
            foreach  ($country_list as $key => $value) {
                    array_push($show, strtolower($value->country_name));
            }
        }
        $select_count = "( SELECT shipment_id AS ship_id,stock_yard_id,chassis_number,COUNT(*) AS total_car FROM erp_stock_list GROUP BY shipment_id) AS a";
        $data = DB::table('erp_shipments')
                  ->select('*')
                  ->leftjoin(DB::raw($select_count),'a.ship_id','=','erp_shipments.shipment_id')
                  ->leftjoin('erp_port_of_loading','erp_port_of_loading.port_of_loading_id','=','erp_shipments.port_of_loading_id')
                  ->leftjoin('erp_discharge','erp_discharge.discharge_id','=','erp_shipments.discharge_id')
                  ->leftjoin('erp_shipping_company','erp_shipping_company.shipping_co_id','=','erp_shipments.shipping_co_id')
                  ->leftjoin('erp_stock_yard_location','erp_stock_yard_location.stock_yard_id','=','a.stock_yard_id')
                  ->whereRaw('total_car > 0')
                  ->when(!empty($hide_pakistan),function ($v) use ($show) {
                    $v->whereIn(DB::raw('LOWER(SUBSTRING_INDEX(REPLACE(discharge_name, " ", ""), ",", - 1 ))'),$show);
                   })
                   ->when(!empty($where),function ($v) use ($where) {
                    $v->where($where);
                   })
                   ->when(!empty($r_sch_condition),function ($v) use ($r_sch_condition) {
                    $v->whereRaw($r_sch_condition);
                   })
                   ->when(!empty($where_manul),function ($v) use ($where_manul) {
                    $v->whereRaw($where_manul);
                   })
                   ->when($sch_from != '' || $sch_voyage != '',function ($v) use ($sch_from,$sch_voyage) {
                    if($sch_from != ''){
                        $v->whereRaw("port_of_loading_name LIKE '%".$sch_from."%'");
                    }else if($sch_voyage != ''){
                        $v->whereRaw("voyage_no LIKE '%".$sch_voyage."%'");
                    }
                   })
                   ->when($sch_discharge != '' || $sch_voyage != '',function ($v) use ($sch_discharge,$sch_voyage) {
                    if($sch_discharge != ''){
                        $v->whereRaw("discharge_name LIKE '%".$sch_discharge."%'");
                    }else if($sch_voyage != ''){
                        $v->whereRaw("voyage_no LIKE '%".$sch_voyage."%'");
                    }
                   })
                   ->OrderBy(DB::raw("(CASE WHEN check_day_shipment = 2  AND confirm_report_shipment='not_confirm' THEN 0 ELSE 1 END)"))
                   ->orderBy('etd','DESC')
                   ->orderBy('shipment_id','DESC')
                   ->paginate($perpage);
        return $data;
    }

    public static function get_shipment_invoice1(){
        $select_count = "( SELECT shipment_id AS ship_id,stock_yard_id,chassis_number,COUNT(*) AS total_car FROM erp_stock_list GROUP BY shipment_id) AS a";
        $data = DB::table('erp_shipments')
                  ->leftjoin(DB::raw($select_count),'a.ship_id','=','erp_shipments.shipment_id')
                  ->leftjoin('erp_port_of_loading','erp_port_of_loading.port_of_loading_id','=','erp_shipments.port_of_loading_id')
                  ->leftjoin('erp_discharge','erp_discharge.discharge_id','=','erp_shipments.discharge_id')
                  ->leftjoin('erp_shipping_company','erp_shipping_company.shipping_co_id','=','erp_shipments.shipping_co_id')
                  ->leftjoin('erp_stock_yard_location','erp_stock_yard_location.stock_yard_id','=','a.stock_yard_id')
                  ->whereRaw('total_car > 0')
                  ->orderBy(DB::raw("(CASE WHEN check_day_shipment = 2  AND confirm_report_shipment='not_confirm' THEN 0 ELSE 1 END)"))
                  ->orderBy('etd','DESC')
                  ->orderBy('shipment_id','DESC')
                  ->get();
        return $data;
    }

    public static function check_bl_date($shipment_id){
        $data = DB::table('erp_shipments')
                  ->select('*')
                  ->where('shipment_id','=',$shipment_id)
                  ->get();
        return $data;
    }

    public static function get_car_in_stocklist_by_shipment_id($shippment_id){
        $data = DB::table('erp_stock_list as a')
                  ->leftjoin('erp_country_list as d','d.country_list_id','=','a.market_country_id')
                  ->leftjoin('erp_stock_list_car_status as e','e.stock_list_car_status_id','=','a.status')
                  ->leftjoin('erp_car_make','erp_car_make.car_make_id','=','a.car_make_id')
                  ->leftjoin('erp_car_model','erp_car_model.car_model_id','=','a.car_model_id')
                  ->leftjoin('erp_car_color','erp_car_color.color_id','=','a.color')
                  ->leftjoin('erp_customer','erp_customer.customer_id','=','a.customer_id')
                  ->leftjoin('erp_stock_city_location','erp_stock_city_location.stock_city_id','=','a.stock_city_id')
                  ->leftjoin('erp_stock_yard_location','erp_stock_yard_location.stock_yard_id','=','a.stock_yard_id')
                  ->whereRaw('a.shipment_id IS NOT NULL')
                  ->where('a.shipment_id','=',$shippment_id)
                  ->orderBy('a.order_shipment','ASC')
                  ->get();
                //   dd($data);
        return $data;
    }

    public static function blockTabVesselUnbookedListByCountries($staff_id){
        if(!empty($staff_id)){
            $data = DB::table('erp_staff')
                      ->select('*')
                      ->where('staff_id','=',$staff_id)
                      ->get();
            return $data;
        }
        return null; 
    }
    public static function check_dubai_users($staff_id){
        $data = DB::table('erp_staff')
                ->select('*')
                ->where('staff_id','=',$staff_id)
                ->get();
        return $data;
    }

    public static function update_image_arrived_status($data,$stock_id){
        DB::table('erp_stock_list')
            ->where('stock_id','=',$stock_id)
            ->update($data);
    }

    public static function get_stock_id_by_shipment_id($shipment_id){
       $data = DB::table('erp_stock_list')
                 ->select('stock_id')
                 ->where('shipment_id','=',$shipment_id)
                 ->get();
        return $data;
    }

    public static function get_car_in_stocklist_for_email($shipmentId){
        $data = DB::table('erp_stock_list as a')
                  ->select('*')
                  ->leftjoin('erp_country_list as d','d.country_list_id','=','a.market_country_id')
                  ->leftjoin('erp_stock_list_car_status as e','e.stock_list_car_status_id','=','a.status')
                  ->leftjoin('erp_car_make','erp_car_make.car_make_id','=','a.car_make_id')
                  ->leftjoin('erp_car_model','erp_car_model.car_model_id','=','a.car_model_id')
                  ->leftjoin('erp_car_color','erp_car_color.color_id','=','a.color')
                  ->leftjoin('erp_customer','erp_customer.customer_id','=','a.customer_id')
                  ->whereRaw('a.shipment_id IS NOT NULL')
                  ->where('a.shipment_id','=',$shipmentId)
                  ->orderBy('a.order_shipment','ASC')
                  ->get();
        return $data;
    }

    public static function get_cars_by_shipment_id1($shipment_id){
        $data = DB::table('erp_stock_list as a')
                  ->select('*')
                  ->whereRaw('a.shipment_id IS NOT NULL')
                  ->where('a.shipment_id','=',$shipment_id)
                  ->get();
                  return $data;
    }
    public static function get_cars_by_shipment_id( $shipment_id ){
        $data = DB::table('erp_stock_list as a')
                  ->leftjoin('erp_stock_list_doc as d','d.stock_id','=','a.stock_id')
                  ->whereRaw('a.shipment_id IS NOT NULL')
                  ->where('d.doc_type','ec')
                  ->where('a.shipment_id','=',$shipment_id)
                  ->groupBy('d.stock_id')
                  ->get();
        return $data;
    }
    public static function get_shipment_car( $shipment_id ){
        $data = DB::table('erp_stock_list as a')
                  ->leftjoin('erp_stock_list_doc as d','d.stock_id','=','a.stock_id')
                  ->whereRaw('a.shipment_id IS NOT NULL')
                  ->where('d.doc_type','bl')
                  ->where('a.shipment_id','=',$shipment_id)
                  ->groupBy('d.stock_id')
                  ->get();
        return $data;
    }

    public static function update_comfirm($shipment_id,$note_arr){
        DB::table('erp_shipments')
          ->where('shipment_id','=',$shipment_id)
          ->update($note_arr);
          return true;
    }

    public static function get_data_stock_list($shipment_id,$arr_stock){
        $data = DB::table('erp_stock_list')
                  ->select('stock_id','customer_id')
                  ->where('shipment_id','=',$shipment_id)
                  ->whereIn('stock_id',[$arr_stock])
                  ->get();
        return  $data;
    
    }

    public static function get_shipment_excel($ship_invoice){
        $sql ="SELECT
            `a`.*, `a`.`consignee_name` AS `con_name`,
            `a`.`consignee_address` AS `con_add`,
            `a`.`consignee_phone` AS `con_phone`,
            `a`.`consignee_other_info` AS `con_other_info`,
            `b`.*, `d`.*, `e`.*, `erp_car_make`.*, `erp_car_model`.*, `erp_customer`.*, `erp_port_of_loading`.*, `erp_discharge`.*, `car_re`.*, `erp_invoice`.*, `erp_car_color`.*, `boss`.*, `final`.`final_des_name`
        FROM
            `erp_stock_list` `a`
        LEFT JOIN `erp_shipments` `b` ON `b`.`shipment_id` = `a`.`shipment_id`
        LEFT JOIN `erp_country_list` `d` ON `d`.`country_list_id` = `a`.`market_country_id`
        LEFT JOIN `erp_stock_list_car_status` `e` ON `e`.`stock_list_car_status_id` = `a`.`status`
        LEFT JOIN `erp_car_make` ON `erp_car_make`.`car_make_id` = `a`.`car_make_id`
        LEFT JOIN `erp_car_model` ON `erp_car_model`.`car_model_id` = `a`.`car_model_id`
        LEFT JOIN `erp_customer` ON `erp_customer`.`customer_id` = `a`.`customer_id`
        LEFT JOIN `erp_port_of_loading` ON `erp_port_of_loading`.`port_of_loading_id` = `b`.`port_of_loading_id`
        LEFT JOIN `erp_discharge` ON `erp_discharge`.`discharge_id` = `b`.`discharge_id`
        LEFT JOIN `erp_invoice` ON `erp_invoice`.`invoice_id` = `a`.`invoice_id`
        LEFT JOIN `erp_car_color` ON `erp_car_color`.`color_id` = `a`.`color`
        LEFT JOIN (
            SELECT
                bb.car_stock_id,
                bb.boss_price,
                bb.currency
            FROM
                (
                    SELECT
                        *
                    FROM
                        erp_stock_list_boss_price
                    ORDER BY
                        boss_price_id DESC
                ) AS bb
            GROUP BY
                bb.car_stock_id
        ) AS boss ON `boss`.`car_stock_id` = `a`.`car_stock_id`
        LEFT JOIN (
            SELECT
                *
            FROM
                (
                    SELECT
                        *
                    FROM
                        erp_car_reserve
                    ORDER BY
                        reserve_id DESC
                ) AS rr
            GROUP BY
                rr.stock_id
        ) AS car_re ON `car_re`.`stock_id` = `a`.`car_stock_id`
        LEFT JOIN `erp_final_destination` AS `final` ON `final`.`id` = `car_re`.`discharge_id`
        WHERE
            `a`.`shipment_id` IS NOT NULL
        AND `b`.`shipment_id` = $ship_invoice
        ORDER BY
            `a`.`order_shipment` ASC";

       $data = DB::select($sql);
       return $data;
    }

    public static function get_data_shipment($shipment_id){
        $data = DB::table('erp_stock_list as a')
                  ->select(DB::raw('a.stock_id,a.car_stock_id,erp_car_make.car_make_name,erp_car_model.car_model_name,a.car_model_year,a.chassis_number,erp_customer.full_name,erp_shipments.shipping_invoice_code'))
                  ->leftjoin('erp_car_make','erp_car_make.car_make_id','=','a.car_make_id')
                  ->leftjoin('erp_car_model','erp_car_model.car_model_id','=','a.car_model_id')
                  ->leftjoin('erp_customer','erp_customer.customer_id','=','a.customer_id')
                  ->leftjoin('erp_shipments','erp_shipments.shipment_id','=','a.shipment_id')
                  ->where('a.shipment_id','=',$shipment_id)
                  ->orderBy('a.order_shipment','ASC')
                  ->get();
        return $data;
    }

    public static function select_file_upload_doc($stock_id){
        $data = DB::table('erp_stock_list')
                  ->select('*')
                  ->where('stock_id','=',$stock_id)
                  ->get();
        return $data;
    }

    public static function select_file_upload($stock_id,$type_file){
        $data = DB::table('erp_stock_list_doc')
                  ->select('*')
                  ->where('stock_id','=',$stock_id)
                  ->where('doc_type', $type_file)
                  ->get();
        return $data;
    }

    public static function get_car_stock_id_by_chassis($trim_chassis){
        $data= DB::table('erp_stock_list')
                 ->select('stock_id')
                 ->where('chassis_number','=',$trim_chassis)
                 ->get();
        return $data[0]->stock_id;    
    }

    public static function add_ship_invoice_to_car($data,$trim_chassis){
        DB::table('erp_stock_list')
          ->where('chassis_number', '=', $trim_chassis)
          ->update($data);
          
    }
}
