<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Stocklist_model extends Model
{
    use HasFactory;
    public static function select_data_stock_list($stock_id){
        $tbl_join = "SELECT bb.car_stock_id,bb.boss_price,bb.currency,bb.boss_price_type,bb.port_name FROM (SELECT * FROM erp_stock_list_boss_price ORDER BY boss_price_id DESC) AS bb GROUP BY bb.car_stock_id";
        $data = DB::table('erp_stock_list AS a')
                  ->select('*')
                  ->leftjoin(DB::raw('('.$tbl_join.') AS boss'), 'boss.car_stock_id','=','a.car_stock_id')
                  ->where('a.car_stock_id','=',$stock_id)
                  ->get();
        return $data;
    }

    public static function update_stock_list($stock_id,$data){
        DB::table('erp_stock_list')
            ->where('stock_id','=',$stock_id)
            ->update($data);
    }

    public static function insert_draft(){
        $data=array("car_register_date"=>date('Y-m-d H:i:s'));
        $stockid = DB::table('erp_stock_list')
        ->insertGetId($data);
        return $stockid;
    }

    public static function select_photo_auction($stock_id){
        $data = DB::table('erp_stock_list_photo')
                ->select('*')
                ->where('stock_id','=',$stock_id)
                ->where('photo_type','=','auction_photo')
                ->where('photo_order','=',1)
                ->get();
        return $data;
    }

    public static function select_photo_yard_two($stock_id){
        $data = DB::table('erp_stock_list_photo')
                ->select('*')
                ->where('stock_id','=',$stock_id)
                ->where('photo_type','=','yard_photo_two')
                ->where('photo_order','=',1)
                ->get();
        return $data;
    }

    public static function select_photo_yard($stock_id){
        $data = DB::table('erp_stock_list_photo')
                ->select('*')
                ->where('stock_id','=',$stock_id)
                ->where('photo_type','=','yard_photo')
                ->where('photo_order','=',1)
                ->get();
        return $data;
    }

    public static function get_last_auction_photoes($id){
        $data =  DB::table('erp_stock_list_photo')
          ->select('photo_order')
          ->where('stock_id','=',$id)
          ->where('photo_type','=','auction_photo')
          ->orderBy('photo_id','DESC')
          ->limit(1)
          ->get();
        return $data;
    }

    public static function get_last_yard_photoes($id){
        $data =  DB::table('erp_stock_list_photo')
        ->select('photo_order')
        ->where('stock_id','=',$id)
        ->where('photo_type','=','yard_photo')
        ->orderBy('photo_id','DESC')
        ->limit(1)
        ->get();
      return $data;
    }

    public static function insert_yart($data){
          $id = DB::table('erp_stock_list_photo')
                  ->insertGetId($data);
          return $id;
    }

    public static function select_detail_image($where){
        $data = DB::table('erp_stock_list_photo')
          ->select('*')
          ->where($where)
          ->orderBy('photo_order','ASC')
          ->get();
        return $data;

    }

    public static function get_last_yard_photoes_two($id){
        $data =  DB::table('erp_stock_list_photo')
        ->select('photo_order')
        ->where('stock_id','=',$id)
        ->where('photo_type','=','yard_photo_two')
        ->orderBy('photo_id','DESC')
        ->limit(1)
        ->get();
      return $data;
    }

    public static function insert_images_upload($data){
        $id = DB::table('erp_stock_list_photo')
        ->insertGetId($data);
        return $id;
    }

    public static function check_car_photo($stock_id){
        $data = DB::table('erp_stock_list')
                  ->select('car_yard_photo_two')
                  ->where('stock_id','=',$stock_id)
                  ->get();
        return $data;
    }

    public static function update_photo_yard_two($stock_id,$data){
        DB::table('erp_stock_list')
          ->where('stock_id','=',$stock_id)
          ->update($data);
    }

    public static function Update_image_stock($where, $id){
        DB::table('erp_stock_list')
          ->where('stock_id','=',$id)
          ->update($where);
    }

    public static function resortExceptSelect($stock_id,$photo_id){
        $order = DB::raw("(CASE WHEN photo_id = ".$photo_id." THEN 1 else 2 END )");
        $data =  DB::table('erp_stock_list_photo')
        ->select('photo_id')
        ->where('stock_id','=',$stock_id)
        ->where('photo_type','=','auction_photo')
        ->orderByRaw("(CASE WHEN photo_id = ".$photo_id." THEN 1 else 2 END )")
        ->get();
      return $data;
    }

    public static function resortExceptSelectYard($stock_id,$photo_id){
        $order = DB::raw("(CASE WHEN photo_id = ".$photo_id." THEN 1 else 2 END )");
        $data =  DB::table('erp_stock_list_photo')
        ->select('photo_id')
        ->where('stock_id','=',$stock_id)
        ->where('photo_type','=','yard_photo')
        ->orderByRaw("(CASE WHEN photo_id = ".$photo_id." THEN 1 else 2 END )")
        ->get();
      return $data;
    }

    public static function resortExceptSelectYardTwo($stock_id,$photo_id){
        $order = DB::raw("(CASE WHEN photo_id = ".$photo_id." THEN 1 else 2 END )");
        $data =  DB::table('erp_stock_list_photo')
        ->select('photo_id')
        ->where('stock_id','=',$stock_id)
        ->where('photo_type','=','yard_photo_two')
        ->orderByRaw("(CASE WHEN photo_id = ".$photo_id." THEN 1 else 2 END )")
        ->get();
      return $data;
    }
    
    public static function update_images_primary($photo_id,$order){
        DB::table('erp_stock_list_photo')
          ->where('photo_id','=',$photo_id)
          ->update(['photo_order'=>$order]);
    }
  
    public static function Update_data_video_url($stock_id,$data_photo){
        DB::table('erp_stock_list_photo')
        ->where('stock_id','=',$stock_id)
        ->update(['video_url'=>$data_photo]);
    }

    public static function get_total_cost($stock_id){
        $data = DB::table('erp_car_expenses AS a')
                    ->select('*')
                    ->leftjoin('erp_staff AS b','a.staff_id','=','b.staff_id')
                    ->where('stock_id','=',$stock_id)
                    ->get();
        return $data;
    }

    public static function get_boss_price($stock_id){
        $select = "a.*,b.full_name,b.staff_id AS st_id";
        $data = DB::table('erp_stock_list_boss_price AS a')
                ->select(DB::raw($select))
                ->leftjoin('erp_staff AS b','a.staff_id','=','b.staff_id')
                ->where('car_stock_id','=',$stock_id)
                ->get();
        return $data;
    }

    public static function get_boss_price_modify($stock_id){
        $data = DB::table('erp_stock_list_boss_price')
                  ->where('car_stock_id','=',$stock_id)
                  ->orderBy('boss_price_id','DESC')
                  ->limit(1)
                  ->get();
        return $data;
    }

    public static function select_boss_price($stock_id){
        $data = DB::table('erp_stock_list_boss_price')
                  ->select('*')
                  ->where('car_stock_id','=',$stock_id)
                  ->orderBy('boss_price_id','DESC')
                  ->limit(1)
                  ->get();
        return $data;
    }

    public static function insert_boss_price($data_bossprice){
          DB::table('erp_stock_list_boss_price')
            ->insert($data_bossprice);
    }

    public static function get_reserve_id($stock_id){
      $id =   DB::table('erp_car_reserve')
            ->select('reserve_id')
            ->where('stock_id','=',$stock_id)
            ->orderBy('reserve_id','DESC')
            ->limit(1)
            ->get();
     return $id;
    }

    public static function update_car_reserve_id($data,$resid){
        DB::table('erp_car_reserve')
            ->where('reserve_id','=',$resid)
            ->update($data);
    }

    public static function get_sell_commission($stock_id){
        $data = DB::table('erp_sell_commission_history AS a')
                ->select('a.*','b.full_name')
                ->leftjoin('erp_staff AS b','a.staff_id','=','b.staff_id')
                ->where('stock_id','=',$stock_id)
                ->get();
        return $data;
    }

    public static function get_stock_list_detail_data($stock_id){
        $select = DB::raw("a.*,b.*,c.*,d.*,e.*,f.*,h.*,i.*,j.*,k.*,l.*,fd.final_des_name,m.country_name AS location_name,n.*,o.port_of_loading_name,p.shipping_co_name,r.fob, r.freight_fee, r.other_fee,r.inspection,r.insurance,r.vanning,r.discount,r.currency AS reserved_cur,a.consignee_name AS car_consignee_name,a.consignee_phone AS car_consignee_phone,a.consignee_address AS car_consignee_address,a.consignee_other_info AS car_consignee_other_info,erp_discharge.discharge_name,sb.etd as etd_dubai,sb.eta as eta_dubai,db_dis.discharge_name as dis_dubai,a.stock_id as stockid");
        $query_reserv = "SELECT res.fob,res.freight_fee,res.insurance,res.inspection,res.other_fee,res.created_dt,res.discount,res.stock_id,res.discharge_id, res.currency,res.vanning FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC   ) AS res WHERE res.reserve_id in (SELECT MAX(reserve_id) AS max_id FROM erp_car_reserve WHERE stock_id = ".$stock_id." ) GROUP BY res.stock_id";
        $data = DB::table('erp_stock_list AS a')
                  ->select($select)
                  ->leftjoin('erp_car_make AS b','b.car_make_id','=','a.car_make_id')
                  ->leftjoin('erp_car_model AS c','c.car_model_id','=','a.car_model_id')
                  ->leftjoin('erp_country_list AS d', 'd.country_list_id','=','a.market_country_id')
                  ->leftjoin('erp_stock_list_car_status AS e','e.stock_list_car_status_id','=','a.status')
                  ->leftjoin('erp_stock_type AS f', 'f.stock_type_id','=','a.stock_type_id')
                  ->leftjoin('erp_car_color AS h','h.color_id','=','a.color')
                  ->leftjoin('erp_customer AS i','i.customer_id','=','a.customer_id')
                  ->leftjoin('erp_stock_city_location AS j','j.stock_city_id','=','a.stock_city_id')
                  ->leftjoin('erp_stock_yard_location AS k','k.stock_yard_id','=','a.stock_yard_id')
                  ->leftjoin('erp_stock_country_location AS l','l.stock_location_id','=','a.stock_location_id')
                  ->leftjoin('erp_country_list AS m','m.country_list_id','=','a.stock_location_id')
                  ->leftjoin('erp_shipments AS n','n.shipment_id','=','a.shipment_id')
                  ->leftjoin('erp_shipments_dubai AS sb','sb.shipment_id','=','a.shipment_dubia_id')
                  ->leftjoin('erp_discharge','erp_discharge.discharge_id','=','n.discharge_id')
                  ->leftjoin('erp_discharge AS db_dis','db_dis.discharge_id','=','sb.discharge_id')
                  ->leftjoin('erp_port_of_loading AS o','o.port_of_loading_id','=','n.port_of_loading_id')
                  ->leftjoin('erp_shipping_company AS p','p.shipping_co_id','=','n.shipping_co_id')
                  ->leftjoin(DB::raw('('.$query_reserv.') AS r'),'r.stock_id','=','a.stock_id')
                  ->leftjoin('erp_final_destination AS fd','fd.id','=','r.discharge_id')
                  ->where('a.stock_id','=',$stock_id)
                  ->orderBy('a.stock_id','desc')
                  ->get();
        return $data;
    }
    public static function get_car_expenses_other_fee($expense_id){
        $data = DB::table('erp_car_expenses_other_fee')
                   ->select('*')
                   ->where('car_expense_id','=',$expense_id)
                   ->get();
        return $data;
    }
    public static function get_car_expenses_other_refund($expense_id){
         $data = DB::table('erp_car_expenses_other_refund')
                    ->select('*')
                    ->where('car_expense_id','=',$expense_id)
                    ->get();
        return $data;
    }
    public static function get_sold_price($stock_id){
        $select = "a.*,b.full_name,b.staff_id AS st_id";
        $data = DB::table('erp_stock_list_boss_price AS a')
                   ->select(DB::raw($select))
                   ->leftjoin('erp_staff AS b','a.staff_id','=','b.staff_id')
                   ->where('car_stock_id','=',$stock_id)
                   ->get();
        return $data;
    }
    public static function final_destination_info(){
        $data = DB::table('erp_final_destination')
                   ->select('*')
                   ->orderBy('final_des_name','ASC')
                   ->get();
        return $data;
    }
 
    public static function get_sold_price_distination($stock_id){
        $data = DB::table('erp_car_reserve AS a')
                   ->select('final_des_name','reserve_id','discharge_id')
                   ->leftjoin('erp_final_destination AS b','a.discharge_id','=','b.id')
                   ->where('stock_id','=',$stock_id)
                   ->orderBy('reserve_id','DESC')
                   ->get();
        return $data;
    }

    public static function get_auction_income($stock_id){
        $select = "car_allocate,a.exchange_rate,a.create_date AS allocate_date,a.customer_deposit_id,
        a.expenses_division_id,car_allocate_currency,customer_deposit_type,d.description,allocate_title,full_name,car_allocate_origin,car_allocate_origin_currency,d.deposit_date,d.deposit_income_id,a.exchange_amount,g.description AS description_expense,g.deposit_expense_id";
        $data = DB::table('erp_carpayments AS a')
                ->select(DB::raw($select))
                ->leftjoin('erp_customer_deposit AS b','a.customer_deposit_id','=','b.customer_deposit_id')
                ->leftjoin('erp_deposit_income AS d','d.deposit_income_id','=','b.deposit_income_id')
                ->leftjoin('erp_staff AS e','e.staff_id','=','a.author_id')
                ->leftjoin('erp_expenses_division AS f','f.expenses_division_id','=','a.expenses_division_id')
                ->leftjoin('erp_deposit_expense AS g','g.deposit_expense_id','=','f.deposit_expense_id')
                ->where('a.stock_id','=',$stock_id)
                ->get();
        return $data;
    }

    public static function get_car_expenses_refund_info($expense_id){
        $data = DB::table('erp_car_expenses_other_refund')
                ->select('*')
                ->where('car_expense_id','=',$expense_id)
                ->get();
    }

    public static function get_stock_list_doc($stock_id){
        $data = DB::table('erp_stock_list_doc')
                ->select('*')
                ->where('stock_id','=',$stock_id)
                ->get();
        return  $data;
    }
    public static function add_car_documents_history($data){
        DB::table('erp_car_documents_history')
            ->insert($data);
    }
    public static function select_image_auction($stock_id){
        $data = DB::table('erp_stock_list_photo')
         ->select('*')
         ->where('stock_id','=',$stock_id)
         ->where('photo_type','=','auction_photo')
         ->orderBy('photo_order','ASC')
         ->get();
        return  $data;
    }

    public static function select_image_upload_yard($stock_id){
        $data = DB::table('erp_stock_list_photo')
        ->select('*')
        ->where('stock_id','=',$stock_id)
        ->where('photo_type','=','yard_photo')
        ->orderBy('photo_order','ASC')
        ->get();
       return  $data;
    }
    public static function select_image_upload_yard_two($stock_id){
        $data = DB::table('erp_stock_list_photo')
        ->select('*')
        ->where('stock_id','=',$stock_id)
        ->where('photo_type','=','yard_photo_two')
        ->orderBy('photo_order','ASC')
        ->get();
       return  $data;
    }

    public static function getAllCarDocumentsByStockId($stock_id){
        $data = DB::table('erp_stock_list_doc')
                     ->select('*')
                     ->where('stock_id','=',$stock_id)
                     ->get();
        return $data; 
    }

    public static function country_list(){
        $data = DB::table('erp_stock_country_location AS a')
                    ->select('*')
                    ->leftjoin('erp_country_list AS b','b.country_list_id','=','a.country_list_id')
                    ->get();
        return $data;
    }

    public static function get_car_color(){
        $data = DB::table('erp_car_color')
                    ->select('*')
                    ->where('color_name','<>','')
                    ->orderBy('color_name','ASC')
                    ->get();
        return $data;
    }

    public static function GetStockType(){
        $data = DB::table('erp_stock_type')
                ->select('*')
                ->get();
        return $data;
    }

    public static function get_car_status(){
        $data = DB::table('erp_stock_list_car_status')
                ->select('*')
                ->orderBy('stock_list_car_status_id','ASC')
                ->get();
         return $data;
    }

    public static function discharge_info(){
        $data = DB::table('erp_discharge')
                   ->select('*')
                   ->orderBy('discharge_name','ASC')
                   ->get();
        return $data;
    }

    public static function get_customer_list(){
        $data = DB::table('erp_customer')
                  ->select('*')
                  ->where('full_name','<>','')
                  ->orderBy('full_name','ASC')
                  ->get();
        return $data;
    }
    public static function GetMarketCountry(){
        $data = DB::table('erp_market_country AS a')
                ->select('*')
                ->leftjoin('erp_country_list AS b','b.country_list_id','=','a.country_list_id')
                ->orderBy('b.country_name','ASC')
                ->get();
                return $data;
    }
    public static function get_car_location_country(){
        $data = DB::table('erp_stock_country_location')
                ->select('country_name','stock_location_id','erp_country_list.country_list_id')
                ->leftjoin('erp_country_list','erp_country_list.country_list_id','=','erp_stock_country_location.country_list_id')
                ->get();
        return $data;
    }
    public static function get_car_city(){
        $data = DB::table('erp_stock_city_location')
                ->select('*')
                ->orderBy('stock_city_name','ASC')
                ->get();
        return  $data;
    }
    public static function get_car_yard(){
        $data = DB::table('erp_stock_yard_location')
                ->select('*')
                ->orderBy('stock_yard_name','ASC')
                ->get();
        return  $data;
    }

    public static function GetMake(){
        $data = DB::table('erp_car_make')
                ->select('*')
                ->groupBy('car_make_id')
                ->orderBy('car_make_name','ASC')
                ->get();
        return $data;

    }

    public static function ChangeCarModel($model_id){
        $data = DB::table('erp_car_model')
        ->select('erp_car_model.*')
        ->leftjoin('erp_stock_list','erp_stock_list.car_model_id','=','erp_car_model.car_model_id')
        ->where("erp_car_model.car_make_id",'=',$model_id)
        ->groupBy('erp_car_model.car_model_id')
        ->get();
        return $data;
    }

    public static function count_file_doc($stock_id,$doc_type){
        $data = DB::table('erp_stock_list_doc')
                  ->select(DB::raw('COUNT(*) AS count'))
                  ->where('stock_id','=',$stock_id)
                  ->where('doc_type','=',$doc_type)
                  ->get();
        return $data;
    }

    public static function select_count_file_upload($stock_id,$doc_type){
       $data = DB::table('erp_stock_list_doc')
                 ->select(DB::raw('COUNT(*) AS numrows'))
                 ->where('stock_id','=',$stock_id)
                 ->where('doc_type','=',$doc_type)
                 ->get();
        return $data;
    }

    public static function update_count_file_upload($stock_id,$doc_type,$data){
        DB::table('erp_stock_list_doc')
        ->where('stock_id','=',$stock_id)
        ->where('doc_type','=',$doc_type)
        ->update($data);
    }

    public static function insert_count_file_upload($data) {
        DB::table('erp_stock_list_doc')
          ->insert($data);
    }

    public static function get_stock_id($id){
        $data = DB::table('erp_stock_list')
          ->select('stock_id')
          ->where('shipment_id','=',$id)
          ->get();
        return $data;
    }

    public static function select_car_consignee($customer_id){
        $data = DB::table('erp_consignee')
             ->select('*')
             ->where('customer_id','=',$customer_id)
             ->get();
        return $data;
    }

    public static function select_car_consignee_with_id($id){
        $data = DB::table('erp_consignee')
                ->select('*')
                ->where('consignee_id','=',$id)
                ->get();
        return $data;
    }

    public static function return_car_expense($stock_id){
        $data = DB::table('erp_car_expenses')
                  ->select('*')
                  ->where('stock_id','=',$stock_id)
                  ->get();
        return $data;
    }

    public static function update_car_expense($updata,$car_expense_id){
         DB::table('erp_car_expenses')
           ->where('expenses_division_id',$car_expense_id)
           ->update($updata);
    }

    public static function get_other_fee_by_car_expense_id($car_expense_id){
        $data = DB::table('erp_car_expenses_other_fee')
                ->where('car_expense_id','=',$car_expense_id)
                ->get();
        return $data;
    }

    public static function delete_other_fee($other_fee_id){
        DB::table('erp_car_expenses_other_fee')
          ->where('other_fee_id','=',$other_fee_id)
          ->delete();
    }

    public static function get_other_refund_by_car_expense_id($car_expense_id){
        $data = DB::table('erp_car_expenses_other_refund')
                ->select('*')
                ->where('car_expense_id','=',$car_expense_id)
                ->get();
        return $data;
    }

    public static function delete_other_refund($other_refund_id){
        DB::table('erp_car_expenses_other_refund')
            ->where('other_refund_id','=',$other_refund_id)
            ->delete();
    }

    public static function get_car_payment_by_stock_id($stock_id){
        $data = DB::table('erp_carpayments')
                  ->select('*')
                  ->where('stock_id','=',$stock_id)
                  ->get();
        return $data;
    }

    public static function delete_row_amount_from_payment($car_payment_id){
        DB::table('erp_carpayments')
            ->where('car_payment_id','=',$car_payment_id)
            ->delete();
    }

    public static function deleteCar($stock_id){
        DB::table('erp_stock_list')
          ->where('stock_id','=',$stock_id)
          ->delete();
    }

    public static function save_multi_instrction($stock_id,$data){
        DB::table('erp_stock_list')
           ->where('stock_id','=',$stock_id)
           ->update($data);
    }

    public static function update_instrction_history($data){
        DB::table('erp_instruction_history')
           ->insert($data);
    }

    public static function update_location_car($stock_id,$data){
        DB::table('erp_stock_list')
          ->where('stock_id','=',$stock_id)
          ->update($data);
    }

    public static function add_location_history($data_location){
         DB::table('erp_location_history')  
           ->insert($data_location);
    }

    public static function get_last_location_history($stock_id){
        $data = DB::table('erp_location_history')
                  ->select('stock_city_id')
                  ->where('stock_id','=',$stock_id)
                  ->orderBy('id','DESC')
                  ->limit(1)
                  ->get();
        return $data;
    }

    public static function delete_location_city_Aichi($id,$stock_id){
        DB::table('erp_location_history')
          ->where('stock_city_id','=',$id)
          ->where('stock_id','=',$stock_id)
          ->delete();
    }

    public static function hide_car_on_stock_list($staff_id){
        $status = false;
        $data = DB::table('erp_staff as s')
                  ->select('s.staff_id','s.full_name','c.country_name')
                  ->leftjoin('erp_country_list as c','s.country_list_id','=','c.country_list_id')
                  ->where('s.staff_id','=',$staff_id)
                  ->get();
        if (count($data) > 0) {
            foreach ($data as $key => $value) {
                if ($value->country_name === "Pakistan") {
                    $status = true;
                }
            }
        }
        return $status;
    }

    public static function hide_car_paragay_on_stock_list($staff_id){
        $status = false;
        $data = DB::table('erp_staff as s')
                  ->select('s.staff_id','s.full_name','c.country_name')
                  ->leftjoin('erp_country_list as c','s.country_list_id','=','c.country_list_id')
                  ->where('s.staff_id','=',$staff_id)
                  ->get();
        if (count($data) > 0) {
            foreach ($data as $key => $value) {
                if ($value->country_name === "Paraguay") {
                    $status = true;
                }
            }
        }
        return $status;
    }

    public static function select_customers_for_stock($hide_pakistan,$hide_paragay){
        $show = array();
        if(!empty($hide_pakistan)){
            $country_list = DB::table('erp_block_countries as t1')
                            ->select('t1.*','c.*')
                            ->leftjoin('erp_block_countries as t2','t1.parent_id','=','t2.parent_id')
                            ->leftjoin('erp_country_list as c','t1.country_list_id','=','c.country_list_id')
                            ->groupBy('t1.country_list_id')
                            ->get();
            foreach  ($country_list as $key => $value) {
                    array_push($show, strtolower($value->country_list_id));
            }
        }
        $data = DB::table('erp_customer as a')
                  ->select('a.*')
                  ->leftjoin('erp_staff as b','b.staff_id','=','a.staff_id')
                  ->where('a.active','=',1)
                  ->whereRaw('a.full_name <> ""')
                  ->when(!empty($hide_pakistan),function ($v) use ($show) {
                      $v->whereIn(DB::raw('b.country_list_id'),$show);
                   })
                   ->orderBy('a.full_name','ASC')
                   ->get(); 
        return $data;
    }

    public static function get_shipment_car_info($stock_id){
        $data = DB::table('erp_stock_list as a')
          ->select('*')
          ->leftjoin('erp_shipments as b','a.shipment_id','=','b.shipment_id')
          ->where('stock_id','=',$stock_id)
          ->get();
        return $data;
    }

    public static function get_sale_name($id){
       $data = DB::table('erp_customer as a')
               ->select('b.full_name','b.staff_id')
               ->leftjoin('erp_staff as b','b.staff_id','=','a.staff_id')
               ->where('customer_id','=',$id)
               ->get();
        return $data;
    }

    public static function insert_reserve($data){
        DB::table('erp_car_reserve')
          ->insert($data);
    }

    public static function insert_reserve_history($data){
        DB::table('erp_car_reserve_history')
          ->insert($data);
    }

    public static function insert_reserve_status_history($data_history){
        DB::table('erp_cars_status_history')
          ->insert($data_history);
    }

    public static function update_stock_list_reserve($stock_id,$data){
        DB::table('erp_stock_list')
          ->where('stock_id','=',$stock_id)
          ->update($data);
    }

    public static function get_total_record_excel_allcate($status_join,$where,$where_manul,$rang_date_option = '',$stock_ids){
        $_in_doc_type = " WHERE doc_type IN ('ec','ecj','ece')";
        $his_tbl_filter = DB::raw(" (SELECT * FROM `erp_cars_status_history` WHERE car_status_id IN ( SELECT MAX(car_status_id) FROM `erp_cars_status_history` GROUP BY stock_id) )");
        $bp_tbl_filter = DB::raw("(SELECT * FROM (SELECT * FROM erp_stock_list_boss_price ORDER BY boss_price_id DESC) AS bp GROUP BY car_stock_id) AS bossprice");
        $expense_tbl = DB::raw("(SELECT IFNULL(SUM(repair_fee), 0) AS repair_fee,IFNULL(SUM(buying_price),0) AS buying_price,IFNULL(SUM(auction_fee),0) AS auction_fee,IFNULL(SUM(transportation_fee),0) AS transportation_fee,IFNULL(SUM(freight_fee),0) AS freight_fee,IFNULL(SUM(inspection_fee),0) AS inspection_fee,IFNULL(SUM(insurance_fee),0) AS insurance_fee,IFNULL(SUM(shipping_charge_fee),0) AS shipping_charge_fee ,IFNULL(SUM(rediation_fee),0) AS rediation_fee,IFNULL(SUM(tax_fee),0) AS tax_fee,IFNULL(SUM(car_tax_fee),0) AS car_tax_fee,IFNULL(SUM(recycle_fee),0) AS recycle_fee,IFNULL(SUM(parking_fee), 0) AS parking_fee,IFNULL(SUM(sale_commission), 0) AS sale_commission,IFNULL(SUM(other_fee_amount),0) AS other_fee_amount,IFNULL(SUM(other_cost_amount),0) AS other_cost_amount,IFNULL(SUM(other_refund_amount),0) AS other_refund_amount,currency_type,stock_id FROM ( SELECT buying_price,auction_fee,transportation_fee,freight_fee,inspection_fee,insurance_fee,shipping_charge_fee,rediation_fee,tax_fee,repair_fee,car_tax_fee,recycle_fee,parking_fee,sale_commission,other_fee_amount,other_cost_amount,other_refund_amount,currency_type,stock_id FROM erp_car_expenses AS exp LEFT JOIN (SELECT SUM(amount) AS other_fee_amount,car_expense_id FROM erp_car_expenses_other_fee GROUP BY car_expense_id) AS other_fee ON exp.car_expense_id=other_fee.car_expense_id LEFT JOIN (SELECT SUM(amount) AS other_cost_amount,car_expense_id FROM erp_car_expenses_other_cost GROUP BY car_expense_id) AS other_cost ON exp.car_expense_id=other_cost.car_expense_id LEFT JOIN (SELECT SUM(amount) AS other_refund_amount,car_expense_id FROM erp_car_expenses_other_refund GROUP BY car_expense_id) AS other_refund ON exp.car_expense_id=other_refund.car_expense_id) AS a GROUP BY stock_id) as expense");
        $data = DB::table('erp_stock_list AS a')
                  ->select(DB::raw('cus_con.country_name AS cus_company,sold.created_dt AS reserved_date,sold.total_sold_price,sold.currency AS sold_price_currency ,sh_co.shipping_co_name,disc.discharge_name ,colo.color_name,d.country_name AS country_market,a.*,sh.*,st.full_name as sale_name,cus.full_name AS cus_name ,mo.car_model_name,bossprice.boss_price,bossprice.boss_price_type,bossprice.currency as boss_currency'))
                  ->leftjoin('erp_country_list as d','d.country_list_id','=','a.stock_location_id')
                  ->leftjoin('erp_shipments as sh','sh.shipment_id','=','a.shipment_id')
                  ->leftjoin('erp_discharge as disc','disc.discharge_id','=','sh.discharge_id')
                  ->leftjoin('erp_customer as cus','cus.customer_id','=','a.customer_id')
                  ->leftjoin('erp_country_list as cus_con','cus.country_list_id','=','cus_con.country_list_id')
                  ->leftjoin('erp_staff as st','cus.staff_id','=','st.staff_id')
                  ->leftjoin('erp_shipping_company as sh_co','sh_co.shipping_co_id','=','sh.shipping_co_id')
                  ->leftjoin('erp_stock_city_location as city_location','city_location.stock_city_id','=','a.stock_city_id')
                  ->leftjoin('erp_car_color as colo','colo.color_id','=','a.color')
                  ->leftjoin('erp_car_model as mo','mo.car_model_id','=','a.car_model_id')
                  ->leftjoin($bp_tbl_filter,'bossprice.car_stock_id','=','a.stock_id')
                  ->leftjoin(DB::raw('(SELECT * FROM erp_stock_list_doc '.$_in_doc_type.' GROUP BY stock_id ) as doc'),'doc.stock_id','=','a.stock_id')
                  ->leftjoin('erp_stock_yard_location','erp_stock_yard_location.stock_yard_id','=','a.stock_yard_id')
                  ->leftjoin('erp_shipments_dubai as shd','shd.shipment_id','=','a.shipment_dubia_id')
                  ->leftjoin(DB::raw('(SELECT SUM(car_allocate) AS car_allocate,SUM(IF(car_allocate_origin_currency="USD", car_allocate_origin, 0)) AS sumusd,SUM(IF( car_allocate_origin_currency ="JPY", car_allocate_origin, 0)) AS sumjpy,car_allocate_currency,stock_id,max(dep.deposit_date) AS full_payment_date,max( x.create_date ) AS ls_create_date  FROM erp_carpayments x LEFT JOIN erp_customer_deposit z ON x.customer_deposit_id = z.customer_deposit_id LEFT JOIN erp_deposit_income dep ON dep.deposit_income_id = z.deposit_income_id
                    WHERE (z.customer_deposit_type = "customer_deposit" OR z.customer_deposit_type = "customer_auction_deposit") GROUP BY stock_id) AS pay'),'pay.stock_id','=','a.stock_id',)
                  ->leftjoin(DB::raw('(SELECT (IFNULL(res.fob,0) + IFNULL(res.freight_fee,0) + IFNULL(res.insurance,0) + IFNULL(res.inspection,0)- IFNULL( res.discount, 0 )) AS total_sold_price,res.created_dt,res.stock_id, res.currency FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res GROUP BY res.stock_id) AS sold'),'sold.stock_id','=','a.stock_id')
                  ->when($status_join == "show",function ($v) use ($his_tbl_filter) {
                     $v->leftjoin(DB::raw('('.$his_tbl_filter.') AS his'), 'his.stock_id','=','a.stock_id');
                   })
                  ->when(!empty($where_manul),function ($v) use ($where_manul) {
                    $v->whereRaw(DB::raw($where_manul));
                  })
                  ->when(!empty($where),function ($v) use ($where) {
                    $v->where($where);
                  })
                  ->when(!empty($where) && $rang_date_option == "paid_date",function ($v) use ($where) {
                    $v->where(DB::raw('IFNULL( pay.car_allocate, 0 ) - IFNULL( sold.total_sold_price, 0 ) >= 0 '));
                  })
                  ->when(!empty($stock_ids),function ($v) use ($stock_ids) {
                    $v->whereRaw('a.stock_id IN ('.$stock_ids.')');
                  })
                  ->groupBy('a.car_stock_id')
                  ->orderBy(DB::raw('ISNULL(sold_price_currency), sold_price_currency'))
                  ->get();
        return $data;    
    }

    public static function get_record_excel_car_sold_out($status_join,$where,$where_manul,$rang_date_option = '',$stock_ids){
        $_in_doc_type = " WHERE doc_type IN ('ec','ecj','ece')";
        $his_tbl_filter = DB::raw(" (SELECT * FROM `erp_cars_status_history` WHERE car_status_id IN ( SELECT MAX(car_status_id) FROM `erp_cars_status_history` GROUP BY stock_id) )");
        $bp_tbl_filter = DB::raw("(SELECT * FROM (SELECT * FROM erp_stock_list_boss_price ORDER BY boss_price_id DESC) AS bp GROUP BY car_stock_id) as bossprice");
        $expense_tbl = DB::raw("(SELECT IFNULL(SUM(repair_fee), 0) AS repair_fee,IFNULL(SUM(buying_price),0) AS buying_price,IFNULL(SUM(auction_fee),0) AS auction_fee,IFNULL(SUM(transportation_fee),0) AS transportation_fee,IFNULL(SUM(freight_fee),0) AS freight_fee,IFNULL(SUM(inspection_fee),0) AS inspection_fee,IFNULL(SUM(insurance_fee),0) AS insurance_fee,IFNULL(SUM(shipping_charge_fee),0) AS shipping_charge_fee ,IFNULL(SUM(rediation_fee),0) AS rediation_fee,IFNULL(SUM(tax_fee),0) AS tax_fee,IFNULL(SUM(car_tax_fee),0) AS car_tax_fee,IFNULL(SUM(recycle_fee),0) AS recycle_fee,IFNULL(SUM(parking_fee), 0) AS parking_fee,IFNULL(SUM(sale_commission), 0) AS sale_commission,IFNULL(SUM(other_fee_amount),0) AS other_fee_amount,IFNULL(SUM(other_cost_amount),0) AS other_cost_amount,IFNULL(SUM(other_refund_amount),0) AS other_refund_amount,currency_type,stock_id FROM ( SELECT buying_price,auction_fee,transportation_fee,freight_fee,inspection_fee,insurance_fee,shipping_charge_fee,rediation_fee,tax_fee,repair_fee,car_tax_fee,recycle_fee,parking_fee,sale_commission,other_fee_amount,other_cost_amount,other_refund_amount,currency_type,stock_id FROM erp_car_expenses AS exp LEFT JOIN (SELECT SUM(amount) AS other_fee_amount,car_expense_id FROM erp_car_expenses_other_fee GROUP BY car_expense_id) AS other_fee ON exp.car_expense_id=other_fee.car_expense_id LEFT JOIN (SELECT SUM(amount) AS other_cost_amount,car_expense_id FROM erp_car_expenses_other_cost GROUP BY car_expense_id) AS other_cost ON exp.car_expense_id=other_cost.car_expense_id LEFT JOIN (SELECT SUM(amount) AS other_refund_amount,car_expense_id FROM erp_car_expenses_other_refund GROUP BY car_expense_id) AS other_refund ON exp.car_expense_id=other_refund.car_expense_id) AS a GROUP BY stock_id) as expense");
        $data = DB::table('erp_stock_list as a')
                ->select(DB::raw('a.*,cus_con.country_name AS cus_company,sold.created_dt AS reserved_date,sold.total_sold_price,sold.currency AS sold_price_currency ,sh_co.shipping_co_name,disc.discharge_name ,colo.color_name,d.country_name AS country_market,a.*,sh.*,st.full_name as sale_name,cus.full_name AS cus_name ,mo.car_model_name,bossprice.boss_price,bossprice.boss_price_type,bossprice.currency as boss_currency'))
                ->leftjoin('erp_country_list as d','d.country_list_id','=','a.stock_location_id')
                ->leftjoin('erp_shipments as sh','sh.shipment_id','=','a.shipment_id')
                ->leftjoin('erp_discharge as disc','disc.discharge_id','=','sh.discharge_id')
                ->leftjoin('erp_customer as cus','cus.customer_id','=','a.customer_id')
                ->leftjoin('erp_country_list as cus_con','cus.country_list_id','=','cus_con.country_list_id')
                ->leftjoin('erp_staff as st','cus.staff_id','=','st.staff_id')
                ->leftjoin('erp_shipping_company as sh_co','sh_co.shipping_co_id','=','sh.shipping_co_id')
                ->leftjoin('erp_stock_city_location as city_location','city_location.stock_city_id','=','a.stock_city_id')
                ->leftjoin('erp_car_color as colo','colo.color_id','=','a.color')
                ->leftjoin('erp_car_model as mo','mo.car_model_id','=','a.car_model_id')
                ->leftjoin($bp_tbl_filter,'bossprice.car_stock_id','=','a.stock_id')
                ->leftjoin(DB::raw('(SELECT * FROM erp_stock_list_doc '.$_in_doc_type.' GROUP BY stock_id ) as doc'),'doc.stock_id','=','a.stock_id')
                ->leftjoin('erp_stock_yard_location','erp_stock_yard_location.stock_yard_id','=','a.stock_yard_id')
                ->leftjoin('erp_shipments_dubai as shd','shd.shipment_id','=','a.shipment_dubia_id')
                ->leftjoin(DB::raw('(SELECT SUM(car_allocate) AS car_allocate,SUM(IF(car_allocate_origin_currency="USD", car_allocate_origin, 0)) AS sumusd,SUM(IF( car_allocate_origin_currency ="JPY", car_allocate_origin, 0)) AS sumjpy,car_allocate_currency,stock_id,max(dep.deposit_date) AS full_payment_date,max( x.create_date ) AS ls_create_date  FROM erp_carpayments x LEFT JOIN erp_customer_deposit z ON x.customer_deposit_id = z.customer_deposit_id LEFT JOIN erp_deposit_income dep ON dep.deposit_income_id = z.deposit_income_id
                   WHERE (z.customer_deposit_type = "customer_deposit" OR z.customer_deposit_type = "customer_auction_deposit") GROUP BY stock_id) AS pay'),'pay.stock_id','=','a.stock_id')
                ->leftjoin(DB::raw('(SELECT (IFNULL(res.fob,0) + IFNULL(res.freight_fee,0) + IFNULL(res.insurance,0) + IFNULL(res.inspection,0)- IFNULL( res.discount, 0 )) AS total_sold_price,res.created_dt,res.stock_id, res.currency FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res GROUP BY res.stock_id) AS sold'),'sold.stock_id','=','a.stock_id')
                ->when($status_join == "show",function ($v) use ($his_tbl_filter) {
                    $v->leftjoin(DB::raw('('.$his_tbl_filter.') AS his'), 'his.stock_id','=','a.stock_id');
                  })
                 ->when(!empty($where_manul),function ($v) use ($where_manul) {
                   $v->whereRaw(DB::raw($where_manul));
                  })
                 ->when(!empty($where),function ($v) use ($where) {
                   $v->where($where);
                  })
                  ->when(!empty($where) && $rang_date_option == "paid_date",function ($v) use ($where) {
                    $v->where(DB::raw('IFNULL( pay.car_allocate, 0 ) - IFNULL( sold.total_sold_price, 0 ) >= 0 '));
                  })
                  ->when(!empty($stock_ids),function ($v) use ($stock_ids) {
                    $v->whereRaw('a.stock_id IN ('.$stock_ids.')');
                  })
                ->groupBy('a.car_stock_id')
                ->orderBy('a.status','ASC')
                ->orderBy('a.buying_date','DESC')
                ->get();
            return $data;
    }  
    
    public static function get_total_income_excel($stock_id){
        $data = DB::table('erp_carpayments as a')
                 ->select(DB::raw("SUM(car_allocate) as total_allocate,car_allocate_origin_currency"))
                 ->leftjoin('erp_customer_deposit as b','a.customer_deposit_id','=','b.customer_deposit_id')
                 ->leftjoin('erp_deposit_income as d','d.deposit_income_id','=','b.deposit_income_id')
                 ->where('a.stock_id','=',$stock_id)
                 ->whereRaw(' (b.customer_deposit_type = "customer_deposit" OR b.customer_deposit_type = "customer_auction_deposit")')
                 ->get();
        if(COUNT($data) > 0){
            if($data[0]->car_allocate_origin_currency == "USD"){
                $currency = '$';
                $total_allocate = $currency.' '.number_format($data[0]->total_allocate,2);
               }else{
                $currency = '¥';
                $total_allocate = $currency.' '.number_format($data[0]->total_allocate);
               }
            return $total_allocate;
        }else{
            return 0;
        }

    }

    public static function get_auction_income_excel($stock_id){
        $data = DB::table('erp_carpayments as a')
                  ->select(DB::raw('car_allocate,a.customer_deposit_id,
                    car_allocate_currency,customer_deposit_type,d.description,car_allocate_origin,car_allocate_origin_currency,d.deposit_date,a.stock_id'))
                  ->leftjoin('erp_customer_deposit as b','a.customer_deposit_id','=','b.customer_deposit_id')
                  ->leftjoin('erp_deposit_income as d','d.deposit_income_id','=','b.deposit_income_id')
                  ->where('a.stock_id','=',$stock_id)
                  ->whereRaw(' (b.customer_deposit_type = "customer_deposit" OR b.customer_deposit_type = "customer_auction_deposit")')
                  ->get();
        return $data;
    }

    public static function get_data_car_allocate($id){
        $data = DB::table('erp_carpayments')
                ->select(DB::raw('*,dep.description AS des_income'))
                ->leftjoin('erp_customer_deposit','erp_customer_deposit.customer_deposit_id','=','erp_carpayments.customer_deposit_id')
                ->leftjoin('erp_deposit_income AS dep','dep.deposit_income_id','=','erp_customer_deposit.deposit_income_id')
                ->whereRaw(DB::raw("(erp_customer_deposit.customer_deposit_type = 'customer_deposit' OR erp_customer_deposit.customer_deposit_type='customer_auction_deposit') AND stock_id =".$id.""))
                ->orderBy('car_payment_id',"ASC")
                ->get();
        return $data;
    }

    public static function get_transport_excel_data($status_join,$where,$where_manul,$rang_date_option = '',$stock_ids){
        $his_tbl_filter = " (SELECT * FROM `erp_cars_status_history` WHERE car_status_id IN ( SELECT MAX(car_status_id) FROM `erp_cars_status_history` GROUP BY stock_id) )";
        $data = DB::table('erp_stock_list as a')
                ->leftjoin('erp_country_list as d','d.country_list_id','=','a.market_country_id')
                ->leftjoin('erp_shipments as sh','sh.shipment_id','=','a.shipment_id')
                ->leftjoin('erp_shipments_dubai as shd','shd.shipment_id','=','a.shipment_dubia_id')
                ->leftjoin('erp_car_make','erp_car_make.car_make_id','=','a.car_make_id')
                ->leftjoin('erp_car_model','erp_car_model.car_model_id','=','a.car_model_id')
                ->leftjoin('erp_customer as cus','cus.customer_id','=','a.customer_id')
                ->leftjoin('erp_stock_yard_location','erp_stock_yard_location.stock_yard_id','=','a.stock_yard_id')
                ->leftjoin('erp_auction_transport as ats','a.auction_supplier','=','ats.auction_house')
                ->when($status_join == "show",function ($v) use ($his_tbl_filter) {
                    $v->leftjoin(DB::raw('('.$his_tbl_filter.') AS his'), 'his.stock_id','=','a.stock_id');
                  })
                 ->when(!empty($where_manul),function ($v) use ($where_manul) {
                   $v->whereRaw(DB::raw($where_manul));
                  })
                 ->when(!empty($where),function ($v) use ($where) {
                   $v->where($where);
                  })
                  ->when(!empty($stock_ids),function ($v) use ($stock_ids) {
                    $v->whereRaw('a.stock_id IN ('.$stock_ids.')');
                  })
                ->groupBy('a.stock_id')
                ->orderBy('a.status','ASC')
                ->orderBy('a.buying_date','DESC')
                ->get();
            return $data;
    }

    // public static function get_total_record_excel($status_join,$where,$where_manul,$rang_date_option = '',$stock_ids,$to_hide){
    //     $_in_doc_type = " WHERE doc_type IN ('ec','ecj','ece')";
    //     $his_tbl_filter = DB::raw(" (SELECT * FROM `erp_cars_status_history` WHERE car_status_id IN ( SELECT MAX(car_status_id) FROM `erp_cars_status_history` GROUP BY stock_id) )");
    //     $bp_tbl_filter = DB::raw("(SELECT * FROM (SELECT * FROM erp_stock_list_boss_price ORDER BY boss_price_id DESC) AS bp GROUP BY car_stock_id) as bossprice");
    //     $expense_tbl = DB::raw("(SELECT IFNULL(SUM(repair_fee), 0) AS repair_fee,IFNULL(SUM(buying_price),0) AS buying_price,IFNULL(SUM(auction_fee),0) AS auction_fee,IFNULL(SUM(transportation_fee),0) AS transportation_fee,IFNULL(SUM(freight_fee),0) AS freight_fee,IFNULL(SUM(inspection_fee),0) AS inspection_fee,IFNULL(SUM(insurance_fee),0) AS insurance_fee,IFNULL(SUM(shipping_charge_fee),0) AS shipping_charge_fee ,IFNULL(SUM(rediation_fee),0) AS rediation_fee,IFNULL(SUM(tax_fee),0) AS tax_fee,IFNULL(SUM(car_tax_fee),0) AS car_tax_fee,IFNULL(SUM(recycle_fee),0) AS recycle_fee,IFNULL(SUM(parking_fee), 0) AS parking_fee,IFNULL(SUM(sale_commission), 0) AS sale_commission,IFNULL(SUM(other_fee_amount),0) AS other_fee_amount,IFNULL(SUM(other_cost_amount),0) AS other_cost_amount,IFNULL(SUM(other_refund_amount),0) AS other_refund_amount,currency_type,stock_id FROM ( SELECT buying_price,auction_fee,transportation_fee,freight_fee,inspection_fee,insurance_fee,shipping_charge_fee,rediation_fee,tax_fee,repair_fee,car_tax_fee,recycle_fee,parking_fee,sale_commission,other_fee_amount,other_cost_amount,other_refund_amount,currency_type,stock_id FROM erp_car_expenses AS exp LEFT JOIN (SELECT SUM(amount) AS other_fee_amount,car_expense_id FROM erp_car_expenses_other_fee GROUP BY car_expense_id) AS other_fee ON exp.car_expense_id=other_fee.car_expense_id LEFT JOIN (SELECT SUM(amount) AS other_cost_amount,car_expense_id FROM erp_car_expenses_other_cost GROUP BY car_expense_id) AS other_cost ON exp.car_expense_id=other_cost.car_expense_id LEFT JOIN (SELECT SUM(amount) AS other_refund_amount,car_expense_id FROM erp_car_expenses_other_refund GROUP BY car_expense_id) AS other_refund ON exp.car_expense_id=other_refund.car_expense_id) AS a GROUP BY stock_id) as expense");
    //     $data = DB::table('erp_stock_list as a')
    //               ->select(DB::raw('cus_con.country_name AS cus_company,sold.created_dt AS reserved_date,sold.total_sold_price,sold.currency AS sold_price_currency ,sh_co.shipping_co_name,disc.discharge_name ,colo.color_name,d.country_name AS country_market,a.*,sh.*,st.full_name as sale_name,cus.full_name AS cus_name ,mo.car_model_name,bossprice.boss_price,bossprice.boss_price_type,bossprice.currency as boss_currency'))
    //               ->leftjoin('erp_country_list as d','d.country_list_id','=','a.stock_location_id')
    //               ->leftjoin('erp_shipments as sh','sh.shipment_id','=','a.shipment_id')
    //               ->leftjoin('erp_discharge as disc','disc.discharge_id','=','sh.discharge_id')
    //               ->leftjoin('erp_customer as cus','cus.customer_id','=','a.customer_id')
    //               ->leftjoin('erp_country_list as cus_con','cus.country_list_id','=','cus_con.country_list_id')
    //               ->leftjoin('erp_staff as st','cus.staff_id','=','st.staff_id')
    //               ->leftjoin('erp_shipping_company as sh_co','sh_co.shipping_co_id','=','sh.shipping_co_id')
    //               ->leftjoin('erp_stock_city_location as city_location','city_location.stock_city_id','=','a.stock_city_id')
    //               ->leftjoin('erp_car_color as colo','colo.color_id','=','a.color')
    //               ->leftjoin('erp_car_model as mo','mo.car_model_id','=','a.car_model_id')
    //               ->leftjoin($bp_tbl_filter,'bossprice.car_stock_id','=','a.stock_id')
    //               ->leftjoin(DB::raw('(SELECT * FROM erp_stock_list_doc '.$_in_doc_type.' GROUP BY stock_id ) as doc'),'doc.stock_id','=','a.stock_id')
    //               ->leftjoin('erp_stock_yard_location','erp_stock_yard_location.stock_yard_id','=','a.stock_yard_id')
    //               ->leftjoin('erp_shipments_dubai as shd','shd.shipment_id','=','a.shipment_dubia_id')
    //               ->leftjoin(DB::raw('(SELECT SUM(car_allocate) AS car_allocate,SUM(IF(car_allocate_origin_currency="USD", car_allocate_origin, 0)) AS sumusd,SUM(IF( car_allocate_origin_currency ="JPY", car_allocate_origin, 0)) AS sumjpy,car_allocate_currency,stock_id,max(dep.deposit_date) AS full_payment_date,max( x.create_date ) AS ls_create_date  FROM erp_carpayments x LEFT JOIN erp_customer_deposit z ON x.customer_deposit_id = z.customer_deposit_id LEFT JOIN erp_deposit_income dep ON dep.deposit_income_id = z.deposit_income_id
    //                  WHERE (z.customer_deposit_type = "customer_deposit" OR z.customer_deposit_type = "customer_auction_deposit") GROUP BY stock_id) AS pay'),'pay.stock_id','=','a.stock_id')
    //               ->leftjoin(DB::raw('(SELECT (IFNULL(res.fob,0) + IFNULL(res.freight_fee,0) + IFNULL(res.insurance,0) + IFNULL(res.inspection,0)- IFNULL( res.discount, 0 )) AS total_sold_price,res.created_dt,res.stock_id, res.currency FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res GROUP BY res.stock_id) AS sold'),'sold.stock_id', '=','a.stock_id')
    //               ->when($status_join == "show",function ($v) use ($his_tbl_filter) {
    //                 $v->leftjoin(DB::raw('('.$his_tbl_filter.') AS his'), 'his.stock_id','=','a.stock_id');
    //               })
                //  ->when(!empty($where_manul),function ($v) use ($where_manul) {
                //    $v->whereRaw(DB::raw($where_manul));
                //   })
                //  ->when(!empty($where),function ($v) use ($where) {
                //    $v->where($where);
                //   })
                //   ->when(!empty($where) && $rang_date_option == "paid_date",function ($v) use ($where) {
                //     $v->where(DB::raw('IFNULL( pay.car_allocate, 0 ) - IFNULL( sold.total_sold_price, 0 ) >= 0 '));
                //   })
                //   ->when(!empty($stock_ids),function ($v) use ($stock_ids) {
                //     $v->whereRaw('a.stock_id IN ('.$stock_ids.')');
                //   })
    //             ->groupBy('a.car_stock_id')
    //             ->orderBy(DB::raw('ISNULL(sold_price_currency), sold_price_currency'))
    //             ->toRawSql();
    //             dd($data);
    //         return $data;
    // }

    public static function get_total_record_excel($status_join,$where,$where_manul,$rang_date_option = '',$stock_ids,$to_hide){
        $show_car_for_paragay = "";
        $his_tbl_filter = DB::raw(" (SELECT * FROM `erp_cars_status_history` WHERE car_status_id IN ( SELECT MAX(car_status_id) FROM `erp_cars_status_history` GROUP BY stock_id) )");
        $expense_tbl = DB::raw("(SELECT IFNULL(SUM(IF(currency_type='USD', repair_fee*exchange_rate,repair_fee)), 0) AS repair_fee,
        IFNULL(SUM(IF(currency_type='USD', buying_price*exchange_rate,buying_price)), 0) AS buying_price,
        IFNULL(SUM(IF(currency_type='USD', auction_fee*exchange_rate,auction_fee)), 0) AS auction_fee,
        IFNULL(SUM(IF(currency_type='USD', transportation_fee*exchange_rate,transportation_fee)), 0) AS transportation_fee,
        IFNULL(SUM(IF(currency_type='USD', freight_fee*exchange_rate,freight_fee)), 0) AS freight_fee,
        IFNULL(SUM(IF(currency_type='USD', inspection_fee*exchange_rate,inspection_fee)), 0) AS inspection_fee,
        IFNULL(SUM(IF(currency_type='USD', insurance_fee*exchange_rate,insurance_fee)), 0) AS insurance_fee,
        IFNULL(SUM(IF(currency_type='USD', shipping_charge_fee*exchange_rate,shipping_charge_fee)), 0) AS shipping_charge_fee,
        IFNULL(SUM(IF(currency_type='USD', rediation_fee*exchange_rate,rediation_fee)), 0) AS rediation_fee,
        IFNULL(SUM(IF(currency_type='USD', tax_fee*exchange_rate,tax_fee)), 0) AS tax_fee,
        IFNULL(SUM(IF(currency_type='USD', car_tax_fee*exchange_rate,car_tax_fee)), 0) AS car_tax_fee,
        IFNULL(SUM(IF(currency_type='USD', recycle_fee*exchange_rate,recycle_fee)), 0) AS recycle_fee,
        IFNULL(SUM(IF(currency_type='USD', ea_fee*exchange_rate,ea_fee)), 0) AS ea_fee,
        IFNULL(SUM(IF(other_fee_currency='USD', other_fee_amount*exchange_rate,other_fee_amount)), 0) AS other_fee_amount,
        IFNULL(SUM(IF(currency_type='USD', other_refund_amount*exchange_rate,other_refund_amount)), 0) AS other_refund_amount,
        currency_type,
        IFNULL(SUM(repair_fee),0) AS repair_fee_ori,
        IFNULL(SUM(buying_price),0) AS buying_price_ori,
        IFNULL(SUM(auction_fee),0) AS auction_fee_ori,
        IFNULL(SUM(transportation_fee),0) AS transportation_fee_ori,
        IFNULL(SUM(freight_fee),0) AS freight_fee_ori,
        IFNULL(SUM(inspection_fee),0) AS inspection_fee_ori,
        IFNULL(SUM(insurance_fee),0) AS insurance_fee_ori,
        IFNULL(SUM(shipping_charge_fee),0) AS shipping_charge_fee_ori,
        IFNULL(SUM(rediation_fee),0) AS rediation_fee_ori,
        IFNULL(SUM(tax_fee),0) AS tax_fee_ori,
        IFNULL(SUM(car_tax_fee),0) AS car_tax_fee_ori,
        IFNULL(SUM(recycle_fee),0) AS recycle_fee_ori,
        IFNULL(SUM(ea_fee),0) AS ea_fee_ori,
        IFNULL(SUM(other_fee_amount),0) AS other_fee_amount_ori,
        IFNULL(SUM(other_refund_amount),0) AS other_refund_amount_ori,
        stock_id,
        exchange_rate,
        other_fee_currency FROM ( SELECT buying_price,auction_fee,transportation_fee,freight_fee,inspection_fee,insurance_fee,shipping_charge_fee,rediation_fee,tax_fee,repair_fee,car_tax_fee,recycle_fee,other_fee_amount,other_refund_amount,currency_type,stock_id,exchange_rate,
        other_fee_currency,ea_fee FROM erp_car_expenses AS exp LEFT JOIN (SELECT SUM(amount) AS other_fee_amount,car_expense_id,currency_type AS other_fee_currency FROM erp_car_expenses_other_fee GROUP BY car_expense_id) AS other_fee ON exp.car_expense_id=other_fee.car_expense_id LEFT JOIN (SELECT SUM(amount) AS other_refund_amount,car_expense_id FROM erp_car_expenses_other_refund GROUP BY car_expense_id) AS other_refund ON exp.car_expense_id=other_refund.car_expense_id) AS a GROUP BY stock_id) as expense");
        $data = DB::table('erp_stock_list as a')
                ->select(DB::raw("sold.created_dt AS reserved_date,sold.total_sold_price,sold.currency AS sold_price_currency ,sh_co.shipping_co_name,disc.discharge_name ,
                        IF (m.country_name = 'Japan',`expense`.`repair_fee`,`expense`.`repair_fee_ori`) AS repair_fee,
                        `expense`.`currency_type` AS `expense_cur`,
                        IF (m.country_name = 'Japan',`expense`.`buying_price`,`expense`.`buying_price_ori`) AS buying_price,
                        IF (m.country_name = 'Japan',`expense`.`auction_fee`,`expense`.`auction_fee_ori`) AS auction_fee,
                        IF (m.country_name = 'Japan',`expense`.`freight_fee`,`expense`.`freight_fee_ori`) AS freight_fee,
                        IF (m.country_name = 'Japan',`expense`.`inspection_fee`,`expense`.`inspection_fee_ori`) AS inspection_fee,
                        IF (m.country_name = 'Japan',`expense`.`insurance_fee`,`expense`.`insurance_fee_ori`) AS insurance_fee,
                        IF (m.country_name = 'Japan',`expense`.`shipping_charge_fee`,`expense`.`shipping_charge_fee_ori`) AS shipping_charge_fee,
                        IF (m.country_name = 'Japan',`expense`.`recycle_fee`,`expense`.`recycle_fee_ori`) AS recycle_fee,
                        IF (m.country_name = 'Japan',`expense`.`tax_fee`,`expense`.`tax_fee_ori`) AS tax_fee,
                        IF (m.country_name = 'Japan',`expense`.`car_tax_fee`,`expense`.`car_tax_fee_ori`) AS car_tax_fee,
                        IF (m.country_name = 'Japan',`expense`.`rediation_fee`,`expense`.`rediation_fee_ori`) AS rediation_fee,
                        IF (m.country_name = 'Japan',`expense`.`other_fee_amount`,`expense`.`other_fee_amount_ori`) AS other_fee_amount,
                        IF (m.country_name = 'Japan',`expense`.`other_refund_amount`,`expense`.`other_refund_amount_ori`) AS other_refund_amount,
                        IF (m.country_name = 'Japan',`expense`.`transportation_fee`,`expense`.`transportation_fee_ori`) AS transportation_fee,
                        IF (m.country_name = 'Japan',`expense`.`ea_fee`,`expense`.`ea_fee_ori`) AS ea_fee,
                        exchange_rate,other_fee_currency,pay.car_allocate,pay.sumjpy,pay.sumusd,pay.car_allocate_currency,colo.color_name,d.country_name AS country_market,a.*,sh.*,st.full_name as sale_name,m.country_name AS location_name,sh_dubai.vessel_name as dubai_vessel,sh_dubai.eta as dubai_eta,sh_dubai.etd as dubai_etd,dubai_doc.id as bl_dubai,cus.full_name AS customer_name"))
                ->leftjoin('erp_country_list as d','d.country_list_id','=','a.market_country_id')
                ->leftjoin('erp_shipments as sh','sh.shipment_id','=','a.shipment_id')
                ->leftjoin('erp_shipments_dubai as sh_dubai','sh_dubai.shipment_id','=','a.shipment_dubia_id')
                ->leftjoin('erp_discharge as disc','disc.discharge_id','=','sh.discharge_id')
                ->leftjoin('erp_customer as cus','cus.customer_id','=','a.customer_id')
                ->leftjoin('erp_staff as st','cus.staff_id','=','st.staff_id')
                ->leftjoin('erp_shipping_company as sh_co','sh_co.shipping_co_id','=','sh.shipping_co_id')
                ->leftjoin('erp_stock_city_location as city_location','city_location.stock_city_id','=','a.stock_city_id')
                ->leftjoin('erp_car_color as colo','colo.color_id','=','a.color')
                ->leftjoin('erp_stock_country_location as l','l.stock_location_id','=','a.stock_location_id')
                ->leftjoin('erp_country_list as m','m.country_list_id','=','a.stock_location_id')
                ->leftjoin(DB::raw('(SELECT SUM(car_allocate) AS car_allocate,SUM(IF(car_allocate_origin_currency="USD", car_allocate_origin, 0)) AS sumusd,SUM(IF( car_allocate_origin_currency ="JPY", car_allocate_origin, 0)) AS sumjpy,car_allocate_currency,stock_id FROM erp_carpayments x LEFT JOIN erp_customer_deposit z ON x.customer_deposit_id = z.customer_deposit_id WHERE z.customer_deposit_type = "customer_deposit" GROUP BY stock_id) AS pay'),'pay.stock_id','=','a.stock_id')
                ->leftjoin(DB::raw('(SELECT id,stock_id FROM erp_stock_list_doc WHERE doc_type="bl_dubai") AS dubai_doc'),'dubai_doc.stock_id','=','a.car_stock_id')
                ->leftjoin($expense_tbl,'expense.stock_id','=','a.stock_id')
                ->leftjoin(DB::raw('(SELECT (IFNULL(res.fob,0) + IFNULL(res.freight_fee,0) + IFNULL(res.vanning,0) + IFNULL(res.insurance,0) + IFNULL(res.inspection,0) + IFNULL(res.other_fee,0) - IFNULL( res.discount, 0 )) AS total_sold_price,res.created_dt,res.stock_id, res.currency FROM ( SELECT * FROM erp_car_reserve ORDER BY reserve_id DESC ) AS res GROUP BY res.stock_id) AS sold'),'sold.stock_id','=','a.stock_id')
                ->when($status_join == "show",function ($v) use ($his_tbl_filter) {
                    $v->leftjoin(DB::raw('('.$his_tbl_filter.') AS his'), 'his.stock_id','=','a.stock_id');
                })
                ->when(!empty($where_manul),function ($v) use ($where_manul) {
                    $v->whereRaw(DB::raw($where_manul));
                })
                ->when(!empty($where),function ($v) use ($where) {
                $v->where($where);
                })
                ->when(!empty($stock_ids),function ($v) use ($stock_ids) {
                    $v->whereRaw('a.stock_id IN ('.$stock_ids.')');
                })
                ->groupBy('a.stock_id')
                ->orderBy('a.status','ASC')
                ->orderBy('a.buying_date','DESC')
                ->get();
                return $data;

    }

    public static function get_country_list_id_block(){
        $country_list = DB::table('erp_block_countries as t1')
                    ->select('t1.*','c.*')
                    ->leftjoin('erp_block_countries as t2','t1.parent_id','=','t2.parent_id')
                    ->leftjoin('erp_country_list as c','t1.country_list_id','=','c.country_list_id')
                    ->groupBy('t1.country_list_id')
                    ->get();
        return $country_list;
    }

    public static function get_count_doc_by_type($type,$stock_id){
        $data = DB::table('erp_stock_list_doc')
                ->select(DB::raw('COUNT(*) AS num_rows'))
                ->where('stock_id','=',$stock_id)
                ->where('doc_type','=',$type)
                ->get();
                if(COUNT($data) > 0){
                    return  $data[0]->num_rows;
                }else{
                    return $data;
                }
        
    }

    public static function get_car_auction_income($stock_id){
         $data = DB::table('erp_carpayments')
                   ->select(DB::raw('SUM(car_allocate) AS total_allocate,car_allocate_currency'))
                   ->leftjoin('erp_customer_deposit','erp_customer_deposit.customer_deposit_id','=','erp_carpayments.customer_deposit_id')
                   ->whereRaw("(erp_customer_deposit.customer_deposit_type <> 'customer_deposit' OR erp_customer_deposit.customer_deposit_type IS NULL) AND stock_id=".$stock_id."")
                   ->groupBy('stock_id')
                   ->get();
         return $data;
    }

    public static function get_forwarding($status_join,$where,$where_manul,$rang_date_option = '',$stock_ids){
        $his_tbl_filter = DB::raw(" (SELECT * FROM `erp_cars_status_history` WHERE car_status_id IN ( SELECT MAX(car_status_id) FROM `erp_cars_status_history` GROUP BY stock_id) )");
        $data = DB::table('erp_stock_list as a')
         ->select(DB::raw("sh.etd,sh.vessel_name,k.stock_yard_name,city_location.stock_city_name,sh_co.shipping_co_name,disc.discharge_name ,colo.color_name,d.country_name AS country_market,a.*,sh.*,st.full_name as sale_name,m.country_name AS location_name,sh_dubai.vessel_name as dubai_vessel,sh_dubai.eta as dubai_eta,sh_dubai.etd as dubai_etd,ec.id as ec_file,cus.full_name AS customer_name"))
         ->leftjoin('erp_country_list as d','d.country_list_id','=','a.market_country_id')
         ->leftjoin('erp_shipments as sh','sh.shipment_id','=','a.shipment_id')
         ->leftjoin('erp_shipments_dubai as sh_dubai','sh_dubai.shipment_id','=','a.shipment_dubia_id')
         ->leftjoin('erp_discharge as disc','disc.discharge_id','=','sh.discharge_id')
         ->leftjoin('erp_customer as cus','cus.customer_id','=','a.customer_id')
         ->leftjoin('erp_staff as st','cus.staff_id','=','st.staff_id')
         ->leftjoin('erp_shipping_company as sh_co','sh_co.shipping_co_id','=','sh.shipping_co_id')
         ->leftjoin('erp_stock_city_location as city_location','city_location.stock_city_id','=','a.stock_city_id')
         ->leftjoin('erp_stock_yard_location as k','k.stock_yard_id','=','a.stock_yard_id')
         ->leftjoin('erp_car_color as colo','colo.color_id','=','a.color')
         ->leftjoin('erp_stock_country_location as l','l.stock_location_id','=','a.stock_location_id')
         ->leftjoin('erp_country_list as m','m.country_list_id','=','a.stock_location_id')
         ->leftjoin(DB::raw('(SELECT id,stock_id FROM erp_stock_list_doc WHERE doc_type="ec") AS ec'),'ec.stock_id','=','a.car_stock_id')
         ->when($status_join == "show",function ($v) use ($his_tbl_filter) {
            $v->leftjoin(DB::raw('('.$his_tbl_filter.') AS his'), 'his.stock_id','=','a.stock_id');
            })
            ->when(!empty($where_manul),function ($v) use ($where_manul) {
                $v->whereRaw(DB::raw($where_manul));
            })
            ->when(!empty($where),function ($v) use ($where) {
            $v->where($where);
            })
            ->when(!empty($stock_ids),function ($v) use ($stock_ids) {
                $v->whereRaw('a.stock_id IN ('.$stock_ids.')');
            })
        ->groupBy('a.stock_id')
        ->orderBy('a.status','ASC')
        ->orderBy('a.buying_date','DESC')
        ->get();
        return $data;
    }

    public static function country_for_cbm(){
        $data = DB::table('erp_car_price_cbm')
                  ->select('*')
                  ->leftjoin('erp_country_list','erp_country_list.country_list_id','=','erp_car_price_cbm.country_id')
                  ->groupBy('country_id')
                  ->get();
        return $data;
    }

    public static function get_sold_price_from_reserve($stock_id){
        $data = DB::table('erp_car_reserve')
                  ->select(DB::raw('MAX(reserve_id),fob, freight_fee,currency, inspection, insurance,vanning, created_dt'))
                  ->where('stock_id','=',$stock_id)
                  ->groupBy('stock_id')
                  ->get();
        return $data;
    }

    public static function get_car_income($stock_id){
        $data = DB::table('erp_carpayments')
                  ->select(DB::raw('SUM(exchange_amount)AS total_allocate,car_allocate_currency'))
                  ->leftjoin('erp_customer_deposit','erp_customer_deposit.customer_deposit_id','=','erp_carpayments.customer_deposit_id')
                  ->whereRaw("erp_customer_deposit.customer_deposit_type='customer_deposit' AND stock_id=".$stock_id."")
                  ->groupBy('stock_id')
                  ->get();
        return $data;
    }

    public static function get_model_size_stocklist(){
        $data= DB::table('erp_car_model_size')
                  ->select('*')
                  ->get();
        return $data;
    }

    public static function get_cbm_value($coutry,$port){
        $data = DB::table('erp_car_price_cbm')
                  ->select('*')
                  ->where('country_id','=',$coutry)
                  ->where('port_name','=',$port)
                  ->get();
        return $data;
    }

    public static function data_group_user($id){
        $data = DB::table('users_groups AS a')
          ->select('b.name')
          ->leftjoin('groups AS b','b.id','a.group_id')
          ->where('a.staff_id','=',$id)
          ->get();
          return $data;
     }

     public static function get_car_list_proforma($stock_ids){
        $data = DB::table('erp_stock_list AS a')
                  ->select('*')
                  ->leftjoin('erp_car_make as b','b.car_make_id','=','a.car_make_id')
                  ->leftjoin('erp_customer as g','g.customer_id','=','a.customer_id')
                  ->whereRaw('a.stock_id IN ('.$stock_ids.')')
                  ->orderBy('a.stock_id','ASC')
                  ->get();
        return $data;
     }

     public static function get_total_income($stock_ids){
        $data = DB::table('erp_carpayments as a')
                  ->select(DB::raw('car_allocate,exchange_rate,a.create_date AS allocate_date,car_allocate_currency,customer_deposit_type,description,allocate_title,full_name,car_allocate_origin,car_allocate_origin_currency,d.deposit_date'))
                  ->leftjoin('erp_customer_deposit as b','a.customer_deposit_id','=','b.customer_deposit_id')
                  ->leftjoin('erp_deposit_income as d','d.deposit_income_id','=','b.deposit_income_id')
                  ->leftjoin('erp_staff as e','e.staff_id','=','a.author_id')
                  ->whereRaw('a.stock_id IN ('.$stock_ids.')')
                  ->get();
        return $data;
     }

     public static function  insert_proforma_invoice($data){
        $return_id = DB::table('erp_invoice')
                       ->insertGetId($data);
        return $return_id;
     }

     public static function update_stock_list_invoice($stock_ids,$invoice_id){
        $data['invoice_id'] = $invoice_id;
        DB::table('erp_stock_list')
          ->whereRaw('stock_id IN ('.$stock_ids.')')
          ->update($data);
     }

     public static function history_invoice($data_history)
     {
        DB::table('invoice_history')
           ->insert($data_history);
     }
    public static function insert_reserve_sold_price($data){
        DB::table('erp_car_reserve')
          ->insert($data);
    }
    public static function insert_reserve_history_sold_price($data){
        DB::table('erp_car_reserve_history')
          ->insert($data);
    }

    public static function update_stock_list_editsoldprince($stock_id,$data){
        DB::table('erp_stock_list')
            ->where('stock_id','=',$stock_id)
            ->update($data);
    }
}
