import { inject as H, defineComponent as g, ref as $, computed as D, watch as T, onBeforeMount as K, onBeforeUnmount as E, withDirectives as B, openBlock as b, createElementBlock as p, unref as M, normalizeClass as v, renderSlot as L, vShow as U, reactive as j, provide as h, onMounted as F, toRefs as N, createElementVNode as C, Fragment as O, renderList as P } from "vue";
const x = Symbol("addTab"), k = Symbol("updateTab"), y = Symbol("deleteTab"), A = Symbol("tabsProvider");
function m(n, c) {
  const a = H(n, c);
  if (typeof a > "u")
    throw new Error(`Could not resolve ${n.description}`);
  return a;
}
const J = ["data-tab-id", "aria-hidden"], W = /* @__PURE__ */ g({
  __name: "Tab",
  props: {
    panelClass: { default: "tabs-component-panel" },
    id: { default: void 0 },
    name: null,
    prefix: { default: "" },
    suffix: { default: "" },
    isDisabled: { type: Boolean, default: !1 },
    navItemClass: { default: void 0 },
    navItemLinkClass: { default: void 0 }
  },
  setup(n, { expose: c }) {
    const a = n, i = $(!1), s = m(A), u = m(x), d = m(k), r = m(y), t = a.prefix + a.name + a.suffix, l = a.id ? a.id : a.name.toLowerCase().replace(/ /g, "-"), e = l + "-pane", o = D(() => "#" + (a.isDisabled ? "" : l));
    return T(
      () => s.activeTabHash,
      () => {
        i.value = o.value === s.activeTabHash;
      }
    ), T(
      () => Object.assign({}, a),
      () => {
        d(l, {
          name: a.name,
          header: a.prefix + a.name + a.suffix,
          isDisabled: a.isDisabled,
          hash: o.value,
          index: s.tabs.length,
          computedId: l,
          paneId: e,
          navItemClass: a.navItemClass,
          navItemLinkClass: a.navItemLinkClass
        });
      }
    ), K(() => {
      u({
        name: a.name,
        header: t,
        isDisabled: a.isDisabled,
        hash: o.value,
        index: s.tabs.length,
        computedId: l,
        paneId: e,
        navItemClass: a.navItemClass,
        navItemLinkClass: a.navItemLinkClass
      });
    }), E(() => {
      r(l);
    }), c({
      header: t,
      computedId: l,
      paneId: e,
      hash: o,
      isActive: i
    }), (f, I) => B((b(), p("section", {
      ref: "tab",
      id: e,
      "data-tab-id": M(l),
      "aria-hidden": !i.value,
      class: v(n.panelClass),
      role: "tabpanel",
      tabindex: "-1"
    }, [
      L(f.$slots, "default")
    ], 10, J)), [
      [U, i.value]
    ]);
  }
});
class z {
  get(c) {
    const a = localStorage.getItem(c);
    if (a === null)
      return null;
    const i = JSON.parse(a);
    return i ? new Date(i.expires) < new Date() ? (localStorage.removeItem(c), null) : i.value : null;
  }
  set(c, a, i) {
    const s = new Date().getTime(), u = new Date(s + i * 6e4);
    localStorage.setItem(c, JSON.stringify({ value: a, expires: u }));
  }
}
const w = new z(), R = ["id"], V = ["aria-controls", "aria-selected", "href", "onClick", "innerHTML"], q = /* @__PURE__ */ g({
  __name: "Tabs",
  props: {
    id: { default: void 0 },
    cacheLifetime: { default: 5 },
    options: { default: () => ({
      useUrlFragment: !0,
      defaultTabHash: void 0,
      storageKey: void 0
    }) },
    wrapperClass: { default: "tabs-component" },
    panelsWrapperClass: { default: "tabs-component-panels" },
    navClass: { default: "tabs-component-tabs" },
    navItemClass: { default: "tabs-component-tab" },
    navItemDisabledClass: { default: "is-disabled" },
    navItemActiveClass: { default: "is-active" },
    navItemInactiveClass: { default: "is-inactive" },
    navItemLinkClass: { default: "tabs-component-tab-a" },
    navItemLinkActiveClass: { default: "is-active" },
    navItemLinkInactiveClass: { default: "is-inactive" },
    navItemLinkDisabledClass: { default: "is-disabled" }
  },
  emits: ["changed", "clicked"],
  setup(n, { expose: c, emit: a }) {
    const i = n, s = j({
      activeTabHash: "",
      lastActiveTabHash: "",
      tabs: []
    });
    h(A, s), h(x, (t) => {
      s.tabs.push(t);
    }), h(k, (t, l) => {
      const e = s.tabs.findIndex((o) => o.computedId === t);
      l.isActive = s.tabs[e].isActive, s.tabs[e] = l;
    }), h(y, (t) => {
      const l = s.tabs.findIndex((e) => e.computedId === t);
      s.tabs.splice(l, 1);
    });
    const u = D(
      () => {
        let t;
        return i.options.storageKey && (t = i.options.storageKey), !t && i.id && (t = `vue-tabs-component.${i.id}.cache.${window.location.host}${window.location.pathname}`), t || (t = `vue-tabs-component.cache.${window.location.host}${window.location.pathname}`), t;
      }
    ), d = (t, l) => {
      l && !i.options.useUrlFragment && l.preventDefault();
      const e = r(t);
      if (!!e) {
        if (l && e.isDisabled) {
          l.preventDefault();
          return;
        }
        if (s.lastActiveTabHash === e.hash) {
          a("clicked", { tab: e });
          return;
        }
        s.tabs.forEach((o) => {
          o.isActive = o.hash === e.hash;
        }), a("changed", { tab: e }), s.lastActiveTabHash = s.activeTabHash = e.hash, !(i.cacheLifetime <= 0) && w.set(u.value, e.hash, i.cacheLifetime);
      }
    }, r = (t) => s.tabs.find((l) => l.hash === t);
    return F(() => {
      if (!!s.tabs.length) {
        if (window.addEventListener("hashchange", () => d(window.location.hash)), r(window.location.hash)) {
          d(window.location.hash);
          return;
        }
        if (i.cacheLifetime > 0) {
          const t = w.get(u.value);
          if (t !== null && r(t)) {
            d(t);
            return;
          }
        }
        if (i.options.defaultTabHash && r("#" + i.options.defaultTabHash)) {
          d("#" + i.options.defaultTabHash);
          return;
        }
        d(s.tabs[0].hash);
      }
    }), c({
      ...N(s),
      selectTab: d,
      findTab: r
    }), (t, l) => (b(), p("div", {
      class: v(n.wrapperClass),
      id: n.id
    }, [
      C("ul", {
        role: "tablist",
        class: v(n.navClass)
      }, [
        (b(!0), p(O, null, P(s.tabs, (e, o) => {
          var f, I;
          return b(), p("li", {
            key: o,
            class: v([
              (f = e.navItemClass) != null ? f : n.navItemClass,
              e.isDisabled ? n.navItemDisabledClass : "",
              e.isActive ? n.navItemActiveClass : e.isDisabled ? "" : n.navItemInactiveClass
            ]),
            role: "presentation"
          }, [
            C("a", {
              role: "tab",
              class: v([
                (I = e.navItemLinkClass) != null ? I : n.navItemLinkClass,
                e.isDisabled ? n.navItemLinkDisabledClass : "",
                e.isActive ? n.navItemLinkActiveClass : e.isDisabled ? "" : n.navItemLinkInactiveClass
              ]),
              "aria-controls": e.paneId,
              "aria-selected": e.isActive,
              href: e.hash,
              onClick: (S) => d(e.hash, S),
              innerHTML: e.header,
              tabindex: "0"
            }, null, 10, V)
          ], 2);
        }), 128))
      ], 2),
      C("div", {
        class: v(n.panelsWrapperClass)
      }, [
        L(t.$slots, "default")
      ], 2)
    ], 10, R));
  }
}), Q = {
  install(n) {
    n.component("tab", W), n.component("tabs", q);
  }
};
export {
  W as Tab,
  q as Tabs,
  Q as default
};
