import axios from 'axios';
import { toast } from 'vue3-toastify';
import 'vue3-toastify/dist/index.css';
var baseUrl = window.location.origin

const api = axios.create({
  baseURL: baseUrl,  // Replace with your Laravel API base URL
  timeout: 10000,  // Optional: Set a timeout for requests (in ms)
});

// Add a request interceptor (optional)
api.interceptors.request.use(
  (config) => {
    const token = localStorage.getItem('accessToken');
    if (token) {
      config.headers['Authorization'] = `Bearer ${token}`;
    }
    return config;
  },
  (error) => {
    return Promise.reject(error);
  }
);

// Add a response interceptor
api.interceptors.response.use(
  (response) => response,  // Return response if successful
  (error) => {
    // Handle errors globally
    if (error.response) {
      if (error.response.status === 401) {
                localStorage.removeItem('accessToken')
                toast.error('Your session has expired.', {
                theme: 'colored',
                limit: 1,
                autoClose: 3000,
                position: toast.POSITION.TOP_RIGHT,
        })
        setTimeout(() => {
          window.location.href = "/";
        }, 4000);
      }
    }
    return Promise.reject(error);
  }
);

export default api;