// import Vue from 'vue'
import Vuex from 'vuex'

// Vue.use(Vuex)

export default new Vuex.Store({
    state: {
        token: localStorage.getItem('accessToken') || null,
    },
    getters: {
       loggedIn(){
          return state.token !== null
        }
    },
    mutations: {
        setToken(state, token) {
            state.token = token;
        },
       
    },
    actions: {
        login(context,credential) {
            return new Promise((resolve, reject) => {
            axios.post(`/api/Login?log_in_id=${credential.identity}&password=${credential.password}`).then(res => {
                if (res.data.status == true) {
                  localStorage.setItem('accessToken', res.data.body.access_token);
                  context.commit('setToken', res.data.body.access_token);
                   localStorage.setItem('username', res.data.name);
                   localStorage.setItem('date', res.data.date);
                   localStorage.setItem('staffId', res.data.id);
                  resolve(res)
                  } else {
                      message.value = res.data.messages
                     reject(error)
                  }
            }).catch(error => {
                console.log(error);
            })
        })
        },
    },
    getters: {
        token: (state) => state.token,
    
    }
})