import { createRouter, createWebHistory} from "vue-router"
import '/resources/js/bootstrap.js';
import invoiceIndex from '../components/stocklist/stocklist.vue'
import notFound from '../components/layout/NotFound.vue'
import register from '../components/stocklist/register_stock.vue'
import login from '../components/stocklist/login.vue'
import locationInfo from '../components/stocklist/location.vue'

import dischageList from '../components/stocklist/dischage_list.vue'



import '/resources/js/bootstrap.js';

import setting from '../components/stocklist/banklist.vue'
import exchageRatePage from '../components/stocklist/Exchange_rate.vue'
import cityPage from '../components/stocklist/city.vue'
import yardPage from '../components/stocklist/yard.vue'
import marketPage from '../components/stocklist/market.vue'
import shippingInfo from '../components/shipping/shipping_company.vue'
import freightsettingInfo from '../components/stocklist/freight_setting.vue';
import carfreightPage from '../components/stocklist/car_freight_setting.vue';

import viewdetail from '../components/stocklist/viewdetail.vue'
import modify from '../components/stocklist/modify.vue'
import carInfo from '../components/car_info/car_makes.vue'
import carModelInfo from '../components/car_info/car_model.vue'
import carColorInfo from '../components/car_info/car_color.vue'
import final_destinationPage from '../components/stocklist/final_destination_list.vue'
import sellcommissionInfo from '../components/sell_commission/sell_commission.vue'

import invoice from '../components/invoice/index.vue'
import shipment from '../components/shipment/shipment.vue'
import shipment_detail  from '../components/shipment/shipping_view.vue'


import customersInfo from '../components/customers/customer.vue'
import customerscreate from '../components/customers/create.vue'
import customeredit from '../components/customers/edit.vue'
import customerdetialInfo from '../components/customers/customer_detial.vue'
import users from '../components/users/index.vue'
import create from '../components/users/create.vue'
import edit from '../components/users/edit.vue'
import profile from '../components/users/profile.vue'
import accounting from '../components/accounting/index.vue'

import income from '../components/income/index.vue'
import expense from '../components/expense/index.vue'


const routes =[{
    name: 'login',
    path:'/',
    component:login
},
 {
    path:`/register/:id`,
    component :register,
    props: true
},
{
    name:'Stock List',
    path:'/index',
    component :invoiceIndex
},
{
    path:'/location',
    component :locationInfo
},
{
    path:'/banklist',
    component:setting
},{
   path:'/modify/:id',
   component : modify,
   props: true
},
{
    path:`/viewdetail/:stockid`,
    component :viewdetail,
    props: true
},
{
    path:'/Exchange_rate',
    component:exchageRatePage
},
{
    path:'/city_list',
    component:cityPage
},
{
    path:'/yard_list',
    component:yardPage
},
{
    path:'/market_stock',
    component:marketPage
},

{
    path:'/shipping/shipping_company_list',
    component:shippingInfo
},
{
    path:'/freight_setting',
    component:freightsettingInfo
},
{
    path:'/car_freight_setting',
    component :carfreightPage
},
{
    path:'/car_info',
    component :carInfo
},
{
    path:'/car_info/car_models',
    component :carModelInfo
},
{
    path:'/car_info/car_colors',
    component :carColorInfo
},
{
    path:'/final_destination_list',
    component :final_destinationPage
},
{
    path:'/sell_commission',
    component :sellcommissionInfo
},
{
    path:'/customers',
    component :customersInfo
},
{
    path:'/customers/create',
    component :customerscreate
},
{
    path:'/customers/edit/:cusid',
    component :customeredit,
    props: true
},
{
    path:'/customer_detial/:cusid',
    component :customerdetialInfo,
    props: true
},
{
    path:'/:pathMatch(.*)*',
    component :notFound
},
{
    path:'/discharge',
    component :dischageList
},
{
    path:'/invoice',
    component :invoice
},
{
    path:'/users',
    component :users
},
{
    path:'/users/create',
    component :create
},
{
    path:'/users/edit/:staffid',
    component :edit,
    props: true
},
{
    path:'/users/profile/:staffid',
    component :profile,
    props: true
},{
    path:'/shipment',
    component :shipment
},
{

    path:'/shipment_detail/:shipment_id/:invoice_number/:freight',
    component :shipment_detail,
    props: true
},
{
    path:'/income',
    component :income,
},{
    path:'/expense',
    component : expense
},{
    path:'/accounting',
    component :accounting,
},
]

const router = createRouter({
    history : createWebHistory(),
    routes
})

export default router
