<?php

use App\Http\Controllers\Accounting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Stock_list;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\banklist;
use App\Http\Controllers\discharge_list;
use App\Http\Controllers\Car_info;
use App\Http\Controllers\City;
use App\Http\Controllers\Exchange_rate;
use App\Http\Controllers\Sell_commission;
use App\Http\Controllers\Shipping_company;

use App\Http\Controllers\Invoice;
use App\Http\Controllers\Shipping;
use App\Http\Controllers\Income;
use App\Http\Controllers\Expense;
use App\Http\Middleware\CheckIdleTimeout;

use App\Http\Controllers\Customer;
use App\Http\Controllers\Users;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});
Route::post('/Login',[AuthController::class,'StaffLogin']);

Route::get('/login',function(){
    return response()->json(['message' => 'Unauthorised'],401);
})->name('login');

Route::middleware(['auth:api', 'check.token.expiry'])->get('/some-endpoint', function () {
    return response()->json(['message' => 'active'],200);
});
Route::middleware('auth:api')->group(function(){
    Route::get('/CheckLogin',[AuthController::class,'CheckLogin']);
    Route::get('/GetColor',[Stock_list::class,'getCarColors']);
    Route::post('/get_stock_list',[Stock_list::class,'index']);
    Route::get('/GetTotal', [Stock_list::class,'GetTotal']);
    Route::get('/GetMake', [Stock_list::class,'GetMake']);
    Route::get('/GetCarsStastus', [Stock_list::class,'get_car_status']);
    Route::get('/getPurchaser', [Stock_list::class,'getPurchaser']);
    Route::get('/GetCarLocation', [Stock_list::class,'get_car_location_country']);
    Route::get('/GetCarModelNew', [Stock_list::class,'get_car_model']);
    Route::get('/GetCity', [Stock_list::class,'get_car_city']);
    Route::get('/GetCustomerInfo', [Stock_list::class,'get_customer_info']);
    Route::get('/GetCarYard',[Stock_list::class,'get_car_yard']);
    Route::get('/GetSale',[Stock_list::class,'select_sales']);
    Route::get('/GetMarket',[Stock_list::class,'get_car_market_country']);
    Route::get('/GetColor',[Stock_list::class,'getCarColors']);
    Route::get('/ChangeCarModel',[Stock_list::class,'ChangeCarModel']);
    Route::get('/UpdateRecycleOk',[Stock_list::class,'UpdateRecycleOk']);
    Route::get('/GetStockType',[Stock_list::class,'GetStockType']);
    Route::get('/GetMarketCountry',[Stock_list::class,'GetMarketCountry']);
    Route::get('/AddCity',[Stock_list::class,'AddCity']);
    Route::get('/GetCityWithLocation',[Stock_list::class,'get_city_with_location']);
    Route::get('/Get_Yard',[Stock_list::class,'Get_Yard']);
    Route::get('/AddYard',[Stock_list::class,'Add_Yard']);
    Route::get('/AddMake',[Stock_list::class,'Add_Make']);
    Route::get('/Get_Model',[Stock_list::class,'Get_Model']);
    Route::get('/AddMdoel',[Stock_list::class,'Add_Mdoel']);
    Route::get('/AddColor',[Stock_list::class,'Add_Color']);
    Route::get('/GetDischarge',[Stock_list::class,'Get_Discharge']);
    Route::get('/CheckChassis',[Stock_list::class,'Check_Chassis']);
    Route::post('/SaveData',[Stock_list::class,'SaveData']);
    Route::post('/uploadFile',[Stock_list::class,'uploadFile']);
    Route::get('/InsertDraft',[Stock_list::class,'insert_draft']);
    Route::get('/GetAuctionImage',[Stock_list::class,'select_image_upload']);
    Route::post('/AddToYard',[Stock_list::class,'add_toyard_two']);
    Route::post('/DeleteImage',[Stock_list::class,'deleted_image']);
    Route::post('/DeleteImageChecked',[Stock_list::class,'deleted_image_checked']);
    Route::post('/HideImageChecked',[Stock_list::class,'hide_image_checked']);
    Route::post('/CheckedPrimary',[Stock_list::class,'set_primary_image']);
    Route::post('/draggedImage',[Stock_list::class,'dragged_image']);
    Route::post('/UploadFileYard',[Stock_list::class,'UploadFileYard']);
    Route::get('/GetYardImage',[Stock_list::class,'select_yard_image']);
    Route::get('/GetYardTwoImage',[Stock_list::class,'select_image_upload_yard_two']);
    Route::post('/UploadFileYardTwo',[Stock_list::class,'upload_images_car_exec_yard_two']);
    Route::post('/CheckedPrimaryYard',[Stock_list::class,'set_primary_image_yard']);
    Route::post('/CheckedPrimaryYardTwo',[Stock_list::class,'set_primary_image_yard_two']);
    Route::get('/get_location_list',[Stock_list::class,'location_list']);
    Route::get('/get_contry_list', [Stock_list::class,'get_all_country']);
    Route::get('/save_location',[Stock_list::class,'save_location_info']);
    Route::get('/delete_location',[Stock_list::class,'delete_location']);
    Route::get('/getlocation',[Stock_list::class,'get_location_combo']);

    Route::get('/banklist',[banklist::class,'index']);
    Route::get('/insert_bank_accounting',[banklist::class,'insert_bank_accounting']);
    Route::get('/update_bank_accounting',[banklist::class,'update_bank_accounting']);
    Route::get('/DeletebankAccounting',[banklist::class,'delete_bank_accounting']);
    Route::post('/SaveDataSort',[banklist::class,'save_data_sort']);

    Route::get('/GetGroupType',[Stock_list::class,'get_group_type']);
    Route::get('/GetStockListData',[Stock_list::class,'get_stock_list_detail']);
    Route::get('/GetReserveInfo',[Stock_list::class,'select_reserve_info']);
    Route::get('/GetPurposeHistory',[Stock_list::class,'get_purpose_history']);
    Route::get('/GetStatusHistory',[Stock_list::class,'get_car_status_history']);
    Route::get('/GetInstructionHistory',[Stock_list::class,'get_instruction_history']);
    Route::get('/GetInstructionHistory',[Stock_list::class,'get_instruction_history']);
    Route::get('/GetLocationHistory',[Stock_list::class,'get_location_history']);
    Route::get('/GetInfoFromjp',[Stock_list::class,'GetInfoFromjp']);
    Route::get('/GetRecycleHistory',[Stock_list::class,'get_car_recycleok_history']);
    Route::get('/GetShowonwebsiteHistory',[Stock_list::class,'get_showonwebsite_history']);
    Route::get('/GetExpenseInfo',[Stock_list::class,'get_expense_info']);
    Route::get('/getOtherfeeinfo',[Stock_list::class,'get_other_fee_info']);
    Route::get('/getRefundDetailinfo',[Stock_list::class,'get_refund_info_detail']);
    Route::get('/DetailSoldPrice',[Stock_list::class,'detail_sold_price']);
    Route::get('/DetailSellingPrice',[Stock_list::class,'get_selling_price_detail']);
    Route::get('/DetailAuctionIncomeDetail',[Stock_list::class,'get_auction_income_detail']);
    Route::get('/GetIncomeDetail',[Stock_list::class,'get_income_detail']);
    Route::post('/AddDhl',[Stock_list::class,'add_dhl']);
    Route::post('/deleteFileCarDocument',[Stock_list::class,'delete_car_document_file']);
    Route::post('/deleteFileCarType',[Stock_list::class,'delete_car_doc']);
   
    Route::get('/FinalDestinationInfo',[Stock_list::class,'get_final_destination']);

    Route::get('/ExchangeRate',[Exchange_rate::class,'index']);
    Route::get('/InsertExchageRate',[Exchange_rate::class,'insert_exchage_rate']);
    Route::get('/UpdateExchageRate',[Exchange_rate::class,'update_exchage_rate']);
    Route::get('/DeleteExchageRate',[Exchange_rate::class,'delete_exchage_rate']);
    Route::get('/get_city_list',[City::class,'city_list']);
    Route::get('/insert_city',[City::class,'save_city']);
    Route::get('/edit_city_data',[City::class,'edit_city']);
    Route::get('/getcountry',[City::class,'get_country_combo']);
    Route::get('/delete_city',[City::class,'delete_city']);
    Route::get('/get_yard_data',[Stock_list::class,'yard_list']);
    Route::get('/get_city',[Stock_list::class,'get_city_combo']);
    Route::get('/InsertYard',[Stock_list::class,'insert_yard']);
    Route::get('/EditYard',[Stock_list::class,'edit_yard']);
    Route::get('/DeleteYard',[Stock_list::class,'delete_yard']);
    Route::get('/get_market_data',[Stock_list::class,'market_list']);
    Route::get('/get_all_country',[Stock_list::class,'country_all']);
    Route::get('/insert_market',[Stock_list::class,'save_market']);
    Route::get('/insert_new_country',[Stock_list::class,'insert_new_country']);
    Route::get('/edit_market',[Stock_list::class,'edit_market']);
    Route::get('/DeleteMarket',[Stock_list::class,'delete_market']);
    Route::get('/Get_Shipping_Com',[Shipping_company::class,'shipping_com_list']);
    Route::get('/Insert_shipping_com',[Shipping_company::class,'insert_shipping_compny']);
    Route::get('/Update_shipping_com',[Shipping_company::class,'update_shipping_company']);
    Route::get('/Delete_shipping_com',[Shipping_company::class,'delete_shipping_company']);
    Route::get('/Get_Cbm_list',[Stock_list::class,'get_cbm_list']);
    Route::get('/Get_All_Country',[Stock_list::class,'get_all_country_list']);
    Route::get('/Insert_Cbm',[Stock_list::class,'insert_cbm']);
    Route::get('/Modify_Cbm',[Stock_list::class,'cbm_modify']);
    Route::get('/Delete_Cbm',[Stock_list::class,'delete_cbm']);

    Route::get('/Get_car_model_size',[Stock_list::class,'get_car_model_size_list']);
    Route::get('/Get_all_car_model',[Stock_list::class,'get_car_model_list']);
    Route::get('/Insert_Car_Model_size',[Stock_list::class,'insert_car_model_size']);
    Route::get('/CarModelSizeModify',[Stock_list::class,'car_model_size_modify']);
    Route::get('/DeleteCarModelSize',[Stock_list::class,'delete_car_model_size']);
    Route::get('/GetCarMake',[Car_info::class,'get_car_make_list']);
    Route::get('/InsertCarMake',[Car_info::class,'insert_car_make']);
    Route::get('/ModifyCarMake',[Car_info::class,'modify_car_make']);
    Route::get('/DeleteCarMake',[Car_info::class,'delete_car_make']);
    Route::get('/GetCarModel',[Car_info::class,'get_car_model_list']);
    Route::get('/GetAllCarMake',[Car_info::class,'get_all_car_make']);
    Route::get('/SaveCarModel',[Car_info::class,'save_car_model']);
    Route::get('/ModifyCarModel',[Car_info::class,'modify_car_model']);
    Route::get('/DeleteCarModel',[Car_info::class,'delete_car_model']);
    Route::get('/GetCarColor',[Car_info::class,'get_car_color_list']);
    Route::get('/SaveCarColor',[Car_info::class,'save_car_color']);
    Route::get('/ModifyCarColor',[Car_info::class,'modify_car_color']);
    Route::get('/DeleteCarColor',[Car_info::class,'delete_car_color']);
    Route::get('/GetFinalDes',[Stock_list::class,'get_final_des_list']);
    Route::get('/InsertFinalDes',[Stock_list::class,'insert_final_des_stock']);
    Route::get('/UpdateFinalDes',[Stock_list::class,'update_final_des_stock']);
    Route::get('/DeleteFinalDes',[Stock_list::class,'delete_final_des_stock']);

    Route::get('/GetDataOfStocklist',[Sell_commission::class,'get_stock_list_cars']);
    Route::get('/GetTotalCars',[Sell_commission::class,'GetTotalCars']);
    Route::get('/GetAllMake',[Sell_commission::class,'get_car_mark']);
    Route::get('/GetAllModel',[Sell_commission::class,'get_car_model']);
    Route::get('/GetAllCarStatus',[Sell_commission::class,'get_car_status']);
    Route::get('/GetCustomer',[Sell_commission::class,'get_customer_info']);
    Route::get('/GetSaleList',[Sell_commission::class,'select_sale']);
    Route::get('/UpdateSellCommission',[Sell_commission::class,'Update_sell_commission']);
    Route::get('/GetStocklistExportExcel',[Sell_commission::class,'get_stock_list_export_excel']);

    Route::post('/UploadFileDocument',[Stock_list::class,'UploadFileDocument']);
    Route::get('/StockListModify',[Stock_list::class,'stock_list_modify']);
    Route::get('/GetFileUpload', [Stock_list::class,'get_file_upload_doc']);
    Route::get('/GetConsigneeData',[Stock_list::class,'get_consignee_for_car']);
    Route::get('/check_status',[Stock_list::class,'check_status']);
    Route::post('/delete_car',[Stock_list::class,'delete_car_from_erp']);
    Route::get('/hide_from_web_mul',[Stock_list::class,'hide_from_web_mul']);
    Route::get('/save_multi_instrction', [Stock_list::class,'save_multi_instrction']);
    Route::get('/GetLacationData', [Stock_list::class,'GetLacationYardData']);
    Route::get('/update_car_location', [Stock_list::class,'update_car_location']);
    Route::get('/check_status_all',[Stock_list::class,'check_status_all']);
    Route::get('/add_shipok',[Stock_list::class, 'add_shipok']);
    Route::get('/cancel_shipok',[Stock_list::class, 'cancel_shipok']);
    Route::get('/GetCustomerInfoStock',[Stock_list::class, 'GetCustomerInfo']);
    Route::get('/select_car_reserve',[Stock_list::class, 'select_car_reserve']);
    Route::post('/save_reserve_car',[Stock_list::class, 'save_reserve_car']);
    Route::get('/check_status_reserve',[Stock_list::class,'check_status_reserve']);


    Route::get('/save_discharge',[discharge_list::class,'discharge_list_info']);
    Route::get('/get_discharge_info',[discharge_list::class,'discharge_info']);
    Route::get('/update_save_discharge',[discharge_list::class,'update_discharge']);
    Route::get('/delete_discharge_list',[discharge_list::class,'delete_discharge']);
    Route::get('/get_discharge_list',[discharge_list::class,'discharge_search_list']);
    Route::get('/get_discharge_search',[discharge_list::class,'search_discharge_info']);

    Route::get('/cancel_reserve',[Stock_list::class, 'cancel_reserve']); 
    Route::get('/export_excel_car_allocate',[Stock_list::class, 'export_excel_car_allocate']);
    Route::get('/get_stock_sold_out',[Stock_list::class, 'get_stock_sold_out']);
    Route::get('/export_transport_excel',[Stock_list::class, 'export_transport_excel']);
    Route::get('/get_stock_excel',[Stock_list::class, 'get_stock_excel']);
    Route::get('/get_stock_excel_forwarding',[Stock_list::class, 'get_stock_excel_forwarding']);
    Route::get('/get_for_export_selectbox',[Stock_list::class, 'get_for_export_selectbox']);
    Route::get('/get_stock_staff_excel',[Stock_list::class, 'get_stock_staff_excel']);

    Route::get('/batchupdate',[Stock_list::class, 'checkBatchProgress']);
    Route::get('/BatchForwardingProgress',[Stock_list::class, 'checkForwardingProgress']);
    Route::get('/BatchTransportProgress',[Stock_list::class, 'checkTransportProgress']);
    Route::get('/BatchSoldOutProgress',[Stock_list::class, 'checkSoldOutProgress']);
    Route::get('/BatchAllocateProgress',[Stock_list::class, 'checkAllocateProgress']);
    Route::get('/BatchStaffProgress',[Stock_list::class, 'checkStaffProgress']);
    Route::get('/downloadExcel',[Stock_list::class, 'downloadExcel']);

    Route::get('/get_data_invoice',[Invoice::class,'get_data_invoice']);
    Route::get('/get_history_invoice', [Invoice::class, 'get_history_invoice']);

    Route::get('/deletes_invoice',[Invoice::class, 'deletes_invoice']);
    Route::get('/update_invoice_status',[Invoice::class, 'update_invoice_status']);
    Route::get('/download_excel_invoice_new',[Invoice::class, 'download_excel_invoice_new']);
    Route::get('/download_excel_invoice',[Invoice::class, 'download_excel_invoice']);
    Route::get('/check_download_pdf_preview',[Invoice::class, 'check_download_pdf_preview']);
    Route::get('/download_excel_invoice_items',[Invoice::class, 'download_excel_invoice_items']);
    Route::get('/check_download_pdf_invoice_item',[Invoice::class, 'check_download_pdf_invoice_item']);
    Route::get('/insert_invoice_items',[Invoice::class, 'insert_invoice_items']);
    Route::get('/proforma_invoices', [Stock_list::class, 'proforma_invoices']);
    Route::post('/submit_add_proforma', [Stock_list::class, 'submit_add_proforma']);
    Route::post('/proforma_invoice_download', [Invoice::class, 'proforma_invoice_download']);
    Route::post('/GetShipmentData', [Shipping::class, 'index']);
    Route::post('/add_ship_company', [Shipping::class, 'add_ship_company']);
    Route::post('/add_port_loading', [Shipping::class, 'add_port_loading']);
    Route::post('/add_discharge', [Shipping::class, 'add_discharge']);
    Route::post('/add_shipment', [Shipping::class, 'add_shipment']);
    Route::post('/update_shipping_step', [Shipping::class, 'update_shipping_step']);
    Route::post('/DeleteInvoice', [Shipping::class, 'delete_invoice_by_shipping_invoice']);
    Route::post('/AddNoteVessel', [Shipping::class, 'add_note_to_vessel']);
    Route::post('/UpdateBookingSpace', [Shipping::class, 'update_booking_spece']);
    Route::post('/UpdateInvoiceSI', [Shipping::class, 'update_invoice_sl']);
    Route::post('/UpdateBlInvoice', [Shipping::class, 'update_get_bl']);
    Route::post('/AddDhlVessel', [Shipping::class, 'add_dhl_vessel']);
    Route::post('/GetDdlInfor', [Shipping::class, 'get_dhl_info']);
    Route::post('/UploadFileStock',[Shipping::class,'UploadFileStock']);
    Route::get('/GetShipmentId',[Shipping::class,'get_shipment_id']);
    Route::post('/AddBookedList',[Shipping::class,'add_car_to_booked']);
    Route::get('/loadCarDetails',[Shipping::class,'get_car_in_stock_list_by_shipment_id']);
    Route::post('/UploadFileDocumentFile',[Stock_list::class,'upload_file_execute']);
    Route::get('/GetFileUploadDoc', [Stock_list::class,'get_file_upload_ship']);
    Route::post('/UploadFileDocumentCar',[Shipping::class,'UploadFileDocumentCar']);
    Route::post('/GetPictureButton',[Shipping::class,'upload_images']);
    Route::post('/UploadFileAllDocumentFile',[Shipping::class,'upload_file_all_doc_cars_execute']);
    Route::post('/UploadFileAllEC',[Shipping::class,'upload_file_all_ec_cars']);


    Route::get('/GetCustomerlist',[Customer::class,'get_customer_list']);
    Route::get('/GetCountryCombo',[Customer::class,'get_country_list_combo']);
    Route::post('/InSertCustomer',[Customer::class,'insert_customers']);
    Route::get('/GetCustomerType',[Customer::class,'get_customers_type']);
    Route::get('/GetCountryList',[Customer::class,'get_country_list']);
    Route::get('/GetSales',[Customer::class,'get_sales']);
    Route::post('/EditCustomers',[Customer::class,'edit_customer']);
    Route::get('/GetCustomnerListEdit',[Customer::class,'get_customer_list_edit']);
    Route::get('/GetCustomnerDetialList',[Customer::class,'get_customer_profile']);
    Route::get('/InsertConsignee',[Customer::class,'insert_consignee']);
    Route::get('/GetConsigneeList',[Customer::class,'get_customer_consignee']);
    Route::get('/ModifyConsignee',[Customer::class,'modify_consignee']);
    Route::get('/DeleteConsignee',[Customer::class,'delete_consignee']);
    Route::get('/InsertRemark',[Customer::class,'insert_customer_remark']);
    Route::get('/GetRemark',[Customer::class,'get_remark']);
    Route::get('/GetDataStockList',[Customer::class,'select_data_stocklist']);
    Route::get('/GetModelList',[Customer::class,'select_model_list']);
    Route::get('/GetTotalCarStockList',[Customer::class,'select_total_stocklist']);
    Route::get('/GetAllocateHistory',[Customer::class,'select_allocate_history']);
    Route::get('/DeleteCustomers',[Customer::class,'delete_customers']);
    Route::get('/DeleteCusDetail',[Customer::class,'delete_customer_detail']);
    Route::get('/GetStaffList',[Users::class,'get_staff_list']);
    Route::get('/GetCountryLists',[Users::class,'select_country_list']);
    Route::get('/GetMemberGroup',[Users::class,'get_member_group']);
    Route::post('/InSertUser',[Users::class,'insert_user']);
    Route::get('/GetCountryComboList',[Users::class,'get_country_combo_list']);
    Route::get('/GetStaffUpdate',[Users::class,'get_staff_update']);
    Route::get('/GetGroup',[Users::class,'get_group']);
    Route::get('/CountryList',[Users::class,'country_list']);
    Route::post('/EditUsers',[Users::class,'edit_users']);
    Route::get('/DeleteUsers',[Users::class,'delete_user']);
    Route::get('/GetuserInfo',[Users::class,'get_user_info']);
    Route::get('/GetViewHistoryLogin',[Users::class,'get_history_login']);
    Route::get('/GetBankList',[Accounting::class,'select_bank_accounting']);
    Route::get('/GetAccountingList',[Accounting::class,'get_acc_list']);
    Route::get('/InsertDepositExpense',[Accounting::class,'insert_deposit_expense']);
    Route::get('/InsertBankAccounting',[Accounting::class,'insert_bank_accounting']);
    Route::get('/ModifyDepositExpense',[Accounting::class,'modify_deposit_expense']);
    Route::get('/DeleteDepositExpense',[Accounting::class,'delete_deposit_expense']);
    Route::post('/InsertDepositInCome',[Accounting::class,'insert_deposit_income']);
    Route::get('/ModifyDepositIncome',[Accounting::class,'modify_deposit_income']);
    Route::get('/DownloadExcelAccount',[Accounting::class,'excel_export_account']);


    Route::get('/DownloadAuctionZip',[Stock_list::class,'download_auction_zip']);
    Route::get('/DownloadYardZip',[Stock_list::class,'download_yard_zip']);
    Route::get('/DownloadYardTwoZip',[Stock_list::class,'download_yard_two_zip']);
  
    Route::get('/SubmitDownloadData',[Shipping::class,'download_all_doc']);
    Route::get('/SubmitDownloadDataAllEC',[Shipping::class,'download_all_ec']);
    Route::get('/SubmitDownloadDataAllBL',[Shipping::class,'download_all_bl']);
    Route::get('/UpdateComfirm',[Shipping::class,'update_comfirm']);
    Route::get('/AddDocDate',[Shipping::class,'add_docs_date']);
    Route::get('/DeleteSendDoc',[Shipping::class,'delete_sent_doc']);
    Route::get('/AddBlDate',[Shipping::class,'add_bl_date']);
    Route::get('/DeleteSendBL',[Shipping::class,'deletebl']);
    Route::post('/AddDHLTOStock',[Shipping::class,'edit_dhl_info']);
    Route::get('/Unbooked',[Shipping::class,'Unbooked']);
    Route::get('/GetDHLInfo',[Shipping::class,'get_dhl_info']);
    Route::get('/CifInvoice',[Shipping::class,'cif_invoice']); 
    Route::get('/GetShipmentData',[Shipping::class,'get_data_shipment']);
    Route::post('/SubmitDataSort',[Shipping::class,'sumbit_data_sort']);
    Route::post('/ViewPdfDoc',[Shipping::class,'get_pdf_view']);
    Route::post('/ViewPdfEC',[Shipping::class,'get_pdf_view_ec']);
    Route::get('/GetCarList',[Shipping::class,'get_car_list']);
    Route::get('/GetBookListCar',[Shipping::class,'GetBookListCar']);
    Route::post('/AddShipInvoiceToCar',[Shipping::class,'AddShipInvoiceToCar']);
    Route::get('/DeleteInvoiceByStock',[Shipping::class,'delete_invoice_by_stock_id']);
    Route::get('/GetIncomeData',[Income::class,'loadDataIncome']);
    Route::get('/GetDepositeIncome',[Income::class,'income_destribute']);
    Route::get('/GetCustomerSearch',[Income::class,'get_customer_search']);
    Route::get('/ExecDistribute',[Income::class,'exec_distribute']);
    Route::get('/HistoryDepositDetail',[Income::class,'history_deposit_detail']);
    Route::get('/HistDetailCar',[Income::class,'get_detail_car']);
    Route::get('/GetExcelExportHistory',[Income::class,'get_excel_export_history']);
    Route::post('/DeleteAllocateFromCar',[Income::class,'delete_allocate']);
    Route::get('/GetIncomeInfo',[Income::class,'GetIncomeInfo']);
    Route::get('/CustomerAllocate',[Income::class,'customer_allocate']);
    Route::post('/DeleteAllocateCustomer',[Income::class,'delete_allocate_customer']);
    Route::get('/CarAllocate',[Income::class,'car_allocate']);
    Route::get('/SearchCarAllocate',[Income::class,'get_chassis_search']);
    Route::get('/CarAllocateExcecute',[Income::class,'car_allocate_excecute']);
    Route::get('/ReturnMoney',[Income::class,'return_money_back']);
    Route::get('/GetAllocateWithChassisData',[Income::class,'customer_allocate_with_chassis']);
    Route::get('/CheckChassis',[Income::class,'check_chassis']);
    Route::get('/SaveWithChassiss',[Income::class,'save_with_chassis']);
    Route::get('/withChassisHis',[Income::class,'with_chassis_history_detail']);
    Route::get('/ReturnWithChassis',[Income::class,'return_money_back_with_cha']);
    Route::get('/ReturnWithOutChassis',[Income::class,'return_money_back_without_cha']);
    Route::get('/ReturnMoneyAuction',[Income::class,'return_auction_money_back']);
    Route::get('/ReturnFurikae',[Income::class,'return_money_back_with_furikae']);
    Route::get('/GetEnpenseData',[Expense::class,'index']);
    Route::post('/DistributeExpensesExec',[Expense::class,'distribute_expenses_exec']);
    Route::get('/DeleteExpensesItem',[Expense::class,'delete_expenses_item']);
    Route::get('/ExportExcelDeposit',[Expense::class,'exportdeposit']);
    Route::get('/ExportExcelDepositHistory',[Expense::class,'exportdeposithistory']);
    Route::get('/MainDetailHistory',[Expense::class,'main_detail_history']);
    Route::get('/getHistoryDetail',[Expense::class,'history_view']);
    Route::get('/GetExpenseSecondTap',[Expense::class,'GetExpenseSecondTap']);
    Route::get('/SearchCarChassis',[Expense::class,'search_chassis_car']);
    Route::post('/AllocateExpense',[Expense::class,'Allocate_car_expense']);
    Route::post('/DeleteOtherFee',[Expense::class,'delete_other_fee']);
    Route::post('/DeleteRefund',[Expense::class,'delete_other_refund']);
    Route::post('/DeleteIncome',[Expense::class,'delete_ex_income']);
    Route::get('/DetailExpenese',[Expense::class,'detail_expenese']);
    Route::get('/DeleteIncomFromPayment',[Expense::class,'delete_income_from_payment']);
    Route::get('/DeleteCarExpense',[Expense::class,'delete_car_expense']);
    Route::post('/UpdateCarExpense',[Expense::class,'update_car_expense']);
    Route::post('/UpdateOtherRefundID',[Expense::class,'update_other_refund_id']);
    Route::get('/DeleteOtherRefundID',[Expense::class,'delete_other_refund_id']);
    Route::post('/UpdateOtherFeeID',[Expense::class,'update_other_fee_id']);
    Route::post('/btnReturnWithChassis',[Expense::class,'return_expend_cha']);
    Route::get('/DeleteOtherFeeID',[Expense::class,'delete_other_fee_id']);
    Route::get('/ExportExcelExpense',[Expense::class,'export_excel_expense']);
    Route::get('/UpdateReserveCar',[Stock_list::class,'update_reserve_car']);


});


